/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.eventhub.spi;

import oracle.jdeveloper.deploy.eventhub.EventHub;

public class AbstractHandle
implements EventHub.Handle {
    private int refCount = 0;
    private final EventHub.Handle delegate;

    public AbstractHandle(EventHub.Handle delegate, boolean isDelegateEnabled) {
        this.delegate = delegate;
        if (isDelegateEnabled) {
            this.refCount = 1;
            this.handleEnabled();
        }
    }

    private void incrementRefCount() {
        ++this.refCount;
        if (this.refCount == 1) {
            this.delegate.enable();
            this.handleEnabled();
        }
    }

    private void decrementRefCount() {
        --this.refCount;
        if (this.refCount == 0) {
            this.delegate.disable();
            this.handleDisabled();
        }
    }

    @Override
    public void enable() {
        this.incrementRefCount();
    }

    @Override
    public void disable() {
        this.decrementRefCount();
    }

    @Override
    public void release() {
        this.disable();
        this.delegate.release();
    }

    protected void handleEnabled() {
    }

    protected void handleDisabled() {
    }
}

