/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.contrib.spi.providers;

import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.contrib.Contributor;
import oracle.jdeveloper.deploy.contrib.spi.HashContributorReader;
import oracle.jdeveloper.deploy.contrib.spi.HashContributorWriter;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.tk.Toolkit;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitBuilder;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public abstract class AbstractHashContributorIOProvider
extends AbstractToolkitProvider {
    public AbstractHashContributorIOProvider() {
        super(DefaultHashContributorIO.class);
    }

    @Override
    public AbstractToolkitBuilder create(ToolkitContext tkContext) {
        final Element element = tkContext.getElement();
        Class classOrIntf = tkContext.getToolkitClass();
        if (classOrIntf.isAssignableFrom(HashContributorReader.class)) {
            HashContributorReader.SpiData spi = new HashContributorReader.SpiData(tkContext.getIdeContext());
            final HashStructure hash = spi.getHashStructure();
            String type = spi.getType();
            if (hash == null) {
                return null;
            }
            final Cookie cookie = new Cookie();
            if (this.canRead(type, hash, tkContext, cookie)) {
                return new AbstractToolkitBuilder(this, tkContext){

                    @Override
                    protected Toolkit build() {
                        return new DefaultHashContributorIO(element, hash, cookie);
                    }
                };
            }
        } else if (classOrIntf.isAssignableFrom(HashContributorWriter.class)) {
            Cookie cookie;
            HashContributorWriter.SpiData spi = new HashContributorWriter.SpiData(tkContext.getIdeContext());
            final Contributor contributor = spi.getContributor();
            String type = spi.getContributorType();
            if (this.canWrite(type, contributor, tkContext, cookie = new Cookie())) {
                return new AbstractToolkitBuilder(this, tkContext){

                    @Override
                    protected Toolkit build() {
                        return new DefaultHashContributorIO(element, contributor, cookie);
                    }

                    @Override
                    public Class getTypeForNarrow() {
                        return AbstractHashContributorIOProvider.this.getTypeForNarrow();
                    }
                };
            }
        }
        return null;
    }

    public Class getTypeForNarrow() {
        return Contributor.class;
    }

    protected abstract boolean canRead(String var1, HashStructure var2, ToolkitContext var3, Cookie var4);

    protected abstract boolean canWrite(String var1, Contributor var2, ToolkitContext var3, Cookie var4);

    protected abstract Contributor read(Element var1, HashStructure var2, Cookie var3);

    protected abstract void write(Element var1, Contributor var2, HashStructure var3, Cookie var4);

    class DefaultHashContributorIO
    implements HashContributorReader,
    HashContributorWriter {
        final Element element;
        final HashStructure hash;
        final Cookie cookie;
        final Contributor contributor;

        DefaultHashContributorIO(Element element, HashStructure hash, Cookie cookie) {
            this.element = element;
            this.hash = hash;
            this.cookie = cookie;
            this.contributor = null;
        }

        DefaultHashContributorIO(Element element, Contributor contributor, Cookie cookie) {
            this.element = element;
            this.hash = null;
            this.cookie = cookie;
            this.contributor = contributor;
        }

        @Override
        public Contributor read() {
            return AbstractHashContributorIOProvider.this.read(this.element, this.hash, this.cookie);
        }

        @Override
        public void write(HashStructure hash) {
            AbstractHashContributorIOProvider.this.write(this.element, this.contributor, hash, this.cookie);
        }
    }
}

