/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.util.ArrayList;
import java.util.Collections;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableFactory;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.deploy.ToolkitFactory;
import oracle.jdeveloper.deploy.tk.ToolkitBuildException;

public class DependableFactory
implements ToolkitFactory {
    private static DependableFactory instance_ = null;

    public static synchronized DependableFactory getInstance() {
        if (instance_ == null) {
            instance_ = new DependableFactory();
        }
        return instance_;
    }

    @Deprecated
    public Dependable[] create(Element element, Element parent) {
        Context ctx = new Context();
        ctx.setElement(element);
        if (parent instanceof Project) {
            ctx.setProject((Project)parent);
        } else if (parent instanceof Workspace) {
            ctx.setWorkspace((Workspace)parent);
        }
        return this.create(element, parent, ctx);
    }

    public Dependable[] create(Element element, Element parent, Context context) {
        Parms parms = new Parms(context);
        parms.setParent(parent);
        return this.create(element, context);
    }

    public Dependable[] create(Element element, Context context) {
        ArrayList dependables = new ArrayList();
        try {
            oracle.jdeveloper.deploy.spi.DependableFactory[] factory = ToolkitFactory.Utils.narrowBuild(element, context, oracle.jdeveloper.deploy.spi.DependableFactory.class, new oracle.jdeveloper.deploy.spi.DependableFactory[0]);
            for (int i = 0; i < factory.length; ++i) {
                Dependable[] deps = factory[i].createDependables();
                Collections.addAll(dependables, deps);
            }
        }
        catch (ToolkitBuildException toolkitBuildException) {
            // empty catch block
        }
        return dependables.toArray(new Dependable[dependables.size()]);
    }

    public static class Parms
    extends DependableFactory.Params {
        static final String CONTEXT_DEPENDABLE_DEPTH = Parms.class + ".depth";

        public Parms(Context c) {
            super(c);
        }

        public static Parms getInstance(Context c) {
            return new Parms(c);
        }

        public Depth getDepth() {
            Depth d = (Depth)((Object)this.getContext().getProperty(CONTEXT_DEPENDABLE_DEPTH));
            return d == null ? Depth.SELF : d;
        }

        public void setDepth(Depth depth) {
            this.getContext().setProperty(CONTEXT_DEPENDABLE_DEPTH, (Object)depth);
        }

        public static enum Depth {
            SELF,
            CHILDREN;

        }
    }
}

