/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server.parser.sparql;

import java.util.ArrayList;
import java.util.Collection;

public class SparqlSourceDescriptor {
    private Collection<String> defaultGraphs = new ArrayList<String>();
    private Collection<String> namedGraphs = new ArrayList<String>();
    private String withGraph = null;
    private boolean defaultFromWith = false;

    public SparqlSourceDescriptor() {
    }

    public SparqlSourceDescriptor(Collection<String> collection, Collection<String> collection2) {
        this();
        this.defaultGraphs.addAll(collection);
        this.namedGraphs.addAll(collection2);
    }

    protected Object clone() throws CloneNotSupportedException {
        SparqlSourceDescriptor sparqlSourceDescriptor = new SparqlSourceDescriptor(this.defaultGraphs, this.namedGraphs);
        return sparqlSourceDescriptor;
    }

    public void addDefaultGraph(String string) {
        this.defaultGraphs.add(string);
    }

    public void addNamedGraph(String string) {
        this.namedGraphs.add(string);
    }

    public void setWithGraph(String string) {
        this.withGraph = string;
    }

    public void setDefaultFromWith(Boolean bl) {
        this.defaultFromWith = bl;
    }

    public Collection<String> getDefaultGraphs() {
        return this.defaultGraphs;
    }

    public Collection<String> getNamedGraphs() {
        return this.namedGraphs;
    }

    public String getWithGraph() {
        return this.withGraph;
    }

    public boolean getDefaultFromWith() {
        return this.defaultFromWith;
    }

    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "====== Source Desc ========\n";
        string2 = string2 + string + "Default Graphs [";
        for (String string3 : this.defaultGraphs) {
            string2 = string2 + " " + string3;
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "Named Graphs [";
        for (String string3 : this.namedGraphs) {
            string2 = string2 + " " + string3;
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "With Graph [";
        if (this.withGraph != null) {
            string2 = string2 + "<" + this.withGraph + ">";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "============================\n";
        return string2;
    }

    public String printSPARQLText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.defaultGraphs) {
            stringBuffer.append("FROM ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        for (String string : this.namedGraphs) {
            stringBuffer.append("FROM NAMED ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

