/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.LinkedList;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class ValuesRewriteOptimizer
implements SparqlQueryOptimizer {
    private static final int MAX_ITERS = 10000;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        int n;
        Node node2 = node;
        boolean bl = true;
        for (n = 0; bl && n < 10000; ++n) {
            bl = this.removeSingleValues(node2, 0);
        }
        if (n >= 10000) {
            throw new ParseException("ValuesRewriteOptimizer: entered infinite loop when optimizing query tree");
        }
        return node2;
    }

    private boolean removeSingleValues(Node node, Integer n) throws ParseException {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(node);
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        linkedList2.offer(n);
        boolean bl = false;
        while (!linkedList.isEmpty() && !bl) {
            SimpleNode simpleNode = (SimpleNode)linkedList.remove();
            Integer n2 = (Integer)linkedList2.remove();
            if (simpleNode.id == 24) {
                bl = true;
                SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
                if (simpleNode2.id != 25) {
                    throw new ParseException("ValuesRewriteOptimizer: unexpected node type found under JJTInlineData");
                }
                this.removeValues(simpleNode.jjtGetParent(), n2, simpleNode2);
            }
            if (bl) continue;
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                linkedList.offer(simpleNode.jjtGetChild(i));
                linkedList2.offer(i);
            }
        }
        return bl;
    }

    private void removeValues(Node node, int n, Node node2) throws ParseException {
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = OptimizerUtils.buildUnionGGP(node2);
        node.jjtAddChild(aSTGraphPatternNotTriples, n);
        aSTGraphPatternNotTriples.jjtSetParent(node);
    }
}

