/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class TriplesBlock {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\?(\\S+)");
    private final Type type;
    private final Element subject;
    private final Element predicate;
    private final Element object;
    private final PPNode ppTree;

    public TriplesBlock(SimpleNode[] simpleNodeArray, SQLGenContext sQLGenContext) {
        this(simpleNodeArray, sQLGenContext, null);
    }

    public TriplesBlock(SimpleNode[] simpleNodeArray, SQLGenContext sQLGenContext, PPNode pPNode) {
        if (simpleNodeArray.length != 3) {
            throw new RuntimeException("ERROR - More than 3 nodes found for Triples Block");
        }
        Element[] elementArray = TriplesBlock.parseNodes(simpleNodeArray, sQLGenContext);
        this.subject = elementArray[0];
        this.predicate = elementArray[1];
        this.object = elementArray[2];
        this.ppTree = pPNode;
        this.type = TriplesBlock.determineType(this.subject, this.predicate, this.object);
        assert (this.checkRep()) : "checkrep failed";
    }

    private boolean checkRep() {
        assert (this.type != null) : "null triple type";
        switch (this.type) {
            case WILDCARD: {
                assert (this.subject.isVariable()) : "subject element has incorrect type for wildcard type";
                assert (this.predicate.isVariable()) : "predicate element has incorrect type for wildcard type";
                assert (this.object.isVariable()) : "object element has incorrect type for wildcard type";
                assert (this.subject.getName() != null) : "subject name is null for wildcard type";
                assert (this.predicate.getName() != null) : "predicate name is null for wildcard type";
                assert (this.object.getName() != null) : "object name is null for wildcard type";
                break;
            }
            case EXACT: {
                assert (!this.subject.isVariable()) : "subject element has incorrect type for exact type";
                assert (!this.predicate.isVariable()) : "predicate element has incorrect type for exact type";
                assert (!this.object.isVariable()) : "object element has incorrect type for exact type";
                assert (!this.subject.exists() || this.subject.getName() == null) : "subject name is not null for exact type";
                assert (!this.predicate.exists() || this.predicate.getName() == null) : "predicate name is not null for exact type";
                assert (!this.object.exists() || this.object.getName() == null) : "object name is not null for exact type";
                break;
            }
            case MISSING_S: {
                assert (this.subject.isVariable()) : "subject element has incorrect type for missing subject type";
                assert (!this.predicate.isVariable()) : "predicate element has incorrect type for missing subject type";
                assert (!this.object.isVariable()) : "object element has incorrect type for missing subject type";
                assert (this.subject.getName() != null) : "subject name is null for missing subject type";
                assert (!this.predicate.exists() || this.predicate.getName() == null) : "predicate name is not null for missing subject type";
                assert (!this.object.exists() || this.object.getName() == null) : "object name is not null for missing subject type";
                break;
            }
            case MISSING_P: {
                assert (!this.subject.isVariable()) : "subject element has incorrect type for missing predicate type";
                assert (this.predicate.isVariable()) : "predicate element has incorrect type for missing predicate type";
                assert (!this.object.isVariable()) : "object element has incorrect type for missing predicate type";
                assert (!this.subject.exists() || this.subject.getName() == null) : "subject name is not null for missing predicate type";
                assert (this.predicate.getName() != null) : "predicate name is null for missing predicate type";
                assert (!this.object.exists() || this.object.getName() == null) : "object name is not null for missing predicate type";
                break;
            }
            case MISSING_O: {
                assert (!this.subject.isVariable()) : "subject element has incorrect type for missing object type";
                assert (!this.predicate.isVariable()) : "predicate element has incorrect type for missing object type";
                assert (this.object.isVariable()) : "object element has incorrect type for missing object type";
                assert (!this.subject.exists() || this.subject.getName() == null) : "subject name is not null for missing object type";
                assert (!this.predicate.exists() || this.predicate.getName() == null) : "predicate name is not null for missing object type";
                assert (this.object.getName() != null) : "object name is null for missing object type";
                break;
            }
            case EXACT_S: {
                assert (!this.subject.isVariable()) : "subject element has incorrect type for exact subject type";
                assert (this.predicate.isVariable()) : "predicate element has incorrect type for exact subject type";
                assert (this.object.isVariable()) : "object element has incorrect type for exact subject type";
                assert (!this.subject.exists() || this.subject.getName() == null) : "subject name is not null for exact subject type";
                assert (this.predicate.getName() != null) : "predicate name is null for exact subject type";
                assert (this.object.getName() != null) : "object name is null for exact subject type";
                break;
            }
            case EXACT_P: {
                assert (this.subject.isVariable()) : "subject element has incorrect type for exact predicate type";
                assert (!this.predicate.isVariable()) : "predicate element has incorrect type for exact predicate type";
                assert (this.object.isVariable()) : "object element has incorrect type for exact predicate type";
                assert (this.subject.getName() != null) : "subject name is null for exact predicate type";
                assert (!this.predicate.exists() || this.predicate.getName() == null) : "predicate name is not null for exact predicate type";
                assert (this.object.getName() != null) : "object name is null for exact predicate type";
                break;
            }
            case EXACT_O: {
                assert (this.subject.isVariable()) : "subject element has incorrect type for exact object type";
                assert (this.predicate.isVariable()) : "predicate element has incorrect type for exact object type";
                assert (!this.object.isVariable()) : "object element has incorrect type for exact object type";
                assert (this.subject.getName() != null) : "subject name is null for exact object type";
                assert (this.predicate.getName() != null) : "predicate name is null for exact object type";
                assert (!this.object.exists() || this.object.getName() == null) : "object name is not null for exact object type";
                break;
            }
            default: {
                assert (false) : "unknown triple type found: " + (Object)((Object)this.type);
                break;
            }
        }
        return true;
    }

    private static boolean isVPDTranslated(ASTTripleAtom aSTTripleAtom) {
        return (aSTTripleAtom.flags & 1) != 0;
    }

    private static boolean isLiteralID(ASTTripleAtom aSTTripleAtom) {
        return (aSTTripleAtom.flags & 4) != 0;
    }

    private static Element createURIElement(ASTTripleAtom aSTTripleAtom, SQLGenContext sQLGenContext) {
        Long l;
        String string;
        String string2 = aSTTripleAtom.name.trim();
        if (TriplesBlock.isVPDTranslated(aSTTripleAtom)) {
            try {
                Long l2 = Long.valueOf(string2);
                return Element.createURI(l2, string2);
            }
            catch (NumberFormatException numberFormatException) {
                string = String.format("Illegal canonical ID, '%s', found for VPD translated URI triple.  Should be a number.", string2);
                System.out.printf("[%5s] %7s: %s\n", "core", "warning", string);
            }
        }
        if (!sQLGenContext.URImap.set.containsKey(string2) || sQLGenContext.URImap.get(string2) == null) {
            return Element.createNonExistant(aSTTripleAtom.type, string2, null, null, string2);
        }
        try {
            l = Long.valueOf(sQLGenContext.URImap.get(string2));
        }
        catch (NumberFormatException numberFormatException) {
            string = String.format("Illegal canonical ID, '%s', found in URImap for triple value '%s'. Should be a number.", sQLGenContext.URImap.get(string2), string2);
            throw new RuntimeException(string);
        }
        return Element.createURI(l, string2);
    }

    private static Element createLiteralElement(ASTTripleAtom aSTTripleAtom, SQLGenContext sQLGenContext) {
        Long l;
        String string;
        String string2 = aSTTripleAtom.name.trim();
        if (TriplesBlock.isVPDTranslated(aSTTripleAtom) || TriplesBlock.isLiteralID(aSTTripleAtom)) {
            try {
                Long l2 = Long.valueOf(string2);
                return Element.createLiteral(aSTTripleAtom.type, aSTTripleAtom.litLang, aSTTripleAtom.litType, l2, null);
            }
            catch (NumberFormatException numberFormatException) {
                string = String.format("Illegal canonical ID, '%s', found for VPD translated literal triple.  Should be a number.", string2);
                System.out.printf("[%5s] %7s: %s\n", "core", "warning", string);
            }
        }
        if (!sQLGenContext.litMap.containsLit(aSTTripleAtom) || sQLGenContext.litMap.get(aSTTripleAtom) == null) {
            return Element.createNonExistant(aSTTripleAtom.type, string2, aSTTripleAtom.litLang, aSTTripleAtom.litType, string2);
        }
        if (sQLGenContext.useExactValue && (!sQLGenContext.litMap.containsExactLit(aSTTripleAtom) || sQLGenContext.litMap.getExact(aSTTripleAtom) == null)) {
            return Element.createNonExistant(aSTTripleAtom.type, string2, aSTTripleAtom.litLang, aSTTripleAtom.litType, string2);
        }
        try {
            l = sQLGenContext.useExactValue ? Long.valueOf(sQLGenContext.litMap.getExact(aSTTripleAtom)) : Long.valueOf(sQLGenContext.litMap.get(aSTTripleAtom));
        }
        catch (NumberFormatException numberFormatException) {
            string = String.format("Illegal canonical ID, '%s', found in listMap for triple value '%s'. Should be a number.", sQLGenContext.useExactValue ? sQLGenContext.litMap.getExact(aSTTripleAtom) : sQLGenContext.litMap.get(aSTTripleAtom), string2);
            throw new RuntimeException(string);
        }
        return Element.createLiteral(aSTTripleAtom.type, aSTTripleAtom.litLang, aSTTripleAtom.litType, l, string2);
    }

    public static Element getElementForNode(SimpleNode simpleNode, SQLGenContext sQLGenContext) {
        return TriplesBlock.parseNode(simpleNode, sQLGenContext);
    }

    private static Element[] parseNodes(SimpleNode[] simpleNodeArray, SQLGenContext sQLGenContext) {
        int n = 0;
        Element[] elementArray = new Element[3];
        for (SimpleNode simpleNode : simpleNodeArray) {
            elementArray[n] = TriplesBlock.parseNode(simpleNode, sQLGenContext);
            ++n;
        }
        return elementArray;
    }

    private static Element parseNode(SimpleNode simpleNode, SQLGenContext sQLGenContext) {
        Element element;
        if (!ASTTripleAtom.class.isInstance(simpleNode)) {
            throw new IllegalArgumentException("Illegal triple element found: '" + simpleNode + "'");
        }
        ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
        String string = aSTTripleAtom.name.trim();
        switch (aSTTripleAtom.type) {
            case 0: {
                Matcher matcher = VAR_PATTERN.matcher(string);
                if (matcher.matches()) {
                    string = matcher.group(1);
                }
                element = Element.createVariable(string);
                break;
            }
            case 1: {
                element = TriplesBlock.createURIElement(aSTTripleAtom, sQLGenContext);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                element = TriplesBlock.createLiteralElement(aSTTripleAtom, sQLGenContext);
                break;
            }
            case 7: {
                element = Element.createSysContextFunction(string);
                break;
            }
            case 8: {
                element = Element.createPPElement();
                break;
            }
            case 9: {
                element = Element.createBindVar(aSTTripleAtom);
                break;
            }
            case 10: {
                element = Element.createBlankNode(string);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized type found for simple node: " + aSTTripleAtom.type);
            }
        }
        return element;
    }

    private static Type determineType(Element element, Element element2, Element element3) {
        byte by = 0;
        by = (byte)(by | (!element.isVariable() ? 1 : 0));
        by = (byte)(by | (element2.isVariable() ? 0 : 2));
        by = (byte)(by | (element3.isVariable() ? 0 : 4));
        switch (by) {
            case 0: {
                return Type.WILDCARD;
            }
            case 1: {
                return Type.EXACT_S;
            }
            case 2: {
                return Type.EXACT_P;
            }
            case 3: {
                return Type.MISSING_O;
            }
            case 4: {
                return Type.EXACT_O;
            }
            case 5: {
                return Type.MISSING_P;
            }
            case 6: {
                return Type.MISSING_S;
            }
            case 7: {
                return Type.EXACT;
            }
        }
        assert (false) : "invalid type computed: " + by + "\n\t subject   is variable? " + element.isVariable() + "\n\t predicate is variable? " + element2.isVariable() + "\n\t object    is variable? " + element3.isVariable();
        return null;
    }

    public String toString() {
        return "Triples " + this.subject + " " + this.predicate + " " + this.object + "; types=[" + this.subject.getType() + "," + this.predicate.getType() + "," + this.object.getType() + "]" + "; property_path=[\n" + (this.getPath() != null ? this.getPath().toString("") : "none") + "]";
    }

    public Element getSubject() {
        return this.subject;
    }

    public Element getPredicate() {
        return this.predicate;
    }

    public Element getObject() {
        return this.object;
    }

    public PPNode getPath() {
        return this.ppTree;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasPropertyPath() {
        return this.ppTree != null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TriplesBlock) {
            TriplesBlock triplesBlock = (TriplesBlock)object;
            if (this.getType() == triplesBlock.getType() && this.getSubject().equals(triplesBlock.getSubject()) && this.getPredicate().equals(triplesBlock.getPredicate()) && this.getObject().equals(triplesBlock.getObject())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 17;
        n2 = n2 * n + this.getType().hashCode();
        n2 = n2 * n + this.getSubject().hashCode();
        n2 = n2 * n + this.getPredicate().hashCode();
        n2 = n2 * n + this.getObject().hashCode();
        return n2;
    }

    public static class Element {
        private final int type;
        private final String name;
        private final Long id;
        private final boolean nonExistant;
        private final String litLang;
        private final String litType;
        private final String valueName;

        private Element(int n, String string, String string2, String string3, Long l, boolean bl, String string4) {
            this.type = n;
            this.name = string;
            this.id = l;
            this.nonExistant = bl;
            this.litLang = string2;
            this.litType = string3;
            this.valueName = string4;
            assert (this.checkRep()) : "fail";
        }

        private boolean checkRep() {
            assert (this.name != null || this.id != null) : "Can not have name and canonical ID of a TriplesBlock Element be null";
            if (this.type == 0 || this.nonExistant || this.type == 7) assert (this.name != null) : "Null name given to element that is a variable, sys context function, or is non-existant";
            if (this.type != 0 && !this.nonExistant && this.type != 7) assert (this.id != null) : "Null canonical ID given to element that is not a variable, not a sys context function, and exists";
            return true;
        }

        public boolean isVariable() {
            return this.type == 0;
        }

        public boolean isBindVariable() {
            return this.type == 9;
        }

        public boolean isSysCtxFunction() {
            return this.type == 7;
        }

        public boolean exists() {
            return !this.nonExistant;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Long getCanonicalID() {
            return this.id;
        }

        public String getLitType() {
            return this.litType;
        }

        public String getLitLang() {
            return this.litLang;
        }

        public String getValueName() {
            return this.valueName;
        }

        public static Element createVariable(String string) {
            return new Element(0, string, null, null, null, false, null);
        }

        public static Element createURI(long l, String string) {
            return new Element(1, string, null, null, l, false, string);
        }

        public static Element createLiteral(int n, String string, String string2, long l, String string3) {
            assert (n == 2 || n == 3 || n == 4 || n == 5 || n == 6) : "Can not create a literal TriplesBlock element with the non-literal type: " + n;
            return new Element(n, string3, string, string2, l, false, string3);
        }

        public static Element createSysContextFunction(String string) {
            return new Element(7, String.format("mdsys.rdf_apis.get_object_id(%s)", string), null, null, null, false, null);
        }

        public static Element createPPElement() {
            return new Element(8, "http://xmlns.oracle.com/propertyPath", null, null, null, false, null);
        }

        public static Element createBindVar(ASTTripleAtom aSTTripleAtom) {
            return new Element(9, aSTTripleAtom.getBindVar().getBVStr(), null, null, null, false, null);
        }

        public static Element createBlankNode(String string) {
            return new Element(10, string, null, null, null, false, null);
        }

        public static Element createNonExistant(int n, String string, String string2, String string3, String string4) {
            return new Element(n, string, string2, string3, null, true, string4);
        }

        public String toString() {
            if (this.nonExistant) {
                return String.format("\"%s\"", this.getName());
            }
            switch (this.type) {
                case 0: 
                case 7: {
                    return this.getName();
                }
                case 9: {
                    return new ASTTripleAtom.BindVar((String)this.getName()).bvName;
                }
            }
            return String.format("\"%s\"", this.getName());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Element) {
                Element element = (Element)object;
                if (this.getType() == element.getType() && (this.getName() == element.getName() || this.getName() != null && this.getName().equalsIgnoreCase(element.getName())) && (this.getCanonicalID() == element.getCanonicalID() || this.getCanonicalID() != null && this.getCanonicalID().equals(element.getCanonicalID()))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 17;
            n2 = n2 * n + this.getType();
            n2 = n2 * n + (this.getName() == null ? 0 : this.getName().toLowerCase().hashCode());
            n2 = n2 * n + (this.getCanonicalID() == null ? 0 : this.getCanonicalID().hashCode());
            return n2;
        }
    }

    public static enum Type {
        WILDCARD("?s ?p ?o"),
        EXACT(" s  p  o"),
        MISSING_S("?s  p  o"),
        MISSING_P(" s ?p  o"),
        MISSING_O(" s  p ?o"),
        EXACT_S(" s ?p ?o"),
        EXACT_P("?s  p ?o"),
        EXACT_O("?s ?p  o");

        private String desc;

        private Type(String string2) {
            this.desc = string2;
        }

        public String toString() {
            return this.desc;
        }
    }
}

