/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.ServiceSPARQLTreeNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class SimpleSPARQLTreeNode
extends AbstractSPARQLTreeNode
implements SPARQLTreeNode {
    private Set<String> rejectedBGPProjections;
    private Set<String> rejectedBGPLexVars;
    private String valuesTab;

    public SimpleSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2) {
        this(n, sQLGenContext, n2, null);
    }

    public SimpleSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2, String string) {
        super(n, sQLGenContext, n2);
        this.setSparqlText(string);
        this.rejectedBGPProjections = new HashSet<String>();
        this.rejectedBGPLexVars = new HashSet<String>();
        this.valuesTab = "MDSYS.RDF_VALUE$";
        if (sQLGenContext.localValues != null) {
            this.valuesTab = sQLGenContext.localValues;
        }
    }

    @Override
    public Set<String> getRequiredLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.myBGP != null) {
            hashSet.addAll(this.myBGP.getRequiredLexVars());
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            hashSet.addAll(this.getChild(i).getRequiredLexVars());
        }
        for (Object object : this.myFilters) {
            hashSet.addAll(((Filter)object).getRequiredLexVars());
        }
        if (!this.ctx.disableVidLexOpt) {
            Object object;
            Set<String> set = this.getDefBoundVidVars();
            object = set.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                hashSet.remove(string);
            }
        }
        return hashSet;
    }

    @Override
    public void setProjections() throws RDFException {
        Set<String> set;
        int n;
        int n2 = this.getNumChildren();
        SPARQLTreeNode sPARQLTreeNode = null;
        HashSet<String> hashSet = new HashSet<String>(this.getProjectVars());
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String set22 : hashSet) {
            if (this.myBGP.getBGPVars().contains(set22) && !this.localBGPFilters.contains(set22)) {
                hashSet2.add(set22);
            }
            for (int i = 0; i < n2; ++i) {
                sPARQLTreeNode = this.getChild(i);
                if (!sPARQLTreeNode.getCumulativeVars().contains(set22) || sPARQLTreeNode.getPushCandidates().contains(set22)) continue;
                hashSet2.add(set22);
            }
        }
        hashSet.removeAll(hashSet2);
        HashSet hashSet3 = new HashSet();
        Object var6_7 = null;
        ArrayList arrayList = new ArrayList(n2 + 1);
        for (int i = 0; i < n2 + 1; ++i) {
            arrayList.add(new HashSet());
        }
        HashSet<String> hashSet4 = new HashSet<String>();
        hashSet4.addAll(this.getJoinVarsForFilters(this.localBGPFilters));
        hashSet4.addAll(this.myBGP.getBindVars());
        Set<String> set2 = QueryUtils.getCommonVars(this.getProjectVars(), hashSet4);
        hashSet3.addAll(set2);
        ((Set)arrayList.get(0)).addAll(hashSet3);
        this.rejectedBGPProjections.addAll(this.myBGP.addProjectVars(set2));
        for (int i = 0; i < n2; ++i) {
            sPARQLTreeNode = this.getChild(i);
            n = sPARQLTreeNode.getType();
            set = QueryUtils.getCommonVars(QueryUtils.getCommonVars(this.getProjectVars(), sPARQLTreeNode.getPushCandidates()), sPARQLTreeNode.getCumulativeVars());
            if (n == 0) {
                Set<String> set3 = QueryUtils.getCommonVars(set, sPARQLTreeNode.getDefiniteBoundVars());
                hashSet3.addAll(set3);
                sPARQLTreeNode.addProjectVars(set3);
            }
            Set<String> set4 = QueryUtils.getCommonVars(set, hashSet);
            sPARQLTreeNode.addProjectVars(set4);
            Set<String> set5 = QueryUtils.getCommonVars(this.getJoinVarsForFilters(sPARQLTreeNode.getNonLocalFilters()), sPARQLTreeNode.getCumulativeVars());
            if (n == 0) {
                hashSet3.addAll(QueryUtils.getCommonVars(sPARQLTreeNode.getDefiniteBoundVars(), set5));
            }
            sPARQLTreeNode.addProjectVars(set5);
            ((Set)arrayList.get(i + 1)).addAll(hashSet3);
        }
        HashSet<String> hashSet5 = new HashSet<String>();
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            set = QueryUtils.getDistinctVars(this.getJoinVarsForFilters(sPARQLTreeNode.getNonLocalFilters()), sPARQLTreeNode.getCumulativeVars());
            set.removeAll((Collection)arrayList.get(n));
            set.removeAll(hashSet5);
            for (String string : set) {
                SPARQLTreeNode sPARQLTreeNode2;
                int n3;
                boolean bl = false;
                for (n3 = n - 1; n3 >= 0 && !bl; --n3) {
                    sPARQLTreeNode2 = this.getChild(n3);
                    if (sPARQLTreeNode2.getType() != 0 || !sPARQLTreeNode2.getDefiniteBoundVars().contains(string)) continue;
                    sPARQLTreeNode2.addProjectVar(string);
                    hashSet5.add(string);
                    bl = true;
                }
                if (!bl && this.myBGP.getBGPVars().contains(string)) {
                    n3 = this.myBGP.addProjectVar(string) ? 1 : 0;
                    if (n3 == 0) {
                        this.rejectedBGPProjections.add(string);
                    }
                    hashSet5.add(string);
                    bl = true;
                }
                if (bl) continue;
                for (n3 = n - 1; n3 >= 0; --n3) {
                    sPARQLTreeNode2 = this.getChild(n3);
                    if (!sPARQLTreeNode2.getCumulativeVars().contains(string)) continue;
                    sPARQLTreeNode2.addProjectVar(string);
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.setProjections();
        }
    }

    @Override
    public void setLexVars() throws RDFException {
        int n;
        this.rejectedBGPLexVars.addAll(this.myBGP.addLexVars(QueryUtils.getCommonVars(this.getRequiredLexVars(), this.getBGPVars())));
        SPARQLTreeNode sPARQLTreeNode = null;
        int n2 = this.getNumChildren();
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.addLexVars(QueryUtils.getCommonVars(this.getRequiredLexVars(), sPARQLTreeNode.getCumulativeVars()));
        }
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.setLexVars();
        }
    }

    @Override
    public String toSQL() throws RDFException {
        return this.toSQL(null, null, null, null, null, null);
    }

    public String toSQL(String string, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        HashSet<String> hashSet = null;
        HashSet<String> hashSet2 = null;
        HashSet<String> hashSet3 = null;
        HashSet<String> hashSet4 = null;
        HashSet<String> hashSet5 = null;
        HashSet<String> hashSet6 = null;
        HashSet<String> hashSet7 = null;
        Set<String> set6 = null;
        HashSet<String> hashSet8 = null;
        HashSet<String> hashSet9 = null;
        HashSet<String> hashSet10 = new HashSet<String>();
        int n = this.getNumChildren();
        int n2 = 0;
        boolean bl = false;
        if (this.myBGP.refsNonExistingTerm() && string == null) {
            String string9 = this.buildAllNullSelect(this.getCumulativeAndPushedVars(), this.getProjectVars(), this.getAllLexVars());
            String string10 = "FROM MDSYS.RDF_NAMESPACE$";
            String string11 = "WHERE 1=0";
            stringBuffer.append(string9).append("\n");
            stringBuffer.append(string10).append("\n");
            stringBuffer.append(string11);
        } else {
            String[] stringArray;
            int n3;
            Object object;
            boolean[] blArray;
            if (string != null) {
                string2 = string;
                hashSet = new HashSet<String>(set);
                hashSet3 = new HashSet<String>(set2);
                hashSet5 = new HashSet<String>(set3);
                hashSet7 = new HashSet<String>(set4);
                hashSet8 = new HashSet<String>(set5);
                string3 = "";
                hashSet2 = new HashSet();
                hashSet4 = new HashSet();
                hashSet6 = new HashSet<String>();
                set6 = new HashSet<String>();
                hashSet9 = new HashSet();
                blArray = new boolean[1];
                hashSet10 = new HashSet();
                string3 = this.translateMyBGP(hashSet2, hashSet4, hashSet6, set6, hashSet9, blArray, hashSet10);
                bl = blArray[0];
                string5 = this.buildSelect(hashSet, hashSet2, hashSet5, hashSet6, hashSet7, set6, "r1", "r2", "");
                string7 = this.buildFrom(string2, string3, 0);
                string8 = this.buildOn(hashSet, hashSet2, hashSet3, hashSet4, hashSet7, set6, hashSet8, hashSet9, new ArrayList<Filter>(), bl);
                string2 = string4 = string5 + "\n" + string7 + "\n" + string8;
                hashSet.addAll(hashSet2);
                hashSet8.addAll(hashSet9);
                hashSet5.addAll(hashSet6);
                hashSet7.addAll(set6);
                hashSet3.addAll(hashSet4);
                hashSet10.addAll(QueryUtils.getCommonVars(hashSet6, hashSet4));
            } else {
                string2 = "";
                hashSet = new HashSet();
                hashSet3 = new HashSet();
                hashSet5 = new HashSet();
                hashSet7 = new HashSet();
                hashSet8 = new HashSet();
                blArray = new boolean[1];
                hashSet10 = new HashSet();
                string2 = this.translateMyBGP(hashSet, hashSet3, hashSet5, hashSet7, hashSet8, blArray, hashSet10);
                bl = blArray[0];
            }
            for (int i = n2; i < n; ++i) {
                object = this.getChild(i);
                hashSet2 = object.getCumulativeAndPushedVars();
                hashSet4 = object.getDefiniteBoundAndPushedVars();
                hashSet9 = object.getCumulativeVars();
                hashSet6 = new HashSet<String>(object.getProjectVars());
                set6 = object.getAllLexVars();
                n3 = 0;
                if (object instanceof ServiceSPARQLTreeNode && this.ctx.serviceJoinPushDown) {
                    string3 = ((ServiceSPARQLTreeNode)object).toSQL(hashSet, string2);
                } else if ((object.getOverloadedServiceInfo() & 2) != 0) {
                    string3 = ((SimpleSPARQLTreeNode)object).getInnerSQL(hashSet, hashSet5, hashSet7, hashSet2, hashSet6, set6, string2, (object.getOverloadedServiceInfo() & 4) != 0);
                    if (string3 == null) {
                        string3 = object.toSQL();
                    } else {
                        n3 = 1;
                    }
                } else {
                    string3 = object.toSQL();
                }
                int n4 = object.getType();
                if (n4 == 2) {
                    string6 = object.getAntiJoinHint();
                    string2 = this.wrapForMinus(hashSet, hashSet2, hashSet3, hashSet4, hashSet5, hashSet6, hashSet7, set6, string2, string3, "r1", "r2", string6);
                    continue;
                }
                if ((object.getOverloadedServiceInfo() & 4) == 0 || n3 == 0) {
                    string6 = object.getJoinHint("r1", "r2");
                    if (i == 0 && this.myBGP.getNumTriples() == 0) {
                        string6 = "";
                    }
                    bl = bl || object.containsEmptyBGP();
                    string5 = this.buildSelect(hashSet, hashSet2, hashSet5, hashSet6, hashSet7, set6, "r1", "r2", string6);
                    string7 = this.buildFrom(string2, string3, object.getType());
                    string8 = this.buildOn(hashSet, hashSet2, hashSet3, hashSet4, hashSet7, set6, hashSet8, hashSet9, (List)this.childJoinFilters.get(i), bl);
                    string4 = string5 + "\n" + string7 + "\n" + string8;
                } else {
                    string4 = string3;
                }
                string2 = string4;
                hashSet.addAll(hashSet2);
                hashSet8.addAll(hashSet9);
                hashSet5.addAll(hashSet6);
                hashSet7.addAll(set6);
                if (object.getType() != 0) continue;
                hashSet3.addAll(hashSet4);
                hashSet10.addAll(QueryUtils.getCommonVars(hashSet6, hashSet4));
            }
            Set<String> set7 = this.getJoinVarsForFilters(this.localNonBGPFilters);
            set7.removeAll(this.getBindVarsForFilters(this.localNonBGPFilters));
            set7.addAll(this.getProjectVars());
            object = new HashSet<String>(hashSet5);
            for (n3 = 0; n3 < n; ++n3) {
                SPARQLTreeNode sPARQLTreeNode = this.getChild(n3);
                object.removeAll(QueryUtils.getDistinctVars(sPARQLTreeNode.getCumulativeVars(), sPARQLTreeNode.getProjectVars()));
            }
            object.removeAll(QueryUtils.getDistinctVars(this.myBGP.getBGPVars(), this.myBGP.getProjectVars()));
            hashSet10.addAll((Collection<String>)object);
            set7 = QueryUtils.getDistinctVars(set7, hashSet10);
            Set<String> set8 = QueryUtils.getDistinctVars(this.getProjectVars(), hashSet10);
            Set<String> set9 = this.getAllLexVars();
            Set<String> set10 = QueryUtils.getCommonVars(hashSet10, set9);
            HashSet<String> hashSet11 = new HashSet<String>();
            hashSet11.addAll(QueryUtils.getCommonVars(set10, QueryUtils.getDistinctVars(this.myBGP.getProjectVars(), this.myBGP.getAllLexVars())));
            for (int i = 0; i < n; ++i) {
                stringArray = this.getChild(i);
                hashSet11.addAll(QueryUtils.getCommonVars(set10, QueryUtils.getDistinctVars(stringArray.getProjectVars(), stringArray.getAllLexVars())));
            }
            if (this.localNonBGPFilters.isEmpty() && this.limit < 0 && !this.pushingMyBGP && set7.isEmpty() && hashSet11.isEmpty()) {
                stringBuffer.append(string2);
            } else {
                String string12 = "";
                if (this.pushingMyBGP) {
                    string12 = this.buildBGPWith();
                }
                stringArray = new String[]{""};
                String[] stringArray2 = new String[]{""};
                String[] stringArray3 = new String[]{""};
                String[] stringArray4 = new String[]{""};
                HashMap<String, String> hashMap = new HashMap<String, String>();
                this.buildFinalValueJoin(set7, set8, this.getDefiniteBoundVars(), set9, stringArray, stringArray2, stringArray3, stringArray4, hashMap);
                String string13 = this.buildSelect(hashSet, new HashSet<String>(), hashSet10, new HashSet<String>(), set9, new HashSet<String>(), hashSet11, "R", "", stringArray4[0]);
                String string14 = "FROM (" + string2 + ") " + "R";
                String string15 = "WHERE (1=1) ";
                string13 = string13 + stringArray[0];
                string14 = string14 + stringArray2[0];
                string15 = string15 + stringArray3[0];
                for (ASTTripleAtom.BindVar bindVar : this.getBindVarObjsForFilters(this.localNonBGPFilters)) {
                    string14 = string14 + ", " + bindVar.getAlias() + " " + bindVar.getAlias();
                }
                stringBuffer.append(string12);
                stringBuffer.append(string13);
                stringBuffer.append("\n");
                stringBuffer.append(string14);
                stringBuffer.append("\n");
                stringBuffer.append(string15);
                stringBuffer.append(this.buildFinalWhere(hashMap, this.localNonBGPFilters, stringBuffer.toString(), this.getCumulativeAndPushedVars(), this.getProjectVars(), this.getAllLexVars(), this.getCumulativeVars()));
                if (this.limit >= 0) {
                    stringBuffer.append(" AND ROWNUM <= " + this.limit);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getInnerSQL(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, String string, boolean bl) {
        CharSequence charSequence2;
        Set<String> set7;
        Set<String> set8;
        Set<String> set9;
        Set<String> set10 = QueryUtils.getCommonVars(set, set4);
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (set10.size() > 0) {
            stringBuffer.append("'");
            for (String string2 : set10) {
                QueryUtils.appendToList(stringBuffer, string2, " ", "'");
                if (set3.contains(string2)) {
                    QueryUtils.appendToList(stringBuffer, "1", " ", "'");
                    continue;
                }
                QueryUtils.appendToList(stringBuffer, "0", " ", "'");
            }
            stringBuffer.append("'");
            stringBuffer2.append("cursor(");
            if (bl) {
                stringBuffer2.append(string);
            } else {
                stringBuffer2.append(SimpleSPARQLTreeNode.buildDistinct(set10, set3, string));
            }
        } else {
            return null;
        }
        stringBuffer2.append(")");
        StringBuffer stringBuffer3 = new StringBuffer("'");
        for (int i = 0; i < this.ctx.models.length; ++i) {
            QueryUtils.appendToList(stringBuffer3, this.ctx.models[i], " ", "'");
        }
        stringBuffer3.append("'");
        if (bl) {
            set9 = QueryUtils.getUnion(set, set4);
            set8 = QueryUtils.getUnion(set2, set5);
            set7 = QueryUtils.getUnion(set3, set6);
        } else {
            set9 = set4;
            set8 = set5;
            set7 = set6;
        }
        StringBuffer stringBuffer4 = new StringBuffer("'");
        for (String object32 : set9) {
            if (set7.contains(object32) || set8.contains(object32)) continue;
            QueryUtils.appendToList(stringBuffer4, object32, " ", "'");
        }
        stringBuffer4.append("'");
        StringBuffer stringBuffer5 = new StringBuffer("'");
        for (String string2 : set8) {
            if (set7.contains(string2)) continue;
            QueryUtils.appendToList(stringBuffer5, string2, " ", "'");
        }
        stringBuffer5.append("'");
        StringBuffer stringBuffer6 = new StringBuffer("'");
        for (CharSequence charSequence2 : set7) {
            if (!set8.contains(charSequence2)) continue;
            QueryUtils.appendToList(stringBuffer6, charSequence2, " ", "'");
        }
        stringBuffer6.append("'");
        StringBuffer stringBuffer7 = new StringBuffer("'INVALID'");
        charSequence2 = new StringBuffer("''' ").append("PLUS_RDFT=VC").append(" ").append(this.ctx.queryOptions).append(" '''");
        StringBuffer stringBuffer8 = new StringBuffer("'");
        for (String string3 : this.ctx.defaultGraphList) {
            QueryUtils.appendToList(stringBuffer8, string3, " ", "'");
        }
        stringBuffer8.append("'");
        StringBuffer stringBuffer9 = new StringBuffer("'");
        for (String string4 : this.ctx.namedGraphsList) {
            QueryUtils.appendToList(stringBuffer9, string4, " ", "'");
        }
        stringBuffer9.append("'");
        StringBuffer stringBuffer10 = new StringBuffer("").append("select * from table(sem_match_nl(").append("\nstr_query=>'").append(this.getSparqlText()).append("'").append(",\nstr_models=>").append(stringBuffer3).append(",\nstr_index_status=>").append(stringBuffer7).append(",\nstr_options=>").append((StringBuffer)charSequence2).append(",\nstr_graphs=>").append(stringBuffer8).append(",\nstr_named_graphs=>").append(stringBuffer9).append(",\nid_vars=>").append(stringBuffer4).append(",\nval_vars=>").append(stringBuffer5).append(",\nterm_vars=>").append(stringBuffer6).append(",\njoin_vars=>").append(stringBuffer).append(",\npushed_results=>").append(stringBuffer2).append("))");
        return stringBuffer10.toString();
    }

    protected static String buildDistinct(Set<String> set, Set<String> set2, String string) {
        String string2 = "$ISCLOB";
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("SELECT DISTINCT ");
        int n = 0;
        for (String string3 : set) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            if (!set2.contains(string3)) {
                stringBuffer.append(string3).append("$RDFVID");
            } else {
                stringBuffer.append(QueryUtils.shortenVNforTerm(string3 + "$RDFCLOB", string3 + "$RDFLANG", string3 + "$RDFLTYP")).append(" AS ").append(string3).append(string2).append(",").append(string3).append("$RDFTERM");
            }
            ++n;
        }
        stringBuffer.append(" FROM(").append(string).append(")");
        return stringBuffer.toString();
    }

    private String translateMyBGP(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, boolean[] blArray, Set<String> set6) throws RDFException {
        String string = "";
        string = this.pushingMyBGP ? this.myBgpWithAlias : this.genBGPSubquery();
        set.addAll(this.myBGP.getBGPAndPushedVars());
        set2.addAll(this.myBGP.getDefiniteBoundAndPushedVars());
        set3.addAll(this.myBGP.getProjectVars());
        set3.addAll(this.rejectedBGPProjections);
        set3.addAll(this.rejectedBGPLexVars);
        set4.addAll(this.myBGP.getAllLexVars());
        set5.addAll(this.myBGP.getBGPVars());
        blArray[0] = this.myBGP.getNumTriples() == 0;
        set6.addAll(QueryUtils.getCommonVars(set3, set2));
        return string;
    }

    private Set<String> getDefBoundVidVars() {
        HashSet<String> hashSet = new HashSet<String>();
        Set<String> set = this.myBGP.getRequiredLexVars();
        for (String object : this.myBGP.getDefiniteBoundVars()) {
            if (set.contains(object)) continue;
            hashSet.add(object);
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            set = sPARQLTreeNode.getRequiredLexVars();
            if (sPARQLTreeNode.getType() != 0) continue;
            for (String string : sPARQLTreeNode.getDefiniteBoundVars()) {
                if (set.contains(string)) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private String genBGPSubquery() throws RDFException {
        String string = this.myBGP.toSQL();
        if (!(this.rejectedBGPFilters.isEmpty() && this.rejectedBGPProjections.isEmpty() && this.rejectedBGPLexVars.isEmpty())) {
            Cloneable cloneable2;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(this.rejectedBGPProjections);
            for (Cloneable cloneable2 : this.rejectedBGPFilters) {
                hashSet.addAll(((Filter)cloneable2).getfJoinVars());
            }
            hashSet.addAll(this.rejectedBGPLexVars);
            hashSet.removeAll(this.myBGP.getProjectVars());
            Set<String> set = this.myBGP.getAllLexVars();
            cloneable2 = new HashSet<String>(this.rejectedBGPProjections);
            cloneable2.addAll(this.rejectedBGPLexVars);
            String[] stringArray = new String[]{""};
            String[] stringArray2 = new String[]{""};
            String[] stringArray3 = new String[]{""};
            String[] stringArray4 = new String[]{""};
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.buildFinalValueJoin(hashSet, (Set<String>)((Object)cloneable2), this.myBGP.getDefiniteBoundVars(), set, stringArray, stringArray2, stringArray3, stringArray4, hashMap);
            String string2 = this.buildSelect(this.myBGP.getBGPAndPushedVars(), new HashSet<String>(), this.myBGP.getProjectVars(), new HashSet<String>(), set, new HashSet<String>(), "R", "", stringArray4[0]);
            String string3 = "FROM (" + string + ") " + "R";
            String string4 = "WHERE (1=1) ";
            string2 = string2 + stringArray[0];
            string3 = string3 + stringArray2[0];
            string4 = string4 + stringArray3[0];
            string = string2 + "\n" + string3 + "\n" + string4;
            String string5 = this.buildFinalWhere(hashMap, this.rejectedBGPFilters, string, this.myBGP.getBGPAndPushedVars(), this.myBGP.getProjectVars(), this.myBGP.getAllLexVars(), this.myBGP.getBGPVars());
            string = string + string5;
        }
        return string;
    }

    private void buildFinalValueJoin(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, Map<String, String> map) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        this.genOuterSelectComponents(set, set3, hashMap, stringArray2, stringArray3, map);
        StringBuffer stringBuffer = new StringBuffer("");
        for (Map.Entry entry : hashMap.entrySet()) {
            if (set2.contains(entry.getKey())) {
                stringBuffer.append(",\n");
                stringBuffer.append(this.buildNonVidSelect((String)entry.getKey(), (List)entry.getValue()));
            }
            if (!set4.contains(entry.getKey())) continue;
            stringBuffer.append(", ");
            stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, this.buildRDFTForVar("", (String)entry.getKey(), hashMap, false, true, false, true), (String)entry.getKey() + this.term_alias));
        }
        stringArray[0] = stringBuffer.toString();
        stringArray4[0] = this.myBGP.getValueJoinHint(map.values(), "R");
    }

    private String buildNonVidSelect(String string, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer("");
        String[] stringArray = new String[]{"", this.vid_alias, this.prefix_alias, this.suffix_alias, this.vtype_alias, this.longLit_alias, this.litType_alias, this.langType_alias};
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 1) continue;
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, list.get(i), string + stringArray[i]));
        }
        return stringBuffer.toString();
    }

    private String buildBGPWith() throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("WITH " + this.myBgpWithAlias + " AS (\n");
        stringBuffer.append(this.genBGPSubquery());
        stringBuffer.append("\n)\n");
        return stringBuffer.toString();
    }

    private String buildFinalWhere(Map<String, String> map, List<Filter> list, String string, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        Map<String, String> map2 = this.buildFilterAliasMap(this.getCumulativeVars(), new HashSet<String>(), "R", "");
        map2.putAll(map);
        for (Filter filter : list) {
            filter.setCurrSQL(string, set, set2, set3, set4);
            QueryUtils.appendToList(stringBuffer, "(" + filter.toSQL(map2, this.ctx.funcTypeMap, this.ctx.funcHandMap) + ")", " AND\n", "dummy");
        }
        return stringBuffer.toString();
    }

    private Map<String, String> buildFilterAliasMap(Set<String> set, Set<String> set2, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object2 : set2) {
            hashMap.put(object2, string2 + "." + object2);
        }
        Set<String> set3 = QueryUtils.getDistinctVars(set, set2);
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            hashMap.put(string3, string + "." + string3);
        }
        return hashMap;
    }

    private String buildCoalesceForVar(String string, String string2, String string3, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        int n2 = 0;
        if (set.contains(string3)) {
            ++n2;
        }
        if (set2.contains(string3)) {
            n2 += 2;
        }
        int n3 = 0;
        if (set3.contains(string3)) {
            ++n3;
        }
        if (set4.contains(string3)) {
            n3 += 2;
        }
        n = n2 > 0 || n3 > 0 ? 8 : 1;
        boolean bl = (n2 & 1) == 1 || (n3 & 1) == 1;
        boolean bl2 = (n2 & 2) == 2 || (n3 & 2) == 2;
        for (int i = 0; i < n; ++i) {
            if (i == 0 || bl && bl2) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, "COALESCE (" + string + "." + string3 + this.varProjColumns[i] + ", " + string2 + "." + string3 + this.varProjColumns[i] + ") ", string3 + this.varProjColumns[i]), ", ", "");
                continue;
            }
            if (bl) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string + "." + string3 + this.varProjColumns[i], string3 + this.varProjColumns[i]), ", ", "");
                continue;
            }
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string2 + "." + string3 + this.varProjColumns[i], string3 + this.varProjColumns[i]), ", ", "");
        }
        if (n3 > 0) {
            if ((n3 & 3) > 2) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, "COALESCE (" + string + "." + string3 + this.varProjColumns[8] + ", " + string2 + "." + string3 + this.varProjColumns[8] + ") ", string3 + this.varProjColumns[8]), ", ", "");
            } else if ((n3 & 1) > 0) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string + "." + string3 + this.varProjColumns[8], string3 + this.varProjColumns[8]), ", ", "");
            } else {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string2 + "." + string3 + this.varProjColumns[8], string3 + this.varProjColumns[8]), ", ", "");
            }
        }
        return stringBuffer.toString();
    }

    private String buildSelect(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, String string, String string2, String string3) {
        Set<String> set7 = Collections.emptySet();
        return this.buildSelect(set, set2, set3, set4, set5, set6, set7, string, string2, string3);
    }

    private String buildSelect(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, Set<String> set7, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set8 = QueryUtils.getDistinctVars(set, set2);
        Set<String> set9 = QueryUtils.getCommonVars(set, set2);
        Set<String> set10 = QueryUtils.getDistinctVars(set2, set);
        if (set8.size() == 0 && set9.size() == 0 && set10.size() > 0) {
            QueryUtils.appendToList(stringBuffer, string2 + ".*", ",\n", "");
        } else {
            String string4;
            for (String string5 : set8) {
                string4 = this.buildSelectForVar(string, string5, set3, set5, set7);
                QueryUtils.appendToList(stringBuffer, string4, ",\n", "");
            }
            for (String string5 : set9) {
                string4 = this.buildCoalesceForVar(string, string2, string5, set3, set4, set5, set6);
                QueryUtils.appendToList(stringBuffer, string4, ",\n", "");
            }
            for (String string5 : set10) {
                string4 = this.buildSelectForVar(string2, string5, set4, set6, set7);
                QueryUtils.appendToList(stringBuffer, string4, ",\n", "");
            }
            if ((this.ctx.contextFlags & 3) > 0) {
                if (string2.equals("")) {
                    QueryUtils.appendToList(stringBuffer, " " + string + ".T0_CTXT2 as T0_CTXT2 ", ",\n ", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, " nvl(" + string + ".T0_CTXT2, " + string2 + ".T0_CTXT2) as T0_CTXT2 ", ",\n ", "");
                }
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("1\n");
        }
        return "SELECT " + string3 + " " + stringBuffer.toString();
    }

    private String buildAllNullSelect(Set<String> set, Set<String> set2, Set<String> set3) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (String string : set) {
            String string2 = this.buildAllNullSelectForVar(string, set2, set3);
            QueryUtils.appendToList(stringBuffer, string2, ",\n", "");
        }
        if ((this.ctx.contextFlags & 3) > 0) {
            QueryUtils.appendToList(stringBuffer, "NULL as T0_CTXT2 ", ",\n ", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("1\n");
        }
        return "SELECT " + stringBuffer.toString();
    }

    private String buildAllNullSelectForVar(String string, Set<String> set, Set<String> set2) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        int n2 = 7;
        int n3 = 0;
        if (set.contains(string)) {
            n3 = 8;
            if (set2.contains(string)) {
                n3 = 9;
            }
        } else {
            n3 = 1;
        }
        for (int i = 0; i < n3; ++i) {
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.buildNullValueForVar(i, n, n2), string + this.varProjColumns[i]), ", ", "");
        }
        return stringBuffer.toString();
    }

    private String buildFrom(String string, String string2, int n) {
        String string3 = "INNER JOIN";
        if (n == 1) {
            string3 = "LEFT OUTER JOIN";
        }
        return "FROM (" + string + ") " + "r1" + "\n" + string3 + "\n" + "(" + string2 + ") " + "r2";
    }

    /*
     * WARNING - void declaration
     */
    private String buildOn(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, Set<String> set7, Set<String> set8, List<Filter> list, boolean bl) throws RDFException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set9 = QueryUtils.getCommonVars(set, set2);
        for (String object : set9) {
            void var15_16;
            String string2 = "";
            string = "r1." + object + this.vid_alias;
            String string3 = "r2." + object + this.vid_alias;
            String string4 = "0";
            if (set5.contains(object) && set6.contains(object)) {
                string = "r1." + object + this.term_alias;
                string3 = "r2." + object + this.term_alias;
                string4 = "'RDF$NULL'";
            } else if (set5.contains(object)) {
                string = SimpleSPARQLTreeNode.buildRes2VidCall("r1." + object + this.term_alias, "r1." + object + this.litType_alias, "r1." + object + this.langType_alias, this.valuesTab);
            } else if (set6.contains(object)) {
                string3 = SimpleSPARQLTreeNode.buildRes2VidCall("r2." + object + this.term_alias, "r2." + object + this.litType_alias, "r2." + object + this.langType_alias, this.valuesTab);
            }
            if (this.ctx.disableNullJoin) {
                String string5 = "(" + string + " = " + string3 + ")";
            } else if ((this.ctx.optJoinFlags & 1) > 0) {
                void var15_23;
                String string6 = "(" + string + " = " + string3;
                if (!set3.contains(object)) {
                    String string7 = string6 + " OR " + string + " IS NULL";
                }
                if (!set4.contains(object)) {
                    void var15_21;
                    String string8 = (String)var15_21 + " OR " + string3 + " IS NULL";
                }
                String string9 = (String)var15_23 + ")";
            } else {
                String string10 = string;
                if (!set3.contains(object)) {
                    string10 = "COALESCE(" + string10 + "," + string3 + "," + string4 + ")";
                }
                String string11 = string3;
                if (!set4.contains(object)) {
                    string11 = "COALESCE(" + string11 + "," + string + "," + string4 + ")";
                }
                String string12 = "(" + string10 + " = " + string11 + ")";
            }
            QueryUtils.appendToList(stringBuffer, (String)var15_16, " AND\n", "");
        }
        if (bl && (this.ctx.contextFlags & 3) > 0 || (this.ctx.contextFlags & 2) > 0) {
            QueryUtils.appendToList(stringBuffer, "(coalesce(r1.T0_CTXT2,r2.T0_CTXT2,'RDFCTX$NULLCTX') = coalesce(r2.T0_CTXT2,r1.T0_CTXT2,'RDFCTX$NULLCTX'))", " AND\n", "");
        } else if ((this.ctx.contextFlags & 1) > 0) {
            QueryUtils.appendToList(stringBuffer, "(r1.T0_CTXT2 = r2.T0_CTXT2)", " AND\n", "");
        }
        Map<String, String> map = this.buildFilterAliasMap(set7, set8, "r1", "r2");
        for (Filter filter : list) {
            string = "(" + filter.toSQL(map, this.ctx.funcTypeMap, this.ctx.funcHandMap) + ")";
            QueryUtils.appendToList(stringBuffer, string, " AND\n", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("(1=1)");
        }
        return "ON (" + stringBuffer.toString() + ")";
    }

    private String wrapForMinus(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, Set<String> set7, Set<String> set8, String string, String string2, String string3, String string4, String string5) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set9 = QueryUtils.getCommonVars(set, set2);
        if (set9.isEmpty()) {
            stringBuffer.append(string);
        } else {
            CharSequence charSequence;
            String string6 = this.buildSelect(set, new HashSet<String>(), set5, new HashSet<String>(), set7, new HashSet<String>(), string3, "", "");
            String string7 = "FROM (" + string + ") " + string3;
            String[] stringArray = set9.toArray(new String[0]);
            String[] stringArray2 = new String[set9.size()];
            String[] stringArray3 = new String[set9.size()];
            String[] stringArray4 = new String[set9.size()];
            String[] stringArray5 = new String[set9.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                charSequence = stringArray[i];
                if (set7.contains(charSequence) && set8.contains(charSequence)) {
                    stringArray2[i] = string3 + "." + (String)charSequence + "$RDFTERM";
                    stringArray3[i] = "'0'";
                    stringArray4[i] = string4 + "." + (String)charSequence + "$RDFTERM";
                    stringArray5[i] = "'0'";
                    continue;
                }
                if (set7.contains(charSequence)) {
                    stringArray2[i] = QueryUtils.wrapSQLforNumeric(SimpleSPARQLTreeNode.buildRes2VidCall(string3 + "." + (String)charSequence + "$RDFTERM", string3 + "." + (String)charSequence + "$RDFLTYP", string3 + "." + (String)charSequence + "$RDFLANG", this.valuesTab));
                    stringArray3[i] = "-1";
                    stringArray4[i] = string4 + "." + (String)charSequence + "$RDFVID";
                    stringArray5[i] = "-1";
                    continue;
                }
                if (set8.contains(charSequence)) {
                    stringArray2[i] = string3 + "." + (String)charSequence + "$RDFVID";
                    stringArray3[i] = "-1";
                    stringArray4[i] = QueryUtils.wrapSQLforNumeric(SimpleSPARQLTreeNode.buildRes2VidCall(string4 + "." + (String)charSequence + "$RDFTERM", string4 + "." + (String)charSequence + "$RDFLTYP", string4 + "." + (String)charSequence + "$RDFLANG", this.valuesTab));
                    stringArray5[i] = "-1";
                    continue;
                }
                stringArray2[i] = string3 + "." + (String)charSequence + "$RDFVID";
                stringArray3[i] = "-1";
                stringArray4[i] = string4 + "." + (String)charSequence + "$RDFVID";
                stringArray5[i] = "-1";
            }
            String string8 = "NOT EXISTS";
            if (this.ctx.disableNotExists) {
                string8 = "NOT IN";
            }
            charSequence = new StringBuffer("");
            ((StringBuffer)charSequence).append("WHERE ((");
            ((StringBuffer)charSequence).append(QueryUtils.buildMaskedInListClause(stringArray, set3, set4, stringArray2, stringArray4, stringArray3, stringArray5, string2, string4, string8, "AND", false, string5, this.ctx));
            ((StringBuffer)charSequence).append(")");
            boolean bl = true;
            for (String string9 : set9) {
                if (!set3.contains(string9)) continue;
                bl = false;
                break;
            }
            if (bl) {
                StringBuffer stringBuffer2 = new StringBuffer("");
                if (stringArray2.length > 1) {
                    String string9;
                    string9 = "";
                    stringBuffer2.append("COALESCE(");
                    for (int i = 0; i < stringArray2.length; ++i) {
                        string9 = stringArray3[i].startsWith("'") ? stringArray2[i] : QueryUtils.buildSafeToChar(stringArray2[i]);
                        QueryUtils.appendToList(stringBuffer2, string9, ",", "COALESCE(");
                    }
                    stringBuffer2.append(")");
                } else {
                    stringBuffer2.append(stringArray2[0]);
                }
                ((StringBuffer)charSequence).append(" OR (" + stringBuffer2.toString() + " IS NULL)");
            }
            ((StringBuffer)charSequence).append(")");
            stringBuffer.append(string6).append("\n");
            stringBuffer.append(string7).append("\n");
            stringBuffer.append(((StringBuffer)charSequence).toString());
        }
        return stringBuffer.toString();
    }
}

