/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintEngine;
import oracle.spatial.rdf.server.HintEngineAdapter;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.HintZeroHintGenerator;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.OrderCond;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SelectExpression;
import oracle.spatial.rdf.server.SimpleSPARQLTreeNode;
import oracle.spatial.rdf.server.TranslateEngine;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.SparqlSelectDescriptor;
import oracle.spatial.rdf.server.parser.sparql.SparqlSolnModDesc;
import oracle.spatial.rdf.server.parser.sparql.SparqlSourceDescriptor;

public class SelectSPARQLTreeNode
extends AbstractSPARQLTreeNode
implements SPARQLTreeNode {
    private static final int[] ID_ONLY_VEC = new int[]{0, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] ALL_BUT_CLOB_VEC = new int[]{1, 1, 1, 1, 1, 0, 1, 1, 1};
    private static final int[] ALL_COLUMN_VEC = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int ID_COL_IDX = 1;
    private static final int PREFIX_COL_IDX = 2;
    private static final int CLOB_COL_IDX = 5;
    private static final String[] COMPONENT_FUNCS = new String[]{"MDSYS.SDO_RDF.VNAME", "", "MDSYS.SDO_RDF.VNPFX", "MDSYS.SDO_RDF.VNSFX", "MDSYS.SDO_RDF.VTYPE", "", "MDSYS.SDO_RDF.LTYPE", "MDSYS.SDO_RDF.LATAG"};
    private static final String[] COMPONENT_FUNCS_VPROJ = new String[]{"", "MDSYS.SDO_RDF.VNAME", "MDSYS.SDO_RDF.VTYPE", "MDSYS.SDO_RDF.VNPFX", "MDSYS.SDO_RDF.VNSFX", "MDSYS.SDO_RDF.LTYPE", "MDSYS.SDO_RDF.LATAG", ""};
    private SparqlSelectDescriptor selDesc;
    private SparqlSourceDescriptor sourceDesc;
    private SparqlSolnModDesc solnMod;
    private boolean orderByExists = false;
    private boolean distinctExists = false;
    private boolean limitExists = false;
    private boolean offsetExists = false;
    private boolean rdfTermsOnly = false;
    private boolean plusRDFTerms = false;
    private boolean rowNumProjected = false;
    private boolean groupByExists = false;
    private boolean havingExist = false;
    private boolean aggregateExist = false;
    private Set<String> pushedVars;
    private Set<String> definedVars;
    private Set<String> topProjVars;
    private int[][] varProjVectors;
    Set<String> myDefBoundVars = null;

    public SelectSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2, SparqlSelectDescriptor sparqlSelectDescriptor, SparqlSourceDescriptor sparqlSourceDescriptor, SparqlSolnModDesc sparqlSolnModDesc, boolean bl, boolean bl2) {
        super(n, sQLGenContext, n2);
        this.selDesc = sparqlSelectDescriptor;
        this.sourceDesc = sparqlSourceDescriptor;
        this.solnMod = sparqlSolnModDesc;
        this.selDesc.initExpressions(sQLGenContext);
        this.solnMod.initExpressions(sQLGenContext);
        this.rdfTermsOnly = bl;
        this.plusRDFTerms = bl2;
        this.orderByExists = false;
        this.distinctExists = false;
        this.limitExists = false;
        this.offsetExists = false;
        this.rowNumProjected = false;
        this.groupByExists = false;
        this.havingExist = false;
        this.aggregateExist = false;
        this.definedVars = new HashSet<String>();
        this.pushedVars = new HashSet<String>();
        this.myDefBoundVars = null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsEmptyBGP() {
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            if (!sPARQLTreeNode.containsEmptyBGP()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pushBGP(SPARQLBGP sPARQLBGP, String string) {
    }

    @Override
    public boolean needsParentBGPPushDown() {
        return false;
    }

    @Override
    public Set<String> getCumulativeVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.selDesc.selectAllVars()) {
            for (SPARQLTreeNode sPARQLTreeNode : this.children) {
                if (sPARQLTreeNode.getType() == 2) continue;
                hashSet.addAll(sPARQLTreeNode.getCumulativeVars());
            }
            hashSet.addAll(this.myBGP.getBGPVars());
        } else {
            for (SelectExpression selectExpression : this.selDesc.getSelectExpressions()) {
                String string = selectExpression.getVarStr();
                if (string.startsWith("A$")) continue;
                hashSet.add(string);
            }
        }
        if (this.graphQuery && this.activeGraph.type == 0) {
            if (this.unmaskGraph) {
                hashSet.remove(this.activeGraph.name);
                hashSet.add(QueryUtils.unMaskVar(this.activeGraph.name));
            } else {
                hashSet.add(this.activeGraph.name);
            }
        }
        return hashSet;
    }

    @Override
    public Set<String> getCumulativeAndPushedVars() {
        return this.getCumulativeVars();
    }

    @Override
    public Set<String> getPushCandidates() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : this.myFilters) {
            if (this.ctx.aggValPushDown || !this.distinctExists && !this.groupByExists) {
                hashSet.addAll(((Filter)object).getfJoinVars());
            }
            hashSet.addAll(((Filter)object).getBindVars());
        }
        if (this.ctx.aggValPushDown || !this.distinctExists && !this.groupByExists) {
            for (Object object : this.children) {
                hashSet.addAll(object.getPushCandidates());
            }
        }
        hashSet.addAll(this.getCumulativeBindVars());
        return hashSet;
    }

    @Override
    public Set<String> getDefiniteBoundVars() {
        Object object;
        if (this.myDefBoundVars != null) {
            return this.myDefBoundVars;
        }
        this.myDefBoundVars = new HashSet<String>();
        boolean bl = false;
        if (!this.selDesc.containsAggregate() || this.ctx.disableNullExprJoin) {
            bl = true;
            this.myDefBoundVars.addAll(this.myBGP.getDefiniteBoundVars());
            for (int i = 0; i < this.getNumChildren(); ++i) {
                object = this.getChild(i);
                if (object.getType() != 0) continue;
                this.myDefBoundVars.addAll(object.getDefiniteBoundVars());
            }
        }
        HintGenerator hintGenerator = this.ctx.useOldHintGenerator ? new HintZeroHintGenerator(this.ctx, true) : new HintEngineAdapter(HintEngine.getDefaultInstance(), this.ctx);
        hintGenerator.setSPARQLBGP(this.myBGP);
        for (SelectExpression object2 : this.selDesc.getSelectExpressions()) {
            if (!this.ctx.disableNullExprJoin && !object2.isDefBound(hintGenerator)) continue;
            bl = true;
            this.myDefBoundVars.add(object2.getVarStr());
        }
        object = this.selDesc.getVarComments();
        for (String string : this.selDesc.getSelectList()) {
            if (!object.containsKey(string)) continue;
            hintGenerator.setUserHint(QueryUtils.extractHint0Contents(object.get(string)));
            hintGenerator.generateHint();
            Map<Hint.QueryOption, String> map = hintGenerator.getQueryOptions();
            if (!map.containsKey((Object)Hint.QueryOption.DEF_NON_NULL)) continue;
            this.myDefBoundVars.add(string);
            bl = true;
        }
        if (bl) {
            this.myDefBoundVars = QueryUtils.getCommonVars(this.myDefBoundVars, this.getCumulativeVars());
        }
        return this.myDefBoundVars;
    }

    @Override
    public Set<String> getDefiniteBoundAndPushedVars() {
        return this.getDefiniteBoundVars();
    }

    @Override
    public Set<String> getRequiredLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.myBGP != null) {
            hashSet.addAll(this.myBGP.getRequiredLexVars());
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            hashSet.addAll(this.getChild(i).getRequiredLexVars());
        }
        if (this.selDesc.containsExpression()) {
            for (SelectExpression object : this.selDesc.getSelectExpressions()) {
                if (object.getExpr() == null || object.isBindSpecialCase()) continue;
                hashSet.add(object.getVarStr());
                hashSet.addAll(object.getExpr().getRequiredLexVars());
            }
        }
        for (Filter filter : this.myFilters) {
            hashSet.addAll(filter.getRequiredLexVars());
        }
        return hashSet;
    }

    @Override
    public Set<String> getCumulativeBindVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.myBGP != null) {
            hashSet.addAll(this.myBGP.getBindVars());
        }
        for (SPARQLTreeNode object : this.children) {
            hashSet.addAll(object.getCumulativeBindVars());
        }
        for (SelectExpression selectExpression : this.selDesc.getSelectExpressions()) {
            if (!selectExpression.isBindSpecialCase()) continue;
            hashSet.add(selectExpression.getVarStr());
        }
        return hashSet;
    }

    @Override
    public void propagateLexVars() throws RDFException {
        Set<String> set = this.getAllLexVars();
        for (Filter filter : this.getAllFilters()) {
            filter.setLexVars(set);
        }
        this.selDesc.setLexVars(set);
        this.solnMod.setLexVars(set);
        Object object = null;
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            object = this.getChild(i);
            object.propagateLexVars();
        }
    }

    @Override
    public void setProjections() throws RDFException {
        this.setQueryFlags();
        this.definedVars.addAll(this.getDefinedVars());
        this.buildVarProjVectors();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.topProjVars);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.addAll(this.definedVars);
        hashSet2.addAll(this.selDesc.getSelectList());
        this.solnMod.setInScopeVars(hashSet2);
        this.solnMod.setDefBoundVars(this.getDefiniteBoundVars());
        this.solnMod.prepareExpressions();
        this.selDesc.prepareExpressions();
        hashSet.addAll(this.solnMod.getVars());
        hashSet.addAll(this.selDesc.getJoinVars());
        hashSet.addAll(this.getAllLexVars());
        this.extractVarsToPush(hashSet);
        this.solnMod.validateFilters();
        this.selDesc.validateFilters();
        if (this.getNumChildren() == 1) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(0);
            sPARQLTreeNode.addProjectVars(this.pushedVars);
            sPARQLTreeNode.setProjections();
        }
    }

    @Override
    public String toSQL() throws RDFException {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "";
        SPARQLTreeNode sPARQLTreeNode = null;
        int n = -1;
        int n2 = -1;
        boolean bl2 = false;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.getNumChildren() == 1) {
            sPARQLTreeNode = this.getChild(0);
            if (!(!this.limitExists || this.distinctExists || this.orderByExists || this.selDesc.containsAggregate() || this.groupByExists || this.havingExist || this.graphQuery && this.unmaskGraph || this.graphQuery && this.activeGraph.type == 0 || !(sPARQLTreeNode instanceof SimpleSPARQLTreeNode))) {
                n = this.solnMod.getLimit();
                n2 = this.solnMod.getOffset();
                if (n >= 0 && n2 >= 0) {
                    n += n2;
                }
                sPARQLTreeNode.setLimit(n);
                bl2 = true;
            }
            string = sPARQLTreeNode.toSQL();
            hashSet.addAll(sPARQLTreeNode.getDefiniteBoundVars());
        } else if (this.getNumChildren() == 0) {
            string = "SELECT NULL FROM DUAL";
        } else {
            throw new RDFException("Syntax Tree Error: ASTSelectQuery with more than one child");
        }
        if (this.selDesc.containsAggregate() || this.groupByExists || this.havingExist) {
            string = this.wrapForGrouping(string, hashSet);
        } else if (this.selDesc.containsExpression()) {
            string = this.wrapSelectExpressions(string, hashSet);
        }
        if (this.orderByExists || this.offsetExists || this.limitExists && !bl2) {
            bl = !this.needResort() && !this.isNGLimitSpecialCase();
            string = this.wrapForSPARQLOrderBy(string, hashSet, bl);
            this.rowNumProjected = true;
        }
        if (this.distinctExists) {
            string = this.wrapForSPARQLDistinct(string);
        }
        if (this.needResort()) {
            string = this.wrapForReSort(string);
        }
        bl = false;
        if (this.isNGLimitSpecialCase()) {
            string = this.wrapForLimitOffset(string, bl2);
            bl = true;
        }
        if (this.graphQuery && this.unmaskGraph) {
            string = this.wrapForGraphUnMask(string, hashSet);
        }
        Set<String> set = this.topProjVars;
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String object2 : set) {
            if (!this.definedVars.contains(object2) || this.pushedVars.contains(object2)) continue;
            hashSet2.add(object2);
        }
        HashMap hashMap = new HashMap();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        if (!hashSet2.isEmpty() && sPARQLTreeNode != null) {
            sPARQLTreeNode.genOuterSelectComponents(hashSet2, hashSet, hashMap, stringArray, stringArray2, hashMap2);
        }
        String string2 = this.buildWithForBind();
        stringBuffer.append(string2);
        String string3 = this.buildFinalValueJoinHint(hashMap2.values());
        stringBuffer.append("SELECT ").append(string3).append(" ");
        stringBuffer.append(this.buildFinalSelect(hashSet2, hashMap)).append("\n");
        stringBuffer.append("FROM (").append(string).append(") R").append(stringArray[0]).append("\n");
        stringBuffer.append("WHERE (1=1) ").append(stringArray2[0]);
        if (!bl && (this.limitExists || this.offsetExists)) {
            n = this.solnMod.getLimit();
            n2 = this.solnMod.getOffset();
            if (n2 >= 0) {
                stringBuffer.append(" AND R.SEM$ROWNUM > ").append(n2);
            }
            if (n >= 0 && !bl2) {
                stringBuffer.append(" AND ROWNUM <= ").append(n);
            }
        }
        if (this.ctx.unescapeResults && this.selDesc.getIsTopSelect()) {
            stringBuffer = new StringBuffer(this.wrapForUnescape(stringBuffer.toString(), this.selDesc.getSelectList(), "SEM$ROWNUM", false));
        }
        if (this.ctx.isPGQuery && this.selDesc.getIsTopSelect()) {
            stringBuffer = new StringBuffer(this.wrapForPGProjection(stringBuffer.toString(), this.selDesc.getSelectList(), "SEM$ROWNUM"));
        }
        return stringBuffer.toString();
    }

    private String wrapForPGProjection(String string, List<String> list, String string2) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string3 = "SELECT ";
        Set<String> set = this.getAllLexVars();
        stringBuffer.append(string3);
        for (String string4 : list) {
            String string5 = "";
            string5 = set.contains(string4) && this.ctx.vcTerms ? this.serializePGVariable(string4 + this.term_alias) : this.serializedPGVariable(string4, string4 + this.vtype_alias, string4 + this.prefix_alias, string4 + this.suffix_alias, string4 + this.litType_alias, string4 + this.langType_alias);
            stringBuffer.append("\n").append(string5).append(" as ");
            stringBuffer.append(string4).append("").append(",");
        }
        stringBuffer.append("\n").append(string2).append(" as ").append("PG$ROWNUM").append("\n");
        stringBuffer.append(" FROM (");
        stringBuffer.append(string);
        stringBuffer.append(") R");
        stringBuffer.append("\n");
        stringBuffer.append("WHERE (1=1)");
        return stringBuffer.toString();
    }

    private String serializePGVariable(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("(CASE\n");
        stringBuffer.append("WHEN (" + string + " IS NULL)\n");
        stringBuffer.append("THEN NULL\n");
        stringBuffer.append("WHEN (substr(" + string + ",1,1) IN ('_','\"'))\n");
        stringBuffer.append("THEN " + string + "\n");
        stringBuffer.append("WHEN (substr(" + string + ",1," + ("http://xmlns.oracle.com/pg/vertex/".length() + 1) + ") = '<" + "http://xmlns.oracle.com/pg/vertex/" + "')\n");
        stringBuffer.append("THEN 'vertex:'||substr(" + string + "," + ("http://xmlns.oracle.com/pg/vertex/".length() + 2) + ",(length(" + string + ")-" + ("http://xmlns.oracle.com/pg/vertex/".length() + 2) + "))\n");
        stringBuffer.append("WHEN (substr(" + string + ",1," + ("http://xmlns.oracle.com/pg/edge/".length() + 1) + ") = '<" + "http://xmlns.oracle.com/pg/edge/" + "')\n");
        stringBuffer.append("THEN 'edge:'||substr(" + string + "," + ("http://xmlns.oracle.com/pg/edge/".length() + 2) + ",(length(" + string + ")-" + ("http://xmlns.oracle.com/pg/edge/".length() + 2) + "))\n");
        stringBuffer.append("WHEN (substr(" + string + ",1," + ("http://xmlns.oracle.com/pg/label/".length() + 1) + ") = '<" + "http://xmlns.oracle.com/pg/label/" + "')\n");
        stringBuffer.append("THEN 'label:'||substr(" + string + "," + ("http://xmlns.oracle.com/pg/label/".length() + 2) + ",(length(" + string + ")-" + ("http://xmlns.oracle.com/pg/label/".length() + 2) + "))\n");
        stringBuffer.append("WHEN (substr(" + string + ",1," + ("http://xmlns.oracle.com/pg/property/vertex/".length() + 1) + ") = '<" + "http://xmlns.oracle.com/pg/property/vertex/" + "')\n");
        stringBuffer.append("THEN 'vertexProperty:'||substr(" + string + "," + ("http://xmlns.oracle.com/pg/property/vertex/".length() + 2) + ",(length(" + string + ")-" + ("http://xmlns.oracle.com/pg/property/vertex/".length() + 2) + "))\n");
        stringBuffer.append("WHEN (substr(" + string + ",1," + ("http://xmlns.oracle.com/pg/property/edge/".length() + 1) + ") = '<" + "http://xmlns.oracle.com/pg/property/edge/" + "')\n");
        stringBuffer.append("THEN 'edgeProperty:'||substr(" + string + "," + ("http://xmlns.oracle.com/pg/property/edge/".length() + 2) + ",(length(" + string + ")-" + ("http://xmlns.oracle.com/pg/property/edge/".length() + 2) + "))\n");
        stringBuffer.append("ELSE " + string + "\n");
        stringBuffer.append("END)");
        return stringBuffer.toString();
    }

    private String serializedPGVariable(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer("(CASE WHEN ");
        stringBuffer.append(string2).append(" IS NULL THEN NULL");
        stringBuffer.append("\nWHEN ").append(string2).append(" IN ('UR','URI') THEN");
        stringBuffer.append(" DECODE(").append(string3).append(",");
        stringBuffer.append("'").append("http://xmlns.oracle.com/pg/vertex/").append("','vertex:'||").append(string4).append(",");
        stringBuffer.append("'").append("http://xmlns.oracle.com/pg/edge/").append("','edge:'||").append(string4).append(",");
        stringBuffer.append("'").append("http://xmlns.oracle.com/pg/label/").append("','label:'||").append(string4).append(",");
        stringBuffer.append("'").append("http://xmlns.oracle.com/pg/property/vertex/").append("','vertexProperty:'||").append(string4).append(",");
        stringBuffer.append("'").append("http://xmlns.oracle.com/pg/property/edge/").append("','edgeProperty:'||").append(string4).append(",");
        stringBuffer.append("'<'||").append(string3).append("||").append(string4).append("||'>'").append(")");
        stringBuffer.append("\nWHEN ").append(string2).append(" IN ('BN','BLN') THEN ").append(string3);
        stringBuffer.append("\nELSE '\"'||").append(string).append("||'\"'||(CASE ");
        stringBuffer.append(" WHEN ").append(string5).append(" IS NOT NULL THEN '^^<'||");
        stringBuffer.append(string5).append("||'>'");
        stringBuffer.append(" WHEN ").append(string6).append(" IS NOT NULL THEN '@'||").append(string6);
        stringBuffer.append(" ELSE '' END)");
        stringBuffer.append(" END)");
        return stringBuffer.toString();
    }

    private void setQueryFlags() {
        if (this.selDesc.getSelectModifier() == 1) {
            this.distinctExists = true;
        }
        if (this.solnMod.solnModExists()) {
            if (!this.solnMod.getOrderConds().isEmpty()) {
                this.orderByExists = true;
            }
            if (this.solnMod.hasLimit()) {
                this.limitExists = true;
            }
            if (this.solnMod.hasOffset()) {
                this.offsetExists = true;
            }
            if (this.solnMod.hasGroupBy()) {
                this.groupByExists = true;
            }
            if (this.solnMod.hasHaving()) {
                this.havingExist = true;
            }
        }
    }

    private Set<String> getDefinedVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.getNumChildren() == 1) {
            hashSet.addAll(this.getChild(0).getCumulativeVars());
        }
        if (this.activeGraph != null && this.activeGraph.type == 73) {
            hashSet.add(this.activeGraph.name);
        }
        return hashSet;
    }

    private void validateSelectExpressions() throws RDFException {
        Set<String> set;
        if (this.selDesc.containsAggregate() || this.groupByExists) {
            set = this.solnMod.getGroupByVars();
            for (SelectExpression selectExpression : this.selDesc.getSelectExpressions()) {
                if (selectExpression.containsAggregate() || selectExpression.containsBooleanSpecialNode()) continue;
                if (selectExpression.getExpr() != null) {
                    throw new RDFException("Only aggregate expressions  allowed in SELECT clause");
                }
                if (set != null && set.contains(selectExpression.getVarStr())) continue;
                throw new RDFException("Variable ?" + selectExpression.getVarStr() + " is not a GROUP BY variable");
            }
        }
        if (this.selDesc.containsExpression()) {
            set = new HashSet<String>();
            if (this.getNumChildren() == 1) {
                set.addAll(this.getChild(0).getCumulativeVars());
            }
            for (SelectExpression selectExpression : this.selDesc.getSelectExpressions()) {
                if (selectExpression.getExpr() == null) continue;
                this.validateExpression(selectExpression, set, "SELECT expression");
                set.add(selectExpression.getVarStr());
            }
        }
    }

    private void validateGrouping() throws RDFException {
        this.validateSelectExpressions();
        HashSet<String> hashSet = new HashSet<String>();
        if (this.getNumChildren() == 1) {
            hashSet.addAll(this.getChild(0).getCumulativeVars());
        }
        for (SelectExpression object3 : this.solnMod.getGroupByConds()) {
            this.validateExpression(object3, hashSet, "GROUP BY");
        }
        if (this.havingExist) {
            Filter filter = this.solnMod.getHavingConds();
            Set<String> set = filter.getVars();
            if (!(OptimizerUtils.containsNodeType(filter.getFilterTree(), 89) || OptimizerUtils.containsUserDefinedOrSpatialAggregate(filter.getFilterTree()) || OptimizerUtils.containsNodeType(filter.getFilterTree(), -1))) {
                Set<String> set2 = this.solnMod.getGroupByVars();
                for (String string : set) {
                    if (set2.contains(string)) continue;
                    throw new RDFException("HAVING variable ?" + string + " is not a GROUP BY variable");
                }
            }
            for (Object object : set) {
                if (hashSet.contains(object)) continue;
                throw new RDFException("HAVING variable ?" + (String)object + " is undefined");
            }
        }
    }

    private void validateExpression(SelectExpression selectExpression, Set<String> set, String string) throws RDFException {
        for (String string2 : selectExpression.getVars()) {
            if (set.contains(string2)) continue;
            throw new RDFException(string + " variable ?" + string2 + " is undefined");
        }
        String string3 = selectExpression.getVarStr();
        if (selectExpression.getExpr() != null) {
            if (string3 != null && set.contains(string3)) {
                throw new RDFException("Alias ?" + (String)string3 + " is already defined");
            }
        } else if (string3 != null && !set.contains(string3)) {
            throw new RDFException(string + " variable ?" + (String)string3 + " is undefined");
        }
    }

    private void extractVarsToPush(Set<String> set) {
        Set<String> set2;
        if (this.getNumChildren() > 0 && (set2 = this.getChild(0).getCumulativeVars()).size() > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(this.getPushCandidates());
            hashSet.addAll(this.getAllLexVars());
            for (String string : set2) {
                if (!set.contains(string) || !hashSet.contains(string)) continue;
                this.pushedVars.add(string);
            }
        }
    }

    private void buildVarProjVectors() {
        int n;
        int n2;
        int n3 = 8;
        int n4 = 1;
        if (this.plusRDFTerms) {
            n3 = 9;
        } else if (this.rdfTermsOnly) {
            n3 = 2;
            n4 = 0;
        }
        int n5 = this.selDesc.getSelectList().size();
        int n6 = n3 * n5;
        this.varProjVectors = new int[n5][n3];
        this.topProjVars = new HashSet<String>();
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n3; ++n) {
                this.varProjVectors[n2][n] = 0;
            }
        }
        if (this.selDesc.getIsTopSelect()) {
            if (this.ctx.isPGQuery) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n3 - 1; ++n) {
                        if (n == n4) continue;
                        this.varProjVectors[n2][n] = 1;
                        this.topProjVars.add(this.selDesc.getSelectList().get(n2));
                    }
                }
            } else {
                for (n2 = 0; n2 < this.ctx.pIDs.length; ++n2) {
                    n = this.ctx.pIDs[n2];
                    if (n >= n6) continue;
                    this.varProjVectors[n / n3][n % n3] = 1;
                    if (n % n3 == n4) continue;
                    this.topProjVars.add(this.selDesc.getSelectList().get(n / n3));
                }
            }
        } else {
            this.topProjVars.addAll(this.getProjectVars());
        }
    }

    @Override
    protected String buildFinalValueJoinHint(Collection<String> collection) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.selDesc.getIsTopSelect()) {
            if (!this.ctx.disableNoMerge) {
                stringBuffer.append(TranslateEngine.DEFAULT_Q_HINT);
            }
            if (!this.ctx.disableNoSwap) {
                stringBuffer.append(" ").append(TranslateEngine.NO_SWAP_HINT);
            }
        } else {
            if (this.ctx.enableSubNoMerge) {
                stringBuffer.append(TranslateEngine.DEFAULT_Q_HINT);
            }
            if (this.ctx.enableSubNoSwap) {
                stringBuffer.append(" ").append(TranslateEngine.NO_SWAP_HINT);
            }
        }
        if (!collection.isEmpty()) {
            if ((this.ctx.finalValJoinFlag & (1 | 2)) > 0) {
                Object object = "";
                object = (this.ctx.finalValJoinFlag & 1) > 0 ? " USE_HASH" : " USE_NL";
                stringBuffer.append(" ").append((String)object).append("(");
                for (String string : collection) {
                    stringBuffer.append(string).append(" ");
                }
                stringBuffer.append(")");
            }
        }
        if (!collection.isEmpty()) {
            if ((this.ctx.finalValJoinFlag & 4) > 0) {
                for (String string : collection) {
                    stringBuffer.append(" NO_INDEX(").append(string).append(")");
                }
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "/*+ ");
            stringBuffer.append(" */");
        }
        return stringBuffer.toString();
    }

    private String buildFinalSelect(Set<String> set, Map<String, List<String>> map) {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        boolean bl2 = this.selDesc.getIsTopSelect();
        if (this.ctx.vcTerms) {
            bl2 = false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.selDesc.getSelectList());
        if (this.graphQuery && this.activeGraph.type == 0) {
            String string = this.activeGraph.name.toUpperCase();
            if (this.unmaskGraph) {
                string = QueryUtils.unMaskVar(string);
            }
            if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
        }
        boolean bl3 = this.rdfTermsOnly && this.selDesc.getIsTopSelect();
        int n = 8;
        if (bl3) {
            n = 1;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        Set<String> set2 = this.getAllLexVars();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (string.startsWith("A$")) continue;
            bl4 = this.rdfTermsOnly || this.plusRDFTerms;
            bl5 = set2.contains(string);
            if (bl) {
                stringBuffer.append(",\n");
            }
            if (this.definedVars.contains(string)) {
                if (this.topProjVars.contains(string)) {
                    int[] nArray = new int[9];
                    if (!this.selDesc.getIsTopSelect()) {
                        nArray = ALL_COLUMN_VEC;
                        bl4 = bl5;
                    } else {
                        nArray = this.ctx.isPGQuery ? ALL_COLUMN_VEC : this.varProjVectors[i];
                    }
                    stringBuffer.append(this.buildTopSelectForVar("R", string, map, set, bl3, nArray, bl4, bl4 && nArray[n] == 0, bl2, bl5, false, "", "", false, this.ctx.hashVids));
                } else {
                    stringBuffer.append(this.buildTopSelectForVar("R", string, map, set, bl3, ID_ONLY_VEC, bl4, true, bl2, bl5, false, "", "", false, this.ctx.hashVids));
                }
            } else {
                bl4 = bl4 || bl5 && !this.selDesc.getIsTopSelect();
                stringBuffer.append(this.buildNullSelectForVar(string, bl3, bl4));
            }
            bl = true;
        }
        if (this.selDesc.getIsTopSelect()) {
            String string = "1";
            if (this.ctx.disableRowNumOpt) {
                string = "ROWNUM";
            }
            if (this.rowNumProjected) {
                string = "R.SEM$ROWNUM";
            }
            if (bl) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append(string).append(" AS SEM$ROWNUM");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("NULL");
        }
        return stringBuffer.toString();
    }

    private String wrapForGraphUnMask(String string, Set<String> set) {
        Set<String> set2;
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = QueryUtils.unMaskVar(this.activeGraph.name);
        String string3 = this.activeGraph.name;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.definedVars.contains(string2) && this.definedVars.contains(string3)) {
            if (this.pushedVars.contains(string2) && !this.pushedVars.contains(string3)) {
                hashSet.add(string3);
            } else if (!this.pushedVars.contains(string2) && this.pushedVars.contains(string3)) {
                hashSet.add(string2);
            }
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        SPARQLTreeNode sPARQLTreeNode = this.getChild(0);
        if (!hashSet.isEmpty() && sPARQLTreeNode != null) {
            sPARQLTreeNode.genOuterSelectComponents(hashSet, set, hashMap, stringArray, stringArray2, hashMap2);
        }
        String string4 = this.buildFinalValueJoinHint(hashMap2.values());
        boolean bl = false;
        if (this.selDesc.getSelectList().contains(string2)) {
            bl = true;
        }
        boolean bl2 = (set2 = this.getAllLexVars()).contains(string2) || set2.contains(string3);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add(string2);
        hashSet2.add(string3);
        String string5 = "ROWNUM";
        if (this.rowNumProjected) {
            string5 = "SEM$ROWNUM";
        }
        String[] stringArray3 = new String[]{""};
        String string6 = this.buildValJoinSelect(this.definedVars, hashSet, hashMap, string5, hashSet2, null, null);
        string6 = string6 + ",\n";
        string6 = string6 + this.buildUnMaskForVar("R", string2, hashMap, hashSet, bl2, bl, stringArray3);
        stringBuffer.append("SELECT ").append(string4).append(" ");
        stringBuffer.append(string6).append("\n");
        stringBuffer.append("FROM (\n").append(string).append(") R");
        stringBuffer.append(stringArray[0]).append("\n");
        stringBuffer.append("WHERE (1=1) ").append(stringArray2[0]).append(stringArray3[0]);
        this.pushedVars.addAll(hashSet);
        if (this.pushedVars.contains(string3)) {
            this.pushedVars.add(string2);
        }
        this.definedVars.add(string2);
        this.definedVars.remove(string3);
        return stringBuffer.toString();
    }

    private String buildValJoinSelect(Set<String> set, Set<String> set2, Map<String, List<String>> map, String string, Set<String> set3, Set<String> set4, Set<String> set5) {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        Set<String> set6 = this.getAllLexVars();
        boolean bl2 = false;
        String string2 = "";
        String string3 = "";
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (set4 != null) {
            bl5 = true;
            string2 = "MIN(";
            string3 = ")";
        }
        for (String string4 : set) {
            Object object;
            if (set3 != null && set3.contains(string4)) continue;
            bl3 = false;
            if (set4 != null && set4.contains(string4)) {
                bl3 = true;
            }
            bl4 = false;
            if (set5 != null && set5.contains(string4)) {
                bl4 = true;
            }
            if (bl) {
                stringBuffer.append(",\n");
            }
            if (this.pushedVars.contains(string4) || set2.contains(string4)) {
                bl2 = set6.contains(string4);
                object = ALL_COLUMN_VEC;
                stringBuffer.append(this.buildTopSelectForVar("R", string4, map, set2, false, (int[])object, bl2, false, false, bl2, bl3, string2, string3, bl4, false));
                bl = true;
                continue;
            }
            object = "R." + string4 + this.finalCols[1];
            if (!bl3) {
                object = bl5 ? (Object)this.buildNullValueForVar(1, 1, 5) : (Object)(string2 + (String)object + string3);
            }
            stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, (String)object, string4 + this.finalCols[1]));
            bl = true;
        }
        if (string != null) {
            if (bl) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append(string + " AS SEM$ROWNUM");
            bl = true;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("NULL");
        }
        return stringBuffer.toString();
    }

    private String buildTopSelectForVar(String string, String string2, Map<String, List<String>> map, Set<String> set, boolean bl, int[] nArray, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string3, String string4, boolean bl7, boolean bl8) {
        int n;
        List<String> list;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        int n3 = 8;
        boolean bl9 = false;
        boolean bl10 = false;
        if (string3 != null && string3.length() > 0) {
            bl10 = true;
        }
        if (bl) {
            n2 = 1;
            n3 = 2;
        }
        String string5 = this.buildRDFTForVar(string, string2, map, false, false, false, true);
        if (set.contains(string2)) {
            list = map.get(string2);
        } else {
            list = new ArrayList<String>(8);
            for (n = 0; n < 8; ++n) {
                if (n == 1 && bl5 && bl8) {
                    list.add(QueryUtils.buildVidHash(string5));
                    continue;
                }
                list.add(string + "." + string2 + this.finalCols[n]);
            }
        }
        for (n = n2; n < n3; ++n) {
            String string6;
            if (n != 5) {
                string6 = list.get(n);
                if (!bl && nArray[n] <= 0) {
                    string6 = this.buildNullValueForVar(n, 1, 5);
                }
                if (!(bl7 || bl6 && !bl5 && n == 1)) {
                    string6 = bl10 && !bl6 ? this.buildNullValueForVar(n, 1, 5) : (bl5 && string3 != null && string3.length() > 0 ? (n == 1 ? "NULL" : COMPONENT_FUNCS[n] + "(" + string5 + ")") : string3 + string6 + string4);
                }
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string6, string2 + this.finalCols[n]), ", ", "");
                continue;
            }
            if (bl) continue;
            string6 = this.buildNullValueForVar(n, 1, 5);
            if (nArray[n] > 0) {
                string6 = list.get(5);
                if (!string3.equals("") && !bl7) {
                    bl9 = true;
                    if (!bl6 || bl5 || !this.ctx.clobAggSupport) {
                        string6 = this.buildNullValueForVar(n, 1, 5);
                    } else {
                        String string7 = list.get(1);
                        String string8 = list.get(2);
                        if (!bl6 || bl5) {
                            string7 = string3 + string7 + string4;
                        }
                        string8 = string3 + string8 + string4;
                        string6 = this.buildSubQForCLOB(string2, string7, string8);
                    }
                }
            }
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string6, string2 + this.finalCols[n]), ", ", "");
        }
        if (bl2) {
            stringBuffer.append(",\n");
            if (bl3) {
                stringBuffer.append(this.buildNullRDFTForVar(string2));
            } else {
                String string9 = "";
                string9 = bl6 && !this.ctx.useExactForExpr ? this.buildCanonRDFTForVar("R", string2, map, bl4, !this.pushedVars.contains(string2), bl9, bl5) : this.buildRDFTForVar("R", string2, map, bl4, !this.pushedVars.contains(string2), bl9, bl5);
                if (!(bl7 || bl6 && bl5)) {
                    string9 = bl10 && !bl6 ? "NULL" : string3 + string9 + string4;
                }
                stringBuffer.append(QueryUtils.buildAliasExpr(this.ctx, string9, string2 + this.term_alias));
            }
        }
        return stringBuffer.toString();
    }

    private String buildUnMaskForVar(String string, String string2, Map<String, List<String>> map, Set<String> set, boolean bl, boolean bl2, String[] stringArray) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        String string3 = QueryUtils.maskVar((String)string2).name;
        boolean bl3 = this.definedVars.contains(string2);
        List<String> list = null;
        List<Object> list2 = null;
        boolean bl4 = false;
        if (this.pushedVars.contains(string2) || this.pushedVars.contains(string3)) {
            if (set.contains(string2)) {
                list = map.get(string2);
            } else {
                list = new ArrayList<String>(9);
                for (n2 = 0; n2 < 8; ++n2) {
                    if (bl3) {
                        list.add(string + "." + string2 + this.finalCols[n2]);
                        continue;
                    }
                    if (n2 == 1) {
                        list.add("TO_NUMBER(NULL)");
                        continue;
                    }
                    list.add("NULL");
                }
            }
            list.add(this.buildRDFTForVar(string, string2, map, false, set.contains(string2), false, false));
            if (set.contains(string3)) {
                list2 = map.get(string3);
            } else {
                list2 = new ArrayList(9);
                for (n2 = 0; n2 < 8; ++n2) {
                    list2.add(string + "." + string3 + this.finalCols[n2]);
                }
            }
            list2.add(this.buildRDFTForVar(string, string3, map, false, set.contains(string3), false, false));
        } else {
            list = new ArrayList<String>(9);
            list2 = new ArrayList<String>(9);
            for (n2 = 0; n2 < 9; ++n2) {
                if (n2 == 1) {
                    if (bl3) {
                        list.add(string + "." + string2 + this.finalCols[n2]);
                    } else {
                        list.add("TO_NUMBER(NULL)");
                    }
                    list2.add(string + "." + string3 + this.finalCols[n2]);
                    continue;
                }
                list.add("NULL");
                list2.add("NULL");
            }
        }
        if (bl) {
            list.remove(1);
            list.add(1, "TO_NUMBER(NULL)");
            list2.remove(1);
            list2.add(1, "TO_NUMBER(NULL)");
        }
        n2 = 0;
        int n3 = 8;
        if (!this.pushedVars.contains(string2) && !this.pushedVars.contains(string3)) {
            n2 = 1;
            n3 = 2;
        }
        String string4 = "";
        for (n = n2; n < n3; ++n) {
            string4 = bl2 ? "COALESCE(" + list.get(n) + "," + (String)list2.get(n) + ")" : (String)list2.get(n);
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string4, string2 + this.finalCols[n]), ", ", "");
        }
        if (bl) {
            string4 = bl2 ? "COALESCE(" + list.get(8) + "," + (String)list2.get(8) + ")" : (String)list2.get(8);
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string4, string2 + this.term_alias), ", ", "");
        }
        if (bl2) {
            n = 1;
            String string5 = "0";
            if (bl) {
                n = 8;
                string5 = "'RDF$NULL'";
            }
            stringArray[0] = "AND (COALESCE(" + (String)list2.get(n) + "," + list.get(n) + "," + string5 + ") = " + "COALESCE(" + list.get(n) + "," + (String)list2.get(n) + "," + string5 + "))";
        }
        return stringBuffer.toString();
    }

    private String buildNullSelectForVar(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        int n2 = 8;
        if (bl) {
            n = 1;
            n2 = 2;
        }
        for (int i = n; i < n2; ++i) {
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.buildNullValueForVar(i, 1, 5), string + this.finalCols[i]), ", ", "");
        }
        if (bl2) {
            stringBuffer.append(",\n");
            stringBuffer.append(this.buildNullRDFTForVar(string));
        }
        return stringBuffer.toString();
    }

    private String buildNullRDFTForVar(String string) {
        return QueryUtils.buildAliasExpr(this.ctx, "NULL", string + this.term_alias);
    }

    private String buildWrapperSelect(Set<String> set, String string, Set<String> set2) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        String string3 = "";
        if (set != null) {
            string2 = "MIN(";
            string3 = ")";
        }
        Set<String> set3 = this.getAllLexVars();
        int n = 8;
        int n2 = 0;
        int n3 = 7;
        int n4 = 0;
        int n5 = 3;
        for (String string4 : this.definedVars) {
            n = 1;
            n2 = 0;
            if (set3.contains(string4) && this.pushedVars.contains(string4)) {
                n = 9;
                n2 = 8;
            } else if (this.pushedVars.contains(string4)) {
                n = 8;
            }
            for (int i = 0; i < n; ++i) {
                String string5 = "R." + string4 + this.varProjColumns[i];
                if (i != n3) {
                    if (!(set == null || i == n2 && set.contains(string4))) {
                        string5 = !set.contains(string4) ? this.buildNullValueForVar(i, n4, n3) : (set3.contains(string4) && string2 != null && string2.length() > 0 ? (i == n4 ? this.buildNullValueForVar(i, n4, n3) : COMPONENT_FUNCS_VPROJ[i] + "(" + "R." + string4 + this.varProjColumns[8] + ")") : string2 + string5 + string3);
                    }
                } else if (!string2.equals("")) {
                    if (n2 != n4 || !set.contains(string4)) {
                        string5 = this.buildNullValueForVar(i, n4, n3);
                    } else {
                        String string6 = "R." + string4 + this.varProjColumns[n4];
                        String string7 = string2 + "R." + string4 + this.varProjColumns[n5] + string3;
                        string5 = this.buildSubQForCLOB(string4, string6, string7);
                    }
                }
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string5, string4 + this.varProjColumns[i]), ", ", "");
            }
        }
        if (set2 != null) {
            for (String string4 : set2) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.buildNullValueForVar(0, n4, n3), string4 + this.varProjColumns[0]), ", ", "");
            }
        }
        if (string != null) {
            QueryUtils.appendToList(stringBuffer, string2 + string + string3 + " AS SEM$ROWNUM", ", ", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("NULL");
        }
        return stringBuffer.toString();
    }

    private String wrapForReSort(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = this.buildWrapperSelect(null, "ROWNUM", null);
        String string3 = this.buildWrapperSelect(null, null, null);
        stringBuffer.append("SELECT ").append(string2).append("\n");
        stringBuffer.append("FROM (\n");
        stringBuffer.append("SELECT ").append(string3).append("\n");
        stringBuffer.append("FROM (").append(string).append(") R\n");
        stringBuffer.append("ORDER BY R.SEM$ROWNUM) R");
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String wrapForGrouping(String string, Set<String> set) throws RDFException {
        void var16_42;
        ArrayList<Object> arrayList;
        String[] stringArray;
        Object object;
        Object object2;
        String[] stringArray2;
        Set<String> set2;
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = this.graphQuery && this.activeGraph.type == 0;
        String string2 = string;
        if (this.graphQuery && this.unmaskGraph && this.selDesc.containsAggregate()) {
            void var8_10;
            serializable = new StringBuffer("");
            set2 = this.activeGraph.name;
            String object72 = (String)((Object)set2) + this.vid_alias;
            if (this.getAllLexVars().contains(set2)) {
                String string3 = this.activeGraph.name + this.term_alias;
            }
            String string4 = this.buildWrapperSelect(null, null, null);
            String string5 = ((String)((Object)set2)).replace("$", "\\$");
            stringArray2 = "R\\." + string5 + "(\\$|\\s|,)";
            String string6 = string4.replaceAll((String)stringArray2, "DG." + string5 + "$1");
            object2 = this.myBGP.distinctGraphsQuery((String)((Object)set2), this.pushedVars.contains(set2));
            ((StringBuffer)serializable).append("SELECT ").append(string6).append("\n");
            ((StringBuffer)serializable).append("FROM (").append((String)object2).append(") DG\n");
            ((StringBuffer)serializable).append("LEFT OUTER JOIN\n");
            ((StringBuffer)serializable).append("(").append(string2).append(") R\n");
            ((StringBuffer)serializable).append("ON (").append("DG.").append((String)var8_10);
            ((StringBuffer)serializable).append("=R.").append((String)var8_10).append(")");
            string2 = ((StringBuffer)serializable).toString();
            if (set.contains(set2)) {
                set.clear();
                set.add((String)((Object)set2));
            } else {
                set.clear();
            }
        } else if (this.selDesc.containsAggregate() && this.ctx.strictAggCard) {
            serializable = new StringBuffer("");
            ((StringBuffer)serializable).append("SELECT GB.*\n");
            ((StringBuffer)serializable).append("FROM (SELECT 1 FROM DUAL) DG\n");
            ((StringBuffer)serializable).append("LEFT OUTER JOIN\n");
            ((StringBuffer)serializable).append("(").append(string2).append(") GB\n");
            ((StringBuffer)serializable).append("ON (1=1)");
            string2 = ((StringBuffer)serializable).toString();
            set.clear();
        }
        serializable = new HashSet();
        for (SelectExpression selectExpression : this.selDesc.getSelectExpressions()) {
            if (this.ctx.allowUnDefVarsInExpr) {
                selectExpression.processUnDefVars(this.definedVars);
            }
            selectExpression.setInScopeVars(this.definedVars);
            selectExpression.setDefBoundVars(set);
            selectExpression.prepareExpression();
            for (String string7 : selectExpression.getJoinVars()) {
                if (this.pushedVars.contains(string7) || !this.definedVars.contains(string7)) continue;
                serializable.add(string7);
            }
        }
        if ((this.groupByExists || this.havingExist) && this.ctx.allowUnDefVarsInExpr) {
            this.solnMod.processUnDefVarsForGroupBy(this.definedVars);
        }
        if (this.groupByExists || bl) {
            set2 = this.solnMod.getAllGroupByJoinVars();
            if (bl && this.getAllLexVars().contains(this.activeGraph.name)) {
                set2.add(this.activeGraph.name);
            }
            for (String string8 : set2) {
                if (this.pushedVars.contains(string8) || !this.definedVars.contains(string8)) continue;
                serializable.add(string8);
            }
        }
        if (this.havingExist) {
            set2 = this.solnMod.getHavingConds().getfJoinVars();
            for (String string9 : set2) {
                if (this.pushedVars.contains(string9) || !this.definedVars.contains(string9)) continue;
                serializable.add(string9);
            }
        }
        set2 = new HashMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String[] stringArray3 = new String[]{""};
        stringArray2 = new String[]{""};
        if (!serializable.isEmpty() && this.getNumChildren() > 0) {
            object2 = this.getChild(0);
            object2.genOuterSelectComponents((Set<String>)((Object)serializable), set, (Map<String, List<String>>)((Object)set2), stringArray3, stringArray2, (Map<String, String>)hashMap);
        }
        object2 = this.buildFinalValueJoinHint(hashMap.values());
        for (String string10 : this.pushedVars) {
            hashMap.put(string10, "R." + string10);
        }
        for (String string11 : this.definedVars) {
            hashMap2.put(string11, "R." + string11 + this.vid_alias);
        }
        HashMap hashMap3 = new HashMap();
        HashMap<String, List<String>> hashMap4 = new HashMap<String, List<String>>();
        for (SelectExpression selectExpression : this.selDesc.getSelectExpressions()) {
            if (selectExpression.getExpr() == null) continue;
            object = selectExpression.getExpr();
            hashMap3.put(selectExpression.getVarStr(), Filter.getNodeRetType(((Filter)object).getFilterTree(), this.ctx.funcTypeMap, this.ctx));
            if (selectExpression.isBindSpecialCase()) {
                object = selectExpression.getBindVarExpr();
            }
            ((Filter)object).setSQLGenCtx(this.ctx);
            stringArray = ((Filter)object).toSelectExprSQL("R." + selectExpression.getVarStr() + this.srt_alias, hashMap, hashMap2, this.ctx.funcTypeMap, this.ctx.funcHandMap);
            arrayList = new ArrayList<Object>(12);
            arrayList.add(stringArray[2] + " || " + stringArray[3]);
            arrayList.add(stringArray[0]);
            arrayList.add(stringArray[2]);
            arrayList.add(stringArray[3]);
            arrayList.add(stringArray[1]);
            arrayList.add(stringArray[6]);
            arrayList.add(stringArray[4]);
            arrayList.add(stringArray[5]);
            arrayList.add(stringArray[7]);
            arrayList.add(stringArray[8]);
            arrayList.add(stringArray[9]);
            arrayList.add(stringArray[10]);
            hashMap4.put(selectExpression.getVarStr(), arrayList);
        }
        Set<String> set3 = this.solnMod.getGroupByVars();
        if (bl) {
            set3.add(this.activeGraph.name);
        }
        String string12 = this.buildValJoinSelect(this.definedVars, (Set<String>)((Object)serializable), (Map<String, List<String>>)((Object)set2), null, hashMap4.keySet(), set3, hashMap4.keySet());
        if (hashMap4.size() > 0) {
            String string13 = this.addSRTselection(hashMap4, string12, hashMap3);
        }
        object = new StringBuffer("");
        stringArray = this.getAllLexVars();
        if (this.groupByExists || bl) {
            ((StringBuffer)object).append("GROUP BY ");
            arrayList = this.solnMod.getGroupByConds();
            if (bl) {
                SelectExpression selectExpression = new SelectExpression();
                selectExpression.setVar(this.activeGraph);
                arrayList.add(0, selectExpression);
            }
            for (SelectExpression selectExpression : arrayList) {
                Object object3;
                String string14 = "";
                if (selectExpression.getExpr() != null) {
                    object3 = selectExpression.getExpr();
                    ((Filter)object3).setSQLGenCtx(this.ctx);
                    string14 = ((Filter)object3).toGroupBySQL(hashMap, hashMap2, this.ctx.funcTypeMap, this.ctx.funcHandMap);
                } else {
                    object3 = selectExpression.getVarStr();
                    string14 = stringArray.contains(object3) ? (this.ctx.useExactForExpr ? this.buildRDFTForVar("R", (String)object3, (Map<String, List<String>>)((Object)set2), false, serializable.contains(object3), false, true) : this.buildCanonRDFTForVar("R", (String)object3, (Map<String, List<String>>)((Object)set2), false, serializable.contains(object3), false, true)) : (serializable.contains(object3) ? (String)((List)set2.get(object3)).get(1) : "R." + (String)object3 + this.vid_alias);
                }
                QueryUtils.appendToList((StringBuffer)object, string14, ", ", "GROUP BY ");
            }
            ((StringBuffer)object).append("\n");
        }
        arrayList = new StringBuffer("");
        if (this.havingExist) {
            ((StringBuffer)((Object)arrayList)).append(this.solnMod.getHavingConds().getSQLForHavingCond(hashMap, hashMap2, this.ctx.funcTypeMap, this.ctx.funcHandMap, set3));
            ((StringBuffer)((Object)arrayList)).append("\n");
        }
        this.validateGrouping();
        this.pushedVars.addAll((Collection<String>)((Object)serializable));
        stringBuffer.append("SELECT ").append((String)var16_42).append("\n");
        stringBuffer.append("FROM (").append(string2).append(") R\n").append(stringArray3[0]).append("\n");
        stringBuffer.append("WHERE (1=1)").append(stringArray2[0]).append("\n");
        stringBuffer.append((StringBuffer)object);
        stringBuffer.append((StringBuffer)((Object)arrayList));
        if (hashMap4.size() > 0) {
            this.wrapForSRTdecomp(this.definedVars, hashMap4, stringBuffer, hashMap3, null);
        }
        this.definedVars.clear();
        this.definedVars.addAll((Collection<String>)set3);
        this.definedVars.addAll(this.selDesc.getSelectList());
        this.pushedVars.addAll(hashMap4.keySet());
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String wrapSelectExpressions(String string, Set<String> set) throws RDFException {
        void var11_17;
        void var11_15;
        AbstractCollection abstractCollection;
        String string2 = string;
        ArrayList arrayList = new ArrayList();
        ArrayList<HashSet<String>> arrayList2 = new ArrayList<HashSet<String>>();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<SelectExpression> arrayList3 = new ArrayList<SelectExpression>();
        for (String object : this.definedVars) {
            if (this.selDesc.containsVar(object)) continue;
            ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
            aSTTripleAtom.type = 0;
            aSTTripleAtom.name = object;
            SelectExpression selectExpression = new SelectExpression();
            selectExpression.setVar(aSTTripleAtom);
        }
        for (SelectExpression list : this.selDesc.getSelectExpressions()) {
            abstractCollection = new HashSet<String>(this.definedVars);
            abstractCollection.addAll(hashSet);
            if (this.ctx.allowUnDefVarsInExpr) {
                list.processUnDefVars((Set<String>)((Object)abstractCollection));
            }
            list.setInScopeVars((Set<String>)((Object)abstractCollection));
            list.setDefBoundVars(set);
            list.prepareExpression();
            if (list.getExpr() == null) continue;
            if (!this.definedVars.containsAll(list.getVars())) {
                arrayList.add(arrayList3);
                arrayList3 = new ArrayList();
                this.definedVars.addAll(hashSet);
                arrayList2.add(new HashSet<String>(this.definedVars));
            }
            arrayList3.add(list);
            hashSet.add(list.getVarStr());
        }
        if (arrayList3.size() > 0) {
            arrayList.add(arrayList3);
            this.definedVars.addAll(hashSet);
            arrayList2.add(new HashSet<String>(this.definedVars));
        }
        this.validateSelectExpressions();
        ArrayList arrayList4 = new ArrayList(arrayList.size());
        boolean bl = false;
        while (var11_15 < arrayList.size()) {
            arrayList4.add(new ArrayList());
            ++var11_15;
        }
        int n = arrayList.size() - 1;
        while (var11_17 >= 0) {
            abstractCollection = new ArrayList();
            for (SelectExpression selectExpression : (List)arrayList.get((int)var11_17)) {
                Filter filter = selectExpression.getExpr();
                if (filter == null) continue;
                abstractCollection.addAll(filter.extractAncInfoForAnc());
            }
            for (void var13_23 = var11_17 - true; var13_23 >= 0; --var13_23) {
                ((List)arrayList4.get((int)var13_23)).addAll(abstractCollection);
            }
            --var11_17;
        }
        Object var11_18 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            List list = (List)arrayList.get(i);
            string2 = this.wrapForSPARQLSelectExpr(string2, list, set, (Set)arrayList2.get(i), (List)arrayList4.get(i));
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private String wrapForSPARQLSelectExpr(String string, List<SelectExpression> list, Set<String> set, Set<String> set2, List<String[]> list2) throws RDFException {
        void var16_26;
        void var16_24;
        StringBuffer stringBuffer;
        Object object;
        StringBuffer stringBuffer2 = new StringBuffer("");
        HashSet<ASTTripleAtom.BindVar> hashSet = new HashSet<ASTTripleAtom.BindVar>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (SelectExpression object52 : list) {
            for (String string2 : object52.getJoinVars()) {
                if (this.pushedVars.contains(string2) || !set2.contains(string2)) continue;
                hashSet2.add(string2);
            }
            if (!object52.isBindSpecialCase() || this.pushedVars.contains(object52.getVarStr())) continue;
            hashSet.add(object52.getVar().getBindVar());
        }
        HashMap hashMap = new HashMap();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap hashMap3 = new HashMap();
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        if (!hashSet2.isEmpty() && this.getNumChildren() > 0) {
            object = this.getChild(0);
            object.genOuterSelectComponents(hashSet2, set, hashMap, stringArray, stringArray2, hashMap2);
        }
        object = this.buildFinalValueJoinHint(hashMap2.values());
        for (String string3 : this.pushedVars) {
            hashMap2.put(string3, "R." + string3);
        }
        for (String string4 : set2) {
            hashMap3.put(string4, "R." + string4 + this.vid_alias);
        }
        HashSet hashSet3 = new HashSet();
        for (SelectExpression selectExpression : list) {
            if (selectExpression.getExpr() == null) continue;
            hashSet3.add(selectExpression.getVarStr());
        }
        String string5 = this.buildValJoinSelect(set2, hashSet2, hashMap, null, hashSet3, null, null);
        if (list2.size() > 0 && this.addAncProjections(list2, stringBuffer = new StringBuffer(""))) {
            String string6 = string5 + "\n," + stringBuffer.toString();
        }
        String string7 = "SELECT " + (String)object + " " + (String)var16_24 + "\n";
        stringBuffer2.append("FROM (\n");
        stringBuffer2.append(string).append("\n) R\n");
        if (!hashSet.isEmpty()) {
            for (ASTTripleAtom.BindVar bindVar : hashSet) {
                stringBuffer2.append(", " + bindVar.getAlias() + " " + bindVar.getAlias());
            }
            stringBuffer2.append("\n");
        }
        if (!hashSet2.isEmpty()) {
            stringBuffer2.append(stringArray[0]).append("\n");
            stringBuffer2.append("WHERE (1=1) ").append(stringArray2[0]).append("\n");
        } else {
            stringBuffer2.append("WHERE (1=1)");
        }
        HashMap hashMap4 = new HashMap();
        HashMap<String, List<String>> hashMap5 = new HashMap<String, List<String>>();
        for (SelectExpression selectExpression : list) {
            if (selectExpression.getExpr() == null) continue;
            Filter filter = selectExpression.getExpr();
            hashMap4.put(selectExpression.getVarStr(), Filter.getNodeRetType(filter.getFilterTree(), this.ctx.funcTypeMap, this.ctx));
            if (selectExpression.isBindSpecialCase()) {
                filter = selectExpression.getBindVarExpr();
            }
            filter.setSQLGenCtx(this.ctx);
            filter.setCurrSQL(string7 + stringBuffer2.toString(), QueryUtils.getDistinctVars(set2, hashSet3), this.pushedVars, this.getAllLexVars(), set2);
            String[] stringArray3 = filter.toSelectExprSQL("R." + selectExpression.getVarStr() + this.srt_alias, hashMap2, hashMap3, this.ctx.funcTypeMap, this.ctx.funcHandMap);
            ArrayList<String> arrayList = new ArrayList<String>(12);
            arrayList.add(stringArray3[2] + " || " + stringArray3[3]);
            arrayList.add(stringArray3[0]);
            arrayList.add(stringArray3[2]);
            arrayList.add(stringArray3[3]);
            arrayList.add(stringArray3[1]);
            arrayList.add(stringArray3[6]);
            arrayList.add(stringArray3[4]);
            arrayList.add(stringArray3[5]);
            arrayList.add(stringArray3[7]);
            arrayList.add(stringArray3[8]);
            arrayList.add(stringArray3[9]);
            arrayList.add(stringArray3[10]);
            hashMap5.put(selectExpression.getVarStr(), arrayList);
        }
        if (hashMap5.size() > 0) {
            String string8 = this.addSRTselection(hashMap5, (String)var16_24, hashMap4);
        }
        String string9 = "SELECT " + (String)object + " " + (String)var16_26 + "\n";
        stringBuffer2.insert(0, string9);
        this.pushedVars.addAll(hashSet2);
        if (hashMap5.size() > 0) {
            this.wrapForSRTdecomp(set2, hashMap5, stringBuffer2, hashMap4, list2);
        }
        this.pushedVars.addAll(hashMap5.keySet());
        return stringBuffer2.toString();
    }

    private String addSRTselection(Map<String, List<String>> map, String string, Map<String, Integer> map2) {
        String string2 = string;
        boolean bl = true;
        if (string2.equals("NULL")) {
            string2 = "";
            bl = false;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            string2 = string2 + "\n";
            String string3 = entry.getKey();
            List<String> list = entry.getValue();
            int n = map2.get(string3);
            if (n == 4 || n == 12) {
                String[] stringArray = new String[]{list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5), list.get(6), list.get(7), list.get(9)};
                String[] stringArray2 = new String[]{string3 + this.finalCols[0], string3 + this.finalCols[1], string3 + this.finalCols[2], string3 + this.finalCols[3], string3 + this.finalCols[4], string3 + this.finalCols[5], string3 + this.finalCols[6], string3 + this.finalCols[7], string3 + this.term_alias};
                for (int i = 0; i < 9; ++i) {
                    if (bl) {
                        string2 = string2 + ", ";
                    }
                    string2 = string2 + QueryUtils.buildAliasExpr(this.ctx, stringArray[i], stringArray2[i]);
                    bl = true;
                }
            } else {
                if (bl) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + QueryUtils.buildAliasExpr(this.ctx, list.get(1), string3 + this.finalCols[1]);
                string2 = string2 + ", ";
                string2 = string2 + QueryUtils.buildAliasExpr(this.ctx, list.get(10), string3 + this.srt_alias);
            }
            bl = true;
        }
        return string2;
    }

    private boolean addAncProjections(List<String[]> list, StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = stringBuffer.length() > 0;
        if (list != null) {
            for (String[] stringArray : list) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("\n").append("R.").append("ANC$").append(stringArray[1]);
                bl = true;
            }
        }
        return bl;
    }

    private void wrapForSRTdecomp(Set<String> set, Map<String, List<String>> map, StringBuffer stringBuffer, Map<String, Integer> map2, List<String[]> list) {
        int n;
        int n2;
        int n3;
        Object object;
        String string = this.buildValJoinSelect(set, new HashSet<String>(), null, null, map.keySet(), null, null);
        if (string.equals("NULL")) {
            string = "";
        }
        String[] stringArray = new String[9];
        String[] stringArray2 = new String[9];
        int n4 = 0;
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer2.append(string);
        boolean bl = true;
        if (stringBuffer2.length() == 0) {
            bl = false;
        }
        for (Map.Entry<String, List<String>> object22 : map.entrySet()) {
            stringBuffer2.append("\n");
            object = object22.getKey();
            List<String> list2 = object22.getValue();
            int n5 = map2.get(object);
            if (n5 == 4 || n5 == 12) {
                stringArray[0] = "R." + (String)object + this.finalCols[0];
                stringArray[1] = "R." + (String)object + this.finalCols[1];
                stringArray[2] = "R." + (String)object + this.finalCols[2];
                stringArray[3] = "R." + (String)object + this.finalCols[3];
                stringArray[4] = "R." + (String)object + this.finalCols[4];
                stringArray[5] = "R." + (String)object + this.finalCols[5];
                stringArray[6] = "R." + (String)object + this.finalCols[6];
                stringArray[7] = "R." + (String)object + this.finalCols[7];
                stringArray[8] = "R." + (String)object + this.term_alias;
                stringArray2[0] = (String)object + this.finalCols[0];
                stringArray2[1] = (String)object + this.finalCols[1];
                stringArray2[2] = (String)object + this.finalCols[2];
                stringArray2[3] = (String)object + this.finalCols[3];
                stringArray2[4] = (String)object + this.finalCols[4];
                stringArray2[5] = (String)object + this.finalCols[5];
                stringArray2[6] = (String)object + this.finalCols[6];
                stringArray2[7] = (String)object + this.finalCols[7];
                stringArray2[8] = (String)object + this.term_alias;
                n4 = 9;
            } else {
                stringArray[0] = "R." + (String)object + this.finalCols[1];
                stringArray[1] = list2.get(11);
                stringArray2[0] = (String)object + this.finalCols[1];
                stringArray2[1] = (String)object + this.srt_alias;
                n4 = 2;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                if (bl) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(QueryUtils.buildAliasExpr(this.ctx, stringArray[n3], stringArray2[n3]));
                bl = true;
            }
            bl = true;
        }
        if (this.addAncProjections(list, stringBuffer2)) {
            bl = true;
        }
        Object object3 = "SELECT ";
        if (!this.ctx.disableSelExprNoMerge) {
            object3 = (String)object3 + "/*+ NO_MERGE(R) */ ";
        }
        stringBuffer.insert(0, (String)object3 + stringBuffer2.toString() + "\nFROM (\n");
        stringBuffer.append("\n) R\n");
        stringBuffer.append("WHERE (1=1)");
        StringBuffer stringBuffer3 = new StringBuffer(string);
        bl = true;
        if (stringBuffer3.length() == 0) {
            bl = false;
        }
        for (Map.Entry entry : map.entrySet()) {
            stringBuffer3.append("\n");
            String string2 = (String)entry.getKey();
            n3 = map2.get(entry.getKey());
            if (n3 == 4 || n3 == 12) {
                if (this.ctx.useExactForExpr) {
                    stringArray[0] = "R." + string2 + this.finalCols[0];
                    stringArray[1] = "R." + string2 + this.finalCols[1];
                    stringArray[2] = "R." + string2 + this.finalCols[2];
                    stringArray[3] = "R." + string2 + this.finalCols[3];
                    stringArray[4] = "R." + string2 + this.finalCols[4];
                    stringArray[5] = "R." + string2 + this.finalCols[5];
                    stringArray[6] = "R." + string2 + this.finalCols[6];
                    stringArray[7] = "R." + string2 + this.finalCols[7];
                    stringArray[8] = "R." + string2 + this.term_alias;
                    stringArray2[0] = string2 + this.finalCols[0];
                    stringArray2[1] = string2 + this.finalCols[1];
                    stringArray2[2] = string2 + this.finalCols[2];
                    stringArray2[3] = string2 + this.finalCols[3];
                    stringArray2[4] = string2 + this.finalCols[4];
                    stringArray2[5] = string2 + this.finalCols[5];
                    stringArray2[6] = string2 + this.finalCols[6];
                    stringArray2[7] = string2 + this.finalCols[7];
                    stringArray2[8] = string2 + this.term_alias;
                    n4 = 9;
                } else {
                    stringArray[0] = "R." + string2 + this.finalCols[1];
                    stringArray[1] = "R." + string2 + this.term_alias;
                    stringArray[2] = "R." + string2 + this.finalCols[5];
                    stringArray2[0] = string2 + this.finalCols[1];
                    stringArray2[1] = string2 + this.term_alias;
                    stringArray2[2] = string2 + this.finalCols[5];
                    n4 = 3;
                }
                for (n2 = 0; n2 < n4; ++n2) {
                    if (bl) {
                        stringBuffer3.append(", ");
                    }
                    stringBuffer3.append(QueryUtils.buildAliasExpr(this.ctx, stringArray[n2], stringArray2[n2]));
                    bl = true;
                }
            } else {
                List list3 = (List)entry.getValue();
                if (this.ctx.useExactForExpr) {
                    if (n3 == 21 || n3 == 23 || n3 == 25) {
                        stringArray[0] = this.buildVcFromClobExpr((String)list3.get(5), (String)list3.get(7), (String)list3.get(6));
                        stringArray[2] = this.buildVcFromClobExpr((String)list3.get(5), (String)list3.get(7), (String)list3.get(6));
                        stringArray[5] = this.buildClobFromClobExpr((String)list3.get(5), (String)list3.get(7), (String)list3.get(6));
                    } else {
                        stringArray[0] = (String)list3.get(0);
                        stringArray[2] = (String)list3.get(2);
                        stringArray[5] = (String)list3.get(5);
                    }
                    stringArray[1] = "R." + string2 + this.finalCols[1];
                    stringArray[3] = (String)list3.get(3);
                    stringArray[4] = (String)list3.get(4);
                    stringArray[6] = (String)list3.get(6);
                    stringArray[7] = (String)list3.get(7);
                    stringArray[8] = (String)list3.get(9);
                    if (n3 == 5 || n3 == 6 || n3 == 7 || n3 == 8 || n3 == 9 || n3 == 10 || n3 == 11 || n3 == 20 || n3 == 27 || n3 == 28) {
                        stringArray[0] = this.removeChr0(stringArray[0]);
                        stringArray[2] = this.removeChr0(stringArray[2]);
                        stringArray[3] = this.removeChr0(stringArray[3]);
                    }
                    stringArray2[0] = string2 + this.finalCols[0];
                    stringArray2[1] = string2 + this.finalCols[1];
                    stringArray2[2] = string2 + this.finalCols[2];
                    stringArray2[3] = string2 + this.finalCols[3];
                    stringArray2[4] = string2 + this.finalCols[4];
                    stringArray2[5] = string2 + this.finalCols[5];
                    stringArray2[6] = string2 + this.finalCols[6];
                    stringArray2[7] = string2 + this.finalCols[7];
                    stringArray2[8] = string2 + this.term_alias;
                    n4 = 9;
                } else {
                    stringArray[1] = n3 == 21 || n3 == 23 || n3 == 25 ? this.buildClobFromClobExpr((String)list3.get(5), (String)list3.get(7), (String)list3.get(6)) : (String)list3.get(5);
                    stringArray[0] = "R." + string2 + this.finalCols[1];
                    stringArray[2] = (String)list3.get(9);
                    stringArray2[0] = string2 + this.finalCols[1];
                    stringArray2[1] = string2 + this.finalCols[5];
                    stringArray2[2] = string2 + this.term_alias;
                    n4 = 3;
                }
                for (n = 0; n < n4; ++n) {
                    if (bl) {
                        stringBuffer3.append(", ");
                    }
                    stringBuffer3.append(QueryUtils.buildAliasExpr(this.ctx, stringArray[n], stringArray2[n]));
                    bl = true;
                }
            }
            bl = true;
        }
        if (this.addAncProjections(list, stringBuffer3)) {
            bl = true;
        }
        stringBuffer.insert(0, (String)object3 + stringBuffer3.toString() + "\nFROM (\n");
        stringBuffer.append("\n) R\n");
        stringBuffer.append("WHERE (1=1)");
        if (!this.ctx.useExactForExpr) {
            object = new StringBuffer(string);
            bl = true;
            if (((StringBuffer)object).length() == 0) {
                bl = false;
            }
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                ((StringBuffer)object).append("\n");
                String string3 = entry.getKey();
                n2 = map2.get(entry.getKey());
                stringArray[0] = "R." + string3 + this.finalCols[1];
                stringArray[1] = "MDSYS.SDO_RDF.VTYPE(R." + string3 + this.term_alias + ")";
                stringArray[2] = "NVL2(R." + string3 + this.finalCols[5] + "," + "NULL," + "MDSYS.SDO_RDF.VNAME" + "(R." + string3 + this.term_alias + "))";
                stringArray[3] = "NVL2(R." + string3 + this.finalCols[5] + "," + "NULL," + "MDSYS.SDO_RDF.VNPFX" + "(R." + string3 + this.term_alias + "))";
                stringArray[4] = "NVL2(R." + string3 + this.finalCols[5] + "," + "NULL," + "MDSYS.SDO_RDF.VNSFX" + "(R." + string3 + this.term_alias + "))";
                stringArray[5] = "MDSYS.SDO_RDF.LTYPE(R." + string3 + this.term_alias + ")";
                stringArray[6] = "MDSYS.SDO_RDF.LATAG(R." + string3 + this.term_alias + ")";
                stringArray[7] = "R." + string3 + this.finalCols[5];
                stringArray[8] = "R." + string3 + this.term_alias;
                stringArray2[0] = string3 + this.finalCols[1];
                stringArray2[1] = string3 + this.finalCols[4];
                stringArray2[2] = string3 + this.finalCols[0];
                stringArray2[3] = string3 + this.finalCols[2];
                stringArray2[4] = string3 + this.finalCols[3];
                stringArray2[5] = string3 + this.finalCols[6];
                stringArray2[6] = string3 + this.finalCols[7];
                stringArray2[7] = string3 + this.finalCols[5];
                stringArray2[8] = string3 + this.term_alias;
                n4 = 9;
                for (n = 0; n < n4; ++n) {
                    if (bl) {
                        ((StringBuffer)object).append(", ");
                    }
                    ((StringBuffer)object).append(QueryUtils.buildAliasExpr(this.ctx, stringArray[n], stringArray2[n]));
                    bl = true;
                }
                bl = true;
            }
            if (this.addAncProjections(list, (StringBuffer)object)) {
                bl = true;
            }
            stringBuffer.insert(0, (String)object3 + ((StringBuffer)object).toString() + "\nFROM (\n");
            stringBuffer.append("\n) R\n");
            stringBuffer.append("WHERE (1=1)");
        }
    }

    private String removeChr0(String string) {
        return "REPLACE(" + string + ",CHR(0))";
    }

    private String buildVcFromClobExpr(String string, String string2, String string3) {
        return "(NVL2(" + string + "," + "(CASE WHEN " + QueryUtils.computeClobTermLen(string, string2, string3) + " <= " + 4000 + " THEN TO_CHAR(" + string + ") " + "ELSE NULL END), " + "NULL))";
    }

    private String buildClobFromClobExpr(String string, String string2, String string3) {
        return "(NVL2(" + string + "," + "(CASE WHEN " + QueryUtils.computeClobTermLen(string, string2, string3) + " > " + 4000 + " THEN " + string + " " + "ELSE NULL END), " + "NULL))";
    }

    private String wrapForSPARQLDistinct(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set = this.getAllLexVars();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.selDesc.getSelectList());
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String charSequence2 : hashSet) {
            if (this.definedVars.contains(charSequence2)) continue;
            hashSet2.add(charSequence2);
        }
        Object object = null;
        if (this.rowNumProjected) {
            object = "R.SEM$ROWNUM";
        }
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (!hashSet2.isEmpty()) {
            stringBuffer2.append("SELECT ");
            stringBuffer2.append(this.buildWrapperSelect(null, (String)object, hashSet2)).append("\n");
            stringBuffer2.append("FROM (").append(string).append(") R");
        } else {
            stringBuffer2.append(string);
        }
        String string2 = "SELECT " + this.buildWrapperSelect(hashSet, (String)object, null);
        StringBuffer stringBuffer3 = new StringBuffer("GROUP BY ");
        int n = 0;
        for (String string3 : hashSet) {
            n = 0;
            if (set.contains(string3)) {
                n = 8;
            }
            QueryUtils.appendToList(stringBuffer3, "R." + string3 + this.varProjColumns[n], ", ", "GROUP BY ");
        }
        String string4 = "FROM (" + stringBuffer2.toString() + ") R";
        stringBuffer.append(string2).append("\n").append(string4).append("\n").append(stringBuffer3);
        return stringBuffer.toString();
    }

    private String wrapForSPARQLOrderBy(String string, Set<String> set, boolean bl) throws RDFException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        this.solnMod.cleanupOrderConds(this.definedVars, this.ctx.funcTypeMap);
        Set<String> set2 = this.solnMod.getVars();
        if (this.orderByExists) {
            set2.addAll(this.topProjVars);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String object22 : set2) {
            if (this.pushedVars.contains(object22) || !this.definedVars.contains(object22)) continue;
            hashSet.add(object22);
        }
        HashMap hashMap = new HashMap();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{""};
        if (!hashSet.isEmpty() && this.getNumChildren() > 0) {
            object = this.getChild(0);
            object.genOuterSelectComponents(hashSet, set, hashMap, stringArray, stringArray2, hashMap2);
        }
        object = this.buildFinalValueJoinHint(hashMap2.values());
        for (String n2 : this.pushedVars) {
            hashMap2.put(n2, "R." + n2);
        }
        int n = -1;
        if (bl && this.limitExists) {
            n = this.solnMod.getLimit();
            int string3 = this.solnMod.getOffset();
            if (n >= 0 && string3 >= 0) {
                n += string3;
            }
        }
        String string2 = this.buildSPARQLOrderBy(hashMap2);
        String string3 = this.buildValJoinSelect(this.definedVars, hashSet, hashMap, null, null, null, null);
        this.pushedVars.addAll(hashSet);
        String string4 = this.buildWrapperSelect(null, "ROWNUM", null);
        stringBuffer.append("SELECT ").append((String)object).append(" ").append(string4).append("\n");
        stringBuffer.append("FROM (\n");
        if (string2.length() > 0) {
            stringBuffer.append("SELECT ").append(string3).append("\n");
            stringBuffer.append("FROM (\n");
        }
        stringBuffer.append(string).append("\n) R\n");
        if (string2.length() > 0) {
            stringBuffer.append(stringArray[0]).append("\n");
            stringBuffer.append("WHERE (1=1) ").append(stringArray2[0]).append("\n");
            stringBuffer.append(string2).append("\n) R\n");
        }
        stringBuffer.append("WHERE (1=1)");
        if (n >= 0) {
            stringBuffer.append(" AND ROWNUM <= " + Integer.toString(n));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String buildSPARQLOrderBy(Map<String, String> map) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        List<OrderCond> list = this.solnMod.getOrderConds();
        for (OrderCond object : list) {
            QueryUtils.appendToList(stringBuffer, object.toSQL(map, this.ctx.funcTypeMap, this.ctx.funcHandMap), ",\n", "");
        }
        if (this.graphQuery && this.activeGraph.type == 0) {
            void var5_10;
            String string = this.activeGraph.name;
            String string2 = (String)string + this.vid_alias;
            if (this.getAllLexVars().contains(string)) {
                String string3 = (String)string + this.term_alias;
            }
            if (stringBuffer.length() > 0) {
                void var5_8;
                String string4 = (String)var5_8 + ", ";
            }
            stringBuffer.insert(0, (String)var5_10);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, " ORDER BY ");
        }
        return stringBuffer.toString();
    }

    private String wrapForLimitOffset(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.graphQuery && this.activeGraph.type == 0) {
            String string2 = this.buildWrapperSelect(null, "SEM$ROWNUM", null);
            String string3 = this.activeGraph.name;
            String string4 = string3 + this.vid_alias;
            if (this.getAllLexVars().contains(string3)) {
                string4 = string3 + this.term_alias;
            }
            String string5 = "(SELECT " + string4 + ", (MIN(SEM$ROWNUM) - 1) MIN$ROWNUM\n" + "FROM (" + string + ")\n" + "GROUP BY " + string4 + ")";
            stringBuffer.append("SELECT ").append(string2).append("\n");
            stringBuffer.append("FROM (" + string + ") R,\n");
            stringBuffer.append(string5 + " R_MIN\n");
            stringBuffer.append("WHERE R." + string4 + "=R_MIN." + string4);
            if (this.limitExists || this.offsetExists) {
                int n = this.solnMod.getLimit();
                int n2 = this.solnMod.getOffset();
                if (n2 >= 0) {
                    stringBuffer.append(" AND R.SEM$ROWNUM > (R_MIN.MIN$ROWNUM + ").append(n2).append(")");
                }
                if (n >= 0 && !bl) {
                    if (n2 >= 0) {
                        n += n2;
                    }
                    stringBuffer.append(" AND R.SEM$ROWNUM <= (R_MIN.MIN$ROWNUM + ").append(n).append(")");
                }
            }
        } else {
            String string6 = this.buildWrapperSelect(null, "SEM$ROWNUM", null);
            stringBuffer.append("SELECT ").append(string6).append("\n");
            stringBuffer.append("FROM (").append(string).append(") R\n");
            stringBuffer.append("WHERE (1=1)");
            if (this.limitExists || this.offsetExists) {
                int n = this.solnMod.getLimit();
                int n3 = this.solnMod.getOffset();
                if (n3 >= 0) {
                    stringBuffer.append(" AND R.SEM$ROWNUM > ").append(n3);
                }
                if (n >= 0 && !bl) {
                    stringBuffer.append(" AND ROWNUM <= ").append(n);
                }
            }
        }
        return stringBuffer.toString();
    }

    private boolean needResort() {
        return this.orderByExists && this.distinctExists && (this.solnMod.hasLimit() || this.solnMod.hasOffset());
    }

    private boolean isNGLimitSpecialCase() {
        return (this.limitExists || this.offsetExists) && this.graphQuery && this.activeGraph.type == 0;
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + this.getClass().getName() + ": Type [" + this.type + "]\n";
        string2 = string2 + string + "Projections: " + this.projectVars + "\n";
        string2 = string2 + this.selDesc.toString(string);
        string2 = string2 + this.solnMod.toString(string);
        if (this.isGraphQuery()) {
            string2 = string2 + string + "GRAPH: [" + this.activeGraph.name + "] [unmaskGraph=" + this.unmaskGraph + "]\n";
        }
        string2 = string2 + string + "Required Lex Vars: [";
        for (String object : this.getRequiredLexVars()) {
            string2 = string2 + object + " ";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "Lex Vars: [";
        for (String string3 : this.getAllLexVars()) {
            string2 = string2 + string3 + " ";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "PLS Vars: [";
        for (String string4 : this.plsVars) {
            string2 = string2 + string4 + " ";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "BGP: \n";
        string2 = string2 + this.myBGP.toString(string) + "\n";
        for (Filter filter : this.myFilters) {
            string2 = string2 + filter.toString(string) + "\n";
        }
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            string2 = string2 + sPARQLTreeNode.toString(string + "  ") + "\n";
        }
        return string2;
    }
}

