/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class SelectExpression {
    private ASTTripleAtom var = null;
    private Node exprTree = null;
    private Filter expr = null;
    private SQLGenContext ctx;
    private String comment = null;

    public Object clone() throws CloneNotSupportedException {
        SelectExpression selectExpression = new SelectExpression();
        if (this.var != null) {
            selectExpression.setVar((ASTTripleAtom)this.var.cloneNode());
        }
        if (this.exprTree != null) {
            selectExpression.setExprTree(this.exprTree.cloneSubTree());
        }
        if (this.expr != null) {
            try {
                selectExpression.setExpr((Filter)this.expr.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        selectExpression.setComment(this.comment);
        return selectExpression;
    }

    public void initExpression(SQLGenContext sQLGenContext) {
        if (this.exprTree != null) {
            this.expr = new Filter((SimpleNode)this.exprTree, sQLGenContext);
        }
        this.ctx = sQLGenContext;
    }

    public void prepareExpression() {
        if (this.expr != null) {
            this.expr.init();
        }
    }

    public boolean containsAggregate() {
        boolean bl = false;
        if (this.exprTree != null && (OptimizerUtils.containsNodeType(this.exprTree, 89) || OptimizerUtils.containsUserDefinedOrSpatialAggregate(this.exprTree))) {
            bl = true;
        }
        return bl;
    }

    public boolean containsBooleanSpecialNode() {
        boolean bl = false;
        if (this.exprTree != null && OptimizerUtils.containsNodeType(this.exprTree, -1)) {
            bl = true;
        }
        return bl;
    }

    public boolean isBindSpecialCase() {
        return this.var.type == 9;
    }

    public boolean isConstant() {
        if (this.exprTree != null) {
            SimpleNode simpleNode = (SimpleNode)this.exprTree;
            if (simpleNode.id == 73) {
                int n = ((ASTTripleAtom)simpleNode).type;
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean isDefBound(HintGenerator hintGenerator) {
        boolean bl = false;
        if (this.comment != null) {
            hintGenerator.setUserHint(QueryUtils.extractHint0Contents(this.comment));
            hintGenerator.generateHint();
            Map<Hint.QueryOption, String> map = hintGenerator.getQueryOptions();
            bl = map.containsKey((Object)Hint.QueryOption.DEF_NON_NULL);
        }
        return bl || this.isBindSpecialCase() || this.isConstant();
    }

    public void validateFilter() throws RDFException, TypeException {
        if (this.expr != null) {
            this.expr.validateFilter(this.ctx.funcTypeMap);
        }
    }

    public void processUnDefVars(Set<String> set) throws RDFException {
        if (this.expr != null) {
            QueryUtils.processUnDefVars(this.expr, set, this.ctx.funcTypeMap);
            this.exprTree = this.expr.getFilterTree();
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "SelectExpression Comment:[" + this.comment + "]\n";
        if (this.var != null) {
            string2 = string2 + string + "\tVar: " + this.var.name + "\n";
        }
        if (this.exprTree != null) {
            string2 = string2 + string + "\tExpr:\n" + ((SimpleNode)this.exprTree).dumpToStr(string) + "\n";
        }
        return string2;
    }

    public String printSPARQLText() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.exprTree != null) {
            stringBuffer.append("(");
            stringBuffer.append(this.exprTree.printSPARQLText());
            stringBuffer.append(" AS ?");
            stringBuffer.append(this.var.name);
            stringBuffer.append(") ");
        } else {
            stringBuffer.append("?");
            stringBuffer.append(this.var.name);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public ASTTripleAtom getVar() {
        return this.var;
    }

    public String getVarStr() {
        if (this.var != null) {
            return this.var.name.toUpperCase();
        }
        return null;
    }

    public Node getExprTree() {
        return this.exprTree;
    }

    public Filter getExpr() {
        return this.expr;
    }

    public Filter getBindVarExpr() {
        Filter filter = new Filter(this.var, this.ctx);
        filter.init();
        return filter;
    }

    public Set<String> getVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.expr != null) {
            hashSet.addAll(this.expr.getVars());
        } else {
            hashSet.add(this.var.name.toUpperCase());
        }
        return hashSet;
    }

    public Set<String> getJoinVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.expr != null) {
            hashSet.addAll(this.expr.getfJoinVars());
        }
        return hashSet;
    }

    public void setLexVars(Set<String> set) {
        if (this.expr != null) {
            this.expr.setLexVars(set);
        }
    }

    public void setInScopeVars(Set<String> set) {
        if (this.expr != null) {
            this.expr.setInScopeVars(set, set);
        }
    }

    public void setDefBoundVars(Set<String> set) {
        if (this.expr != null) {
            this.expr.setDefBoundVars(set);
        }
    }

    public void setVar(ASTTripleAtom aSTTripleAtom) {
        this.var = aSTTripleAtom;
    }

    public void setExprTree(Node node) {
        this.exprTree = node;
    }

    public void setExpr(Filter filter) {
        this.expr = filter;
    }

    public boolean isAliased() {
        boolean bl = false;
        if (this.getExprTree() != null && this.getVar() != null) {
            bl = true;
        }
        return bl;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }
}

