/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RelationalBGP;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SPARQLTriplesBlock;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.UnionSPARQLTreeNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class RelationalSPARQLTreeNode
implements SPARQLTreeNode {
    protected static final String LHS_ALIAS = "r1";
    protected static final String RHS_ALIAS = "r2";
    protected static final String MAIN_ALIAS = "R";
    protected SQLGenContext ctx;
    protected int type;
    protected SPARQLBGP myBGP;
    protected String sparqlText;
    protected int overloadedServiceInfo;
    protected List<Filter> myFilters;
    protected SPARQLTreeNode parent;
    protected List<SPARQLTreeNode> children;
    protected Set<String> projectVars;
    protected List<Filter> localBGPFilters;
    protected List<Filter> localNonBGPFilters;
    protected List<List<Filter>> childJoinFilters;
    protected Set<String> bgpProjectSuperSet;
    protected List<Set<String>> childProjectSuperSets;
    protected String vid_alias = "$RDFVID";
    protected String vtype_alias = "$RDFVTYP";
    protected String prefix_alias = "$_PREFIX";
    protected String suffix_alias = "$_SUFFIX";
    protected String litType_alias = "$RDFLTYP";
    protected String langType_alias = "$RDFLANG";
    protected String longLit_alias = "$RDFCLOB";
    protected int limit;
    protected String[] varProjColumns;
    protected boolean graphQuery = false;
    protected ASTTripleAtom activeGraph = null;

    public RelationalSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2) {
        this.ctx = sQLGenContext;
        this.type = n;
        this.myBGP = new RelationalBGP(n2, sQLGenContext);
        this.myFilters = new ArrayList<Filter>();
        this.projectVars = new HashSet<String>();
        this.parent = null;
        this.children = new ArrayList<SPARQLTreeNode>();
        this.localBGPFilters = new ArrayList<Filter>();
        this.localNonBGPFilters = new ArrayList<Filter>();
        this.childJoinFilters = new ArrayList<List<Filter>>();
        this.bgpProjectSuperSet = new HashSet<String>();
        this.childProjectSuperSets = new ArrayList<Set<String>>();
        this.varProjColumns = new String[7];
        this.varProjColumns[0] = this.vid_alias;
        this.varProjColumns[1] = "";
        this.varProjColumns[2] = this.vtype_alias;
        this.varProjColumns[3] = this.prefix_alias;
        this.varProjColumns[4] = this.suffix_alias;
        this.varProjColumns[5] = this.litType_alias;
        this.varProjColumns[6] = this.langType_alias;
        this.graphQuery = false;
        this.activeGraph = null;
        this.overloadedServiceInfo = 0;
    }

    @Override
    public void setType(int n) {
        this.type = n;
    }

    @Override
    public void setParent(SPARQLTreeNode sPARQLTreeNode) {
        this.parent = sPARQLTreeNode;
    }

    @Override
    public void addChild(SPARQLTreeNode sPARQLTreeNode) {
        this.children.add(sPARQLTreeNode);
    }

    @Override
    public void addChild(SPARQLTreeNode sPARQLTreeNode, int n) {
        this.children.add(n, sPARQLTreeNode);
    }

    @Override
    public void addTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) {
        this.myBGP.addTriplesBlock(sPARQLTriplesBlock);
    }

    @Override
    public void addFilter(Filter filter) {
        this.myFilters.add(filter);
    }

    @Override
    public void addUserHint(String string) {
        this.myBGP.addUserHint(string);
    }

    @Override
    public String getJoinHint(String string, String string2) {
        String string3 = "";
        return string3;
    }

    @Override
    public String getAntiJoinHint() {
        String string = "";
        return string;
    }

    @Override
    public void pushBGP(SPARQLBGP sPARQLBGP, String string) {
        if (this.myBGP.getNumTriples() > 0) {
            this.myBGP.pushBGP(sPARQLBGP, string);
        }
    }

    @Override
    public boolean needsParentBGPPushDown() {
        boolean bl = false;
        if (this.myBGP.getNumTriples() > 0) {
            bl = this.myBGP.needsParentBGPPushDown();
        } else {
            for (int i = 0; i < this.getNumChildren(); ++i) {
                SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
                if (!sPARQLTreeNode.needsParentBGPPushDown()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public void setIsGraphQuery(boolean bl) {
        this.graphQuery = bl;
        this.myBGP.setIsGraphQuery(bl);
    }

    @Override
    public boolean isGraphQuery() {
        return this.graphQuery;
    }

    @Override
    public void setActiveGraph(ASTTripleAtom aSTTripleAtom) {
        this.activeGraph = aSTTripleAtom;
        this.myBGP.setActiveGraph(aSTTripleAtom);
    }

    @Override
    public ASTTripleAtom getActiveGraph() {
        return this.activeGraph;
    }

    @Override
    public void addJoinVarsForHint(Set<String> set) {
        this.myBGP.addJoinVarsForHint(set);
    }

    @Override
    public void setPushedBGPs() throws RDFException {
    }

    @Override
    public void setLexVars() throws RDFException {
    }

    @Override
    public void setInScopeLexVars(Set<String> set) throws RDFException {
    }

    @Override
    public void initFilters() throws RDFException {
    }

    @Override
    public void verifyPushedBGPs() throws RDFException {
    }

    @Override
    public void propagateLexVars() throws RDFException {
    }

    @Override
    public void markForUnmask() {
    }

    @Override
    public void unmarkForUnmask() {
    }

    @Override
    public void setInScopeVars(Set<String> set) throws RDFException {
    }

    @Override
    public void setBindIds(SortedSet<Integer> sortedSet) {
    }

    @Override
    public SortedSet<Integer> getBindIds() {
        return null;
    }

    @Override
    public Set<String> getCumulativeBindVars() {
        return null;
    }

    @Override
    public void setSparqlText(String string) {
        this.sparqlText = string;
    }

    @Override
    public String getSparqlText() {
        return this.sparqlText;
    }

    @Override
    public void setOverloadedServiceInfo(int n) {
        this.overloadedServiceInfo = n;
    }

    @Override
    public int getOverloadedServiceInfo() {
        return this.overloadedServiceInfo;
    }

    @Override
    public void addProjectVars(Set<String> set) {
        this.projectVars.addAll(set);
    }

    @Override
    public void addProjectVar(String string) {
        this.projectVars.add(string);
    }

    @Override
    public Set<String> getAllLexVars() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getRequiredLexVars() {
        return new HashSet<String>();
    }

    @Override
    public void addLexVar(String string) {
    }

    @Override
    public void addLexVars(Set<String> set) {
    }

    @Override
    public boolean isEmpty() {
        if (this.getParent() instanceof UnionSPARQLTreeNode) {
            return false;
        }
        return this.getNumChildren() == 0 && (this.myBGP == null || this.myBGP.getNumTriples() == 0);
    }

    @Override
    public boolean containsEmptyBGP() {
        if (this.myBGP == null || this.myBGP.getNumTriples() == 0) {
            return true;
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            if (!sPARQLTreeNode.containsEmptyBGP()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEmptyLocalBGP() {
        if ((this.ctx.contextFlags & 3) > 0) {
            return false;
        }
        return this.myBGP == null || this.myBGP.getNumTriples() == 0;
    }

    @Override
    public Set<String> getDefiniteBoundVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getBGPVars());
        return hashSet;
    }

    @Override
    public Set<String> getDefiniteBoundAndPushedVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getBGPAndPushedVars());
        return hashSet;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public SPARQLTreeNode getParent() {
        return this.parent;
    }

    @Override
    public SPARQLTreeNode getChild(int n) {
        return this.children.get(n);
    }

    @Override
    public SPARQLTreeNode removeChild(int n) {
        return this.children.remove(n);
    }

    @Override
    public int getNumChildren() {
        return this.children.size();
    }

    @Override
    public List<Filter> getLocalFilters() {
        Set<String> set = this.getCumulativeVars();
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : this.myFilters) {
            if (!set.containsAll(filter.getVars())) continue;
            arrayList.add(filter);
        }
        return arrayList;
    }

    @Override
    public List<Filter> getNonLocalFilters() {
        Set<String> set = this.getCumulativeVars();
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : this.myFilters) {
            if (set.containsAll(filter.getVars())) continue;
            arrayList.add(filter);
        }
        return arrayList;
    }

    @Override
    public List<Filter> getAllFilters() {
        return this.myFilters;
    }

    @Override
    public Set<String> getBGPVars() {
        return this.myBGP.getBGPVars();
    }

    @Override
    public Set<String> getBGPAndPushedVars() {
        return this.myBGP.getBGPAndPushedVars();
    }

    @Override
    public Set<String> getCumulativeVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            hashSet.addAll(sPARQLTreeNode.getCumulativeVars());
        }
        hashSet.addAll(this.myBGP.getBGPVars());
        return hashSet;
    }

    @Override
    public Set<String> getCumulativeAndPushedVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            hashSet.addAll(sPARQLTreeNode.getCumulativeAndPushedVars());
        }
        hashSet.addAll(this.myBGP.getBGPAndPushedVars());
        return hashSet;
    }

    @Override
    public Set<String> getPushCandidates() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Filter object : this.myFilters) {
            hashSet.addAll(object.getVars());
        }
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            hashSet.addAll(sPARQLTreeNode.getPushCandidates());
        }
        return hashSet;
    }

    @Override
    public Set<String> getCumulativeHintVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.myBGP != null) {
            hashSet.addAll(this.myBGP.getHintVars());
        }
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            hashSet.addAll(sPARQLTreeNode.getCumulativeHintVars());
        }
        return hashSet;
    }

    @Override
    public Set<String> getProjectVars() {
        return this.projectVars;
    }

    @Override
    public void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2) {
        this.myBGP.genOuterSelectComponents(set, set2, map, stringArray, stringArray2, map2);
    }

    @Override
    public String buildSubQForCLOB(String string, String string2, String string3) {
        return this.myBGP.buildSubQForCLOB(string, string2, string3);
    }

    @Override
    public void pushJoinVarsForHint() {
    }

    @Override
    public void setLimit(int n) {
        this.limit = n;
    }

    @Override
    public String toSQL() throws RDFException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        this.allocateFilters();
        this.setProjections();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Set<String> set = null;
        Set<String> set2 = null;
        Set<String> set3 = null;
        Set<String> set4 = null;
        int n = this.getNumChildren();
        int n2 = 0;
        boolean bl = false;
        string = this.myBGP.toSQL();
        set = this.myBGP.getBGPVars();
        set3 = this.myBGP.getBGPVars();
        bl = this.myBGP.getNumTriples() == 0;
        for (int i = n2; i < n; ++i) {
            object = this.getChild(i);
            string2 = object.toSQL();
            set2 = object.getCumulativeVars();
            set4 = object.getDefiniteBoundVars();
            bl = bl || object.containsEmptyBGP();
            string4 = this.buildSelect(set, set2, this.childProjectSuperSets.get(i), LHS_ALIAS, RHS_ALIAS);
            string5 = this.buildFrom(string, string2, object.getType());
            string6 = this.buildOn(set, set2, set3, set4, this.childJoinFilters.get(i), bl);
            string = string3 = string4 + "\n" + string5 + "\n" + string6;
            set.addAll(set2);
            if (object.getType() != 0) continue;
            set3.addAll(set4);
        }
        if (this.localNonBGPFilters.isEmpty()) {
            stringBuffer.append(string);
        } else {
            String string7 = this.buildSelect(set, new HashSet<String>(), this.projectVars, MAIN_ALIAS, "");
            object = "FROM (" + string + ") " + MAIN_ALIAS;
            String string8 = this.buildFinalWhere();
            stringBuffer.append(string7);
            stringBuffer.append("\n");
            stringBuffer.append((String)object);
            stringBuffer.append("\n");
            stringBuffer.append(string8);
        }
        return stringBuffer.toString();
    }

    protected Set<String> getCommonVars(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!set2.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected Set<String> getDistinctVars(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (set2.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected String buildFinalWhere() throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        Map<String, String> map = this.buildFilterAliasMap(this.getCumulativeVars(), new HashSet<String>(), MAIN_ALIAS, "");
        for (Filter filter : this.localNonBGPFilters) {
            QueryUtils.appendToList(stringBuffer, "(" + filter.toSQL(map, this.ctx.funcTypeMap, this.ctx.funcHandMap) + ")", " AND\n", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("(1=1)");
        }
        return "WHERE " + stringBuffer.toString();
    }

    @Override
    public void allocateFilters() throws RDFException {
        this.localBGPFilters = new ArrayList<Filter>();
        this.localNonBGPFilters = new ArrayList<Filter>();
        this.childJoinFilters = new ArrayList<List<Filter>>();
        Set<String> set = this.getBGPVars();
        List<Filter> list = this.getLocalFilters();
        for (Filter filter : list) {
            if (set.containsAll(filter.getVars())) {
                this.localBGPFilters.add(filter);
                continue;
            }
            this.localNonBGPFilters.add(filter);
        }
        for (Filter filter : this.localBGPFilters) {
            this.myBGP.addFilter(filter);
        }
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            ArrayList<Filter> arrayList = new ArrayList<Filter>();
            arrayList.addAll(sPARQLTreeNode.getNonLocalFilters());
            this.childJoinFilters.add(arrayList);
        }
    }

    @Override
    public void setProjections() throws RDFException {
        SPARQLTreeNode sPARQLTreeNode;
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getProjectVars());
        for (Filter filter : this.localNonBGPFilters) {
            hashSet.addAll(filter.getVars());
        }
        int n2 = this.getNumChildren();
        for (int i = 0; i < n2; ++i) {
            HashSet<String> hashSet2 = new HashSet<String>();
            hashSet2.addAll(hashSet);
            this.childProjectSuperSets.add(hashSet2);
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        for (n = n2 - 1; n >= 0; --n) {
            sPARQLTreeNode = this.getChild(n);
            for (Filter filter : sPARQLTreeNode.getNonLocalFilters()) {
                hashSet3.addAll(filter.getVars());
            }
            this.childProjectSuperSets.get(n).addAll(hashSet3);
        }
        this.bgpProjectSuperSet = new HashSet<String>();
        this.bgpProjectSuperSet.addAll(hashSet);
        this.bgpProjectSuperSet.addAll(hashSet3);
        this.myBGP.addProjectVars(this.getCommonVars(this.bgpProjectSuperSet, this.myBGP.getBGPVars()));
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.addProjectVars(this.getCommonVars(this.childProjectSuperSets.get(n), sPARQLTreeNode.getCumulativeVars()));
        }
    }

    protected Map<String, String> buildFilterAliasMap(Set<String> set, Set<String> set2, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object2 : set2) {
            hashMap.put(object2, string2 + "." + object2);
        }
        Set<String> set3 = this.getDistinctVars(set, set2);
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            hashMap.put(string3, string + "." + string3);
        }
        return hashMap;
    }

    protected String buildSelectForVar(String string, String string2, Set<String> set) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        n = set.contains(string2) ? 7 : 1;
        for (int i = 0; i < n; ++i) {
            QueryUtils.appendToList(stringBuffer, string + "." + string2 + this.varProjColumns[i] + " AS " + string2 + this.varProjColumns[i], ", ", "");
        }
        return stringBuffer.toString();
    }

    protected String buildCoalesceForVar(String string, String string2, String string3, Set<String> set) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        n = set.contains(string3) ? 7 : 1;
        for (int i = 0; i < n; ++i) {
            QueryUtils.appendToList(stringBuffer, "COALESCE (" + string + "." + string3 + this.varProjColumns[i] + ", " + string2 + "." + string3 + this.varProjColumns[i] + ") " + "AS " + string3 + this.varProjColumns[i], ", ", "");
        }
        return stringBuffer.toString();
    }

    protected String buildSelect(Set<String> set, Set<String> set2, Set<String> set3, String string, String string2) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set4 = this.getDistinctVars(set, set2);
        Set<String> set5 = this.getCommonVars(set, set2);
        Set<String> set6 = this.getDistinctVars(set2, set);
        for (String string4 : set4) {
            string3 = this.buildSelectForVar(string, string4, set3);
            QueryUtils.appendToList(stringBuffer, string3, ",\n", "");
        }
        for (String string4 : set5) {
            string3 = this.buildCoalesceForVar(string, string2, string4, set3);
            QueryUtils.appendToList(stringBuffer, string3, ",\n", "");
        }
        for (String string4 : set6) {
            string3 = this.buildSelectForVar(string2, string4, set3);
            QueryUtils.appendToList(stringBuffer, string3, ",\n", "");
        }
        if ((this.ctx.contextFlags & 3) > 0) {
            if (string2.equals("")) {
                QueryUtils.appendToList(stringBuffer, " " + string + ".T0_CTXT2 as T0_CTXT2 ", ",\n ", "");
            } else {
                QueryUtils.appendToList(stringBuffer, " nvl(" + string + ".T0_CTXT2, " + string2 + ".T0_CTXT2) as T0_CTXT2 ", ",\n ", "");
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("1\n");
        }
        return "SELECT " + stringBuffer.toString();
    }

    protected String buildFrom(String string, String string2, int n) {
        String string3 = "INNER JOIN";
        if (n == 1) {
            string3 = "LEFT OUTER JOIN";
        }
        return "FROM (" + string + ") " + LHS_ALIAS + "\n" + string3 + "\n" + "(" + string2 + ") " + RHS_ALIAS;
    }

    /*
     * WARNING - void declaration
     */
    protected String buildOn(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, List<Filter> list, boolean bl) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set5 = this.getCommonVars(set, set2);
        for (String object : set5) {
            void var11_17;
            String string = "(r1." + object + this.vid_alias + " = " + RHS_ALIAS + "." + object + this.vid_alias;
            if (!set3.contains(object)) {
                String string2 = string + " OR r1." + object + this.vid_alias + " IS NULL";
            }
            if (!set4.contains(object)) {
                void var11_15;
                String string3 = (String)var11_15 + " OR r2." + object + this.vid_alias + " IS NULL";
            }
            String string4 = (String)var11_17 + ")";
            QueryUtils.appendToList(stringBuffer, string4, " AND\n", "");
        }
        if (bl && (this.ctx.contextFlags & 3) > 0 || (this.ctx.contextFlags & 2) > 0) {
            QueryUtils.appendToList(stringBuffer, "(coalesce(r1.T0_CTXT2,r2.T0_CTXT2,'RDFCTX$NULLCTX') = coalesce(r2.T0_CTXT2,r1.T0_CTXT2,'RDFCTX$NULLCTX'))", " AND\n", "");
        } else if ((this.ctx.contextFlags & 1) > 0) {
            QueryUtils.appendToList(stringBuffer, "(r1.T0_CTXT2 = r2.T0_CTXT2)", " AND\n", "");
        }
        Map<String, String> map = this.buildFilterAliasMap(set, set2, LHS_ALIAS, RHS_ALIAS);
        for (Filter filter : list) {
            String string = "(" + filter.toSQL(map, this.ctx.funcTypeMap, this.ctx.funcHandMap) + ")";
            QueryUtils.appendToList(stringBuffer, string, " AND\n", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("(1=1)");
        }
        return "ON (" + stringBuffer.toString() + ")";
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + this.getClass().getName() + ": Type [" + this.type + "]\n";
        string2 = string2 + string + "BGP: \n";
        string2 = string2 + this.myBGP.toString(string) + "\n";
        for (Filter object : this.myFilters) {
            string2 = string2 + object.toString(string) + "\n";
        }
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            string2 = string2 + sPARQLTreeNode.toString(string + "  ") + "\n";
        }
        return string2;
    }
}

