/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.io.Serializable;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.spatial.rdf.server.BGPNodeInfo;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.DBDictionaryInfo;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.HintZeroHintGenerator;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RRTabRowInfo;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SPARQLTriplesBlock;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SpatialFilterHandler;
import oracle.spatial.rdf.server.TPOmap;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ASTBuiltInCall;
import oracle.spatial.rdf.server.parser.sparql.ASTComparisonOperator;
import oracle.spatial.rdf.server.parser.sparql.ASTIRIrefOrFunction;
import oracle.spatial.rdf.server.parser.sparql.ASTRelationalExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTUnaryOperator;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.predVarMapping;
import oracle.spatial.util.Util;

public class RelationalBGP
implements SPARQLBGP {
    public static final int VARCHAR2_SIZE_LIMIT = 4000;
    public static final String XSD_PREFIX = "http://www.w3.org/2001/XMLSchema#";
    public static final String XSD_STRING_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#string";
    public static final String XSD_FLOAT_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#float";
    public static final String XSD_DOUBLE_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#double";
    public static final String XSD_DATE_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#date";
    public static final String XSD_DATETIME_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#dateTime";
    public static final String XSD_DECIMAL_NO_ENCLOSING = "http://www.w3.org/2001/XMLSchema#decimal";
    public static final String XSD_STRING = "<http://www.w3.org/2001/XMLSchema#string>";
    public static final String XSD_FLOAT = "<http://www.w3.org/2001/XMLSchema#float>";
    public static final String XSD_DOUBLE = "<http://www.w3.org/2001/XMLSchema#double>";
    public static final String XSD_DATE = "<http://www.w3.org/2001/XMLSchema#date>";
    public static final String XSD_DATETIME = "<http://www.w3.org/2001/XMLSchema#dateTime>";
    public static final String XSD_DECIMAL = "<http://www.w3.org/2001/XMLSchema#decimal>";
    private static final String FORMAT_TZ = "TZH:TZM";
    private static final String FORMAT_DATE = "SYYYY-MM-DD";
    private static final String FORMAT_DATE_TZ = "SYYYY-MM-DDTZH:TZM";
    private static final String FORMAT_TIMESTAMP = "SYYYY-MM-DD\"T\"HH24:MI:SS.FF9";
    private static final String FORMAT_TIMESTAMP_TZ = "SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM";
    private static final int VN_IDX = 0;
    private static final int VT_IDX = 1;
    private static final int LT_IDX = 2;
    private static final int LA_IDX = 3;
    public static final String GENERIC_TYPE_FAMILY = "$__ORA_$_GEN_$_COL_$_TYPE__$";
    public static final String COND_CONNECTOR = " AND ";
    public static final String COND_FALSE = " AND 1=0 ";
    public static final String COND_TRUE = " AND 1=1 ";
    public static final String COND_NULL = " AND 1=0 ";
    public static final int MATCHABILITY_NO_TERMTYPE = -4;
    public static final int MATCHABILITY_NO_TYFAM = -3;
    public static final int MATCHABILITY_NO_COLTYPE = -2;
    public static final int MATCHABILITY_NO_MIN_PFX_SFX = -1;
    public static final int MATCHABILITY_UNKNOWN = 0;
    public static final int MATCHABILITY_NOT_RULED_OUT = 1;
    public static final int MATCHABILITY_YES_SIMILAR = 2;
    public static final int MATCHABILITY_YES_CONGRUENT = 3;
    public static final String LTC_TYPE_STRING = "STRING";
    public static final String LTC_TYPE_STRING_CLOB = "STRING_CLOB";
    public static final String LTC_TYPE_SDO_GEOMETRY = "SDO_GEOMETRY";
    public static final String LTC_TYPE_NUMBER = "NUMBER";
    public static final String LTC_TYPE_BFLOAT = "BFLOAT";
    public static final String LTC_TYPE_BDOUBLE = "BDOUBLE";
    public static final String LTC_TYPE_DATE = "DATE";
    public static final String LTC_TYPE_TIMESTAMP = "TIMESTAMP";
    public static final String LTC_TYPE_TIMESTAMP_TZ = "TIMESTAMP_TZ";
    public static final String LTC_TYPE_TIMESTAMP_LTZ = "TIMESTAMP_LTZ";
    public static final String TYPE_FAM_STRING = "STRING";
    public static final String TYPE_FAM_NUMERIC = "NUMERIC";
    public static final String TYPE_FAM_FLOAT = "FLOAT";
    public static final String TYPE_FAM_DOUBLE = "DOUBLE";
    public static final String TYPE_FAM_DATE = "DATE";
    public static final String TYPE_FAM_TIME = "TIME";
    public static final String TYPE_FAM_DATETIME = "DATETIME";
    public static final String TYPE_FAM_BOOLEAN = "BOOLEAN";
    public static final String TYPE_FAM_RAW = "RAW";
    public static final String TYPE_FAM_SDO_GEOMETRY = "SDO_GEOMETRY";
    public static final String TYPE_FAM_OTHER = "OTHER";
    public static final String TYPE_FAM_NUMFLTDBL = "NUMFLTDBL";
    public static final String SDO_RDF_VNAME_BEG = "sdo_rdf.vname(";
    public static final String SDO_RDF_VNAME_END = ")";
    public static final String SDO_CS_TRANSFORM_BEG = "sdo_cs.transform(";
    public static final String SDO_CS_TRANSFORM_END = ")";
    public static final String SDO_EQUAL_BEG = "sdo_equal(";
    public static final String SDO_EQUAL_END = ") = 'TRUE' ";
    public static final String DEFAULT_GEOMETRY_SRID_STR = "8307";
    public static final Long DEFAULT_GEOMETRY_SRID = Long.parseLong("8307");
    public static final String DEFAULT_GEOMETRY_DIMENSION = "sdo_dim_array(sdo_dim_element('LONGITUDE','-180','180','10'),sdo_dim_element('LATITUDE','-90','90','10'))";
    private static HashMap<String, List<String>> geo_functionArgsMap = new HashMap();
    private static Set<String> geo_funtionRequiringSridTransformationSet = new HashSet<String>();
    public static final String TZ_LOWER_VAL = "12";
    public static final String TZ_UPPER_VAL = "14";
    public static final String TZ_LOWER = "-12:00";
    public static final String TZ_UPPER = "+14:00";
    public static final String TZ_LOWER_INTERVAL = " - INTERVAL '12' HOUR";
    public static final String TZ_UPPER_INTERVAL = " + INTERVAL '14' HOUR";
    private BasicGraphPattern bgp;
    private Map<String, String> varset;
    private List<SPARQLTriplesBlock> myTrips;
    private Map<String, String> rdfTermSet;
    private List<Filter> filters;
    private HashSet<Filter> filterSet_for_BGP;
    private Map<String, Integer> hint0leadPosMap;
    private SQLGenContext ctx = null;
    private String userHint = "";
    private Set<String> projectVars;
    private Set<String> leftJoinVars;
    private Map<String, String> varAliases;
    private Map<String, String> withMap;
    private HashMap<String, DBDictionaryInfo> relPredSet;
    private HashMap<String, TPOmap> predMapSet;
    private HashSet<String> VarSet_for_BGP;
    private Map<String, String> DatatypeFam_for_var;
    private Map<String, Set<Long>> Geometry_VarSRID;
    private Map<String, String> Geometry_VarDimension;
    private HashMap<String, LtcTabRowInfo> LtcRowInfo_for_Tmap_plus_Col;
    private ArrayList<String> TFTglobalList;
    private ArrayList<String> noTFTglobalList;
    private ArrayList<TFTinfo> TFTinfoGlobalList;
    private int null_TFTidx;
    private HashMap<String, RRTabRowInfo> RRrowInfo_for_MatchingRow;
    private HashMap<String, Set<String>> RRrowSet_for_BGPconst;
    private HashMap<String, Set<String>> RRrowSet_for_BGPvar;
    private HashMap<String, Set<String>> RRrowSet_for_TriplePattern;
    private HashMap<String, ArrayList<String>> OccPosList_for_Var;
    private HashMap<String, ArrayList<Filter>> FilterList_for_Var;
    private HashMap<String, ArrayList<String>> SimpleConstraintList_for_Var;
    private HashSet<RelExpr> RelExprFilterList_for_BGP;
    private HashSet<RelExpr> TwoVarRelExprFilterList_for_BGP;
    private HashSet<String> VarSet_filter2vCond_outer;
    private HashMap<String, Set<String>> TmapSet_for_svar;
    private HashSet<String> Tmaps_with_nonUnique_Smaps;
    private HashMap<String, Set<String>> PredConstSet_for_pvar;
    private HashMap<String, String> Subj_for_TpatCSRGroup;
    private HashMap<String, Set<String>> TmapSet_for_TpatCSRGroup;
    private HashMap<String, Set<String>> TpatSet_for_TpatCSRGroup;
    private HashMap<String, String> CSRAlias_for_TpatCSRGroup;
    private HashMap<String, Set<String>> CSRAliasSet_for_tuple;
    private HashMap<String, ArrayList<String>> predList_for_CSRAlias;
    private HashMap<String, ArrayList<String>> objeList_for_CSRAlias;
    private HashMap<String, ArrayList<String>> varsList_for_CSRAlias;
    private HashMap<String, ArrayList<ArrayList<String>>> TrueMatchingRRrowListList_for_CSRAliasPlusTmap;
    private ArrayList<String> RRrowList_All;
    private HashMap<String, String> FullOccInfo_for_VarPlusCSRAlias;
    private HashMap<String, Set<String>> TypeInfoSet_for_VarPlusCSRAlias;
    private HashMap<String, ArrayList<String>> NativeVarList_for_CSRAlias;
    private HashSet<String> CLOBVarPlusCSRAliasSet_for_BGP;
    private HashMap<String, TriplesBlock> TpatInfo_for_TpatKey;
    private HashMap<String, String> LtabExpr_for_Tmap;
    private HashMap<String, String> SubjExpr_for_Tmap;
    private HashMap<String, Integer> sTFT_idx_for_Tmap;
    private HashMap<String, String> SubjRRrowid_for_Tmap;
    private HashMap<String, String> RRrowFlags_for_Tmap;
    private List<TriplesBlock> dummyTBList;
    private ArrayList<String> condForNullSkipping;
    private static final String NATIVE_SUFFIX = "$";
    private static final String FUNC_DECL;
    private static final String RRrowSelList = ", Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr";
    private static final String LtcRowSelList = "Tmap, col_Name, col_type, col_type_name, col_max_len, col_precision, col_scale";
    private static final String rrIRI = "<http://www.w3.org/ns/r2rml#IRI>";
    private static final String rrBlankNode = "<http://www.w3.org/ns/r2rml#BlankNode>";
    private static final String rrLiteral = "<http://www.w3.org/ns/r2rml#Literal>";
    private static final String rrDefaultGraph = "<http://www.w3.org/ns/r2rml#defaultGraph>";
    private static final String BASE_PREFIX_COLNAME_SEP = " ";
    private static final String BASE_PREFIX_BEGMARK = " BASE=";
    private static final String ESC_SBYTE_OFF = " ESC_SBYTE_OPT=F ";
    private static final String URL_ESCAPE_BEG = "sdo_rdf.pencd(";
    private static final String URL_ESCAPE_END = ",1)";
    private static final String URL_UNESCAPE_BEG = "sys.utl_url.unescape(";
    private static final String URL_UNESCAPE_END = ")";
    private static final String URL_ESCAPE_END_SBOFF = ", options=>' ESC_SBYTE_OPT=F ')";
    private static final String TTL_ESCAPE_BEG = "sdo_rdf.escape_rdf_value(";
    private static final String TTL_ESCAPE_END = ")";
    private static final String TTL_ESCAPE_CLOB_BEG = "sdo_rdf.escape_clob_value(";
    private static final String TTL_ESCAPE_CLOB_END = ")";
    private static final String TTL_CONVERT_TO_WKT_BEG = "sdo_rdf.convert_to_wkt_literal(";
    private static final String TTL_CONVERT_TO_WKT_END = ",col_SRID=>NVL(%TABLE_NAME%.%COLUMN_NAME%.SDO_SRID, %DBCOLTYPE_SRID%),options=>' VNAME=T ')";
    private static final String TTL_COMPARE_CLOB_BEG = "dbms_lob.compare(";
    private static final String TTL_COMPARE_CLOB_END = ")";
    private static final String TTL_ESCAPE_UNI_ONLY_END = ")";
    private static final String TTL_ESCAPE_END_SBOFF = ", options=>' ESC_SBYTE_OPT=F ')";
    private static final String TTL_UNESCAPE_BEG = "sdo_rdf.unescape_rdf_value(";
    private static final String TTL_UNESCAPE_END = ")";
    private static final String TTL_UNESCAPE_CLOB_BEG = "sdo_rdf.unescape_clob_value(";
    private static final String TTL_UNESCAPE_CLOB_END = ")";
    private static final HashMap<String, String> sqlcompOper_clobCompare_map;
    final String GRAPH_CLAUSE_CONSTANT_MISMATCH = "0";
    private static final String NO_DB_COL_TYPE = "NO_DB_COL_TYPE";
    private static final String ALIAS_SEP = " AS ";
    private int graph_use_mode;
    private static final int FROM_CLAUSE = 1;
    private static final int FROM_NAMED_CLAUSE = 2;
    private static final int GRAPH_CLAUSE = 4;
    private boolean graphMatchUnnamed;
    private String bgp_graph;
    private boolean is_bgp_graph_const;
    private boolean is_bgp_graph_a_var;
    private int id;
    private boolean m_bLog = false;
    private HintGenerator hintG;
    private String sqlHint;
    private boolean rtyp_pred_only;
    private Integer alias;
    private int model_id;
    private String rr_tab_qname;
    private String Ltc_tab_qname;
    private String rr_tab_dummy_query;
    private int queryOptions = 0;
    private String defaultOwner;
    private String subjectCol = "START_NODE_ID";
    private String predicateCol = "P_VALUE_ID";
    private String canonObjCol = "CANON_END_NODE_ID";
    private String exactObjCol = "END_NODE_ID";
    private String values_tab = "MDSYS.RDF_VALUE$";
    private String vname_col = "VALUE_NAME";
    private String vid_col = "VALUE_ID";
    private String vtype_col = "VALUE_TYPE";
    private String prefix_col = "VNAME_PREFIX";
    private String suffix_col = "VNAME_SUFFIX";
    private String litType_col = "LITERAL_TYPE";
    private String langType_col = "LANGUAGE_TYPE";
    private String longLit_col = "LONG_VALUE";
    private String vid_alias = "$RDFVID";
    private String vtype_alias = "$RDFVTYP";
    private String prefix_alias = "$_PREFIX";
    private String suffix_alias = "$_SUFFIX";
    private String litType_alias = "$RDFLTYP";
    private String langType_alias = "$RDFLANG";
    private String longLit_alias = "$RDFCLOB";
    private boolean graphQuery = false;
    private ASTTripleAtom activeGraph = null;
    private String graphVar = null;
    private String rdftyp_pred = "834132227519661324";
    private String ini_delimiter = "{";
    private String fnl_delimiter = "}";
    private static final String delim = "\\";
    private static Set<String> spcl_chars;

    private static HashMap<String, String> create_map_of_strings(String[] stringArray, String[] stringArray2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        for (String string : stringArray) {
            hashMap.put(string, stringArray2[n++]);
        }
        return hashMap;
    }

    private void log(String string) {
        RelationalBGP.log_static(string, this.ctx.R2RFlags);
    }

    private void log(String string, long l) {
        RelationalBGP.log_static(string, this.ctx.R2RFlags, l);
    }

    private static void log_static(String string, long l) {
        long l2 = 1L;
        RelationalBGP.log_static(string, l, l2);
    }

    private static void log_static(String string, long l, long l2) {
        long l3 = l & 7L;
        if (l2 <= l3) {
            System.out.print(string + "\n");
        }
    }

    private String prettyPrintCond(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = string.indexOf(COND_CONNECTOR) + 1;
        int n2 = 0;
        while (true) {
            int n3 = string.indexOf(COND_CONNECTOR, n);
            n = n3 + 1;
            if (n3 == -1) break;
            stringBuffer.append(string.substring(n2, n3) + "\n");
            n2 = n3;
        }
        stringBuffer.append(string.substring(n2) + "\n");
        return stringBuffer.toString();
    }

    private void dumpUnionArrayRow(String string, int n, ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, ArrayList<String> arrayList4, ArrayList<ArrayList<String>> arrayList5, ArrayList<String> arrayList6, ArrayList<ArrayList<String>> arrayList7) {
        this.log("Tmap=" + string + " ++++++++++++++++++++++++++++++++++ rowNum=" + n + "+++++++++++++++++++++++++++++++++++++++");
        this.log("RRrLArray[" + n + "]: " + arrayList.get(n));
        this.log("fromArray[" + n + "]: " + arrayList2.get(n));
        this.log("condArray[" + n + "]: \n" + arrayList3.get(n));
        this.log(this.prettyPrintCond(arrayList3.get(n)));
        for (int i = 0; i < arrayList4.size(); ++i) {
            this.log("pred-obje[" + i + "]=[ " + arrayList4.get(i) + BASE_PREFIX_COLNAME_SEP + arrayList6.get(i) + " ]");
            this.log("  pExpr : " + arrayList5.get(i).get(n));
            this.log("  -oExpr: " + arrayList7.get(i).get(n));
        }
    }

    private static String get_base_prefix_from_RR_table(String string) {
        String string2 = null;
        int n = BASE_PREFIX_BEGMARK.length();
        if (string.indexOf(BASE_PREFIX_BEGMARK) == 0) {
            string2 = string.substring(n, string.indexOf(BASE_PREFIX_COLNAME_SEP, n));
        }
        return string2;
    }

    private static String get_col_name_from_RR_table(String string) {
        String string2 = string;
        int n = BASE_PREFIX_BEGMARK.length();
        if (string.indexOf(BASE_PREFIX_BEGMARK) == 0) {
            string2 = string.substring(string.indexOf(BASE_PREFIX_COLNAME_SEP, n) + 1, string.length());
        }
        return string2;
    }

    private static String matchabilityPlusCond(String[] stringArray, TFTinfo tFTinfo, TFTinfo tFTinfo2, String string, int n, String string2, int n2, String string3, HashMap<String, RRTabRowInfo> hashMap, SQLGenContext sQLGenContext) {
        RelationalBGP.log_static("Entered matchabilityPlusCond", sQLGenContext.R2RFlags);
        RelationalBGP.log_static("L_TFTinfo:\n" + tFTinfo.toString(), sQLGenContext.R2RFlags);
        RelationalBGP.log_static("R_TFTinfo:\n" + tFTinfo2.toString(), sQLGenContext.R2RFlags);
        boolean bl = false;
        int n3 = 0;
        String string4 = "";
        RRTabRowInfo rRTabRowInfo = hashMap.get(string);
        RRTabRowInfo rRTabRowInfo2 = hashMap.get(string2);
        ArrayList<String> arrayList = rRTabRowInfo.colLists.get(n);
        ArrayList<String> arrayList2 = rRTabRowInfo2.colLists.get(n2);
        if (!tFTinfo.termType.equals(tFTinfo2.termType)) {
            n3 = -4;
        } else if (tFTinfo.termType.equals(rrLiteral) && !bl && !tFTinfo.datatype_family.equals(tFTinfo2.datatype_family)) {
            n3 = -3;
        } else if (tFTinfo.termType.equals(rrLiteral) && bl && !tFTinfo.datatype.equals(tFTinfo2.datatype)) {
            n3 = -3;
        } else if (tFTinfo.exprType == RRTabRowInfo.MapExprType_TEMPLATE && tFTinfo2.exprType == RRTabRowInfo.MapExprType_TEMPLATE) {
            RelationalBGP.log_static("Case: Template-Template", sQLGenContext.R2RFlags);
            if (tFTinfo.termType.equals(rrIRI) && tFTinfo2.termType.equals(rrIRI)) {
                RelationalBGP.log_static("sub-case: Template-Template/IRI-IRI", sQLGenContext.R2RFlags);
                if (tFTinfo.TFTidx == tFTinfo2.TFTidx) {
                    RelationalBGP.log_static("leaf-case: Template-Template/IRI-IRI + congruent TFTs", sQLGenContext.R2RFlags);
                    n3 = 3;
                    RelationalBGP.log_static("leaf-case: Template-Template/IRI-IRI + congruent TFTs: matchability_status" + n3, sQLGenContext.R2RFlags);
                    if (string3 != null) {
                        if (tFTinfo.numIsolStrs > 0) {
                            for (int i = 0; i < tFTinfo.numCols; ++i) {
                                if (tFTinfo.strIsolList.get(i) == null || tFTinfo.strIsolList.get(i + 1) == null) continue;
                                string4 = string4 + COND_CONNECTOR + string3 + "." + arrayList.get(i) + "=" + string3 + "." + arrayList2.get(i);
                            }
                            stringArray[0] = string4;
                            stringArray[1] = tFTinfo.numIsolStrs == tFTinfo.numCols + 1 ? "REPLACE_NON_OPTIM_COND" : "APPEND_TO_NON_OPTIM_COND";
                        } else {
                            stringArray[1] = "NO_OPTIM_COND_POSSIBLE";
                        }
                    }
                } else if (tFTinfo.strList.equals(tFTinfo2.strList)) {
                    boolean bl2 = true;
                    n3 = 2;
                    for (int i = 0; i < tFTinfo.colTypeList.size(); ++i) {
                        String string5 = tFTinfo.colTypeList.get(i);
                        String string6 = tFTinfo2.colTypeList.get(i);
                        String string7 = "";
                        String string8 = "";
                        if (string5.equals(string6)) {
                            if (tFTinfo.strIsolList.get(i) != null && tFTinfo.strIsolList.get(i + 1) != null && tFTinfo2.strIsolList.get(i) != null && tFTinfo2.strIsolList.get(i + 1) != null) {
                                if (string3 == null) continue;
                                string4 = string4 + COND_CONNECTOR + string3 + "." + arrayList.get(i) + "=" + string3 + "." + arrayList2.get(i);
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        if (string5.equals("STRING")) {
                            if (tFTinfo.strIsolList.get(i) != null && tFTinfo.strIsolList.get(i + 1) != null || tFTinfo2.strIsolList.get(i) != null && tFTinfo2.strIsolList.get(i + 1) != null) {
                                if (string3 == null) continue;
                                string4 = string4 + COND_CONNECTOR + string3 + "." + arrayList.get(i) + "=" + "to_char(" + string3 + "." + arrayList2.get(i) + ")";
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        if (string6.equals("STRING")) {
                            if (tFTinfo.strIsolList.get(i) != null && tFTinfo.strIsolList.get(i + 1) != null || tFTinfo2.strIsolList.get(i) != null && tFTinfo2.strIsolList.get(i + 1) != null) {
                                if (string3 == null) continue;
                                string4 = string4 + COND_CONNECTOR + "to_char(" + string3 + "." + arrayList.get(i) + ")" + "=" + string3 + "." + arrayList2.get(i);
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        if ((string5.equals(LTC_TYPE_NUMBER) || string5.equals(LTC_TYPE_BFLOAT) || string5.equals(LTC_TYPE_BDOUBLE)) && (string6.equals(LTC_TYPE_NUMBER) || string6.equals(LTC_TYPE_BFLOAT) || string6.equals(LTC_TYPE_BDOUBLE))) {
                            if (tFTinfo.strIsolList.get(i) != null && tFTinfo.strIsolList.get(i + 1) != null && tFTinfo2.strIsolList.get(i) != null && tFTinfo2.strIsolList.get(i + 1) != null) {
                                if (string3 == null) continue;
                                string4 = string4 + COND_CONNECTOR + string3 + "." + arrayList.get(i) + "=" + string3 + "." + arrayList2.get(i);
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        n3 = -2;
                        break;
                    }
                    if (string3 != null && n3 == 2) {
                        stringArray[0] = string4;
                        stringArray[1] = bl2 ? "REPLACE_NON_OPTIM_COND" : (!string4.equals("") ? "APPEND_TO_NON_OPTIM_COND" : "NO_OPTIM_COND_POSSIBLE");
                    }
                } else {
                    String string9 = rRTabRowInfo.sExpr;
                    String string10 = rRTabRowInfo2.sExpr;
                    if (RelationalBGP.matchableSqlTemplatePair(string9, string10, sQLGenContext)) {
                        n3 = 1;
                        RelationalBGP.log_static("matchabilityPlusCond: general case: matchable templates: " + string9 + " and " + string10, sQLGenContext.R2RFlags);
                    } else {
                        n3 = -1;
                    }
                    RelationalBGP.log_static("leaf-case: Template-Template/IRI-IRI + general case: matchability_status" + n3, sQLGenContext.R2RFlags);
                }
            }
        } else {
            n3 = 0;
        }
        RelationalBGP.log_static("matchabilityPlusCond: matchability_status=" + n3, sQLGenContext.R2RFlags);
        if (n3 > 0) {
            return "MATCHABLE";
        }
        return "NOT-MATCHABLE";
    }

    private static String typeOfSqlTemplate(String string, SQLGenContext sQLGenContext) {
        if (string.charAt(0) == '<') {
            return "TURTLE_IRI";
        }
        if (string.indexOf("SQLexpr=") < 0) {
            return "TURTLE_NON_IRI";
        }
        return "SQL_TEMPLATE";
    }

    private static boolean matchableSqlTemplateAndConstant_genCondInfo(ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, String string, ArrayList<String> arrayList4, SQLGenContext sQLGenContext) {
        int n;
        RelationalBGP.log_static("matchableSqlTemplateAndConstant_genCondInfo: INPUT:\n strList=" + arrayList + "\n constant=" + string + "\n colList=" + arrayList2 + "\n colTypeList=" + arrayList3, sQLGenContext.R2RFlags);
        int n2 = arrayList.size() - 1;
        String string2 = arrayList.get(0);
        if (n2 == 0) {
            return string2.equals(string);
        }
        String string3 = arrayList.get(n2);
        int n3 = string.length();
        int n4 = string.indexOf(string2);
        if (n4 != 0) {
            RelationalBGP.log_static("filter NOT-MATCHABLE: first_str (" + string2 + ") leftmost match starts at pos=" + n4, sQLGenContext.R2RFlags);
            return false;
        }
        int n5 = string.lastIndexOf(string3);
        if (n5 + string3.length() != n3) {
            RelationalBGP.log_static("filter NOT-MATCHABLE: last_str (" + string3 + ") rightmost match starts at pos=" + n5, sQLGenContext.R2RFlags);
            return false;
        }
        RelationalBGP.log_static("starting forward scan ...", sQLGenContext.R2RFlags);
        int n6 = 0;
        int n7 = 0;
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        for (String object2 : arrayList) {
            if (object2.length() == 0) {
                n = n6 == n2 ? n3 : n7;
                ++n6;
                arrayList5.add(n);
                continue;
            }
            n = string.indexOf(object2, n7);
            RelationalBGP.log_static("idx=" + n6 + ",start_pos=" + n7 + "match_start_pos=" + n, sQLGenContext.R2RFlags);
            if (n < 0) {
                return false;
            }
            arrayList5.add(n);
            n7 = n + object2.length();
            ++n6;
        }
        RelationalBGP.log_static("... forward scan DONE: forward_strMatchPosList=" + arrayList5, sQLGenContext.R2RFlags);
        if ((Integer)arrayList5.get(n2) + string3.length() != n3) {
            RelationalBGP.log_static("filter MATCHABLE-BUT-NOT-OPTIMIZABLE: forward scan last str match at pos=" + arrayList5.get(n2), sQLGenContext.R2RFlags);
            return true;
        }
        RelationalBGP.log_static("starting reverse scan of RDFterm ...", sQLGenContext.R2RFlags);
        int n8 = string.length();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        for (n6 = arrayList.size() - 1; n6 >= 0; --n6) {
            String n9 = arrayList.get(n6);
            if (n9.length() == 0) {
                n = n6 == 0 ? 0 : n8;
                arrayList6.add(n);
                continue;
            }
            n = string.substring(0, n8).lastIndexOf(n9);
            RelationalBGP.log_static("idx=" + n6 + ",end_pos=" + n8 + "match_start_pos=" + n, sQLGenContext.R2RFlags);
            arrayList6.add(n);
            n8 = n;
        }
        RelationalBGP.log_static("... reverse scan of RDFterm DONE: reverse_strMatchPosList=" + arrayList6, sQLGenContext.R2RFlags);
        for (n6 = 0; n6 <= n2; ++n6) {
            n = n2 - n6;
            if (arrayList5.get(n6) == arrayList6.get(n)) continue;
            RelationalBGP.log_static("filter MATCHABLE-BUT-NOT-OPTIMIZABLE: match pos mismatch for str at idx=" + n6 + ": forward pos=" + arrayList5.get(n6) + " reverse pos=" + arrayList6.get(n), sQLGenContext.R2RFlags);
            return true;
        }
        RelationalBGP.log_static("got UNIQUE MATCH: forward and reverse scan gave same match positions", sQLGenContext.R2RFlags);
        n = 1;
        int n9 = 0;
        for (n6 = 1; n6 <= n2; ++n6) {
            String string4;
            String string5 = arrayList3.get(n6 - 1);
            if (!(string5.equals(LTC_TYPE_NUMBER) || string5.equals(LTC_TYPE_BFLOAT) || string5.equals(LTC_TYPE_BDOUBLE) || string5.equals("STRING"))) {
                RelationalBGP.log_static("matchable, but skip optim: non-numeric, non-string colType of col at idx=" + (n6 - 1) + ": " + string5, sQLGenContext.R2RFlags);
                return true;
            }
            int n10 = n9 + arrayList.get(n6 - 1).length();
            int n11 = (Integer)arrayList5.get(n6);
            String string6 = string.substring(n10, n11);
            if (string5.equals(LTC_TYPE_NUMBER) || string5.equals(LTC_TYPE_BFLOAT) || string5.equals(LTC_TYPE_BDOUBLE)) {
                try {
                    double numberFormatException = Double.parseDouble(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                    break;
                }
                string4 = string6;
            } else {
                string4 = string6;
            }
            arrayList4.add(string4);
            n9 = n11;
        }
        RelationalBGP.log_static("matchableSqlTemplateAndConstant_genCondInfo returning true (matchable): OUTPUT: colValList=" + arrayList4, sQLGenContext.R2RFlags);
        return n != 0;
    }

    private static boolean matchableSqlTemplateAndConstant(ArrayList<String> arrayList, String string, SQLGenContext sQLGenContext) {
        RelationalBGP.log_static("matchableSqlTemplateAndConstant: strList=" + arrayList, sQLGenContext.R2RFlags);
        RelationalBGP.log_static("matchableSqlTemplateAndConstant: constant=" + string, sQLGenContext.R2RFlags);
        if (arrayList.size() == 1) {
            return arrayList.get(0).equals(string);
        }
        int n = 0;
        int n2 = 0;
        for (String string2 : arrayList) {
            if (string2.length() == 0) {
                ++n;
                continue;
            }
            int n3 = string.substring(n2).indexOf(string2);
            RelationalBGP.log_static("idx=" + n + ",start_pos=" + n2 + "match_start_pos=" + n3, sQLGenContext.R2RFlags);
            if (n3 < 0) {
                return false;
            }
            if (n == 0 && n3 != 0) {
                return false;
            }
            if (n == arrayList.size() - 1 && string.substring(n2 + n3).length() > string2.length()) {
                return false;
            }
            n2 = n2 + n3 + string2.length();
            ++n;
        }
        return true;
    }

    private static boolean matchableSqlTemplatePair(String string, String string2, SQLGenContext sQLGenContext) {
        String string3;
        String string4;
        String string5;
        String string6 = string.substring(1, string.length() - 1);
        String string7 = string2.substring(1, string2.length() - 1);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            if (RelationalBGP.typeOfSqlTemplate(string, sQLGenContext).equals("SQL_TEMPLATE")) {
                string5 = RelationalBGP.sqlTempl2sqlExpr(string6, null, null, null, null, arrayList, null, sQLGenContext);
            } else {
                arrayList.add(string6);
            }
            if (RelationalBGP.typeOfSqlTemplate(string2, sQLGenContext).equals("SQL_TEMPLATE")) {
                string5 = RelationalBGP.sqlTempl2sqlExpr(string7, null, null, null, null, arrayList2, null, sQLGenContext);
            } else {
                arrayList2.add(string7);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (arrayList.size() == 1) {
            return RelationalBGP.matchableSqlTemplateAndConstant(arrayList2, (String)arrayList.get(0), sQLGenContext);
        }
        if (arrayList2.size() == 1) {
            return RelationalBGP.matchableSqlTemplateAndConstant(arrayList, arrayList2.get(0), sQLGenContext);
        }
        string5 = arrayList.get(0);
        if (string5.indexOf(string4 = arrayList2.get(0)) < 0 && string4.indexOf(string5) < 0) {
            RelationalBGP.log_static("min-pfx mismatch", sQLGenContext.R2RFlags);
            return false;
        }
        String string8 = arrayList.get(arrayList.size() - 1);
        if (string8.indexOf(string3 = arrayList2.get(arrayList2.size() - 1)) < 0 && string3.indexOf(string8) < 0) {
            RelationalBGP.log_static("min-sfx mismatch", sQLGenContext.R2RFlags);
            return false;
        }
        RelationalBGP.log_static("matchable: min-pfx and min-sfx", sQLGenContext.R2RFlags);
        return true;
    }

    private static boolean matchableSqlTemplate_in_list(String string, Collection<String> collection, SQLGenContext sQLGenContext) {
        if (collection == null) {
            return false;
        }
        for (String string2 : collection) {
            if (!RelationalBGP.matchableSqlTemplatePair(string, string2, sQLGenContext)) continue;
            RelationalBGP.log_static("FOUND MATCHABLE: (min-sfx and min-sfx match) with following template in list\n" + string2, sQLGenContext.R2RFlags);
            return true;
        }
        RelationalBGP.log_static("NOT-FOUND any MATCHABLE template for: " + string, sQLGenContext.R2RFlags);
        return false;
    }

    private int findIndexOfMatchableRRrow(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2, String string2, String string3, int n) {
        int n2 = -1;
        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(string);
        this.log("Need to compare the [pos=" + string2 + " of RRrowid=" + string + "] for matchabilty: \n" + rRTabRowInfo.toString());
        String string4 = null;
        String string5 = null;
        int n3 = -1;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (string2.equals("subject")) {
            string4 = rRTabRowInfo.sExpr;
            string5 = rRTabRowInfo.sTermType;
            if (string5 == null) {
                string5 = rrIRI;
            }
            n3 = rRTabRowInfo.sExprType;
        } else if (string2.equals("predicate")) {
            string4 = rRTabRowInfo.pExpr;
            string5 = rrIRI;
            n3 = rRTabRowInfo.pExprType;
        } else if (string2.equals("object") && rRTabRowInfo.paTmap == null) {
            string4 = rRTabRowInfo.oExpr;
            string5 = rRTabRowInfo.oTermType;
            if (string5 == null) {
                string5 = rrLiteral;
            }
            n3 = rRTabRowInfo.oExprType;
            string6 = rRTabRowInfo.oDataType;
            if (string6 != null) {
                string7 = this.TYPE_FAMILY(string6.substring(1, string6.length() - 1));
            }
            string8 = rRTabRowInfo.oLanguage;
        } else if (string2.equals("object") && rRTabRowInfo.paTmap != null) {
            string4 = rRTabRowInfo.psExpr;
            string5 = rRTabRowInfo.psTermType;
            if (string5 == null) {
                string5 = rrIRI;
            }
            n3 = rRTabRowInfo.psExprType;
        }
        for (int i = n; i < arrayList.size(); ++i) {
            String string9 = arrayList.get(i);
            String string10 = arrayList2.get(i);
            if (string10.substring(0, 2).equals("XX")) {
                this.log("rejected b/c this candidate RRrowid is marked as NON-MATCHING: RRrowid=" + string9 + " MatchInfo: " + string10);
                continue;
            }
            RRTabRowInfo rRTabRowInfo2 = this.RRrowInfo_for_MatchingRow.get(string9);
            this.log("... [z(index)=" + i + "] for matchabilty with [pos=" + string3 + " of RRrowid=" + string9 + "]: \n" + rRTabRowInfo2.toString());
            String string11 = null;
            String string12 = null;
            int n4 = -1;
            String string13 = null;
            String string14 = null;
            String string15 = null;
            if (string3.equals("subject")) {
                string11 = rRTabRowInfo2.sExpr;
                string12 = rRTabRowInfo2.sTermType;
                if (string12 == null) {
                    string12 = rrIRI;
                }
                n4 = rRTabRowInfo2.sExprType;
            } else if (string3.equals("predicate")) {
                string11 = rRTabRowInfo2.pExpr;
                string12 = rrIRI;
                n4 = rRTabRowInfo2.pExprType;
            } else if (string3.equals("object") && rRTabRowInfo2.paTmap == null) {
                string11 = rRTabRowInfo2.oExpr;
                string12 = rRTabRowInfo2.oTermType;
                if (string12 == null) {
                    string12 = rrLiteral;
                }
                n4 = rRTabRowInfo2.oExprType;
                string13 = rRTabRowInfo2.oDataType;
                if (string13 != null) {
                    string14 = this.TYPE_FAMILY(string13.substring(1, string13.length() - 1));
                }
                string15 = rRTabRowInfo2.oLanguage;
            } else if (string3.equals("object") && rRTabRowInfo2.paTmap != null) {
                string11 = rRTabRowInfo2.psExpr;
                string12 = rRTabRowInfo2.psTermType;
                if (string12 == null) {
                    string12 = rrIRI;
                }
                n4 = rRTabRowInfo2.psExprType;
            }
            this.log("checking for easy rejects: ");
            if (!string5.equals(string12)) {
                this.log("rejected due to termType mismatch: target=" + string5 + " vs. candidate=" + string12);
                continue;
            }
            if (string6 == null && string13 != null || string6 != null && string13 == null || string6 != null && string13 != null && (!string7.equals(string14) || string7.equals(TYPE_FAM_OTHER) && !string6.equals(string13))) {
                this.log("rejected due to datatype (type_family) mismatch: target=" + string6 + " (type_family: " + string7 + ") vs. candidate=" + string13 + " (type_family: " + string14 + ")");
                continue;
            }
            if (string8 == null && string15 != null || string8 != null && string15 == null || string8 != null && string15 != null && !string8.equals(string15)) {
                this.log("rejected due to language mismatch: target=" + string8 + " vs. candidate=" + string15);
                continue;
            }
            this.log("checking for easy ACCEPTs: ");
            if (n3 == RRTabRowInfo.MapExprType_COLUMN || n4 == RRTabRowInfo.MapExprType_COLUMN) {
                n2 = i;
                this.log("--- GOT An E-Z MATCHABLE! --- setting m=" + n2);
                this.log("ACCEPTED due to one or both exprType being col-valued: target=" + n3 + " vs. candidate=" + n4);
                break;
            }
            if (string4.equals(string11)) {
                n2 = i;
                this.log("--- GOT An E-Z MATCHABLE! --- setting m=" + n2);
                this.log("ACCEPTED b/c the two expressions are equal: target=" + string4 + " vs. candidate=" + string11);
                break;
            }
            if (!RelationalBGP.matchableSqlTemplatePair(string11, string4, this.ctx)) continue;
            n2 = i;
            this.log("--- GOT A MATCHABLE! --- setting m=" + n2);
            break;
        }
        return n2;
    }

    private static String r2rmlNameToSqlName(String string, SQLGenContext sQLGenContext) {
        StringBuffer stringBuffer = new StringBuffer(BASE_PREFIX_COLNAME_SEP);
        int n = 0;
        RelationalBGP.log_static(string, sQLGenContext.R2RFlags);
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = string.indexOf(delim, n3);
            if (n != -1) {
                RelationalBGP.log_static("delimiter found at position : " + n, sQLGenContext.R2RFlags);
                if (n > n3) {
                    stringBuffer.append(string.substring(n3, n - 1));
                }
                if (n + 1 < n2 && spcl_chars.contains(Character.valueOf(string.charAt(n + 1)))) {
                    stringBuffer.append(BASE_PREFIX_COLNAME_SEP);
                    n3 = n + 2;
                } else {
                    n3 = n + 1;
                }
            }
            stringBuffer.append(string.substring(n3, n2));
        }
        RelationalBGP.log_static("sqlName derived from r2rmlName is : " + stringBuffer.toString(), sQLGenContext.R2RFlags);
        return stringBuffer.toString();
    }

    private static String trimConcatOperAndSingleQuotes(String string) {
        int n = 0;
        if (string.indexOf(" || ") == 0) {
            n = " || ".length();
        }
        if (n == string.length()) {
            return "";
        }
        if (string.substring(n, n + 1).equals("'")) {
            ++n;
        }
        int n2 = string.length() - 1;
        if (string.lastIndexOf(" || ") == string.length() - " || ".length()) {
            n2 -= " || ".length();
        }
        if (string.substring(n2, n2 + 1).equals("'")) {
            --n2;
        }
        String string2 = string.substring(n, n2 + 1);
        return string2.replace("''", "'");
    }

    private static boolean isEscNeededForColDatatype(String string) {
        return !string.equals(LTC_TYPE_NUMBER) && !string.equals("DATE");
    }

    private static String sqlTempl2sqlExpr(String string, String string2, String string3, StringBuffer stringBuffer, ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, SQLGenContext sQLGenContext) throws SQLException {
        RelationalBGP.log_static("sqlTempl2sqlExpr: r2rmlTemplsql=" + string + " alias=" + string3 + "\n", sQLGenContext.R2RFlags);
        RelationalBGP.log_static("input => r2rmlTemplsql: " + string, sQLGenContext.R2RFlags);
        String string4 = URL_ESCAPE_BEG;
        String string5 = URL_ESCAPE_END;
        boolean bl = false;
        if ((sQLGenContext.R2RFlags & 0x100L) > 0L) {
            string4 = "";
            string5 = "";
            bl = true;
        } else if ((sQLGenContext.R2RFlags & 0x20000L) > 0L) {
            string5 = ", options=>' ESC_SBYTE_OPT=F ')";
        }
        String string6 = TTL_ESCAPE_BEG;
        String string7 = ")";
        if ((sQLGenContext.R2RFlags & 0x200L) > 0L) {
            string6 = "";
            string7 = "";
        } else if ((sQLGenContext.R2RFlags & 0x20000L) > 0L) {
            string7 = ", options=>' ESC_SBYTE_OPT=F ')";
        }
        RelationalBGP.log_static("ctx.R2RFlags=" + sQLGenContext.R2RFlags + " url_escape:" + string4 + string5, sQLGenContext.R2RFlags);
        RelationalBGP.log_static("ctx.R2RFlags=" + sQLGenContext.R2RFlags + " ttl_escape:" + string6 + string7, sQLGenContext.R2RFlags);
        String string8 = string.substring(string.indexOf("SQLexpr=") + "SQLexpr=".length(), string.length());
        int n = 0;
        int n2 = string.indexOf(35);
        int n3 = Integer.parseInt(string.substring(0, n2));
        StringBuffer stringBuffer2 = new StringBuffer("");
        int n4 = n2 + 1;
        int n5 = -1;
        for (int i = 0; i < n3; ++i) {
            n5 = string.indexOf(58, n4);
            int n6 = Integer.parseInt(string.substring(n4, n5)) - 1;
            n4 = n5 + 1;
            n5 = string.indexOf(44, n4);
            int n7 = Integer.parseInt(string.substring(n4, n5)) - 1;
            n4 = n5 + 1;
            String string9 = string8.substring(n, n6);
            stringBuffer2.append(string9);
            arrayList2.add(RelationalBGP.trimConcatOperAndSingleQuotes(string9));
            if (string3 != null) {
                RelationalBGP.log_static("alias=" + string3 + " url_escape_beg=: " + string4 + " url_escape_end=" + string5, sQLGenContext.R2RFlags);
                if (string2.equals(rrIRI)) {
                    if (!bl && (arrayList3 == null || RelationalBGP.isEscNeededForColDatatype(arrayList3.get(i)))) {
                        stringBuffer2.append(string4);
                    }
                } else if (string2.equals(rrLiteral)) {
                    stringBuffer2.append(string6);
                }
                stringBuffer2.append(string3);
                String string10 = string8.substring(n6 + "\"___oRa$R2RML_Ltab___\".".length(), n7 + 1);
                stringBuffer2.append(string10);
                if (string2.equals(rrIRI)) {
                    if (!bl && (arrayList3 == null || RelationalBGP.isEscNeededForColDatatype(arrayList3.get(i)))) {
                        stringBuffer2.append(string5);
                    }
                } else if (string2.equals(rrLiteral)) {
                    stringBuffer2.append(string7);
                }
                arrayList.add(string10);
                String string11 = COND_CONNECTOR + string3 + string10 + " is NOT NULL";
                if (stringBuffer != null && stringBuffer.toString().indexOf(string11) < 0) {
                    stringBuffer.append(string11);
                }
            }
            n = n7 + 1;
        }
        if (n > string8.length()) {
            arrayList2.add("");
        } else {
            String string12 = string8.substring(n, string8.length());
            stringBuffer2.append(string12);
            arrayList2.add(RelationalBGP.trimConcatOperAndSingleQuotes(string12));
        }
        RelationalBGP.log_static("strList.size()=" + arrayList2.size() + " : " + arrayList2, sQLGenContext.R2RFlags);
        if (string3 != null) {
            RelationalBGP.log_static("colList.size()=" + arrayList.size() + " : " + arrayList, 1L);
            if (stringBuffer != null) {
                RelationalBGP.log_static("notNullColCondExpr: " + stringBuffer.toString(), sQLGenContext.R2RFlags);
            }
            RelationalBGP.log_static("urifmt2sql: out_sqlExpr=\n" + stringBuffer2.toString() + "\n", sQLGenContext.R2RFlags);
            return stringBuffer2.toString();
        }
        return null;
    }

    private static String unesc_turtle_constant(String string, SQLGenContext sQLGenContext) {
        RelationalBGP.log_static("esc_val=" + string, sQLGenContext.R2RFlags);
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < string.length()) {
            char c;
            int n2 = string.indexOf(92, n);
            if (n2 < 0) {
                stringBuffer = stringBuffer.append(string.substring(n, string.length()));
                break;
            }
            if (n2 > n) {
                stringBuffer = stringBuffer.append(string.substring(n, n2));
            }
            stringBuffer = (c = string.charAt(n2 + 1)) == 'n' ? stringBuffer.append("\n") : (c == 't' ? stringBuffer.append("\t") : (c == 'r' ? stringBuffer.append("\r") : stringBuffer.append(c)));
            n = n2 + 2;
        }
        RelationalBGP.log_static("unesc_val=" + stringBuffer, sQLGenContext.R2RFlags);
        return stringBuffer.toString();
    }

    private static String vname(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '<%>') THEN substr(" + string + ",2,length(" + string + ")-2) WHEN (substr(" + string + ",1,2)='_:') THEN " + string + " WHEN (" + string + " LIKE '\"%\"') THEN substr(" + string + ",2,length(" + string + ")-2) WHEN (" + string + " LIKE '\"%\"^^<%>') THEN substr(" + string + ",2,instr(" + string + ",'\"^^<',-1)-2) WHEN (" + string + " LIKE '\"%\"@%') THEN substr(" + string + ",2,instr(" + string + ",'\"@',-1)-2) ELSE sdo_rdf.raise_parse_error('Invalid RDF term syntax', " + string + ") END)";
    }

    private static String vtype(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '<%>') THEN 'URI' WHEN (substr(" + string + ",1,2)='_:') THEN 'BLN' WHEN (" + string + " LIKE '\"%\"' OR " + string + " LIKE '\"%\"^^<%>' OR " + string + " LIKE '\"%\"@%') THEN 'LIT' ELSE sdo_rdf.raise_parse_error('Invalid RDF term syntax', " + string + ") END)";
    }

    private static String vnpfx(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '<%>') THEN NVL(substr(substr(" + string + ",2,length(" + string + ")-2),1,instr(translate(substr(" + string + ",2,length(" + string + ")-2),'/#','::'),':',-1)),substr(" + string + ",2,length(" + string + ")-2)) WHEN (substr(" + string + ",1,2)='_:') THEN " + string + " WHEN (" + string + " LIKE '\"%\"') THEN substr(" + string + ",2,length(" + string + ")-2) WHEN (" + string + " LIKE '\"%\"^^<%>') THEN substr(" + string + ",2,instr(" + string + ",'\"^^<',-1)-2) WHEN (" + string + " LIKE '\"%\"@%') THEN substr(" + string + ",2,instr(" + string + ",'\"@',-1)-2) ELSE sdo_rdf.raise_parse_error('Invalid RDF term syntax', " + string + ") END)";
    }

    private static String vnsfx(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '<%>') THEN substr(substr(" + string + ",2,length(" + string + ")-2),length(substr(substr(" + string + ",2,length(" + string + ")-2),1,instr(translate(substr(" + string + ",2,length(" + string + ")-2),'/#','::'),':',-1)))+1) ELSE NULL END)";
    }

    private static String ltype(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '\"%\"^^<%>') THEN substr(" + string + ",instr(" + string + ",'\"^^<',-1)+4,length(" + string + ")-instr(" + string + ",'\"^^<',-1)-4) ELSE NULL END)";
    }

    private static String latag(String string) {
        return "(CASE WHEN " + string + " is NULL THEN NULL WHEN (" + string + " LIKE '\"%\"@%' AND " + string + " NOT LIKE '\"%\"' AND " + string + " NOT LIKE '\"%>') THEN substr(" + string + ",instr(" + string + ",'\"@',-1)+2) ELSE NULL END)";
    }

    public RelationalBGP(int n, SQLGenContext sQLGenContext) {
        this.id = n;
        this.ctx = sQLGenContext;
        this.bgp = new BasicGraphPattern();
        this.varset = new HashMap<String, String>();
        this.myTrips = new ArrayList<SPARQLTriplesBlock>();
        this.rdfTermSet = new HashMap<String, String>();
        this.filters = new ArrayList<Filter>();
        this.filterSet_for_BGP = new HashSet();
        this.hint0leadPosMap = new HashMap<String, Integer>();
        this.projectVars = new HashSet<String>();
        this.leftJoinVars = new HashSet<String>();
        this.varAliases = new HashMap<String, String>();
        this.withMap = new HashMap<String, String>();
        this.relPredSet = new HashMap();
        this.predMapSet = new HashMap();
        this.LtcRowInfo_for_Tmap_plus_Col = null;
        this.TFTglobalList = new ArrayList();
        this.noTFTglobalList = new ArrayList();
        this.TFTinfoGlobalList = new ArrayList();
        this.null_TFTidx = -1;
        this.RRrowInfo_for_MatchingRow = new HashMap();
        this.VarSet_for_BGP = null;
        this.DatatypeFam_for_var = new HashMap<String, String>();
        this.Geometry_VarSRID = new HashMap<String, Set<Long>>();
        this.Geometry_VarDimension = new HashMap<String, String>();
        this.RRrowSet_for_BGPconst = new HashMap();
        this.RRrowSet_for_BGPvar = new HashMap();
        this.RRrowSet_for_TriplePattern = new HashMap();
        this.OccPosList_for_Var = new HashMap();
        this.FilterList_for_Var = new HashMap();
        this.SimpleConstraintList_for_Var = new HashMap();
        this.RelExprFilterList_for_BGP = new HashSet();
        this.TwoVarRelExprFilterList_for_BGP = new HashSet();
        this.VarSet_filter2vCond_outer = new HashSet();
        this.TmapSet_for_svar = new HashMap();
        this.Tmaps_with_nonUnique_Smaps = new HashSet();
        this.PredConstSet_for_pvar = new HashMap();
        this.Subj_for_TpatCSRGroup = new HashMap();
        this.TmapSet_for_TpatCSRGroup = new HashMap();
        this.TpatSet_for_TpatCSRGroup = new HashMap();
        this.CSRAlias_for_TpatCSRGroup = new HashMap();
        this.CSRAliasSet_for_tuple = new HashMap();
        this.predList_for_CSRAlias = new HashMap();
        this.objeList_for_CSRAlias = new HashMap();
        this.varsList_for_CSRAlias = new HashMap();
        this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap = new HashMap();
        this.RRrowList_All = new ArrayList();
        this.FullOccInfo_for_VarPlusCSRAlias = new HashMap();
        this.TypeInfoSet_for_VarPlusCSRAlias = new HashMap();
        this.NativeVarList_for_CSRAlias = new HashMap();
        this.CLOBVarPlusCSRAliasSet_for_BGP = new HashSet();
        this.TpatInfo_for_TpatKey = new HashMap();
        this.LtabExpr_for_Tmap = new HashMap();
        this.SubjExpr_for_Tmap = new HashMap();
        this.sTFT_idx_for_Tmap = new HashMap();
        this.SubjRRrowid_for_Tmap = new HashMap();
        this.RRrowFlags_for_Tmap = new HashMap();
        this.dummyTBList = new ArrayList<TriplesBlock>();
        this.condForNullSkipping = new ArrayList();
        this.graph_use_mode = 0;
        this.graphMatchUnnamed = false;
        this.bgp_graph = null;
        this.is_bgp_graph_const = false;
        this.is_bgp_graph_a_var = false;
        this.queryOptions = 0;
        this.model_id = 0;
        this.rr_tab_qname = "";
        this.Ltc_tab_qname = "";
        this.rr_tab_dummy_query = "";
        this.alias = 0;
        this.defaultOwner = null;
        this.userHint = null;
        this.hintG = new HintZeroHintGenerator(sQLGenContext, false);
        this.sqlHint = "";
        this.rtyp_pred_only = false;
        this.graphQuery = false;
        this.activeGraph = null;
        spcl_chars = new HashSet<String>(Arrays.asList("t", "r", "n"));
    }

    @Override
    public SPARQLBGP shallowClone() {
        RelationalBGP relationalBGP = new RelationalBGP(this.id, this.ctx);
        for (SPARQLTriplesBlock sPARQLTriplesBlock : this.myTrips) {
            relationalBGP.addTriplesBlock(sPARQLTriplesBlock);
        }
        return relationalBGP;
    }

    @Override
    public void setIsGraphQuery(boolean bl) {
        this.graphQuery = bl;
    }

    @Override
    public boolean isGraphQuery() {
        return this.graphQuery;
    }

    @Override
    public void setActiveGraph(ASTTripleAtom aSTTripleAtom) {
        this.activeGraph = aSTTripleAtom;
        if (this.activeGraph.type == 0) {
            this.graphVar = this.activeGraph.name.toUpperCase();
        }
        this.log("setting: activeGraph=" + this.activeGraph + " graphVar=" + this.graphVar);
    }

    @Override
    public void addUserHint(String string) {
        this.userHint = string;
        this.hintG.setUserHint(string);
    }

    @Override
    public String getJoinHint(String string, String string2) {
        return "";
    }

    @Override
    public String getAntiJoinHint() {
        return "";
    }

    @Override
    public String getValueJoinHint(Collection<String> collection, String string) {
        String string2 = BASE_PREFIX_COLNAME_SEP;
        if ((this.ctx.R2RFlags & 0x2000L) == 0L) {
            string2 = " /*+ NO_MERGE(" + string + ") */ ";
        }
        return string2;
    }

    @Override
    public void addTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) {
        this.myTrips.add(sPARQLTriplesBlock);
        this.bgp.addTriplesBlock(sPARQLTriplesBlock, this.ctx);
        this.populateFromTBs();
    }

    @Override
    public List<SPARQLTriplesBlock> getTriplesBlocks() {
        return this.myTrips;
    }

    @Override
    public int getNumTriples() {
        return this.bgp.numTriples();
    }

    @Override
    public boolean addFilter(Filter filter) {
        SimpleNode simpleNode;
        this.log("addFilter => " + filter.toString(BASE_PREFIX_COLNAME_SEP));
        this.filterSet_for_BGP.add(filter);
        if ((this.ctx.R2RFlags & 0x1000L) > 0L) {
            return false;
        }
        this.log("entered addFilter() RelExpr at start: " + this.RelExprFilterList_for_BGP.toString());
        this.log("entered addFilter() TwoVarRelExpr at start: " + this.TwoVarRelExprFilterList_for_BGP.toString());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(88);
        arrayList.add(80);
        arrayList.add(90);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("ISURI");
        arrayList2.add("ISIRI");
        arrayList2.add("ISLITERAL");
        arrayList2.add("ISBLANK");
        arrayList2.add("SAMETERM");
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("http://xmlns.oracle.com/rdf/textContains");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfEquals");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfContains");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfDisjoint");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfCrosses");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfIntersects");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfOverlaps");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfTouches");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/sfWithin");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/buffer");
        arrayList3.add("http://xmlns.oracle.com/rdf/geo/buffer");
        arrayList3.add("http://www.opengis.net/def/function/geosparql/relate");
        arrayList3.add("http://xmlns.oracle.com/rdf/geo/relate");
        arrayList3.add("http://xmlns.oracle.com/rdf/geo/withinDistance");
        boolean bl = false;
        SimpleNode simpleNode2 = filter.getFilterTree();
        int n = simpleNode2.jjtGetNumChildren();
        int n2 = simpleNode2.id;
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        boolean bl3 = false;
        String string3 = "";
        this.log("+++++ current nodeType=" + n2 + " numChildren=" + n);
        if (n == 0) {
            return bl;
        }
        this.log("[" + simpleNode2.children.length + "]" + simpleNode2.dumpToStr("==>"));
        boolean bl4 = false;
        int n3 = 0;
        while (n2 == 86 && simpleNode2.jjtGetNumChildren() == 2) {
            SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(0);
            if (!((ASTUnaryOperator)simpleNode3).name.equals("!")) continue;
            simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(1);
            n2 = simpleNode2.id;
            n = simpleNode2.jjtGetNumChildren();
            bl4 = !bl4;
            ++n3;
            this.log("+++++ new: current nodeType=" + n2 + " numChildren=" + n);
            if (n <= 0) continue;
            this.log("new: [" + simpleNode2.children.length + "]" + simpleNode2.dumpToStr("==>"));
        }
        if (bl4) {
            this.log("negation is ON");
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                simpleNode = (SimpleNode)simpleNode2.jjtGetChild(i);
                this.log("childFilterNode " + i + ": nodeType=" + simpleNode.id + " numChildren=" + simpleNode.jjtGetNumChildren());
            }
        }
        if (arrayList.contains(n2)) {
            if (n2 == 88) {
                string = ((ASTBuiltInCall)simpleNode2).name;
                this.log("funcName=" + string);
                if (arrayList2.contains(string)) {
                    if (n == 1) {
                        SimpleNode simpleNode4 = (SimpleNode)simpleNode2.jjtGetChild(0);
                        int n4 = simpleNode4.id;
                        this.log("childFilterNode: nodeType=" + n4 + " numChildren=" + simpleNode4.jjtGetNumChildren());
                        if (n4 == 73) {
                            int n5 = ((ASTTripleAtom)simpleNode4).type;
                            String string4 = ((ASTTripleAtom)simpleNode4).name;
                            if (n5 == 0) {
                                this.log("Native filter handling possible: " + string4);
                                String string5 = string4;
                                String string6 = "";
                                ArrayList<String> arrayList4 = this.SimpleConstraintList_for_Var.get(string5);
                                if (arrayList4 == null) {
                                    arrayList4 = new ArrayList();
                                    this.SimpleConstraintList_for_Var.put(string5, arrayList4);
                                }
                                if (bl4) {
                                    string6 = "!";
                                }
                                this.log("adding SimpleConstraint for var=" + string5 + " : " + string6 + string);
                                arrayList4.add(string6 + string);
                                ArrayList<Filter> arrayList5 = this.FilterList_for_Var.get(string5);
                                if (arrayList5 == null) {
                                    arrayList5 = new ArrayList();
                                    this.FilterList_for_Var.put(string5, arrayList5);
                                }
                                this.log("adding Filter for var=" + string5 + " : " + string6 + simpleNode2.dumpToStr("--->"));
                                arrayList5.add(filter);
                                bl = true;
                            }
                        }
                    } else if (n == 2 && string.equals("SAMETERM")) {
                        this.log("got sameTerm()");
                        SimpleNode simpleNode5 = (SimpleNode)simpleNode2.jjtGetChild(0);
                        simpleNode = (SimpleNode)simpleNode2.jjtGetChild(1);
                        int n6 = simpleNode5.id;
                        int n7 = simpleNode.id;
                        if (n6 == 73 && n7 == 73) {
                            ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode5;
                            String string7 = string;
                            if (bl4) {
                                this.log("orig compOper was: " + string7);
                                string7 = "DIFFTERM";
                                this.log("NEGATED compOper is: " + string7);
                            }
                            ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)simpleNode;
                            if (aSTTripleAtom.type != 0 || aSTTripleAtom2.type != 0) {
                                RelExpr relExpr = new RelExpr(aSTTripleAtom, string7, aSTTripleAtom2, filter, 0L);
                                if (aSTTripleAtom2.type == 0) {
                                    relExpr.InvertRelExpr();
                                }
                                this.RelExprFilterList_for_BGP.add(relExpr);
                                bl = true;
                            } else {
                                this.log("addFilter: recording: sameTerm(<var>,<var>) -- NOT NATIVELY IMPLEMENTED YET");
                                RelExpr relExpr = new RelExpr(aSTTripleAtom, string7, aSTTripleAtom2, filter, 0L);
                                this.TwoVarRelExprFilterList_for_BGP.add(relExpr);
                            }
                        }
                    }
                }
            } else if (n2 == 80 && n == 3) {
                this.log("got RelationalExpression");
                SimpleNode simpleNode6 = (SimpleNode)simpleNode2.jjtGetChild(0);
                simpleNode = (SimpleNode)simpleNode2.jjtGetChild(1);
                SimpleNode simpleNode7 = (SimpleNode)simpleNode2.jjtGetChild(2);
                int n8 = simpleNode6.id;
                int n9 = simpleNode.id;
                int n10 = simpleNode7.id;
                this.log("L_childFilterNodeType: " + n8);
                this.log("M_childFilterNodeType: " + n9);
                this.log("R_childFilterNodeType: " + n10);
                if (n9 == 81) {
                    ASTComparisonOperator aSTComparisonOperator = (ASTComparisonOperator)simpleNode;
                    String string8 = aSTComparisonOperator.name;
                    this.log("[RE] ASTComparisonOperator: " + string8);
                    List<String> list = Arrays.asList("=", "!=", ">", "<", ">=", "<=");
                    List<String> list2 = Arrays.asList("!=", "=", "<=", ">=", "<", ">");
                    int n11 = list.indexOf(string8);
                    if (n11 == -1) {
                        this.log("[RE] no native handling of orig compOper: " + string8);
                        bl = false;
                    } else {
                        if (bl4) {
                            this.log("orig compOper was: " + string8);
                            string8 = list2.get(n11);
                            this.log("NEGATED compOper is: " + string8);
                        }
                        if (n8 == 73 && n10 == 73) {
                            this.log("[RE] JJTTRIPLEATOM  JJTCOMPARISONOPERATOR JJTTRIPLEATOM ");
                            ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode6;
                            ASTTripleAtom aSTTripleAtom3 = (ASTTripleAtom)simpleNode7;
                            this.log("[RE] " + aSTTripleAtom.name + BASE_PREFIX_COLNAME_SEP + aSTComparisonOperator.name + BASE_PREFIX_COLNAME_SEP + aSTTripleAtom3.name);
                            if (aSTTripleAtom.type != 0 || aSTTripleAtom3.type != 0) {
                                RelExpr relExpr = new RelExpr(aSTTripleAtom, string8, aSTTripleAtom3, filter, 0L);
                                if (aSTTripleAtom3.type == 0) {
                                    relExpr.InvertRelExpr();
                                }
                                this.RelExprFilterList_for_BGP.add(relExpr);
                                this.log("added relExpr=" + relExpr);
                                this.log(this.RelExprFilterList_for_BGP.toString());
                                bl = true;
                            } else {
                                this.log("addFilter: recording: <var> " + string8 + " <var> NOT NATIVELY IMPLEMENTED YET");
                                RelExpr relExpr = new RelExpr(aSTTripleAtom, string8, aSTTripleAtom3, filter, 0L);
                                this.TwoVarRelExprFilterList_for_BGP.add(relExpr);
                                this.log("added to TwoVarRelExprFilterList_for_BGP: relExpr=" + relExpr);
                                this.log(this.TwoVarRelExprFilterList_for_BGP.toString());
                                if ((this.ctx.R2RFlags & 0x8000L) > 0L) {
                                    this.log("addFilter: recording: <var> " + string8 + " <var> NOT NATIVELY IMPLEMENTED YET ... TRYING OUT b/c of RDB2RDF_SKIP_SPARQL_2V_FILTER=T flag");
                                    bl = true;
                                }
                            }
                        } else if (n8 == 90 && n10 == 73 || n8 == 73 && n10 == 90) {
                            SimpleNode simpleNode8 = null;
                            SimpleNode simpleNode9 = null;
                            Object var31_76 = null;
                            this.log("[RE] Instantiation of relational expression atoms: L_atom and R_atom:");
                            if (simpleNode6 instanceof ASTIRIrefOrFunction) {
                                this.log("[RE] JJTIRIREFORFUNCTION  JJTCOMPARISONOPERATOR JJTTRIPLEATOM ");
                                simpleNode8 = (ASTIRIrefOrFunction)simpleNode6;
                                simpleNode9 = (ASTTripleAtom)simpleNode7;
                            } else {
                                this.log("[RE] JJTTRIPLEATOM JJTCOMPARISONOPERATOR JJTIRIREFORFUNCTION ");
                                simpleNode8 = (ASTTripleAtom)simpleNode6;
                                simpleNode9 = (ASTIRIrefOrFunction)simpleNode7;
                            }
                            try {
                                this.log("[RE] " + simpleNode8.printSPARQLText());
                                this.log("[RE] " + aSTComparisonOperator.printSPARQLText());
                                this.log("[RE] " + simpleNode9.printSPARQLText());
                            }
                            catch (ParseException parseException) {
                                this.log(parseException.toString());
                            }
                            bl = false;
                            this.log("[RE] For the moment we are not handling natively regular expressions that involve JJTIRIREFORFUNCTION ");
                        } else {
                            this.log("[RE] unknown combination of operands/operand");
                        }
                    }
                } else {
                    this.log("[RE] unknown operand: " + simpleNode.toString());
                }
            } else if (n2 == 90 && n == 3) {
                this.log("got IRIrefOrFunction with numChildren=" + n);
                SimpleNode simpleNode10 = (SimpleNode)simpleNode2.jjtGetChild(0);
                simpleNode = (SimpleNode)simpleNode2.jjtGetChild(1);
                SimpleNode simpleNode11 = (SimpleNode)simpleNode2.jjtGetChild(2);
                int n12 = simpleNode10.id;
                int n13 = simpleNode.id;
                int n14 = simpleNode11.id;
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode10;
                this.log("[ML] L_atom.name: " + aSTTripleAtom.name);
                if (arrayList3.contains(aSTTripleAtom.name) && !aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/textContains") || n12 == 73 && n13 == 73 && n14 == 73) {
                    if (aSTTripleAtom.type == 1 && arrayList3.contains(aSTTripleAtom.name)) {
                        this.log("We will try processing this filter condition");
                        if (aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/textContains")) {
                            this.log("start processing filter: " + aSTTripleAtom.name);
                            ASTTripleAtom aSTTripleAtom4 = (ASTTripleAtom)simpleNode;
                            ASTTripleAtom aSTTripleAtom5 = (ASTTripleAtom)simpleNode11;
                            if (aSTTripleAtom4.type == 0 && aSTTripleAtom5.type == 3) {
                                String string9 = "LIKE";
                                if (bl4) {
                                    string9 = "NOT LIKE";
                                }
                                this.log("start processing filter as: " + aSTTripleAtom4.name + BASE_PREFIX_COLNAME_SEP + string9 + BASE_PREFIX_COLNAME_SEP + aSTTripleAtom5.name);
                                RelExpr relExpr = new RelExpr(aSTTripleAtom4, string9, aSTTripleAtom5, filter, 0L);
                                this.RelExprFilterList_for_BGP.add(relExpr);
                                relExpr.setNotNegatedFilterLevel(n3);
                                this.log("added relExpr=" + relExpr);
                                this.log(this.RelExprFilterList_for_BGP.toString());
                                bl = true;
                            } else {
                                this.log("cannot process: LIKE filter args types are diff than expected: " + aSTTripleAtom4.type + COND_CONNECTOR + aSTTripleAtom5.type);
                            }
                        } else if (arrayList3.contains(aSTTripleAtom.name)) {
                            this.log("start processing OGCF filter: " + aSTTripleAtom.name);
                            String string10 = aSTTripleAtom.name;
                            this.log("start processing OGCF filter M_atomName: " + string10);
                            RelExpr relExpr = new RelExpr(null, string10, null, filter, 2L);
                            this.RelExprFilterList_for_BGP.add(relExpr);
                            relExpr.setNotNegatedFilterLevel(n3);
                            bl = true;
                            this.log("added relExpr=" + relExpr);
                            this.log(this.RelExprFilterList_for_BGP.toString());
                        } else {
                            this.log("cannot process: IRIrefOrFunction=" + aSTTripleAtom.name);
                        }
                    } else {
                        this.log("cannot process: IRIrefOrFunction " + aSTTripleAtom.name + " NOT in the list " + arrayList3);
                    }
                } else {
                    this.log("cannot process: IRIrefOrFunction: childFilterNodeTypes are diff than expected: " + n12 + BASE_PREFIX_COLNAME_SEP + n13 + BASE_PREFIX_COLNAME_SEP + n14);
                }
            } else if (n2 == 90 && n >= 4) {
                this.log("got IRIrefOrFunction with numChildren=" + n);
                SimpleNode simpleNode12 = (SimpleNode)simpleNode2.jjtGetChild(0);
                simpleNode = (SimpleNode)simpleNode2.jjtGetChild(1);
                SimpleNode simpleNode13 = (SimpleNode)simpleNode2.jjtGetChild(2);
                SimpleNode simpleNode14 = (SimpleNode)simpleNode2.jjtGetChild(3);
                int n15 = simpleNode12.id;
                int n16 = simpleNode.id;
                int n17 = simpleNode13.id;
                int n18 = simpleNode14.id;
                if (n15 == 73) {
                    ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode12;
                    if (aSTTripleAtom.name.equals("http://www.opengis.net/def/function/geosparql/relate") && n18 != 73) {
                        this.log("Unsupported function: http://www.opengis.net/def/function/geosparql/relate -- expecting plain or xsd:string literal at position 3");
                        return bl;
                    }
                    ASTTripleAtom aSTTripleAtom6 = (ASTTripleAtom)simpleNode14;
                    if (aSTTripleAtom.type == 1 && arrayList3.contains(aSTTripleAtom.name)) {
                        this.log("We will try processing this filter condition: " + aSTTripleAtom.name);
                        if (aSTTripleAtom.name.equals("http://www.opengis.net/def/function/geosparql/relate") || aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/geo/relate") || aSTTripleAtom.name.equals("http://xmlns.oracle.com/rdf/geo/withinDistance")) {
                            this.log("start processing OGCF filter: " + aSTTripleAtom.name);
                            String string11 = aSTTripleAtom.name;
                            this.log("FNAM_atomName : " + string11);
                            RelExpr relExpr = new RelExpr(null, string11, null, filter, 2L, aSTTripleAtom6);
                            relExpr.setNotNegatedFilterLevel(n3);
                            this.RelExprFilterList_for_BGP.add(relExpr);
                            this.log(relExpr.toString());
                            bl = true;
                        } else {
                            this.log("cannot process: IRIrefOrFunction=" + aSTTripleAtom.name + " mask=" + aSTTripleAtom6.name);
                        }
                    } else {
                        this.log("cannot process: IRIrefOrFunction " + aSTTripleAtom.name + " NOT in the list " + arrayList3);
                    }
                } else {
                    this.log("cannot process: IRIrefOrFunction: childFilterNodeTypes are diff than expected: " + n15 + BASE_PREFIX_COLNAME_SEP + n16 + BASE_PREFIX_COLNAME_SEP + n17 + BASE_PREFIX_COLNAME_SEP + simpleNode14);
                }
            }
            this.log("****");
            Set<String> set = filter.getVars();
            Set<String> set2 = this.getDefiniteBoundVars();
            if (!this.getDefiniteBoundVars().containsAll(set)) {
                bl = false;
                this.log("addFilter: no native handling involving potentially unbound variables");
                this.RelExprFilterList_for_BGP.remove(this.RelExprFilterList_for_BGP.size() - 1);
            } else if (bl) {
                this.log("addFilter: adding filter to list: " + filter.toString());
                this.filters.add(filter);
            }
        } else {
            this.log("nodeType=" + n2 + " not in the list: " + arrayList.toString());
        }
        this.log("addFilter: returning: " + bl);
        return bl;
    }

    @Override
    public Set<String> addProjectVars(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        Set<String> set2 = this.getDefiniteBoundVars();
        return hashSet;
    }

    @Override
    public boolean addProjectVar(String string) {
        boolean bl = true;
        return bl;
    }

    @Override
    public Set<String> getAllLexVars() {
        Set<String> set = this.getBGPVars();
        this.log("getAllLexVars: returning vSet=" + set);
        return set;
    }

    @Override
    public Set<String> getRequiredLexVars() {
        Set<String> set = this.getBGPVars();
        this.log("getRequiredLexVars: returning vSet=" + set);
        return set;
    }

    @Override
    public boolean addLexVar(String string) {
        return true;
    }

    @Override
    public Set<String> addLexVars(Set<String> set) {
        return new HashSet<String>();
    }

    @Override
    public void pushBGP(SPARQLBGP sPARQLBGP, String string) {
    }

    @Override
    public boolean needsParentBGPPushDown() {
        return false;
    }

    @Override
    public void verifyPushedBGP() {
    }

    @Override
    public void addJoinVarsForHint(Set<String> set) {
    }

    @Override
    public Set<String> getJoinVarsForHint() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getBindVars() {
        return new HashSet<String>();
    }

    @Override
    public void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2) {
        QueryUtils.genOuterSelectComponents(set, set2, map, stringArray, stringArray2, map2, "MDSYS.RDF_VALUE$");
    }

    @Override
    public String buildSubQForCLOB(String string, String string2, String string3) {
        return QueryUtils.buildSubQForCLOB(string, string2, string3, "MDSYS.RDF_VALUE$");
    }

    @Override
    public String distinctGraphsQuery(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return null;
        }
        this.log("distinctGraphsQuery: gVar=" + string + " isProjected=" + bl);
        this.log("RRrowSet_for_TriplePattern is : \n");
        RelationalBGP.printMapSet(this.RRrowSet_for_TriplePattern, this.ctx);
        return null;
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public Set<String> getBGPVars() {
        Set<String> set = this.getTriplePatternVars();
        if (this.graphQuery && this.activeGraph != null && (this.activeGraph.type == 0 || this.activeGraph.type == 9)) {
            set.add(this.activeGraph.name.toUpperCase());
        }
        this.log("getBGPVars: returning vSet: " + set);
        return set;
    }

    @Override
    public Set<String> getBGPAndPushedVars() {
        Set<String> set = this.getBGPVars();
        return set;
    }

    @Override
    public Set<String> getDefiniteBoundVars() {
        Set<String> set = this.getTriplePatternVars();
        if (this.graphVar != null && (this.ctx.contextFlags & 4) == 0) {
            set.add(this.graphVar);
        }
        this.log("getDefiniteBoundVars: returning vSet: " + set);
        return set;
    }

    @Override
    public Set<String> getDefiniteBoundAndPushedVars() {
        Set<String> set = this.getDefiniteBoundVars();
        return set;
    }

    @Override
    public Set<String> getProjectVars() {
        return this.getAllLexVars();
    }

    @Override
    public Set<String> getHintVars() {
        return new HashSet<String>();
    }

    @Override
    public boolean refsNonExistingTerm() {
        return false;
    }

    @Override
    public String toSQL() throws RDFException {
        long l = System.currentTimeMillis();
        this.ctx.R2RFlags |= 8L;
        String string = new String();
        this.log("toSQL(): entered RDB2RDF java translation code");
        if (this.filters.size() > 0) {
            this.log("filters [" + this.filters.size() + "]: " + this.filters.toString());
            this.log(this.FilterList_for_Var.toString());
        }
        this.log("toSQL: RelExprFilterList_for_BGP=> " + this.RelExprFilterList_for_BGP.toString());
        this.log("toSQL(): activeGraph=" + this.activeGraph + " graphVar=" + this.graphVar);
        if (this.ctx.defaultGraphList != null && this.ctx.defaultGraphList.size() > 0) {
            ++this.graph_use_mode;
            this.log("defaultGraphList: " + this.ctx.defaultGraphList);
        }
        if (this.ctx.namedGraphsList != null && this.ctx.namedGraphsList.size() > 0) {
            this.graph_use_mode += 2;
            this.log("namedGraphsList: " + this.ctx.namedGraphsList);
        }
        if (this.activeGraph != null) {
            this.graph_use_mode += 4;
            if (this.graphVar == null) {
                this.is_bgp_graph_const = true;
                this.bgp_graph = "<" + this.activeGraph.name + ">";
            } else {
                this.is_bgp_graph_a_var = true;
                this.bgp_graph = this.graphVar;
            }
            this.log("------------- bgp_graph=" + this.bgp_graph);
        }
        if ((this.ctx.contextFlags & 4) > 0) {
            this.graphMatchUnnamed = true;
        }
        if (this.bgp.TBList.size() == 0 && this.activeGraph != null) {
            if (this.dummyTBList.size() == 0) {
                this.dummyTBList.add(this.composeTripleBlock("dummyS", "dummyP", "dummyO"));
                this.log("dummyTBList populated: " + this.dummyTBList);
            } else {
                this.log("dummyTBList ALREADY populated: " + this.dummyTBList);
            }
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        try {
            this.findModelId_for_RDFView();
            this.rr_tab_qname = "MDSYS.RDF_RR$TAB" + Integer.toHexString(this.model_id);
            this.Ltc_tab_qname = "MDSYS.RDF_RR$LTC" + Integer.toHexString(this.model_id);
            this.rr_tab_dummy_query = "select null from " + this.rr_tab_qname;
            this.log("toSQL(): name of rr_tab : " + this.rr_tab_qname);
            boolean bl = true;
            if (this.graph_use_mode == 2) {
                this.log("NoRows case: 010: / - / FROM NAMED / - / : default graph is EMPTY");
            } else if (this.graph_use_mode == 5) {
                this.log("NoRows case: 101: / GRAPH / - / FROM / : list of named graphs is EMPTY");
            } else if ((this.graph_use_mode & 6) == 6 && this.graphVar == null && !RelationalBGP.matchableSqlTemplate_in_list("<" + this.activeGraph.name + ">", this.ctx.namedGraphsList, this.ctx)) {
                this.log("NoRows case: GRAPH constant [<" + this.activeGraph.name + ">" + "] NOT IN named graphs list: " + this.ctx.namedGraphsList);
            } else {
                bl = false;
            }
            if (!bl) {
                this.log("toSQL(): invoking routines to find matching RRrowSets");
                l2 = System.currentTimeMillis();
                this.importLtcTabRowInfo();
                l3 = System.currentTimeMillis();
                this.log("time_delta time_aft_importLtcTabRowInfo: " + (l3 - l2));
                l4 = System.currentTimeMillis();
                this.findMatchingRRrowSets_for_BGPconstants();
                this.log("RRrowSet_for_BGPconst: " + this.RRrowSet_for_BGPconst);
                l5 = System.currentTimeMillis();
                this.log("time_delta time_aft_BGPconstants: " + (l5 - l4));
                this.log("==>RRROWSET_FOR_BGPCONST=" + this.RRrowSet_for_BGPconst.toString());
                this.findMatchingRRrowSets_for_TriplePatterns(1);
                l6 = System.currentTimeMillis();
                this.log("time_delta time_aft_TriplePatterns: " + (l6 - l5));
                this.log("toSQL(): DONE invoking routines to find matching RRrowSets");
            }
            this.log("\n \n");
            this.log("RRrowSet_for_TriplePattern is : \n");
            RelationalBGP.printMapSet(this.RRrowSet_for_TriplePattern, this.ctx);
            this.log("\n\n");
            this.log("RRrowInfo_for_MatchingRows is :\n");
            for (String string2 : this.RRrowSet_for_TriplePattern.keySet()) {
                this.log(" \n \n RRTabRowInfo defined for Triple Pattern " + string2 + "\n");
                Set<String> set = this.RRrowSet_for_TriplePattern.get(string2);
                for (String string3 : set) {
                    this.log("\n rowid info for rowid " + string3 + " :\n " + this.RRrowInfo_for_MatchingRow.get(string3));
                }
                this.log("\n");
            }
            long l7 = System.currentTimeMillis();
            this.prepareForBuildSQL();
            long l8 = System.currentTimeMillis();
            this.log("time_delta time_aft_prepare: " + (l8 - l7));
            this.log("==>LTABEXPR_FOR_TMAP=" + this.LtabExpr_for_Tmap);
            this.log("==>SUBJEXPR_FOR_TMAP=" + this.SubjExpr_for_Tmap);
            this.log("==>STFT_IDX_FOR_TMAP=" + this.sTFT_idx_for_Tmap);
            this.log("==>SUBJRRROWID_FOR_TMAP=" + this.SubjRRrowid_for_Tmap);
            this.log("==>TMAPSET_FOR_TPATCSRGROUP=" + this.TmapSet_for_TpatCSRGroup);
            this.log("==>TPATSET_FOR_TPATCSRGROUP=" + this.TpatSet_for_TpatCSRGroup);
            this.log("==>SUBJ_FOR_TPATCSRGROUP=" + this.Subj_for_TpatCSRGroup);
            this.buildSQLNew();
            long l9 = System.currentTimeMillis();
            this.log("time_delta time_aft_analyze: " + (l9 - l8));
            this.log("==>CSRALIAS_FOR_TPATCSRGROUP=" + this.CSRAlias_for_TpatCSRGroup);
            this.log("==>PREDLIST_FOR_CSRALIAS=" + this.predList_for_CSRAlias);
            this.log("==>OBJELIST_FOR_CSRALIAS=" + this.objeList_for_CSRAlias);
            this.log("==>TYPEINFOSET_FOR_VARPLUSCSRALIAS=" + this.TypeInfoSet_for_VarPlusCSRAlias);
            this.log("==>CSRALIASSET_FOR_TUPLE=" + this.CSRAliasSet_for_tuple);
            this.log("==>TRUEMATCHINGRRROWLISTLIST_FOR_CSRALIASPLUSTMAP=" + this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap);
            this.log("final TFTglobalList: " + this.TFTglobalList);
            this.log("final noTFTglobalList: " + this.noTFTglobalList);
            this.log("final TFTinfoGlobalList: " + this.TFTinfoGlobalList.toString());
            string = this.generateSQL();
            long l10 = System.currentTimeMillis();
            this.log("time_delta time_aft_generate: " + (l10 - l9));
            this.log("\n NEW Generated relational sql in bgpToSQLAgainstRelationa : " + string + " \n");
            long l11 = System.currentTimeMillis();
            this.log("time_delta time_aft_importLtcTabRowInfo: " + (l3 - l2));
            this.log("time_delta time_aft_BGPconstants:   " + (l5 - l4));
            this.log("time_delta time_aft_TriplePatterns: " + (l6 - l5));
            this.log("time_delta time_aft_prepare:        " + (l8 - l7));
            this.log("time_delta time_aft_build:          " + (l9 - l8));
            this.log("time_delta time_aft_generate:       " + (l10 - l9));
            this.log("time_delta Total time taken for translation: " + (l11 - l));
        }
        catch (RDFException rDFException) {
            throw rDFException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RDFException("toSQL(): Error processing RDB2RDF query. See trace file for details.");
        }
        finally {
            this.ctx.R2RFlags &= 0xFFFFFFFFFFFFFFF7L;
        }
        return string;
    }

    private Set<String> getTriplePatternVars() {
        return new HashSet<String>(this.varset.keySet());
    }

    public String buildWithClause() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.withMap != null && !this.withMap.isEmpty()) {
            stringBuffer.append("WITH ");
            boolean bl = false;
            for (Map.Entry<String, String> entry : this.withMap.entrySet()) {
                if (bl) {
                    stringBuffer.append(",\n");
                }
                bl = true;
                stringBuffer.append(entry.getKey()).append(" AS (").append(entry.getValue()).append(")");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int getId() {
        return this.id;
    }

    private void populateFromTBs() {
        this.varset = new HashMap<String, String>();
        this.rdfTermSet = new HashMap<String, String>();
        this.extractVariables();
        this.extractRDFTerms();
    }

    private void extractVariables() {
        boolean bl = false;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            int n = 0;
            for (TriplesBlock.Element element : new TriplesBlock.Element[]{triplesBlock.getSubject(), triplesBlock.getPredicate(), triplesBlock.getObject()}) {
                String string = element.getName();
                if (element.isVariable()) {
                    if (!this.varset.containsKey(string)) {
                        this.varset.put(string, this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string).append((String)",").append((int)n).toString()).position);
                    }
                } else if (n != 1) {
                    if (element.getType() == 1) {
                        string = "<" + string + ">";
                    }
                    if (!this.rdfTermSet.containsKey(string)) {
                        this.rdfTermSet.put(string, "object");
                    }
                }
                ++n;
            }
        }
    }

    private void extractRDFTerms() {
        for (String string : this.bgp.BGPelements.keySet()) {
            if (this.bgp.BGPelements.get((Object)string).type.equalsIgnoreCase("0") || this.bgp.BGPelements.get((Object)string).position.equalsIgnoreCase("object")) continue;
            String string2 = string.substring(0, string.lastIndexOf(44));
            this.rdfTermSet.put(string2, this.bgp.BGPelements.get((Object)string).position);
            this.log("extractRDFTerms: rdfTerm=" + string + " (used substr-till-last-comma) name=" + string2);
            this.log("extractRDFTerms: " + this.bgp.BGPelements.get(string).toString());
        }
    }

    private TriplesBlock composeTripleBlock(String string, String string2, String string3) {
        SimpleNode[] simpleNodeArray = new ASTTripleAtom[3];
        simpleNodeArray[0] = new ASTTripleAtom(73);
        simpleNodeArray[0].type = 0;
        simpleNodeArray[0].name = string;
        simpleNodeArray[1] = new ASTTripleAtom(73);
        simpleNodeArray[1].type = 0;
        simpleNodeArray[1].name = string2;
        simpleNodeArray[2] = new ASTTripleAtom(73);
        simpleNodeArray[2].type = 0;
        simpleNodeArray[2].name = string3;
        TriplesBlock triplesBlock = new TriplesBlock(simpleNodeArray, this.ctx);
        return triplesBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findModelId_for_RDFView() throws SQLException, RDFException {
        Connection connection = DriverManager.getConnection("jdbc:oracle:kprb:");
        Statement statement = null;
        ResultSet resultSet = null;
        String[] stringArray = this.ctx.models;
        String string = Util.qualifiedSQLName((Connection)connection, (String)("MDSYS.RDFM_" + stringArray[0].toUpperCase()));
        String string2 = "SELECT model_id MOD_ID FROM " + string + " WHERE rownum < 2";
        this.log("query_find_model_id: " + string2);
        String string3 = "";
        int n = 0;
        boolean bl = false;
        try {
            if (!string.startsWith("MDSYS.RDFM_")) {
                return;
            }
            string3 = string.substring(11);
            statement = connection.prepareStatement(string2);
            this.log("query_find_model_id: " + string2);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                bl = true;
                this.model_id = resultSet.getInt("MOD_ID");
                this.log("model_name (given): " + string3 + " found model_id=" + this.model_id);
            }
        }
        catch (SQLException sQLException) {
            n = sQLException.getErrorCode();
            this.log("ret_code=" + n);
            if (Math.abs(n) == 1403) {
                throw sQLException;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        if (!bl) {
            throw new RDFException("model is not associated with any relational data");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findTerm_for_Element(TriplesBlock.Element element, String string, boolean bl) throws RDFException {
        int n = element.getType();
        String string2 = element.getName();
        String string3 = null;
        String string4 = element.getLitType();
        String string5 = element.getLitLang();
        this.log("findTerm_for_Element: [name=" + string2 + " type=" + n + " litType=" + string4 + " id=" + element.getCanonicalID() + "] elem.toString(): " + element.toString());
        if (element.isVariable()) {
            return element.getName();
        }
        if (string.equalsIgnoreCase("subject") || string.equalsIgnoreCase("predicate") || string.equalsIgnoreCase("graph")) {
            string3 = "<" + element.getName() + ">";
        } else {
            if (!string.equalsIgnoreCase("object")) throw new RDFException("INTERNAL ERROR: findTerm_for_Element: position=" + string);
            if (n == 1) {
                string3 = "<" + string2 + ">";
            } else if (n == 3) {
                string3 = "\"" + string2 + "\"";
            } else if (n == 2) {
                string3 = "\"" + string2 + "\"^^<" + string4 + ">";
            } else if (n == 4) {
                string3 = "\"" + string2 + "\"" + "@" + string5;
            } else if (n == 5) {
                string3 = string4.equalsIgnoreCase(XSD_STRING_NO_ENCLOSING) ? "\"" + string2 + "\"" : "\"" + string2 + "\"" + "^^<" + string4 + ">";
            } else {
                if (n != 6) throw new RDFException("Feature not supported: non-URI and non-PlainLiteral: elemType=" + n + " name=" + string2);
                throw new RDFException("Feature not supported: Typed-Literal with Language-Tag: elemType=" + n + " name=" + string2 + " litType=" + string4 + " litLang=" + string5);
            }
        }
        this.log("returning elemTerm=" + string3);
        return string3;
    }

    private String findTerm_from_BGPNodeInfo(BGPNodeInfo bGPNodeInfo) throws SQLException, RDFException {
        Object object;
        Object object2;
        String string;
        String string2 = "";
        String string3 = bGPNodeInfo.name.substring(0, bGPNodeInfo.name.lastIndexOf(44));
        this.log("name=" + string3);
        if (string3.charAt(0) != '>' && string3.charAt(0) != '\"') {
            string = "SELECT /*+ index(v,C_PK_VID) */ sem_apis.compose_rdf_term(value_name,value_type,literal_type,language_type) rdfterm   FROM mdsys.rdf_value$ v  WHERE v.value_id=:1";
            object2 = null;
            object = null;
            int n = 0;
            String string4 = "";
            try {
                Connection connection = DriverManager.getConnection("jdbc:oracle:kprb:");
                object2 = connection.prepareStatement(string);
                object2.setString(1, string3);
                object = object2.executeQuery();
                while (object.next()) {
                    string2 = object.getString("RDFTERM");
                    string4 = string4 + " [" + ++n + "]: " + string2;
                }
            }
            catch (Exception exception) {
                if (object != null) {
                    object.close();
                }
                if (object2 != null) {
                    object2.close();
                }
                exception.printStackTrace();
                throw new RDFException("[see trace file for more details] Failed while trying to retrieve RDFTERM for value_id=" + string3);
            }
            finally {
                if (object != null) {
                    object.close();
                }
                if (object2 != null) {
                    object2.close();
                }
            }
            if (n == 1) {
                return string2;
            }
            if (n == 0) {
                throw new RDFException("No RDFTERM found for value_id=" + string3);
            }
            if (n > 1) {
                throw new RDFException("Multiple RDFTERMs found for value_id=" + string3 + string4);
            }
        }
        string = string3.substring(1, string3.length() - 1);
        int n = Integer.parseInt(bGPNodeInfo.type);
        this.log("type=" + n);
        object2 = bGPNodeInfo.litType;
        object = bGPNodeInfo.litLang;
        if (n == 1) {
            string2 = "<" + string + ">";
        } else if (n == 3) {
            string2 = "\"" + string + "\"";
        } else if (n == 2) {
            string2 = "\"" + string + "\"" + "^^<" + (String)object2 + ">";
        } else if (n == 4) {
            string2 = "\"" + string + "\"" + "@" + (String)object;
        } else if (n == 5) {
            string2 = ((String)object2).equalsIgnoreCase(XSD_STRING_NO_ENCLOSING) ? "\"" + string + "\"" : "\"" + string + "\"" + "^^<" + (String)object2 + ">";
        } else {
            if (n == 6) {
                throw new RDFException("Feature not supported: Typed-Literal with Language-Tag: type=" + n + " name=" + string3 + " litType=" + (String)object2 + " litLang=" + (String)object);
            }
            throw new RDFException("Feature not supported: non-URI and non-PlainLiteral: type=" + n + " name=" + string3);
        }
        this.log("term=" + string2);
        return string2;
    }

    private String constructKey_for_TriplePattern(TriplesBlock.Element element, TriplesBlock.Element element2, TriplesBlock.Element element3) throws RDFException {
        String string;
        String string2 = string = this.findTerm_for_Element(element, "subject", true);
        string = this.findTerm_for_Element(element2, "predicate", true);
        string2 = string2 + "+" + string;
        string = this.findTerm_for_Element(element3, "object", true);
        string2 = string2 + "+" + string;
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFetchedRRrow(ResultSet resultSet, Set<String> set, ArrayList<String> arrayList, String string, String string2) throws SQLException, RDFException {
        TFTinfo tFTinfo;
        Object object;
        String[] stringArray = new String[2];
        String string3 = null;
        Integer n = 0;
        String string4 = null;
        Integer n2 = 0;
        String string5 = null;
        Integer n3 = 0;
        String string6 = null;
        Integer n4 = 0;
        String string7 = null;
        Integer n5 = 0;
        String[] stringArray2 = new String[2];
        String string8 = resultSet.getString("ROWID");
        String string9 = resultSet.getString("Tmap");
        String string10 = resultSet.getString("tabName");
        String string11 = resultSet.getString("qry");
        String string12 = resultSet.getString("sqlv");
        String string13 = resultSet.getString("subjTemplate");
        String string14 = resultSet.getString("subjCol");
        String string15 = resultSet.getString("subjConstant");
        String string16 = resultSet.getString("subjTermType");
        String string17 = resultSet.getString("subjUnique");
        if (string17.indexOf("false") != -1) {
            this.Tmaps_with_nonUnique_Smaps.add(string9);
        }
        String string18 = resultSet.getString("POmapGraphTemplate");
        String string19 = resultSet.getString("POmapGraphCol");
        String string20 = resultSet.getString("POmapGraphConstant");
        String string21 = resultSet.getString("predTemplate");
        String string22 = resultSet.getString("predCol");
        String string23 = resultSet.getString("predConstant");
        String string24 = resultSet.getString("Omap");
        String string25 = resultSet.getString("objeTemplate");
        String string26 = resultSet.getString("objeCol");
        String string27 = resultSet.getString("objeConstant");
        String string28 = resultSet.getString("objeTermType");
        String string29 = resultSet.getString("objeDataType");
        boolean bl = false;
        String string30 = resultSet.getString("objeLanguage");
        String string31 = resultSet.getString("parentTmap");
        String string32 = resultSet.getString("flags");
        this.log("retrieved RRrowFlags=" + string32);
        this.RRrowFlags_for_Tmap.put(string9, string32);
        String string33 = resultSet.getString("RDFdatatype_DBColType");
        String string34 = resultSet.getString("paTabName");
        String string35 = resultSet.getString("paQry");
        String string36 = resultSet.getString("paSqlV");
        String string37 = resultSet.getString("paSubjTemplate");
        String string38 = resultSet.getString("paSubjCol");
        String string39 = resultSet.getString("paSubjConstant");
        String string40 = resultSet.getString("paSubjTermType");
        String string41 = resultSet.getString("refJoinStr");
        this.log("processFetchedRRrow: checking RRrowid=" + string8);
        if (string != null) {
            object = null;
            if (string.equals("subject") && string13 != null) {
                object = string13;
            } else if (string.equals("predicate") && string21 != null) {
                object = string21;
            } else if (string.equals("object") && string25 != null) {
                object = string25;
            } else if (string.equals("object") && string37 != null) {
                object = string37;
            } else if (string.equals("graph") && string18 != null) {
                object = string18;
            }
            if (object != null) {
                this.log("checking matchability of pos+bgpConstVal=" + string + "+" + string2 + " and template=" + (String)object);
                if (!RelationalBGP.matchableSqlTemplatePair(string2, (String)object, this.ctx)) {
                    this.log("SKIP RRrowid=" + string8 + ": NO matchability of pos+bgpConstVal=" + string + "+" + string2 + " and template=" + (String)object);
                    return;
                }
            }
        }
        if (set != null) {
            set.add(string8);
            this.log("ROWID=" + string8 + " added to RRrowSet: size=" + set.size());
        }
        if (arrayList != null) {
            arrayList.add(string8);
            this.log("ROWID=" + string8 + " added to RRrowList: size=" + arrayList.size());
        }
        object = new ArrayList();
        ArrayList<String> arrayList2 = null;
        ArrayList<String> arrayList3 = null;
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = null;
        ArrayList<String> arrayList6 = null;
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<String> arrayList8 = null;
        ArrayList<String> arrayList9 = null;
        ArrayList<String> arrayList10 = new ArrayList<String>();
        ArrayList<String> arrayList11 = null;
        ArrayList<String> arrayList12 = null;
        ArrayList<String> arrayList13 = new ArrayList<String>();
        ArrayList<String> arrayList14 = null;
        ArrayList<String> arrayList15 = null;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        if (string31 != null) {
            this.log("REF CONSTRAINT processing logic");
            this.log("\n Parent tmap " + string31 + " found for tmap and pexpr(pexprtype) " + string9 + "+" + string4 + "(" + n2 + ")" + " and rowid = " + string8);
            if (string34 != null) {
                stringArray2 = this.resolveOwnTabNames(string34);
            }
            if (string37 != null) {
                string7 = string37;
                n5 = RRTabRowInfo.MapExprType_TEMPLATE;
            } else if (string39 != null) {
                string7 = string39.replace("'", "''");
                n5 = RRTabRowInfo.MapExprType_CONSTANT;
            } else {
                if (string38 == null) throw new RDFException("processFetchedRRrow: psExpr is null for parenttmap=" + string31 + " [tmap=" + string9 + "]");
                string7 = string38;
                n5 = RRTabRowInfo.MapExprType_COLUMN;
            }
            n9 = this.add_TFT(string31, string7, n5, string40, null, (ArrayList<String>)object);
            tFTinfo = this.TFTinfoGlobalList.get(n9);
            arrayList2 = tFTinfo.strList;
            arrayList3 = tFTinfo.colTypeList;
            this.log("psStrList=" + arrayList2);
            this.log("psColTypeList=" + arrayList3);
        }
        if (!this.RRrowInfo_for_MatchingRow.containsKey(string8)) {
            Object object2;
            if (string10 != null) {
                stringArray = this.resolveOwnTabNames(string10);
            }
            if (string13 != null) {
                string3 = string13;
                n = RRTabRowInfo.MapExprType_TEMPLATE;
            } else if (string15 != null) {
                string3 = string15.replace("'", "''");
                n = RRTabRowInfo.MapExprType_CONSTANT;
            } else {
                if (string14 == null) throw new RDFException("processFetchedRRrow: sexpr is null for tmap=" + string9);
                string3 = string14;
                n = RRTabRowInfo.MapExprType_COLUMN;
            }
            n6 = this.add_TFT(string9, string3, n, string16, null, arrayList4);
            tFTinfo = this.TFTinfoGlobalList.get(n6);
            arrayList5 = tFTinfo.strList;
            arrayList6 = tFTinfo.colTypeList;
            this.log("sStrList=" + arrayList5);
            this.log("sColTypeList=" + arrayList6);
            if (string21 != null) {
                string4 = string21;
                n2 = RRTabRowInfo.MapExprType_TEMPLATE;
            } else if (string23 != null) {
                string4 = string23.replace("'", "''");
                n2 = RRTabRowInfo.MapExprType_CONSTANT;
            } else {
                if (string22 == null) throw new RDFException("processFetchedRRrow: pexpr is null for tmap=" + string9);
                string4 = string22;
                n2 = RRTabRowInfo.MapExprType_COLUMN;
            }
            n7 = this.add_TFT(string9, string4, n2, rrIRI, null, arrayList7);
            tFTinfo = this.TFTinfoGlobalList.get(n7);
            arrayList8 = tFTinfo.strList;
            arrayList9 = tFTinfo.colTypeList;
            this.log("pStrList=" + arrayList8);
            this.log("pColTypeList=" + arrayList9);
            if (string18 != null) {
                string5 = string18;
                n3 = RRTabRowInfo.MapExprType_TEMPLATE;
            } else if (string20 != null) {
                if (string20.equals(rrDefaultGraph)) {
                    string5 = null;
                    n3 = 0;
                } else {
                    string5 = string20.replace("'", "''");
                    n3 = RRTabRowInfo.MapExprType_CONSTANT;
                }
            } else if (string19 != null) {
                string5 = string19;
                n3 = RRTabRowInfo.MapExprType_COLUMN;
            }
            if (string5 != null || this.activeGraph != null && this.graphVar != null && this.graphMatchUnnamed) {
                n10 = this.add_TFT(string9, string5, n3, rrIRI, null, arrayList10);
                if (string5 == null) {
                    this.log("add a dummy TFT with NULL as the template: to account for match with NULL graph");
                }
                tFTinfo = this.TFTinfoGlobalList.get(n10);
                arrayList11 = tFTinfo.strList;
                arrayList12 = tFTinfo.colTypeList;
                this.log("pogStrList=" + arrayList11);
                this.log("pogColTypeList=" + arrayList12);
            }
            if (string25 != null) {
                string6 = string25;
                n4 = RRTabRowInfo.MapExprType_TEMPLATE;
                if (string29 != null || string30 != null) {
                    if (string28 == null) {
                        string28 = rrLiteral;
                    } else if (!string28.equals(rrLiteral)) {
                        throw new RDFException("Found incorrect otermtype=" + string28 + ": must be " + rrLiteral + " because: odatatype (" + string29 + ") or olanguage (" + string30 + ") is non-null");
                    }
                } else if (string28 == null) {
                    string28 = rrIRI;
                }
                if (string28.equals(rrLiteral) && string29 == null && string30 == null) {
                    string29 = XSD_STRING;
                }
            } else if (string27 != null) {
                string6 = string27.replace("'", "''");
                n4 = RRTabRowInfo.MapExprType_CONSTANT;
                object2 = new String[4];
                this.findComponents_of_RDFterm_simple(string27, (String[])object2);
                if (object2[1].equals("UR")) {
                    string28 = rrIRI;
                } else if (object2[1].equals("BN")) {
                    string28 = rrBlankNode;
                } else {
                    if (!object2[1].equals("PL") && !object2[1].equals("TL") && !object2[1].equals("PL@")) throw new RDFException("Unknown Value_Type (" + object2[1] + ") extracted from oconst=" + string27);
                    string28 = rrLiteral;
                    string29 = "<" + object2[2] + ">";
                    if (object2[1].equals("PL")) {
                        bl = true;
                    }
                    string30 = object2[3];
                }
            } else if (string26 != null) {
                object2 = RelationalBGP.get_base_prefix_from_RR_table(string26);
                String string42 = object2 != null ? RelationalBGP.get_col_name_from_RR_table(string26) : string26;
                string6 = string26;
                n4 = RRTabRowInfo.MapExprType_COLUMN;
                if (string28 == null) {
                    string28 = rrLiteral;
                }
                if (string28.equals(rrLiteral) && string29 == null && string30 == null) {
                    this.log("odatatype=null: setting it to the appropriate non-null value (otermtype=" + string28 + ")");
                    String string43 = string42.charAt(0) == '\"' ? string42.substring(1, string42.length() - 1) : string42.toUpperCase();
                    LtcTabRowInfo ltcTabRowInfo = this.LtcRowInfo_for_Tmap_plus_Col.get(string9 + "+" + string43);
                    if (ltcTabRowInfo == null) {
                        this.log("LtcRowInfo == null [tmap=" + string9 + ", ocolName=" + string42 + ", ocol=" + string26 + "]");
                        throw new RDFException("LtcRowInfo == null [tmap=" + string9 + ", ocolName=" + string42 + ", ocol=" + string26 + "]");
                    }
                    if (ltcTabRowInfo.colTypeName.equals("STRING")) {
                        string29 = XSD_STRING;
                    } else if (ltcTabRowInfo.colTypeName.equals(LTC_TYPE_NUMBER)) {
                        string29 = XSD_DECIMAL;
                    } else if (ltcTabRowInfo.colTypeName.equals("DATE")) {
                        string29 = XSD_DATE;
                    } else if (ltcTabRowInfo.colTypeName.equals(LTC_TYPE_TIMESTAMP) || ltcTabRowInfo.colTypeName.equals(LTC_TYPE_TIMESTAMP_TZ) || ltcTabRowInfo.colTypeName.equals(LTC_TYPE_TIMESTAMP_LTZ)) {
                        string29 = XSD_DATETIME;
                    } else if (ltcTabRowInfo.colTypeName.equals(LTC_TYPE_BFLOAT)) {
                        string29 = XSD_FLOAT;
                    } else {
                        if (!ltcTabRowInfo.colTypeName.equals(LTC_TYPE_BDOUBLE)) throw new RDFException("Unsupported LtcRowInfo.colTypeName: " + ltcTabRowInfo.colTypeName);
                        string29 = XSD_DOUBLE;
                    }
                    this.log("odatatype changed from null to: " + string29 + ")");
                }
            }
            if (string6 != null) {
                n8 = this.add_TFT(string9, string6, n4, string28, string29, arrayList13);
                tFTinfo = this.TFTinfoGlobalList.get(n8);
                arrayList14 = tFTinfo.strList;
                arrayList15 = tFTinfo.colTypeList;
                this.log("oStrList=" + arrayList14);
                this.log("oColTypeList=" + arrayList15);
            }
            if (string6 == null && string7 == null) {
                throw new RDFException("processFetchedRRrow: oexpr is null AND psexpr is null for tmap=" + string9);
            }
            object2 = new RRTabRowInfo(string8, string9, stringArray[0], stringArray[1], string11, string12, string3, n, string16, n6, arrayList4, arrayList5, arrayList6, string5, n3, n10, arrayList10, arrayList11, arrayList12, string4, n2, n7, arrayList7, arrayList8, arrayList9, string24, string6, n4, string28, string29, bl, string30, n8, arrayList13, arrayList14, arrayList15, string31, stringArray2[0], stringArray2[1], string35, string36, string7, n5, string40, n9, (ArrayList<String>)object, arrayList2, arrayList3, string41, string33);
            this.RRrowInfo_for_MatchingRow.put(string8, (RRTabRowInfo)object2);
            this.log("after insertion of row " + string8 + " into tabrowinfo set " + ((RRTabRowInfo)object2).toString());
            return;
        } else {
            this.log("SKIPPED rowid: " + string8);
        }
    }

    private void importLtcTabRowInfo() throws SQLException, RDFException {
        block16: {
            Connection connection = DriverManager.getConnection("jdbc:oracle:kprb:");
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            String string = "SELECT Tmap, col_Name, col_type, col_type_name, col_max_len, col_precision, col_scale FROM " + Util.qualifiedSQLName((Connection)connection, (String)this.Ltc_tab_qname) + " ltc";
            try {
                preparedStatement = connection.prepareStatement(string);
                resultSet = preparedStatement.executeQuery();
                this.LtcRowInfo_for_Tmap_plus_Col = new HashMap();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("Tmap");
                    String string3 = resultSet.getString("col_name");
                    Integer n = resultSet.getInt("col_type");
                    String string4 = resultSet.getString("col_type_name");
                    Integer n2 = resultSet.getInt("col_max_len");
                    Integer n3 = resultSet.getInt("col_precision");
                    Integer n4 = resultSet.getInt("col_scale");
                    LtcTabRowInfo ltcTabRowInfo = new LtcTabRowInfo(string2, string3, n, string4, n2, n3, n4);
                    String string5 = string2 + "+" + string3;
                    this.LtcRowInfo_for_Tmap_plus_Col.put(string5, ltcTabRowInfo);
                    this.log("after insertion of LtcRow: key (Tmap+colName)=" + string5 + " type info:\n" + ltcTabRowInfo.toString());
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                int n = sQLException.getErrorCode();
                this.log("ret_code=" + n);
                if (Math.abs(n) == 942) {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    this.log("LTC table (" + this.Ltc_tab_qname + ") not present in the database");
                    break block16;
                }
                throw sQLException;
            }
            catch (Exception exception) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                exception.printStackTrace();
                throw new RDFException("[see trace file for more details] Failed while adding all RR tab rows");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    private void fetchGeometryColMetadata(LtcTabRowInfo ltcTabRowInfo, String string, String string2, String string3) throws SQLException, RDFException {
        block16: {
            String string4 = " GCM.SRID,\n DI.SDO_DIMNAME , DI.SDO_LB, DI.SDO_UB, DI.SDO_TOLERANCE";
            String string5 = "MDSYS.ALL_SDO_GEOM_METADATA";
            Connection connection = DriverManager.getConnection("jdbc:oracle:kprb:");
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            String string6 = "SELECT " + string4 + "\n  FROM " + string5 + " GCM, TABLE(GCM.DIMINFO) DI " + "\n WHERE GCM.OWNER = :ownerName " + "\n   AND GCM.TABLE_NAME = :tableName " + "\n   AND GCM.COLUMN_NAME = :geoColName ";
            this.log("[ML] query_for_geometryColMetadata: \n" + string6 + "\n WITH\n ownerName=" + string + " tableName=" + string2 + " geoColName=" + string3);
            try {
                preparedStatement = connection.prepareStatement(string6);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string7 = resultSet.getString("SRID");
                    String string8 = resultSet.getString("SDO_DIMNAME");
                    String string9 = resultSet.getString("SDO_LB");
                    String string10 = resultSet.getString("SDO_UB");
                    String string11 = resultSet.getString("SDO_TOLERANCE");
                    ltcTabRowInfo.setGeomMetadata(string7, string8, string9, string10, string11);
                    this.log("after gathering SDO_GEOMETRY metadata of LtcRow: key (Tmap+colName)=" + ltcTabRowInfo.Tmap + "+" + ltcTabRowInfo.colName + " type info:\n" + ltcTabRowInfo.toString());
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                int n = sQLException.getErrorCode();
                this.log("ret_code=" + n);
                if (Math.abs(n) == 942) {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    this.log("LTC table (" + this.Ltc_tab_qname + ") not present in the database");
                    break block16;
                }
                throw sQLException;
            }
            catch (Exception exception) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                exception.printStackTrace();
                throw new RDFException("[see trace file for more details] Failed while adding SDO_GEOMETRY metadata");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findMatchingRRrowSets_for_BGPconstants() throws SQLException, RDFException {
        Object object;
        Connection connection = DriverManager.getConnection("jdbc:oracle:kprb:");
        Statement statement = null;
        Statement statement2 = null;
        Statement statement3 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = Util.qualifiedSQLName((Connection)connection, (String)this.rr_tab_qname);
        String string2 = "SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr" + " WHERE rr.subjTemplate is NOT NULL " + "    OR rr.subjCol is NOT NULL " + "    OR rr.subjConstant=:1 ";
        String string3 = "SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr" + " WHERE rr.predTemplate is NOT NULL " + "    OR rr.predCol is NOT NULL " + "    OR rr.predConstant=:1 ";
        String string4 = " SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr" + "  WHERE ((rr.objeCol is NOT NULL OR rr.objeTemplate is NOT NULL) AND rr.objeTermType=:1) " + "     OR rr.objeConstant=sdo_rdf.get_canon_val(:2,' GCVN_ALLOW_VALUE_ID ') " + " UNION " + " SELECT rr.rowid" + RRrowSelList + " FROM " + string + " rr" + "  WHERE parentTmap is NOT NULL" + "    and parentTmap in (" + " select distinct Tmap from " + string + " rr " + "  where subjTemplate is NOT NULL or subjCol is NOT NULL or (subjConstant = :3)" + ")";
        String string5 = "SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + string + " rr" + " WHERE rr.POmapGraphTemplate is NOT NULL " + "    OR rr.POmapGraphCol      is NOT NULL " + "    OR rr.POmapGraphConstant=:1 ";
        try {
            boolean bl;
            Set<String> set;
            String string6;
            Object object2;
            HashSet hashSet = new HashSet();
            HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
            statement = connection.prepareStatement(string3);
            statement2 = connection.prepareStatement(string2);
            statement3 = connection.prepareStatement(string4);
            preparedStatement = connection.prepareStatement(string5);
            if (this.activeGraph != null && this.graphVar == null) {
                object2 = "<" + this.activeGraph.name + ">";
                string6 = "graph";
                preparedStatement.setString(1, (String)object2);
                resultSet = preparedStatement.executeQuery();
                set = this.RRrowSet_for_BGPconst.get(string6 + "+" + (String)object2);
                if (set == null) {
                    this.log("--------------- compute RRrowSet pos+bgpConstVal=" + string6 + "+" + (String)object2);
                    set = new HashSet<String>();
                    this.RRrowSet_for_BGPconst.put(string6 + "+" + (String)object2, set);
                    bl = true;
                } else {
                    this.log("SKIP: RRrowSet already exists for bgpConstPos+bgpConstVal=" + string6 + "+" + (String)object2 + " RRrowSet:" + set + " tmp_RRrowSet: " + hashSet);
                    bl = false;
                }
                while (resultSet.next()) {
                    this.processFetchedRRrow(resultSet, set, null, string6, (String)object2);
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            for (String string7 : this.bgp.BGPelements.keySet()) {
                BGPNodeInfo bGPNodeInfo = this.bgp.BGPelements.get(string7);
                this.log("findMatchingRRrowSets_for_BGPconstants: rdfTerm=" + string7 + " : bgpNode=" + bGPNodeInfo.toString());
                if (bGPNodeInfo.type.equals("0")) continue;
                object2 = this.findTerm_from_BGPNodeInfo(bGPNodeInfo);
                string6 = bGPNodeInfo.position;
                char c = ((String)object2).charAt(0);
                object = c == '<' ? rrIRI : (c == '\"' ? rrLiteral : rrBlankNode);
                this.log("[bgpConstPos+bgpConstVal+bgpConstTermType]: " + string6 + "+" + (String)object2 + "+" + (String)object);
                if (string6.equalsIgnoreCase("predicate")) {
                    statement.setString(1, (String)object2);
                    resultSet = statement.executeQuery();
                } else if (string6.equalsIgnoreCase("subject")) {
                    statement2.setString(1, (String)object2);
                    resultSet = statement2.executeQuery();
                } else if (string6.equalsIgnoreCase("object")) {
                    statement3.setString(1, (String)object);
                    statement3.setString(2, (String)object2);
                    statement3.setString(3, (String)object2);
                    resultSet = statement3.executeQuery();
                }
                set = this.RRrowSet_for_BGPconst.get(string6 + "+" + (String)object2);
                if (set == null) {
                    this.log("--------------- compute RRrowSet pos+bgpConstVal=" + string6 + "+" + (String)object2);
                    set = new HashSet<String>();
                    this.RRrowSet_for_BGPconst.put(string6 + "+" + (String)object2, set);
                    bl = true;
                } else {
                    this.log("SKIP: RRrowSet already exists for bgpConstPos+bgpConstVal=" + string6 + "+" + (String)object2 + " RRrowSet:" + set + " tmp_RRrowSet: " + hashSet);
                    bl = false;
                    continue;
                }
                while (resultSet.next()) {
                    this.processFetchedRRrow(resultSet, set, null, string6, (String)object2);
                }
                if (resultSet == null) continue;
                resultSet.close();
            }
            this.log("printing child table tmap and parent table tmap mappings");
            RelationalBGP.printMapSet(hashMap, this.ctx);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (statement3 != null) {
                statement3.close();
            }
            if (statement2 != null) {
                statement2.close();
            }
            if (preparedStatement != null) {
                statement2.close();
            }
        }
        this.log("===>SUMMARY ");
        for (String string6 : this.RRrowSet_for_BGPconst.keySet()) {
            object = this.RRrowSet_for_BGPconst.get(string6);
            this.log("SUMMARY: [" + string6 + "] : RRrowSet.size()=" + object.size() + " : " + object);
        }
    }

    private void findMatchingRRrowSets_for_TriplePatterns(int n) throws SQLException, RDFException {
        String string;
        HashMap hashMap = new HashMap();
        List<TriplesBlock> list = this.bgp.TBList;
        if (this.dummyTBList.size() > 0) {
            if (this.bgp.TBList.size() != 0) {
                this.log("EXCEPTION: [expected size=0 b/c dummyTBList.size()=" + this.dummyTBList.size() + "] bgp.TBList.size()=" + this.bgp.TBList.size() + " : " + this.bgp.TBList);
            } else {
                list = this.dummyTBList;
            }
            this.log("findMatchingRRrowSets_for_TriplePatterns => TBList being used: " + list);
        }
        Set<String> set = null;
        if (this.activeGraph != null && this.graphVar == null) {
            string = "<" + this.activeGraph.name + ">";
            set = this.RRrowSet_for_BGPconst.get("graph+" + string);
            this.log("---->RRrowSet for graph=graph+" + string + ": " + set);
        }
        for (TriplesBlock triplesBlock : list) {
            ArrayList<String> arrayList;
            String string2;
            HashSet<String> hashSet;
            Set<String> set2 = null;
            Set<String> set3 = null;
            Set<String> set4 = null;
            TriplesBlock.Element element = triplesBlock.getSubject();
            TriplesBlock.Element element2 = triplesBlock.getPredicate();
            TriplesBlock.Element element3 = triplesBlock.getObject();
            String string3 = this.constructKey_for_TriplePattern(element, element2, element3);
            if (!element.isVariable()) {
                string = this.findTerm_for_Element(element, "subject", false);
                set2 = this.RRrowSet_for_BGPconst.get("subject+" + string);
                this.log("---->RRrowSet for sub=subject+" + string + ": " + set2);
            } else {
                hashSet = element.getName();
                string2 = (String)((Object)hashSet) + "+subject:" + string3;
                arrayList = this.OccPosList_for_Var.get(hashSet);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.OccPosList_for_Var.put((String)((Object)hashSet), arrayList);
                }
                this.log("adding subject OccPosInfo for var=" + (String)((Object)hashSet) + " : " + string2);
                arrayList.add(string2);
            }
            if (!element2.isVariable()) {
                string = this.findTerm_for_Element(element2, "predicate", false);
                set3 = this.RRrowSet_for_BGPconst.get("predicate+" + string);
                this.log("---->RRrowSet for pred=predicate+" + string + ": " + set3);
            } else {
                hashSet = element2.getName();
                string2 = (String)((Object)hashSet) + "+predicate:" + string3;
                arrayList = this.OccPosList_for_Var.get(hashSet);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.OccPosList_for_Var.put((String)((Object)hashSet), arrayList);
                }
                this.log("adding predicate OccPosInfo for var=" + (String)((Object)hashSet) + " : " + string2);
                arrayList.add(string2);
            }
            if (!element3.isVariable()) {
                string = this.findTerm_for_Element(element3, "object", false);
                set4 = this.RRrowSet_for_BGPconst.get("object+" + string);
                this.log("---->RRrowSet for obj=object+" + string + ": " + set4);
            } else {
                hashSet = element3.getName();
                string2 = (String)((Object)hashSet) + "+object:" + string3;
                arrayList = this.OccPosList_for_Var.get(hashSet);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.OccPosList_for_Var.put((String)((Object)hashSet), arrayList);
                }
                this.log("adding object OccPosInfo for var=" + (String)((Object)hashSet) + " : " + string2);
                arrayList.add(string2);
            }
            if (n == 1) {
                Set<Object> set5;
                Object object;
                HashSet<String> hashSet2;
                boolean bl = false;
                boolean bl2 = false;
                if (!element2.isVariable() || !element.isVariable() || !element3.isVariable() || this.activeGraph != null && this.graphVar == null) {
                    String string4;
                    String string5;
                    HashSet hashSet3;
                    arrayList = new HashSet();
                    this.RRrowSet_for_TriplePattern.put(string3, (Set<String>)((Object)arrayList));
                    if (this.activeGraph != null && this.graphVar == null) {
                        arrayList.addAll(set);
                        bl = true;
                    }
                    this.log("====>[after using graph_RRrowSet] RRrowSet for tp_key=" + string3 + " is: " + arrayList);
                    if (!element2.isVariable()) {
                        if (bl) {
                            arrayList.retainAll(set3);
                        } else {
                            arrayList.addAll(set3);
                            bl = true;
                        }
                    }
                    this.log("====>[after using pred_RRrowSet] RRrowSet for tp_key=" + string3 + " is: " + arrayList);
                    if (!element.isVariable()) {
                        if (bl) {
                            arrayList.retainAll(set2);
                        } else {
                            arrayList.addAll(set2);
                            bl = true;
                        }
                    }
                    this.log("====>[after using  sub_RRrowSet] RRrowSet for tp_key=" + string3 + " is: " + arrayList);
                    if (!element3.isVariable()) {
                        if (bl) {
                            arrayList.retainAll(set4);
                        } else {
                            arrayList.addAll(set4);
                            bl = true;
                        }
                    }
                    this.log("====>[after using  obj_RRrowSet] RRrowSet for tp_key=" + string3 + " is: " + arrayList);
                    if (element.isVariable()) {
                        hashSet2 = new HashSet();
                        object = new HashSet();
                        for (String string6 : arrayList) {
                            this.log("rowid for this subElem variable: " + string6);
                            if (this.RRrowInfo_for_MatchingRow.get(string6) == null) {
                                this.log("going to crash b/c rowid DOES NOT EXIST in RRrowInfo_for_MatchingRow: " + this.RRrowInfo_for_MatchingRow);
                            }
                            hashSet2.add(this.RRrowInfo_for_MatchingRow.get((Object)string6).Tmap);
                            object.add(new predVarMapping(string6, this.RRrowInfo_for_MatchingRow.get((Object)string6).Tmap));
                        }
                        set5 = this.TmapSet_for_svar.get(element.getName());
                        if (set5 == null) {
                            set5 = new HashSet();
                            set5.addAll(hashSet2);
                        } else {
                            set5.retainAll(hashSet2);
                        }
                        hashSet3 = (HashSet)hashMap.get(element.getName());
                        if (hashSet3 == null) {
                            hashSet3 = new HashSet();
                            hashSet3.addAll(object);
                        } else {
                            hashSet3.addAll(object);
                            HashSet hashSet4 = new HashSet();
                            hashSet4.addAll(hashSet3);
                            for (predVarMapping predVarMapping2 : hashSet4) {
                                string5 = predVarMapping2.predName;
                                string4 = predVarMapping2.subjVarName;
                                if (set5.contains(string5)) continue;
                                hashSet3.remove(predVarMapping2);
                            }
                        }
                        hashMap.put(element.getName(), hashSet3);
                        this.TmapSet_for_svar.put(element.getName(), set5);
                    }
                    if (element2.isVariable()) {
                        hashSet2 = new HashSet<String>();
                        for (String string7 : arrayList) {
                            hashSet2.add(this.RRrowInfo_for_MatchingRow.get((Object)string7).pExpr);
                        }
                        set5 = this.PredConstSet_for_pvar.get(element.getName() + "+" + element2.getName());
                        if (set5 == null) {
                            set5 = new HashSet();
                            set5.addAll(hashSet2);
                        } else {
                            set5.retainAll(hashSet2);
                        }
                        this.PredConstSet_for_pvar.put(element.getName() + "+" + element2.getName(), set5);
                    }
                    if (element3.isVariable()) {
                        hashSet2 = new HashSet();
                        object = new HashSet();
                        for (String string8 : arrayList) {
                            String string9 = this.RRrowInfo_for_MatchingRow.get((Object)string8).paTmap;
                            if (string9 == null) continue;
                            hashSet2.add(string9);
                            object.add(new predVarMapping(string8, string9));
                        }
                        set5 = this.TmapSet_for_svar.get(element3.getName());
                        if (hashSet2.size() > 0 && hashSet2 != null) {
                            if (set5 == null) {
                                set5 = new HashSet();
                                set5.addAll(hashSet2);
                            } else {
                                set5.retainAll(hashSet2);
                            }
                            this.TmapSet_for_svar.put(element3.getName(), set5);
                        }
                        hashSet3 = (Set)hashMap.get(element3.getName());
                        if (object.size() > 0 && object != null) {
                            if (hashSet3 == null) {
                                hashSet3 = new HashSet();
                                hashSet3.addAll(object);
                            } else {
                                HashSet hashSet5 = new HashSet();
                                hashSet5.addAll(hashSet3);
                                for (predVarMapping predVarMapping2 : hashSet5) {
                                    string5 = predVarMapping2.predName;
                                    string4 = predVarMapping2.subjVarName;
                                    if (set5.contains(string5)) continue;
                                    hashSet3.remove(predVarMapping2);
                                }
                                hashSet3.addAll(object);
                            }
                            hashMap.put(element3.getName(), hashSet3);
                        }
                    }
                } else if (!bl2) {
                    arrayList = null;
                    hashSet2 = null;
                    set5 = null;
                    try {
                        arrayList = DriverManager.getConnection("jdbc:oracle:kprb:");
                        object = "SELECT rr.rowid, Tmap, tabName, qry, sqlv, subjTemplate, subjCol, subjConstant, subjTermType, subjUnique, POmapGraphTemplate, POmapGraphCol, POmapGraphConstant, predTemplate, predCol, predConstant, Omap, objeTemplate, objeCol, objeConstant, objeTermType, objeDataType, objeLanguage, parentTmap, flags, RDFdatatype_DBColType, paTabName, paQry, paSqlV, paSubjTemplate, paSubjCol, paSubjConstant, paSubjTermType, refJoinStr FROM " + Util.qualifiedSQLName((Connection)((Object)arrayList), (String)this.rr_tab_qname) + " rr";
                        this.log("query_for_rr_tab_all_rows: " + (String)object);
                        hashSet2 = arrayList.prepareStatement((String)object);
                        set5 = hashSet2.executeQuery();
                        this.log("before adding all RR tab rows: " + this.RRrowInfo_for_MatchingRow.keySet().size() + " : \n" + this.RRrowInfo_for_MatchingRow.keySet());
                        while (set5.next()) {
                            this.processFetchedRRrow((ResultSet)((Object)set5), null, this.RRrowList_All, null, null);
                        }
                    }
                    catch (Exception exception) {
                        if (set5 != null) {
                            set5.close();
                        }
                        if (hashSet2 != null) {
                            hashSet2.close();
                        }
                        exception.printStackTrace();
                        throw new RDFException("[see trace file for more details] Failed while adding all RR tab rows");
                    }
                    finally {
                        if (set5 != null) {
                            set5.close();
                        }
                        if (hashSet2 != null) {
                            hashSet2.close();
                        }
                    }
                    this.log("AFTER  adding all RR tab rows: " + this.RRrowInfo_for_MatchingRow.keySet().size() + " : \n" + this.RRrowInfo_for_MatchingRow.keySet() + "\nRRrowList_All.size()=" + this.RRrowList_All.size() + " : \n" + this.RRrowList_All);
                    bl2 = true;
                }
            }
            if ((hashSet = this.RRrowSet_for_TriplePattern.get(string3)) != null) continue;
            hashSet = new HashSet<String>();
            hashSet.addAll(this.RRrowList_All);
            this.RRrowSet_for_TriplePattern.put(string3, hashSet);
        }
        this.log("RRrowSet_for_TriplePattern AFTER pass 1 BEFORE pass 2: " + this.RRrowSet_for_TriplePattern);
        this.log("--------------------------------------------------");
        this.findMatchingRRrowSets_for_MultiOccVars();
        this.log("**************************************************");
    }

    private void dumpMatchabilityStructures(ArrayList<String> arrayList, ArrayList<ArrayList<String>> arrayList2, ArrayList<ArrayList<String>> arrayList3) {
        this.log("---------- dump of Matchability Structures ----------------------------");
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            this.log("===============> OccPosList.get(OccPos_idx=" + i + ")=" + arrayList.get(i));
            String string = arrayList.get(i);
            String string2 = string.substring(string.indexOf(":") + 1, string.length());
            Set<String> set = this.RRrowSet_for_TriplePattern.get(string2);
            ArrayList<String> arrayList4 = arrayList2.get(i);
            ArrayList<String> arrayList5 = arrayList3.get(i);
            this.log("... RRrowSet=" + set);
            this.log("... RRrowList=" + arrayList4);
            this.log("... MatchInfoList: " + arrayList5);
            if (set != null) {
                this.log("Sizes: RRrowSet=" + set.size());
            }
            if (arrayList4 == null) continue;
            this.log("Sizes: RRrowList=" + arrayList4.size() + " MatchInfoList=" + arrayList5.size());
            for (n = 0; n < arrayList4.size(); ++n) {
                this.log("[idx=" + n + "] RRrowid=" + arrayList4.get(n) + " MatchInfo: " + arrayList5.get(n));
            }
            for (n = 0; n < arrayList4.size(); ++n) {
                if (!arrayList5.get(n).substring(0, 2).equals("MI")) continue;
                this.log("[idx=" + n + "] RRrowid=" + arrayList4.get(n) + " MatchInfo: " + arrayList5.get(n));
            }
            for (n = 0; n < arrayList4.size(); ++n) {
                if (!arrayList5.get(n).substring(0, 2).equals("MI")) continue;
                this.log(arrayList4.get(n));
            }
        }
        this.log("---------- END: dump of Matchability Structures ----------------------------");
    }

    private void findMatchingRRrowSets_for_MultiOccVars() {
        Object object;
        Object object2;
        this.log("Entered: findMatchingRRrowSets_for_MultiOccVars");
        this.log("RRrowSet_for_TriplePattern: " + this.RRrowSet_for_TriplePattern);
        this.log("initial OccPosList_for_Var: " + this.OccPosList_for_Var);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object3 : this.OccPosList_for_Var.keySet()) {
            ArrayList<String> arrayList2 = this.OccPosList_for_Var.get(object3);
            if (arrayList2.size() <= 1) {
                arrayList.add(object3);
                this.log("SKIP var=" + object3 + " => NOT a multi-occurring var");
                continue;
            }
            object2 = null;
            boolean bl = false;
            for (String string : arrayList2) {
                this.log("processing var=" + object3 + ": OccPosInfo=" + string);
                String string2 = string.substring(string.indexOf(":") + 1, string.length());
                object = this.RRrowSet_for_TriplePattern.get(string2);
                if (object == null) {
                    this.log("this occurrence for var=" + object3 + " is associated triple-pattern has NULL RRrowSet: tp_key=" + string2);
                }
                this.log("for var=" + object3 + ": tp_key in OccPosInfo is: " + string2);
                if (!bl && object2 != null && !string.equals(object2)) {
                    bl = true;
                }
                if (object2 != null) continue;
                object2 = string;
            }
            if (bl) continue;
            arrayList.add(object3);
            this.log("SKIP var=" + object3 + " => NOT a multi-occurring var (after stringent check)");
        }
        for (String string : arrayList) {
            this.OccPosList_for_Var.remove(string);
        }
        this.log("post-filter OccPosList_for_Var: " + this.OccPosList_for_Var);
        int n = this.OccPosList_for_Var.size();
        if (n == 0) {
            return;
        }
        for (String string : this.OccPosList_for_Var.keySet()) {
            int n2;
            int n3;
            Object object3;
            int n4;
            int n5;
            int n6;
            ArrayList<String> arrayList3;
            Collection<Object> collection;
            ArrayList<String> arrayList4;
            object2 = this.OccPosList_for_Var.get(string);
            this.log("OccPosList for var=" + string + " : " + object2);
            ArrayList<ArrayList<String>> arrayList5 = new ArrayList<ArrayList<String>>();
            ArrayList arrayList6 = new ArrayList();
            Iterator<String> iterator = ((ArrayList)object2).iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                object = string3.substring(string3.indexOf(":") + 1, string3.length());
                arrayList4 = (ArrayList<String>)((Object)this.RRrowSet_for_TriplePattern.get(object));
                if (arrayList4 == null) {
                    arrayList4 = this.RRrowList_All;
                    this.log("NULL RRrowSet: Added using RRrowList_All");
                }
                this.log("alloc/init RRrowList and MatchInfoList for OccPosInfo: " + string3);
                collection = new ArrayList();
                arrayList3 = new ArrayList<String>();
                arrayList5.add((ArrayList<String>)collection);
                arrayList6.add(arrayList3);
                n6 = 0;
                for (String string4 : arrayList4) {
                    ((ArrayList)collection).add(string4);
                    arrayList3.add("MI=>" + string4 + "#" + n6 + ":");
                    ++n6;
                }
                this.log("Done alloc/init of RRrowList: " + collection);
                this.log("Done alloc/init of MatchInfoList: " + arrayList3);
            }
            do {
                n5 = 0;
                for (n4 = 0; n4 < ((ArrayList)object2).size(); ++n4) {
                    this.log("occurrence# i=" + n4);
                    object = (String)((ArrayList)object2).get(n4);
                    this.log("OccPosInfo_i: i=" + n4 + " : " + (String)object);
                    arrayList4 = arrayList5.get(n4);
                    collection = (ArrayList)arrayList6.get(n4);
                    this.log("RRrowList_i: i=" + n4 + " : " + arrayList4);
                    this.log("MatchInfoList_i: i=" + n4 + " : " + collection);
                    if (arrayList4 == null) continue;
                    arrayList3 = ((String)object).substring(((String)object).indexOf("+") + 1, ((String)object).indexOf(":"));
                    this.log("OccPos_i=" + arrayList3);
                    for (n6 = 0; n6 < arrayList4.size(); ++n6) {
                        String string4;
                        this.log("(in occurrence# i=" + n4 + "): RRrowid# x=" + n6);
                        if (((String)((ArrayList)collection).get(n6)).substring(0, 2).equals("XX")) {
                            this.log("SKIP RRrowid=" + (String)arrayList4.get(n6) + " has already been marked as NON-MATCHING: " + (String)((ArrayList)collection).get(n6));
                            continue;
                        }
                        object3 = null;
                        string4 = null;
                        n3 = -1;
                        n2 = 0;
                        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                            String string5;
                            int n7;
                            String string6;
                            String string7 = (String)((ArrayList)collection).get(n6);
                            this.log("..checking list of RRrowids for occurrence# j=" + i + " (latest MatchInfoList_i_x=" + string7 + ")");
                            String string8 = (String)((ArrayList)object2).get(i);
                            this.log("OccPosInfo_j: j=" + i + " : " + string8);
                            ArrayList<String> arrayList7 = arrayList5.get(i);
                            ArrayList arrayList8 = (ArrayList)arrayList6.get(i);
                            String string9 = BASE_PREFIX_COLNAME_SEP + i + "-";
                            if (i == n4 || arrayList7 == null) {
                                string6 = string9 + "X$";
                                if (i == n4) {
                                    this.log("TRIVIAL MATCH b/c j==i");
                                } else {
                                    this.log("TRIVIAL MATCH b/c RRrowList_j=(" + arrayList7 + ") is NULL (implying matchable with all RRrowids)");
                                }
                                if (string7.indexOf(string6) < 0) {
                                    this.log("... appending: " + string6 + " to MatchInfoList_i_x=" + string7);
                                    ((ArrayList)collection).set(n6, string7 + string6);
                                } else {
                                    this.log("no need to append: already present: " + string6 + " in MatchInfoList_i_x=" + string7);
                                }
                                this.log("MatchInfoList_i.get(" + n6 + ")=" + (String)((ArrayList)collection).get(n6));
                                continue;
                            }
                            string6 = string8.substring(string8.indexOf("+") + 1, string8.indexOf(":"));
                            this.log("OccPos_j=" + string6);
                            int n8 = string7.lastIndexOf(string9);
                            if (n8 >= 0) {
                                n7 = string7.indexOf(36, n8);
                                string4 = string7.substring(n8, n7 + 1);
                                n3 = Integer.parseInt(string4.substring(string4.indexOf(45) + 1, string4.length() - 1));
                                this.log("....a matchable RRrowid already present (for occurrence# j=" + i + "): match_i_x_j_full=" + string4);
                                if (((String)arrayList8.get(n3)).substring(0, 2).equals("XX")) {
                                    this.log("......BUT the RRrowid has since been discarded! MatchInfoList_j.get(" + n3 + ")=" + (String)arrayList8.get(n3));
                                    String string10 = string7.substring(0, n8) + string7.substring(n7 + 1);
                                    this.log("shrinking MatchInfo to remove now-discarded match: " + string10);
                                    ((ArrayList)collection).set(n6, string10);
                                    string7 = (String)((ArrayList)collection).get(n6);
                                    this.log("latest (shrunk) MatchInfoList_i_x=" + string7);
                                    n2 = 1;
                                }
                            }
                            n7 = 0;
                            if (n3 != -1 && n2 == 0) continue;
                            if (n3 != -1 && n2 != 0) {
                                n7 = n3 + 1;
                            }
                            int n9 = -1;
                            this.log("starting search for matchable RRrowid in RRrowList for occ# j=" + i + " at start_idx=" + n7);
                            if (n7 >= arrayList7.size()) {
                                this.log("But NO RRrowids left to search in the list: RRrowList_j.size()=" + arrayList7.size());
                            } else {
                                n9 = this.findIndexOfMatchableRRrow((String)arrayList4.get(n6), arrayList7, arrayList8, (String)((Object)arrayList3), string6, n7);
                            }
                            if (n9 == -1) {
                                string5 = string9 + "Z$";
                                ((ArrayList)collection).set(n6, "XX" + string7.substring(2) + string5);
                                this.log("REMOVED: i=" + n4 + " x=" + n6 + " : " + (String)((ArrayList)collection).get(n6));
                                ++n5;
                                break;
                            }
                            string5 = string9 + n9 + NATIVE_SUFFIX;
                            ((ArrayList)collection).set(n6, string7 + string5);
                            this.log("RECORD MATCHABLE: i=" + n4 + " x=" + n6 + " : " + (String)((ArrayList)collection).get(n6));
                            String string11 = BASE_PREFIX_COLNAME_SEP + n4 + "-";
                            String string12 = string11 + n6 + NATIVE_SUFFIX;
                            int n10 = ((String)arrayList8.get(n9)).lastIndexOf(string11);
                            if (n10 >= 0) {
                                this.log("....SKIP reverse_match_recording b/c a matchable RRrowid already present for j=" + i + " m=" + n9 + ": MatchInfoList_j.get(m)=" + (String)arrayList8.get(n9));
                                continue;
                            }
                            arrayList8.set(n9, (String)arrayList8.get(n9) + string12);
                            this.log("(REVERSE) RECORD MATCHABLE: j=" + n4 + " m=" + n6 + " : " + (String)arrayList8.get(n9));
                        }
                        this.log("MatchInfoList_i.get(x): i=" + n4 + " x=" + n6 + " : " + (String)((ArrayList)collection).get(n6));
                    }
                }
                this.log("dump of Matchability structures for var=" + string + " (RRrowid_removal_cnt=" + n5 + ")");
                this.dumpMatchabilityStructures((ArrayList<String>)object2, arrayList5, arrayList6);
            } while (n5 > 0);
            for (n4 = 0; n4 < ((ArrayList)object2).size(); ++n4) {
                int n11;
                this.log("===============> OccPosList.get(OccPos_idx=" + n4 + ")=" + (String)((ArrayList)object2).get(n4));
                object = (String)((ArrayList)object2).get(n4);
                arrayList4 = ((String)object).substring(((String)object).indexOf(":") + 1, ((String)object).length());
                collection = this.RRrowSet_for_TriplePattern.get(arrayList4);
                this.log("before adjusting: RRrowSet for tp_key=" + (String)((Object)arrayList4) + " : " + collection);
                arrayList3 = arrayList5.get(n4);
                ArrayList arrayList9 = (ArrayList)arrayList6.get(n4);
                this.log("before removal of XX: RRrowList=" + arrayList3);
                if (collection == null) {
                    this.log("NULL RRrowSet encountered during adjustment: RRrowSet=" + collection + " RRrowList=" + arrayList3);
                }
                object3 = new ArrayList();
                for (n11 = 0; n11 < arrayList3.size(); ++n11) {
                    if (!((String)arrayList9.get(n11)).substring(0, 2).equals("XX")) continue;
                    ((ArrayList)object3).add(n11);
                }
                this.log("RRrowid_indexes_for_removal: " + object3);
                n11 = ((ArrayList)object3).size();
                for (n3 = 0; n3 < n11; ++n3) {
                    n2 = (Integer)((ArrayList)object3).get(n11 - n3 - 1);
                    this.log("removing RRrowid_idx=" + n2);
                    arrayList3.remove(n2);
                }
                this.log("AFTER  removal of XX: RRrowList=" + arrayList3);
                if (collection == null) {
                    collection = new HashSet();
                    collection.addAll(arrayList3);
                    this.RRrowSet_for_TriplePattern.put((String)((Object)arrayList4), (Set<String>)collection);
                } else {
                    collection.retainAll(arrayList3);
                }
                this.log("AFTER  adjusting: RRrowSet for tp_key=" + (String)((Object)arrayList4) + " : " + collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] resolveOwnTabNames(String string) throws SQLException {
        String string2 = ".";
        int n = 0;
        int n2 = string.indexOf(string2, n);
        String[] stringArray = new String[2];
        StringBuffer stringBuffer = new StringBuffer();
        ResultSet resultSet = null;
        Statement statement = null;
        String string3 = null;
        if (n2 > 0) {
            stringArray[0] = string.substring(n, n2);
            stringArray[1] = string.substring(n2 + 1, string.length());
        } else {
            if (this.defaultOwner == null) {
                try {
                    stringBuffer.append("SELECT user USR FROM DUAL");
                    Connection connection = DriverManager.getConnection("jdbc:oracle:kprb:");
                    statement = connection.prepareStatement(stringBuffer.toString());
                    resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        string3 = resultSet.getString("USR");
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                stringArray[0] = this.defaultOwner = "\"" + string3 + "\"";
            } else {
                stringArray[0] = this.defaultOwner;
            }
            stringArray[1] = string.substring(n, string.length());
        }
        return stringArray;
    }

    private void populate_FirstOccPos_for_TpatCSRgroup(HashMap<String, String> hashMap, String string) {
        for (String string2 : this.FullOccInfo_for_VarPlusCSRAlias.keySet()) {
            int n;
            String string3 = string2.substring((n = string2.indexOf(43)) + 1);
            if (!string3.equals(string)) continue;
            String string4 = string2.substring(0, n);
            String string5 = this.FullOccInfo_for_VarPlusCSRAlias.get(string2);
            int n2 = string5.indexOf(43, 1);
            if (n2 < 0) {
                n2 = string5.length();
            }
            String string6 = string5.substring(1, n2);
            hashMap.put(string4, string6);
            this.log("populate_FirstOccPos_for_TpatCSRgroup: var=" + string4 + " firstOccPos=" + string6);
        }
    }

    private void add_to_FullOccInfo(String string, String string2, String string3, int n) {
        String string4 = string + "+" + string2;
        String string5 = "+" + string3 + ":" + n;
        String string6 = this.FullOccInfo_for_VarPlusCSRAlias.get(string4);
        if (string6 == null) {
            string6 = "";
        }
        String string7 = string6 + string5;
        this.FullOccInfo_for_VarPlusCSRAlias.put(string4, string7);
        if (this.TypeInfoSet_for_VarPlusCSRAlias.get(string4) == null) {
            this.TypeInfoSet_for_VarPlusCSRAlias.put(string4, new HashSet());
        }
    }

    private void add_to_TypeInfoSet(String string, String string2, RRTabRowInfo rRTabRowInfo) {
        String string3 = string + "+" + string2;
        Set<String> set = this.TypeInfoSet_for_VarPlusCSRAlias.get(string3);
        if (set != null) {
            String string4 = null;
            string4 = rRTabRowInfo.RDFdatatype_DBColType != null ? rRTabRowInfo.oDataType + BASE_PREFIX_COLNAME_SEP + rRTabRowInfo.RDFdatatype_DBColType : NO_DB_COL_TYPE;
            this.log("TypeInfo: " + string4);
            if (!set.add(string4)) {
                this.log("TypeInfo already present in VarPlusCSRAlias=" + string3);
            } else {
                this.log("Extended TypeInfoSet content of VarPlusCSRAlias=" + string3 + " is: " + set);
            }
        }
    }

    private void refineCSRs(ArrayList<String> arrayList) throws RDFException {
        this.log("Entered refineCSRs:" + this.TpatSet_for_TpatCSRGroup.toString());
        block0: for (String string : this.TpatSet_for_TpatCSRGroup.keySet()) {
            this.log("SubjTmapSet_key=" + string);
            Set<String> set = this.TpatSet_for_TpatCSRGroup.get(string);
            if (set.size() == 1) continue;
            this.log("Check to see if breakup is needed for SubjTmapSet_key=" + string);
            Set<String> set2 = this.TmapSet_for_TpatCSRGroup.get(string);
            HashSet<String> hashSet = new HashSet<String>(this.Tmaps_with_nonUnique_Smaps);
            hashSet.retainAll(set2);
            if (hashSet.size() > 0) {
                arrayList.add(string);
                this.log("This TpatCSRGroup is marked for breakup because it contains Tmap(s) with nonUnique Smap: " + ((Object)hashSet).toString());
                continue;
            }
            if (set2.size() == 1) continue;
            boolean bl = false;
            for (String string2 : set2) {
                int n = this.sTFT_idx_for_Tmap.get(string2);
                TFTinfo tFTinfo = this.TFTinfoGlobalList.get(n);
                String string3 = this.SubjRRrowid_for_Tmap.get(string2);
                for (String string4 : set2) {
                    if (string2.compareTo(string4) >= 0) continue;
                    int n2 = this.sTFT_idx_for_Tmap.get(string4);
                    TFTinfo tFTinfo2 = this.TFTinfoGlobalList.get(n2);
                    String string5 = this.SubjRRrowid_for_Tmap.get(string4);
                    this.log("Checking Smap-matchability of Tmaps: " + string2 + " and " + string4);
                    String[] stringArray = new String[2];
                    String string6 = RelationalBGP.matchabilityPlusCond(stringArray, tFTinfo, tFTinfo2, string3, 0, string5, 0, null, this.RRrowInfo_for_MatchingRow, this.ctx);
                    if (!string6.equals("MATCHABLE")) continue;
                    bl = true;
                    this.log("matchable Smaps found: Tmap1=" + string2 + ", Tmap2=" + string4);
                    break;
                }
                if (!bl) continue;
                arrayList.add(string);
                continue block0;
            }
        }
        RelationalBGP.log_static("breakTpatCSRList: " + arrayList, this.ctx.R2RFlags);
    }

    private void prepareForBuildSQL() throws RDFException {
        Set<String> set;
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        this.log("Entered: pfbs");
        this.log("Structures involved here are:");
        this.log("===============================================:");
        this.log("[Use] RRrowSet_for_TriplePattern:         Map => <tp_key, RRrowSet(actually, RRrowidSet)>");
        this.log("[Use] RRrowInfo_for_MatchingRow:          Map => <RRrowid, RRrowInfo(actually, RRTabRowInfo)>");
        this.log("-----");
        this.log("[Pop] TpatInfo_for_TpatKey:               Map => <tp_key, TriplesBlock>");
        this.log("[Pop] LtabExpr_for_Tmap:                  Map => <Tmap, rowsrc>");
        this.log("[Pop] SubjExpr_for_Tmap:                  Map => <Tmap, sTermType+RRrowInfo.sExprType+RRrowInfo.sExpr>");
        this.log("[Pop] Subj_for_TpatCSRGroup:              Map => <SubjTmapSet_key, Subj>");
        this.log("[Pop] TmapSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key, TmapSet (set of Tmaps from matching RR rows)>");
        this.log("[Pop] TpatSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key (CSR key), TpatSet (triple-patterns in this CSR>");
        this.log("===============================================:");
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        List<TriplesBlock> list = this.bgp.TBList;
        if (this.dummyTBList.size() > 0) {
            if (this.bgp.TBList.size() != 0) {
                this.log("EXCEPTION: [expected size=0 b/c dummyTBList.size()=" + this.dummyTBList.size() + "] bgp.TBList.size()=" + this.bgp.TBList.size() + " : " + this.bgp.TBList);
            } else {
                list = this.dummyTBList;
            }
            this.log("prepareForBuildSQL => TBList being used: " + list);
        }
        for (TriplesBlock object72 : list) {
            HashSet<String> hashSet2;
            object6 = object72.getSubject();
            object5 = object72.getPredicate();
            object4 = object72.getObject();
            object3 = this.findTerm_for_Element((TriplesBlock.Element)object6, "subject", true);
            String n = this.findTerm_for_Element((TriplesBlock.Element)object5, "predicate", true);
            object2 = this.findTerm_for_Element((TriplesBlock.Element)object4, "object", true);
            this.log("In pfbs : subject : " + (String)object3);
            this.log("In pfbs : predicate : " + n);
            this.log("In pfbs : object : " + (String)object2);
            string = this.constructKey_for_TriplePattern((TriplesBlock.Element)object6, (TriplesBlock.Element)object5, (TriplesBlock.Element)object4);
            this.log("In pfbs : tp_key : " + string);
            if (this.TpatInfo_for_TpatKey.get(string) == null) {
                this.TpatInfo_for_TpatKey.put(string, object72);
                this.log("added TpatInfo for tp_key=" + string);
            }
            object = object3;
            set = this.RRrowSet_for_TriplePattern.get(string);
            if (this.RRrowSet_for_TriplePattern.get(string) == null) {
                this.log("In pfbs: RRrowSet for this triple-pattern is NULL => setting up to skip tp_key=" + string);
                set = hashSet;
            }
            this.log("RRrowSet: " + set.toString());
            HashSet<String> hashSet3 = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = "#";
            for (String string3 : set) {
                RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(string3);
                if (rRTabRowInfo != null) {
                    hashSet2 = rRTabRowInfo.Tmap;
                    this.log("Tmap: " + (String)((Object)hashSet2));
                    if (hashSet3.add((String)((Object)hashSet2))) {
                        arrayList.add((String)((Object)hashSet2));
                        String string4 = null;
                        if (rRTabRowInfo.tabName != null) {
                            string4 = rRTabRowInfo.tabOwner + "." + rRTabRowInfo.tabName;
                            if (this.ctx.asOfClause != null) {
                                string4 = string4 + this.ctx.asOfClause;
                            }
                        } else if (rRTabRowInfo.sqlQuery != null) {
                            string4 = "(" + rRTabRowInfo.sqlQuery.substring(1, rRTabRowInfo.sqlQuery.length() - 1).replaceAll("\\\\\"", "\"") + ")";
                        } else {
                            throw new RDFException("EXCEPTION: NULL rowsrc in RRrowid=" + string3 + ": RRrowInfo.tabName=" + rRTabRowInfo.tabName + " .sqlQuery=" + rRTabRowInfo.sqlQuery);
                        }
                        this.log("rowsrc=" + string4);
                        this.LtabExpr_for_Tmap.put((String)((Object)hashSet2), string4);
                        String string5 = rRTabRowInfo.sTermType;
                        this.log("sTermType=" + string5);
                        if (string5 == null || string5.equals(rrIRI)) {
                            string5 = "U";
                        } else if (string5.equals(rrBlankNode)) {
                            string5 = "B";
                        } else {
                            throw new RDFException("invalid TermType for subject: sTermType=" + string5);
                        }
                        this.log("RRrowInfo.sExpr=" + rRTabRowInfo.sExpr);
                        this.SubjExpr_for_Tmap.put((String)((Object)hashSet2), string5 + rRTabRowInfo.sExprType + rRTabRowInfo.sExpr);
                        this.sTFT_idx_for_Tmap.put((String)((Object)hashSet2), rRTabRowInfo.sTFT_idx);
                        this.SubjRRrowid_for_Tmap.put((String)((Object)hashSet2), rRTabRowInfo.rowid);
                    } else {
                        this.log("already in TmapSet: " + (String)((Object)hashSet2));
                    }
                    string2 = "+";
                    continue;
                }
                throw new RDFException("RRrowInfo is null for RRrowid=" + string3);
            }
            this.log("TmapSet: " + ((Object)hashSet3).toString());
            this.log("SubjTmapSet_key: " + (String)object);
            this.log("before sorting => TmapList: " + arrayList);
            Collections.sort(arrayList);
            this.log("AFTER  sorting => TmapList: " + arrayList);
            if (!bl) {
                for (String string6 : arrayList) {
                    object = (String)object + string2 + string6;
                    string2 = "+";
                }
                this.log("SubjTmapSet_key=" + (String)object);
            }
            this.log("LtabExpr_for_Tmap: " + this.LtabExpr_for_Tmap);
            this.log("SubjExpr_for_Tmap: " + this.SubjExpr_for_Tmap);
            String string7 = this.Subj_for_TpatCSRGroup.get(object);
            if (string7 != null) {
                this.log("pfbs: SKIP: oldSubj=" + string7 + " current Subj=" + (String)object3);
            } else {
                this.Subj_for_TpatCSRGroup.put((String)object, (String)object3);
            }
            Set<String> set2 = this.TmapSet_for_TpatCSRGroup.get(object);
            if (set2 != null) {
                this.log("pfbs: TmapSet (computed for this triple-pattern) size=" + hashSet3.size() + " : " + hashSet3);
                this.log("pfbs: INTERSECT WITH: oldTmapSet.size()=" + set2.size() + " : " + set2);
                hashSet3.retainAll(set2);
                this.log("pfbs: TmapSet (AFTER INTERSECT with oldTmapSet) size=" + hashSet3.size() + " : " + hashSet3);
                this.TmapSet_for_TpatCSRGroup.put((String)object, hashSet3);
            } else {
                this.TmapSet_for_TpatCSRGroup.put((String)object, hashSet3);
            }
            hashSet2 = this.TpatSet_for_TpatCSRGroup.get(object);
            if (hashSet2 != null) {
                this.log("pfbs: key already exists: " + (String)object + " : add " + string);
                hashSet2.add(string);
            } else {
                hashSet2 = new HashSet<String>();
                hashSet2.add(string);
                this.TpatSet_for_TpatCSRGroup.put((String)object, hashSet2);
            }
            this.log("TpatSet: " + ((Object)hashSet2).toString());
        }
        ArrayList arrayList = new ArrayList();
        this.refineCSRs(arrayList);
        this.log("pfbs: breakTpatCSRList: " + arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object6 = (String)iterator.next();
            this.log("pfbs: breaking up CSR: SubjTmapSet_key=" + (String)object6);
            object4 = this.Subj_for_TpatCSRGroup.get(object6);
            object5 = this.TmapSet_for_TpatCSRGroup.get(object6);
            object3 = this.TpatSet_for_TpatCSRGroup.get(object6);
            int n = 0;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                string = (String)object2.next();
                this.log("Tpat-" + ++n + ": " + string);
                object = n + "-" + (String)object6;
                this.TmapSet_for_TpatCSRGroup.put((String)object, (Set<String>)object5);
                this.Subj_for_TpatCSRGroup.put((String)object, (String)object4);
                set = new HashSet<String>();
                set.add(string);
                this.TpatSet_for_TpatCSRGroup.put((String)object, set);
            }
            this.TpatSet_for_TpatCSRGroup.put((String)object6, null);
            this.TpatSet_for_TpatCSRGroup.remove(object6);
        }
    }

    private String TYPE_FAMILY(String string) {
        if (string.equals("")) {
            return "STRING";
        }
        String string2 = string;
        if (string.charAt(0) == '<' && string.charAt(string.length() - 1) == '>') {
            string2 = string.substring(1, string.length() - 1);
        }
        if (string2.length() <= XSD_PREFIX.length() || !string2.substring(0, XSD_PREFIX.length()).equals(XSD_PREFIX)) {
            if (string2.equals("http://www.opengis.net/ont/geosparql#wktLiteral") || string2.equals("http://www.opengis.net/ont/geosparql#gmlLiteral") || string2.equals("http://xmlns.oracle.com/rdf/geo/GML31Literal")) {
                return "SDO_GEOMETRY";
            }
            if (string2.equals(XSD_DECIMAL_NO_ENCLOSING)) {
                return TYPE_FAM_NUMERIC;
            }
            return TYPE_FAM_OTHER;
        }
        String string3 = string2.substring(XSD_PREFIX.length());
        this.log("xsd_suffix=" + string3);
        String string4 = string3.equals("string") || string3.equals("normalizedString") || string3.equals("token") || string3.equals("language") || string3.equals("Name") || string3.equals("NCName") || string3.equals("NMTOKEN") ? "STRING" : (string3.equals("double") ? TYPE_FAM_DOUBLE : (string3.equals("float") ? TYPE_FAM_FLOAT : (string3.equals("decimal") || string3.equals("integer") || string3.equals("nonPositiveInteger") || string3.equals("negativeInteger") || string3.equals("long") || string3.equals("int") || string3.equals("short") || string3.equals("byte") || string3.equals("nonNegativeInteger") || string3.equals("unsignedLong") || string3.equals("unsignedInt") || string3.equals("unsignedShort") || string3.equals("unsignedByte") || string3.equals("positiveInteger") ? TYPE_FAM_NUMERIC : (string3.equals("date") ? "DATE" : (string3.equals("time") ? TYPE_FAM_TIME : (string3.equals("dateTime") ? TYPE_FAM_DATETIME : (string3.equals("boolean") ? TYPE_FAM_BOOLEAN : (string3.equals("hexBinary") ? TYPE_FAM_RAW : TYPE_FAM_OTHER))))))));
        return string4;
    }

    private void findComponents_of_RDFterm(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, StringBuffer stringBuffer4) throws RDFException {
        int n = string.length();
        char c = string.charAt(0);
        char c2 = string.charAt(n - 1);
        int n2 = string.lastIndexOf("\"^^<");
        int n3 = string.lastIndexOf("\"@");
        if (c == '<' && c2 == '>') {
            stringBuffer.append(string.substring(1, n - 1));
            stringBuffer2.append("UR");
        } else if (c == '\"' && c2 == '\"') {
            stringBuffer.append(string.substring(1, n - 1));
            stringBuffer2.append("PL");
        } else if (c == '\"' && c2 == '>' && n2 > 0) {
            stringBuffer.append(string.substring(1, n2));
            stringBuffer2.append("TL");
            stringBuffer3.append(string.substring(n2 + 4, n - 1));
        } else if (c == '\"' && n3 > 0) {
            stringBuffer.append(string.substring(1, n3));
            stringBuffer2.append("PL@");
            stringBuffer4.append(string.substring(n3 + 2));
        } else {
            this.log("EXCEPTION: unrecognized syntax for RDFterm: " + string);
            throw new RDFException("EXCEPTION: unrecognized syntax for RDFterm: " + string);
        }
    }

    private void findComponents_of_RDFterm_simple(String string, String[] stringArray) throws RDFException {
        int n = string.length();
        char c = string.charAt(0);
        char c2 = string.charAt(n - 1);
        int n2 = string.lastIndexOf("\"^^<");
        int n3 = string.lastIndexOf("\"@");
        if (c == '<' && c2 == '>') {
            stringArray[0] = string.substring(1, n - 1);
            stringArray[1] = "UR";
        } else if (c == '\"' && c2 == '\"') {
            stringArray[0] = string.substring(1, n - 1);
            stringArray[1] = "PL";
            stringArray[2] = XSD_STRING_NO_ENCLOSING;
        } else if (c == '\"' && c2 == '>' && n2 > 0) {
            stringArray[0] = string.substring(1, n2);
            stringArray[1] = "TL";
            stringArray[2] = string.substring(n2 + 4, n - 1);
        } else if (c == '\"' && n3 > 0) {
            stringArray[0] = string.substring(1, n3);
            stringArray[1] = "PL@";
            stringArray[3] = string.substring(n3 + 2);
        } else if (c == '_' && string.charAt(1) == ':') {
            stringArray[0] = string;
            stringArray[1] = "BN";
        } else {
            this.log("EXCEPTION: unrecognized syntax for RDFterm: " + string);
            throw new RDFException("EXCEPTION: unrecognized syntax for RDFterm: " + string);
        }
    }

    private void multiplyUnionArrays(int n, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2, ArrayList<ArrayList<String>> arrayList3, int n2, int n3, ArrayList<String> arrayList4, ArrayList<String> arrayList5, ArrayList<String> arrayList6, String string, boolean bl, ArrayList<String> arrayList7, ArrayList<HashSet<String>> arrayList8, ArrayList<HashMap<String, String>> arrayList9, HashMap<String, ArrayList<Set<String>>> hashMap, NatVarOpt_Info natVarOpt_Info, int n4, ArrayList<UArowNatSelectInfo> arrayList10) {
        int n5;
        ArrayList<Object> arrayList11;
        int n6;
        this.log("mUA: Entering: po_idx=" + n + " multiply_writePos=" + n3 + " UAstartPos=" + n4);
        for (n6 = 0; n6 < n; ++n6) {
            ArrayList<String> object2 = arrayList.get(n6);
            arrayList11 = arrayList2.get(n6);
            ArrayList<String> arrayList12 = arrayList3.get(n6);
            if (object2.size() > 0) {
                this.log("  BEFORE COPY: prev_pExprArray.size()=" + object2.size() + " : \n  " + object2);
            }
            this.log("  BEFORE COPY: prev_oExprArray.size()=" + arrayList11.size() + " : \n  " + arrayList11);
            this.log("  BEFORE COPY: prev_clobExprArray.size()=" + arrayList12.size() + " : \n  " + arrayList12);
            for (int i = 0; i < n2; ++i) {
                if (object2.size() > 0) {
                    object2.add(object2.get(n4 + i));
                }
                arrayList11.add(arrayList11.get(n4 + i));
                arrayList12.add(arrayList12.get(n4 + i));
            }
            if (object2.size() > 0) {
                this.log("  AFTER  COPY: prev_pExprArray.size()=" + object2.size() + " : \n  " + object2);
            }
            this.log("  AFTER  COPY: prev_oExprArray.size()=" + arrayList11.size() + " : \n  " + arrayList11);
            this.log("  AFTER  COPY: prev_clobExprArray.size()=" + arrayList12.size() + " : \n  " + arrayList12);
            this.log("  prev_po_idx=" + n6 + ": copied first " + n2 + " rows, starting from UAstartPos=" + n4 + ", into pos starting from " + n4 + "+" + n3);
        }
        if (this.graph_use_mode > 0) {
            if (this.is_bgp_graph_a_var) {
                this.log("  BEFORE COPY: gExprArray.size()=" + arrayList7.size() + " : \n  " + arrayList7);
                for (n6 = 0; n6 < n2; ++n6) {
                    arrayList7.add(arrayList7.get(n4 + n6));
                }
                this.log("  AFTER  COPY: gExprArray.size()=" + arrayList7.size() + " : \n  " + arrayList7);
            }
            this.log("  BEFORE COPY: GeesArray.size()=" + arrayList8.size() + " : \n  " + arrayList8);
            for (n6 = 0; n6 < n2; ++n6) {
                HashSet hashSet = new HashSet(arrayList8.get(n4 + n6));
                arrayList8.add(hashSet);
            }
            this.log("  AFTER  COPY: GeesArray.size()=" + arrayList8.size() + " : \n  " + arrayList8);
            this.log("  BEFORE COPY: TpGEArray.size()=" + arrayList9.size() + " : \n  " + arrayList9);
            for (n6 = 0; n6 < n2; ++n6) {
                HashMap hashMap2 = new HashMap(arrayList9.get(n4 + n6));
                arrayList9.add(hashMap2);
            }
            this.log("  AFTER  COPY: TpGEArray.size()=" + arrayList9.size() + " : \n  " + arrayList9);
        }
        for (String string2 : hashMap.keySet()) {
            arrayList11 = hashMap.get(string2);
            this.log("  BEFORE COPY: [var=" + string2 + "] native_oExprSetArray.size()=" + arrayList11.size() + " : \n  " + arrayList11);
            for (int i = 0; i < n2; ++i) {
                HashSet hashSet = new HashSet((Collection)arrayList11.get(n4 + i));
                arrayList11.add(hashSet);
                this.log("UAstartPos=" + n4 + "[multiply_writePos+row_idx=" + n3 + "+" + i + "] [var=" + string2 + "] : added to native_oExprSetArray replicated content of native_oExprSet [" + n4 + "+" + i + "] [var=" + string2 + "] :" + hashSet);
            }
            this.log("  AFTER  COPY: [var=" + string2 + "] native_oExprSetArray.size()=" + arrayList11.size() + " : \n  " + arrayList11);
        }
        this.log("  BEFORE COPY: RRrLArray.size()=" + arrayList4.size() + " : \n  " + arrayList4);
        for (n5 = 0; n5 < n2; ++n5) {
            arrayList4.add(arrayList4.get(n4 + n5));
        }
        this.log("  AFTER  COPY: RRrLArray.size()=" + arrayList4.size() + " : \n  " + arrayList4);
        this.log("  rowBlock_size=" + n2 + " : UAstartPos=" + n4);
        this.log("  BEFORE COPY: UArowNatSelectInfoArray.size()=" + arrayList10.size() + " : \n  " + arrayList10);
        this.log("===> UArowNatSelectInfoArray=");
        for (n5 = 0; n5 < arrayList10.size(); ++n5) {
            this.log("[" + n5 + "]: " + arrayList10.get(n5));
        }
        for (n5 = 0; n5 < n2; ++n5) {
            UArowNatSelectInfo uArowNatSelectInfo = new UArowNatSelectInfo(arrayList10.get(n4 + n5));
            arrayList10.add(uArowNatSelectInfo);
        }
        this.log("  AFTER  COPY: UArowNatSelectInfoArray.size()=" + arrayList10.size() + " : \n  " + arrayList10);
        this.log("===> UArowNatSelectInfoArray=");
        for (n5 = 0; n5 < arrayList10.size(); ++n5) {
            this.log("[" + n5 + "]: " + arrayList10.get(n5));
        }
        this.log("  BEFORE COPY: fromArray.size()=" + arrayList5.size() + " : \n  " + arrayList5);
        for (n5 = 0; n5 < n2; ++n5) {
            arrayList5.add(arrayList5.get(n4 + n5));
        }
        this.log("  AFTER  COPY: fromArray.size()=" + arrayList5.size() + " : \n  " + arrayList5);
        this.log("  BEFORE COPY: condArray.size()=" + arrayList6.size() + " : \n  " + arrayList6);
        for (n5 = 0; n5 < n2; ++n5) {
            arrayList6.add(arrayList6.get(n4 + n5));
        }
        this.log("  AFTER  COPY: condArray.size()=" + arrayList6.size() + " : \n  " + arrayList6);
    }

    private String getExprFromArrays(String string, int n, String string2, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2, ArrayList<String> arrayList3, ArrayList<HashMap<String, String>> arrayList4) {
        String string3 = null;
        String string4 = string.substring(0, string.indexOf(58));
        int n2 = Integer.parseInt(string.substring(string.indexOf(58) + 1, string.length()));
        this.log("orig_pos_in_tp: " + string4 + " : orig_po_idx=" + n2);
        if (string4.equals("graph")) {
            if (arrayList4 == null) {
                string3 = arrayList3.get(n);
            } else {
                HashMap<String, String> hashMap = arrayList4.get(n);
                for (String string5 : hashMap.keySet()) {
                    String string6 = hashMap.get(string5);
                    if ((string6 + "+").indexOf("+" + n2 + "+") == -1) continue;
                    string3 = string5;
                    this.log("picked gExpr=" + string5 + " from TpGE: " + hashMap);
                }
            }
        } else if (string4.equals("subject")) {
            string3 = string2;
        } else if (string4.equals("predicate")) {
            ArrayList<String> arrayList5 = arrayList.get(n2);
            this.log("orig_pExprArray.size()=" + arrayList5.size() + " : " + arrayList5);
            string3 = arrayList5.get(n);
        } else if (string4.equals("object")) {
            ArrayList<String> arrayList6 = arrayList2.get(n2);
            this.log("orig_oExprArray.size()=" + arrayList6.size() + " : " + arrayList6);
            string3 = arrayList6.get(n);
        } else {
            this.log("getExprFromArrays: Exception: unknown orig_pos_in_tp=" + string4);
        }
        this.log("getExprFromArrays: returning: " + string3);
        return string3;
    }

    private String genLikeFilterCond_new(RelExpr relExpr, String string, String string2, String string3, RRTabRowInfo rRTabRowInfo, int n, String string4, String string5) throws RDFException {
        int n2;
        String string6 = "";
        this.log("genLikeFilterCond_new: INPUT: pattern=" + string3 + " RRrowid=" + rRTabRowInfo.rowid + " | comp_idx=" + n + " | alias=" + string5 + " | sqlExpr=" + string4);
        String string7 = rRTabRowInfo.termTypes.get(n);
        Integer n3 = rRTabRowInfo.exprTypes.get(n);
        ArrayList<String> arrayList = rRTabRowInfo.strLists.get(n);
        ArrayList<String> arrayList2 = rRTabRowInfo.colLists.get(n);
        ArrayList<String> arrayList3 = rRTabRowInfo.colTypeLists.get(n);
        this.log("genLikeFilterCond_new: map_exprType=" + n3 + " | map_termType=" + string7);
        int n4 = -1;
        boolean bl = true;
        if (string3.indexOf(95) == -1) {
            n2 = string3.indexOf(37);
            int n5 = -1;
            if (n2 != -1) {
                n5 = string3.indexOf(37, n2 + 1);
            }
            this.log("first_pct_pos=" + n2 + " second_pct_pos=" + n5 + " pattern.length()=" + string3.length());
            if (n2 == -1) {
                n4 = 0;
            } else if (n2 == 0 && n5 == -1) {
                n4 = 1;
            } else if (n2 == string3.length() - 1) {
                n4 = 2;
            } else if (n2 == 0 && n5 == string3.length() - 1) {
                n4 = 3;
            } else {
                bl = false;
                this.log("LIKE filter optimization: could not optimize b/c pattern has wildcard (%) not just at left and/or right ends");
            }
        } else {
            bl = false;
            this.log("LIKE filter optimization: could not optimize b/c pattern contains underscore (_)");
        }
        this.log("optimizable=" + bl + " pattern_type=" + n4);
        if (bl) {
            if (n3 == RRTabRowInfo.MapExprType_CONSTANT) {
                n2 = 0;
                String string8 = arrayList.get(0);
                String string9 = null;
                if (string7.equals(rrIRI)) {
                    string9 = "<" + string8 + ">";
                } else if (string7.equals(rrBlankNode)) {
                    string9 = "_:" + string8;
                } else if (string7.equals(rrLiteral)) {
                    string9 = "\"" + string8 + "\"";
                    if (!rRTabRowInfo.oDataType.equals(XSD_STRING)) {
                        string9 = string9 + "^^" + rRTabRowInfo.oDataType;
                    }
                } else {
                    throw new RDFException("unknown map_termType=" + string7);
                }
                this.log("map_rdfterm=" + string9);
                String string10 = string9;
                if (n4 == 0) {
                    if (string10.equals(string3)) {
                        n2 = 1;
                    }
                } else if (n4 == 1) {
                    int n6 = string10.lastIndexOf(string3.substring(1));
                    if (n6 != -1 && n6 == string10.length() - (string3.length() - 1)) {
                        n2 = 1;
                    }
                } else if (n4 == 2) {
                    if (string10.indexOf(string3.substring(0, string3.length() - 1)) == 0) {
                        n2 = 1;
                    }
                } else if (n4 == 3) {
                    this.log("pattern is %str% case");
                    if (string10.indexOf(string3.substring(1, string3.length() - 1)) != -1) {
                        n2 = 1;
                    }
                } else {
                    throw new RDFException("constant-valued case: pattern_type=" + n4);
                }
                string6 = string6 + this.gen_e_z_filter_cond(relExpr, n2 != 0, false);
                this.log("optimized LIKE or NOT LIKE condition: [" + string6 + "]");
                return string6;
            }
            if (n3 == RRTabRowInfo.MapExprType_TEMPLATE) {
                this.log("template map: optimization not implemented");
                bl = false;
            } else if (n3 == RRTabRowInfo.MapExprType_COLUMN) {
                this.log("column map: optimization not implemented");
                bl = false;
            } else {
                throw new RDFException("unknown map_exprType=" + n3);
            }
        }
        this.log("generating unoptimized LIKE condition");
        string6 = string6 + COND_CONNECTOR + string4 + BASE_PREFIX_COLNAME_SEP + string2 + BASE_PREFIX_COLNAME_SEP + "'" + string3 + "'";
        return string6;
    }

    private static String const_for_native_comparison(String string) {
        String string2 = "'" + (string.indexOf("'") >= 0 ? string.replace("'", "''") : string) + "'";
        String string3 = string.indexOf("%") >= 0 ? URL_UNESCAPE_BEG + string2 + ")" : string2;
        String string4 = string.indexOf(delim) >= 0 ? TTL_UNESCAPE_BEG + string3 + ")" : string3;
        return string4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String genFilterCond_new(RelExpr relExpr, RRTabRowInfo rRTabRowInfo, int n, String string, String string2) throws RDFException {
        boolean bl;
        String string3;
        ArrayList<String> arrayList;
        String string4;
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3;
        block146: {
            boolean bl2;
            String string5;
            ArrayList<String> arrayList4;
            block145: {
                String string6;
                String string7;
                String string8;
                block154: {
                    String string9;
                    String string10;
                    String string11;
                    String string12;
                    ArrayList<String> arrayList5;
                    block157: {
                        block149: {
                            double d;
                            double d2;
                            block158: {
                                String string13;
                                ASTTripleAtom aSTTripleAtom;
                                block155: {
                                    block148: {
                                        block156: {
                                            block151: {
                                                String string14;
                                                block147: {
                                                    String string15;
                                                    String string16;
                                                    String string17;
                                                    String string18;
                                                    String string19;
                                                    String string20;
                                                    String string21;
                                                    block153: {
                                                        block152: {
                                                            this.log("genFilterCond_new: INPUT: RRrowid=" + rRTabRowInfo.rowid + " | comp_idx=" + n + " | alias=" + string2 + " | sqlExpr=" + string);
                                                            this.log("RRrowInfo for var-matching RRrow:" + rRTabRowInfo.toString());
                                                            if (relExpr.RelExprFlags == 2L) {
                                                                this.log("genFilterCond_new: GEOMETRY filters not processed here");
                                                                return "";
                                                            }
                                                            String string22 = rRTabRowInfo.termTypes.get(n);
                                                            Integer n2 = rRTabRowInfo.exprTypes.get(n);
                                                            arrayList5 = rRTabRowInfo.strLists.get(n);
                                                            arrayList3 = rRTabRowInfo.colLists.get(n);
                                                            arrayList2 = rRTabRowInfo.colTypeLists.get(n);
                                                            this.log("genFilterCond_new: map_exprType=" + n2 + " | map_termType=" + string22);
                                                            string4 = "";
                                                            string8 = relExpr.compOperator;
                                                            string12 = relExpr.compOperator;
                                                            if (relExpr.compOperator.equals("SAMETERM")) {
                                                                string12 = "=";
                                                            } else if (relExpr.compOperator.equals("DIFFTERM")) {
                                                                string12 = "!=";
                                                            }
                                                            int n3 = relExpr.L_atom.type;
                                                            int n4 = relExpr.R_atom.type;
                                                            ASTTripleAtom aSTTripleAtom2 = null;
                                                            aSTTripleAtom = null;
                                                            if (n3 == 0 && n4 != 0) {
                                                                aSTTripleAtom2 = relExpr.L_atom;
                                                                aSTTripleAtom = relExpr.R_atom;
                                                            } else if (n4 == 0 && n3 != 0) {
                                                                relExpr.InvertRelExpr();
                                                                aSTTripleAtom2 = relExpr.L_atom;
                                                                aSTTripleAtom = relExpr.R_atom;
                                                            } else {
                                                                this.log("skipping FILTER opt for this relExpr b/c it is NOT of the form: v <compOp> rdfterm, or vice-versa");
                                                                return string4;
                                                            }
                                                            if (relExpr.compOperator.equals("LIKE") || relExpr.compOperator.equals("NOT LIKE")) {
                                                                string4 = string4 + this.genLikeFilterCond_new(relExpr, aSTTripleAtom2.name, relExpr.compOperator, aSTTripleAtom.name, rRTabRowInfo, n, string, string2);
                                                                this.log("genFilterCond [LIKE filter]: " + string4);
                                                                return string4;
                                                            }
                                                            if (string22.equals(rrIRI) && aSTTripleAtom.type != 1 || string22.equals(rrBlankNode) && aSTTripleAtom.type != 10 || string22.equals(rrLiteral) && !aSTTripleAtom.literalHasType() && aSTTripleAtom.type != 3) {
                                                                this.log("termType mismatch in single-var filter");
                                                                if (!string8.equals("!=") && !string8.equals("DIFFTERM")) {
                                                                    this.log("termType mismatch: compOperator=" + string8 + ": returning COND_FALSE ");
                                                                    return " AND 1=0 ";
                                                                }
                                                                this.log("termType mismatch: compOperator=" + string8 + ": returning COND_TRUE ");
                                                                return COND_TRUE;
                                                            }
                                                            this.log("term_atom.type=" + aSTTripleAtom.type);
                                                            if (aSTTripleAtom.type == 1) {
                                                                if (!(string8.equals("=") || string8.equals("SAMETERM") || string8.equals("!=") || string8.equals("DIFFTERM"))) {
                                                                    throw new RDFException("Comparison of incompatible types in SPARQL filter expression: IRIs can only be checked for =, sameTerm, !=");
                                                                }
                                                                if (n2 == RRTabRowInfo.MapExprType_CONSTANT) {
                                                                    this.log("CASE: URI-[URI+Constant]");
                                                                    if (arrayList5.get(0).equals(aSTTripleAtom.name)) {
                                                                        if (string8.equals("=")) return string4 + COND_TRUE;
                                                                        if (string8.equals("SAMETERM")) return string4 + COND_TRUE;
                                                                        return string4 + " AND 1=0 ";
                                                                    }
                                                                    if (string8.equals("=")) return string4 + " AND 1=0 ";
                                                                    if (string8.equals("SAMETERM")) return string4 + " AND 1=0 ";
                                                                    return string4 + COND_TRUE;
                                                                }
                                                                if (n2 == RRTabRowInfo.MapExprType_COLUMN) {
                                                                    this.log("CASE: URI-[URI+Column]");
                                                                    if (arrayList2.get(0).equals("STRING")) {
                                                                        String string23 = string8.equals("=") || string8.equals("SAMETERM") ? "=" : "!=";
                                                                        return COND_CONNECTOR + string4 + string2 + "." + arrayList3.get(0) + BASE_PREFIX_COLNAME_SEP + string23 + " '" + aSTTripleAtom.name.replace("'", "''") + "' ";
                                                                    }
                                                                    if (string8.equals("=")) return string4 + " AND 1=0 ";
                                                                    if (string8.equals("SAMETERM")) return string4 + " AND 1=0 ";
                                                                    return string4 + COND_TRUE;
                                                                }
                                                                if (n2 == RRTabRowInfo.MapExprType_TEMPLATE) {
                                                                    this.log("CASE: URI-[URI+Template]");
                                                                    arrayList4 = new ArrayList<String>();
                                                                    boolean bl3 = RelationalBGP.matchableSqlTemplateAndConstant_genCondInfo(arrayList5, arrayList3, arrayList2, aSTTripleAtom.name, arrayList4, this.ctx);
                                                                    if (bl3) {
                                                                        if (arrayList4.size() != arrayList3.size()) {
                                                                            return string4 + COND_CONNECTOR + string + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "'<" + aSTTripleAtom.name.replace("'", "''") + ">'";
                                                                        }
                                                                        string4 = "";
                                                                        string5 = "";
                                                                        bl2 = !string8.equals("=") && !string8.equals("SAMETERM");
                                                                        break block145;
                                                                    } else {
                                                                        if (string8.equals("=")) return string4 + " AND 1=0 ";
                                                                        if (string8.equals("SAMETERM")) return string4 + " AND 1=0 ";
                                                                        return string4 + COND_TRUE;
                                                                    }
                                                                }
                                                            }
                                                            if (!aSTTripleAtom.literalHasType() && aSTTripleAtom.type != 3) {
                                                                this.log("skipping FILTER opt for this relExpr b/c it is NOT of the form: v <compOp> <numeric/plain/typed literal>, or vice-versa");
                                                                return string4;
                                                            }
                                                            if (n != 2) {
                                                                this.log("skipping FILTER opt for this relExpr b/c comp_idx is NOT in the object position");
                                                                return string4;
                                                            }
                                                            if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_TEMPLATE) {
                                                                this.log("CASE: Literal-[Literal+Template]");
                                                                String string24 = rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1);
                                                                String string25 = this.TYPE_FAMILY(rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1));
                                                                this.log("objType=" + string24 + " objTypeFam=" + string25);
                                                                String string26 = aSTTripleAtom.name;
                                                                String string27 = aSTTripleAtom.litType;
                                                                this.log("TERM_ATOM.TYPE (value_type)=" + aSTTripleAtom.type);
                                                                String string28 = aSTTripleAtom.type == 3 ? "STRING" : this.TYPE_FAMILY(string27);
                                                                this.log("litType=" + string27 + " | litTypeFam=" + string28 + " | oDataType=" + rRTabRowInfo.oDataType);
                                                                this.log("litTypeFam=" + string28 + " | objTypeFam=" + string25);
                                                                if (!string28.equals(string25) || string28.equals(TYPE_FAM_OTHER) && !string27.equals(string24)) {
                                                                    this.log("CASE: different type families: litTypeFam=" + string28 + " objTypeFam=" + string25 + " compOp=" + string8);
                                                                    if (string28.equals(TYPE_FAM_OTHER) || string25.equals(TYPE_FAM_OTHER)) {
                                                                        string4 = relExpr.compOperator.equals("DIFFTERM") ? COND_TRUE : " AND 1=0 ";
                                                                        this.log("at least one of the types is unknown (OTHER): " + string4);
                                                                        return string4;
                                                                    }
                                                                    if (!string8.equals("!=") && !string8.equals("DIFFTERM")) {
                                                                        string4 = " AND 1=0 ";
                                                                        this.log("genFilterCond: " + string4);
                                                                        return string4;
                                                                    }
                                                                    this.log("CASE: !=, !sameTerm : 1=1");
                                                                    return COND_TRUE;
                                                                }
                                                                if (string27 != null && string27.equals(XSD_STRING_NO_ENCLOSING) && (string8.equals("SAMETERM") || string8.equals("DIFFTERM"))) {
                                                                    if (!string8.equals("SAMETERM")) return COND_TRUE;
                                                                    return " AND 1=0 ";
                                                                }
                                                                if (string28.equals(TYPE_FAM_OTHER) && !string8.equals("=") && !string8.equals("SAMETERM")) {
                                                                    return " AND 1=0 ";
                                                                }
                                                                if (!(string8.equals("=") || string8.equals("!=") || string8.equals("SAMETERM") || string8.equals("DIFFTERM"))) {
                                                                    this.log("ieq case: compOperator: " + string8);
                                                                    return string4 + COND_CONNECTOR + SDO_RDF_VNAME_BEG + string + ")" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + "'\"" + aSTTripleAtom.name + "\"" + (string28.equals(TYPE_FAM_OTHER) ? "^^<" + string27 + ">" : "") + "'" + ")";
                                                                }
                                                                Object var23_40 = null;
                                                                arrayList = new ArrayList<String>();
                                                                boolean bl4 = RelationalBGP.matchableSqlTemplateAndConstant_genCondInfo(arrayList5, arrayList3, arrayList2, aSTTripleAtom.name, arrayList, this.ctx);
                                                                if (bl4) {
                                                                    if (arrayList.size() == arrayList3.size() && (string8.equals("=") || string8.equals("!="))) {
                                                                        string3 = "";
                                                                        bl = !string8.equals("=");
                                                                        break block146;
                                                                    } else {
                                                                        return string4 + COND_CONNECTOR + SDO_RDF_VNAME_BEG + string + ")" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + "'\"" + aSTTripleAtom.name + "\"" + (string28.equals(TYPE_FAM_OTHER) ? "^^<" + string27 + ">" : "") + "'" + ")";
                                                                    }
                                                                }
                                                                if (string8.equals("=")) return string4 + " AND 1=0 ";
                                                                if (string8.equals("SAMETERM")) {
                                                                    return string4 + " AND 1=0 ";
                                                                }
                                                                if (string8.equals("!=")) return string4 + COND_TRUE;
                                                                if (string8.equals("DIFFTERM")) {
                                                                    return string4 + COND_TRUE;
                                                                }
                                                                this.log("SHOULD NOT REACH HERE (redundant code): ieq case: compOperator: " + string8);
                                                                return string4 + COND_CONNECTOR + SDO_RDF_VNAME_BEG + string + ")" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + "'\"" + aSTTripleAtom.name + "\"" + (string28.equals(TYPE_FAM_OTHER) ? "^^<" + string27 + ">" : "") + "'" + ")";
                                                            }
                                                            if (rRTabRowInfo.oExprType != RRTabRowInfo.MapExprType_COLUMN) break block151;
                                                            this.log("CASE: Literal-[Literal+Column]");
                                                            string21 = rRTabRowInfo.oExpr;
                                                            String string29 = string21.charAt(0) == '\"' ? string21.substring(1, string21.length() - 1) : string21;
                                                            this.log("LtcRow: key=" + rRTabRowInfo.Tmap + "+" + string29);
                                                            string20 = this.LtcRowInfo_for_Tmap_plus_Col.get((Object)new StringBuilder().append((String)rRTabRowInfo.Tmap).append((String)"+").append((String)string29).toString()).colTypeName;
                                                            string19 = rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1);
                                                            string18 = this.TYPE_FAMILY(rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1));
                                                            this.log("objType=" + string19 + " objTypeFam=" + string18);
                                                            string17 = aSTTripleAtom.name.replace("'", "''");
                                                            string16 = aSTTripleAtom.litType;
                                                            this.log("TERM_ATOM.TYPE (value_type)=" + aSTTripleAtom.type);
                                                            string15 = aSTTripleAtom.type == 3 ? "STRING" : this.TYPE_FAMILY(string16);
                                                            string14 = null;
                                                            this.log("litType=" + string16 + " | litTypeFam=" + string15 + " | colTypeName=" + string20 + " | oDataType=" + rRTabRowInfo.oDataType);
                                                            this.log("litTypeFam=" + string15 + " | colTypeName=" + string20 + " | objTypeFam=" + string18);
                                                            if (!string15.equals("STRING") || !string15.equals(string18) || !string20.equals("STRING")) break block152;
                                                            this.log("CASE: equal type families, STRING-STRING");
                                                            if (aSTTripleAtom.type == 3) {
                                                                string14 = COND_CONNECTOR + string2 + "." + string21 + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + TTL_UNESCAPE_BEG + "'" + string17 + "'" + ")";
                                                                break block147;
                                                            } else {
                                                                if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                                                                    this.log("CASE: term (not value) comparison: " + relExpr.compOperator);
                                                                    return string4 + (relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE);
                                                                }
                                                                string14 = COND_CONNECTOR + string2 + "." + string21 + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + TTL_UNESCAPE_BEG + "'" + string17 + "'" + ")";
                                                            }
                                                            break block147;
                                                        }
                                                        if (string15.equals("STRING") && string15.equals(string18) && string20.equals(LTC_TYPE_STRING_CLOB)) {
                                                            this.log("CASE: equal type families, STRING_CLOB(var)-STRING(literal)");
                                                            if (aSTTripleAtom.type == 3 || !relExpr.compOperator.equals("SAMETERM") && !relExpr.compOperator.equals("DIFFTERM")) {
                                                                string14 = " AND dbms_lob.compare(" + string2 + "." + string21 + ", " + TTL_UNESCAPE_BEG + "'" + string17 + "'" + ")" + ")";
                                                                string14 = string14 + sqlcompOper_clobCompare_map.get(string12);
                                                                break block147;
                                                            } else {
                                                                this.log("CASE: term (not value) comparison: " + relExpr.compOperator);
                                                                return string4 + (relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE);
                                                            }
                                                        }
                                                        if (!string15.equals(TYPE_FAM_NUMERIC) && !string15.equals(TYPE_FAM_FLOAT) && !string15.equals(TYPE_FAM_DOUBLE) || !string18.equals(TYPE_FAM_NUMERIC) && !string18.equals(TYPE_FAM_FLOAT) && !string18.equals(TYPE_FAM_DOUBLE) || !string20.equals(LTC_TYPE_NUMBER) && !string20.equals(LTC_TYPE_BFLOAT) && !string20.equals(LTC_TYPE_BDOUBLE)) break block153;
                                                        this.log("CASE: equal-or-compatible type families, NUMERIC/FLOAT/DOUBLE(NFD)-NUMBER/BFLOAT/BDOUBLE(NbFbD)");
                                                        if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                                                            if (!string16.equals(string19)) {
                                                                string14 = relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE;
                                                                break block147;
                                                            } else {
                                                                String string30 = string2 + "." + string21;
                                                                if (!string20.equals(LTC_TYPE_NUMBER) || !string18.equals(TYPE_FAM_NUMERIC)) {
                                                                    string30 = "to_number(" + string30 + ")";
                                                                }
                                                                string14 = " AND sdo_rdf.vname(sdo_rdf.get_canon_val('\"' || " + string30 + " || '\"^^<" + string19 + ">')" + ")" + BASE_PREFIX_COLNAME_SEP + string12 + SDO_RDF_VNAME_BEG + BASE_PREFIX_COLNAME_SEP + "'\"" + string17 + "\"^^<" + string16 + ">'" + ")";
                                                            }
                                                            break block147;
                                                        } else if (string20.equals(LTC_TYPE_NUMBER) && string18.equals(TYPE_FAM_NUMERIC)) {
                                                            String string31 = !string15.equals(TYPE_FAM_NUMERIC) ? "to_number(" + string17 + ")" : string17;
                                                            string14 = COND_CONNECTOR + string2 + "." + string21 + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + string31;
                                                            break block147;
                                                        } else {
                                                            String string32 = null;
                                                            String string33 = string17;
                                                            if (string18.equals(TYPE_FAM_NUMERIC)) {
                                                                string32 = "to_char(" + string2 + "." + string21 + ")";
                                                            } else if (string18.equals(TYPE_FAM_FLOAT)) {
                                                                string32 = !string20.equals(LTC_TYPE_BFLOAT) ? "to_binary_float(to_char(" + string2 + "." + string21 + "))" : string2 + "." + string21;
                                                            } else if (string18.equals(TYPE_FAM_DOUBLE)) {
                                                                string32 = !string20.equals(LTC_TYPE_BDOUBLE) ? "to_binary_double(to_char(" + string2 + "." + string21 + "))" : string2 + "." + string21;
                                                            }
                                                            string14 = " AND to_number(" + string32 + ")" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_number(" + string33 + ")";
                                                        }
                                                        break block147;
                                                    }
                                                    if (string15.equals("DATE") && string18.equals("DATE") && string20.equals("DATE")) {
                                                        this.log("CASE: equal type families, DATE-DATE");
                                                        boolean bl5 = false;
                                                        if (RelationalBGP.tzone(string17) != null) {
                                                            bl5 = true;
                                                        }
                                                        if (bl5) {
                                                            String string34 = "to_timestamp_tz(ltrim(to_char(" + string2 + "." + string21 + ",'" + FORMAT_DATE + "')) || 'Z'" + ",'" + FORMAT_DATE_TZ + "')";
                                                            String string35 = "to_timestamp_tz('" + string17 + "','" + FORMAT_DATE_TZ + "')";
                                                            string14 = " AND (" + string34 + " - INTERVAL '14' HOUR" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + string35 + COND_CONNECTOR + string34 + TZ_UPPER_INTERVAL + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + string35 + ")";
                                                        } else {
                                                            string14 = COND_CONNECTOR + string2 + "." + string21 + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_date('" + string17 + "','" + FORMAT_DATE + "')";
                                                        }
                                                    } else if (string15.equals(TYPE_FAM_DATETIME) && string18.equals(TYPE_FAM_DATETIME) && string20.indexOf(LTC_TYPE_TIMESTAMP) == 0) {
                                                        this.log("CASE: equal type families, DATETIME-TIMESTAMP");
                                                        boolean bl6 = false;
                                                        boolean bl7 = false;
                                                        if (RelationalBGP.tzone(string17) != null) {
                                                            bl6 = true;
                                                        }
                                                        if (string20.equals(LTC_TYPE_TIMESTAMP_TZ) || string20.equals(LTC_TYPE_TIMESTAMP_LTZ)) {
                                                            bl7 = true;
                                                        }
                                                        if (bl6) {
                                                            if (bl7) {
                                                                string14 = COND_CONNECTOR + string2 + "." + string21 + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string17 + "','" + FORMAT_TIMESTAMP_TZ + "')";
                                                            } else {
                                                                this.log("term_has_timezone=" + bl6 + " col_has_timezone=" + bl7);
                                                                string14 = " AND (to_timestamp_tz(to_char(" + string2 + "." + string21 + ",'" + FORMAT_TIMESTAMP + "') || '" + TZ_LOWER + "','" + FORMAT_TIMESTAMP_TZ + "')" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string17 + "','" + FORMAT_TIMESTAMP_TZ + "')" + COND_CONNECTOR + "to_timestamp_tz(to_char(" + string2 + "." + string21 + ",'" + FORMAT_TIMESTAMP + "') || '" + TZ_UPPER + "','" + FORMAT_TIMESTAMP_TZ + "')" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string17 + "','" + FORMAT_TIMESTAMP_TZ + "')" + ")";
                                                            }
                                                            this.log("term has time zone: condExpr=" + string14);
                                                        } else {
                                                            if (bl7) {
                                                                this.log("term_has_timezone=" + bl6 + " col_has_timezone=" + bl7);
                                                                string14 = " AND (" + string2 + "." + string21 + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string17 + TZ_LOWER + "','" + FORMAT_TIMESTAMP_TZ + "')" + COND_CONNECTOR + string2 + "." + string21 + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string17 + TZ_UPPER + "','" + FORMAT_TIMESTAMP_TZ + "')" + ")";
                                                            } else {
                                                                string14 = COND_CONNECTOR + string2 + "." + string21 + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp('" + string17 + "','" + FORMAT_TIMESTAMP + "')";
                                                            }
                                                            this.log("term does NOT have time zone: condExpr=" + string14);
                                                        }
                                                    } else if (string20.equals(LTC_TYPE_STRING_CLOB)) {
                                                        this.log("CASE: non-STRING CLOB case (only OTHER types allowed): colTypeName=" + string20 + " objTypeFam=" + string18 + " litType=" + string16 + " litTypeFam=" + string15);
                                                        if (string15.equals(TYPE_FAM_OTHER) || string18.equals(TYPE_FAM_OTHER)) {
                                                            if (!string16.equals(string19)) {
                                                                this.log("CASE: CLOB: mismatched types with TYPE_FAM_OTHER (return COND_FALSE): litType=" + string16 + " | objType=" + string19);
                                                                return string4 + " AND 1=0 ";
                                                            }
                                                            this.log("-: non-STRING CLOB case: objType=" + string18 + " litType=" + string16);
                                                            string14 = " AND dbms_lob.compare(" + string2 + "." + string21 + ", " + TTL_UNESCAPE_BEG + "'" + string17 + "'" + ")" + ")";
                                                            string14 = string14 + sqlcompOper_clobCompare_map.get(string12);
                                                        }
                                                    } else if (string15.equals(string18)) {
                                                        this.log("CASE: Equal lit/obj TypeFam: but not one of the ones above: colTypeName=" + string20 + " objTypeFam=" + string18 + " litType=" + string16 + " litTypeFam=" + string15);
                                                        if (string8.equals("=") || string8.equals("SAMETERM") || string8.equals("!=") || string8.equals("DIFFTERM")) {
                                                            this.log("CASE: =, !=");
                                                            String string36 = "\"" + string17 + "\"";
                                                            if (string16 != null && string16.length() > 0) {
                                                                string36 = string36 + "^^<" + string16 + ">";
                                                            }
                                                            string14 = " AND sdo_rdf.vname(" + string + ")" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + "sdo_rdf.get_canon_val('" + string36 + "')" + ")";
                                                        } else {
                                                            this.log("CASE: >=, <=, <, >");
                                                            string14 = " AND 1=0 ";
                                                        }
                                                    } else {
                                                        this.log("CASE: different type families: litTypeFam=" + string15 + " objTypeFam=" + string18 + " compOp=" + string8);
                                                        if (string15.equals(TYPE_FAM_OTHER) || string18.equals(TYPE_FAM_OTHER)) {
                                                            string14 = relExpr.compOperator.equals("DIFFTERM") ? COND_TRUE : " AND 1=0 ";
                                                            this.log("at least one of the types is unknown (OTHER): " + string14);
                                                        } else if (string8.equals("!=") || string8.equals("DIFFTERM")) {
                                                            this.log("CASE: !=, !sameTerm : 1=1");
                                                            string14 = COND_TRUE;
                                                        } else {
                                                            string14 = " AND 1=0 ";
                                                            this.log("genFilterCond: " + string14);
                                                        }
                                                    }
                                                }
                                                string4 = string4 + string14;
                                                this.log("genFilterCond: " + string4);
                                                return string4;
                                            }
                                            if (rRTabRowInfo.oExprType != RRTabRowInfo.MapExprType_CONSTANT) {
                                                this.log("skipping FILTER opt for this relExpr b/c it is NOT of the form: v <compOp> <numeric/plain/typed literal>, or vice-versa");
                                                return string4;
                                            }
                                            this.log("CASE: Literal-[Literal+Constant]");
                                            this.log(arrayList5.get(0) + "=" + aSTTripleAtom.name);
                                            string11 = aSTTripleAtom.name;
                                            string10 = aSTTripleAtom.litType;
                                            string7 = aSTTripleAtom.type == 3 ? "STRING" : this.TYPE_FAMILY(string10);
                                            string13 = rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1);
                                            string6 = this.TYPE_FAMILY(string13);
                                            this.log("litType=" + string10 + " (litTypeFam=" + string7 + ") objDataType=" + string13 + " (objTypeFam=" + string6 + ")");
                                            string9 = null;
                                            if (!string6.equals(string7) && (!string6.equals(TYPE_FAM_FLOAT) && !string6.equals(TYPE_FAM_DOUBLE) && !string6.equals(TYPE_FAM_NUMERIC) || !string7.equals(TYPE_FAM_FLOAT) && !string7.equals(TYPE_FAM_DOUBLE) && !string7.equals(TYPE_FAM_NUMERIC)) || string6.equals(TYPE_FAM_OTHER) && !string10.equals(string13)) break block154;
                                            this.log("CASE: equal type families (and neither is OTHER *or* two identical datatypes)");
                                            if (!string6.equals("STRING")) break block155;
                                            this.log("CASE: string comparisons");
                                            this.log("      " + arrayList5.get(0) + "=" + aSTTripleAtom.name);
                                            if (!arrayList5.get(0).equals(aSTTripleAtom.name)) break block156;
                                            this.log("CASE: equal strings");
                                            if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                                                this.log("CASE: term (not value) comparison: " + relExpr.compOperator);
                                                this.log("term_atom.type=" + aSTTripleAtom.type + " RRrowInfo.oValueTypePL=" + rRTabRowInfo.oValueTypePL);
                                                string4 = aSTTripleAtom.type == 3 && rRTabRowInfo.oValueTypePL || aSTTripleAtom.type != 3 && !rRTabRowInfo.oValueTypePL ? string4 + (relExpr.compOperator.equals("SAMETERM") ? COND_TRUE : " AND 1=0 ") : string4 + (relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE);
                                                break block148;
                                            } else if (string8.equals("=") || string8.equals("<=") || string8.equals(">=")) {
                                                this.log("CASE: =, <=, >= cond: 1=1");
                                                string4 = string4 + COND_TRUE;
                                                break block148;
                                            } else {
                                                this.log("CASE: !=, <, > cond: 1=0");
                                                string4 = string4 + " AND 1=0 ";
                                            }
                                            break block148;
                                        }
                                        this.log("CASE: different strings");
                                        if (string8.equals("=") || string8.equals("SAMETERM")) {
                                            this.log("CASE: =, SAMETERM, 1=0");
                                            string4 = string4 + " AND 1=0 ";
                                        } else if (string8.equals("!=") || string8.equals("DIFFTERM") || (string8.equals("<") || string8.equals("<=")) && arrayList5.get(0).compareTo(aSTTripleAtom.name) < 0 || (string8.equals(">") || string8.equals(">=")) && arrayList5.get(0).compareTo(aSTTripleAtom.name) > 0) {
                                            this.log("CASE: !=, !SAMETERM, <, >, <=, >=, 1=1");
                                            string4 = string4 + COND_TRUE;
                                        } else {
                                            this.log("CASE: others, 1=0");
                                            string4 = string4 + " AND 1=0 ";
                                        }
                                    }
                                    this.log("FILTERCONDEXPR=" + string4);
                                    return string4;
                                }
                                if (!string6.equals(TYPE_FAM_DOUBLE) && !string6.equals(TYPE_FAM_FLOAT) && !string6.equals(TYPE_FAM_NUMERIC)) break block157;
                                this.log("CASE: numeric comparisons");
                                d2 = Double.valueOf(arrayList5.get(0));
                                d = Double.valueOf(aSTTripleAtom.name);
                                if (d2 != d) break block158;
                                this.log("CASE: equal numbers");
                                if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                                    this.log("CASE: term (not value) comparison: " + relExpr.compOperator);
                                    string4 = string10.equals(string13) && arrayList5.get(0).equals(aSTTripleAtom.name) ? string4 + (relExpr.compOperator.equals("SAMETERM") ? COND_TRUE : " AND 1=0 ") : string4 + (relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE);
                                    break block149;
                                } else if (string8.equals("=") || string8.equals("<=") || string8.equals(">=")) {
                                    this.log("CASE: =, <=, >= cond: 1=1");
                                    string4 = string4 + COND_TRUE;
                                    break block149;
                                } else {
                                    this.log("CASE: !=, <, > cond: 1=0");
                                    string4 = string4 + " AND 1=0 ";
                                }
                                break block149;
                            }
                            this.log("CASE: different numbers");
                            if (string8.equals("=") || string8.equals("SAMETERM")) {
                                this.log("CASE: =, SAMETERM, 1=0");
                                string4 = string4 + " AND 1=0 ";
                            } else if (string8.equals("!=") || string8.equals("DIFFTERM") || (string8.equals("<") || string8.equals("<=")) && d2 < d || (string8.equals(">") || string8.equals(">=")) && d2 > d) {
                                this.log("CASE: !=, !SAMETERM, <, >, <=, >=, 1=1");
                                string4 = string4 + COND_TRUE;
                            } else {
                                this.log("CASE: others, 1=0");
                                string4 = string4 + " AND 1=0 ";
                            }
                        }
                        this.log("FILTERCONDEXPR=" + string4);
                        return string4;
                    }
                    if (string6.equals("DATE")) {
                        this.log("CASE: date comparisons - generate the native (db-col based) optimized condition");
                        if (arrayList5.get(0).equals(string11)) {
                            if (string8.equals("=") || string8.equals(">=") || string8.equals("<=")) {
                                string4 = string4 + COND_TRUE;
                            } else if (string8.equals("!=") || string8.equals(">") || string8.equals("<")) {
                                string4 = string4 + " AND 1=0 ";
                            } else if (string8.equals("SAMETERM")) {
                                string4 = string4 + COND_TRUE;
                            } else {
                                if (!string8.equals("DIFFTERM")) throw new RDFException("genFilterCond_new: unknown compOperator:[" + string8 + "]");
                                string4 = string4 + " AND 1=0 ";
                            }
                            this.log("FILTERCONDEXPR=" + string4);
                            return string4;
                        }
                        if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                            string4 = string4 + (relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE);
                            this.log("FILTERCONDEXPR=" + string4);
                            return string4;
                        }
                        String string37 = arrayList5.get(0);
                        boolean bl8 = false;
                        boolean bl9 = false;
                        if (RelationalBGP.tzone(string37) != null) {
                            bl8 = true;
                        }
                        if (RelationalBGP.tzone(string11) != null) {
                            bl9 = true;
                        }
                        if (bl8 != bl9) {
                            this.log("time zone present in one but not the other: map_tzone_present=" + bl8 + " lit_tzone_present=" + bl9);
                            string9 = "(to_timestamp_tz('" + string37 + (bl8 ? "" : TZ_LOWER) + "','" + FORMAT_DATE_TZ + "')" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string11 + (bl9 ? "" : TZ_LOWER) + "','" + FORMAT_DATE_TZ + "')" + COND_CONNECTOR + "to_timestamp_tz('" + string37 + (bl8 ? "" : TZ_UPPER) + "','" + FORMAT_DATE_TZ + "')" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string11 + (bl9 ? "" : TZ_UPPER) + "','" + FORMAT_DATE_TZ + "')" + ")";
                            this.log("time zone present-absent: condExpr=" + string9);
                        } else {
                            string9 = bl8 ? "to_timestamp_tz('" + string37 + "','" + FORMAT_DATE_TZ + "')" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string11 + "','" + FORMAT_DATE_TZ + "')" : "to_timestamp('" + string37 + "','" + FORMAT_DATE + "')" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp('" + string11 + "','" + FORMAT_DATE + "')";
                        }
                    } else if (string6.equals(TYPE_FAM_DATETIME)) {
                        this.log("CASE: dateTime comparisons - generate the native (db-col based) optimized condition");
                        if (arrayList5.get(0).equals(string11)) {
                            if (string8.equals("=") || string8.equals(">=") || string8.equals("<=")) {
                                string4 = string4 + COND_TRUE;
                            } else if (string8.equals("!=") || string8.equals(">") || string8.equals("<")) {
                                string4 = string4 + " AND 1=0 ";
                            } else if (string8.equals("SAMETERM")) {
                                string4 = string4 + COND_TRUE;
                            } else {
                                if (!string8.equals("DIFFTERM")) throw new RDFException("genFilterCond_new: unknown compOperator:[" + string8 + "]");
                                string4 = string4 + " AND 1=0 ";
                            }
                            this.log("FILTERCONDEXPR=" + string4);
                            return string4;
                        }
                        if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                            string4 = string4 + (relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE);
                            this.log("FILTERCONDEXPR=" + string4);
                            return string4;
                        }
                        String string38 = arrayList5.get(0);
                        boolean bl10 = false;
                        boolean bl11 = false;
                        if (RelationalBGP.tzone(string38) != null) {
                            bl10 = true;
                        }
                        if (RelationalBGP.tzone(string11) != null) {
                            bl11 = true;
                        }
                        if (bl10 != bl11) {
                            this.log("time zone present in one but not the other: map_tzone_present=" + bl10 + " lit_tzone_present=" + bl11);
                            string9 = "(to_timestamp_tz('" + string38 + (bl10 ? "" : TZ_LOWER) + "','" + FORMAT_TIMESTAMP_TZ + "')" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string11 + (bl11 ? "" : TZ_LOWER) + "','" + FORMAT_TIMESTAMP_TZ + "')" + COND_CONNECTOR + "to_timestamp_tz('" + string38 + (bl10 ? "" : TZ_UPPER) + "','" + FORMAT_TIMESTAMP_TZ + "')" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string11 + (bl11 ? "" : TZ_UPPER) + "','" + FORMAT_TIMESTAMP_TZ + "')" + ")";
                            this.log("time zone present-absent: condExpr=" + string9);
                        } else {
                            string9 = bl10 ? "to_timestamp_tz('" + string38 + "','" + FORMAT_TIMESTAMP_TZ + "')" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp_tz('" + string11 + "','" + FORMAT_TIMESTAMP_TZ + "')" : "to_timestamp('" + string38 + "','" + FORMAT_TIMESTAMP + "')" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + "to_timestamp('" + string11 + "','" + FORMAT_TIMESTAMP + "')";
                        }
                    } else {
                        this.log("CASE: get the literal (full rdfterm) constant");
                        String string39 = "\"" + string11 + "\"";
                        if (string10 != null && string10.length() > 0) {
                            string39 = string39 + "^^<" + string10 + ">";
                        }
                        string9 = SDO_RDF_VNAME_BEG + string + ")" + BASE_PREFIX_COLNAME_SEP + string12 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + "sdo_rdf.get_canon_val('" + string39 + "')" + ")";
                    }
                    string4 = string4 + COND_CONNECTOR + string9;
                    this.log("genFilterCond: " + string4);
                    return string4;
                }
                this.log("CASE: different type families: litTypeFam=" + string7 + " objTypeFam=" + string6 + " compOp=" + string8);
                if (string7.equals(TYPE_FAM_OTHER) || string6.equals(TYPE_FAM_OTHER)) {
                    string4 = relExpr.compOperator.equals("DIFFTERM") ? string4 + COND_TRUE : string4 + " AND 1=0 ";
                    this.log("at least one of the types is unknown (OTHER): " + string4);
                    return string4;
                }
                if (!string8.equals("!=") && !string8.equals("DIFFTERM")) {
                    string4 = string4 + " AND 1=0 ";
                    this.log("genFilterCond: " + string4);
                    return string4;
                }
                this.log("CASE: !=, 1=1");
                return string4 + COND_TRUE;
            }
            for (int i = 0; i < arrayList3.size(); ++i) {
                String string40 = "";
                String string41 = "";
                if (!arrayList2.get(i).equals("STRING") && !arrayList2.get(i).equals(LTC_TYPE_NUMBER)) {
                    string40 = "to_char(";
                    string41 = ")";
                } else if (arrayList2.get(i).equals(LTC_TYPE_NUMBER)) {
                    String string42 = arrayList4.get(i);
                    String string43 = null;
                    if (string42.indexOf(46) != -1) {
                        double d = Double.parseDouble(string42);
                        string43 = String.valueOf(d);
                        if (Math.ceil(d) == Math.floor(d)) {
                            string43 = string43.substring(0, string43.indexOf(46));
                        }
                    } else {
                        long l = Long.parseLong(string42);
                        string43 = String.valueOf(l);
                    }
                    this.log("canon_num_str=" + string43);
                    if (!string43.equals(string42)) {
                        string40 = "to_char(";
                        string41 = ")";
                    }
                }
                string5 = string5 + COND_CONNECTOR + string40 + string2 + "." + arrayList3.get(i) + string41 + " = " + RelationalBGP.const_for_native_comparison(arrayList4.get(i));
            }
            if (!bl2) return string4 + string5;
            string5 = " AND NOT ( " + string5.substring(COND_CONNECTOR.length()) + " )";
            return string4 + string5;
        }
        for (int i = 0; i < arrayList3.size(); ++i) {
            String string44 = "";
            String string45 = "";
            if (!arrayList2.get(i).equals("STRING") && !arrayList2.get(i).equals(LTC_TYPE_NUMBER)) {
                string44 = "to_char(";
                string45 = ")";
            } else if (arrayList2.get(i).equals(LTC_TYPE_NUMBER)) {
                String string46 = arrayList.get(i);
                String string47 = null;
                if (string46.indexOf(46) != -1) {
                    double d = Double.parseDouble(string46);
                    string47 = String.valueOf(d);
                    if (Math.ceil(d) == Math.floor(d)) {
                        string47 = string47.substring(0, string47.indexOf(46));
                    }
                } else {
                    long l = Long.parseLong(string46);
                    string47 = String.valueOf(l);
                }
                this.log("canon_num_str=" + string47);
                if (!string47.equals(string46)) {
                    string44 = "to_char(";
                    string45 = ")";
                }
            }
            string3 = string3 + COND_CONNECTOR + string44 + string2 + "." + arrayList3.get(i) + string45 + " = " + "'" + arrayList.get(i) + "'";
        }
        if (!bl) return string4 + string3;
        string3 = " AND NOT ( " + string3.substring(COND_CONNECTOR.length()) + " )";
        return string4 + string3;
    }

    private Integer getComponentInfo_from_RRrow(String string, RRTabRowInfo rRTabRowInfo, String[] stringArray) {
        String string2 = "";
        int n = 0;
        String string3 = null;
        String string4 = null;
        if (string.equals("subject") && rRTabRowInfo.sExpr != null) {
            string2 = rRTabRowInfo.sExpr;
            n = rRTabRowInfo.sExprType;
            string3 = rRTabRowInfo.sTermType;
        } else if (string.equals("predicate") && rRTabRowInfo.pExpr != null) {
            string2 = rRTabRowInfo.pExpr;
            n = rRTabRowInfo.pExprType;
            string3 = rrIRI;
        } else if (string.equals("object") && rRTabRowInfo.oExpr != null) {
            string2 = rRTabRowInfo.oExpr;
            n = rRTabRowInfo.oExprType;
            string3 = rRTabRowInfo.oTermType;
            if (string3 == null) {
                string3 = rrIRI;
            }
            string4 = rRTabRowInfo.oDataType;
        } else if (string.equals("object") && rRTabRowInfo.psExpr != null) {
            string2 = rRTabRowInfo.psExpr;
            n = rRTabRowInfo.psExprType;
            string3 = rRTabRowInfo.psTermType;
        } else if (string.equals("graph") && rRTabRowInfo.pogExpr != null) {
            string2 = rRTabRowInfo.pogExpr;
            n = rRTabRowInfo.pogExprType;
            string3 = rrIRI;
        }
        stringArray[0] = string2;
        stringArray[1] = string3;
        if (string3.equals(rrLiteral) && string4 == null) {
            string4 = XSD_STRING_NO_ENCLOSING;
        }
        stringArray[2] = string4;
        return n;
    }

    private String isVarOccMatchable_in_UArow(String string, String string2, int n, int n2, String string3, String string4, String string5) {
        boolean bl = true;
        this.log("entered: isVarOccMatchable_in_UArow: var=" + string + " pos_in_tp=" + string2 + " currRRrowid=" + string3 + " fullOccInfo=" + string4 + " UA rowNum=" + n2 + " po_idx=" + n + " RRrL=" + string5);
        String[] stringArray = string5.substring(1, string5.length()).split(":");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        this.log(arrayList.toString());
        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(string3);
        String[] stringArray2 = new String[3];
        Integer n3 = this.getComponentInfo_from_RRrow(string2, rRTabRowInfo, stringArray2);
        String string6 = stringArray2[0];
        String string7 = stringArray2[1];
        String string8 = stringArray2[2];
        String string9 = null;
        if (string8 != null) {
            string9 = this.TYPE_FAMILY(string8.substring(1, string8.length() - 1));
        }
        String string10 = null;
        String string11 = null;
        if (n3 == RRTabRowInfo.MapExprType_COLUMN) {
            string10 = RelationalBGP.get_base_prefix_from_RR_table(string6);
            string11 = RelationalBGP.get_col_name_from_RR_table(string6);
            if (string10 == null) {
                this.log("... MATCHABLE (b/c it is column-valued mapping and no base prefix): returned: EMPTY-STRING");
                return "";
            }
        } else {
            string11 = string6;
        }
        this.log("\ncurrExprType: " + n3);
        this.log("\ncurrTemplate: " + string6);
        this.log("\ncurrTermType: " + string7);
        this.log("\ncurrDatatype: " + string8 + " [" + string9 + "]");
        int n4 = string4.length() - string4.replace("+", "").length();
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = n5;
            int n7 = string4.indexOf(58, n6);
            n5 = (string4 + "+").indexOf(43, n7);
            String string12 = string4.substring(n6 + 1, n7);
            int n8 = Integer.parseInt(string4.substring(n7 + 1, n5));
            this.log("occ_pos_in_tp=" + string12 + " occ_po_idx=" + n8);
            if (n < n8 || n == n8 && (string2.equals(string12) || string2.equals("graph") && (string12.equals("predicate") || string12.equals("object")) || string2.equals("predicate") && string12.equals("object"))) {
                this.log("skip checking with itself or with yet-to-be-processed occ: +" + string12 + ":" + n8);
                continue;
            }
            String string13 = arrayList.get(n8);
            this.log("compare currRRrowid=" + string3 + " with occRRrowid=" + string13);
            RRTabRowInfo rRTabRowInfo2 = this.RRrowInfo_for_MatchingRow.get(string13);
            String[] stringArray3 = new String[3];
            Integer n9 = this.getComponentInfo_from_RRrow(string12, rRTabRowInfo2, stringArray3);
            String string14 = stringArray3[0];
            String string15 = stringArray3[1];
            String string16 = stringArray3[2];
            this.log("\noccExprType: " + n9);
            this.log("\noccTemplate: " + string14);
            this.log("\noccTermType: " + string15);
            this.log("\noccDatatype: " + string16);
            String string17 = null;
            String string18 = null;
            if (n9 == RRTabRowInfo.MapExprType_COLUMN) {
                string17 = RelationalBGP.get_base_prefix_from_RR_table(string14);
                string18 = RelationalBGP.get_col_name_from_RR_table(string14);
                if (string17 == null) {
                    this.log("... MATCHABLE (b/c it is column-valued mapping): continue");
                    continue;
                }
            } else {
                string18 = string14;
            }
            if (!string15.equals(string7)) {
                bl = false;
            } else if (string7.equals(rrLiteral) && !string8.equals(string16)) {
                String string19 = this.TYPE_FAMILY(string16.substring(1, string16.length() - 1));
                if (!string19.equals(string9) || string19.equals(TYPE_FAM_OTHER)) {
                    bl = false;
                }
            } else if (string10 == null && string17 == null && !RelationalBGP.matchableSqlTemplatePair(string6, string14, this.ctx)) {
                bl = false;
            }
            if (!bl) break;
        }
        this.log("isVarOccMatchable_in_UArow: ... DONE");
        if (!bl) {
            this.log("... NOT-MATCHABLE: returned:  AND 1=0 ");
            return " AND 1=0 ";
        }
        this.log("... MATCHABLE: returned: EMPTY-STRING");
        return "";
    }

    private String multiOccurrenceOfVar(String string, String string2, int n, int n2, String string3, HashMap<String, String> hashMap, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2, String string4, ArrayList<String> arrayList3, NatVarOpt_Info natVarOpt_Info, ArrayList<String> arrayList4, String string5) {
        this.log("multiOcc: starting ... UnionArray rowNum=" + n2);
        String string6 = "";
        String string7 = hashMap.get(string);
        String string8 = string2 + ":" + n;
        String string9 = string7.substring(0, string7.indexOf(58));
        int n3 = Integer.parseInt(string7.substring(string7.indexOf(58) + 1, string7.length()));
        String string10 = null;
        if (!string8.equals(string7)) {
            this.log("multi-occurrence of var (now in " + string2 + ":" + n + " pos): " + string + " : FirstOccPos=" + string7);
            string10 = this.getExprFromArrays(string7, n2, string4, arrayList, arrayList2, arrayList3, null);
            if (!string10.equals(string3)) {
                CharSequence charSequence;
                String string11 = null;
                Integer n4 = new Integer(n2);
                HashSet<String> hashSet = natVarOpt_Info.get_occInfoSet_inUArow(string, n4);
                this.log("-> origExpr=" + string10 + " : currExpr=" + " NOT-IDENTICAL" + "\noccInfoSet : " + hashSet);
                String string12 = arrayList4.get(n2);
                ArrayList<String> arrayList5 = new ArrayList<String>();
                String string13 = "";
                int n5 = -1;
                boolean bl = true;
                boolean bl2 = true;
                while (bl) {
                    bl = false;
                    n5 = string12.indexOf(58);
                    if (n5 >= 0) {
                        string13 = string12.substring(0, n5);
                        string12 = string12.substring(n5 + 1, string12.length());
                        if (!bl2) {
                            arrayList5.add(string13);
                        }
                        bl = true;
                    }
                    bl2 = false;
                }
                if (string12.length() > 0) {
                    arrayList5.add(string12);
                }
                RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(arrayList5.get(n3));
                RRTabRowInfo rRTabRowInfo2 = this.RRrowInfo_for_MatchingRow.get(arrayList5.get(n));
                String string14 = "";
                Integer n6 = null;
                if (string9.equals("subject") && rRTabRowInfo.sExpr != null) {
                    string14 = rRTabRowInfo.sExpr;
                    n6 = rRTabRowInfo.sExprType;
                } else if (string9.equals("predicate") && rRTabRowInfo.pExpr != null) {
                    string14 = rRTabRowInfo.pExpr;
                    n6 = rRTabRowInfo.pExprType;
                } else if (string9.equals("object") && rRTabRowInfo.oExpr != null) {
                    string14 = rRTabRowInfo.oExpr;
                    n6 = rRTabRowInfo.oExprType;
                } else if (string9.equals("object") && rRTabRowInfo.psExpr != null) {
                    string14 = rRTabRowInfo.psExpr;
                    n6 = rRTabRowInfo.psExprType;
                } else if (string9.equals("graph") && rRTabRowInfo.pogExpr != null) {
                    string14 = rRTabRowInfo.pogExpr;
                    n6 = rRTabRowInfo.pogExprType;
                }
                String string15 = "";
                Integer n7 = null;
                if (string2.equals("subject") && rRTabRowInfo2.sExpr != null) {
                    string15 = rRTabRowInfo2.sExpr;
                    n7 = rRTabRowInfo2.sExprType;
                } else if (string2.equals("predicate") && rRTabRowInfo2.pExpr != null) {
                    string15 = rRTabRowInfo2.pExpr;
                    n7 = rRTabRowInfo2.pExprType;
                } else if (string2.equals("object") && rRTabRowInfo2.oExpr != null) {
                    string15 = rRTabRowInfo2.oExpr;
                    n7 = rRTabRowInfo2.oExprType;
                } else if (string2.equals("object") && rRTabRowInfo2.psExpr != null) {
                    string15 = rRTabRowInfo2.psExpr;
                    n7 = rRTabRowInfo2.psExprType;
                } else if (string2.equals("graph") && rRTabRowInfo2.pogExpr != null) {
                    string15 = rRTabRowInfo2.pogExpr;
                    n7 = rRTabRowInfo2.pogExprType;
                }
                if (hashSet != null && hashSet.size() != 1) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    charSequence = new StringBuffer("");
                    ArrayList<String> arrayList6 = new ArrayList<String>();
                    ArrayList<String> arrayList7 = new ArrayList<String>();
                    ArrayList<String> arrayList8 = new ArrayList<String>();
                    ArrayList<String> arrayList9 = new ArrayList<String>();
                    string14 = string14.substring(1, string14.length() - 1);
                    string15 = string15.substring(1, string15.length() - 1);
                    try {
                        String string16 = RelationalBGP.sqlTempl2sqlExpr(string14, rrIRI, string5 + ".", stringBuffer, arrayList6, arrayList7, null, this.ctx);
                        string16 = RelationalBGP.sqlTempl2sqlExpr(string15, rrIRI, string5 + ".", charSequence, arrayList8, arrayList9, null, this.ctx);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    string11 = "";
                    for (int i = 0; i < arrayList6.size(); ++i) {
                        string11 = string11 + COND_CONNECTOR + string5 + "." + arrayList6.get(i) + " = " + string5 + "." + arrayList8.get(i);
                    }
                    this.log("OPTNATVARCOND=" + string11);
                }
                int n8 = 2;
                string6 = n7 == n8 && n7 == n8 ? " AND 1=0 " : (string11 == null ? COND_CONNECTOR + string10 + "=" + string3 : string11);
                charSequence = COND_CONNECTOR + string10 + "=" + string3;
                this.log("-> origExpr=" + string10 + " : currExpr=" + string3);
                this.log("-> condExpr_delta=" + (String)charSequence + " : optimizedCondExpr_delta=" + string6);
            } else {
                this.log("-> origExpr=" + string10 + " : currExpr=" + " IDENTICAL");
            }
        }
        this.log("multiOcc: ... DONE");
        return string6;
    }

    private void store_noVa_related_Info(int n, String string, ArrayList<String> arrayList, ArrayList<String> arrayList2, String string2, String string3, String string4, String string5, int n2, int n3, int n4, NatVarOpt_Info natVarOpt_Info, UArowNatSelectInfo uArowNatSelectInfo) throws RDFException {
        String string6 = this.TFTglobalList.get(n).substring(0, 2);
        Integer n5 = new Integer(-1);
        if (string6.substring(1, 2).equals("1")) {
            n5 = RRTabRowInfo.MapExprType_TEMPLATE;
        } else if (string6.substring(1, 2).equals("2")) {
            n5 = RRTabRowInfo.MapExprType_CONSTANT;
        } else if (string6.substring(1, 2).equals("3")) {
            n5 = RRTabRowInfo.MapExprType_COLUMN;
        } else if (string6.substring(1, 2).equals("0")) {
            n5 = 0;
        } else {
            this.log("ERROR: ExprType is NOT correct. TERMTYPE_EXPRTYPE=" + string6);
        }
        if (n5.intValue() != RRTabRowInfo.MapExprType_CONSTANT.intValue() && n5 != 0) {
            natVarOpt_Info.set(string2, n, string3, string4, arrayList.size());
        } else {
            natVarOpt_Info.set(string2, n, string3, string4, 0);
        }
        if (!string3.equals("subject:0")) {
            for (int i = 0; i < n4; ++i) {
                this.log("var=" + string2 + ": adding occInfo: occInfo=" + string3);
                natVarOpt_Info.set(string2, new Integer(n2 + n3 + i), n, string3);
            }
        } else {
            this.log("var=" + string2 + ": SKIP adding occInfo b/c it occurs in subject position: occInfo=" + string3);
        }
        if (n5.intValue() != RRTabRowInfo.MapExprType_CONSTANT.intValue() && n5 != 0) {
            String string7 = string4;
            if (string5 != null) {
                string7 = string5;
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string8 = arrayList.get(i);
                String string9 = string7 + "." + string8;
                String string10 = this.TFTinfoGlobalList.get((int)n).colTypeList.get(i);
                this.log("colName: " + string8);
                this.log("colType: " + string10);
                if ("SDO_GEOMETRY".equals(string10)) {
                    String string11 = string + "+" + string8.replaceAll("\"", "");
                    this.log("[store_noVa_related_Info]  SDO_GEOMETRY retrieving metadata for var " + string2 + " associated to the column name " + string8 + " from LtcRowInfo_for_Tmap_plus_Col with key " + string11);
                    LtcTabRowInfo ltcTabRowInfo = this.LtcRowInfo_for_Tmap_plus_Col.get(string11);
                    this.log("[store_noVa_related_Info]  LtcRowInfo.toString(): " + ltcTabRowInfo.toString());
                    this.log("[store_noVa_related_Info]  LtcRowInfo.getDimArrayConstructor(): " + ltcTabRowInfo.getDimArrayConstructor());
                    this.log("[store_noVa_related_Info] Starting multi-SRID handling for var " + string2 + " mapped to colName " + string8 + " at the column expression level");
                    Long l = null;
                    l = ltcTabRowInfo.getSRID() == null ? DEFAULT_GEOMETRY_SRID : Long.valueOf(ltcTabRowInfo.getSRID());
                    this.log("[store_noVa_related_Info] [SRID] SDO_GEOMETRY SRID: " + l + " for column " + string8);
                    Set<Object> set = null;
                    if (!this.Geometry_VarSRID.containsKey(string2)) {
                        set = new LinkedHashSet();
                        this.Geometry_VarSRID.put(string2, set);
                    } else {
                        set = this.Geometry_VarSRID.get(string2);
                    }
                    if (!set.contains(l)) {
                        this.log("[store_noVa_related_Info] [SRID] adding to Geometry_VarSRID: obje var=" + string2 + " col_srid=" + l);
                        this.log("[store_noVa_related_Info] [SRID] BEFORE count SRIDs: " + set.size());
                        this.log("[store_noVa_related_Info] [SRID] BEFORE SRIDs: " + set);
                        set.add(l);
                        this.log("[store_noVa_related_Info] [SRID] AFTER count SRIDs: " + set.size());
                        this.log("[store_noVa_related_Info] [SRID] AFTER SRIDs: " + set);
                        this.log("[store_noVa_related_Info] [SRID] Geometry_VarSRID: " + this.Geometry_VarSRID);
                        this.log("[store_noVa_related_Info] [SRID] NOTE: we may have to UNDO this addition to Geometry_VarSRID later if filter validation requires this type to be non-geometry");
                    }
                    this.log("[store_noVa_related_Info] Finishing multi-SRID handling for var " + string2 + " mapped to colName " + string8 + " at store_noVa_related_Info method");
                    String string12 = ltcTabRowInfo.getDimArrayConstructor(DEFAULT_GEOMETRY_DIMENSION);
                    this.log("[store_noVa_related_Info] retrieved geoDimesion for current mapping (MUST be single column for geometry vars): " + string12);
                    this.Geometry_VarDimension.put(string4 + "." + string2, string12);
                }
                arrayList3.add(string9);
            }
            uArowNatSelectInfo.add_ColList_for_var(string2, arrayList3);
        } else {
            ArrayList<String> arrayList4 = new ArrayList<String>();
            uArowNatSelectInfo.add_ColList_for_var(string2, arrayList4);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateUnionArrays(String string, int n, int n2, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2, ArrayList<ArrayList<String>> arrayList3, RRTabRowInfo rRTabRowInfo, int n3, String string2, ArrayList<String> arrayList4, ArrayList<String> arrayList5, ArrayList<String> arrayList6, String string3, String string4, String string5, boolean bl, boolean bl2, HashMap<String, String> hashMap, String string6, String string7, boolean bl3, ArrayList<String> arrayList7, ArrayList<HashSet<String>> arrayList8, ArrayList<HashMap<String, String>> arrayList9, boolean bl4, HashMap<String, ArrayList<Set<String>>> hashMap2, int n4, NatVarOpt_Info natVarOpt_Info, int n5, UArowNatSelectInfo uArowNatSelectInfo, ArrayList<UArowNatSelectInfo> arrayList10) throws RDFException, SQLException {
        void var65_115;
        void var62_77;
        Object object;
        HashMap<Object, Object> hashMap3;
        Set<String> set;
        Object object2;
        CharSequence charSequence;
        CharSequence charSequence2;
        Object object3;
        Object object4;
        CharSequence charSequence3;
        String string8;
        String string9;
        UArowNatSelectInfo uArowNatSelectInfo2;
        String string10;
        String string11;
        Object object5;
        String string12;
        String string13;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        ArrayList<String> arrayList11;
        ArrayList<String> arrayList12;
        ArrayList<String> arrayList13;
        boolean bl8;
        String string14;
        block239: {
            block229: {
                block242: {
                    block241: {
                        Object object6;
                        Object object7;
                        block240: {
                            String string15;
                            CharSequence charSequence4;
                            String string16;
                            block225: {
                                Object object8;
                                Object object9;
                                block233: {
                                    block238: {
                                        block236: {
                                            int n6;
                                            block237: {
                                                void var71_124;
                                                block235: {
                                                    block234: {
                                                        block230: {
                                                            block232: {
                                                                ArrayList<String> arrayList14;
                                                                ArrayList<String> arrayList15;
                                                                block231: {
                                                                    string14 = "P" + n;
                                                                    bl8 = true;
                                                                    arrayList13 = arrayList.get(n);
                                                                    arrayList12 = arrayList2.get(n);
                                                                    arrayList11 = arrayList3.get(n);
                                                                    this.log("entered populateUnionArrays: --------------------------------------------------------------------------");
                                                                    this.log("pUA: ENTERING: po_idx=" + n + " writePos=" + n2 + " rowBlock_size=" + n3 + " alias=" + string2 + " UAstartPos=" + n5);
                                                                    if (bl8) {
                                                                        this.log("pUA: initially : pExprArray.size()=" + arrayList13.size());
                                                                    }
                                                                    this.log("pUA: initially : oExprArray.size()=" + arrayList12.size());
                                                                    this.log("pUA: initially : clobExprArray.size()=" + arrayList11.size());
                                                                    if (this.graph_use_mode > 0) {
                                                                        if (this.is_bgp_graph_a_var) {
                                                                            this.log("pUA: initially : gExprArray.size()=" + arrayList7.size());
                                                                        }
                                                                        this.log("pUA: initially : GeesArray.size()=" + arrayList8.size());
                                                                        this.log("pUA: initially : TpGEArray.size()=" + arrayList9.size());
                                                                    }
                                                                    this.log("pUA: initially : fromArray.size()=" + arrayList5.size());
                                                                    this.log("pUA: initially : condArray.size()=" + arrayList6.size());
                                                                    this.log("pUA: initially : native_oExprSetArray_for_Var.size()=" + hashMap2.size() + " : " + hashMap2);
                                                                    bl7 = false;
                                                                    bl6 = false;
                                                                    bl5 = false;
                                                                    string13 = null;
                                                                    string12 = null;
                                                                    object5 = "NULL";
                                                                    string11 = null;
                                                                    string10 = "";
                                                                    string16 = null;
                                                                    this.log("===> writePos=" + n2);
                                                                    this.log("===> UArowNatSelectInfoArray.size()=" + arrayList10.size());
                                                                    uArowNatSelectInfo2 = n5 + n2 < arrayList10.size() ? new UArowNatSelectInfo() : new UArowNatSelectInfo(uArowNatSelectInfo);
                                                                    this.log("UArowNatSelectInfo_for_Copy=" + uArowNatSelectInfo);
                                                                    this.log("UArowNatSelectInfo_tmp=" + uArowNatSelectInfo2);
                                                                    StringBuffer stringBuffer = new StringBuffer("");
                                                                    Object var49_48 = null;
                                                                    arrayList15 = new ArrayList<String>();
                                                                    arrayList14 = new ArrayList<String>();
                                                                    if (!bl8) break block230;
                                                                    charSequence4 = "";
                                                                    string15 = null;
                                                                    if (rRTabRowInfo.pExprType != RRTabRowInfo.MapExprType_TEMPLATE) break block231;
                                                                    try {
                                                                        string9 = rrIRI;
                                                                        string13 = RelationalBGP.sqlTempl2sqlExpr(rRTabRowInfo.pExpr.substring(1, rRTabRowInfo.pExpr.length() - 1), string9, string2 + ".", stringBuffer, arrayList15, arrayList14, rRTabRowInfo.pColTypeList, this.ctx);
                                                                        string13 = "'<'||" + string13 + "||'>'";
                                                                        this.log("pExpr=" + string13 + " pNotNullColCondExpr=" + stringBuffer);
                                                                        if (stringBuffer.length() > 0) {
                                                                            string10 = string10 + stringBuffer.toString();
                                                                            this.log("[pExpr: added notNullColCondExpr] condExpr: " + string10);
                                                                        }
                                                                        if (!bl) {
                                                                            this.store_noVa_related_Info(rRTabRowInfo.pTFT_idx, rRTabRowInfo.Tmap, arrayList15, arrayList14, string3, "predicate:" + n, string2, null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                                        }
                                                                    }
                                                                    catch (Exception exception) {
                                                                        exception.printStackTrace();
                                                                    }
                                                                    if (bl) {
                                                                        charSequence4 = "'" + string3.replace("'", "''") + "'" + "=" + string13;
                                                                        string15 = this.find_optimized_CondExpr(string3, arrayList15, arrayList14, string2, rRTabRowInfo.Tmap, null);
                                                                        this.log("[pred in triple-pattern is constant] pCondExpr: " + (String)charSequence4 + " optimized_pCondExpr: " + string15);
                                                                        if (string15 != null) {
                                                                            charSequence4 = string15;
                                                                        }
                                                                    }
                                                                    break block232;
                                                                }
                                                                if (rRTabRowInfo.pExprType == RRTabRowInfo.MapExprType_CONSTANT) {
                                                                    string13 = "'" + rRTabRowInfo.pExpr + "'";
                                                                    this.log("[PredicateMap is constant] pExpr: " + string13 + " is matchable with pred in triple-pattern: pred=" + string3);
                                                                    if (!bl) {
                                                                        this.store_noVa_related_Info(rRTabRowInfo.pTFT_idx, rRTabRowInfo.Tmap, null, null, string3, "predicate:" + n, string2, null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                                    }
                                                                } else if (rRTabRowInfo.pExprType == RRTabRowInfo.MapExprType_COLUMN) {
                                                                    string9 = TTL_ESCAPE_BEG;
                                                                    object9 = ")";
                                                                    if ((this.ctx.R2RFlags & 0x200L) > 0L) {
                                                                        string9 = "";
                                                                        object9 = "";
                                                                    } else if ((this.ctx.R2RFlags & 0x20000L) > 0L) {
                                                                        object9 = ", options=>' ESC_SBYTE_OPT=F ')";
                                                                    }
                                                                    string8 = RelationalBGP.get_base_prefix_from_RR_table(rRTabRowInfo.pExpr);
                                                                    if (string8 != null) {
                                                                        object7 = RelationalBGP.get_col_name_from_RR_table(rRTabRowInfo.pExpr);
                                                                        object8 = string2 + "." + (String)object7;
                                                                        string13 = "sdo_rdf.criri('" + string8 + "'," + string9 + (String)object8 + (String)object9 + ")";
                                                                        arrayList15.add((String)object7);
                                                                        arrayList14.add(string8);
                                                                    } else {
                                                                        object8 = string2 + "." + rRTabRowInfo.pExpr;
                                                                        string13 = "sdo_rdf.criri(NULL," + string9 + (String)object8 + (String)object9 + ")";
                                                                        arrayList15.add(rRTabRowInfo.pExpr);
                                                                        arrayList14.add("");
                                                                    }
                                                                    if (!bl) {
                                                                        this.store_noVa_related_Info(rRTabRowInfo.pTFT_idx, rRTabRowInfo.Tmap, arrayList15, arrayList14, string3, "predicate:" + n, string2, null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                                    }
                                                                    if (bl) {
                                                                        charSequence4 = "'" + string3.replace("'", "''") + "'" + "=" + string9 + string13 + (String)object9;
                                                                        this.log("col-valued PredicateMap: ADD condition: " + (String)charSequence4);
                                                                    }
                                                                }
                                                            }
                                                            if (((String)charSequence4).length() > 0) {
                                                                this.log("[pExpr: before adding notNullColCondExpr] condExpr: " + string10);
                                                                string10 = string10.length() == 0 ? COND_CONNECTOR + (String)charSequence4 : string10 + COND_CONNECTOR + (String)charSequence4;
                                                                this.log("[pExpr: after adding notNullColCondExpr] condExpr: " + string10);
                                                            }
                                                        }
                                                        charSequence4 = new StringBuffer("");
                                                        string15 = null;
                                                        string9 = null;
                                                        object9 = new ArrayList();
                                                        object8 = new ArrayList();
                                                        if (rRTabRowInfo.oExpr == null) break block233;
                                                        if (rRTabRowInfo.oExprType != RRTabRowInfo.MapExprType_TEMPLATE) break block234;
                                                        try {
                                                            string8 = null;
                                                            this.log("RRrowInfo.oTermType=" + rRTabRowInfo.oTermType + "[oExpr=" + rRTabRowInfo.oExpr + "]");
                                                            object7 = rRTabRowInfo.oTermType == null ? rrIRI : rRTabRowInfo.oTermType;
                                                            this.log("ottyp=" + (String)object7 + " : rrIRI=" + rrIRI);
                                                            string12 = RelationalBGP.sqlTempl2sqlExpr(rRTabRowInfo.oExpr.substring(1, rRTabRowInfo.oExpr.length() - 1), (String)object7, string2 + ".", (StringBuffer)charSequence4, (ArrayList<String>)object9, (ArrayList<String>)object8, rRTabRowInfo.oColTypeList, this.ctx);
                                                            if (((String)object7).equals(rrIRI)) {
                                                                string8 = "U";
                                                                this.log("=IRI");
                                                                string12 = "'<'||" + string12 + "||'>'";
                                                            } else if (((String)object7).equals(rrBlankNode)) {
                                                                string8 = "B";
                                                                this.log("=BLANK_NODE");
                                                                string12 = "'_:' || sdo_rdf.cbnod(" + string12 + ")";
                                                            } else {
                                                                if (!((String)object7).equals(rrLiteral)) {
                                                                    this.log("=ERROR");
                                                                    this.log("pUA: EXCEPTION: Unknown termType for template-valued Omap: oTermType=" + rRTabRowInfo.oTermType + " rowid=" + rRTabRowInfo.rowid);
                                                                    throw new RDFException("Unknown termType for template-valued Omap: oTermType=" + rRTabRowInfo.oTermType + " RR_TAB rowid=" + rRTabRowInfo.rowid);
                                                                }
                                                                this.log("=LITERAL");
                                                                string8 = "L";
                                                                string12 = "'\"' || " + string12 + " || '\"'";
                                                                if (rRTabRowInfo.oLanguage != null) {
                                                                    this.log("processing language-tagged literal: " + rRTabRowInfo.oLanguage);
                                                                    string12 = string12 + " || '@" + rRTabRowInfo.oLanguage.substring(1, rRTabRowInfo.oLanguage.length() - 1).toLowerCase() + "'";
                                                                    this.log("canonicalized (using langTag.toLowerCase()) oExpr for PL@ lexval: " + string12);
                                                                } else if (rRTabRowInfo.oDataType != null && !rRTabRowInfo.oDataType.equals(XSD_STRING)) {
                                                                    this.log("processing typed-literal: " + rRTabRowInfo.oDataType);
                                                                    string12 = string12 + " || '^^" + rRTabRowInfo.oDataType + "'";
                                                                    string12 = "sdo_rdf.get_canon_val(" + string12 + ")";
                                                                    this.log("canonicalization-aware oExpr for typed-literal lexval: " + string12);
                                                                } else {
                                                                    this.log("[no-canonicalization] oExpr for PL-or-string lexval: " + string12);
                                                                }
                                                            }
                                                            if (!bl2) {
                                                                this.store_noVa_related_Info(rRTabRowInfo.oTFT_idx, rRTabRowInfo.Tmap, (ArrayList<String>)object9, (ArrayList<String>)object8, string4, "object:" + n, string2, null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                            }
                                                            break block225;
                                                        }
                                                        catch (Exception exception) {
                                                            exception.printStackTrace();
                                                        }
                                                        break block225;
                                                    }
                                                    if (rRTabRowInfo.oExprType != RRTabRowInfo.MapExprType_CONSTANT) break block235;
                                                    string12 = "'" + rRTabRowInfo.oExpr + "'";
                                                    if (!bl2) {
                                                        this.store_noVa_related_Info(rRTabRowInfo.oTFT_idx, rRTabRowInfo.Tmap, null, null, string4, "object:" + n, string2, null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                    }
                                                    break block225;
                                                }
                                                if (rRTabRowInfo.oExprType != RRTabRowInfo.MapExprType_COLUMN) {
                                                    this.log("pUA: EXCEPTION: unknown oExprType=" + rRTabRowInfo.oExprType);
                                                    throw new RDFException("unknown oExprType=" + rRTabRowInfo.oExprType + " RR_TAB rowid=" + rRTabRowInfo.rowid);
                                                }
                                                string8 = string2 + "." + rRTabRowInfo.oExpr;
                                                object7 = "";
                                                object6 = RelationalBGP.get_base_prefix_from_RR_table(rRTabRowInfo.oExpr);
                                                charSequence3 = RelationalBGP.get_col_name_from_RR_table(rRTabRowInfo.oExpr);
                                                if (object6 != null) {
                                                    string8 = string2 + "." + (String)charSequence3;
                                                    ((ArrayList)object9).add(charSequence3);
                                                    ((ArrayList)object8).add(object6);
                                                } else {
                                                    ((ArrayList)object9).add(rRTabRowInfo.oExpr);
                                                    ((ArrayList)object8).add("");
                                                }
                                                if (!bl2) {
                                                    string9 = string8;
                                                }
                                                object4 = null;
                                                Object var62_66 = null;
                                                Object var63_79 = null;
                                                Object var64_95 = null;
                                                Object var65_105 = null;
                                                object3 = COND_CONNECTOR + string8 + " is NOT NULL";
                                                if (((StringBuffer)charSequence4).toString().indexOf((String)object3) < 0) {
                                                    ((StringBuffer)charSequence4).append((String)object3);
                                                } else {
                                                    this.log("SKIPPED adding (already-present) additional notNullCol condition: " + (String)object3);
                                                }
                                                if (bl2) {
                                                    charSequence2 = new StringBuffer("");
                                                    charSequence = new StringBuffer("");
                                                    object2 = new StringBuffer("");
                                                    set = new StringBuffer("");
                                                    this.findComponents_of_RDFterm(string4, (StringBuffer)charSequence2, (StringBuffer)charSequence, (StringBuffer)object2, (StringBuffer)((Object)set));
                                                    object4 = ((StringBuffer)charSequence2).toString();
                                                    String string17 = ((StringBuffer)charSequence).toString();
                                                    String string18 = ((StringBuffer)object2).toString();
                                                    String string19 = ((StringBuffer)((Object)set)).toString();
                                                    String string20 = this.TYPE_FAMILY(string18);
                                                    this.log("obje: vn=" + (String)object4 + " vt=" + string17 + " lt=" + string18 + " la=" + string19 + " tyfam=" + string20);
                                                }
                                                charSequence2 = null;
                                                if (rRTabRowInfo.oTermType != null && !rRTabRowInfo.oTermType.equals(rrLiteral)) break block236;
                                                charSequence2 = "L";
                                                charSequence = TTL_ESCAPE_BEG;
                                                object2 = ")";
                                                set = "";
                                                String string21 = "";
                                                if ((this.ctx.R2RFlags & 0x200L) > 0L) {
                                                    charSequence = "";
                                                    object2 = "";
                                                } else if ((this.ctx.R2RFlags & 0x20000L) > 0L) {
                                                    object2 = ", options=>' ESC_SBYTE_OPT=F ')";
                                                } else if (rRTabRowInfo.RDFdatatype_DBColType.contains("DB_TYPE=STRING_CLOB")) {
                                                    charSequence = TTL_ESCAPE_CLOB_BEG;
                                                    object2 = ")";
                                                }
                                                if (rRTabRowInfo.RDFdatatype_DBColType.contains("DB_TYPE=SDO_GEOMETRY")) {
                                                    hashMap3 = ((String)charSequence3).replaceAll("\"", "");
                                                    object = rRTabRowInfo.Tmap + "+" + (String)((Object)hashMap3);
                                                    LtcTabRowInfo ltcTabRowInfo = this.LtcRowInfo_for_Tmap_plus_Col.get(object);
                                                    if (ltcTabRowInfo.getDimArrayConstructor() == null) {
                                                        this.fetchGeometryColMetadata(ltcTabRowInfo, rRTabRowInfo.tabOwner.replaceAll("\"", ""), rRTabRowInfo.tabName.replaceAll("\"", ""), (String)((Object)hashMap3));
                                                    }
                                                    if (ltcTabRowInfo.getDimArrayConstructor() == null) {
                                                        this.log("fetchGeometryColMetadata failed: tabOwner=" + rRTabRowInfo.tabOwner + " tabName=" + rRTabRowInfo.tabName + " geoColName=" + (String)charSequence3);
                                                    }
                                                    if ((object7 = ltcTabRowInfo.getSRID()) == null || ((String)object7).equals("")) {
                                                        n6 = rRTabRowInfo.RDFdatatype_DBColType.lastIndexOf("(") + 1;
                                                        int n7 = rRTabRowInfo.RDFdatatype_DBColType.lastIndexOf(")");
                                                        object7 = rRTabRowInfo.RDFdatatype_DBColType.substring(n6, n7);
                                                    }
                                                    if (object7 == null || ((String)object7).equals("")) {
                                                        object7 = DEFAULT_GEOMETRY_SRID_STR;
                                                    }
                                                    set = TTL_CONVERT_TO_WKT_BEG;
                                                    String string22 = TTL_CONVERT_TO_WKT_END.replaceFirst("%TABLE_NAME%.%COLUMN_NAME%", string8).replaceFirst("%DBCOLTYPE_SRID%", (String)object7);
                                                    charSequence = "";
                                                    object2 = "";
                                                }
                                                hashMap3 = (String)charSequence + (String)((Object)set) + string8 + (String)var71_124 + (String)object2;
                                                string12 = "'\"' || " + (String)((Object)hashMap3) + " || '\"'";
                                                this.log("rr:Literal case: initial: oExpr=" + string12);
                                                if (rRTabRowInfo.oLanguage == null) break block237;
                                                this.log("processing language-tagged literal: " + rRTabRowInfo.oLanguage);
                                                string12 = string12 + " || '@" + rRTabRowInfo.oLanguage.substring(1, rRTabRowInfo.oLanguage.length() - 1) + "'";
                                                string12 = "sdo_rdf.get_canon_val(" + string12 + ")";
                                                this.log("canonicalization-aware oExpr for PL@ lexval: " + string12);
                                                break block238;
                                            }
                                            if (rRTabRowInfo.oDataType != null) {
                                                void var65_107;
                                                this.log("processing typed-literal: " + rRTabRowInfo.oDataType + " debug: lang=" + rRTabRowInfo.oLanguage);
                                                object = this.TYPE_FAMILY(rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1));
                                                this.log("omap_tyfam=" + (String)object + " (RRrowInfo.oDataType=" + rRTabRowInfo.oDataType + ")");
                                                this.log("RRrowInfo.RDFdatatype_DBColType=" + rRTabRowInfo.RDFdatatype_DBColType);
                                                n6 = rRTabRowInfo.RDFdatatype_DBColType.indexOf(" DB_TYPE=");
                                                String string23 = rRTabRowInfo.RDFdatatype_DBColType.substring(0, n6);
                                                String string24 = rRTabRowInfo.RDFdatatype_DBColType.substring(n6 + " DB_TYPE=".length());
                                                String string25 = string24.charAt(string24.length() - 1) == ')' ? string24.substring(0, string24.indexOf(40)) : string24;
                                                this.log("RDFdatatype=" + string23 + "*DBColType=" + string24 + NATIVE_SUFFIX + " DBColType_name=" + string25);
                                                if (bl2 && ((String)object).equals(var65_107)) {
                                                    Object object10 = null;
                                                    String string26 = "";
                                                    if (((String)object).equals("STRING")) {
                                                        object10 = "'" + ((String)object4).replace("'", "''") + "'";
                                                        object10 = TTL_UNESCAPE_BEG + (String)object10 + ")";
                                                    } else if (((String)object).equals(TYPE_FAM_NUMERIC)) {
                                                        object10 = object4;
                                                    } else if (((String)object).equals(TYPE_FAM_DATETIME)) {
                                                        if (string25.equals(LTC_TYPE_TIMESTAMP_TZ)) {
                                                            object10 = "to_TIMESTAMP_TZ('" + (String)object4 + "','" + FORMAT_TIMESTAMP_TZ + "')";
                                                        } else if (string25.equals(LTC_TYPE_TIMESTAMP)) {
                                                            object10 = "to_TIMESTAMP('" + (String)object4 + "','" + FORMAT_TIMESTAMP + "')";
                                                        } else if (string25.equals(LTC_TYPE_TIMESTAMP_LTZ)) {
                                                            this.log(string25 + ": OPTIMIZATION NOT IMPLEMENTED");
                                                        } else {
                                                            this.log(string25 + ": UNKNOWN DBColType_name: Skipping optimization");
                                                        }
                                                        this.log("rhs_expr : " + (String)object10);
                                                    } else if (((String)object).equals("DATE")) {
                                                        if (string25.equals("DATE")) {
                                                            object10 = "to_DATE('" + (String)object4 + "','" + FORMAT_DATE + "')";
                                                        } else {
                                                            this.log(string25 + ": UNKNOWN DBColType_name: Skipping optimization");
                                                        }
                                                    } else if (((String)object).equals(TYPE_FAM_FLOAT)) {
                                                        object10 = "to_BINARY_FLOAT('" + (String)object4 + "')";
                                                    } else if (((String)object).equals(TYPE_FAM_DOUBLE)) {
                                                        object10 = "to_BINARY_DOUBLE('" + (String)object4 + "')";
                                                    } else if (rRTabRowInfo.RDFdatatype_DBColType.contains("DB_TYPE=SDO_GEOMETRY")) {
                                                        void var63_81;
                                                        object10 = "sdo_rdf.getV$GeometryVal('" + string4 + "'," + (String)object7 + ")";
                                                        String string27 = null;
                                                        if (!var63_81.equals("http://www.opengis.net/ont/geosparql#wktLiteral")) {
                                                            if (!string4.substring(1, 6).equals("<gml:")) {
                                                                this.log("srid eq check skipped for obje_ltype=" + (String)var63_81 + " with unrecognized pattern: obje=" + string4);
                                                                this.log("obje[1-5]: " + string4.substring(1, 6));
                                                            } else {
                                                                int n8 = string4.indexOf(" srsName=") + " srsName=".length() + 6;
                                                                int n9 = string4.indexOf(delim, n8);
                                                                this.log("GML literal case: start_pos=" + n8 + " endPlus1_pos=" + n9);
                                                                string27 = string4.substring(n8, n9);
                                                                this.log("GML literal case: start_pos=" + n8 + " endPlus1_pos=" + n9 + " got constant: " + string27);
                                                            }
                                                        } else if (string4.charAt(1) != '<') {
                                                            string27 = DEFAULT_GEOMETRY_SRID_STR;
                                                            this.log("srid_from_lit: got default constant: " + string27);
                                                        } else {
                                                            String string28 = string4.substring(2, string4.indexOf(BASE_PREFIX_COLNAME_SEP) - 1);
                                                            if (string28.equals("http://www.opengis.net/def/crs/OGC/1.3/CRS84")) {
                                                                string27 = DEFAULT_GEOMETRY_SRID_STR;
                                                                this.log("srid_from_lit: got constant by explicit check for crs84 (avoids runtime check for this common case): " + string27);
                                                            } else if (string28.indexOf("http://xmlns.oracle.com/rdf/geo/srid/") == 0) {
                                                                string27 = string28.substring("http://xmlns.oracle.com/rdf/geo/srid/".length(), string28.length());
                                                                this.log("srid_from_lit: got constant from orageo: " + string27);
                                                            } else {
                                                                string27 = "(SELECT SRID FROM MDSYS.RDF_CRS_URI$ WHERE CRS_URI='" + string28 + "')";
                                                                this.log("srid_from_lit: will get from table: " + string27);
                                                            }
                                                        }
                                                        string26 = string27 == null ? "" : (string27.charAt(0) == '(' ? COND_CONNECTOR + (String)object7 + " = " + string27 : (string27.equals(object7) ? COND_TRUE : " AND 1=0 "));
                                                        this.log("srid_eq_cond: " + string26);
                                                    } else {
                                                        this.log((String)object + ": UNKNOWN omap_tyfam: Skipping optimization");
                                                    }
                                                    if (object10 != null) {
                                                        string16 = rRTabRowInfo.RDFdatatype_DBColType.contains("DB_TYPE=SDO_GEOMETRY") ? " AND sdo_equal(" + string8 + "," + (String)object10 + SDO_EQUAL_END + string26 : COND_CONNECTOR + string8 + "=" + (String)object10;
                                                    }
                                                }
                                                boolean bl9 = true;
                                                if (!(string25.equals("STRING") || string25.equals(LTC_TYPE_STRING_CLOB) || string25.equals("SDO_GEOMETRY"))) {
                                                    string12 = "'\"' || " + string8 + " || '\"'";
                                                }
                                                if (string16 != null) {
                                                    this.log("using optimized valuedCond=" + string16);
                                                } else if (rRTabRowInfo.oDataType.equals(XSD_DATETIME)) {
                                                    if (string25.equals(LTC_TYPE_TIMESTAMP_TZ)) {
                                                        string12 = "'\"' || ltrim(to_char(" + string8 + ",'" + FORMAT_TIMESTAMP_TZ + "'))" + " || '\"'";
                                                    } else if (string25.equals(LTC_TYPE_TIMESTAMP)) {
                                                        string12 = "'\"' || ltrim(to_char(" + string8 + ",'" + FORMAT_TIMESTAMP + "'))" + " || '\"'";
                                                    } else if (string25.equals(LTC_TYPE_TIMESTAMP_LTZ)) {
                                                        this.log(string25 + ": OPTIMIZATION NOT IMPLEMENTED");
                                                    }
                                                    string12 = string12 + " || '^^" + rRTabRowInfo.oDataType + "'";
                                                    string12 = "sdo_rdf.get_canon_val(" + string12 + ")";
                                                    this.log("oExpr for DateTime : " + string12);
                                                } else if (rRTabRowInfo.oDataType.equals(XSD_DATE)) {
                                                    if (string25.equals("DATE")) {
                                                        string12 = "'\"' || ltrim(to_char(" + string8 + ",'" + FORMAT_DATE + "'))" + " || '\"'";
                                                        this.log("[omap_tyfam=" + (String)object + " DBColType_name=" + string25 + "] => no need to do canonicalization");
                                                        bl9 = false;
                                                    }
                                                    string12 = string12 + " || '^^" + rRTabRowInfo.oDataType + "'";
                                                    if (bl9) {
                                                        string12 = "sdo_rdf.get_canon_val(" + string12 + ")";
                                                    }
                                                    this.log("oExpr for Date : " + string12);
                                                } else if (!rRTabRowInfo.oDataType.equals(XSD_STRING)) {
                                                    if ((rRTabRowInfo.oDataType.equals(XSD_FLOAT) || rRTabRowInfo.oDataType.equals(XSD_DOUBLE)) && ((this.ctx.R2RFlags & 0x10L) == 16L || (this.ctx.R2RFlags & 0x20L) == 32L)) {
                                                        string12 = "'\"' || sdo_rdf.bdouble2LexDouble(" + string8 + ")" + " || '\"'";
                                                        string12 = string12 + " || '^^" + XSD_DOUBLE + "'";
                                                    } else if (((String)object).equals(TYPE_FAM_NUMERIC) && string25.equals(LTC_TYPE_NUMBER)) {
                                                        this.log("[omap_tyfam=" + (String)object + " DBColType_name=" + string25 + "] => no need to do canonicalization");
                                                        bl9 = false;
                                                        string12 = string12 + " || '^^" + XSD_DECIMAL + "'";
                                                    } else if (((String)object).equals(TYPE_FAM_NUMERIC) && (string25.equals(LTC_TYPE_BFLOAT) || string25.equals(LTC_TYPE_BDOUBLE))) {
                                                        this.log("[omap_tyfam=" + (String)object + " DBColType_name=" + string25 + "] => use to_number(), but no need to do canonicalization");
                                                        bl9 = false;
                                                        string12 = "'\"' || to_number(" + string8 + ")" + " || '\"'" + " || '^^" + XSD_DECIMAL + "'";
                                                    } else if (string25.equals(LTC_TYPE_STRING_CLOB)) {
                                                        this.log("[omap_tyfam=" + (String)object + " DBColType_name=" + string25 + "] => do not do canonicalization");
                                                        bl9 = false;
                                                        object5 = hashMap3;
                                                        string12 = "'\"' || dbms_lob.substr(" + hashMap3 + ", " + 4000 + " - ( 2 + " + ("^^" + rRTabRowInfo.oDataType).length() + ")) || '\"^^" + rRTabRowInfo.oDataType + "'";
                                                    } else if (string25.equals("SDO_GEOMETRY")) {
                                                        this.log("[omap_tyfam=" + (String)object + " DBColType_name=" + string25 + "] => do not do canonicalization");
                                                        bl9 = false;
                                                        object5 = "(case when length(" + hashMap3 + ") + " + ("http://www.opengis.net/ont/geosparql#wktLiteral".length() + "\"\"^^<>".length()) + " <= " + 4000 + " then null else " + hashMap3 + " end)";
                                                        string12 = "'\"' || dbms_lob.substr(" + hashMap3 + ", " + 4000 + " - ( 2 + " + ("^^" + rRTabRowInfo.oDataType).length() + ")) || '\"^^" + rRTabRowInfo.oDataType + "'";
                                                    } else {
                                                        string12 = string12 + " || '^^" + rRTabRowInfo.oDataType + "'";
                                                    }
                                                    if (bl9) {
                                                        string12 = "sdo_rdf.get_canon_val(" + string12 + ")";
                                                    }
                                                } else if (string25.equals(LTC_TYPE_STRING_CLOB)) {
                                                    this.log("[omap_tyfam=" + (String)object + " DBColType_name=" + string25 + "] ");
                                                    object5 = hashMap3;
                                                    string12 = "'\"' || dbms_lob.substr(" + hashMap3 + " ," + 4000 + " - 2) || '\"'";
                                                } else if (string25.equals("SDO_GEOMETRY")) {
                                                    this.log("[omap_tyfam=" + (String)object + " DBColType_name=" + string25 + "] ");
                                                    object5 = hashMap3;
                                                    string12 = "dbms_lob.substr(" + hashMap3 + " ," + 4000 + " - 2) ";
                                                }
                                                this.log("   oExpr for DBColType_name " + string25 + " and RRrowInfo.oDataType " + rRTabRowInfo.oDataType + " : " + string12);
                                                this.log("clobExpr for DBColType_name " + string25 + " and RRrowInfo.oDataType " + rRTabRowInfo.oDataType + " : " + object5);
                                            }
                                            break block238;
                                        }
                                        if (rRTabRowInfo.oTermType.equals(rrIRI)) {
                                            charSequence2 = "U";
                                            charSequence = TTL_ESCAPE_BEG;
                                            object2 = ")";
                                            if ((this.ctx.R2RFlags & 0x200L) > 0L) {
                                                charSequence = "";
                                                object2 = "";
                                            } else if ((this.ctx.R2RFlags & 0x20000L) > 0L) {
                                                object2 = ", options=>' ESC_SBYTE_OPT=F ')";
                                            }
                                            set = (String)charSequence + string8 + (String)object2;
                                            string12 = object6 != null ? "sdo_rdf.criri('" + (String)object6 + "'," + (String)((Object)set) + ")" : "sdo_rdf.criri(NULL," + (String)((Object)set) + ")";
                                        } else {
                                            if (!rRTabRowInfo.oTermType.equals(rrBlankNode)) {
                                                this.log("pUA: EXCEPTION: unsupported oExpr for column-valued Omap: oTermType=" + rRTabRowInfo.oTermType + " oDataType=" + rRTabRowInfo.oDataType + " oLanguage=" + rRTabRowInfo.oLanguage);
                                                throw new RDFException("unsupported oExpr for column-valued Omap: oTermType=" + rRTabRowInfo.oTermType + " RR_TAB rowid=" + rRTabRowInfo.rowid);
                                            }
                                            charSequence2 = "B";
                                            string12 = "'_:' || sdo_rdf.cbnod(" + string8 + ")";
                                        }
                                    }
                                    if (!bl2) {
                                        this.log("[pUA] CALLING store_noVa_related_Info: for obje=" + string4);
                                        this.store_noVa_related_Info(rRTabRowInfo.oTFT_idx, rRTabRowInfo.Tmap, (ArrayList<String>)object9, (ArrayList<String>)object8, string4, "object:" + n, string2, null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                    }
                                    break block225;
                                }
                                if (rRTabRowInfo.psExpr != null) {
                                    block228: {
                                        this.log("debug: [refprop] RRrowInfo: (RRrowFlags=" + n4 + ")\n" + rRTabRowInfo.toString());
                                        this.log("[psExpr before processing: before adding notNullColCondExpr] condExpr: " + string10);
                                        string8 = this.RRrowFlags_for_Tmap.get(rRTabRowInfo.paTmap);
                                        this.log("paRRrowFlags_string=" + string8);
                                        int n10 = 0;
                                        if (string8 != null) {
                                            n10 = Integer.parseInt(this.RRrowFlags_for_Tmap.get(rRTabRowInfo.paTmap));
                                        }
                                        this.log("paRRrowFlags=" + n10);
                                        object6 = rRTabRowInfo.psTermType;
                                        if (object6 == null) {
                                            object6 = rrIRI;
                                        }
                                        try {
                                            if (rRTabRowInfo.psExprType == RRTabRowInfo.MapExprType_TEMPLATE) {
                                                string12 = RelationalBGP.sqlTempl2sqlExpr(rRTabRowInfo.psExpr.substring(1, rRTabRowInfo.psExpr.length() - 1), (String)object6, string14 + ".", (StringBuffer)charSequence4, (ArrayList<String>)object9, (ArrayList<String>)object8, rRTabRowInfo.psColTypeList, this.ctx);
                                                if (((String)object6).equals(rrIRI)) {
                                                    string12 = "'<'||" + string12 + "||'>'";
                                                    if (!bl2) {
                                                        this.store_noVa_related_Info(rRTabRowInfo.psTFT_idx, rRTabRowInfo.Tmap, (ArrayList<String>)object9, (ArrayList<String>)object8, string4, "object:" + n, string2, string14, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                        break block228;
                                                    }
                                                    charSequence3 = this.find_optimized_CondExpr(string4, (ArrayList<String>)object9, (ArrayList<String>)object8, string14, rRTabRowInfo.paTmap, null);
                                                    this.log("[obje in triple-pattern is constant] psCondExpr: " + string15 + " optimized_psCondExpr: " + (String)charSequence3);
                                                    if (charSequence3 != null) {
                                                        string15 = COND_CONNECTOR + (String)charSequence3;
                                                    }
                                                    break block228;
                                                }
                                                if (!rRTabRowInfo.psTermType.equals(rrBlankNode)) {
                                                    this.log("pUA: EXCEPTION: invalid psTermType=" + (String)object6 + " (RRrowInfo.psTermType=" + rRTabRowInfo.psTermType + ")");
                                                    throw new RDFException("invalid psTermType=" + (String)object6 + " RR_TAB rowid=" + rRTabRowInfo.rowid);
                                                }
                                                if ((n10 & 1) == 1) {
                                                    string12 = "'_:' || 'BlankNode' || to_char(sys_op_combined_hash(" + string12 + "), 'FMXXXXXXXXXXXXXXXX', " + "'NLS_Numeric_Characters=''.,'''" + ")";
                                                    this.log("oNotNullColCondExpr for null-col check in ref subject is being cleared: " + charSequence4);
                                                    ((StringBuffer)charSequence4).setLength(0);
                                                } else {
                                                    string12 = "'_:' || sdo_rdf.cbnod(" + string12 + ")";
                                                }
                                                if (!bl2) {
                                                    this.store_noVa_related_Info(rRTabRowInfo.psTFT_idx, rRTabRowInfo.Tmap, (ArrayList<String>)object9, (ArrayList<String>)object8, string4, "object:" + n, string2, string14, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                }
                                                break block228;
                                            }
                                            if (rRTabRowInfo.psExprType == RRTabRowInfo.MapExprType_CONSTANT) {
                                                string12 = "'" + rRTabRowInfo.psExpr + "'";
                                                if (!bl2) {
                                                    this.store_noVa_related_Info(rRTabRowInfo.psTFT_idx, rRTabRowInfo.Tmap, null, null, string4, "object:" + n, string2, null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                }
                                                break block228;
                                            }
                                            if (rRTabRowInfo.psExprType == RRTabRowInfo.MapExprType_COLUMN) {
                                                if (((String)object6).equals(rrIRI)) {
                                                    charSequence3 = TTL_ESCAPE_BEG;
                                                    object4 = ")";
                                                    if ((this.ctx.R2RFlags & 0x200L) > 0L) {
                                                        charSequence3 = "";
                                                        object4 = "";
                                                    } else if ((this.ctx.R2RFlags & 0x20000L) > 0L) {
                                                        object4 = ", options=>' ESC_SBYTE_OPT=F ')";
                                                    }
                                                    String string29 = rRTabRowInfo.psExpr;
                                                    String string30 = RelationalBGP.get_base_prefix_from_RR_table(string29);
                                                    if (string30 != null) {
                                                        String string31 = RelationalBGP.get_col_name_from_RR_table(string29);
                                                        string12 = "sdo_rdf.criri('" + string30 + "'," + (String)charSequence3 + string14 + "." + string31 + (String)object4 + ")";
                                                        ((ArrayList)object9).add(string31);
                                                        ((ArrayList)object8).add(string30);
                                                    } else {
                                                        string12 = "sdo_rdf.criri(NULL," + (String)charSequence3 + string14 + "." + string29 + (String)object4 + ")";
                                                        ((ArrayList)object9).add(rRTabRowInfo.psExpr);
                                                        ((ArrayList)object8).add("");
                                                    }
                                                    if (!bl2) {
                                                        this.store_noVa_related_Info(rRTabRowInfo.psTFT_idx, rRTabRowInfo.Tmap, (ArrayList<String>)object9, (ArrayList<String>)object8, string4, "object:" + n, string2, string14, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                    }
                                                    break block228;
                                                }
                                                if (rRTabRowInfo.psTermType.equals(rrBlankNode)) {
                                                    string12 = "'_:' ||" + string14 + "." + rRTabRowInfo.psExpr;
                                                    ((ArrayList)object9).add(rRTabRowInfo.psExpr);
                                                    ((ArrayList)object8).add("");
                                                    if (!bl2) {
                                                        this.store_noVa_related_Info(rRTabRowInfo.psTFT_idx, rRTabRowInfo.Tmap, (ArrayList<String>)object9, (ArrayList<String>)object8, string4, "object:" + n, string2, string14, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                                                    }
                                                    break block228;
                                                }
                                                this.log("pUA: EXCEPTION: invalid psTermType=" + (String)object6 + " (RRrowInfo.psTermType=" + rRTabRowInfo.psTermType + ")");
                                                break block228;
                                            }
                                            this.log("pUA: EXCEPTION: unsupported psExprType=" + rRTabRowInfo.psExprType);
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }
                                    charSequence3 = this.LtabExpr_for_Tmap.get(rRTabRowInfo.paTmap);
                                    if (charSequence3 == null) {
                                        if (rRTabRowInfo.ptabName != null) {
                                            charSequence3 = rRTabRowInfo.ptabOwner + "." + rRTabRowInfo.ptabName;
                                        } else if (rRTabRowInfo.pSqlQuery != null) {
                                            charSequence3 = "(" + rRTabRowInfo.pSqlQuery.substring(1, rRTabRowInfo.pSqlQuery.length() - 1).replaceAll("\\\\\"", "\"") + ")";
                                        } else {
                                            this.log("EXCEPTION: NULL prowsrc: RRrowInfo.tabName=" + rRTabRowInfo.ptabName + " .sqlQuery=" + rRTabRowInfo.pSqlQuery);
                                        }
                                        this.log("prowsrc=" + (String)charSequence3);
                                        this.LtabExpr_for_Tmap.put(rRTabRowInfo.paTmap, (String)charSequence3);
                                    }
                                    string11 = ", " + (String)charSequence3 + BASE_PREFIX_COLNAME_SEP + string14;
                                    if (rRTabRowInfo.refJoinStr != null) {
                                        object4 = COND_CONNECTOR + rRTabRowInfo.refJoinStr;
                                        object4 = ((String)object4).replaceAll("\\(ctab.", "\\(" + string2 + ".");
                                        object4 = ((String)object4).replaceAll(" = ptab.", " = " + string14 + ".");
                                        object4 = ((String)object4).replaceAll(" and ptab.", " and " + string14 + ".");
                                        string10 = string10 + (String)object4;
                                        this.log("[condExpr: after adding refJoinStrInst] condExpr: " + string10);
                                    }
                                }
                            }
                            if (((StringBuffer)charSequence4).length() > 0) {
                                this.log("[oExpr: before adding notNullColCondExpr] condExpr: " + string10);
                                string10 = string10 + ((StringBuffer)charSequence4).toString();
                                this.log("[oExpr: added notNullColCondExpr] condExpr: " + string10);
                            }
                            if (bl2) {
                                if (string15 != null) {
                                    string10 = string10 + string15;
                                } else if (!string12.equals("'" + string4 + "'")) {
                                    string8 = string16 == null ? (string4.charAt(0) == '<' ? COND_CONNECTOR + string12 + "='" + string4.replace("'", "''") + "'" : COND_CONNECTOR + string12 + "=sdo_rdf.get_canon_val('" + string4.replace("'", "''") + "')") : string16;
                                    string10 = string10 + string8;
                                } else {
                                    this.log("skipped TRIVIALLY TRUE value_cond with IDENTICAL lhs and rhs: oExpr=" + string12 + " (enquoted)obje=" + "'" + string4 + "'");
                                }
                            }
                            string8 = null;
                            object7 = new ArrayList();
                            object6 = new ArrayList();
                            if (this.graph_use_mode <= 0) break block239;
                            this.log("RRrowInfo.pogExpr [Type=" + rRTabRowInfo.pogExprType + "] : " + rRTabRowInfo.pogExpr);
                            charSequence3 = new StringBuffer("");
                            if (rRTabRowInfo.pogExpr != null && (rRTabRowInfo.pogExprType != RRTabRowInfo.MapExprType_CONSTANT || !rRTabRowInfo.pogExpr.equals(rrDefaultGraph))) break block240;
                            if (!bl4 || string7 == null && (this.graph_use_mode & 1) == 1) {
                                this.log("rr:graphMap is ABSENT or uses rr:defaultGraph");
                                break block229;
                            } else {
                                string8 = "NULL";
                                this.log("graphMatchUnnamed is TRUE: gExpr=" + string8 + " (rr:graphMap is ABSENT or uses rr:defaultGraph)");
                                this.store_noVa_related_Info(this.null_TFTidx, rRTabRowInfo.Tmap, null, null, string7, "graph:" + n, string2, null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                            }
                            break block229;
                        }
                        if (rRTabRowInfo.pogExprType != RRTabRowInfo.MapExprType_TEMPLATE) break block241;
                        try {
                            string8 = RelationalBGP.sqlTempl2sqlExpr(rRTabRowInfo.pogExpr.substring(1, rRTabRowInfo.pogExpr.length() - 1), rrIRI, string2 + ".", (StringBuffer)charSequence3, (ArrayList<String>)object7, (ArrayList<String>)object6, rRTabRowInfo.pogColTypeList, this.ctx);
                            string8 = "'<'||" + string8 + "||'>'";
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (this.is_bgp_graph_a_var) {
                            this.store_noVa_related_Info(rRTabRowInfo.pogTFT_idx, rRTabRowInfo.Tmap, (ArrayList<String>)object7, (ArrayList<String>)object6, string7, "graph:" + n, string2, null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                            break block229;
                        } else {
                            this.log("Not an error: but for debugging: [graph_use_mode=" + this.graph_use_mode + ": GRAPH clause absent and FROM/FROM NAMED present]:");
                            this.log("-->GraphMap is TEMPLATE: gExpr=" + string8 + " graph_use_mode=" + this.graph_use_mode + " bgp_graph=" + string7);
                        }
                        break block229;
                    }
                    if (rRTabRowInfo.pogExprType != RRTabRowInfo.MapExprType_CONSTANT) break block242;
                    if (bl3) {
                        if (rRTabRowInfo.pogExpr.equals(string7)) {
                            string8 = "'" + rRTabRowInfo.pogExpr + "'";
                            this.log("found exact match of GRAPH clause and rr:graph constants");
                            break block229;
                        } else {
                            string8 = "'0'";
                            this.log("found MISMATCH of GRAPH clause and rr:graph constants: ");
                        }
                        break block229;
                    } else if (this.is_bgp_graph_a_var) {
                        string8 = "'" + rRTabRowInfo.pogExpr + "'";
                        this.store_noVa_related_Info(rRTabRowInfo.pogTFT_idx, rRTabRowInfo.Tmap, null, null, string7, "graph:" + n, string2, null, n5, n2, n3, natVarOpt_Info, uArowNatSelectInfo2);
                        break block229;
                    } else {
                        this.log("Not an error: but for debugging: [graph_use_mode=" + this.graph_use_mode + ": GRAPH clause absent and FROM/FROM NAMED present]:");
                        this.log("-->GraphMap is CONSTANT: gExpr=" + string8 + " graph_use_mode=" + this.graph_use_mode + " bgp_graph=" + string7);
                    }
                    break block229;
                }
                if (rRTabRowInfo.pogExprType == RRTabRowInfo.MapExprType_COLUMN) {
                    throw new RDFException("Feature not supported: column-valued rr:GraphMap : " + rRTabRowInfo.pogExpr);
                }
            }
            if (((StringBuffer)charSequence3).length() > 0) {
                string10 = string10 + ((StringBuffer)charSequence3).toString();
                this.log("[gExpr: added notNullColCondExpr] condExpr: " + string10);
            }
            this.log("computed gExpr=" + string8 + " gNotNullColCondExpr=" + charSequence3);
        }
        this.log("[STARTING] predicate-var Filter Condition");
        charSequence3 = "";
        if (!bl) {
            this.log("variable in predicate-position: generating condition (if any) based on FILTER: " + string3);
            for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                this.log(relExpr.toString());
                if (relExpr.RelExprFlags == 2L) {
                    this.log("skipping GEOMETRY filter");
                    continue;
                }
                if ((relExpr.L_atom.type != 0 || !relExpr.L_atom.name.equals(string3) || relExpr.R_atom.type == 0) && (relExpr.R_atom.type != 0 || !relExpr.R_atom.name.equals(string3) || relExpr.L_atom.type == 0)) continue;
                charSequence3 = (String)charSequence3 + this.genFilterCond_new(relExpr, rRTabRowInfo, 1, string13, string2);
                this.log("condExpr_pred_filter_delta: " + (String)charSequence3);
            }
        }
        this.log("condExpr_pred_filter_delta[AFTER]: " + (String)charSequence3);
        this.log("[STARTING] object-variable Filter Condition");
        object4 = "";
        if (!bl2) {
            this.log("variable in object-position: generating condition (if any) based on FILTER: " + string4);
            this.log("Relexprfilterlist_For_Bgp.size()=" + this.RelExprFilterList_for_BGP.size());
            for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                this.log(relExpr.toString());
            }
            for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                void var65_111;
                int n11;
                this.log(relExpr.toString());
                if (relExpr.RelExprFlags != 2L && (relExpr.L_atom.type != 0 || !relExpr.L_atom.name.equals(string4) || relExpr.R_atom.type == 0) && (relExpr.R_atom.type != 0 || !relExpr.R_atom.name.equals(string4) || relExpr.L_atom.type == 0)) continue;
                int n12 = 2;
                String string32 = string2;
                if (rRTabRowInfo.psExpr != null) {
                    n11 = 4;
                    String string33 = string14;
                }
                object4 = (String)object4 + this.genFilterCond_new(relExpr, rRTabRowInfo, n11, string12, (String)var65_111);
                this.log("condExpr_obje_filter_delta: " + (String)object4);
            }
        }
        this.log("condExpr_obje_filter_delta[AFTER]: " + (String)object4);
        this.log("[STARTING] bgp_graph-var Filter Condition");
        String string34 = "";
        if (this.is_bgp_graph_a_var) {
            this.log("variable in bgp_graph-position: generating condition (if any) based on FILTER: " + string7);
            for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                this.log(relExpr.toString());
                if (relExpr.RelExprFlags == 2L) {
                    this.log("skipping GEOMETRY filter");
                    continue;
                }
                if ((relExpr.L_atom.type != 0 || !relExpr.L_atom.name.equals(string7) || relExpr.R_atom.type == 0) && (relExpr.R_atom.type != 0 || !relExpr.R_atom.name.equals(string7) || relExpr.L_atom.type == 0)) continue;
                String string35 = (String)var62_77 + this.genFilterCond_new(relExpr, rRTabRowInfo, 3, string8, string2);
                this.log("condExpr_bgp_graph_filter_delta: " + string35);
            }
        }
        this.log("condExpr_bgp_graph_filter_delta[AFTER]: " + (String)var62_77);
        bl7 = n == 0;
        bl6 = n == 0;
        bl5 = n == 0;
        this.log("UArowNatSelectInfo_tmp=" + uArowNatSelectInfo2);
        this.log("going to process GEOMETRY filters");
        String string36 = "";
        for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
            void var63_91;
            this.log("checking relExpr for GEOMETRY filter: " + relExpr.toString());
            if (relExpr.RelExprFlags != 2L) {
                this.log("pUA: skipping non-GEOMETRY filter");
                continue;
            }
            object3 = new HashSet();
            if (!bl) {
                object3.add(string3);
            }
            if (!bl2) {
                object3.add(string4);
            }
            if (this.is_bgp_graph_a_var) {
                object3.add(string7);
            }
            charSequence2 = this.genFilter_v3("TPAT_LEVEL", string2, -1, rRTabRowInfo, null, hashMap, null, relExpr, (Set<String>)object3, null, null);
            this.log("condExpr_geo :" + (String)charSequence2);
            if (((String)charSequence2).equals(" AND 1=0 ")) {
                String string37 = " AND 1=0 ";
                break;
            }
            if (((String)charSequence2).equals("")) continue;
            this.log("processed this filter at TPAT level: relExpr.procAtLevel=" + relExpr.procAtLevel);
            String string38 = (String)var63_91 + COND_CONNECTOR + (String)charSequence2;
        }
        String string39 = rRTabRowInfo.rowid;
        boolean bl10 = false;
        while (var65_115 < n3) {
            void var63_94;
            void var71_140;
            boolean bl11 = false;
            charSequence2 = "";
            charSequence = ":" + string39;
            if (bl7) {
                this.log("pUA loop: adding element [" + arrayList4.size() + "] : RRrLContent=" + (String)charSequence);
                arrayList4.add((String)charSequence);
            } else {
                this.log("pUA loop: extending RRrLArrray element " + n5 + "+" + n2 + "+" + (int)var65_115 + " appending: RRrLContent=" + (String)charSequence);
                arrayList4.set(n5 + n2 + var65_115, arrayList4.get(n5 + n2 + var65_115) + (String)charSequence);
            }
            this.log("==> writePos=" + n2 + " : idx=" + (int)var65_115 + " : UArowNatSelectInfoArray.size()=" + arrayList10.size());
            if (n5 + n2 + var65_115 < arrayList10.size()) {
                object2 = arrayList10.get(n5 + n2 + var65_115);
                ((UArowNatSelectInfo)object2).addVarInfoFrom(uArowNatSelectInfo2);
            } else {
                object2 = new UArowNatSelectInfo(uArowNatSelectInfo2);
                arrayList10.add((UArowNatSelectInfo)object2);
            }
            this.log("UArowNatSelectInfo_for_Copy=" + uArowNatSelectInfo);
            this.log("UArowNatSelectInfo_tmp=" + uArowNatSelectInfo2);
            if (bl8) {
                this.log("pUA loop: adding element [" + arrayList13.size() + "] : pExpr=" + string13);
                arrayList13.add(string13);
                if (!bl) {
                    charSequence2 = this.isVarOccMatchable_in_UArow(string3, "predicate", n, n5 + n2 + var65_115, string39, this.FullOccInfo_for_VarPlusCSRAlias.get(string3 + "+" + string2), arrayList4.get(n5 + n2 + var65_115));
                }
            }
            this.log("pUA loop: adding element [" + arrayList12.size() + "] : oExpr=" + string12);
            arrayList12.add(string12);
            arrayList11.add((String)object5);
            if (n == 0) {
                for (String string40 : hashMap2.keySet()) {
                    hashMap3 = hashMap2.get(string40);
                    object = new HashSet();
                    this.log("pUA loop: adding element [" + ((ArrayList)((Object)hashMap3)).size() + "] : (for var=" + string40 + " : native_oExprSet=EMPTY-SET");
                    ((ArrayList)((Object)hashMap3)).add(object);
                    this.log("UAstartPos=" + n5 + "[writePos+idx=" + n2 + "+" + (int)var65_115 + "] [var=" + string40 + "] : Created an empty native_oExprSet and added to native_oExprSetArray");
                }
                this.log("pUA: EXTENDED native_oExprSetArray for each native-optimizable var : Content :" + hashMap2);
            }
            if (!bl2) {
                this.log("native_oExpr=" + string9 + " :  native_oExprSetArray_for_Var.get(" + string4 + ") :" + hashMap2.get(string4));
            }
            if (string9 != null && hashMap2.get(string4) != null) {
                set = hashMap2.get(string4).get(n5 + n2 + var65_115);
                this.log("before adding to set: native_oExprSet_for_var_and_row=" + set);
                set.add(string9);
                this.log("AFTER  adding to set: native_oExprSet_for_var_and_row=" + set);
                bl11 = true;
            }
            set = "";
            if (this.graph_use_mode > 0) {
                void var71_131;
                if (this.is_bgp_graph_a_var && n == 0) {
                    this.log("po_idx=" + n + " : adding (as row: " + arrayList7.size() + ") : gExpr=" + string8);
                    arrayList7.add(string8);
                }
                Object var71_128 = null;
                if (n == 0) {
                    HashSet hashSet = new HashSet();
                    this.log("created new Gees to add to GeesArray at row number: " + arrayList8.size());
                    arrayList8.add(hashSet);
                } else {
                    HashSet<String> hashSet = arrayList8.get(n5 + n2 + var65_115);
                    this.log("retrieved Gees from GeesArray row number " + (n5 + n2 + var65_115) + " : Gees (before adding)=" + hashSet);
                }
                var71_131.add(string8);
                this.log("po_idx=" + n + " : after adding gExpr to set : Gees=" + var71_131);
                hashMap3 = null;
                if (n == 0) {
                    hashMap3 = new HashMap();
                    this.log("created new TpGE HashMap to add to TpGEArray at row number: " + arrayList9.size());
                    arrayList9.add(hashMap3);
                } else {
                    hashMap3 = arrayList9.get(n5 + n2 + var65_115);
                    this.log("retrieved TpGE from TpGEArray row number " + (n5 + n2 + var65_115) + " : TpGE (before adding)=" + hashMap3);
                }
                object = "";
                if (hashMap3.containsKey(string8)) {
                    object = (String)hashMap3.get(string8);
                }
                hashMap3.put(string8, (String)object + "+" + n);
                this.log("po_idx=" + n + " : after adding gExpr to HashMap : TpGE=" + hashMap3);
            }
            if (bl6) {
                void var71_135;
                String string41 = "";
                hashMap3 = "";
                if (string11 != null) {
                    String string42 = string11;
                    hashMap3 = "+" + n + ":" + "0";
                }
                this.log("pUA loop: adding element [" + arrayList5.size() + "] : fromContent=" + (String)var71_135);
                arrayList5.add((String)var71_135);
            } else if (string11 != null) {
                String string43 = arrayList5.get(n5 + n2 + var65_115);
                hashMap3 = string43 + string11;
                this.log("pUA loop: updating element [UAstartPos=" + n5 + "+" + n2 + "+" + (int)var65_115 + "] : fromOrigContent=" + string43 + " -> " + (String)((Object)hashMap3));
                arrayList5.set(n5 + n2 + var65_115, (String)((Object)hashMap3));
            }
            String string44 = "";
            if (!bl2 && !bl11) {
                String string45 = this.isVarOccMatchable_in_UArow(string4, "object", n, n5 + n2 + var65_115, string39, this.FullOccInfo_for_VarPlusCSRAlias.get(string4 + "+" + string2), arrayList4.get(n5 + n2 + var65_115));
            } else if (!bl2) {
                this.log("multiOccurrenceOfVar() call skipped because native_oExprSet_added");
            }
            this.log("condExpr_obje_filter_delta[START_OF_ADD_TO_CONDARRAY]: " + (String)object4);
            if (bl5) {
                hashMap3 = "";
                object = string5 + (String)((Object)hashMap3) + string10 + (String)charSequence3 + (String)object4 + (String)var62_77 + set + (String)charSequence2 + (String)var71_140 + (String)var63_94;
                this.log("[COND] 5 " + (String)object);
                this.log("pUA loop: adding element [" + arrayList6.size() + "] : condContent=" + (String)object);
                arrayList6.add((String)object);
            } else if (!arrayList6.get(n5 + n2 + var65_115).equals(" AND 1=0 ")) {
                hashMap3 = arrayList6.get(n5 + n2 + var65_115);
                this.log(" [                condOrigContent ] " + (String)((Object)hashMap3));
                this.log(" [                       condExpr ] " + string10);
                this.log(" [     condExpr_pred_filter_delta ] " + (String)charSequence3);
                this.log(" [     condExpr_obje_filter_delta ] " + (String)object4);
                this.log(" [condExpr_bgp_graph_filter_delta ] " + (String)var62_77);
                this.log(" [   condExpr_pred_multiOcc_delta ] " + (String)charSequence2);
                this.log(" [   condExpr_obje_multiOcc_delta ] " + (String)var71_140);
                this.log(" [       condExpr_geometry_filter ] " + (String)var63_94);
                if (((String)charSequence2).equals(" AND 1=0 ") || var71_140.equals(" AND 1=0 ")) {
                    object = " AND 1=0 ";
                } else {
                    object = hashMap3 + string10 + (String)charSequence3 + (String)object4 + (String)var62_77 + (String)charSequence2 + (String)var71_140;
                    if (((String)((Object)hashMap3)).indexOf((String)var63_94) == -1) {
                        object = (String)object + (String)var63_94;
                    }
                }
                this.log("pUA loop: updating element [UAstartPos=" + n5 + "+" + n2 + "+" + (int)var65_115 + "] : condOrigContent=" + hashMap3 + " -> " + (String)object);
                arrayList6.set(n5 + n2 + var65_115, (String)object);
            } else {
                this.log("pUA loop: SKIPPED updating element because it is already  AND 1=0 ");
            }
            ++var65_115;
        }
        if (!bl) {
            this.log("pUA: FINALLY : pExprArray.size()=" + arrayList13.size());
        }
        this.log("pUA: FINALLY : oExprArray.size()=" + arrayList12.size());
        this.log("pUA: FINALLY : clobExprArray.size()=" + arrayList11.size());
        if (this.graph_use_mode > 0) {
            if (this.is_bgp_graph_a_var) {
                this.log("pUA: FINALLY : gExprArray.size()=" + arrayList7.size());
            }
            this.log("pUA: FINALLY : GeesArray.size()=" + arrayList8.size());
            this.log("pUA: FINALLY : TpGEArray.size()=" + arrayList9.size());
        }
        this.log("pUA: FINALLY : fromArray.size()=" + arrayList5.size());
        this.log("pUA: FINALLY : condArray.size()=" + arrayList6.size());
        this.log("pUA: FINALLY : native_oExprSetArray_for_Var.size()=" + hashMap2.size() + " : " + hashMap2);
        this.log("EXIT populateUnionArrays: --------------------------------------------------------------------------");
    }

    String get_subStringAtIndex(String string, int n, String string2) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i <= n; ++i) {
            n3 = string.indexOf(string2, n2 + 1);
            if (n3 == -1) {
                n3 = string.length();
            }
            if (i >= n) continue;
            n2 = n3;
        }
        return string.substring(n2 + 1, n3);
    }

    String gen_e_z_filter_cond(RelExpr relExpr, boolean bl, boolean bl2) {
        String string = "";
        if (bl2 && (relExpr.compOperator.equals("<=") || relExpr.compOperator.equals(">=") || relExpr.compOperator.equals("<=") || relExpr.compOperator.equals(">="))) {
            string = " AND 1=0 ";
            this.log("gen_e_z_filter_cond (case 1): setting cond: " + string);
        } else if (relExpr.compOperator.equals("=") || relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("<=") || relExpr.compOperator.equals(">=") || relExpr.compOperator.equalsIgnoreCase("LIKE")) {
            this.log("gen_e_z_filter_cond (case 2): ");
            if (!bl) {
                string = " AND 1=0 ";
                this.log("  setting cond as COND_FALSE: " + string);
            } else {
                string = COND_TRUE;
                this.log("  setting cond as COND_TRUE: " + string);
            }
        } else {
            this.log("gen_e_z_filter_cond (case 3): ");
            if (!bl) {
                string = COND_TRUE;
                this.log("  setting cond as COND_TRUE: " + string);
            } else {
                string = " AND 1=0 ";
                this.log("  setting cond as COND_FALSE: " + string);
            }
        }
        this.log("gen_e_z_filter_cond: returning cond: " + string);
        return string;
    }

    private boolean isNumFltDbl(String string) {
        return string.equals(TYPE_FAM_NUMERIC) || string.equals(TYPE_FAM_FLOAT) || string.equals(TYPE_FAM_DOUBLE);
    }

    String gen_e_z_termType_based_cond(RelExpr relExpr, boolean bl) throws RDFException {
        String string = null;
        if (!bl) {
            return string;
        }
        if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("=") || relExpr.compOperator.equals("<") || relExpr.compOperator.equals("<=") || relExpr.compOperator.equals(">") || relExpr.compOperator.equals(">=") || relExpr.compOperator.equalsIgnoreCase("LIKE")) {
            string = " AND 1=0 ";
        } else if (relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("!=") || relExpr.compOperator.equals("NOT LIKE")) {
            string = COND_TRUE;
        }
        return string;
    }

    String gen_e_z_datatype_based_cond(RelExpr relExpr, boolean bl, boolean bl2, boolean bl3) throws RDFException {
        String string = null;
        if (!bl) {
            return string;
        }
        if (relExpr.compOperator.equals("SAMETERM")) {
            string = " AND 1=0 ";
        } else if (relExpr.compOperator.equals("DIFFTERM")) {
            string = COND_TRUE;
        }
        if (string != null) {
            return string;
        }
        if (bl3 && (relExpr.compOperator.equals("=") || relExpr.compOperator.equals("!=") || relExpr.compOperator.equals("<") || relExpr.compOperator.equals("<=") || relExpr.compOperator.equals(">") || relExpr.compOperator.equals(">="))) {
            string = " AND 1=0 ";
        }
        return string;
    }

    private static String tzone(String string) {
        if (string.charAt(string.length() - 1) == 'Z') {
            return "Z";
        }
        if (string.length() >= 11 && (string.charAt(string.length() - 6) == '+' || string.charAt(string.length() - 6) == '-')) {
            return string.substring(string.length() - 6);
        }
        return null;
    }

    int convert_comp_name_to_comp_idx(String string, String string2) throws RDFException {
        int n;
        if (string.equals("subject")) {
            n = 0;
        } else if (string.equals("predicate")) {
            n = 1;
        } else if (string.equals("object") && string2 == null) {
            n = 2;
        } else if (string.equals("graph")) {
            n = 3;
        } else if (string.equals("object") && string2 != null) {
            n = 4;
        } else {
            throw new RDFException("convert_comp_name_to_comp_idx: Internal error: Unknown comp_name=" + string);
        }
        return n;
    }

    private String compose_filter2v_opt_condExpr_for_UArow_from_occPos_pairs(RelExpr relExpr, int n, int n2, String string, String string2, ArrayList<String> arrayList, String string3) throws RDFException {
        this.log("Entering: compose_filter2v_opt_condExpr_for_UArow_from_occPos_pairs");
        String string4 = relExpr.compOperator;
        if (relExpr.eqBasedComp) {
            string4 = "=";
        }
        String string5 = string.substring(0, string.indexOf(58));
        int n3 = Integer.parseInt(string.substring(string.indexOf(58) + 1, string.length()));
        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(arrayList.get(n3));
        int n4 = this.convert_comp_name_to_comp_idx(string5, rRTabRowInfo.paTmap);
        ArrayList<String> arrayList2 = rRTabRowInfo.colLists.get(n4);
        String string6 = string3;
        if (n4 == 4) {
            string6 = "P" + n3;
        }
        this.log("L_pos_in_tp: " + string5 + " : L_po_idx=" + n3 + " : L_alias=" + string6 + " : L_colList=" + arrayList2);
        String string7 = string2.substring(0, string2.indexOf(58));
        int n5 = Integer.parseInt(string2.substring(string2.indexOf(58) + 1, string2.length()));
        RRTabRowInfo rRTabRowInfo2 = this.RRrowInfo_for_MatchingRow.get(arrayList.get(n5));
        int n6 = this.convert_comp_name_to_comp_idx(string7, rRTabRowInfo2.paTmap);
        ArrayList<String> arrayList3 = rRTabRowInfo2.colLists.get(n6);
        String string8 = string3;
        if (n6 == 4) {
            string8 = "P" + n5;
        }
        this.log("R_pos_in_tp: " + string7 + " : R_po_idx=" + n5 + " : R_alias=" + string8 + " : R_colList=" + arrayList3);
        TFTinfo tFTinfo = this.TFTinfoGlobalList.get(n);
        ArrayList<String> arrayList4 = tFTinfo.colTypeList;
        TFTinfo tFTinfo2 = this.TFTinfoGlobalList.get(n2);
        ArrayList<String> arrayList5 = tFTinfo2.colTypeList;
        String string9 = "";
        this.log("L_TFTobj: " + tFTinfo.toString());
        this.log("R_TFTobj: " + tFTinfo2.toString());
        this.log("L_RRrowInfo: " + rRTabRowInfo.toString());
        this.log("R_RRrowInfo: " + rRTabRowInfo2.toString());
        this.log("loop thru each col in L_colList: " + arrayList2 + " ...");
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string10 = null;
            String string11 = null;
            if (tFTinfo.exprType == RRTabRowInfo.MapExprType_COLUMN) {
                string10 = tFTinfo.colTypeList.get(0);
            }
            this.log("L_DBColType_name: " + string10);
            if (tFTinfo2.exprType == RRTabRowInfo.MapExprType_COLUMN) {
                string11 = tFTinfo2.colTypeList.get(0);
            }
            this.log("R_DBColType_name: " + string11);
            String string12 = string6 + "." + arrayList2.get(i);
            String string13 = string8 + "." + arrayList3.get(i);
            if (n != n2) {
                String string14 = tFTinfo.datatype_family;
                String string15 = tFTinfo2.datatype_family;
                if (tFTinfo.exprType == RRTabRowInfo.MapExprType_COLUMN && tFTinfo2.exprType == RRTabRowInfo.MapExprType_COLUMN && string14 != null && string15 != null && (string14.equals(TYPE_FAM_NUMERIC) || string14.equals(TYPE_FAM_FLOAT) || string14.equals(TYPE_FAM_DOUBLE)) && (string15.equals(TYPE_FAM_NUMERIC) || string15.equals(TYPE_FAM_FLOAT) || string15.equals(TYPE_FAM_DOUBLE))) {
                    String string16 = tFTinfo.colTypeList.get(i);
                    String string17 = tFTinfo2.colTypeList.get(i);
                    this.log("mapping-pair: column-column | colType-pair=" + string16 + "-" + string17 + " | datatye_families: " + string14 + "-" + string15);
                    if (string14.equals(TYPE_FAM_FLOAT) && !string16.equals(LTC_TYPE_BFLOAT)) {
                        string12 = "to_binary_float(to_char(" + string12 + "))";
                    } else if (string14.equals(TYPE_FAM_DOUBLE) && !string16.equals(LTC_TYPE_BDOUBLE)) {
                        string12 = "to_binary_double(to_char(" + string12 + "))";
                    } else if (string14.equals(TYPE_FAM_NUMERIC) && !string16.equals(LTC_TYPE_NUMBER)) {
                        string12 = "to_number(" + string12 + ")";
                    } else {
                        this.log("L_colType matches L_datatype_family: L_colExpr=" + string12);
                    }
                    if (string15.equals(TYPE_FAM_FLOAT) && !string17.equals(LTC_TYPE_BFLOAT)) {
                        string13 = "to_binary_float(to_char(" + string13 + "))";
                    } else if (string15.equals(TYPE_FAM_DOUBLE) && !string17.equals(LTC_TYPE_BDOUBLE)) {
                        string13 = "to_binary_double(to_char(" + string13 + "))";
                    } else if (string15.equals(TYPE_FAM_NUMERIC) && !string17.equals(LTC_TYPE_NUMBER)) {
                        string13 = "to_number(" + string13 + ")";
                    } else {
                        this.log("R_colType matches R_datatype_family: R_colExpr=" + string13);
                    }
                    if (!string14.equals(string15)) {
                        if (string14.equals(TYPE_FAM_NUMERIC)) {
                            string13 = "to_number(" + string13 + ")";
                        } else if (string15.equals(TYPE_FAM_NUMERIC)) {
                            string12 = "to_number(" + string12 + ")";
                        } else {
                            string12 = "to_number(" + string12 + ")";
                            string13 = "to_number(" + string13 + ")";
                        }
                        this.log("L_colExpr=" + string12 + " | R_colExpr=" + string13);
                    }
                } else {
                    if (!arrayList4.get(i).equals("STRING") && !LTC_TYPE_STRING_CLOB.equals(string10)) {
                        string12 = "to_char(" + string12 + ")";
                    }
                    if (!arrayList5.get(i).equals("STRING") && !LTC_TYPE_STRING_CLOB.equals(string11)) {
                        string13 = "to_char(" + string13 + ")";
                    }
                    this.log("L_colExpr=" + string12 + " | R_colExpr=" + string13);
                }
            }
            if (LTC_TYPE_STRING_CLOB.equals(string10) || LTC_TYPE_STRING_CLOB.equals(string11)) {
                this.log("Filter contains a CLOB");
                string9 = string9 + " AND dbms_lob.compare(" + string12 + ", " + string13 + ")" + sqlcompOper_clobCompare_map.get(string4);
                continue;
            }
            string9 = string9 + COND_CONNECTOR + string12 + BASE_PREFIX_COLNAME_SEP + string4 + BASE_PREFIX_COLNAME_SEP + string13;
        }
        if (string9.equals("")) {
            string9 = this.gen_e_z_filter_cond(relExpr, true, false);
        } else if (relExpr.compOperator.equals("!=") || relExpr.compOperator.equals("DIFFTERM")) {
            string9 = " AND NOT (" + string9.substring(COND_CONNECTOR.length()) + ")";
        }
        this.log("genFilter2vCond_new: returning opt_simcongTFT_filter2v_cond_delta:" + string9);
        return string9;
    }

    private String compose_filter2v_nonOpt_condExpr_for_UArow_from_occPos_pairs(int n, RelExpr relExpr, String string, String string2, String string3, int n2, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2, ArrayList<ArrayList<String>> arrayList3, ArrayList<String> arrayList4) throws RDFException {
        String string4;
        int n3;
        String string5;
        String string6 = this.getExprFromArrays(string, n, string3, arrayList, arrayList2, arrayList4, null);
        String string7 = this.getExprFromArrays(string2, n, string3, arrayList, arrayList2, arrayList4, null);
        String string8 = relExpr.compOperator;
        if (string8.equals("SAMETERM")) {
            string8 = "=";
        } else if (string8.equals("DIFFTERM")) {
            string8 = "!=";
        }
        boolean bl = false;
        boolean bl2 = false;
        if (string.startsWith("object:") && !(string5 = arrayList3.get(n3 = Integer.parseInt(string.substring(string.indexOf(58) + 1, string.length()))).get(n)).equals("NULL")) {
            bl = true;
            string6 = string5;
            this.log("non_opt_filter2v_cond_delta: found L_clobExpr: " + string5);
        }
        if (string2.startsWith("object:") && !(string5 = arrayList3.get(n3 = Integer.parseInt(string2.substring(string2.indexOf(58) + 1, string2.length()))).get(n)).equals("NULL")) {
            bl2 = true;
            string7 = string5;
            this.log("non_opt_filter2v_cond_delta: found R_clobExpr: " + string5);
        }
        if (!string8.equals("=") && !string8.equals("!=")) {
            if (string6.indexOf("sdo_rdf.escape_rdf_value") != -1) {
                string6 = TTL_UNESCAPE_BEG + string6 + ")";
            } else if (string6.indexOf("sdo_rdf.escape_clob_value") != -1) {
                string6 = TTL_UNESCAPE_CLOB_BEG + string6 + ")";
            }
            if (string7.indexOf("sdo_rdf.escape_rdf_value") != -1) {
                string7 = TTL_UNESCAPE_BEG + string7 + ")";
            } else if (string7.indexOf("sdo_rdf.escape_clob_value") != -1) {
                string7 = TTL_UNESCAPE_CLOB_BEG + string7 + ")";
            }
        }
        if (bl || bl2) {
            if (!bl) {
                string6 = "substr(" + string6 + ",2,length(" + string6 + ")-2)";
            } else if (!bl2) {
                string7 = "substr(" + string7 + ",2,length(" + string7 + ")-2)";
            }
            string4 = " AND dbms_lob.compare(" + string6 + ", " + string7 + ")" + sqlcompOper_clobCompare_map.get(string8);
        } else {
            string4 = " AND sdo_rdf.vname(" + string6 + ")" + BASE_PREFIX_COLNAME_SEP + string8 + BASE_PREFIX_COLNAME_SEP + SDO_RDF_VNAME_BEG + string7 + ")";
        }
        this.log("genFilter2vCond_new: returning non_opt_filter2v_cond_delta=" + string4);
        return string4;
    }

    private HashMap<Integer, HashSet<String>> add_subj_to_TFTidx_occInfoSet_pairs(String string, String string2, int n, HashMap<Integer, HashSet<String>> hashMap) {
        HashMap<Integer, HashSet<String>> hashMap2 = hashMap;
        if (string2.equals(string)) {
            this.log("need to add subject occinfo for var=" + string);
            hashMap2 = new HashMap();
            boolean bl = false;
            if (hashMap != null) {
                for (Integer n2 : hashMap.keySet()) {
                    HashSet<String> hashSet = new HashSet<String>();
                    hashMap2.put(n2, hashSet);
                    if (n2 == n) {
                        hashSet.add("subject:0");
                        bl = true;
                    }
                    for (String string3 : hashMap.get(n2)) {
                        hashSet.add(string3);
                    }
                }
            }
            if (!bl) {
                HashSet hashSet = new HashSet();
                hashMap2.put(n, hashSet);
                hashSet.add("subject:0");
                bl = true;
            }
        }
        return hashMap2;
    }

    private String genFilter2vCond_new_v2(int n, RelExpr relExpr, HashMap<Integer, HashSet<String>> hashMap, HashMap<Integer, HashSet<String>> hashMap2, String string, String string2, int n2, String string3, int n3, RRTabRowInfo rRTabRowInfo, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2, ArrayList<String> arrayList3, String string4) throws RDFException {
        int n4;
        this.log("Entered: genFilter2vCond_new_v2: UArowNum=" + n + " common_subj=" + string2 + " sTFT_idx=" + n2);
        String string5 = null;
        String string6 = relExpr.compOperator;
        String string7 = relExpr.compOperator;
        if (relExpr.compOperator.equals("SAMETERM")) {
            string7 = "=";
        } else if (relExpr.compOperator.equals("DIFFTERM")) {
            string7 = "!=";
        }
        String[] stringArray = string.substring(1, string.length()).split(":");
        ArrayList<String> arrayList4 = new ArrayList<String>(Arrays.asList(stringArray));
        this.log("genFilter2vCond_new: RRrL_as_ArrayList: " + arrayList4.toString());
        String string8 = relExpr.L_atom.name;
        String string9 = relExpr.R_atom.name;
        this.log("Lvar=" + string8 + " Rvar=" + string9);
        HashMap<Integer, HashSet<String>> hashMap3 = null;
        HashMap<Integer, HashSet<String>> hashMap4 = null;
        hashMap3 = this.add_subj_to_TFTidx_occInfoSet_pairs(string8, string2, n2, hashMap);
        hashMap4 = this.add_subj_to_TFTidx_occInfoSet_pairs(string9, string2, n2, hashMap2);
        this.log("Lvar_TFTidx_occInfoSet_pairs: " + hashMap3.keySet());
        this.log("Rvar_TFTidx_occInfoSet_pairs: " + hashMap4.keySet());
        this.log("Lvar_TFTidx_occInfoSet_pairs=" + hashMap3);
        this.log("Rvar_TFTidx_occInfoSet_pairs=" + hashMap4);
        TFTinfo tFTinfo = null;
        TFTinfo tFTinfo2 = null;
        Object object = hashMap3.keySet().iterator();
        while (object.hasNext()) {
            n4 = object.next();
            tFTinfo = this.TFTinfoGlobalList.get(n4);
            if (tFTinfo.numCols != 0) continue;
            break;
        }
        object = hashMap4.keySet().iterator();
        while (object.hasNext()) {
            n4 = object.next();
            tFTinfo2 = this.TFTinfoGlobalList.get(n4);
            if (tFTinfo2.numCols != 0) continue;
            break;
        }
        this.log("comparing:\nL_TFTinfo=" + tFTinfo.toString() + "\nR_TFTinfo=" + tFTinfo2.toString());
        if (!tFTinfo.termType.equals(tFTinfo2.termType)) {
            this.log("termType mismatch in two-var filter");
            if (string6.equals("!=") || string6.equals("DIFFTERM")) {
                this.log("termType mismatch: compOperator=" + string6 + ": returning COND_TRUE ");
                return COND_TRUE;
            }
            this.log("termType mismatch: compOperator=" + string6 + ": returning COND_FALSE ");
            return " AND 1=0 ";
        }
        if (tFTinfo.termType.equals(rrIRI)) {
            this.log("termType mismatch in two-var filter");
            if (string6.equals("=") || string6.equals("SAMETERM") || string6.equals("!=") || string6.equals("DIFFTERM")) {
                this.log("both termTypes are URIs: compOperator= \"" + string6 + "\": is allowed ");
            } else {
                this.log("both termTypes are URIs: compOperator= \"" + string6 + "\": CANNOT BE MATCHED: returning COND_FALSE ");
                return " AND 1=0 ";
            }
        }
        object = null;
        TFTinfo tFTinfo3 = null;
        TFTinfo tFTinfo4 = null;
        HashSet<String> hashSet = null;
        boolean bl = false;
        if (tFTinfo2.numCols == 0) {
            if (tFTinfo.numCols == 0) {
                this.log("found the both-constant mapping case for L and R variables");
                string5 = string6.equals("!=") || string6.equals("DIFFTERM") ? (tFTinfo.strList.get(0).equals(tFTinfo2.strList.get(0)) ? " AND 1=0 " : COND_TRUE) : (string6.equals("=") || string6.equals("SAMETERM") ? (tFTinfo.strList.get(0).equals(tFTinfo2.strList.get(0)) ? COND_TRUE : " AND 1=0 ") : " AND sdo_rdf.tuesc('" + tFTinfo.strList.get(0) + "')" + BASE_PREFIX_COLNAME_SEP + string7 + BASE_PREFIX_COLNAME_SEP + "sdo_rdf.tuesc('" + tFTinfo2.strList.get(0) + "')" + BASE_PREFIX_COLNAME_SEP);
                this.log("both-constant mapping case: returning condExpr: " + string5);
                return string5;
            }
            tFTinfo4 = tFTinfo2;
            object = relExpr.L_atom;
            tFTinfo3 = tFTinfo;
            hashSet = hashMap3.get(tFTinfo3.TFTidx);
        } else if (tFTinfo.numCols == 0) {
            bl = true;
            tFTinfo4 = tFTinfo;
            object = relExpr.R_atom;
            tFTinfo3 = tFTinfo2;
            hashSet = hashMap4.get(tFTinfo3.TFTidx);
        }
        if (hashSet != null) {
            RRTabRowInfo rRTabRowInfo2;
            String string10 = null;
            Iterator iterator = hashSet.iterator();
            if (iterator.hasNext()) {
                String string11;
                string10 = string11 = (String)iterator.next();
            }
            iterator = string10.substring(0, string10.indexOf(58));
            int n5 = Integer.parseInt(string10.substring(string10.indexOf(58) + 1, string10.length()));
            int n6 = -1;
            if (((String)((Object)iterator)).equals("subject")) {
                rRTabRowInfo2 = rRTabRowInfo;
                n6 = 0;
            } else {
                rRTabRowInfo2 = this.RRrowInfo_for_MatchingRow.get(arrayList4.get(n5));
                if (((String)((Object)iterator)).equals("predicate")) {
                    n6 = 1;
                } else if (((String)((Object)iterator)).equals("object")) {
                    n6 = rRTabRowInfo2.paTmap != null ? 4 : 2;
                } else if (((String)((Object)iterator)).equals("graph")) {
                    n6 = 3;
                }
            }
            ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
            aSTTripleAtom.name = tFTinfo4.strList.get(0);
            if (tFTinfo4.termType.equals(rrIRI)) {
                aSTTripleAtom.type = 1;
            } else if (tFTinfo4.termType.equals(rrBlankNode)) {
                aSTTripleAtom.type = 10;
            } else if (tFTinfo4.termType.equals(rrLiteral)) {
                if (tFTinfo4.datatype_family.equals("STRING")) {
                    if (tFTinfo4.language == null) {
                        aSTTripleAtom.type = 3;
                    } else {
                        aSTTripleAtom.litLang = tFTinfo4.language;
                        aSTTripleAtom.type = 4;
                    }
                } else if (tFTinfo4.datatype_family.equals(TYPE_FAM_NUMERIC) || tFTinfo4.datatype_family.equals(TYPE_FAM_FLOAT) || tFTinfo4.datatype_family.equals(TYPE_FAM_DOUBLE)) {
                    aSTTripleAtom.litType = tFTinfo4.datatype.substring(1, tFTinfo4.datatype.length() - 1);
                    aSTTripleAtom.type = 2;
                } else {
                    aSTTripleAtom.litType = tFTinfo4.datatype.substring(1, tFTinfo4.datatype.length() - 1);
                    aSTTripleAtom.type = 5;
                }
            }
            this.log("constructed term_atom: " + aSTTripleAtom.toString());
            RelExpr relExpr2 = null;
            if (bl) {
                relExpr2 = new RelExpr(aSTTripleAtom, relExpr.compOperator, (ASTTripleAtom)object, relExpr.filterExprTree, 1L);
                relExpr2.InvertRelExpr();
            } else {
                relExpr2 = new RelExpr((ASTTripleAtom)object, relExpr.compOperator, aSTTripleAtom, relExpr.filterExprTree, 1L);
            }
            String string12 = this.getExprFromArrays(string10, n, string3, arrayList, arrayList2, arrayList3, null);
            this.log("sqlExpr: " + string12);
            string5 = this.genFilterCond_new(relExpr2, rRTabRowInfo2, n6, string12, string4);
            this.log("condExpr=" + string5);
            return string5;
        }
        return "DUMMY";
    }

    private String genFilter2vCond_new(int n, RelExpr relExpr, HashMap<Integer, HashSet<String>> hashMap, HashMap<Integer, HashSet<String>> hashMap2, String string, String string2, int n2, String string3, int n3, RRTabRowInfo rRTabRowInfo, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2, ArrayList<ArrayList<String>> arrayList3, ArrayList<String> arrayList4, String string4) throws RDFException {
        Object object;
        Object object2;
        TFTinfo tFTinfo;
        Object object3;
        Object object4;
        Iterator<String> iterator;
        String string5;
        Iterator<String> iterator2;
        int n4;
        Object object5;
        String string6;
        int n5;
        Object object6;
        int n6;
        HashSet<Integer> hashSet;
        this.log("Entered: genFilter2vCond_new: UArowNum=" + n + " common_subj=" + string2 + " sTFT_idx=" + n2);
        String[] stringArray = string.substring(1, string.length()).split(":");
        ArrayList<String> arrayList5 = new ArrayList<String>(Arrays.asList(stringArray));
        this.log("genFilter2vCond_new: RRrL_as_ArrayList: " + arrayList5.toString());
        String string7 = relExpr.L_atom.name;
        String string8 = relExpr.R_atom.name;
        this.log("Lvar=" + string7 + " Rvar=" + string8);
        HashMap<Integer, HashSet<String>> hashMap3 = null;
        HashMap<Integer, HashSet<String>> hashMap4 = null;
        hashMap3 = this.add_subj_to_TFTidx_occInfoSet_pairs(string7, string2, n2, hashMap);
        hashMap4 = this.add_subj_to_TFTidx_occInfoSet_pairs(string8, string2, n2, hashMap2);
        this.log("Lvar_TFTidx_occInfoSet_pairs: " + hashMap3.keySet());
        this.log("Rvar_TFTidx_occInfoSet_pairs: " + hashMap4.keySet());
        this.log("Lvar_TFTidx_occInfoSet_pairs=" + hashMap3);
        this.log("Rvar_TFTidx_occInfoSet_pairs=" + hashMap4);
        boolean bl = true;
        boolean bl2 = false;
        String string9 = "";
        String string10 = "";
        Object object7 = hashMap3.keySet().iterator();
        if (object7.hasNext()) {
            int n7 = object7.next();
            this.log("TFTglobalList=" + this.TFTglobalList);
            hashSet = this.TFTglobalList.get(n7);
            TFTinfo tFTinfo2 = this.TFTinfoGlobalList.get(n7);
            n6 = ((String)((Object)hashSet)).charAt(0);
            object6 = hashMap4.keySet().iterator();
            if (object6.hasNext()) {
                n5 = object6.next();
                string6 = this.TFTglobalList.get(n5);
                object5 = this.TFTinfoGlobalList.get(n5);
                n4 = string6.charAt(0);
                this.log("comparing: L_TFT=" + hashSet + " R_TFT=" + string6);
                this.log("comparing:\n L_TFTinfo=" + tFTinfo2.toString() + "\n R_TFTinfo=" + ((TFTinfo)object5).toString());
                this.log("relExpr.eqBasedComp=" + relExpr.eqBasedComp);
                if (!relExpr.eqBasedComp) {
                    this.log("// *CASE: compOperator is in {>, >=, <, <=}");
                    if (n6 != n4 || n6 == 85 && n4 == 85) {
                        this.log("  not-comparable: because of distinct termType letters or both are URIs: " + (char)n6 + " vs. " + (char)n4);
                        bl = false;
                        bl2 = true;
                        return this.gen_e_z_termType_based_cond(relExpr, true);
                    }
                    string9 = ((String)((Object)hashSet)).substring(2, ((String)((Object)hashSet)).indexOf(32));
                    string10 = string6.substring(2, string6.indexOf(32));
                    iterator2 = tFTinfo2.termType;
                    if (!(!((String)((Object)iterator2)).equals(rrLiteral) || tFTinfo2.datatype_family.equals(((TFTinfo)object5).datatype_family) || this.isNumFltDbl(tFTinfo2.datatype_family) && this.isNumFltDbl(((TFTinfo)object5).datatype_family))) {
                        this.log("  not-comparable: because of distinct non-compatible datatype_family");
                        bl = false;
                        bl2 = true;
                        return this.gen_e_z_datatype_based_cond(relExpr, true, true, true);
                    }
                } else {
                    this.log("// *CASE: compOperator is in {=,!=, SAMETERM, !SAMETERM}");
                    if (((String)((Object)hashSet)).charAt(0) == 'L') {
                        string9 = ((String)((Object)hashSet)).substring(2, ((String)((Object)hashSet)).indexOf(32));
                        string10 = string6.substring(2, string6.indexOf(32));
                        this.log("L_datatype_family=" + string9 + " R_datatype_family=" + string10);
                        if (!string9.equals(string10)) {
                            if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DiFFTERM")) {
                                String string11 = relExpr.compOperator.equals("SAMETERM") ? " AND 1=0 " : COND_TRUE;
                                return string11;
                            }
                            if ((relExpr.compOperator.equals("=") || relExpr.compOperator.equals("!=")) && (tFTinfo2.datatype_family.equals(TYPE_FAM_NUMERIC) || tFTinfo2.datatype_family.equals(TYPE_FAM_FLOAT) || tFTinfo2.datatype_family.equals(TYPE_FAM_DOUBLE)) && (((TFTinfo)object5).datatype_family.equals(TYPE_FAM_NUMERIC) || ((TFTinfo)object5).datatype_family.equals(TYPE_FAM_FLOAT) || ((TFTinfo)object5).datatype_family.equals(TYPE_FAM_DOUBLE))) {
                                bl = true;
                                bl2 = false;
                            } else {
                                bl = false;
                                if (!relExpr.eqBasedComp) {
                                    bl2 = true;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!bl) {
            this.log("NOT-MATCHABLE: possible notComparable? " + bl2);
            return this.gen_e_z_filter_cond(relExpr, bl, bl2);
        }
        object7 = null;
        String string12 = null;
        hashSet = new HashSet();
        this.log("L_datatype_family=" + string9 + " R_datatype_family=" + string10);
        hashSet = new HashSet<Integer>(hashMap3.keySet());
        hashSet.retainAll(hashMap4.keySet());
        this.log("common_TFTidx_set    =" + hashSet);
        if (hashSet.size() > 0) {
            int n8 = -1;
            Object object8 = hashSet.iterator();
            while (object8.hasNext()) {
                int n9 = (Integer)object8.next();
                String string13 = this.TFTglobalList.get(n9);
                this.log("common_TFT=" + string13);
                if (string13.charAt(1) == RRTabRowInfo.MapExprType_CONSTANT.intValue()) {
                    return this.gen_e_z_filter_cond(relExpr, true, false);
                }
                if (n8 != -1) continue;
                n8 = n9;
            }
            this.log("chosen_TFTidx    =" + n8);
            object8 = hashMap3.get(n8).iterator();
            if (object8.hasNext()) {
                object7 = object6 = (String)object8.next();
                Iterator<String> iterator3 = hashMap4.get(n8).iterator();
                if (iterator3.hasNext()) {
                    string12 = string6 = iterator3.next();
                }
            }
            this.log("COMMON-TFT case: chosen_L_occInfo=" + (String)object7 + " chosen_R_occInfo=" + string12);
            this.log("TFTinfoGlobalList.get(chosen_TFTidx)=" + this.TFTinfoGlobalList.get(n8));
            this.log("TFTinfoGlobalList.get(chosen_TFTidx).ieq_optimizable=" + this.TFTinfoGlobalList.get((int)n8).ieq_optimizable);
            this.log("relExpr.compOperator=" + relExpr.compOperator);
            if (!relExpr.eqBasedComp && !this.TFTinfoGlobalList.get((int)n8).ieq_optimizable || relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM")) {
                object8 = this.compose_filter2v_nonOpt_condExpr_for_UArow_from_occPos_pairs(n, relExpr, (String)object7, string12, string3, n3, arrayList, arrayList2, arrayList3, arrayList4);
                this.log("COMMON-TFT case: nonOpt cond: " + (String)object8);
                return object8;
            }
            object8 = this.compose_filter2v_opt_condExpr_for_UArow_from_occPos_pairs(relExpr, n8, n8, (String)object7, string12, arrayList5, string4);
            this.log("COMMON-TFT case: opt cond: " + (String)object8);
            return object8;
        }
        this.log("no common TFTs: " + hashMap3.keySet().size() + " and " + hashMap4.keySet().size());
        n6 = 9999;
        int n10 = 0;
        n5 = -1;
        int n11 = -1;
        this.log("noTFTglobalList=" + this.noTFTglobalList);
        object5 = hashMap3.keySet().iterator();
        while (object5.hasNext()) {
            n4 = (Integer)object5.next();
            iterator2 = this.TFTglobalList.get(n4);
            string5 = this.noTFTglobalList.get(n4);
            iterator = hashMap4.keySet().iterator();
            while (iterator.hasNext()) {
                int n12 = iterator.next();
                object4 = this.TFTglobalList.get(n12);
                String string14 = this.noTFTglobalList.get(n12);
                this.log("comparing noTFTs: L_noTFT=" + string5 + " R_noTFT=" + string14);
                if (!string5.equals(string14)) {
                    this.log("ENTER_HERE");
                    continue;
                }
                this.log("found a matching pair of noTFTs: similar_TFT_pairs_cnt=" + ++n10);
                object3 = this.TFTinfoGlobalList.get(n4);
                tFTinfo = this.TFTinfoGlobalList.get(n12);
                object2 = ((TFTinfo)object3).colTypeList;
                object = tFTinfo.colTypeList;
                int n13 = ((ArrayList)object2).size();
                int n14 = 0;
                for (int i = 0; i < n13; ++i) {
                    String string15;
                    String string16 = (String)((ArrayList)object2).get(i);
                    if (string16.equals(string15 = (String)((ArrayList)object).get(i))) continue;
                    ++n14;
                    if (string16.equals("STRING") || string15.equals("STRING") || (string16.equals(LTC_TYPE_NUMBER) || string16.equals(LTC_TYPE_BFLOAT) || string16.equals(LTC_TYPE_BDOUBLE)) && (string15.equals(LTC_TYPE_NUMBER) || string15.equals(LTC_TYPE_BFLOAT) || string15.equals(LTC_TYPE_BDOUBLE))) continue;
                    this.log("NOT-MATCHABLE: both NON-STRING and not-NFD-NFD: (" + string16 + "," + string15 + ")");
                    return this.gen_e_z_filter_cond(relExpr, false, false);
                }
                if (n13 + n14 >= n6) continue;
                n5 = n4;
                n11 = n12;
                n6 = n13 + n14;
            }
        }
        if (n10 > 0) {
            this.log("generate condition from occInfo for SIMILAR TFTs: min_L_TFTidx=" + n5 + " min_R_TFTidx=" + n11);
            object5 = hashMap3.get(n5).iterator();
            if (object5.hasNext()) {
                String string17 = object5.next();
                object7 = string17;
                iterator2 = hashMap4.get(n11).iterator();
                if (iterator2.hasNext()) {
                    string12 = string5 = iterator2.next();
                }
            }
            this.log("SIMILAR-TFT case: chosen_L_occInfo=" + (String)object7 + " chosen_R_occInfo=" + string12);
            object5 = this.TFTinfoGlobalList.get(n5);
            TFTinfo tFTinfo3 = this.TFTinfoGlobalList.get(n11);
            if (!(relExpr.eqBasedComp || this.noTFTglobalList.get(n5).equals(this.noTFTglobalList.get(n11)) && ((TFTinfo)object5).ieq_optimizable && tFTinfo3.ieq_optimizable)) {
                iterator2 = this.compose_filter2v_nonOpt_condExpr_for_UArow_from_occPos_pairs(n, relExpr, (String)object7, string12, string3, n3, arrayList, arrayList2, arrayList3, arrayList4);
                this.log("SIMILAR-TFT case: nonOpt cond: " + (String)((Object)iterator2));
                return iterator2;
            }
            this.log("optimized similar TFTs case");
            iterator2 = this.compose_filter2v_opt_condExpr_for_UArow_from_occPos_pairs(relExpr, n5, n11, (String)object7, string12, arrayList5, string4);
            this.log("SIMILAR-TFT case: opt cond: " + (String)((Object)iterator2));
            return iterator2;
        }
        bl = true;
        int n15 = -1;
        n4 = -1;
        iterator2 = hashMap3.keySet().iterator();
        while (iterator2.hasNext()) {
            int n16 = (Integer)iterator2.next();
            iterator = this.TFTglobalList.get(n16);
            TFTinfo tFTinfo4 = this.TFTinfoGlobalList.get(n16);
            object4 = hashMap4.keySet().iterator();
            while (object4.hasNext()) {
                int n17 = (Integer)object4.next();
                object3 = this.TFTglobalList.get(n17);
                tFTinfo = this.TFTinfoGlobalList.get(n17);
                this.log("comparing: L_TFT=" + iterator + " R_TFT=" + (String)object3);
                if (tFTinfo4.exprType == RRTabRowInfo.MapExprType_CONSTANT && tFTinfo.exprType == RRTabRowInfo.MapExprType_CONSTANT) {
                    bl = false;
                    this.log("Two non-equal constant-valued mappings => NOT-MATCHABLE");
                    return this.gen_e_z_filter_cond(relExpr, bl, false);
                }
                object2 = "";
                object = "";
                if (n15 == -1) {
                    n15 = n16;
                }
                if (n4 != -1) continue;
                n4 = n17;
            }
        }
        this.log("Non-similar TFTs: chosen_L_TFTidx=" + n15 + " chosen_R_TFTidx=" + n4);
        iterator2 = hashMap3.get(n15).iterator();
        if (iterator2.hasNext()) {
            String string18 = iterator2.next();
            object7 = string18;
            iterator = hashMap4.get(n4).iterator();
            if (iterator.hasNext()) {
                String string19;
                string12 = string19 = iterator.next();
            }
        }
        this.log("Non-similar TFTs: chosen_L_occInfo=" + (String)object7 + " chosen_R_occInfo=" + string12);
        iterator2 = this.compose_filter2v_nonOpt_condExpr_for_UArow_from_occPos_pairs(n, relExpr, (String)object7, string12, string3, n3, arrayList, arrayList2, arrayList3, arrayList4);
        this.log("genFilter2vCond_new: returning non_opt_filter2v_cond_delta=" + (String)((Object)iterator2));
        return iterator2;
    }

    private String genFilter_v3(String string, String string2, int n, RRTabRowInfo rRTabRowInfo, String string3, HashMap<String, String> hashMap, NatVarOpt_Info natVarOpt_Info, RelExpr relExpr, Set<String> set, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2) throws RDFException {
        if (string.equals("TPAT_LEVEL")) {
            this.log("[GFV3 genFilter_v3] RRrowInfo: " + rRTabRowInfo + "\nFirstOccPos_for_tuple: " + hashMap);
        } else if (string.equals("UAROW_LEVEL")) {
            this.log("[GFV3 genFilter_v3] RRrL: " + string3 + "\nFirstOccPos_for_tuple: " + hashMap);
        }
        Filter filter = relExpr.filterExprTree;
        this.log("[GFV3 genFilter_v3] " + filter.getFilterTree());
        HashSet<String> hashSet = new HashSet<String>(filter.getVars());
        int n2 = hashSet.size();
        this.log("[GFV3]     genFilter_v3 filterVars: " + hashSet);
        String string4 = "FULL_PROCESSING";
        if (!string.equals("OUTER_LEVEL")) {
            this.log("[GFV3]              varsSetInScope: " + set + " FirstOccPos_for_tuple.keySet()): " + hashMap.keySet());
            hashSet.removeAll(set != null ? set : hashMap.keySet());
            this.log("[GFV3] after difference filterVars.size(): " + hashSet.size());
            if (hashSet.size() > 0) {
                if (hashSet.size() == n2) {
                    this.log("Skip cond generation at this level because there are variables out of this scope - extra vars are: " + hashSet);
                    return "";
                }
                string4 = "VALIDATION_ONLY";
                this.log("Downgrade mode to " + string4 + ": validate mapping for filter vars present in this scope (still Skip cond generation at this level because there are variables out of this scope - extra vars are: " + hashSet + ")");
            } else {
                relExpr.procAtLevel = string;
            }
        }
        Stack<Node> stack = new Stack<Node>();
        Node node = filter.getFilterTree();
        int n3 = 0;
        n3 = relExpr.isNegated() ? relExpr.getNotNegatedFilterLevel() - 1 : relExpr.getNotNegatedFilterLevel();
        this.log("[GFV3] relExpr " + relExpr.toString());
        this.log("[GFV3] Negation is " + (relExpr.isNegated() ? "ON" : "OFF") + " ... " + (n3 - 1) + " levels to skip");
        while (n3 > 0) {
            --n3;
            this.log("[GFV3]  ... Skipping negation level: " + ((SimpleNode)node).toString());
            node = node.jjtGetChild(1);
        }
        this.log("[GFV3] Innermost negated level: " + ((SimpleNode)node).toString());
        SpatialFilterHandler spatialFilterHandler = new SpatialFilterHandler(this.ctx, this.ctx.strictOGC);
        SimpleNode simpleNode = null;
        String string5 = null;
        if (relExpr.isNegated()) {
            simpleNode = (ASTUnaryOperator)node.jjtGetChild(0);
            string5 = ((ASTUnaryOperator)simpleNode).name;
            this.log("[GFV3] Unary operator name : " + string5);
        } else {
            simpleNode = (ASTTripleAtom)node.jjtGetChild(0);
            string5 = ((ASTTripleAtom)simpleNode).name;
            this.log("[GFV3] Geo function name : " + string5);
        }
        String string6 = null;
        if (geo_functionArgsMap.containsKey(string5)) {
            string6 = geo_functionArgsMap.get(string5).get(0);
            if (string6 == null) {
                this.log("[GFV3] Undefined function type: " + string5);
                throw new RDFException("Undefined function expected type");
            }
        } else {
            this.log("[GFV3] Undefined function signature: " + string5);
            throw new RDFException("Undefined function signature: " + string5);
        }
        this.log("[GFV3] Top level function : " + simpleNode.toString() + ": " + string6);
        String string7 = "";
        try {
            R2R2MatSPARQLFilterMap r2R2MatSPARQLFilterMap = this.genFilter_v3_expWalker(string4, string, node, string6, stack, spatialFilterHandler, string2, n, rRTabRowInfo, string3, hashMap, set, natVarOpt_Info, arrayList, arrayList2);
            if (r2R2MatSPARQLFilterMap != null) {
                string7 = r2R2MatSPARQLFilterMap.getNodeFilterSQL();
                this.log("[GFV3] sqlFilterExpression: " + string7);
            } else {
                this.log("[GFV3] validation successful for the this filter");
            }
        }
        catch (SpatialArgTypeException spatialArgTypeException) {
            this.log("[GFV3] SpatialArgTypeException: " + spatialArgTypeException.getMessage());
            string7 = " AND 1=0 ";
        }
        catch (RDFException rDFException) {
            this.log("[GFV3] RDFException: " + rDFException.getMessage());
            throw new RDFException(rDFException.getMessage());
        }
        return string7;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private R2R2MatSPARQLFilterMap genFilter_v3_expWalker(String var1_1, String var2_2, Node var3_3, String var4_4, Stack<Node> var5_5, SpatialFilterHandler var6_6, String var7_7, int var8_8, RRTabRowInfo var9_9, String var10_10, HashMap<String, String> var11_11, Set<String> var12_12, NatVarOpt_Info var13_13, ArrayList<ArrayList<String>> var14_14, ArrayList<ArrayList<String>> var15_15) throws RDFException, SpatialArgTypeException {
        block56: {
            block60: {
                block55: {
                    this.log("========> genFilter_v3_expWalker called: callStackLevel=" + var5_5.size());
                    var5_5.push(var3_3);
                    var16_16 = "";
                    var17_17 = this.TYPE_FAMILY(var4_4);
                    var18_18 = "";
                    for (var19_19 = 0; var19_19 < var5_5.size(); ++var19_19) {
                        var18_18 = var18_18 + "  ";
                    }
                    this.log("[GFV3W] " + var18_18 + " genFilter_v3_expWalker for node:" + var3_3.toString());
                    this.log("[GFV3W] " + var18_18 + "     numchildren: " + var3_3.jjtGetNumChildren());
                    this.log("[GFV3W] " + var18_18 + "    expectedType: " + var4_4);
                    this.log("[GFV3W] " + var18_18 + " expectedTypeFam: " + var17_17);
                    var19_20 = null;
                    var20_21 = null;
                    var21_22 = null;
                    var22_23 = "'EMPTY'";
                    var23_24 = "'EMPTY'";
                    var24_25 = var22_23 + " || " + var23_24;
                    if (var3_3.jjtGetNumChildren() != 0) break block55;
                    var25_26 = (ASTTripleAtom)var3_3;
                    this.log("[GFV3W] " + var18_18 + "            LEAF: " + ((SimpleNode)var3_3).dumpToStr(""));
                    this.log("[GFV3W] " + var18_18 + "           CLASS: " + var3_3.getClass());
                    this.log("[GFV3W]");
                    var21_22 = var25_26.litType != null ? this.TYPE_FAMILY(var25_26.litType) : null;
                    var26_28 = "MAPPING_COL_NAME_EXCEPTION";
                    var27_30 = "MAPPING_COL_TYPE_EXCEPTION";
                    var28_32 = -1;
                    var29_34 = -1;
                    var30_36 = -1;
                    var20_21 = null;
                    var31_38 = null;
                    if (var1_1.equals("VALIDATION_ONLY") && var25_26.type != 0) {
                        this.log("Validation skipped for non-var atom: " + var25_26.name);
                        return null;
                    }
                    switch (var25_26.type) {
                        case 0: {
                            var32_40 = "''";
                            var33_44 = null;
                            var34_47 = "";
                            this.log("[GFV3W] " + var18_18 + " VAR-ATOM: ASTTripleAtom.ATOM_TYPE_VAR: " + 0);
                            if (!var2_2.equals("OUTER_LEVEL")) {
                                this.log("[GFV3W] " + var18_18 + " running TPAT or UAROW condition handling");
                                if (var1_1.equals("VALIDATION_ONLY") && (var12_12 != null && !var12_12.contains(var25_26.name) || !var11_11.keySet().contains(var25_26.name))) {
                                    this.log("[GFV3W] " + var18_18 + " This variable (" + var25_26.name + ") is NOT present in current scope (" + var2_2 + "): SKIP VALIDATION for this var");
                                    return null;
                                }
                                var35_49 = var11_11.get(var25_26.name);
                                this.log("[GFV3W] " + var18_18 + " FirstOccPos_for_tuple: " + var11_11.toString().replaceAll("\\n", "\\n[GFV3W] [FOPT] " + var18_18 + " "));
                                this.log("[GFV3W] " + var18_18 + " occInfo for atom.name=" + var25_26.name + " is: " + var35_49);
                                var36_52 = var35_49.split(":")[0];
                                var37_55 = Integer.parseInt(var35_49.split(":")[1]);
                                var38_58 = null;
                                if (var9_9 != null) {
                                    var38_58 = var9_9;
                                } else {
                                    var39_60 /* !! */  = var10_10.substring(1, var10_10.length()).split(":");
                                    var40_62 = new ArrayList<String>(Arrays.asList(var39_60 /* !! */ ));
                                    var38_58 = this.RRrowInfo_for_MatchingRow.get(var40_62.get(var37_55));
                                }
                                this.log("[GFV3W] " + var18_18 + " RRrowInfo for occInfo=" + var35_49 + " is: ");
                                this.log("[GFV3W] " + var18_18 + " [RRrowInfo] " + var38_58.toString().toString().replaceAll("\n", "\n[GFV3W] [RRrowInfo] " + var18_18 + " "));
                                var28_32 = this.convert_comp_name_to_comp_idx(var36_52, var38_58.paTmap);
                                this.log("[GFV3W] " + var18_18 + " position in triple pattern: " + var36_52 + " comp_idx: " + var28_32);
                                if (var28_32 != 2) {
                                    throw new RDFException("Not handled yet: Variable used in GeoSparql filter appears in position other than object: " + var36_52);
                                }
                                var39_60 /* !! */  = var38_58.exprTypes.get(var28_32);
                                this.log("[GFV3W] " + var18_18 + " expression type: " + var39_60 /* !! */ );
                                if (var39_60 /* !! */  != RRTabRowInfo.MapExprType_COLUMN) {
                                    throw new SpatialArgTypeException(" (for NOW) returning COND_FALSE: Variable (" + var25_26.name + ") used in GeoSparql filter has non-COLUMN mapping: " + var39_60 /* !! */ );
                                }
                                var40_62 = var38_58.termTypes.get(var28_32);
                                var41_64 = var38_58.strLists.get(var28_32);
                                var42_65 = var38_58.colLists.get(var28_32);
                                var43_66 = var38_58.colTypeLists.get(var28_32);
                                var44_67 = var38_58.oDataType;
                                var29_34 = 0;
                                var27_30 = var43_66.get(var29_34);
                                var26_28 = var42_65.get(var29_34);
                                this.log("[GFV3W] " + var18_18 + " colName: " + var26_28);
                                this.log("[GFV3W] " + var18_18 + " colType: " + var27_30);
                                this.log("[GFV3W] " + var18_18 + " expectedTypeFam: " + var17_17);
                                if (var17_17.equals("SDO_GEOMETRY") != false && "SDO_GEOMETRY".equals(var27_30) != false || var17_17.equals("BOOLEAN") != false && "BOOLEAN".equals(var27_30) != false || var17_17.equals("STRING") != false && "STRING".equals(var27_30) != false || var17_17.equals("NUMERIC") && "NUMBER".equals(var27_30)) {
                                    var20_21 = var4_4;
                                    if (!this.DatatypeFam_for_var.containsKey(var25_26.name)) {
                                        this.DatatypeFam_for_var.put(var25_26.name, var17_17);
                                        this.log("added to DatatypeFam_for_var: " + this.DatatypeFam_for_var);
                                    } else if (!var17_17.equals(this.DatatypeFam_for_var.get(var25_26.name))) {
                                        this.log("var " + var25_26.name + " is already categorized as type " + this.DatatypeFam_for_var.get(var25_26.name) + ": It cannot also have another type: column type=" + var27_30 + " expectedTypeFam=" + var17_17);
                                        throw new SpatialArgTypeException("var " + var25_26.name + " is already categorized as type " + this.DatatypeFam_for_var.get(var25_26.name) + ": It cannot also have another type: column type=" + var27_30);
                                    }
                                } else {
                                    if (!var17_17.equals("SDO_GEOMETRY") && this.Geometry_VarSRID.containsKey(var25_26.name)) {
                                        this.Geometry_VarSRID.remove(var25_26.name);
                                        this.log("removed from Geometry_VarSRID (filter expects diff datatype family=" + var17_17 + "): var=" + var25_26.name);
                                    }
                                    throw new SpatialArgTypeException("Inappropriate column type " + var27_30 + " ... Expecting a type compatible with " + var4_4);
                                }
                                if (var17_17.equals("SDO_GEOMETRY")) {
                                    var45_68 = var38_58.Tmap + "+" + var26_28.replaceAll("\"", "");
                                    this.log("[GFV3W] " + var18_18 + " Starting multi-SRID handling for var " + var25_26.name + " at " + var2_2 + " filter handling level");
                                    this.log("[GFV3W] [SRID] " + var18_18 + " SDO_GEOMETRY retrieving metadata for var " + var25_26.name + " associated to the column name " + var26_28 + " from LtcRowInfo_for_Tmap_plus_Col with key " + var45_68);
                                    var46_69 = this.LtcRowInfo_for_Tmap_plus_Col.get(var45_68);
                                    this.log("[GFV3W] [SRID] " + var18_18 + " LtcRowInfo.toString(): " + var46_69.toString());
                                    this.log("[GFV3W] [SRID] " + var18_18 + " LtcRowInfo.getDimArrayConstructor(): " + var46_69.getDimArrayConstructor());
                                    var34_47 = var46_69.getDimArrayConstructor("sdo_dim_array(sdo_dim_element('LONGITUDE','-180','180','10'),sdo_dim_element('LATITUDE','-90','90','10'))");
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " geoDimension [DimArrayConstructor] : " + var34_47);
                                    var33_44 = Long.valueOf(var46_69.getSRID());
                                    this.log("[GFV3W] " + var18_18 + " Finishing multi-SRID handling for var " + var25_26.name + " at " + var2_2 + " filter handling level");
                                }
                                if (var1_1.equals("VALIDATION_ONLY")) {
                                    this.log("Validation successful for var: " + var25_26.name);
                                    return null;
                                }
                                var16_16 = var7_7 + "." + var26_28;
                                var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16, var33_44);
                                this.log("[GFV3W] finally, col_srid (for var " + var25_26.name + "): " + var33_44);
                            } else {
                                this.log("[GFV3W] " + var18_18 + " running OUTER condition handling");
                                this.log("[GFV3W] " + var18_18 + " natVarOptInfo: " + var13_13.toString());
                                this.log("[GFV3W] " + var18_18 + " atom.name: " + var25_26.name);
                                var20_21 = var4_4;
                                var35_50 = var13_13.get_NatVarOpt_Structure(var25_26.name);
                                this.log("[GFV3W] " + var18_18 + " natVarOpt: " + var35_50);
                                var7_7 = var35_50.getCSRAlias();
                                if (var17_17.equals("SDO_GEOMETRY")) {
                                    var36_53 = var35_50.getColCount();
                                    if (var36_53 != 1) {
                                        this.log("SDO_GEOMETRY type handles ONLY COLUMN mapping - so colCount (" + var36_53 + ") is NOT handled");
                                        throw new RDFException("Geometry value being constructed with a non-COLUMN mapping (multiple cols in TFT): colCount=" + var36_53);
                                    }
                                    var16_16 = var7_7 + "." + var25_26.name + "$" + (var36_53 - 1);
                                    this.log("[GFV3W] " + var18_18 + " Starting multi-SRID handling for var " + var25_26.name + " at " + var2_2 + " filter handling level");
                                    this.log("[GFV3W]  [SRID]" + var18_18 + " Geometry_VarSRID for var " + var25_26.name + ": " + this.Geometry_VarSRID.get(var25_26.name).toString());
                                    var37_56 = null;
                                    if (this.Geometry_VarSRID.containsKey(var25_26.name)) {
                                        var37_56 = this.Geometry_VarSRID.get(var25_26.name).iterator().next();
                                        this.log("[GFV3W]  [SRID]" + var18_18 + " SDO_GEOMETRY metadata for key var " + var25_26.name + " : " + var37_56 + " during OUTER condition handling");
                                    } else {
                                        this.log("[GFV3W]  [SRID]" + var18_18 + " UNEXPECTED ERROR!!! SDO_GEOMETRY SRID for key var " + var25_26.name + " NOTFOUND at OUTER condition processing in Geometry_VarSRID");
                                    }
                                    this.log("[GFV3W]  [SRID]" + var18_18 + " Finishing multi-SRID handling for var " + var25_26.name + " at " + var2_2 + " filter handling level");
                                    var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16, var37_56);
                                    var31_38.setGeoDimension(this.Geometry_VarDimension.get(var7_7 + "." + var25_26.name));
                                } else {
                                    var16_16 = "sdo_rdf.vname(" + var7_7 + "." + var25_26.name + ")";
                                    var32_40 = "sdo_rdf.ltype(" + var7_7 + "." + var25_26.name + ")";
                                    var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16);
                                }
                            }
                            var22_23 = var16_16;
                            var23_24 = "''";
                            var24_25 = var22_23;
                            var31_38.setValue_name_0(var24_25);
                            var31_38.setValue_type_1("'LIT'");
                            var31_38.setVname_prefix_2(var22_23);
                            var31_38.setVname_suffix_3(var23_24);
                            var31_38.setLiteral_type_4(var32_40);
                            var31_38.setLanguage_type_5("''");
                            var31_38.setLong_value_6("TO_CLOB(NULL)");
                            var31_38.setArgument_type_7(String.valueOf(4));
                            var31_38.setVarName(var25_26.name);
                            if (!"SDO_GEOMETRY".equals(var27_30)) break;
                            var31_38.setArg_8("LOCAL_VAR");
                            var31_38.setGeoDimension(var34_47);
                            break;
                        }
                        case 5: {
                            this.log("[GFV3W] " + var18_18 + " TERM-ATOM: ASTTripleAtom.ATOM_TYPE_LITERAL_TEXT_TYPED: " + 5);
                            this.log("[GFV3W] " + var18_18 + "            type: " + var25_26.type);
                            this.log("[GFV3W] " + var18_18 + "         litType: " + var25_26.litType);
                            this.log("[GFV3W] " + var18_18 + "      litTypeFam: " + var21_22);
                            if (!var17_17.equals(var21_22)) {
                                throw new RDFException("Inappropriate literal argument " + var25_26.litType + " ... Expecting a type compatible with " + var4_4);
                            }
                            var20_21 = var4_4;
                            var16_16 = "'" + var25_26.name + "'";
                            var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16);
                            var22_23 = var16_16;
                            var23_24 = "''";
                            var24_25 = var22_23 + " || " + var23_24;
                            var31_38.setValue_name_0(var22_23);
                            var31_38.setValue_type_1("'LIT'");
                            var31_38.setVname_prefix_2(var22_23);
                            var31_38.setVname_suffix_3(var23_24);
                            var31_38.setLiteral_type_4("'" + var25_26.litType + "'");
                            var31_38.setLanguage_type_5("''");
                            var31_38.setLong_value_6("TO_CLOB(NULL)");
                            var31_38.setArgument_type_7(String.valueOf(var31_38.getNodeFilterType()));
                            var31_38.setArg_8("CONSTANT");
                            if (!"SDO_GEOMETRY".equals(var17_17)) break;
                            this.log("Note: for this SDO_GEOMETRY literal, geoDimension is NOT populated yet: caller will do it using function_geoDimension");
                            break;
                        }
                        case 3: {
                            this.log("[GFV3W] " + var18_18 + " TERM-ATOM: ASTTripleAtom.ATOM_TYPE_LITERAL_TEXT_PLAIN: " + 3);
                            this.log("[GFV3W] " + var18_18 + "            type: " + var25_26.type);
                            this.log("[GFV3W] " + var18_18 + "         litType: " + var25_26.litType);
                            this.log("[GFV3W] " + var18_18 + "      litTypeFam: " + var21_22);
                            if (!var17_17.equals("STRING")) {
                                throw new RDFException("Inappropriate literal text plain ... Expecting a type compatible with " + var4_4);
                            }
                            var20_21 = var4_4;
                            var16_16 = "'" + var25_26.name + "'";
                            var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16);
                            var22_23 = var16_16;
                            var23_24 = "''";
                            var24_25 = var22_23 + " || " + var23_24;
                            var31_38.setValue_name_0(var24_25);
                            var31_38.setValue_type_1("'LIT'");
                            var31_38.setVname_prefix_2(var22_23);
                            var31_38.setVname_suffix_3(var23_24);
                            var31_38.setLiteral_type_4("''");
                            var31_38.setLanguage_type_5("''");
                            var31_38.setLong_value_6("TO_CLOB(NULL)");
                            var31_38.setArgument_type_7(String.valueOf(var31_38.getNodeFilterType()));
                            var31_38.setArg_8("CONSTANT");
                            break;
                        }
                        case 2: {
                            this.log("[GFV3W] " + var18_18 + " TERM-ATOM: ASTTripleAtom.ATOM_TYPE_LITERAL_NUMERIC: " + 2);
                            this.log("[GFV3W] " + var18_18 + "            type: " + var25_26.type);
                            this.log("[GFV3W] " + var18_18 + "         litType: " + var25_26.litType);
                            this.log("[GFV3W] " + var18_18 + "      litTypeFam: " + var21_22);
                            if (!var17_17.equals("NUMERIC")) {
                                throw new SpatialArgTypeException("Inappropriate literal numeric ... Expecting a type compatible with " + var4_4);
                            }
                            var20_21 = var4_4;
                            var16_16 = var25_26.name;
                            var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16);
                            var22_23 = var16_16;
                            var23_24 = "''";
                            var24_25 = var22_23;
                            var31_38.setValue_name_0(var24_25);
                            var31_38.setValue_type_1("'LIT'");
                            var31_38.setVname_prefix_2(var22_23);
                            var31_38.setVname_suffix_3(var23_24);
                            var31_38.setLiteral_type_4("''");
                            var31_38.setLanguage_type_5("''");
                            var31_38.setLong_value_6("TO_CLOB(NULL)");
                            var31_38.setArgument_type_7(String.valueOf(var31_38.getNodeFilterType()));
                            var31_38.setArg_8("CONSTANT");
                            break;
                        }
                        case 1: {
                            this.log("[GFV3W] " + var18_18 + " TERM-ATOM: ASTTripleAtom.ATOM_TYPE_URI: " + 1);
                            this.log("[GFV3W] " + var18_18 + "            type: " + var25_26.type);
                            this.log("[GFV3W] " + var18_18 + "         litType: " + var25_26.litType);
                            this.log("[GFV3W] " + var18_18 + "      litTypeFam: " + var21_22);
                            if (!var17_17.equals("STRING")) {
                                throw new SpatialArgTypeException("Inappropriate literal type ... Expecting a type compatible with " + var4_4);
                            }
                            var20_21 = "URI";
                            var16_16 = "'" + var25_26.name + "'";
                            var31_38 = new R2R2MatSPARQLFilterMap(var20_21, var16_16);
                            var22_23 = var16_16;
                            var23_24 = "''";
                            var24_25 = var22_23;
                            var31_38.setValue_name_0(var24_25);
                            var31_38.setValue_type_1("'LIT'");
                            var31_38.setVname_prefix_2(var22_23);
                            var31_38.setVname_suffix_3(var23_24);
                            var31_38.setLiteral_type_4("''");
                            var31_38.setLanguage_type_5("''");
                            var31_38.setLong_value_6("TO_CLOB(NULL)");
                            var31_38.setArgument_type_7(String.valueOf(var31_38.getNodeFilterType()));
                            var31_38.setArg_8("CONSTANT");
                            break;
                        }
                        default: {
                            throw new RDFException("Unhandled atom type: " + var25_26.type);
                        }
                    }
                    var19_20 = var31_38;
                    break block56;
                }
                var25_27 = null;
                var26_29 = (SimpleNode)var3_3.jjtGetChild(0);
                if (var26_29 instanceof ASTUnaryOperator) {
                    var27_31 = (ASTUnaryOperator)var26_29;
                    var25_27 = var27_31.name.trim();
                } else if (var26_29 instanceof ASTTripleAtom) {
                    var27_31 = (ASTTripleAtom)var26_29;
                    var25_27 = var27_31.name.trim();
                }
                this.log("[GFV3W] " + var18_18 + "        FUNCTION: " + var26_29.dumpToStr(""));
                this.log("[GFV3W] " + var18_18 + "           CLASS: " + var26_29.getClass());
                this.log("[GFV3W] " + var18_18 + "        funcName: " + var25_27);
                if (!RelationalBGP.geo_functionArgsMap.containsKey(var25_27)) {
                    this.log("[GFV3W] " + var18_18 + " Unsupported function: " + var25_27);
                    throw new RDFException("Unsupported function: " + var25_27);
                }
                var27_31 = RelationalBGP.geo_functionArgsMap.get(var25_27).get(0);
                var21_22 = this.TYPE_FAMILY((String)var27_31);
                this.log("[GFV3W] " + var18_18 + "        funcType: " + (String)var27_31);
                this.log("[GFV3W] " + var18_18 + "      litTypeFam: " + var21_22);
                this.log("[GFV3W]");
                if (!var4_4.equals(var27_31)) {
                    throw new SpatialArgTypeException("Inappropriate type argument " + (String)var27_31 + " ... Expecting a compatible type with " + var4_4);
                }
                var28_33 = null;
                var29_35 = new ArrayList<String[]>();
                var30_37 = null;
                var31_39 = null;
                for (var32_41 = 1; var32_41 < var3_3.jjtGetNumChildren(); ++var32_41) {
                    block57: {
                        block59: {
                            block58: {
                                this.log("[GFV3W] " + var18_18 + " --> #child: " + var32_41 + " function_srid so far =" + var30_37);
                                var33_45 = (SimpleNode)var3_3.jjtGetChild(var32_41);
                                var34_48 = RelationalBGP.geo_functionArgsMap.get(var25_27).get(var32_41);
                                if (var34_48 == null) {
                                    throw new SpatialArgTypeException("There is no expected type mapping for the function " + var25_27 + " at the argument " + var32_41);
                                }
                                var35_51 = this.genFilter_v3_expWalker(var1_1, var2_2, var33_45, var34_48, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10, var11_11, var12_12, var13_13, var14_14, var15_15);
                                this.log("[GFV3W] " + var18_18 + " back after processing of #child: " + var32_41 + " callStackLevel=" + var5_5.size());
                                if (var1_1.equals("VALIDATION_ONLY") && var35_51 == null) {
                                    this.log("[GFV3W] " + var18_18 + " VALIDATION_ONLY mode --> got to the next child");
                                    continue;
                                }
                                if (!"SDO_GEOMETRY".equals(this.TYPE_FAMILY(var35_51.getR2r_type()))) break block57;
                                this.log("[GFV3W] " + var18_18 + " dealing with family " + "SDO_GEOMETRY" + " of concrete type " + var35_51.getR2r_type());
                                if (!RelationalBGP.geo_funtionRequiringSridTransformationSet.contains(var25_27) || var35_51.getArg_8().equals("CONSTANT")) break block58;
                                this.log("[GFV3W] " + var18_18 + " The function " + var25_27 + " requires SRID transformation at the OUTER filter handling");
                                var36_54 = var35_51.getValue_name_0();
                                this.log("[GFV3W] " + var18_18 + " Starting multi-SRID handling for function " + var25_27 + " for argument " + (String)var36_54 + " at " + var2_2 + " filter handling level");
                                var37_57 = null;
                                var38_59 = var35_51.getVarName();
                                this.log("[GFV3W]  [SRID] " + var18_18 + " geom_obj_var " + var38_59);
                                if (var38_59 == null) ** GOTO lbl312
                                if (this.Geometry_VarSRID.containsKey(var38_59)) {
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " value_name " + (String)var36_54 + " matches the variable identifier pattern: " + var38_59);
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " AND we have its SRIDs");
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " geom_obj_var: " + var38_59 + " SRIDs: " + this.Geometry_VarSRID.get(var38_59));
                                    var37_57 = this.Geometry_VarSRID.get(var38_59).iterator().next();
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " very first SRID for geom_obj_var " + var38_59 + ": " + var37_57);
                                } else {
                                    throw new SpatialArgTypeException("There is no SRID associated to the var " + var38_59);
lbl312:
                                    // 1 sources

                                    this.log("[GFV3W]  [SRID] " + var18_18 + " Using SRID of " + (String)var36_54);
                                    var37_57 = var35_51.getSrid();
                                }
                                if (var30_37 == null) {
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " Function SRID has not been defined");
                                    var30_37 = var37_57;
                                    var31_39 = var35_51.getGeoDimension();
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " Defining function SRID: " + var30_37 + " and function geoDimension: " + var31_39);
                                }
                                this.log("[GFV3W]  [SRID] " + var18_18 + " Deciding if it's worth to do the SRID transformation for " + var35_51.getValue_name_0() + " ...");
                                var39_61 = false;
                                if (var2_2.equals("OUTER_LEVEL") && var38_59 != null) {
                                    this.log("[GFV3W] " + var18_18 + " At the OUTER level it is required a transformation if a vriable " + var38_59 + " has multiple mappings with different SRIDs");
                                    var40_63 = this.Geometry_VarSRID.get(var38_59);
                                    if (var40_63.size() > 1) {
                                        this.log("[GFV3W]  [SRID] " + var18_18 + " ... the var " + var38_59 + " has more than one SRIDs: " + var40_63.toString());
                                        this.log("[GFV3W]  [SRID] " + var18_18 + " ... SRID transformation is required");
                                        var39_61 = true;
                                    }
                                }
                                if (!var30_37.equals(var35_51.getSrid())) {
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " The function_srid " + var30_37 + " is different from the child's SRID " + var35_51.getSrid());
                                    var39_61 = true;
                                }
                                if (var39_61) {
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " Transforming geometry in " + var35_51.getValue_name_0() + " to " + var30_37 + " --> ");
                                    var40_63 = "sdo_cs.transform( /* FUNC SRID */ " + var35_51.getValue_name_0() + ", " + var30_37 + ")";
                                    var35_51.setVname_prefix_2((String)var40_63);
                                    var35_51.setValue_name_0(var35_51.getVname_prefix_2());
                                    this.log("[GFV3W]  [SRID] " + var18_18 + " " + var35_51.getValue_name_0());
                                }
                                break block59;
                            }
                            if (var30_37 == null) {
                                var30_37 = var35_51.getSrid();
                                var31_39 = var35_51.getGeoDimension();
                                this.log("[GFV3W]  [SRID] " + var18_18 + " Defining function SRID: " + var30_37 + " and function geoDimension: " + var31_39);
                            }
                        }
                        this.log("[GFV3W] " + var18_18 + " Finishing multi-SRID handling for function " + var25_27 + " at " + var2_2 + " filter handling level");
                        if (var35_51.getGeoDimension() == null) {
                            this.log("replacing null geoDimension in just-processed-child with function_geoDimension: " + var31_39);
                            var35_51.setGeoDimension(var31_39);
                        }
                    }
                    var36_54 = new String[]{var35_51.getValue_name_0(), var35_51.getValue_type_1(), var35_51.getVname_prefix_2(), var35_51.getVname_suffix_3(), var35_51.getLiteral_type_4(), var35_51.getLanguage_type_5(), var35_51.getLong_value_6(), var35_51.getArgument_type_7(), var35_51.getArg_8(), var35_51.getGeoDimension()};
                    var29_35.add(var36_54);
                    this.log("[GFV3W] " + var18_18 + " <-- END #child: " + var32_41);
                }
                if (var1_1.equals("VALIDATION_ONLY")) break block60;
                this.log("[GFV3W] " + var18_18 + " funcName: " + var25_27);
                this.log("[GFV3W] " + var18_18 + " CLASS: " + var26_29.getClass());
                if (!(var26_29 instanceof ASTUnaryOperator)) ** GOTO lbl365
                if (var25_27.equals("!")) {
                    var32_42 = ((String[])var29_35.get(0))[2];
                    this.log("[GFV3W] " + var18_18 + " Negating the filter expression: " + var32_42);
                    var16_16 = "NOT " + var32_42;
                } else {
                    this.log("[GFV3W] " + var18_18 + " Unsupported Unary Operator: " + var25_27);
                    throw new RDFException("Unsupported Unary Operator: " + var25_27);
lbl365:
                    // 1 sources

                    var32_43 = "''";
                    var33_46 = this.ctx.srid;
                    v0 = this.ctx.srid = var30_37 != null ? var30_37 : 0L;
                    if ("http://www.opengis.net/def/function/geosparql/sfDisjoint".equals(var25_27)) {
                        this.log("[GFV3W] " + var18_18 + " Special case for handling " + "http://www.opengis.net/def/function/geosparql/sfDisjoint" + "...");
                        this.log("[GFV3W] " + var18_18 + " ... We use " + "http://www.opengis.net/def/function/geosparql/sfDisjointR2R" + " to induce the use of the index-based SDO_RELATE");
                        var25_27 = "http://www.opengis.net/def/function/geosparql/sfDisjointR2R";
                    }
                    var16_16 = var6_6.genSQL(var29_35, var25_27, var32_43);
                    this.ctx.srid = var33_46;
                }
                var28_33 = new R2R2MatSPARQLFilterMap(var4_4, var16_16, var30_37);
                var22_23 = var16_16;
                var23_24 = "''";
                var24_25 = "";
                var28_33.setValue_name_0(var24_25);
                var28_33.setValue_type_1("'LIT'");
                var28_33.setVname_prefix_2(var22_23);
                var28_33.setVname_suffix_3(var23_24);
                var28_33.setLiteral_type_4("''");
                var28_33.setLanguage_type_5("''");
                var28_33.setLong_value_6("TO_CLOB(NULL)");
                if (var4_4.equals("http://www.opengis.net/ont/geosparql#wktLiteral")) {
                    var28_33.setArgument_type_7(String.valueOf(25));
                    var28_33.setArg_8(var28_33.getVname_prefix_2());
                    this.log("Note: function call returns a geometry value: it gets its geoDimension from function_geoDimension=" + var31_39);
                    var28_33.setGeoDimension(var31_39);
                } else {
                    var28_33.setArgument_type_7(String.valueOf(var28_33.getNodeFilterType()));
                    var28_33.setArg_8("LOCAL_VAR");
                }
                var19_20 = var28_33;
                break block56;
            }
            return null;
        }
        var5_5.pop();
        this.log("[GFV3W] " + var18_18 + " genFilter_v3_expWalker result:\n" + var18_18 + " " + var19_20.toString());
        return var19_20;
    }

    private RelExpr buildUnindexedEqualityGeomExpression(String string, String string2) {
        ASTRelationalExpression aSTRelationalExpression = new ASTRelationalExpression(90);
        aSTRelationalExpression.jjtSetInitCapacity(4);
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 1;
        aSTTripleAtom.name = "http://www.opengis.net/def/function/geosparql/relate";
        aSTTripleAtom.jjtSetParent(aSTRelationalExpression);
        aSTRelationalExpression.jjtAddChild(aSTTripleAtom, 0);
        ASTTripleAtom aSTTripleAtom2 = new ASTTripleAtom(73);
        aSTTripleAtom2.type = 0;
        aSTTripleAtom2.name = string;
        aSTTripleAtom2.jjtSetParent(aSTRelationalExpression);
        aSTRelationalExpression.jjtAddChild(aSTTripleAtom2, 1);
        ASTTripleAtom aSTTripleAtom3 = new ASTTripleAtom(73);
        aSTTripleAtom3.type = 0;
        aSTTripleAtom3.name = string2;
        aSTTripleAtom3.jjtSetParent(aSTRelationalExpression);
        aSTRelationalExpression.jjtAddChild(aSTTripleAtom3, 2);
        ASTTripleAtom aSTTripleAtom4 = new ASTTripleAtom(73);
        aSTTripleAtom4.name = "TFFFTFFFT";
        aSTTripleAtom4.type = 3;
        aSTTripleAtom4.jjtSetParent(aSTRelationalExpression);
        aSTRelationalExpression.jjtAddChild(aSTTripleAtom4, 3);
        Filter filter = new Filter(aSTRelationalExpression);
        this.log("filter: " + filter.toString());
        RelExpr relExpr = new RelExpr(aSTTripleAtom2, "=", aSTTripleAtom3, filter, 2L);
        return relExpr;
    }

    private String genFilter2vCond_outer(NatVarOpt_Info natVarOpt_Info) throws RDFException {
        HashSet hashSet = new HashSet();
        Object object = "";
        for (RelExpr relExpr : this.TwoVarRelExprFilterList_for_BGP) {
            Object object2;
            Object object3;
            Object object4;
            this.log("Two-var filter condition: " + relExpr.toString());
            if (relExpr.L_atom.type != 0 || relExpr.R_atom.type != 0) {
                throw new RDFException("Internal error: not a two-var filter: " + relExpr.toString());
            }
            String string = relExpr.L_atom.name;
            String string2 = relExpr.R_atom.name;
            Set<String> set = this.CSRAliasSet_for_tuple.get(string);
            Set<String> set2 = this.CSRAliasSet_for_tuple.get(string2);
            this.log("Lvar=" + string + " CSRAliasSet: " + set);
            this.log("Rvar=" + string2 + " CSRAliasSet: " + set2);
            hashSet.addAll(this.CSRAliasSet_for_tuple.get(string));
            hashSet.retainAll((Collection)this.CSRAliasSet_for_tuple.get(string2));
            if (!hashSet.isEmpty()) {
                hashSet.clear();
                continue;
            }
            this.log("this two-var filter needs processing: the two vars never occur in the same CSR");
            String string3 = "";
            NatVarOpt_Structure natVarOpt_Structure = natVarOpt_Info.get_NatVarOpt_Structure(string);
            NatVarOpt_Structure natVarOpt_Structure2 = natVarOpt_Info.get_NatVarOpt_Structure(string2);
            this.log("for Lvar=" + string + ":\n" + natVarOpt_Structure.toString());
            this.log("for Rvar=" + string2 + ":\n" + natVarOpt_Structure2.toString());
            if (natVarOpt_Structure.natVarCountForAlias_for_TFTidx.keySet().size() > 1 || natVarOpt_Structure2.natVarCountForAlias_for_TFTidx.keySet().size() > 1) {
                this.log("filter2vdco native processing SKIPPED because of more than one TFTs for Lvar and/or Rvar (will be handled in SPARQL)");
                continue;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            String string4 = "";
            String string5 = "";
            Object object5 = natVarOpt_Structure.natVarCountForAlias_for_TFTidx.keySet().iterator();
            while (object5.hasNext()) {
                int n = (Integer)object5.next();
                object4 = this.TFTinfoGlobalList.get(n);
                string4 = ((TFTinfo)object4).termType;
                string5 = ((TFTinfo)object4).datatype;
                this.log("Lvar_TermType=" + string4 + " Lvar_datatype=" + string5);
                this.log("Lvar_TFTinfo=" + object4);
                this.log("Lvar_TFTidx=" + n);
                object3 = natVarOpt_Structure2.natVarCountForAlias_for_TFTidx.keySet().iterator();
                while (object3.hasNext()) {
                    int n2 = (Integer)object3.next();
                    this.log("  Rvar_TFTidx=" + n2);
                    if (n == n2) continue;
                    object2 = this.TFTinfoGlobalList.get(n2);
                    this.log("Rvar_TFTinfo=" + object2);
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    bl4 = false;
                    if (!((TFTinfo)object4).termType.equals(((TFTinfo)object2).termType)) {
                        this.log("termType mismatch: Lvar_TFTinfo.termType=" + ((TFTinfo)object4).termType + " Rvar_TFTinfo.termType=" + ((TFTinfo)object2).termType);
                        bl = true;
                        string3 = this.gen_e_z_termType_based_cond(relExpr, bl);
                    } else if (((TFTinfo)object4).termType.equals(rrLiteral)) {
                        if (!((TFTinfo)object4).datatype.equals(((TFTinfo)object2).datatype)) {
                            bl2 = true;
                            if (!((TFTinfo)object4).datatype_family.equals(((TFTinfo)object2).datatype_family)) {
                                bl3 = true;
                                if (!this.isNumFltDbl(((TFTinfo)object4).datatype_family) || !this.isNumFltDbl(((TFTinfo)object2).datatype_family)) {
                                    bl4 = true;
                                }
                            }
                        }
                        if (bl2) {
                            this.log("non-identical datatype: datatype_mismatch=" + bl2 + " | datatype_family_mismatch=" + bl3 + " | datatype_family_incompatible=" + bl4);
                            String string6 = this.gen_e_z_datatype_based_cond(relExpr, bl2, bl3, bl4);
                            if (string6 != null) {
                                string3 = string6;
                            }
                        }
                    }
                    if (string3.length() <= 0) continue;
                    break;
                }
                if (string3.length() <= 0) continue;
                break;
            }
            if (string3.length() == 0) {
                this.log("no condition could be generated for current relExpr (termTypes match and datatypes compatible): fall back to SPARQL-generated condition");
                object5 = null;
                String string7 = null;
                object4 = set.iterator();
                if (object4.hasNext()) {
                    object5 = object3 = (String)object4.next();
                }
                if ((object4 = set2.iterator()).hasNext()) {
                    object3 = object4.next();
                    string7 = object3;
                }
                this.log("Lvar_CSRAliasSet=" + set + " chosen=" + (String)object5);
                this.log("Rvar_CSRAliasSet=" + set2 + " chosen=" + string7);
                object4 = relExpr.compOperator.equals("SAMETERM") ? "=" : (relExpr.compOperator.equals("DIFFTERM") ? "!=" : relExpr.compOperator);
                this.log("sql_compOperator=" + (String)object4);
                if (string4.equals(rrIRI) || string4.equals(rrBlankNode)) {
                    this.log("[IRIorBN]");
                    if (relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("=") || relExpr.compOperator.equals("!=")) {
                        object3 = natVarOpt_Info.get_optOutNatCond_For_Filter2v(string, string2, (String)object4);
                        if (!((String)object3).equals("")) {
                            this.log("CASE: =, !=, SAMETERM, DIFFTERM [FILTER_OPTIMIZED]");
                            object = object3;
                            this.VarSet_filter2vCond_outer.add(string);
                            this.VarSet_filter2vCond_outer.add(string2);
                            this.log("VarSet_filter2vCond_outer: " + this.VarSet_filter2vCond_outer);
                        } else {
                            this.log("//CASE: =, !=, SAMETERM, DIFFTERM [NOT_FILTER_OPTIMIZED]");
                            object = (String)object + COND_CONNECTOR + (String)object5 + "." + string + BASE_PREFIX_COLNAME_SEP + (String)object4 + BASE_PREFIX_COLNAME_SEP + string7 + "." + string2;
                        }
                        this.log("filter2vdco_condExpr=" + (String)object);
                        continue;
                    }
                    this.log("//CASE: <, >, <=, >=");
                    object = (String)object + " AND 1=0 ";
                    continue;
                }
                if (!string4.equals(rrLiteral)) continue;
                this.log("[Literal] datatype=" + string5);
                object3 = "";
                if ((relExpr.compOperator.equals("SAMETERM") || relExpr.compOperator.equals("DIFFTERM") || relExpr.compOperator.equals("=") || relExpr.compOperator.equals("!=")) && !((String)(object3 = natVarOpt_Info.get_optOutNatCond_For_Filter2v(string, string2, (String)object4))).equals("")) {
                    object = object3;
                    this.VarSet_filter2vCond_outer.add(string);
                    this.VarSet_filter2vCond_outer.add(string2);
                    this.log("VarSet_filter2vCond_outer: " + this.VarSet_filter2vCond_outer);
                }
                if (((String)object3).equals("")) {
                    String string8 = "";
                    object2 = "";
                    this.log(this.TYPE_FAMILY(string5));
                    if (this.isNumFltDbl(this.TYPE_FAMILY(string5))) {
                        this.log(this.TYPE_FAMILY(string5));
                        string8 = "to_number(";
                        object2 = ")";
                    }
                    object = (String)object + COND_CONNECTOR + string8 + SDO_RDF_VNAME_BEG + (String)object5 + "." + string + ")" + (String)object2 + BASE_PREFIX_COLNAME_SEP + (String)object4 + BASE_PREFIX_COLNAME_SEP + string8 + SDO_RDF_VNAME_BEG + string7 + "." + string2 + ")" + (String)object2;
                }
                this.log("filter2vdco_condExpr=" + (String)object);
                continue;
            }
            if (string3.equals(" AND 1=0 ")) {
                this.log("COND_FALSE generated by relExpr: set global COND_FALSE and exit");
                object = " AND 1=0 ";
                break;
            }
            object = (String)object + string3;
        }
        this.log("genFilter2vCond_outer: filter2vdco_condExpr: " + (String)object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getGraphCondition_for_UnionOperand(int n, String string, boolean bl, int n2, ArrayList<HashMap<String, String>> arrayList, ArrayList<String> arrayList2, String string2) throws RDFException {
        String string3;
        Object object;
        String string4;
        String string5 = "";
        String string6 = " AND 1=0";
        String string7 = "";
        String string8 = "";
        HashMap<String, String> hashMap = arrayList.get(n2);
        String string9 = arrayList2.get(n2);
        this.log("... entered getGraphCondition_for_UnionOperand: graph_use_mode=" + n + " bgp_graph=" + string + " rowNum=" + n2);
        if (n == 0) {
            return string5;
        }
        if (string != null) {
            if (n == 5) {
                return string6;
            }
            this.log("===>[size=" + arrayList.size() + "] TpGEArray: " + arrayList);
            this.log("===>[size=" + arrayList2.size() + "] RRrLArray: " + arrayList2);
            string4 = null;
            if (bl) {
                string4 = "'" + string.replace("'", "''") + "'";
                this.log("[const bgp_graph] chosen_gExpr=" + string4);
            }
            this.log("TpGE [for rowNum=" + n2 + "]:" + hashMap);
            object = hashMap.keySet().iterator();
        } else {
            if (n == 2) {
                return string6;
            }
            if ((n & 1) != 1) {
                throw new RDFException("EXCEPTION: Internal Error: graph_use_mode=" + n);
            }
            String string10 = "";
            String string11 = "";
            for (String string12 : this.ctx.defaultGraphList) {
                string11 = string11 + string10 + "'" + string12.replace("'", "''") + "'";
                if (string10.length() != 0) continue;
                string10 = ", ";
            }
            Iterator<String> iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string12;
                string12 = iterator.next();
                string7 = string7 + COND_CONNECTOR + string12 + " IN (" + string11 + ")";
            }
            return string7;
        }
        while (object.hasNext()) {
            string3 = object.next();
            String string13 = hashMap.get(string3);
            if (string4 == null) {
                string4 = string3;
                this.log("chosen_gExpr=" + string4);
                continue;
            }
            Object object2 = COND_CONNECTOR + string4 + " = " + string3;
            if (bl) {
                String string14;
                int n3 = Integer.parseInt(this.get_subStringAtIndex(string13, 0, "+"));
                String string15 = this.get_subStringAtIndex(string9, n3, ":");
                RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(string15);
                String string16 = rRTabRowInfo.pogExpr;
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                StringBuffer stringBuffer = new StringBuffer("");
                try {
                    string14 = RelationalBGP.sqlTempl2sqlExpr(string16.substring(1, string16.length() - 1), rrIRI, string2 + ".", stringBuffer, arrayList3, arrayList4, null, this.ctx);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string14 = null;
                string14 = arrayList3.size() == 0 ? "1=1" : this.find_optimized_CondExpr(string, arrayList3, arrayList4, string2, rRTabRowInfo.Tmap, null);
                this.log("[bgp_graph is constant] gCondExpr: " + (String)object2 + " optimized_gCondExpr: " + string14);
                if (string14 != null) {
                    object2 = COND_CONNECTOR + string14;
                }
            }
            string7 = string7 + (String)object2;
            this.log("===>COND (after considering TpGE gExpr=" + string3 + ": " + string7);
        }
        if ((n & 2) != 2) return string8 + string7;
        object = "";
        string3 = "";
        boolean bl2 = false;
        for (String string17 : this.ctx.namedGraphsList) {
            string3 = string3 + (String)object + "'" + string17.replace("'", "''") + "'";
            if (bl && string.equals(string17)) {
                bl2 = true;
                break;
            }
            if (((String)object).length() != 0) continue;
            object = ", ";
        }
        if (bl) {
            if (!bl2) {
                this.log("NO-MATCH for GRAPH clause constant (" + string + ") in FROM NAMED list (" + string3 + ")");
                return string6;
            }
            this.log("found GRAPH clause constant (" + string + ") in (partial) FROM NAMED list (" + string3 + ")");
            string8 = "";
            return string8 + string7;
        } else {
            if (!this.is_bgp_graph_a_var) throw new RDFException("INTERNAL ERROR: SHOULD NEVER REACH THIS CODE: graph_use_mode=" + n + " bgp_graph=" + string + " is_bgp_graph_const=" + bl + " is_bgp_graph_a_var=" + this.is_bgp_graph_a_var);
            string8 = COND_CONNECTOR + string4 + " IN (" + string3 + ")";
        }
        return string8 + string7;
    }

    String get_po_CondExpr(int n, String string, String string2) {
        int n2;
        String string3 = "+" + n + ":";
        if (n == -1) {
            string3 = "S:";
        }
        if ((n2 = string.indexOf(string3)) == -1) {
            return "";
        }
        int n3 = string.indexOf("L", n2);
        this.log("str=" + string3 + " pos1=" + n2 + " pos2=" + n3);
        int n4 = Integer.parseInt(string.substring(n2 + string3.length(), n3));
        int n5 = string.indexOf(NATIVE_SUFFIX, n3);
        int n6 = Integer.parseInt(string.substring(n3 + 1, n5));
        String string4 = string2.substring(n4, n4 + n6);
        return string4;
    }

    String buildSQL_NoRows_for_TpatCSRgroup_Tmap(HashMap<String, String> hashMap, ArrayList<String> arrayList) {
        StringBuffer stringBuffer = new StringBuffer("");
        this.log("FirstOccPos_for_tuple=" + hashMap);
        stringBuffer.append("\nSELECT ");
        boolean bl = true;
        for (String string : hashMap.keySet()) {
            this.log("var=" + string);
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append("null AS " + string);
        }
        if (bl) {
            stringBuffer.append("null");
        } else {
            this.log("native_var_list=" + arrayList);
            if (arrayList != null) {
                for (String string : arrayList) {
                    this.log("native_var=" + string);
                    stringBuffer.append(", null AS " + string + NATIVE_SUFFIX);
                }
            }
        }
        stringBuffer.append("\n  FROM DUAL");
        stringBuffer.append("\n WHERE 1=0");
        return stringBuffer.toString();
    }

    String buildSQL_NoRows_for_BGP() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\nSELECT ");
        boolean bl = true;
        for (String string : this.varsList_for_CSRAlias.keySet()) {
            ArrayList<String> arrayList = this.varsList_for_CSRAlias.get(string);
            for (String string2 : arrayList) {
                this.log("var=" + string2);
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append("null AS " + string2);
            }
        }
        if (bl) {
            stringBuffer.append("null");
        }
        stringBuffer.append("\n  FROM DUAL");
        stringBuffer.append("\n WHERE 1=0");
        return stringBuffer.toString();
    }

    /*
     * Could not resolve type clashes
     */
    int buildSQL_for_TpatCSRgroup_Tmap(String string, String string2, int n, int n2, int n3, HashMap<String, String> hashMap, String string3, String string4, int n4, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2, ArrayList<ArrayList<String>> arrayList3, ArrayList<String> arrayList4, ArrayList<String> arrayList5, String string5, String string6, boolean bl, ArrayList<String> arrayList6, ArrayList<HashSet<String>> arrayList7, ArrayList<HashMap<String, String>> arrayList8, ArrayList<String> arrayList9, HashMap<String, ArrayList<Set<String>>> hashMap2, NatVarOpt_Info natVarOpt_Info, ArrayList<UArowNatSelectInfo> arrayList10, HashSet<String> hashSet) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        int n5 = 0;
        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(this.SubjRRrowid_for_Tmap.get(string));
        this.log("entered: buildSQL_for_TpatCSRgroup_Tmap: UAstartPos=" + n2 + ", numRows=" + n3 + " FirstOccPos_for_tuple: " + hashMap);
        String string7 = "UNION ALL";
        if ((this.ctx.R2RFlags & 0x4000L) > 0L) {
            string7 = "UNION";
        }
        boolean bl2 = true;
        for (int i = 0; i < n3; ++i) {
            String string8;
            String string92;
            Object object7;
            Object object2;
            Object object32;
            Object object42;
            Object object5;
            int n6 = n2 + i;
            String string10 = arrayList5.get(n6);
            this.log("condArray[" + n6 + "]=" + string10);
            if (string10.indexOf(" AND 1=0 ") >= 0) {
                this.log("[Tmap=" + string + " abs_rowNum=" + n6 + "] : SKIPPED sql generation because condArray[" + n6 + "] => " + string10);
                ++n5;
                object5 = arrayList10.get(n6);
                ((UArowNatSelectInfo)object5).sqlSubq = stringBuffer.toString();
                ((UArowNatSelectInfo)object5).selListEndpos = new Integer(-1);
                continue;
            }
            this.log("going to process GEOMETRY filters at UAROW level");
            object5 = "";
            for (Object object42 : this.RelExprFilterList_for_BGP) {
                this.log("checking relExpr for GEOMETRY filter: " + ((RelExpr)object42).toString());
                if (((RelExpr)object42).RelExprFlags != 2L) {
                    this.log("buildSQL_for_TpatCSRgroup_Tmap: skipping non-GEOMETRY filter at UAROW level");
                    continue;
                }
                if (((RelExpr)object42).procAtLevel != null && ((RelExpr)object42).procAtLevel.equals("TPAT_LEVEL")) {
                    this.log("buildSQL_for_TpatCSRgroup_Tmap: skipping filter at UAROW level b/c it has already been processed at level: " + ((RelExpr)object42).procAtLevel);
                    continue;
                }
                this.log("going to process GEOMETRY filters at UAROW level");
                this.log("currentbeg of iter value of condExpr_geometry_filter: " + (String)object5);
                object32 = this.genFilter_v3("UAROW_LEVEL", string2, n6, null, arrayList9.get(n6), hashMap, null, (RelExpr)object42, null, arrayList2, arrayList3);
                this.log("condExpr_geo :" + (String)object32);
                if (((String)object32).equals(" AND 1=0 ")) {
                    object5 = " AND 1=0 ";
                    break;
                }
                if (((String)object32).equals("")) {
                    this.log("we did not handle this filter here (probably because some filter vars are NOT in scope (reuqires outer cond)");
                    continue;
                }
                this.log("processed this filter at UAROW level: relExpr.procAtLevel=" + ((RelExpr)object42).procAtLevel);
                object5 = (String)object5 + COND_CONNECTOR + (String)object32;
                this.log("end of iter value of condExpr_geometry_filter: " + (String)object5);
            }
            this.log("finally, UAROW level: condExpr_geometry_filter: " + (String)object5);
            string10 = string10 + (String)object5;
            this.log("[COND] 4 " + string10);
            Object object6 = "";
            for (Object object32 : this.TwoVarRelExprFilterList_for_BGP) {
                if (((RelExpr)object32).L_atom.type != 0 || ((RelExpr)object32).R_atom.type != 0) continue;
                this.log("Two-var filter condition: " + ((RelExpr)object32).toString());
                if (!this.varsList_for_CSRAlias.get(string2).contains(((RelExpr)object32).L_atom.name) || !this.varsList_for_CSRAlias.get(string2).contains(((RelExpr)object32).R_atom.name)) continue;
                this.log("Two-var filter condition: BOTH vars appear in CSR=" + string2);
                object2 = natVarOpt_Info.get_NatVarOpt_Structure(((RelExpr)object32).L_atom.name).get_TFTidx_occInfoSet_pairs(n6);
                object7 = natVarOpt_Info.get_NatVarOpt_Structure(((RelExpr)object32).R_atom.name).get_TFTidx_occInfoSet_pairs(n6);
                string92 = this.genFilter2vCond_new_v2(n6, (RelExpr)object32, (HashMap<Integer, HashSet<String>>)object2, (HashMap<Integer, HashSet<String>>)object7, arrayList9.get(n6), string3, this.sTFT_idx_for_Tmap.get(string), string4, n4, rRTabRowInfo, arrayList, arrayList2, arrayList6, string2);
                object6 = !string92.equals("DUMMY") ? (String)object6 + string92 : (String)object6 + this.genFilter2vCond_new(n6, (RelExpr)object32, (HashMap<Integer, HashSet<String>>)object2, (HashMap<Integer, HashSet<String>>)object7, arrayList9.get(n6), string3, this.sTFT_idx_for_Tmap.get(string), string4, n4, rRTabRowInfo, arrayList, arrayList2, arrayList3, arrayList6, string2);
                string10 = string10 + (String)object6;
            }
            this.log("[COND] 3 " + string10);
            this.log(natVarOpt_Info.toString());
            object42 = this.varsList_for_CSRAlias.get(string2);
            this.log("varsList_for_CSRAlias for " + string2 + ": " + object42);
            object32 = "";
            object2 = "";
            for (String string92 : this.varsList_for_CSRAlias.get(string2)) {
                string8 = this.FullOccInfo_for_VarPlusCSRAlias.get(string92 + "+" + string2);
                int n7 = string8.length() - string8.replace("+", "").length();
                this.log("processing var=" + string92 + " [occCount=" + n7 + "]: FullOccInfo=> " + string8);
                if (n7 == 1) continue;
                object32 = natVarOpt_Info.noVa_compose_multiOccVar_joinCond_for_UArow(string92, string2, n6, string4, n4, arrayList, arrayList2, arrayList6, arrayList9, this.ctx);
                this.log("NATLOCALOPTCOND=" + (String)object32);
                if (((String)object32).indexOf(" AND 1=0 ") >= 0) {
                    object2 = " AND 1=0 ";
                    break;
                }
                object2 = (String)object2 + (String)object32;
            }
            this.log("ALLNATLOCALOPTCOND=" + (String)object2);
            string10 = string10 + (String)object2;
            this.log("[COND] 1 " + string10);
            if (string10.indexOf(" AND 1=0 ") >= 0) {
                this.log("[Tmap=" + string + " abs_rowNum=" + n6 + "] : SKIPPED sql generation because cond (including two-var filters) => " + string10);
                ++n5;
                object42 = arrayList10.get(n6);
                ((UArowNatSelectInfo)object42).sqlSubq = stringBuffer.toString();
                ((UArowNatSelectInfo)object42).selListEndpos = new Integer(-1);
                continue;
            }
            if (bl2) {
                if (n > 0) {
                    stringBuffer.append("\n" + string7);
                }
                stringBuffer.append("\n-- Tmap=" + string + "\n");
                bl2 = false;
            }
            if (i > n5) {
                stringBuffer.append("\n" + string7 + "\n");
            }
            if (i == 0) {
                stringBuffer.append("\n");
            }
            this.log("generating SELECT-list");
            stringBuffer.append("SELECT ");
            object42 = new StringBuffer("");
            boolean bl3 = true;
            for (Object object7 : hashMap.keySet()) {
                String string11;
                Object object8;
                this.log("SELECT-list: var=" + (String)object7);
                if (this.dummyTBList.size() > 0 && (((String)object7).equals("dummyS") || ((String)object7).equals("dummyP") || ((String)object7).equals("dummyO"))) continue;
                if (!bl3) {
                    ((StringBuffer)object42).append(", ");
                } else {
                    bl3 = false;
                }
                string92 = hashMap.get(object7);
                string8 = this.getExprFromArrays(string92, n6, string4, arrayList, arrayList2, arrayList6, null);
                this.log("SELECT-list: var=" + (String)object7 + " occPos=" + string92 + " expr=" + string8);
                if (string8.substring(0, "'_:".length()).equals("'_:") && (this.ctx.R2RFlags & 0x40L) != 64L) {
                    String string12 = "";
                    if (arrayList7 != null && arrayList7.get(n6) != null && arrayList7.get(n6).size() > 0 && (this.ctx.R2RFlags & 0x80L) != 128L && (object8 = arrayList7.get(n6).iterator()).hasNext() && (string11 = (String)object8.next()) != null && !string11.equals("NULL")) {
                        string12 = "g' || utl_raw.cast_to_raw(" + string11 + ") || 'g";
                    }
                    object8 = "'_:m" + this.model_id + string12 + "m";
                    this.log("expr=" + string8 + " | bNode_augm=" + (String)object8);
                    if (string8.indexOf((String)object8) != 0) {
                        string8 = (String)object8 + string8.substring("'_:".length(), string8.length());
                        this.log("SELECT-list (after bNode prefix augmentation): var=" + (String)object7 + " occPos=" + string92 + " expr=" + string8);
                    }
                }
                ((StringBuffer)object42).append(string8 + ALIAS_SEP + (String)object7);
                if (!string92.startsWith("object:")) continue;
                int n8 = Integer.valueOf(string92.substring(string92.indexOf(":") + 1));
                this.log("pos=" + n8 + " clobExprArrays [size=" + arrayList3.size() + "]: " + arrayList3);
                object8 = arrayList3.get(n8).get(n6);
                this.log("CLOB expression found: " + (String)object8);
                this.log("SELECT-list: var=" + (String)object7 + " occPos=" + string92 + " clobExpr=" + (String)object8);
                string11 = (String)object7 + "$RDFCLOB";
                ((StringBuffer)object42).append(", " + (String)object8 + ALIAS_SEP + string11);
                hashSet.add((String)object7 + "+" + string2);
            }
            if (((StringBuffer)object42).length() == 0) {
                ((StringBuffer)object42).append("NULL");
            }
            this.log("[abs_rowNum=" + n6 + "]: SelectList=" + ((StringBuffer)object42).toString());
            stringBuffer.append(((StringBuffer)object42).toString());
            Integer n9 = new Integer(stringBuffer.length());
            this.log("[abs_rowNum=" + n6 + "]: FROM-clause=" + string5 + arrayList4.get(n6));
            stringBuffer.append("\n  FROM " + string5 + arrayList4.get(n6));
            object2 = "";
            if (this.graph_use_mode > 0) {
                object2 = this.getGraphCondition_for_UnionOperand(this.graph_use_mode, string6, bl, n6, arrayList8, arrayList9, string2);
                this.log("graphCondition: ------------- \n" + (String)object2);
                string10 = string10 + (String)object2;
            }
            this.log("[COND] 2 " + string10);
            if (string10.indexOf(COND_CONNECTOR) == 0) {
                this.log("cond (before removal)=" + string10);
                string10 = string10.substring(COND_CONNECTOR.length(), string10.length());
                this.log("cond (AFTER removal)=" + string10);
            }
            if (!string10.equals("") && !string10.equals("\n")) {
                stringBuffer.append("\n WHERE " + string10 + "\n");
                this.log("[abs_rowNum=" + n6 + "]: WHERE-clause cond (cond.length()=" + string10.length() + "]=" + string10 + "***");
            }
            object7 = arrayList10.get(n6);
            ((UArowNatSelectInfo)object7).sqlSubq = stringBuffer.toString();
            ((UArowNatSelectInfo)object7).selListEndpos = n9;
            stringBuffer = new StringBuffer("");
        }
        return n3 - n5;
    }

    private boolean isTrueMatchingRRrow_for_Tmap(RRTabRowInfo rRTabRowInfo, String string, String string2, boolean bl, boolean bl2, String string3, boolean bl3, String string4, boolean bl4) throws RDFException {
        String string5;
        String string6;
        Object object;
        Object object2;
        int n;
        this.log("checking ...");
        if (rRTabRowInfo == null) {
            this.log("->SKIPPED deleted RRrowInfo");
            return false;
        }
        if (!rRTabRowInfo.Tmap.equals(string)) {
            this.log("->skipped non-matching Tmap=" + rRTabRowInfo.Tmap);
            return false;
        }
        if (rRTabRowInfo.pogExpr == null) {
            boolean bl5 = true;
            if (this.graph_use_mode == 0 && !bl5 || string2 == null && (this.graph_use_mode & 1) == 1 || string2 != null && !bl2) {
                this.log("->skipped: unnamed graph not allowed: bgp_graph=" + string2 + " graph_use_mode=" + this.graph_use_mode);
                return false;
            }
        }
        if (!bl3) {
            for (RelExpr object32 : this.RelExprFilterList_for_BGP) {
                if (object32.RelExprFlags == 2L) {
                    this.log("skipping GEOMETRY filter");
                    continue;
                }
                n = object32.L_atom.type;
                int string11 = object32.R_atom.type;
                object2 = null;
                object = null;
                if (n == 0 && object32.L_atom.name.equals(string3) && string11 != 0) {
                    object2 = object32.L_atom;
                    object = object32.R_atom;
                } else {
                    if (string11 != 0 || !object32.R_atom.name.equals(string3) || n == 0) continue;
                    object2 = object32.R_atom;
                    object = object32.L_atom;
                }
                string6 = object32.compOperator;
                boolean bl5 = true;
                if (((ASTTripleAtom)object).type != 1 && (string6.equals("=") || string6.equals("SAMETERM"))) {
                    bl5 = false;
                } else if (rRTabRowInfo.pExprType == RRTabRowInfo.MapExprType_CONSTANT) {
                    if (string6.equals("=") || string6.equals("SAMETERM")) {
                        if (!rRTabRowInfo.pExpr.equals("<" + ((ASTTripleAtom)object).name + ">")) {
                            bl5 = false;
                        }
                    } else if ((string6.equals("!=") || string6.equals("DIFFTERM")) && rRTabRowInfo.pExpr.equals("<" + ((ASTTripleAtom)object).name + ">")) {
                        bl5 = false;
                    }
                } else if (rRTabRowInfo.pExprType == RRTabRowInfo.MapExprType_TEMPLATE && (string6.equals("=") || string6.equals("SAMETERM")) && !RelationalBGP.matchableSqlTemplatePair(rRTabRowInfo.pExpr, "<" + ((ASTTripleAtom)object).name + ">", this.ctx)) {
                    bl5 = false;
                }
                if (bl5) continue;
                this.log("NO pred filter-satisfiability of RRrowInfo.pExpr: " + rRTabRowInfo.pExpr + " for [" + object32.toString() + "]");
                return false;
            }
        }
        if ((string5 = rRTabRowInfo.oTermType) == null) {
            if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_TEMPLATE) {
                string5 = rrIRI;
            } else if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_CONSTANT) {
                string5 = rRTabRowInfo.oExpr.charAt(0) == '<' ? rrIRI : (rRTabRowInfo.oExpr.charAt(0) == '\"' ? rrLiteral : rrBlankNode);
            } else if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_COLUMN) {
                string5 = rrLiteral;
            }
            if (rRTabRowInfo.paTmap != null) {
                string5 = rrIRI;
            }
        }
        this.log("oTermType: implicit=" + rRTabRowInfo.oTermType + " explicit=" + string5);
        if (bl4) {
            this.log("checking matchability of RRrowInfo.oExpr: " + rRTabRowInfo.oExpr + " with: " + string4);
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            StringBuffer stringBuffer3 = new StringBuffer("");
            object2 = new StringBuffer("");
            this.findComponents_of_RDFterm(string4, stringBuffer, stringBuffer2, stringBuffer3, (StringBuffer)object2);
            object = stringBuffer.toString();
            string6 = stringBuffer2.toString();
            String string7 = stringBuffer3.toString();
            String string8 = ((StringBuffer)object2).toString();
            String string9 = this.TYPE_FAMILY(string7);
            this.log("obje: vn=" + (String)object + " vt=" + string6 + " lt=" + string7 + " la=" + string8 + " tyfam=" + string9);
            if (string6.equals("PL@") && rRTabRowInfo.oLanguage == null || !string6.equals("PL@") && rRTabRowInfo.oLanguage != null) {
                this.log("NO object-matchability because of lang tag: RRrowInfo.oLanguage: " + rRTabRowInfo.oLanguage + " obje_lang: " + string8);
                return false;
            }
            if (string6.equals("PL@") && rRTabRowInfo.oLanguage != null && !rRTabRowInfo.oLanguage.equalsIgnoreCase(string8)) {
                this.log("NO object-matchability due to lang tag mismatch: RRrowInfo.oLanguage: " + rRTabRowInfo.oLanguage + " obje_lang: " + string8);
                return false;
            }
            if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_TEMPLATE && (rRTabRowInfo.oTermType == null || rRTabRowInfo.oTermType.equals(rrIRI))) {
                if (string4.charAt(0) != '<') {
                    this.log("NO object-matchability of rr:IRI RRrowInfo.oExpr: " + rRTabRowInfo.oExpr + " against non-IRI: " + string4);
                    return false;
                }
                if (!RelationalBGP.matchableSqlTemplatePair(rRTabRowInfo.oExpr, string4, this.ctx)) {
                    this.log("NO object-matchability of rr:IRI RRrowInfo.oExpr: " + rRTabRowInfo.oExpr + " against IRI obje: " + string4);
                    return false;
                }
            } else if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_CONSTANT) {
                if (!rRTabRowInfo.oExpr.equals(string4)) {
                    this.log("IGNORE (to allow caninical equality): NO object-matchability of constant RRrowInfo.oExpr: " + rRTabRowInfo.oExpr + " against constant obje: " + string4);
                    return true;
                }
            } else if (rRTabRowInfo.oExprType == RRTabRowInfo.MapExprType_COLUMN && (rRTabRowInfo.oTermType == null || rRTabRowInfo.oTermType.equals(rrLiteral))) {
                if (string4.charAt(0) != '\"') {
                    this.log("NO object-matchability of col-valued rr:Literal RRrowInfo.oExpr: " + rRTabRowInfo.oExpr + " against constant non-Literal obje: " + string4);
                    return false;
                }
                if (rRTabRowInfo.oDataType != null) {
                    String string10 = this.TYPE_FAMILY(rRTabRowInfo.oDataType.substring(1, rRTabRowInfo.oDataType.length() - 1));
                    this.log("omap_tyfam=" + string10 + " (RRrowInfo.oDataType=" + rRTabRowInfo.oDataType + ")");
                    if (!string10.equals(string9)) {
                        this.log("Skip: NOT MATCHABLE: omap_tyfam=" + string10 + " obje_tyfam=" + string9);
                        return false;
                    }
                }
            }
        } else if (this.SimpleConstraintList_for_Var.get(string4) != null) {
            ArrayList<String> arrayList = this.SimpleConstraintList_for_Var.get(string4);
            this.log("isTrueMatchingRRrow_for_Tmap: obje is a var=" + string4 + " ... will check for satisfiability of all the simple constraints involving this var");
            this.log(arrayList.toString());
            for (n = 0; n < arrayList.size(); ++n) {
                String string11 = arrayList.get(n);
                if (!(string11.equals("ISLITERAL") && !string5.equals(rrLiteral) || string11.equals("!ISLITERAL") && string5.equals(rrLiteral) || (string11.equals("ISURI") || string11.equals("ISIRI")) && !string5.equals(rrIRI) || (string11.equals("!ISURI") || string11.equals("!ISIRI")) && string5.equals(rrIRI) || string11.equals("ISBLANK") && !string5.equals(rrBlankNode)) && (!string11.equals("!ISBLANK") || !string5.equals(rrBlankNode))) continue;
                this.log("NO constraint-satisfiability of RRrowInfo.oTermType: " + rRTabRowInfo.oTermType + "(" + string5 + ") with simple constraint: " + string11);
                return false;
            }
        }
        if (rRTabRowInfo.pogExprType != 3) {
            this.log("checking matchability of RRrowInfo.pogExpr: " + rRTabRowInfo.pogExpr);
            this.log("graph_use_mode=" + this.graph_use_mode + " bgp_graph=" + string2 + " defaultGraphList=" + this.ctx.defaultGraphList + " namedGraphsList=" + this.ctx.namedGraphsList);
            if (string2 == null) {
                if ((this.graph_use_mode & 1) == 1 && !RelationalBGP.matchableSqlTemplate_in_list(rRTabRowInfo.pogExpr, this.ctx.defaultGraphList, this.ctx)) {
                    this.log("NO graph-matchability of RRrowInfo.pogExpr: " + rRTabRowInfo.pogExpr + " against FROM graphs: " + this.ctx.defaultGraphList);
                    return false;
                }
            } else if (bl) {
                this.log("here: bgp_graph=" + string2 + " graph_use_mode=" + this.graph_use_mode);
                if ((this.graph_use_mode & 3) == 0) {
                    if (!RelationalBGP.matchableSqlTemplatePair(rRTabRowInfo.pogExpr, string2, this.ctx)) {
                        this.log("NO graph-matchability of RRrowInfo.pogExpr: " + rRTabRowInfo.pogExpr + " against GRAPH clause graph: " + string2);
                        return false;
                    }
                } else if ((this.graph_use_mode & 2) == 2 && !RelationalBGP.matchableSqlTemplatePair(rRTabRowInfo.pogExpr, string2, this.ctx)) {
                    this.log("NO graph-matchability of RRrowInfo.pogExpr: " + rRTabRowInfo.pogExpr + " against GRAPH clause graph: " + string2);
                }
            } else if (this.is_bgp_graph_a_var) {
                if ((this.graph_use_mode & 2) == 2 && !RelationalBGP.matchableSqlTemplate_in_list(rRTabRowInfo.pogExpr, this.ctx.namedGraphsList, this.ctx)) {
                    this.log("NO graph-matchability of RRrowInfo.pogExpr: " + rRTabRowInfo.pogExpr + " against FROM NAMED graphs: " + this.ctx.namedGraphsList);
                    return false;
                }
            } else {
                throw new RDFException("INTERNAL ERROR: SHOULD NEVER REACH THIS CODE: graph_use_mode=" + this.graph_use_mode + " bgp_graph=" + string2 + " is_bgp_graph_const=" + bl + " is_bgp_graph_a_var=" + this.is_bgp_graph_a_var);
            }
        }
        return true;
    }

    private void buildSQLNew() throws RDFException {
        this.log("Entered buildSQLNew");
        this.log("Structures involved here are:");
        this.log("===============================================:");
        this.log("[Use] TpatSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key (CSR key), TpatSet (triple-patterns in this CSR>");
        this.log("[Use] Subj_for_TpatCSRGroup:              Map => <SubjTmapSet_key, Subj>");
        this.log("[Use] TmapSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key, TmapSet (set of Tmaps from matching RR rows)>");
        this.log("[Use] LtabExpr_for_Tmap:                  Map => <Tmap, rowsrc>");
        this.log("[Use] SubjExpr_for_Tmap:                  Map => <Tmap, sTermType+RRrowInfo.sExprType+RRrowInfo.sExpr>");
        this.log("[Use] RRrowSet_for_TriplePattern:         Map => <tp_key, RRrowSet(actually, RRrowidSet)>");
        this.log("-----");
        this.log("[Pop] CSRAlias_for_TpatCSRGroup:          Map => <SubjTmapSet_key (CSR key), CSRAlias (e.g., T0)>");
        this.log("[P/U] CSRAliasSet_for_tuple:              Map => <Var, CSRAliasSet (each CSR corr to a (union) query block)>");
        this.log("[P/U] FirstOccPos_for_tuple (local: CSR): Map => <Var, FirstOcc (position:idx of pred-obje pair, e.g., object:3)>");
        this.log("[P/U] RRrowList_for_Tmap (local: CSR-Tmap): List => <truly matching RRrowids (matchable based on data)>");
        this.log("[Pop] FullOccInfo_for_VarPlusCSRAlias:    Map => <Var+CSRAlias, formatted string => e.g., S:0+O:3+O:12>");
        this.log("[Pop] TypeInfoSet_for_VarPlusCSRAlias:    Map => <Var+CSRAlias, Set<TypeInfo (formatted string => objeDataType RDFdatatype_DBColType>>");
        this.log("===============================================:");
        int n = -1;
        for (String string : this.TpatSet_for_TpatCSRGroup.keySet()) {
            Object object;
            Object object22;
            Iterator<Object> iterator;
            Object object3;
            String string2 = this.Subj_for_TpatCSRGroup.get(string);
            int n2 = -1;
            String string3 = "";
            if (n != -1) {
                string3 = "\n, ";
            }
            String string4 = "T" + ++n;
            this.CSRAlias_for_TpatCSRGroup.put(string, string4);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            this.predList_for_CSRAlias.put(string4, arrayList);
            this.objeList_for_CSRAlias.put(string4, arrayList2);
            this.varsList_for_CSRAlias.put(string4, arrayList3);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            boolean bl = false;
            if (string2.charAt(0) == '<' || string2.charAt(0) == '\"' || string2.charAt(0) == '_') {
                bl = true;
            } else {
                hashMap.put(string2, "subject:0");
                this.add_to_FullOccInfo(string2, string4, "subject", 0);
                if (!arrayList3.contains(string2)) {
                    arrayList3.add(string2);
                }
            }
            boolean bl2 = false;
            if (this.graphVar != null) {
                Set<String> set;
                if (hashMap.get(this.graphVar) == null) {
                    hashMap.put(this.graphVar, "graph:0");
                }
                this.add_to_FullOccInfo(this.graphVar, string4, "graph", 0);
                if (!arrayList3.contains(this.graphVar)) {
                    arrayList3.add(this.graphVar);
                }
                if ((set = this.CSRAliasSet_for_tuple.get(this.graphVar)) == null) {
                    set = new HashSet<String>();
                    this.CSRAliasSet_for_tuple.put(this.graphVar, set);
                }
                if (!set.add(string4)) {
                    this.log("CSRAliasSet for var=" + this.graphVar + " already has alias=" + string4);
                }
            }
            this.log("=================================================== TpatCSR=" + string + " common_subj=" + string2);
            int n3 = 0;
            for (String string5 : this.TpatSet_for_TpatCSRGroup.get(string)) {
                object3 = this.TpatInfo_for_TpatKey.get(string5);
                iterator = ((TriplesBlock)object3).getSubject();
                object22 = ((TriplesBlock)object3).getPredicate();
                object = ((TriplesBlock)object3).getObject();
                String string6 = this.findTerm_for_Element((TriplesBlock.Element)((Object)iterator), "subject", true);
                String i = this.findTerm_for_Element((TriplesBlock.Element)object22, "predicate", true);
                String string9 = this.findTerm_for_Element((TriplesBlock.Element)object, "object", true);
                if (!string2.equals(string6)) {
                    this.log("Exception: [" + string + "]" + " common_subj=" + string2 + " != [" + string5 + "]" + " subj=" + string6);
                }
                arrayList.add(i);
                arrayList2.add(string9);
                if (((TriplesBlock.Element)object22).isVariable()) {
                    if (hashMap.get(i) == null) {
                        hashMap.put(i, "predicate:" + n3);
                    }
                    this.add_to_FullOccInfo(i, string4, "predicate", n3);
                    if (!arrayList3.contains(i)) {
                        arrayList3.add(i);
                    }
                }
                if (((TriplesBlock.Element)object).isVariable()) {
                    if (hashMap.get(string9) == null) {
                        hashMap.put(string9, "object:" + n3);
                    }
                    this.add_to_FullOccInfo(string9, string4, "object", n3);
                    if (!arrayList3.contains(string9)) {
                        arrayList3.add(string9);
                    }
                }
                if (!bl2) {
                    if (((TriplesBlock.Element)((Object)iterator)).isVariable()) {
                        Set<String> set = this.CSRAliasSet_for_tuple.get(string6);
                        if (set == null) {
                            set = new HashSet<String>();
                            this.CSRAliasSet_for_tuple.put(string6, set);
                        }
                        if (!set.add(string4)) {
                            this.log("CSRAliasSet for var=" + string6 + " already has alias=" + string4);
                        }
                    } else {
                        bl = true;
                        char set = string2.charAt(0);
                        if (set == '<') {
                            n2 = 1;
                        } else {
                            throw new RDFException("Exception: only URIs are supported as subject: " + string2);
                        }
                    }
                    bl2 = true;
                }
                if (((TriplesBlock.Element)object22).isVariable()) {
                    Set<String> n4 = this.CSRAliasSet_for_tuple.get(i);
                    if (n4 == null) {
                        n4 = new HashSet<String>();
                        this.CSRAliasSet_for_tuple.put(i, n4);
                    }
                    if (!n4.add(string4)) {
                        this.log("CSRAliasSet for var=" + i + " already has alias=" + string4);
                    }
                }
                if (((TriplesBlock.Element)object).isVariable()) {
                    Set<String> string10 = this.CSRAliasSet_for_tuple.get(string9);
                    if (string10 == null) {
                        string10 = new HashSet<String>();
                        this.CSRAliasSet_for_tuple.put(string9, string10);
                    }
                    if (!string10.add(string4)) {
                        this.log("CSRAliasSet for var=" + string9 + " already has alias=" + string4);
                    }
                }
                this.log("CSRAliasSet_for_tuple: size()=" + this.CSRAliasSet_for_tuple.size() + " : " + this.CSRAliasSet_for_tuple.entrySet());
                ++n3;
            }
            this.log("--> predList=" + arrayList);
            this.log("==> objeList=" + arrayList2);
            this.log("++> FirstOccPos_for_tuple: size()=" + hashMap.size() + " : " + hashMap.entrySet());
            this.log("**> (extended content of) CSRAliasSet_for_tuple: size()=" + this.CSRAliasSet_for_tuple.size() + " : " + this.CSRAliasSet_for_tuple.entrySet());
            this.log("**> (extended content of) FullOccInfo_for_VarPlusCSRAlias: size()=" + this.FullOccInfo_for_VarPlusCSRAlias.size() + " : " + this.FullOccInfo_for_VarPlusCSRAlias.entrySet());
            this.log("**> (extended content (with EMPTY sets) of) TypeInfoSet_for_VarPlusCSRAlias: size()=" + this.TypeInfoSet_for_VarPlusCSRAlias.size() + " : " + this.TypeInfoSet_for_VarPlusCSRAlias.entrySet());
            Set<String> object42 = this.TmapSet_for_TpatCSRGroup.get(string);
            this.log("==> tmapSet=" + object42);
            object3 = new ArrayList();
            for (Object object22 : object42) {
                object = new ArrayList();
                this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap.put(string4 + "+" + (String)object22, (ArrayList<ArrayList<String>>)object);
                boolean bl3 = false;
                this.log("----------------- processing Tmap=" + (String)object22);
                if (bl) {
                    String string7 = this.SubjExpr_for_Tmap.get(object22);
                    char c = string7.charAt(0);
                    int n4 = Integer.parseInt(string7.substring(1, 2));
                    this.log("comparing: common_subj=" + string2 + " SubjExpr=" + string7 + " vtype=" + c + " mapType=" + n4);
                    if (n2 != 1 || c != 'U') {
                        this.log("common_subj and SubjExpr: termType mismatch");
                        bl3 = true;
                    } else if (n4 == RRTabRowInfo.MapExprType_TEMPLATE && !RelationalBGP.matchableSqlTemplatePair(string7.substring(2), string2, this.ctx)) {
                        this.log("NO subject-matchability of SubjExpr.substring(2): " + string7.substring(2) + " against IRI common_subj: " + string2);
                        bl3 = true;
                    }
                    if (bl3) {
                        this.log("common_subj is NOT matchable with SubjExpr for Tmap=" + (String)object22);
                        ((ArrayList)object3).add(object22);
                        this.log("SKIP Tmap=" + (String)object22 + " tmapExclusionList=" + object3);
                        continue;
                    }
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string8 = (String)arrayList.get(i);
                    String string9 = (String)arrayList2.get(i);
                    ArrayList arrayList4 = new ArrayList();
                    ((ArrayList)object).add(arrayList4);
                    this.log("  \n");
                    this.log("\n========== BEGIN pred-obje pair: " + string8 + BASE_PREFIX_COLNAME_SEP + string9);
                    this.log("  \n");
                    boolean bl4 = false;
                    if (string8.charAt(0) == '<') {
                        bl4 = true;
                    }
                    boolean bl5 = false;
                    if (string9.charAt(0) == '<' || string9.charAt(0) == '\"' || string9.charAt(0) == '_') {
                        bl5 = true;
                    }
                    String string10 = string2 + "+" + string8 + "+" + string9;
                    Set<String> set = this.RRrowSet_for_TriplePattern.get(string10);
                    this.log("RRrowSet for tp_key=" + string10 + " size=" + set.size() + " : " + set);
                    int n5 = 0;
                    ArrayList<String> arrayList5 = new ArrayList<String>();
                    for (String string11 : set) {
                        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(string11);
                        this.log("  \n");
                        this.log("checking RRrowid=" + string11);
                        if (!this.isTrueMatchingRRrow_for_Tmap(rRTabRowInfo, (String)object22, this.bgp_graph, this.is_bgp_graph_const, this.graphMatchUnnamed, string8, bl4, string9, bl5)) continue;
                        this.log("buildSQLNew: FOUND TrueMatching RRrowid=" + string11 + " : Tmap=" + rRTabRowInfo.Tmap);
                        arrayList5.add(string11);
                        ++n5;
                        this.add_to_TypeInfoSet(string9, string4, rRTabRowInfo);
                    }
                    if (arrayList5.size() == 0) {
                        this.log("SKIP Tmap=" + (String)object22 + " : because no apparently matching RR rows survived the scrutiny");
                        bl3 = true;
                        break;
                    }
                    this.log("adding RRrowList_for_Tmap (Tmap=" + (String)object22 + ") content to TrueMatchingRRrowList");
                    this.log("before adding: " + arrayList4);
                    arrayList4.addAll(arrayList5);
                    this.log("AFTER  adding: " + arrayList4);
                    this.log("\nEND pred-obje pair: " + string8 + BASE_PREFIX_COLNAME_SEP + string9);
                    this.log("  \n");
                }
                if (bl3) {
                    ((ArrayList)object3).add(object22);
                    this.log("SKIP Tmap=" + (String)object22 + " tmapExclusionList=" + object3);
                    continue;
                }
                this.log("tpCSR_alias=" + string4 + " Tmap=" + (String)object22);
            }
            iterator = ((ArrayList)object3).iterator();
            while (iterator.hasNext()) {
                object22 = (String)iterator.next();
                object42.remove(object22);
            }
            for (Object object22 : object42) {
                this.log("TrueMatchingRRrowListList_for_CSRAliasPlusTmap(" + string4 + "+" + (String)object22 + ") :" + this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap.get(string4 + "+" + (String)object22));
            }
            if (object42.size() == 0) {
                this.log("EMPTY tmapSet: will generate NoRows SQL");
            }
            this.log("**> (extended content of) TypeInfoSet_for_VarPlusCSRAlias: size()=" + this.TypeInfoSet_for_VarPlusCSRAlias.size() + " : " + this.TypeInfoSet_for_VarPlusCSRAlias.entrySet());
        }
        this.log("--> CSRAlias_for_TpatCSRGroup: size()=" + this.CSRAlias_for_TpatCSRGroup.size() + " : " + this.CSRAlias_for_TpatCSRGroup.entrySet());
    }

    private String find_optimized_CondExpr(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2, String string2, String string3, String string4) throws RDFException {
        int n;
        String string5;
        int n2;
        string = string.substring(1, string.length() - 1);
        String string6 = "";
        this.log("Inside find_optimized_CondExpr ...: constant to match=" + string);
        this.log("strList.size()=" + arrayList2.size() + ": " + arrayList2.toString());
        this.log(arrayList.toString());
        int n3 = arrayList2.get(0).length();
        int n4 = arrayList2.get(arrayList2.size() - 1).length();
        if (n3 + n4 >= string.length()) {
            return null;
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n5 = 0;
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            int n6;
            string5 = arrayList2.get(n2);
            if (string5.equals("")) {
                if (n2 == 0) continue;
                if (n2 == arrayList2.size() - 1) {
                    arrayList3.add(string.length());
                    continue;
                }
                this.log("skip cond-opt: THERE_ARE_EMPTY_STRLIST_ELEMENT_IN_THE_MIDDLE AND IT IS NOT POSSIBLE TO ELIMINATE AMBIGUITY");
                return null;
            }
            if (n2 == arrayList2.size() - 1) {
                int n7 = string.length() - string5.length();
                if (!string5.equals(string.substring(n7))) {
                    return "1=0";
                }
                n = n7 - n5;
                if (n < 0) {
                    return "1=0";
                }
                n6 = string.length();
            } else {
                n = string.substring(n5).indexOf(string5);
                if (n < 0) {
                    return "1=0";
                }
                if (n2 == 0 && n > 0) {
                    return "1=0";
                }
                n6 = n5 + n + string5.length();
            }
            arrayList3.add(n5 + n);
            this.log("s=" + n2 + ",search_start=" + n5 + "match_pos=" + n);
            n5 = n6;
        }
        this.log(arrayList3.toString());
        for (n2 = arrayList2.size() - 2; n2 > 0; --n2) {
            string5 = arrayList2.get(n2);
            n5 = (Integer)arrayList3.get(n2) + 1;
            n = string.substring(n5).indexOf(string5);
            this.log("reverse scan: s=" + n2 + ",search_start=" + n5 + "match_pos=" + n);
            if (n < 0 || n5 + n + string5.length() > (Integer)arrayList3.get(n2 + 1)) continue;
            this.log("MyCode: found a second match for strList[" + n2 + "] at position " + (n5 + n));
            return null;
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            Object object;
            String string7;
            int n8 = n2;
            n = n2 + 1;
            String string8 = arrayList.get(n2);
            int n9 = (Integer)arrayList3.get(n8) + arrayList2.get(n8).length();
            int n10 = (Integer)arrayList3.get(n);
            String string9 = string.substring(n9, n10);
            boolean bl = false;
            if (this.LtcRowInfo_for_Tmap_plus_Col != null) {
                string7 = string8.charAt(0) == '\"' && string8.charAt(string8.length() - 1) == '\"' ? string8.substring(1, string8.length() - 1) : string8.toUpperCase();
                this.log("colName=" + string8 + " uColName=" + string7 + " colValue=" + string9);
                object = this.LtcRowInfo_for_Tmap_plus_Col.get(string3 + "+" + string7);
                if (object == null) {
                    this.log("LtcRowInfo absent for: Tmap=" + string3 + " uColName=" + string7 + "***");
                    throw new RDFException("LtcRowInfo absent for: Tmap=" + string3 + " uColName=" + string7 + "***");
                }
                this.log(((LtcTabRowInfo)object).toString());
                if (!((LtcTabRowInfo)object).colTypeName.equals("STRING") && !((LtcTabRowInfo)object).colTypeName.equals(LTC_TYPE_NUMBER)) {
                    this.log("skip-optimization: found column (" + string8 + ") to be of type: " + ((LtcTabRowInfo)object).colTypeName);
                    return null;
                }
                if (((LtcTabRowInfo)object).colTypeName.equals(LTC_TYPE_NUMBER)) {
                    try {
                        double d = Double.parseDouble(string9);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "1=0";
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            string7 = null;
            if (bl) {
                string7 = string9;
            } else {
                try {
                    string7 = "'" + URLDecoder.decode(string9, "UTF-8") + "'";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new RDFException("java.net.URLDecoder(" + string9 + ",UTF-8) failed: see trace file for details");
                }
            }
            try {
                object = TTL_UNESCAPE_BEG;
                String string10 = ")";
                if ((this.ctx.R2RFlags & 0x200L) > 0L || !RelationalBGP.needTTLunescape(string9)) {
                    object = "";
                    string10 = "";
                }
                String string11 = "";
                string11 = !RelationalBGP.needPercentDecode(string9) ? "'" + string9.replace("'", "''") + "'" : ((this.ctx.R2RFlags & 0x10000L) == 65536L ? "sys.utl_url.unescape('" + string9.replace("'", "''") + "'" + ")" : "'" + URLDecoder.decode(string9, "UTF-8").replace("'", "''") + "'");
                string6 = string6 + COND_CONNECTOR + string2 + "." + string8 + "=" + (String)object + string11 + string10;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.log("MyCode:OPTIMIZED_CONDEXPR=" + string6.substring(COND_CONNECTOR.length()));
        return string6.substring(COND_CONNECTOR.length());
    }

    private static boolean needTTLunescape(String string) {
        return string.indexOf(delim) >= 0;
    }

    private static boolean needPercentDecode(String string) {
        return string.indexOf("%") >= 0;
    }

    private boolean isCompatibleTFTpair(int n, int n2) {
        TFTinfo tFTinfo = this.TFTinfoGlobalList.get(n);
        TFTinfo tFTinfo2 = this.TFTinfoGlobalList.get(n2);
        this.log("isCompatibleTFTpair: comparing: TFTidx1=" + n + " TFTidx2=" + n2);
        if (tFTinfo == null || tFTinfo2 == null) {
            this.log("isCompatibleTFTpair: null TFTinfo: TFTinfo1=" + tFTinfo + " TFTinfo2=" + tFTinfo2);
            return true;
        }
        if (!tFTinfo.termType.equals(tFTinfo2.termType)) {
            this.log("isCompatibleTFTpair: termType mismatch: TFTinfo1=" + tFTinfo.termType + " TFTinfo2=" + tFTinfo2.termType);
            return false;
        }
        if (rrLiteral.equals(tFTinfo.termType) && !tFTinfo.datatype_family.equals(tFTinfo2.datatype_family)) {
            this.log("isCompatibleTFTpair: Literals: checking datatype families: TFTinfo1=" + tFTinfo.datatype_family + " TFTinfo2=" + tFTinfo2.datatype_family);
            if (!tFTinfo.datatype_family.equals(TYPE_FAM_NUMERIC) && !tFTinfo.datatype_family.equals(TYPE_FAM_FLOAT) && !tFTinfo.datatype_family.equals(TYPE_FAM_DOUBLE) || !tFTinfo2.datatype_family.equals(TYPE_FAM_NUMERIC) && !tFTinfo2.datatype_family.equals(TYPE_FAM_FLOAT) && !tFTinfo2.datatype_family.equals(TYPE_FAM_DOUBLE)) {
                this.log("isCompatibleTFTpair: Literals: datatype family mismatch: TFTinfo1=" + tFTinfo.datatype_family + " TFTinfo2=" + tFTinfo2.datatype_family);
                return false;
            }
        }
        this.log("isCompatibleTFTpair: all okay: TFTidx1=" + n + " TFTidx2=" + n2);
        return true;
    }

    private int add_TFT(String string, String string2, int n, String string3, String string4, ArrayList<String> arrayList) throws SQLException, RDFException {
        Object object;
        int n2;
        String string5;
        Object object2;
        this.log("add_TFT: INPUT: Tmap=" + string + " | rrExpr=" + string2 + " | exprType=" + n + " | termType=" + string3 + " | datatype=" + string4);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string6 = null;
        if (n == RRTabRowInfo.MapExprType_CONSTANT) {
            object2 = new String[4];
            this.findComponents_of_RDFterm_simple(string2, (String[])object2);
            arrayList2.add(object2[0]);
        } else if (n == RRTabRowInfo.MapExprType_COLUMN) {
            object2 = RelationalBGP.get_base_prefix_from_RR_table(string2);
            if (object2 != null) {
                string5 = RelationalBGP.get_col_name_from_RR_table(string2);
                arrayList2.add((String)object2);
                arrayList.add(string5);
            } else {
                arrayList2.add("");
                arrayList.add(string2);
            }
            arrayList2.add("");
        } else if (n == RRTabRowInfo.MapExprType_TEMPLATE) {
            object2 = RelationalBGP.sqlTempl2sqlExpr(string2.substring(1, string2.length() - 1), string3, "xyz.", null, arrayList, arrayList2, null, this.ctx);
        } else if (n == 0) {
            arrayList2.add(null);
            this.log("adding a dummy TFT for NULL");
        } else {
            throw new RDFException("Exception: unknown exprType: " + n);
        }
        if (string3.equals(rrIRI)) {
            string5 = "U";
        } else if (string3.equals(rrBlankNode)) {
            string5 = "B";
        } else if (string3.equals(rrLiteral)) {
            string5 = "L";
        } else {
            throw new RDFException("Exception: unknown termType: " + string3);
        }
        String string7 = string5 = string5 + n;
        if (string3.equals(rrLiteral)) {
            string6 = string4 == null ? "STRING" : this.TYPE_FAMILY(string4.substring(1, string4.length() - 1));
            if (string6.equals(TYPE_FAM_OTHER)) {
                string6 = string6 + string4;
            }
            string7 = string6.equals(TYPE_FAM_NUMERIC) || string6.equals(TYPE_FAM_FLOAT) || string6.equals(TYPE_FAM_DOUBLE) ? string5 + TYPE_FAM_NUMFLTDBL : string5 + string6;
            string5 = string5 + string6;
        }
        string5 = string5 + BASE_PREFIX_COLNAME_SEP;
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            string5 = string5 + arrayList2.get(n2);
            string7 = string7 + arrayList2.get(n2);
            if (n2 > arrayList.size() - 1) continue;
            object = arrayList.get(n2);
            String string8 = ((String)object).charAt(0) == '\"' ? ((String)object).substring(1, ((String)object).length() - 1) : ((String)object).toUpperCase();
            object2 = string + "+" + string8;
            this.log("add_TFT: Tmap_plus_Col=" + (String)object2);
            LtcTabRowInfo ltcTabRowInfo = this.LtcRowInfo_for_Tmap_plus_Col.get(object2);
            if (ltcTabRowInfo == null) {
                this.log("EXCEPTION-tyfam_template");
                throw new RDFException("add_TFT: returns NULL ltcTablRowInfo for: Tmap_plus_Col=" + (String)object2);
            }
            string5 = string5 + "{" + ltcTabRowInfo.colTypeName + "}";
            string7 = string7 + "{" + GENERIC_TYPE_FAMILY + "}";
            arrayList3.add(ltcTabRowInfo.colTypeName);
        }
        this.log("TYFAM_TEMPL=" + string5 + " (colList: " + arrayList + ")" + " (strList: " + arrayList2 + ")" + " (colTypeList: " + arrayList3 + ")");
        n2 = this.TFTglobalList.indexOf(string5);
        if (n2 == -1) {
            this.TFTglobalList.add(string5);
            this.noTFTglobalList.add(string7);
            n2 = this.TFTglobalList.size() - 1;
            this.log("add_TFT: ADDED at idx=" + n2 + ": " + string5);
            object = new TFTinfo(n2, string5, string3, n, arrayList2, arrayList3, string4, string6, null);
            this.TFTinfoGlobalList.add((TFTinfo)object);
        } else {
            this.log("add_TFT: already present at idx=" + n2 + ": " + string5);
            arrayList2.clear();
            arrayList3.clear();
        }
        this.log("add_TFT: returning idx=" + n2);
        if (n == 0) {
            this.null_TFTidx = n2;
        }
        return n2;
    }

    private String get_tyfam_Templ(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2, String string2) throws RDFException {
        String string3 = string2;
        for (int i = 0; i < arrayList2.size(); ++i) {
            string3 = string3 + arrayList2.get(i);
            if (i > arrayList.size() - 1) continue;
            String string4 = arrayList.get(i);
            String string5 = string4.charAt(0) == '\"' ? string4.substring(1, string4.length() - 1) : string4.toUpperCase();
            String string6 = string + "+" + string5;
            this.log("get_tyfam_Templ: Tmap_plus_Col=" + string6);
            LtcTabRowInfo ltcTabRowInfo = this.LtcRowInfo_for_Tmap_plus_Col.get(string6);
            if (ltcTabRowInfo == null) {
                this.log("EXCEPTION-tyfam_template");
                throw new RDFException("get_tyfam_Templ returns NULL ltcTablRowInfo for: Tmap_plus_Col=" + string6);
            }
            string3 = string3 + "{" + ltcTabRowInfo.colTypeName + "}";
        }
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private String generateSQL() throws RDFException, SQLException {
        void var24_53;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<String> arrayList;
        Object object5;
        Object object6;
        Object object7;
        Object object82;
        Object object9;
        AbstractCollection abstractCollection;
        Object object10;
        Object object11;
        int n;
        Object object12;
        Object object13;
        Object object14;
        ArrayList<String> arrayList2;
        String string;
        String string2;
        Object object15;
        Object object16;
        this.log("Entered generateSQL");
        this.log("Structures involved here are:");
        this.log("===============================================:");
        this.log("[Use] CSRAliasSet_for_tuple:              Map => <Var, CSRAliasSet (each CSR corr to a (union) query block)>");
        this.log("[Use] FullOccInfo_for_VarPlusCSRAlias:    Map => <Var+CSRAlias, formatted string => e.g., S:0+O:3+O:12>");
        this.log("[Use] TypeInfoSet_for_VarPlusCSRAlias:    Map => <Var+CSRAlias, Set<TypeInfo (formatted string => objeDataType RDFdatatype_DBColType>>");
        this.log("[Use] Tmaps_with_nonUnique_Smaps:         Map => <Tmaps>");
        this.log("[Use] TpatSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key (CSR key), TpatSet (triple-patterns in this CSR>");
        this.log("[Use] Subj_for_TpatCSRGroup:              Map => <SubjTmapSet_key, Subj>");
        this.log("[Use] TmapSet_for_TpatCSRGroup:           Map => <SubjTmapSet_key, TmapSet (set of Tmaps from matching RR rows)>");
        this.log("[Use] LtabExpr_for_Tmap:                  Map => <Tmap, rowsrc>");
        this.log("[Use] SubjExpr_for_Tmap:                  Map => <Tmap, sTermType+RRrowInfo.sExprType+RRrowInfo.sExpr>");
        this.log("[Use] RRrowSet_for_TriplePattern:         Map => <tp_key, RRrowSet(actually, RRrowidSet)>");
        this.log("-----");
        this.log("[Pop] NativeVarList_for_CSRAlias:         Map => <CSRAlias, list-of-native-vars (allow direct use of DB cols)>");
        this.log("[Pop] CLOBVarPlusCSRAliasSet_for_BGP:     Map => <Var+CSRAlias (occurrences of CLOB)>");
        this.log("[P/U] FirstOccPos_for_tuple (local: CSR): Map => <Var, FirstOcc (position:idx of pred-obje pair, e.g., object:3)>");
        this.log("[P/U] RRrowList_for_Tmap (local: CSR-Tmap): List => <truly matching RRrowids (matchable based on data)>");
        this.log("===============================================:");
        for (String object192 : this.CSRAliasSet_for_tuple.keySet()) {
            object16 = this.CSRAliasSet_for_tuple.get(object192);
            object15 = object16.iterator();
            while (object15.hasNext()) {
                string2 = object15.next();
                string = object192 + "+" + string2;
                arrayList2 = this.NativeVarList_for_CSRAlias.get(string2);
                String string3 = this.FullOccInfo_for_VarPlusCSRAlias.get(string);
                boolean bl = false;
                if (string3.indexOf("subject") < 0 && string3.indexOf("predicate") < 0 && string3.indexOf("graph") < 0) {
                    bl = true;
                }
                if ((object14 = this.TypeInfoSet_for_VarPlusCSRAlias.get(string)) == null || object14.size() != 1) continue;
                object13 = object14.toArray(new String[0]);
                String string4 = object13[0];
                if (string4.equals(NO_DB_COL_TYPE)) {
                    this.log("SKIP adding var=" + object192 + " to NativeVarList for CSRAlias=" + string2 + " (TypeInfo=" + string4 + ")");
                    continue;
                }
                int n2 = string4.indexOf(BASE_PREFIX_COLNAME_SEP);
                object12 = string4.substring(0, n2);
                n = string4.indexOf(" DB_TYPE=");
                object11 = string4.substring(n2 + BASE_PREFIX_COLNAME_SEP.length(), n);
                this.log("comparing actual and ideal data types: objeDataType=" + (String)object12 + " RDFdatatype=" + (String)object11);
                if (((String)object12).equals(object11)) {
                    this.log("add var=" + object192 + " to NativeVarList for CSRAlias=" + string2);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>();
                        this.NativeVarList_for_CSRAlias.put(string2, arrayList2);
                    }
                    arrayList2.add(object192);
                    continue;
                }
                this.log("SKIP adding var=" + object192 + " to NativeVarList for CSRAlias=" + string2 + " (Type mismatch)");
            }
        }
        this.log("NativeVarList_for_CSRAlias: " + this.NativeVarList_for_CSRAlias);
        this.log("Tmaps_with_nonUnique_Smaps: " + this.Tmaps_with_nonUnique_Smaps);
        ArrayList arrayList4 = new ArrayList();
        NatVarOpt_Info natVarOpt_Info = new NatVarOpt_Info();
        object16 = new HashMap();
        object15 = null;
        string2 = null;
        string = null;
        for (String string5 : this.TpatSet_for_TpatCSRGroup.keySet()) {
            int n3;
            Object object17;
            Object object18;
            Object object19;
            String string6 = this.Subj_for_TpatCSRGroup.get(string5);
            object14 = this.CSRAlias_for_TpatCSRGroup.get(string5);
            object13 = new HashMap();
            this.populate_FirstOccPos_for_TpatCSRgroup((HashMap<String, String>)object13, (String)object14);
            boolean bl = false;
            if (string6.charAt(0) == '<' || string6.charAt(0) == '\"' || string6.charAt(0) == '_') {
                bl = true;
            } else {
                this.log("common_subj is variable: " + string6);
            }
            boolean bl2 = false;
            if (this.graphVar != null) {
                this.log("graphVar=" + this.graphVar);
            }
            this.log("=================================================== TpatCSR=" + string5 + " common_subj=" + string6);
            ArrayList<String> arrayList3 = this.predList_for_CSRAlias.get(object14);
            object12 = this.objeList_for_CSRAlias.get(object14);
            object10 = this.TmapSet_for_TpatCSRGroup.get(string5);
            this.log("--> predList=" + arrayList3);
            this.log("==> objeList=" + object12);
            this.log("==> tmapSet=" + object10);
            n = 0;
            object11 = null;
            ArrayList<HashSet<String>> arrayList5 = null;
            ArrayList<HashMap<String, String>> arrayList6 = null;
            if (this.graph_use_mode > 0) {
                arrayList5 = new ArrayList<HashSet<String>>();
                arrayList6 = new ArrayList<HashMap<String, String>>();
                if (this.is_bgp_graph_a_var) {
                    object11 = new ArrayList();
                }
            }
            abstractCollection = new ArrayList();
            object9 = new ArrayList();
            ArrayList<String> arrayList7 = new ArrayList<String>();
            ArrayList<ArrayList<String>> arrayList8 = new ArrayList<ArrayList<String>>();
            object82 = 0;
            while ((Integer)object82 < ((ArrayList)object12).size()) {
                arrayList8.add(new ArrayList());
                object7 = object82;
                object6 = object82 = Integer.valueOf((Integer)object82 + 1);
            }
            object82 = new ArrayList();
            object7 = 0;
            while ((Integer)object7 < ((ArrayList)object12).size()) {
                ((ArrayList)object82).add(new ArrayList());
                object6 = object7;
                object5 = object7 = Integer.valueOf((Integer)object7 + 1);
            }
            object7 = new ArrayList();
            for (int i = 0; i < arrayList3.size(); ++i) {
                ((ArrayList)object7).add(new ArrayList());
            }
            object6 = new ArrayList();
            object5 = new HashMap();
            arrayList = this.NativeVarList_for_CSRAlias.get(object14);
            if (arrayList != null) {
                for (String string7 : arrayList) {
                    ((HashMap)object5).put(string7, new ArrayList());
                }
            }
            this.log("[CSRAlias=" + (String)object14 + "] => native_oExprSetArray_for_Var: " + object5);
            HashMap hashMap = new HashMap();
            HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
            object4 = new HashMap();
            object3 = new HashMap();
            object2 = new HashMap();
            Iterator iterator = object10.iterator();
            while (iterator.hasNext()) {
                int n4;
                Object object20;
                String string8;
                String string9;
                String string10;
                object = (String)iterator.next();
                this.log("----------------- processing Tmap=" + (String)object);
                this.log("UAstartPos for the Tmaps processed so far: " + hashMap);
                int n5 = ((ArrayList)object9).size();
                hashMap.put(object, n5);
                object19 = this.RRrowFlags_for_Tmap.get(object);
                this.log("RRrowFlags_string=" + (String)object19);
                int n6 = 0;
                if (object19 != null) {
                    n6 = Integer.parseInt(this.RRrowFlags_for_Tmap.get(object));
                }
                this.log("RRrowFlags=" + n6);
                object18 = this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap.get((String)object14 + "+" + (String)object);
                String string11 = this.LtabExpr_for_Tmap.get(object);
                this.log("LtabExpr=" + string11);
                object17 = this.RRrowInfo_for_MatchingRow.get(this.SubjRRrowid_for_Tmap.get(object));
                String string12 = this.SubjExpr_for_Tmap.get(object);
                String string13 = string12.substring(0, 2);
                String string14 = null;
                UArowNatSelectInfo uArowNatSelectInfo = new UArowNatSelectInfo();
                String string15 = null;
                String string16 = null;
                int n7 = 0;
                StringBuffer stringBuffer = new StringBuffer("");
                ArrayList<String> arrayList9 = new ArrayList<String>();
                ArrayList<String> arrayList10 = new ArrayList<String>();
                try {
                    this.log("sExprTypeAndTermType_code=" + string13);
                    if (string13.equals("U1")) {
                        string10 = string12.substring(3, string12.length() - 1);
                        string16 = RelationalBGP.sqlTempl2sqlExpr(string10, rrIRI, (String)object14 + ".", stringBuffer, arrayList9, arrayList10, ((RRTabRowInfo)object17).sColTypeList, this.ctx);
                        string16 = "'<'||" + string16 + "||'>'";
                        n7 = RRTabRowInfo.MapExprType_TEMPLATE;
                        if (!bl) {
                            this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(object), (String)object, arrayList9, arrayList10, string6, "subject:0", (String)object14, null, 0, 0, 0, natVarOpt_Info, uArowNatSelectInfo);
                        }
                    } else if (string13.equals("U2")) {
                        string10 = string12.substring(2, string12.length());
                        string16 = "'" + string10 + "'";
                        n7 = RRTabRowInfo.MapExprType_CONSTANT;
                        if (!bl) {
                            this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(object), (String)object, null, null, string6, "subject:0", (String)object14, null, 0, 0, 0, natVarOpt_Info, uArowNatSelectInfo);
                        }
                    } else if (string13.equals("U3")) {
                        string9 = TTL_ESCAPE_BEG;
                        string8 = ")";
                        if ((this.ctx.R2RFlags & 0x200L) > 0L) {
                            string9 = "";
                            string8 = "";
                        } else if ((this.ctx.R2RFlags & 0x20000L) > 0L) {
                            string8 = ", options=>' ESC_SBYTE_OPT=F ')";
                        }
                        string10 = string12.substring(2, string12.length());
                        object20 = RelationalBGP.get_base_prefix_from_RR_table(string10);
                        if (object20 != null) {
                            String string17 = RelationalBGP.get_col_name_from_RR_table(string10);
                            string16 = "sdo_rdf.criri('" + ((String)object20).replace("'", "''") + "'," + string9 + (String)object14 + "." + string17 + string8 + ")";
                            arrayList9.add(string17);
                            arrayList10.add((String)object20);
                        } else {
                            string16 = "sdo_rdf.criri(NULL," + string9 + (String)object14 + "." + string10 + string8 + ")";
                            arrayList9.add(string10);
                            arrayList10.add("");
                        }
                        n7 = RRTabRowInfo.MapExprType_COLUMN;
                        if (!bl) {
                            this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(object), (String)object, arrayList9, arrayList10, string6, "subject:0", (String)object14, null, 0, 0, 0, natVarOpt_Info, uArowNatSelectInfo);
                        }
                    } else if (string13.equals("B1")) {
                        string10 = string12.substring(3, string12.length() - 1);
                        string16 = RelationalBGP.sqlTempl2sqlExpr(string10, rrBlankNode, (String)object14 + ".", stringBuffer, arrayList9, arrayList10, null, this.ctx);
                        if ((n6 & 1) == 1) {
                            string16 = "'_:' || 'BlankNode' || to_char(sys_op_combined_hash(" + string16 + "), 'FMXXXXXXXXXXXXXXXX', " + "'NLS_Numeric_Characters=''.,'''" + ")";
                            this.log("notNullColCondExpr for null-col check in subject is being cleared: " + stringBuffer);
                            stringBuffer.setLength(0);
                        } else {
                            string16 = "'_:' || sdo_rdf.cbnod(" + string16 + ")";
                        }
                        n7 = RRTabRowInfo.MapExprType_TEMPLATE;
                        if (!bl) {
                            this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(object), (String)object, arrayList9, arrayList10, string6, "subject:0", (String)object14, null, 0, 0, 0, natVarOpt_Info, uArowNatSelectInfo);
                        }
                    } else if (string13.equals("B2")) {
                        string10 = string12.substring(2, string12.length());
                        string16 = "'" + string10 + "'";
                        n7 = RRTabRowInfo.MapExprType_CONSTANT;
                        if (!bl) {
                            this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(object), (String)object, null, null, string6, "subject:0", (String)object14, null, 0, 0, 0, natVarOpt_Info, uArowNatSelectInfo);
                        }
                    } else if (string13.equals("B3")) {
                        string10 = string12.substring(2, string12.length());
                        string16 = "'_:' || sdo_rdf.cbnod(" + (String)object14 + "." + string10 + ")";
                        n7 = RRTabRowInfo.MapExprType_COLUMN;
                        arrayList9.add(string10);
                        arrayList10.add("");
                        if (!bl) {
                            this.store_noVa_related_Info(this.sTFT_idx_for_Tmap.get(object), (String)object, arrayList9, arrayList10, string6, "subject:0", (String)object14, null, 0, 0, 0, natVarOpt_Info, uArowNatSelectInfo);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ((HashMap)object4).put(object, string16);
                ((HashMap)object3).put(object, new Integer(n7));
                this.log("iUriExpr=" + string16 + " notNullColCondExpr=" + stringBuffer.toString() + " sColList :" + arrayList9 + " sStrList: " + arrayList10 + " RRrowFlags=" + n6);
                this.log("TYFAM_TEMPL=" + string15);
                this.log("NATVAROPTINFO=" + natVarOpt_Info);
                this.log("UArowNatSelectInfo_for_Copy=" + uArowNatSelectInfo);
                string10 = "";
                string9 = null;
                if (bl) {
                    string10 = "'" + string6.replace("'", "''") + "'" + "=" + string16;
                    string8 = string12.substring(2, string12.length());
                    object20 = RelationalBGP.get_base_prefix_from_RR_table(string8);
                    this.log("SubjExpr=" + string12 + " sExpr=" + string8 + " sbase_prefix=" + (String)object20);
                    if (!string13.equals("U3")) {
                        string9 = this.find_optimized_CondExpr(string6, arrayList9, arrayList10, (String)object14, (String)object, null);
                        this.log("[common_subj is constant] sCondExpr: " + string10 + " optimized_sCondExpr: " + string9);
                        if (string9 != null) {
                            string10 = string9;
                        }
                    } else {
                        this.log("[common_subj is constant] sCondExpr: " + string10 + " SKIPPED optimized_sCondExpr attempt because: non-null sbase_prefix= " + (String)object20 + " and column-valued subjectMap");
                    }
                }
                this.log("[STARTING] commonSubj-var Filter Condition");
                string8 = "";
                if (!bl) {
                    this.log("variable in common subject-position: generating condition (if any) based on FILTER: " + string6);
                    this.log("toSQL: RelExprFilterList_for_BGP=> " + this.RelExprFilterList_for_BGP.toString());
                    this.log("=>");
                    for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                        this.log(relExpr.toString());
                        if (relExpr.RelExprFlags == 2L) {
                            this.log("skipping GEOMETRY filter");
                            continue;
                        }
                        if ((relExpr.L_atom.type != 0 || !relExpr.L_atom.name.equals(string6) || relExpr.R_atom.type == 0) && (relExpr.R_atom.type != 0 || !relExpr.R_atom.name.equals(string6) || relExpr.L_atom.type == 0)) continue;
                        string8 = string8 + this.genFilterCond_new(relExpr, (RRTabRowInfo)object17, 0, string16, (String)object14);
                        this.log("condExpr_commonSubj_filter_delta: " + string8);
                    }
                }
                this.log("condExpr_commonSubj_filter_delta[AFTER]: " + string8);
                string10 = string10 + string8;
                this.log("[common_subj: added condExpr_commonSubj_filter_delta] sCondExpr: " + string10);
                if (stringBuffer.length() > 0) {
                    string10 = string10 + stringBuffer.toString();
                    this.log("[common_subj: added notNullColCondExpr] sCondExpr: " + string10);
                }
                int n8 = 1;
                boolean bl3 = false;
                int n9 = 0;
                for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                    int n10;
                    Object object21;
                    String string18 = arrayList3.get(n4);
                    String string19 = (String)((ArrayList)object12).get(n4);
                    ArrayList arrayList11 = (ArrayList)((ArrayList)object18).get(n4);
                    this.log("  \n");
                    this.log("\n========== BEGIN pred-obje pair: " + string18 + BASE_PREFIX_COLNAME_SEP + string19);
                    this.log("  \n");
                    boolean bl4 = false;
                    if (string18.charAt(0) == '<') {
                        bl4 = true;
                    }
                    boolean bl5 = false;
                    if (string19.charAt(0) == '<' || string19.charAt(0) == '\"' || string19.charAt(0) == '_') {
                        bl5 = true;
                    }
                    String string20 = string6 + "+" + string18 + "+" + string19;
                    this.log("TrueMatchingRRrowList for tp_key=" + string20 + " size=" + arrayList11.size() + " : " + arrayList11);
                    if (arrayList11.size() == 0) {
                        this.log("SKIP Tmap=" + (String)object + " (empty TrueMatchingRRrowList): tp_key=" + string20);
                        throw new RDFException("EXCEPTION: $$$TBD$$$ this case should not arise after Tmap eliminatins during analysis: crash");
                    }
                    int n11 = 0;
                    ArrayList arrayList12 = arrayList11;
                    for (String string21 : arrayList12) {
                        object21 = this.RRrowInfo_for_MatchingRow.get(string21);
                        this.log("  \n");
                        this.log("checking RRrowid=" + string21);
                        this.log("generateSQL: FOUND RRrowid=" + string21 + " : Tmap=" + ((RRTabRowInfo)object21).Tmap);
                        if (string14 == null) {
                            string14 = string11 + BASE_PREFIX_COLNAME_SEP + (String)object14;
                            this.log("initializing: fromLtabPlusAlias=" + string14);
                            ((HashMap)object2).put(object, string14);
                        }
                        if (n4 <= 0 || ++n11 <= 1) continue;
                        this.log("  need to multiply: RRrow_match_count=" + n11 + " po_idx=" + n4);
                        this.multiplyUnionArrays(n4, (ArrayList<ArrayList<String>>)object7, arrayList8, (ArrayList<ArrayList<String>>)object82, n8, n9, (ArrayList<String>)abstractCollection, (ArrayList<String>)object9, arrayList7, this.bgp_graph, this.is_bgp_graph_const, (ArrayList<String>)object11, arrayList5, arrayList6, (HashMap<String, ArrayList<Set<String>>>)object5, natVarOpt_Info, n5, (ArrayList<UArowNatSelectInfo>)object6);
                        this.log("  updated multiply_writePos (increased by " + n8 + "): new value=" + (n9 += n8));
                    }
                    if (n4 > 0 && n11 > 1) {
                        this.log("  natVarOptInfo: need to multiply: RRrow_match_count=" + n11 + " po_idx=" + n4);
                        natVarOpt_Info.multiply(n5, n8, n11);
                    }
                    this.log("po_idx=" + n4 + ": multiply (if any) is now done: multiply_writePos=" + n9);
                    this.log("po_idx=" + n4 + ": going to populate phase: RRrowList_for_Tmap.size()=" + arrayList12.size() + " :\n " + arrayList12);
                    int n12 = 0;
                    for (n10 = 0; n10 < arrayList12.size(); ++n10) {
                        object21 = (String)arrayList12.get(n10);
                        RRTabRowInfo rRTabRowInfo = this.RRrowInfo_for_MatchingRow.get(object21);
                        this.populateUnionArrays((String)object, n4, n12, (ArrayList<ArrayList<String>>)object7, arrayList8, (ArrayList<ArrayList<String>>)object82, rRTabRowInfo, n8, (String)object14, (ArrayList<String>)abstractCollection, (ArrayList<String>)object9, arrayList7, string18, string19, string10, bl4, bl5, (HashMap<String, String>)object13, string16, this.bgp_graph, this.is_bgp_graph_const, (ArrayList<String>)object11, arrayList5, arrayList6, this.graphMatchUnnamed, (HashMap<String, ArrayList<Set<String>>>)object5, n6, natVarOpt_Info, n5, uArowNatSelectInfo, (ArrayList<UArowNatSelectInfo>)object6);
                        this.log("po_idx=" + n4 + ": populated " + n8 + " (identical) rows starting from rownum=" + n12);
                        this.log("->pExprArrays.get(" + n4 + ").size()=" + ((ArrayList)((ArrayList)object7).get(n4)).size());
                        this.log("-> oExprArrays.get(" + n4 + ").size()=" + arrayList8.get(n4).size());
                        this.log("-> clobExprArrays.get(" + n4 + ").size()=" + ((ArrayList)((ArrayList)object82).get(n4)).size());
                        this.log("updated writePos (increased by " + n8 + "): new value=" + (n12 += n8));
                        this.log("===> NATVAROPTINFO=" + natVarOpt_Info);
                        this.log("===> UArowNatSelectInfoArray=");
                        for (int i = 0; i < ((ArrayList)object6).size(); ++i) {
                            this.log("  " + ((ArrayList)object6).get(i));
                        }
                    }
                    this.log("===> UArowNatSelectInfoArray=");
                    for (n10 = 0; n10 < ((ArrayList)object6).size(); ++n10) {
                        this.log("  " + ((ArrayList)object6).get(n10));
                    }
                    if (n4 == 0) {
                        n9 = n12;
                        this.log("initalized multiply_writePos (to same value as writePos=" + n12 + "): new value=" + n9);
                    } else if (n12 != n9) {
                        this.log("EXCEPTION: po_idx=" + n4 + "(>0) BUT: writePos (" + n12 + ") != multiply_writePos (" + n9 + ")");
                    }
                    n8 = n12;
                    this.log("updated rowBlock_size (same as writePos=" + n12 + "): new value=" + n8 + "\n");
                    this.log("\nEND pred-obje pair: " + string18 + BASE_PREFIX_COLNAME_SEP + string19);
                    this.log("  \n");
                }
                this.log("===> UArowNatSelectInfoArray=");
                for (n4 = 0; n4 < ((ArrayList)object6).size(); ++n4) {
                    this.log("  " + ((ArrayList)object6).get(n4));
                }
                hashMap2.put(object, ((ArrayList)object9).size() - n5);
                this.log("++++++++++++++++++++++++++++++++++ Tmap=" + (String)object + " +++++++++++++++++++++++++++++++++++++++");
                this.log("iUriExpr: " + string16);
                this.log("sCondExpr: \n" + this.prettyPrintCond(string10));
                for (n4 = 0; n4 < ((ArrayList)object9).size(); ++n4) {
                    this.dumpUnionArrayRow((String)object, n4, (ArrayList<String>)abstractCollection, (ArrayList<String>)object9, arrayList7, arrayList3, (ArrayList<ArrayList<String>>)object7, (ArrayList<String>)object12, arrayList8);
                }
            }
            this.log("===> pExprArrays=" + object7);
            this.log("===> oExprArrays=" + arrayList8);
            this.log("===> TrueMatchingRRrowListList_for_CSRAliasPlusTmap=" + this.TrueMatchingRRrowListList_for_CSRAliasPlusTmap);
            this.log("===> NATVAROPTINFO=" + natVarOpt_Info);
            this.log("===> LtcRowInfo_for_Tmap_plus_Col=" + this.LtcRowInfo_for_Tmap_plus_Col);
            this.log("===> UArowNatSelectInfoArray=" + object6);
            this.log("===> UArowNatSelectInfoArray=");
            for (n3 = 0; n3 < ((ArrayList)object6).size(); ++n3) {
                this.log("  " + ((ArrayList)object6).get(n3));
            }
            n3 = 1;
            for (String string22 : hashMap.keySet()) {
                object19 = (Integer)hashMap.get(string22);
                Integer n13 = (Integer)hashMap2.get(string22);
                object18 = (String)((HashMap)object4).get(string22);
                int n14 = (Integer)((HashMap)object3).get(string22);
                object17 = (String)((HashMap)object2).get(string22);
                int n15 = this.buildSQL_for_TpatCSRgroup_Tmap(string22, (String)object14, n, (Integer)object19, n13, (HashMap<String, String>)object13, string6, (String)object18, n14, (ArrayList<ArrayList<String>>)object7, arrayList8, (ArrayList<ArrayList<String>>)object82, (ArrayList<String>)object9, arrayList7, (String)object17, this.bgp_graph, this.is_bgp_graph_const, (ArrayList<String>)object11, arrayList5, arrayList6, (ArrayList<String>)abstractCollection, (HashMap<String, ArrayList<Set<String>>>)object5, natVarOpt_Info, (ArrayList<UArowNatSelectInfo>)object6, this.CLOBVarPlusCSRAliasSet_for_BGP);
                if (n15 > 0) {
                    ++n;
                    continue;
                }
                this.log("EMPTY SQL for TpatCSRgroup_Tmap=" + string5 + "+" + string22);
            }
            this.log("===> UArowNatSelectInfoArray=");
            for (int i = 0; i < ((ArrayList)object6).size(); ++i) {
                this.log("  " + ((ArrayList)object6).get(i));
            }
            if (object10.size() == 0 || n == 0) {
                this.log("EMPTY tmapSet: generating NoRows SQL");
                this.log("NativeVarList_for_CSRAlias (size=" + this.NativeVarList_for_CSRAlias.size() + "): " + this.NativeVarList_for_CSRAlias.toString());
                String string23 = this.buildSQL_NoRows_for_TpatCSRgroup_Tmap((HashMap<String, String>)object13, this.NativeVarList_for_CSRAlias.get(object14));
                string2 = string5;
                string = this.CSRAlias_for_TpatCSRGroup.get(string5);
                object15 = this.buildSQL_NoRows_for_BGP();
                this.log("NoRows_sql_str_BGP [TpatCSR=" + string5 + "]: \n" + (String)object15);
                UArowNatSelectInfo uArowNatSelectInfo = new UArowNatSelectInfo();
                uArowNatSelectInfo.sqlSubq = string23;
                uArowNatSelectInfo.selListEndpos = new Integer(-2);
                ((ArrayList)object6).add(uArowNatSelectInfo);
            }
            natVarOpt_Info.resetLocalStructure();
            object = (UArowNatSelectInfo)((ArrayList)object6).get(((ArrayList)object6).size() - 1);
            ((UArowNatSelectInfo)object).sqlSubq = ((UArowNatSelectInfo)object).sqlSubq + "\n ) " + (String)object14;
            ((HashMap)object16).put(string5, object6);
        }
        if (this.TpatSet_for_TpatCSRGroup.size() == 0) {
            this.log("EMPTY TpatSet_for_TpatCSRGroup: bgp_graph=" + this.bgp_graph + " graphVar=" + this.graphVar);
            if (this.bgp_graph == null || this.is_bgp_graph_const) {
                return "SELECT null FROM DUAL";
            }
            throw new RDFException("EXCEPTION: we should not reach here => special case: EMPTY-BGP-with-GRAPH-clause");
        }
        arrayList2 = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        object14 = new StringBuffer();
        object13 = "";
        String string24 = "SELECT ";
        if ((this.ctx.R2RFlags & 0x2000L) == 0L) {
            string24 = string24 + " /*+ NO_MERGE */ ";
        }
        String string25 = "WHERE ";
        String string26 = "SELECT /*+ NO_MERGE(T) */ ";
        object12 = new StringBuffer("");
        object10 = new StringBuffer("");
        String string27 = "$SRT";
        boolean bl = false;
        int n16 = 0;
        boolean bl6 = true;
        this.log("==>[NEW_CODE]");
        abstractCollection = new HashSet();
        for (String string28 : this.CSRAliasSet_for_tuple.keySet()) {
            if (this.dummyTBList.size() > 0 && (string28.equals("dummyS") || string28.equals("dummyP") || string28.equals("dummyO"))) continue;
            Set<String> set = this.CSRAliasSet_for_tuple.get(string28);
            object82 = string28 + string27;
            object7 = "";
            this.log("var=" + string28 + " : outer_where_clause_tmp:" + stringBuffer + "***");
            if (natVarOpt_Info.containsVar(string28)) {
                object6 = natVarOpt_Info.get_optOutNatCond_ForVar(string28, set);
                object7 = ((COptNatCondition)object6).notOptChosenExpr;
                stringBuffer.append(((COptNatCondition)object6).optNatCondition);
                this.log("optNatCondition=" + ((COptNatCondition)object6).toString() + "***");
                if (((COptNatCondition)object6).optNatCondition.length() > 0 && this.Geometry_VarSRID.containsKey(string28)) {
                    this.log("This geometry var is needed in the outer condition");
                    abstractCollection.add(string28);
                }
            } else {
                object5 = "";
                arrayList = set.iterator();
                boolean bl7 = false;
                while (arrayList.hasNext()) {
                    object6 = arrayList.next();
                    if (!bl7) {
                        object7 = (String)object6 + "." + string28;
                        bl7 = true;
                        continue;
                    }
                    object5 = (String)object5 + COND_CONNECTOR + (String)object7 + "=" + (String)object6 + "." + string28;
                }
                stringBuffer.append((String)object5);
                this.log("notOptExpr=" + ((String)object5).toString());
            }
            if (string2 != null) {
                stringBuffer.setLength(0);
                object7 = "NULL";
            }
            ++n16;
            if (bl6) {
                void var31_72;
                String string29;
                object3 = "sdo_rdf.";
                if ((this.ctx.R2RFlags & 0x400L) > 0L) {
                    object3 = "orardf$";
                    object13 = FUNC_DECL + "\n";
                } else if ((this.ctx.R2RFlags & 0x800L) > 0L) {
                    object3 = null;
                }
                if (string2 != null) {
                    object6 = "NULL";
                    object5 = "NULL";
                    arrayList = "NULL";
                    string29 = "NULL";
                    String string30 = "NULL";
                    object4 = "NULL";
                } else if (object3 != null) {
                    object6 = (String)object3 + "vname(" + object7 + ")";
                    object5 = (String)object3 + "vtype(" + (String)object7 + ")";
                    arrayList = (String)object3 + "vnpfx(" + (String)object7 + ")";
                    string29 = (String)object3 + "vnsfx(" + (String)object7 + ")";
                    String string31 = (String)object3 + "ltype(" + (String)object7 + ")";
                    object4 = (String)object3 + "latag(" + (String)object7 + ")";
                } else {
                    object6 = RelationalBGP.vname(object7);
                    object5 = RelationalBGP.vtype(object7);
                    arrayList = RelationalBGP.vnpfx(object7);
                    string29 = RelationalBGP.vnsfx(object7);
                    String string32 = RelationalBGP.ltype((String)object7);
                    object4 = RelationalBGP.latag((String)object7);
                }
                this.log("chosen_expr=" + (String)object7);
                object2 = "NULL";
                if (!((String)object7).equals("NULL")) {
                    String string33 = ((String)object7).substring(0, ((String)object7).indexOf("."));
                    object = string28 + "+" + string33;
                    if (this.CLOBVarPlusCSRAliasSet_for_BGP.contains(object)) {
                        object2 = ((String)object).substring(0, ((String)object).indexOf("+")) + "$RDFCLOB";
                        object2 = string33 + "." + (String)object2;
                    }
                }
                ((StringBuffer)object14).append(string24 + "\n" + "TO_NUMBER(NULL)" + ALIAS_SEP + string28 + "$RDFVID" + ", " + (String)object7 + ALIAS_SEP + string28 + "$RDFTERM" + ", " + (String)object6 + ALIAS_SEP + string28 + ", " + (String)object5 + ALIAS_SEP + string28 + "$RDFVTYP" + ", " + (String)((Object)arrayList) + ALIAS_SEP + string28 + "$_PREFIX" + ", " + string29 + ALIAS_SEP + string28 + "$_SUFFIX" + ", " + (String)var31_72 + ALIAS_SEP + string28 + "$RDFLTYP" + ", " + (String)object4 + ALIAS_SEP + string28 + "$RDFLANG" + ", " + "TO_CLOB(" + (String)object2 + ")" + ALIAS_SEP + string28 + "$RDFCLOB");
                string24 = ", ";
                continue;
            }
            stringBuffer2.append(string24 + "sem_apis.sdo_rdf_term(" + object7 + ") AS " + object82);
            string24 = ", ";
            stringBuffer2.append(string24 + object7 + ALIAS_SEP + string28 + "$RDFTERM");
            ((StringBuffer)object10).append("\n" + string26 + "TO_NUMBER(NULL) AS " + string28 + "$RDFVID" + ", " + "T." + string28 + "$RDFTERM" + ", " + "T." + (String)object82 + ".value_name AS " + string28 + ", " + "(CASE " + "when T." + (String)object82 + ".value_type IS NULL then NULL " + "when T." + (String)object82 + ".value_type IN ('UR','URI') then 'URI' " + "when T." + (String)object82 + ".value_type IN ('BN','BLN') then 'BLN' " + "else 'LIT' " + "END) AS " + string28 + "$RDFVTYP" + ", " + "T." + (String)object82 + ".vname_prefix AS " + string28 + "$_PREFIX" + ", " + "T." + (String)object82 + ".vname_suffix AS " + string28 + "$_SUFFIX" + ", " + "T." + (String)object82 + ".literal_type AS " + string28 + "$RDFLTYP" + ", " + "T." + (String)object82 + ".language_type AS " + string28 + "$RDFLANG" + ", " + "T." + (String)object82 + ".long_value AS " + string28 + "$RDFCLOB");
            string26 = ", ";
        }
        this.log("2: outer_where_clause_tmp:" + stringBuffer + "***");
        if (string2 != null) {
            this.log("NoRows_TpatCSR =" + string2 + " : SKIP filter2vdco_condExpr generation");
        } else {
            object9 = this.genFilter2vCond_outer(natVarOpt_Info);
            stringBuffer.append((String)object9);
            this.log("after 2vdco: outer_where_clause_tmp :" + stringBuffer.toString());
        }
        if (string2 != null) {
            this.log("SKIP processing of GEOMETRY filters at OUTER level: NoRows_TpatCSR=" + string2);
        } else {
            this.log("going to process GEOMETRY filters at OUTER level");
            object9 = "";
            for (RelExpr relExpr : this.RelExprFilterList_for_BGP) {
                this.log("checking relExpr for GEOMETRY filter NOT processed in TPAT or UAROW level: " + relExpr.toString());
                if (relExpr.RelExprFlags != 2L) {
                    this.log("buildSQL_for_TpatCSRgroup_Tmap: skipping non-GEOMETRY filter at OUTER level");
                    continue;
                }
                if (relExpr.procAtLevel != null) {
                    this.log("buildSQL_for_TpatCSRgroup_Tmap: skipping filter at OUTER level b/c it has already been processed at level: " + relExpr.procAtLevel);
                    continue;
                }
                this.log("going to process GEOMETRY filters at OUTER level");
                abstractCollection.addAll(relExpr.filterExprTree.getVars());
                this.log("varsNeededInOuterCond_geo: " + abstractCollection);
                object82 = this.genFilter_v3("OUTER_LEVEL", null, -1, null, null, null, natVarOpt_Info, relExpr, null, null, null);
                this.log("condExpr_geo :" + (String)object82);
                if (((String)object82).equals(" AND 1=0 ")) {
                    object9 = " AND 1=0 ";
                    break;
                }
                if (((String)object82).equals("")) {
                    this.log("ERROR: It MUST be handled in outer condition -- check the code");
                    continue;
                }
                relExpr.procAtLevel = "OUTER_LEVEL";
                this.log("processed this filter at OUTER level: relExpr.procAtLevel=" + relExpr.procAtLevel);
                object9 = (String)object9 + COND_CONNECTOR + (String)object82;
            }
            this.log("finally, OUTER level: condExpr_geometry_filter: " + (String)object9);
            stringBuffer.append((String)object9);
        }
        this.log("[COND] " + stringBuffer.toString());
        object9 = BASE_PREFIX_COLNAME_SEP;
        for (Object object82 : ((HashMap)object16).keySet()) {
            int n17;
            if (string2 != null) {
                if (!string2.equals(object82)) {
                    arrayList4.add("\n-- BEGIN TpatCSR=" + object82 + " [alias=" + this.CSRAlias_for_TpatCSRGroup.get(object82) + ": subquery skipped]");
                    arrayList4.add("\n-- END TpatCSR=" + (String)object82);
                    continue;
                }
                arrayList4.add("\n-- BEGIN TpatCSR=" + object82 + "\n" + (String)object9 + "(");
                arrayList4.add(object15 + "\n ) " + string);
                arrayList4.add("\n-- END TpatCSR=" + (String)object82);
                continue;
            }
            arrayList4.add("\n-- BEGIN TpatCSR=" + object82 + "\n" + (String)object9 + "(");
            object9 = ",";
            ArrayList arrayList13 = (ArrayList)((HashMap)object16).get(object82);
            this.log("[HERE] UArowNatSelectInfoArray=" + arrayList13);
            for (n17 = 0; n17 < arrayList13.size(); ++n17) {
                object7 = (UArowNatSelectInfo)arrayList13.get(n17);
                object5 = ((UArowNatSelectInfo)object7).sqlSubq;
                int n18 = ((UArowNatSelectInfo)object7).selListEndpos;
                this.log("SQLSUBQ=" + (String)object5);
                if (n18 >= 0) {
                    arrayList = ((String)object5).substring(0, ((UArowNatSelectInfo)object7).selListEndpos);
                    String string34 = ((String)object5).substring(((UArowNatSelectInfo)object7).selListEndpos, ((String)object5).length());
                    this.log("BEG_SQLSUBQ=" + (String)((Object)arrayList));
                    this.log("END_SQLSUBQ=" + string34);
                    object3 = "";
                    for (String string35 : ((UArowNatSelectInfo)object7).colList_for_var.keySet()) {
                        this.log("var=" + string35 + ": checking if native-cols need to be projected");
                        if (this.CSRAliasSet_for_tuple.get(string35).size() == 1 && !this.VarSet_filter2vCond_outer.contains(string35) && !abstractCollection.contains(string35)) {
                            this.log("--> var=" + string35 + ": not projecting native-cols b/c it appears in 1 CSR and not needed in two-var filter");
                            continue;
                        }
                        ArrayList<String> arrayList14 = ((UArowNatSelectInfo)object7).colList_for_var.get(string35);
                        object2 = this.CSRAlias_for_TpatCSRGroup.get(object82);
                        object3 = (String)object3 + natVarOpt_Info.get_natVarListStr_ForVar(string35, (String)object2, arrayList14, (Set<String>)((Object)abstractCollection));
                        this.log("NATSELLIST=" + (String)object3);
                    }
                    object6 = (String)((Object)arrayList) + (String)object3 + string34;
                    this.log("SQL_STR=" + (String)object6);
                    arrayList4.add(object6);
                    continue;
                }
                arrayList4.add(object5);
            }
            arrayList4.add("\n-- END TpatCSR=" + (String)object82);
            this.log("SQLARRAY_TMP=");
            for (n17 = 0; n17 < arrayList4.size(); ++n17) {
                this.log((String)arrayList4.get(n17));
            }
        }
        this.log("no_clob_outer_select_clause_tmp :" + ((StringBuffer)object14).toString());
        this.log("outer_where_clause_tmp :" + stringBuffer.toString());
        if (this.CSRAliasSet_for_tuple.size() == 0 || n16 == 0) {
            this.log("EMPTY variable-list");
            if (bl6) {
                ((StringBuffer)object14).append(string24 + "NULL");
            } else {
                ((StringBuffer)object10).append("\n" + string26 + "NULL");
                stringBuffer2.append(string24 + "NULL");
            }
        }
        if (bl6) {
            ((StringBuffer)((Object)arrayList2)).append((String)object13 + ((StringBuffer)object14).toString());
        } else {
            ((StringBuffer)((Object)arrayList2)).append(object10 + " FROM (\n");
            ((StringBuffer)((Object)arrayList2)).append(stringBuffer2.toString());
        }
        ((StringBuffer)((Object)arrayList2)).append("\n  FROM");
        boolean bl8 = false;
        while (var24_53 < arrayList4.size()) {
            ((StringBuffer)((Object)arrayList2)).append((String)arrayList4.get((int)var24_53));
            ++var24_53;
        }
        this.log("3: outer_where_clause_tmp:" + stringBuffer + "***");
        stringBuffer.append(" AND EXISTS(" + this.rr_tab_dummy_query + ")");
        this.log("4: outer_where_clause_tmp:" + stringBuffer + "***");
        ((StringBuffer)((Object)arrayList2)).append("\nWHERE " + stringBuffer.substring(COND_CONNECTOR.length()));
        if (!bl6) {
            ((StringBuffer)((Object)arrayList2)).append("\n) T");
        }
        this.log("\n \n FINAL tmp SQL String is [length=" + ((StringBuffer)((Object)arrayList2)).toString().length() + "]: \n");
        this.log(((StringBuffer)((Object)arrayList2)).toString());
        return ((StringBuffer)((Object)arrayList2)).toString();
    }

    private static void printMapSet(HashMap<String, Set<String>> hashMap, SQLGenContext sQLGenContext) {
        for (String string : hashMap.keySet()) {
            RelationalBGP.log_static("Set defined for " + string, sQLGenContext.R2RFlags);
            Set<String> set = hashMap.get(string);
            RelationalBGP.log_static(" corresponding set values : ", sQLGenContext.R2RFlags);
            for (String string2 : set) {
                RelationalBGP.log_static(" : " + string2, sQLGenContext.R2RFlags);
            }
        }
        RelationalBGP.log_static("\n", sQLGenContext.R2RFlags);
    }

    private static void printMapList(HashMap<String, ArrayList<String>> hashMap, SQLGenContext sQLGenContext) {
        for (String string : hashMap.keySet()) {
            RelationalBGP.log_static("Predicate Set defined for Subject Variable " + string, sQLGenContext.R2RFlags);
            ArrayList<String> arrayList = hashMap.get(string);
            RelationalBGP.log_static(" corresponding predicate list : ", sQLGenContext.R2RFlags);
            for (String string2 : arrayList) {
                RelationalBGP.log_static(" : " + string2, sQLGenContext.R2RFlags);
            }
        }
        RelationalBGP.log_static("\n", sQLGenContext.R2RFlags);
    }

    private static void printMap(HashMap<String, String> hashMap, SQLGenContext sQLGenContext) {
        for (String string : hashMap.keySet()) {
            String string2 = hashMap.get(string);
            RelationalBGP.log_static("Entry in set = : " + string + "  " + string2, sQLGenContext.R2RFlags);
        }
        RelationalBGP.log_static("\n", sQLGenContext.R2RFlags);
    }

    @Override
    public String toString(String string) {
        return this.bgp.toString(string);
    }

    static {
        geo_functionArgsMap.put("!", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.w3.org/2001/XMLSchema#boolean")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/relate", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", XSD_STRING_NO_ENCLOSING)));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/relate", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", XSD_STRING_NO_ENCLOSING)));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfEquals", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfContains", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfDisjoint", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfCrosses", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfIntersects", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfOverlaps", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfTouches", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/sfWithin", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/withinDistance", new ArrayList<String>(Arrays.asList("http://www.w3.org/2001/XMLSchema#boolean", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", XSD_DECIMAL_NO_ENCLOSING, XSD_STRING_NO_ENCLOSING)));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/convexHull", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/convexHull", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://www.opengis.net/def/function/geosparql/buffer", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", XSD_DECIMAL_NO_ENCLOSING, XSD_STRING_NO_ENCLOSING)));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/buffer", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", XSD_DECIMAL_NO_ENCLOSING, XSD_STRING_NO_ENCLOSING)));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/centroid", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/mbr", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_funtionRequiringSridTransformationSet.add("http://xmlns.oracle.com/rdf/geo/difference");
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/difference", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_funtionRequiringSridTransformationSet.add("http://xmlns.oracle.com/rdf/geo/intersection");
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/intersection", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_funtionRequiringSridTransformationSet.add("http://xmlns.oracle.com/rdf/geo/union");
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/union", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        geo_funtionRequiringSridTransformationSet.add("http://xmlns.oracle.com/rdf/geo/xor");
        geo_functionArgsMap.put("http://xmlns.oracle.com/rdf/geo/xor", new ArrayList<String>(Arrays.asList("http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral", "http://www.opengis.net/ont/geosparql#wktLiteral")));
        FUNC_DECL = "\nWITH\n\nFUNCTION orardf$vname (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.vname("term") + ";\nEND;" + "\nFUNCTION orardf$vtype (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.vtype("term") + ";\nEND;" + "\nFUNCTION orardf$vnpfx (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.vnpfx("term") + ";\nEND;" + "\nFUNCTION orardf$vnsfx (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.vnsfx("term") + ";\nEND;" + "\nFUNCTION orardf$ltype (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.ltype("term") + ";\nEND;" + "\nFUNCTION orardf$latag (term varchar2) RETURN varchar2 deterministic AS\nBEGIN\nRETURN\n" + RelationalBGP.latag("term") + ";\nEND;";
        sqlcompOper_clobCompare_map = RelationalBGP.create_map_of_strings(new String[]{"=", "!=", ">", "<", ">=", "<="}, new String[]{" = 0 ", " != 0 ", " = 1 ", " = -1 ", " >= 0 ", " <= 0 "});
    }

    public class SpatialArgTypeException
    extends SpatialFilterHandler.SpatialArgException {
        SpatialArgTypeException(String string) {
            super(string);
        }
    }

    private static class R2R2MatSPARQLFilterMap {
        public static final String ATOM_TYPE_URI = "ATOM_TYPE_URI";
        public static final Integer _ATOM_TYPE_URI = 196607;
        private static HashMap<String, Integer> R2R_to_MatSPARQL_type_map = new HashMap();
        private Integer filter_type;
        private String r2r_type;
        private String sql;
        private Long srid;
        private String value_name_0;
        private String value_type_1;
        private String vname_prefix_2;
        private String vname_suffix_3;
        private String literal_type_4;
        private String language_type_5;
        private String long_value_6;
        private String argument_type_7;
        private String arg_8;
        private String geoDimension;
        private String varName;

        R2R2MatSPARQLFilterMap(Integer n, String string) {
            this(n, string, null);
        }

        R2R2MatSPARQLFilterMap(Integer n, String string, Long l) {
            this(new String(), string, l);
            this.filter_type = n;
            this.r2r_type = null;
        }

        R2R2MatSPARQLFilterMap(String string, String string2) {
            this(string, string2, null);
        }

        R2R2MatSPARQLFilterMap(String string, String string2, Long l) {
            this.sql = string2;
            this.r2r_type = string;
            this.filter_type = R2R_to_MatSPARQL_type_map.get(string);
            this.srid = l;
            this.value_name_0 = "''";
            this.value_type_1 = "'LIT'";
            this.vname_prefix_2 = null;
            this.vname_suffix_3 = "''";
            this.literal_type_4 = "''";
            this.language_type_5 = "''";
            this.long_value_6 = "TO_CLOB(NULL)";
            this.argument_type_7 = null;
            this.arg_8 = "LOCAL_VAR";
            this.geoDimension = null;
            this.varName = null;
        }

        public static int getNodeFilterType(String string) {
            return R2R_to_MatSPARQL_type_map.get(string);
        }

        public String getNodeFilterSQL() {
            return this.sql;
        }

        public Integer getNodeFilterType() {
            return this.filter_type;
        }

        public void setVarName(String string) {
            this.varName = string;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setValue_name_0(String string) {
            this.value_name_0 = string;
        }

        public String getValue_name_0() {
            return this.value_name_0;
        }

        public void setValue_type_1(String string) {
            this.value_type_1 = string;
        }

        public String getValue_type_1() {
            return this.value_type_1;
        }

        public void setVname_prefix_2(String string) {
            this.vname_prefix_2 = string;
        }

        public String getVname_prefix_2() {
            return this.vname_prefix_2;
        }

        public void setVname_suffix_3(String string) {
            this.vname_suffix_3 = string;
        }

        public String getVname_suffix_3() {
            return this.vname_suffix_3;
        }

        public void setLiteral_type_4(String string) {
            this.literal_type_4 = string;
        }

        public String getLiteral_type_4() {
            return this.literal_type_4;
        }

        public void setLanguage_type_5(String string) {
            this.language_type_5 = string;
        }

        public String getLanguage_type_5() {
            return this.language_type_5;
        }

        public void setLong_value_6(String string) {
            this.long_value_6 = string;
        }

        public String getLong_value_6() {
            return this.long_value_6;
        }

        public void setArgument_type_7(String string) {
            this.argument_type_7 = string;
        }

        public String getArgument_type_7() {
            return this.argument_type_7;
        }

        public void setArg_8(String string) {
            this.arg_8 = string;
        }

        public String getArg_8() {
            return this.arg_8;
        }

        public void setGeoDimension(String string) {
            this.geoDimension = string;
        }

        public String getGeoDimension() {
            return this.geoDimension;
        }

        public void setFilter_type(Integer n) {
            this.filter_type = n;
        }

        public Integer getFilter_type() {
            return this.filter_type;
        }

        public void setR2r_type(String string) {
            this.r2r_type = string;
        }

        public String getR2r_type() {
            return this.r2r_type;
        }

        public void setSql(String string) {
            this.sql = string;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSrid(Long l) {
            this.srid = l;
        }

        public Long getSrid() {
            return this.srid;
        }

        public String toString() {
            return String.format("         r2r_type: %s \n\t      filter_type: %d \n\t             srid: %s \n\t              sql: %s \n\t     value_name_0: %s \n\t     value_type_1: %s \n\t   vname_prefix_2: %s \n\t   vname_suffix_3: %s \n\t   literal_type_4: %s \n\t  language_type_5: %s \n\t     long_value_6: %s \n\t  argument_type_7: %s \n\t            arg_8: %s \n\t     geoDimension: %s \n\t          varName: %s \n\t", this.r2r_type == null ? "null" : this.r2r_type, this.filter_type, this.srid, this.sql, this.value_name_0, this.value_type_1, this.vname_prefix_2, this.vname_suffix_3, this.literal_type_4, this.language_type_5, this.long_value_6, this.argument_type_7, this.arg_8, this.geoDimension, this.varName);
        }

        static {
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_DECIMAL_NO_ENCLOSING, 12);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_DOUBLE_NO_ENCLOSING, 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#integer", 12);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_FLOAT_NO_ENCLOSING, 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#int", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#negativeInteger", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#long", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#short", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#unsignedLong", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#unsignedInt", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#unsignedShort", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#unsignedByte", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#positiveInteger", 12);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#byte", 6);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#boolean", 5);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_STRING_NO_ENCLOSING, 11);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_DATE_NO_ENCLOSING, 15);
            R2R_to_MatSPARQL_type_map.put("http://www.w3.org/2001/XMLSchema#time", 16);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.XSD_DATETIME_NO_ENCLOSING, 14);
            R2R_to_MatSPARQL_type_map.put("URI", 5);
            R2R_to_MatSPARQL_type_map.put("http://www.opengis.net/ont/geosparql#wktLiteral", 24);
            R2R_to_MatSPARQL_type_map.put("http://www.opengis.net/ont/geosparql#gmlLiteral", 22);
            R2R_to_MatSPARQL_type_map.put("http://xmlns.oracle.com/rdf/geo/GML31Literal", 22);
            R2R_to_MatSPARQL_type_map.put("STRING", 11);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_NUMERIC, 12);
            R2R_to_MatSPARQL_type_map.put("SDO_GEOMETRY", 25);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_FLOAT, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_DOUBLE, 4);
            R2R_to_MatSPARQL_type_map.put("DATE", 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_TIME, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_DATETIME, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_BOOLEAN, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_RAW, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_OTHER, 4);
            R2R_to_MatSPARQL_type_map.put(RelationalBGP.TYPE_FAM_NUMFLTDBL, 4);
        }
    }

    private class UnionRow {
        public ArrayList<String> RRrowList;
        public String fromCommon;
        public ArrayList<Pair_IntString> oFromList;
        public HashMap<String, ArrayList<Integer>> TpCE_colNotNull;
        public HashMap<String, ArrayList<Integer>> TpCE_colEqConst;
        public HashMap<String, ArrayList<Integer>> TpCE_colPairEq;
        public HashMap<String, ArrayList<Pair_IntInt>> TpPairCE;
        public HashMap<String, ArrayList<Integer>> TpGE;
        public ArrayList<String> pExprList;
        public ArrayList<String> oExprList;

        private UnionRow() {
        }

        public String toString() {
            return "UnionRow.toString(): not implemented yet";
        }
    }

    private class LtcTabRowInfo {
        public String Tmap;
        public String colName;
        public int colType;
        public String colTypeName;
        public Integer colMaxLen;
        public Integer colPrecision;
        public Integer colScale;
        private String srid;
        private ColDimInfoMetadata colDimInfoMetadata;

        public LtcTabRowInfo(String string, String string2, Integer n, String string3, Integer n2, Integer n3, Integer n4) {
            this.Tmap = string;
            this.colName = string2;
            this.colType = n;
            this.colTypeName = string3;
            this.colPrecision = n3;
            this.colScale = n4;
            this.colDimInfoMetadata = null;
        }

        public void setGeomMetadata(String string, String string2, String string3, String string4, String string5) {
            if ("SDO_GEOMETRY".equals(this.colTypeName)) {
                if (this.colDimInfoMetadata == null) {
                    this.colDimInfoMetadata = new ColDimInfoMetadata(string);
                }
                this.colDimInfoMetadata.addDimInfo(string2, string3, string4, string5);
            }
        }

        public String getSRID() {
            if ("SDO_GEOMETRY".equals(this.colTypeName) && this.colDimInfoMetadata != null) {
                return this.colDimInfoMetadata.srid;
            }
            return null;
        }

        public String getDimArrayConstructor() {
            if ("SDO_GEOMETRY".equals(this.colTypeName) && this.colDimInfoMetadata != null) {
                return this.colDimInfoMetadata.getDimArrayConstructor();
            }
            return null;
        }

        public String getDimArrayConstructor(String string) {
            if ("SDO_GEOMETRY".equals(this.colTypeName) && this.colDimInfoMetadata != null) {
                return this.colDimInfoMetadata.getDimArrayConstructor();
            }
            return string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n  *[Tmap=" + this.Tmap + " colName=" + this.colName + "]");
            stringBuffer.append("\n  colType=" + this.colType + " colTypeName=" + this.colTypeName);
            stringBuffer.append("\n  colPrecision=" + this.colPrecision + " colScale=" + this.colScale);
            if ("SDO_GEOMETRY".equals(this.colTypeName)) {
                stringBuffer.append("\n  SDO_GEOMETRY metadata: " + (this.colDimInfoMetadata == null ? "NO SDO_GEOMETRY metadata" : this.colDimInfoMetadata.toString()));
            }
            return stringBuffer.toString();
        }

        public class ColDimInfoMetadata {
            private String srid;
            private List<String> sdo_dimnames;
            private List<String> sdo_lbs;
            private List<String> sdo_ubs;
            private List<String> sdo_tolerances;

            ColDimInfoMetadata(String string) {
                this.srid = string != null ? string : RelationalBGP.DEFAULT_GEOMETRY_SRID_STR;
                this.sdo_dimnames = new ArrayList<String>();
                this.sdo_lbs = new ArrayList<String>();
                this.sdo_ubs = new ArrayList<String>();
                this.sdo_tolerances = new ArrayList<String>();
            }

            public boolean addDimInfo(String string, String string2, String string3, String string4) {
                this.sdo_dimnames.add(string);
                this.sdo_lbs.add(string2);
                this.sdo_ubs.add(string3);
                this.sdo_tolerances.add(string4);
                return true;
            }

            public String getDimArrayConstructor() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("sdo_dim_array(");
                for (int i = 0; i < this.sdo_dimnames.size(); ++i) {
                    stringBuffer.append(String.format("sdo_dim_element('%s','%s','%s','%s')", this.sdo_dimnames.get(i), this.sdo_lbs.get(i), this.sdo_ubs.get(i), this.sdo_tolerances.get(i)));
                    if (i >= this.sdo_dimnames.size() - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                return stringBuffer.toString();
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer("DIMINFO: ");
                stringBuffer.append(String.format("SRID: %s\n", this.srid));
                for (int i = 0; i < this.sdo_dimnames.size(); ++i) {
                    stringBuffer.append(String.format("\t[%2d] SDO_DIMNAME: %s, SDO_LB: %s, SDO_UB: %s, SDO_TOLERANCE: %s\n", i, this.sdo_dimnames.get(i), this.sdo_lbs.get(i), this.sdo_ubs.get(i), this.sdo_tolerances.get(i)));
                }
                return stringBuffer.toString();
            }
        }
    }

    private class NatVarOpt_Info {
        private HashMap<String, NatVarOpt_Structure> natVarOptInfo_for_var = new HashMap();

        public NatVarOpt_Structure get_NatVarOpt_Structure(String string) {
            return this.natVarOptInfo_for_var.get(string);
        }

        public String noVa_compose_multiOccVar_joinCond_for_UArow(String string, String string2, int n, String string3, int n2, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2, ArrayList<String> arrayList3, ArrayList<String> arrayList4, SQLGenContext sQLGenContext) {
            RelationalBGP.this.log("Entering: noVa_compose_multiOccVar_joinCond_for_UArow: var=" + string + " UArowAbsNum=" + n + " CSRAlias=" + string2);
            String string4 = "";
            if (this.natVarOptInfo_for_var.containsKey(string)) {
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                string4 = natVarOpt_Structure.noVa_compose_multiOccVar_joinCond_for_UArow(string2, n, string3, n2, arrayList, arrayList2, arrayList3, arrayList4, sQLGenContext);
            } else {
                RelationalBGP.this.log("natVarOptInfo_for_var does NOT contain var=" + string);
            }
            RelationalBGP.this.log("Exiting: noVa_compose_multiOccVar_joinCond_for_UArow: optOutNatCond=" + string4);
            return string4;
        }

        public boolean containsVar(String string) {
            return this.natVarOptInfo_for_var.containsKey(string);
        }

        public COptNatCondition get_optOutNatCond_ForVar(String string, Set<String> set) throws RDFException, SQLException {
            COptNatCondition cOptNatCondition = null;
            if (this.natVarOptInfo_for_var.containsKey(string)) {
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                cOptNatCondition = natVarOpt_Structure.get_optOutNatCond_ForVar(string, set);
            }
            return cOptNatCondition;
        }

        public String get_optOutNatCond_For_Filter2v(String string, String string2, String string3) {
            RelationalBGP.this.log("==>get_optOutNatCond_For_Filter2v");
            String string4 = "";
            String string5 = "";
            if (this.natVarOptInfo_for_var.containsKey(string) && this.natVarOptInfo_for_var.containsKey(string2)) {
                Serializable serializable;
                Iterator iterator;
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                NatVarOpt_Structure natVarOpt_Structure2 = this.natVarOptInfo_for_var.get(string2);
                Integer n = new Integer(-1);
                Iterator iterator2 = natVarOpt_Structure.natVarCountForAlias_for_TFTidx.keySet().iterator();
                if (iterator2.hasNext()) {
                    iterator = (Integer)iterator2.next();
                    n = iterator;
                }
                iterator2 = new Integer(-1);
                iterator = natVarOpt_Structure2.natVarCountForAlias_for_TFTidx.keySet().iterator();
                if (iterator.hasNext()) {
                    serializable = (Integer)iterator.next();
                    iterator2 = serializable;
                }
                if (n == iterator2) {
                    HashMap hashMap;
                    Object object;
                    iterator = "";
                    serializable = new ArrayList();
                    String string6 = RelationalBGP.COND_CONNECTOR;
                    if (string3.equals("!=")) {
                        string6 = "  OR ";
                    }
                    if ((object = (hashMap = (HashMap)natVarOpt_Structure.natVarCountForAlias_for_TFTidx.get(n)).keySet().iterator()).hasNext()) {
                        String string7 = (String)object.next();
                        for (int i = 0; i < (Integer)hashMap.get(string7); ++i) {
                            ((ArrayList)serializable).add(string7 + "." + string + RelationalBGP.NATIVE_SUFFIX + i);
                        }
                        RelationalBGP.this.log("optChosenExpr: " + serializable);
                    }
                    object = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get((Integer)((Object)iterator2));
                    int n2 = 0;
                    hashMap = (HashMap)natVarOpt_Structure2.natVarCountForAlias_for_TFTidx.get(iterator2);
                    RelationalBGP.this.log("natVarNo_for_Alias=" + hashMap);
                    Iterator iterator3 = hashMap.keySet().iterator();
                    if (iterator3.hasNext()) {
                        String string8 = (String)iterator3.next();
                        for (int i = 0; i < (Integer)hashMap.get(string8); ++i) {
                            if (((TFTinfo)object).strIsolList.get(i) == null || ((TFTinfo)object).strIsolList.get(i + 1) == null) continue;
                            ++n2;
                            iterator = (String)((Object)iterator) + string6 + (String)((ArrayList)serializable).get(i) + string3 + string8 + "." + string2 + RelationalBGP.NATIVE_SUFFIX + i;
                        }
                    }
                    string5 = string5 + (String)((Object)iterator);
                    RelationalBGP.this.log("allOptExpr=" + string5);
                    if (n2 > 0) {
                        string5 = " AND (" + string5.substring(5) + ")";
                        RelationalBGP.this.log("allOptExpr=" + string5);
                    }
                    string4 = string5;
                    if (((TFTinfo)object).numIsolStrs < ((TFTinfo)object).numCols + 1) {
                        RelationalBGP.this.log("partial opt native cond (this will be discarded for now): " + string4);
                        string4 = "";
                    }
                }
            }
            RelationalBGP.this.log("<==get_optOutNatCond_For_Filter2v");
            return string4;
        }

        public String get_natVarListStr_ForVar(String string, String string2, ArrayList<String> arrayList, Set<String> set) {
            RelationalBGP.this.log(this.toString());
            RelationalBGP.this.log("=>get_natVarListStr_ForVar: var=" + string + " : CSRAlias=" + string2 + " : colList=" + arrayList);
            String string3 = "";
            RelationalBGP.this.log("NATVAROPTINFO_FOR_VAR.CONTAINSKEY(" + string + ")=" + this.natVarOptInfo_for_var.containsKey(string));
            if (this.natVarOptInfo_for_var.containsKey(string)) {
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                string3 = natVarOpt_Structure.get_natVarListStr_ForVar(string, string2, arrayList, set);
            }
            return string3;
        }

        public HashSet<String> get_occInfoSet_inUArow(String string, Integer n) {
            NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
            HashSet<String> hashSet = null;
            if (natVarOpt_Structure != null) {
                hashSet = natVarOpt_Structure.get_optOccInfoSet_inUArow(n);
            }
            return hashSet;
        }

        public void set(String string, NatVarOpt_Structure natVarOpt_Structure) {
            this.natVarOptInfo_for_var.put(string, natVarOpt_Structure);
        }

        public void set(String string, int n, String string2, String string3, int n2) {
            NatVarOpt_Structure natVarOpt_Structure;
            RelationalBGP.this.log("var=" + string + ": adding info for inter-CSR join optimization ...");
            if (!this.natVarOptInfo_for_var.containsKey(string)) {
                natVarOpt_Structure = new NatVarOpt_Structure();
                this.natVarOptInfo_for_var.put(string, natVarOpt_Structure);
                RelationalBGP.this.log("var=" + string + ": CREATED NEW NatVarOpt structure");
            } else {
                natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                RelationalBGP.this.log("var=" + string + ": ADDING to existing NatVarOpt structure");
            }
            natVarOpt_Structure.set(n, string2, string3, n2);
            RelationalBGP.this.log("var=" + string + ": adding info for inter-CSR join optimization ... DONE");
        }

        public void set(String string, Integer n, int n2, String string2) {
            NatVarOpt_Structure natVarOpt_Structure;
            RelationalBGP.this.log("var=" + string + ": adding info for LOCAL JOIN optimization ...");
            if (!this.natVarOptInfo_for_var.containsKey(string)) {
                natVarOpt_Structure = new NatVarOpt_Structure();
                this.natVarOptInfo_for_var.put(string, natVarOpt_Structure);
                RelationalBGP.this.log("var=" + string + ": CREATED NEW NatVarOpt structure");
            } else {
                natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                RelationalBGP.this.log("var=" + string + ": ADDING to existing NatVarOpt structure");
            }
            natVarOpt_Structure.set(n, n2, string2);
            RelationalBGP.this.log("var=" + string + ": adding info for LOCAL JOIN optimization ... DONE");
        }

        public void multiply(int n, int n2, int n3) {
            for (String string : this.natVarOptInfo_for_var.keySet()) {
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                natVarOpt_Structure.multiply(n, n2, n3);
            }
        }

        public void resetLocalStructure() {
            for (String string : this.natVarOptInfo_for_var.keySet()) {
                NatVarOpt_Structure natVarOpt_Structure = this.natVarOptInfo_for_var.get(string);
                natVarOpt_Structure.resetLocalStructure();
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.natVarOptInfo_for_var.keySet()) {
                stringBuffer.append("\n NatVarOpt_Structure for variable name=" + string + "-----------------------");
                stringBuffer.append(this.natVarOptInfo_for_var.get(string).toString());
            }
            return stringBuffer.toString();
        }
    }

    private class NatVarOpt_Structure {
        private int TEMPLATE = RRTabRowInfo.MapExprType_TEMPLATE;
        private int CONSTANT = RRTabRowInfo.MapExprType_CONSTANT;
        private int COLUMN = RRTabRowInfo.MapExprType_COLUMN;
        private String subjectPos = "";
        private Integer sTFT_idx = new Integer(-1);
        private HashMap<String, HashSet<Integer>> TFTidxSet_for_CSRAlias = new HashMap();
        private HashMap<Integer, HashMap<String, Integer>> natVarCountForAlias_for_TFTidx = new HashMap();
        private HashMap<Integer, HashMap<Integer, HashSet<String>>> TFTidx_occInfoSet_pairs_for_pos = new HashMap();

        public boolean isValidForGeometryVar(int n) {
            TFTinfo tFTinfo = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get(n);
            return tFTinfo.termType != null && tFTinfo.termType.equals(RelationalBGP.rrLiteral) && tFTinfo.datatype_family.equals("SDO_GEOMETRY");
        }

        public Set<Integer> getInvalidTFTsForGeometryVar() {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n : this.natVarCountForAlias_for_TFTidx.keySet()) {
                if (this.isValidForGeometryVar(n)) continue;
                hashSet.add(n);
            }
            return hashSet;
        }

        public void removeInvalidTFTsForGeometryVar() {
            Set<Integer> set = this.getInvalidTFTsForGeometryVar();
            for (int n : set) {
                Object object;
                for (String string : this.TFTidxSet_for_CSRAlias.keySet()) {
                    object = this.TFTidxSet_for_CSRAlias.get(string);
                    object.remove(n);
                }
                this.natVarCountForAlias_for_TFTidx.remove(n);
                Iterator<Object> iterator = this.TFTidx_occInfoSet_pairs_for_pos.keySet().iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    object = this.TFTidx_occInfoSet_pairs_for_pos.get(n2);
                    object.remove(n);
                }
            }
        }

        public int getColCount() {
            int n = this.natVarCountForAlias_for_TFTidx.keySet().iterator().next();
            int n2 = this.natVarCountForAlias_for_TFTidx.get(n).values().iterator().next();
            return n2;
        }

        public String getCSRAlias() {
            return this.TFTidxSet_for_CSRAlias.keySet().iterator().next();
        }

        public HashMap<Integer, HashSet<String>> get_TFTidx_occInfoSet_pairs(int n) {
            return this.TFTidx_occInfoSet_pairs_for_pos.get(n);
        }

        public String noVa_compose_multiOccVar_joinCond_for_UArow(String string, int n, String string2, int n2, ArrayList<ArrayList<String>> arrayList, ArrayList<ArrayList<String>> arrayList2, ArrayList<String> arrayList3, ArrayList<String> arrayList4, SQLGenContext sQLGenContext) {
            Object object;
            RelationalBGP.this.log("==>ENTER: noVa_compose_multiOccVar_joinCond_for_UArow(): UArowAbsNum=" + n);
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            int n3 = this.TEMPLATE;
            boolean bl = true;
            HashMap<Integer, HashSet<String>> hashMap = this.TFTidx_occInfoSet_pairs_for_pos.get(new Integer(n));
            RelationalBGP.this.log("occInfoSet_for_TFTidx [keySet().size()=" + hashMap.keySet().size() + "]: " + hashMap);
            if (hashMap == null) {
                RelationalBGP.this.log("could not find any TFTidx_occInfoSet_pairs_for_pos entry for pos=" + n);
                RelationalBGP.this.log("here is the keySet(): " + this.TFTidx_occInfoSet_pairs_for_pos.keySet());
            }
            boolean bl2 = false;
            if (hashMap.keySet().size() == 1) {
                int n4 = hashMap.keySet().iterator().next();
                TFTinfo tFTinfo = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get(n4);
                if ("SDO_GEOMETRY".equals(tFTinfo.datatype_family)) {
                    bl2 = true;
                    RelationalBGP.this.log("multiOcc join cond for geometry var");
                }
            }
            for (int n5 : hashMap.keySet()) {
                TFTinfo tFTinfo = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get(n5);
                object = hashMap.keySet().iterator();
                while (object.hasNext()) {
                    int n6 = object.next();
                    TFTinfo tFTinfo2 = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get(n6);
                    if (n5 >= n6 || RelationalBGP.this.isCompatibleTFTpair(n5, n6)) continue;
                    return " AND 1=0 ";
                }
            }
            for (int n7 : hashMap.keySet()) {
                RelationalBGP.this.log("-------------------------------------------------------");
                RelationalBGP.this.log("TFTidx=" + n7 + " [TYFAM_TEMPL=" + (String)RelationalBGP.this.TFTglobalList.get(n7) + "]");
                boolean bl3 = true;
                object = "";
                String string7 = "";
                int n8 = this.TEMPLATE;
                ArrayList<String> arrayList5 = new ArrayList<String>();
                HashSet<String> hashSet = hashMap.get(n7);
                for (String string8 : hashSet) {
                    String string9;
                    String string10;
                    RelationalBGP.this.log("        ------------------------------------------------");
                    RelationalBGP.this.log("OCCINFO=" + string8);
                    String string11 = string8.substring(0, string8.indexOf(58));
                    int n9 = Integer.parseInt(string8.substring(string8.indexOf(58) + 1, string8.length()));
                    String string12 = RelationalBGP.this.getExprFromArrays(string8, n, string2, arrayList, arrayList2, arrayList3, null);
                    RelationalBGP.this.log("EXPR=" + string12);
                    String string13 = arrayList4.get(n);
                    String[] stringArray = string13.substring(1, string13.length()).split(":");
                    ArrayList<String> arrayList6 = new ArrayList<String>(Arrays.asList(stringArray));
                    RelationalBGP.this.log(arrayList6.toString());
                    RRTabRowInfo rRTabRowInfo = (RRTabRowInfo)RelationalBGP.this.RRrowInfo_for_MatchingRow.get(arrayList6.get(n9));
                    String string14 = "";
                    int n10 = this.TEMPLATE;
                    ArrayList<String> arrayList7 = null;
                    if (string11.equals("subject") && rRTabRowInfo.sExpr != null) {
                        string14 = rRTabRowInfo.sExpr;
                        n10 = rRTabRowInfo.sExprType;
                        arrayList7 = rRTabRowInfo.sColTypeList;
                    } else if (string11.equals("predicate") && rRTabRowInfo.pExpr != null) {
                        string14 = rRTabRowInfo.pExpr;
                        n10 = rRTabRowInfo.pExprType;
                        arrayList7 = rRTabRowInfo.pColTypeList;
                    } else if (string11.equals("object") && rRTabRowInfo.oExpr != null) {
                        string14 = rRTabRowInfo.oExpr;
                        n10 = rRTabRowInfo.oExprType;
                        arrayList7 = rRTabRowInfo.oColTypeList;
                    } else if (string11.equals("object") && rRTabRowInfo.psExpr != null) {
                        string14 = rRTabRowInfo.psExpr;
                        n10 = rRTabRowInfo.psExprType;
                        arrayList7 = rRTabRowInfo.psColTypeList;
                    } else if (string11.equals("graph") && rRTabRowInfo.pogExpr != null) {
                        string14 = rRTabRowInfo.pogExpr;
                        n10 = rRTabRowInfo.pogExprType;
                        arrayList7 = rRTabRowInfo.pogColTypeList;
                    }
                    RelationalBGP.this.log("TEMPL=" + string14);
                    RelationalBGP.this.log("EXPRTYPE=" + n10);
                    RelationalBGP.this.log("COLTYPELIST=" + arrayList7);
                    StringBuffer stringBuffer = new StringBuffer("");
                    ArrayList<String> arrayList8 = new ArrayList<String>();
                    ArrayList<String> arrayList9 = new ArrayList<String>();
                    if (n10 == this.TEMPLATE) {
                        string14 = string14.substring(1, string14.length() - 1);
                        try {
                            string10 = RelationalBGP.sqlTempl2sqlExpr(string14, RelationalBGP.rrIRI, string + ".", stringBuffer, arrayList8, arrayList9, arrayList7, sQLGenContext);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    RelationalBGP.this.log("COLLIST=" + arrayList8);
                    RelationalBGP.this.log("STRLIST=" + arrayList9);
                    if (n10 == this.COLUMN) {
                        string10 = RelationalBGP.get_base_prefix_from_RR_table(string14);
                        if (string10 != null) {
                            string9 = RelationalBGP.get_col_name_from_RR_table(string14);
                            arrayList8.add(string9);
                            arrayList9.add(string10);
                        } else {
                            arrayList8.add(string14);
                            arrayList9.add("");
                        }
                    }
                    RelationalBGP.this.log("COLLIST=" + arrayList8);
                    RelationalBGP.this.log("STRLIST=" + arrayList9);
                    if (bl3) {
                        if (!bl && !string12.equals(string6)) {
                            string5 = n3 == this.CONSTANT && n10 == this.CONSTANT ? string5 + " AND 1=0" : string5 + RelationalBGP.COND_CONNECTOR + string6 + "=" + string12;
                            RelationalBGP.this.log("NOTOPTEXPRCOND=" + string5);
                        }
                        if (n10 == this.TEMPLATE || n10 == this.COLUMN) {
                            for (int i = 0; i < arrayList8.size(); ++i) {
                                arrayList5.add(string + "." + (String)arrayList8.get(i));
                                string7 = string12;
                                n8 = n10;
                            }
                        } else if (n10 == this.CONSTANT) {
                            string7 = string12;
                            n8 = n10;
                        } else {
                            RelationalBGP.this.log("ERROR: It is not possible to assign optChosenExpr because Expr is not any of TEMPLATE, CONSTANT or COLUMN");
                        }
                        RelationalBGP.this.log("OPTCHOSENEXPR=" + string7 + "  OPTCHOSENEXPRTYPE=" + n8);
                        bl3 = false;
                    } else {
                        RelationalBGP.this.log("EXPR=" + string12 + "  OPTCHOSENEXP=" + string7);
                        if (!string12.equals(string7)) {
                            if (n8 == this.TEMPLATE && n10 == this.TEMPLATE || n8 == this.COLUMN && n10 == this.COLUMN) {
                                for (int i = 0; i < arrayList5.size(); ++i) {
                                    string9 = (String)arrayList5.get(i);
                                    String string15 = string + "." + (String)arrayList8.get(i);
                                    object = bl2 ? (String)object + RelationalBGP.COND_CONNECTOR + RelationalBGP.SDO_EQUAL_BEG + string9 + "," + string15 + RelationalBGP.SDO_EQUAL_END : (String)object + RelationalBGP.COND_CONNECTOR + string9 + "=" + string15;
                                }
                            } else if (n8 == this.CONSTANT && n10 == this.CONSTANT) {
                                object = (String)object + " AND 1=0";
                            } else {
                                RelationalBGP.this.log("ERROR: There is not any of TEMPLATE-TEMPLATE, CONSTANT-CONSTANT or COLUMN-COLUMN");
                                RelationalBGP.this.log("ERROR: ");
                            }
                            RelationalBGP.this.log("OPTEXPRCOND=" + (String)object);
                        }
                    }
                    if (!bl) continue;
                    string6 = string12;
                    n3 = n10;
                    bl = false;
                    RelationalBGP.this.log("NOTOPTCHOSENEXPR=" + string6 + "  NOTOPTCHOSENEXPRTYPE=" + n3);
                }
                string4 = string4 + (String)object;
                if (!((String)object).equals("")) {
                    string4 = string4 + "\n";
                }
                RelationalBGP.this.log("ALLOPTEXPR=" + string4);
            }
            string3 = string4 + string5;
            if (!string3.equals("")) {
                string3 = string3 + "\n";
            }
            RelationalBGP.this.log("[ENTER_HERE]=4");
            RelationalBGP.this.log("OPTOUTNATCOND=" + string3);
            RelationalBGP.this.log("<==ENTER: noVa_compose_multiOccVar_joinCond_for_UArow()");
            return string3;
        }

        public COptNatCondition get_optOutNatCond_ForVar(String string, Set<String> set) throws RDFException, SQLException {
            boolean bl;
            COptNatCondition cOptNatCondition = new COptNatCondition();
            String string2 = "";
            String string3 = "";
            String string4 = "";
            boolean bl2 = true;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            if (RelationalBGP.this.Geometry_VarSRID.containsKey(string)) {
                RelationalBGP.this.log("BEFORE CLEANUP: structure for this var=" + string + " is:" + this.toString());
                this.removeInvalidTFTsForGeometryVar();
                RelationalBGP.this.log("AFTER CLEANUP: structure for this var=" + string + " is:" + this.toString());
            }
            Object object = this.natVarCountForAlias_for_TFTidx.keySet().iterator();
            while (object.hasNext()) {
                int n = object.next();
                bl = true;
                String string5 = "";
                ArrayList<String> arrayList = new ArrayList<String>();
                HashMap<String, Integer> hashMap2 = this.natVarCountForAlias_for_TFTidx.get(n);
                for (String string6 : hashMap2.keySet()) {
                    int n2;
                    HashSet<Integer> hashSet = this.TFTidxSet_for_CSRAlias.get(string6);
                    RelationalBGP.this.log("TFTIDXSET.SIZE()=" + hashSet.size() + " : It has to be 1: TFTidxSet=" + hashSet);
                    if (hashSet.size() != 1 && !RelationalBGP.this.Geometry_VarSRID.containsKey(string)) continue;
                    hashMap.put(string6, new Integer(0));
                    if (bl) {
                        if (!bl2) {
                            string3 = string3 + RelationalBGP.COND_CONNECTOR + string4 + "=" + string6 + "." + string;
                        }
                        for (n2 = 0; n2 < hashMap2.get(string6); ++n2) {
                            arrayList.add(string6 + "." + string + RelationalBGP.NATIVE_SUFFIX + n2);
                        }
                        bl = false;
                        RelationalBGP.this.log("optChosenExpr: " + arrayList);
                    } else {
                        for (n2 = 0; n2 < hashMap2.get(string6); ++n2) {
                            String string7 = (String)arrayList.get(n2);
                            String string8 = string6 + "." + string + RelationalBGP.NATIVE_SUFFIX + n2;
                            if (RelationalBGP.this.Geometry_VarSRID.containsKey(string)) {
                                int n3 = 131072;
                                int n4 = n3 + 1;
                                if (n4 == n3) {
                                    RelExpr relExpr = RelationalBGP.this.buildUnindexedEqualityGeomExpression(string, string);
                                    boolean bl3 = ((RelationalBGP)RelationalBGP.this).ctx.strictOGC;
                                    ((RelationalBGP)RelationalBGP.this).ctx.strictOGC = false;
                                    NatVarOpt_Info natVarOpt_Info = new NatVarOpt_Info();
                                    natVarOpt_Info.set(string, this);
                                    String string9 = RelationalBGP.this.genFilter_v3("OUTER_LEVEL", null, -1, null, null, null, natVarOpt_Info, relExpr, null, null, null);
                                    ((RelationalBGP)RelationalBGP.this).ctx.strictOGC = bl3;
                                    continue;
                                }
                                string5 = string5 + RelationalBGP.COND_CONNECTOR + "SDO_RELATE(" + string7 + "," + string8 + ", " + "'mask=100010001'" + ") = 'TRUE'";
                                continue;
                            }
                            string5 = string5 + RelationalBGP.COND_CONNECTOR + string7 + "=" + string8;
                        }
                    }
                    if (!bl2) continue;
                    string4 = string6 + "." + string;
                    bl2 = false;
                    RelationalBGP.this.log("notOptChosenExpr: " + string4);
                }
                string2 = string2 + string5;
            }
            if (!RelationalBGP.this.Geometry_VarSRID.containsKey(string)) {
                Iterator<String> iterator = set.iterator();
                bl = false;
                if (string4.equals("")) {
                    bl = true;
                }
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (bl) {
                        string4 = (String)object + "." + string;
                        bl = false;
                        continue;
                    }
                    if (hashMap.containsKey(object)) continue;
                    string3 = string3 + RelationalBGP.COND_CONNECTOR + string4 + "=" + (String)object + "." + string;
                }
                cOptNatCondition.optNatCondition = string2 + string3;
            } else {
                RelationalBGP.this.log("non-native (outer) condition generation makes NO SENSE for geometry var: " + string);
                cOptNatCondition.optNatCondition = string2;
            }
            cOptNatCondition.notOptChosenExpr = string4;
            RelationalBGP.this.log("get_optOutNatCond_ForVar returning: optOutNatCond.optNatCondition:" + cOptNatCondition.optNatCondition + "***");
            return cOptNatCondition;
        }

        public String get_natVarListStr_ForVar(String string, String string2, ArrayList<String> arrayList, Set<String> set) {
            RelationalBGP.this.log("=>get_natVarListStr_ForVar: var=" + string + " : CSRAlias=" + string2 + " : colList=" + arrayList);
            String string3 = "";
            String string4 = null;
            if (this.natVarCountForAlias_for_TFTidx.keySet().size() > 1) {
                if (!set.contains(string)) {
                    return string3;
                }
                string4 = (String)RelationalBGP.this.DatatypeFam_for_var.get(string);
                RelationalBGP.this.log("varsNeededInOuterCond_geo contains var=" + string + ": look for TFT with datatypeFam=" + string4);
            }
            for (int n : this.natVarCountForAlias_for_TFTidx.keySet()) {
                TFTinfo tFTinfo = (TFTinfo)RelationalBGP.this.TFTinfoGlobalList.get(n);
                String string5 = tFTinfo.datatype_family;
                if (!(string4 == null || string5 != null && string5.equals(string4))) {
                    RelationalBGP.this.log("not the right TFT: datatype_family=" + string5 + " - looking for " + string4);
                    continue;
                }
                RelationalBGP.this.log("for: TFTidx=" + n + ": TYFAM_TEMPL=" + (String)RelationalBGP.this.TFTglobalList.get(n));
                HashMap<String, Integer> hashMap = this.natVarCountForAlias_for_TFTidx.get(n);
                RelationalBGP.this.log("NATVARNO_FOR_ALIAS.SIZE()=" + hashMap.size());
                RelationalBGP.this.log("NATVARNO_FOR_ALIAS.CONTAINSKEY(" + string2 + ")=" + hashMap.containsKey(string2));
                if (hashMap.containsKey(string2)) {
                    RelationalBGP.this.log("COLLIST.SIZE()=" + arrayList.size() + "=" + hashMap.get(string2) + "=NATVARNO_FOR_ALIAS.GET(" + string2 + ").INTVALUE()");
                    if (arrayList.size() == hashMap.get(string2).intValue()) {
                        HashSet<Integer> hashSet = this.TFTidxSet_for_CSRAlias.get(string2);
                        RelationalBGP.this.log("TFTIDXSET.SIZE()=" + hashSet.size() + " : It has to be 1 OR var=" + string + " MUST BE IN varsNeededInOuterCond_geo: " + set);
                        if (hashSet.size() == 1 || set.contains(string)) {
                            if (set.contains(string) && hashSet.size() != 1) {
                                RelationalBGP.this.log("ERROR: geometry variable " + string + " has more than one (" + hashSet.size() + ") TFTidx");
                            }
                            for (int i = 0; i < arrayList.size(); ++i) {
                                string3 = string3 + ", " + arrayList.get(i) + RelationalBGP.ALIAS_SEP + string + RelationalBGP.NATIVE_SUFFIX + i;
                            }
                            RelationalBGP.this.log("NATVARLIST=" + string3);
                        }
                    } else {
                        RelationalBGP.this.log("ERROR: colList size does NOT coincide with natVarNo_for_alias.get(CSRAlias) : colList=" + arrayList + " : natVarNo_for_alias.get(" + string2 + ")=" + hashMap.get(string2));
                    }
                }
                RelationalBGP.this.log("break from the for loop: we have created the natVarList based on a single TFTidx=" + n);
                break;
            }
            return string3;
        }

        public boolean containsTFTidx(int n) {
            return this.natVarCountForAlias_for_TFTidx.containsKey(n);
        }

        public boolean containsPos(Integer n) {
            return this.TFTidx_occInfoSet_pairs_for_pos.containsKey(n);
        }

        public HashSet<String> get_optOccInfoSet_inUArow(Integer n) {
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<Integer, HashSet<String>> hashMap = this.TFTidx_occInfoSet_pairs_for_pos.get(n);
            if (hashMap.size() == 1) {
                for (int n2 : hashMap.keySet()) {
                    hashSet = hashMap.get(n2);
                }
                return hashSet;
            }
            return null;
        }

        public void set(int n, String string, String string2, int n2) {
            Cloneable cloneable;
            if (string.equals("subject:0")) {
                this.subjectPos = "subject:0";
                this.sTFT_idx = new Integer(n);
                RelationalBGP.this.log("var occurs as subject in this CSR (alias=" + string2 + "): sTFT_idx for this current Tmap is: " + this.sTFT_idx);
            }
            RelationalBGP.this.log("noVa trace: natVarCountForAlias_for_TFTidx data structure: adding (alias=" + string2 + ", dbColCnt=" + n2 + ") to occInfoSet HashMap of TFTidx=" + n + ": corr to TFT=" + (String)RelationalBGP.this.TFTglobalList.get(n));
            if (!this.containsTFTidx(n)) {
                cloneable = new HashMap<String, Integer>();
                ((HashMap)cloneable).put(string2, new Integer(n2));
                this.natVarCountForAlias_for_TFTidx.put(n, (HashMap<String, Integer>)cloneable);
            } else {
                cloneable = this.natVarCountForAlias_for_TFTidx.get(n);
                ((HashMap)cloneable).put(string2, new Integer(n2));
            }
            RelationalBGP.this.log("noVa trace: TFTidxSet_for_CSRAlias data structure: adding (TFTidx=" + n + ") corr to TFT=" + (String)RelationalBGP.this.TFTglobalList.get(n));
            if (!this.TFTidxSet_for_CSRAlias.containsKey(string2)) {
                cloneable = new HashSet();
                ((HashSet)cloneable).add(n);
                this.TFTidxSet_for_CSRAlias.put(string2, (HashSet<Integer>)cloneable);
            } else {
                cloneable = this.TFTidxSet_for_CSRAlias.get(string2);
                ((HashSet)cloneable).add(n);
            }
        }

        public void set(Integer n, int n2, String string) {
            RelationalBGP.this.log("noVa trace: TFTidx_occInfoSet_pairs_for_pos data structure: adding OccInfo=" + string + " to occInfoSet for TFTidx=" + n2 + ": corr to TFT=" + (String)RelationalBGP.this.TFTglobalList.get(n2));
            if (!this.containsPos(n)) {
                HashMap hashMap = new HashMap();
                HashSet<String> hashSet = new HashSet<String>();
                if (!this.subjectPos.equals("")) {
                    if (n2 == this.sTFT_idx) {
                        hashSet.add(this.subjectPos);
                    } else {
                        HashSet<String> hashSet2 = new HashSet<String>();
                        hashSet2.add(this.subjectPos);
                        hashMap.put(this.sTFT_idx, hashSet2);
                    }
                }
                hashSet.add(string);
                hashMap.put(n2, hashSet);
                this.TFTidx_occInfoSet_pairs_for_pos.put(n, hashMap);
            } else {
                HashMap<Integer, HashSet<String>> hashMap = this.TFTidx_occInfoSet_pairs_for_pos.get(n);
                if (!hashMap.containsKey(n2)) {
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add(string);
                    hashMap.put(n2, hashSet);
                } else {
                    HashSet<String> hashSet = hashMap.get(n2);
                    hashSet.add(string);
                }
            }
        }

        private int f(int n, int n2, int n3, int n4) {
            return n - n2 + n2 + n3 * n4;
        }

        private void add(Integer n, int n2, int n3, int n4) {
            HashMap<Integer, HashSet<String>> hashMap = this.TFTidx_occInfoSet_pairs_for_pos.get(n);
            HashMap hashMap2 = new HashMap();
            Object object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                int n5 = object.next();
                HashSet<String> hashSet = hashMap.get(n5);
                HashSet<String> hashSet2 = new HashSet<String>();
                hashSet2.addAll(hashSet);
                hashMap2.put(n5, hashSet2);
            }
            object = new Integer(this.f(n, n2, n3, n4));
            RelationalBGP.this.log("add(): pos2=" + object + "(calculated from: pos=" + n + " UAstartPos=" + n2 + " k=" + n3 + " rowBlock_size=" + n4);
            this.TFTidx_occInfoSet_pairs_for_pos.put((Integer)object, hashMap2);
            RelationalBGP.this.log("add(): added to TFTidx_occInfoSet_pairs_for_pos: key=" + object + " occInfoSet=" + hashMap2);
        }

        public void multiply(int n, int n2, int n3) {
            RelationalBGP.this.log("multiply(): INPUT => UAstartPos=" + n + " rowBlock_size=" + n2 + " RRrow_match_count=" + n3);
            Set<Integer> set = this.TFTidx_occInfoSet_pairs_for_pos.keySet();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(set);
            Collections.sort(arrayList);
            RelationalBGP.this.log("multiply(): posArray: " + arrayList);
            for (int i = 1; i < n3; ++i) {
                for (int j = n + 0; j < arrayList.size(); ++j) {
                    this.add(arrayList.get(j), n, i, n2);
                }
            }
        }

        public void resetLocalStructure() {
            this.subjectPos = "";
            this.sTFT_idx = new Integer(-1);
            this.TFTidx_occInfoSet_pairs_for_pos = new HashMap();
        }

        public String toString() {
            Object object;
            Object object2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n  natVarCountForAlias_for_TFTidx [size=" + this.natVarCountForAlias_for_TFTidx.size() + "]:");
            if (!this.subjectPos.equals("")) {
                stringBuffer.append("\n    " + this.subjectPos + "  sTFT_idx=" + this.sTFT_idx);
            }
            Object object3 = this.natVarCountForAlias_for_TFTidx.keySet().iterator();
            while (object3.hasNext()) {
                int n = object3.next();
                object2 = (String)RelationalBGP.this.TFTglobalList.get(n);
                object = "[" + n + ": " + (String)object2 + "]";
                stringBuffer.append("\n    " + (String)object + "=" + this.natVarCountForAlias_for_TFTidx.get(n).toString());
            }
            stringBuffer.append("\n  TFTidxSet_for_CSRAlias [size=" + this.TFTidxSet_for_CSRAlias.size() + "]:");
            for (String string : this.TFTidxSet_for_CSRAlias.keySet()) {
                stringBuffer.append("\n    " + string + "=" + this.TFTidxSet_for_CSRAlias.get(string).toString());
            }
            stringBuffer.append("\n  TFTidx_occInfoSet_pairs_for_pos [size=" + this.TFTidx_occInfoSet_pairs_for_pos.size() + "]:");
            object3 = new ArrayList<Integer>(this.TFTidx_occInfoSet_pairs_for_pos.keySet());
            Collections.sort(object3);
            Iterator iterator = ((ArrayList)object3).iterator();
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                object = this.TFTidx_occInfoSet_pairs_for_pos.get(object2);
                stringBuffer.append("\n    pos(UArowNUM)=" + object2);
                Iterator iterator2 = ((HashMap)object).keySet().iterator();
                while (iterator2.hasNext()) {
                    int n = (Integer)iterator2.next();
                    String string = (String)RelationalBGP.this.TFTglobalList.get(n);
                    String string2 = "[" + n + ": " + string + "]";
                    stringBuffer.append("\n        " + string2);
                    stringBuffer.append("=" + ((HashSet)((HashMap)object).get(n)).toString());
                }
            }
            return stringBuffer.toString();
        }
    }

    private class COptNatCondition {
        public String notOptChosenExpr = "";
        public String optNatCondition = "";

        public String toString() {
            return "notOptChosenExpr=" + this.notOptChosenExpr + "\n   optNatCondition=" + this.optNatCondition + "\n";
        }
    }

    private class UArowNatSelectInfo {
        public String sqlSubq;
        public Integer selListEndpos;
        public HashMap<String, ArrayList<String>> colList_for_var;

        public UArowNatSelectInfo() {
            this.sqlSubq = "";
            this.selListEndpos = new Integer(-1);
            this.colList_for_var = new HashMap();
        }

        public UArowNatSelectInfo(UArowNatSelectInfo uArowNatSelectInfo) {
            this.sqlSubq = uArowNatSelectInfo.sqlSubq;
            this.selListEndpos = uArowNatSelectInfo.selListEndpos;
            this.colList_for_var = new HashMap();
            for (String string : uArowNatSelectInfo.colList_for_var.keySet()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = uArowNatSelectInfo.colList_for_var.get(string);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    arrayList.add(arrayList2.get(i));
                }
                this.colList_for_var.put(string, arrayList);
            }
        }

        public boolean add_ColList_for_var(String string, ArrayList<String> arrayList) {
            if (!this.colList_for_var.containsKey(string)) {
                this.colList_for_var.put(string, arrayList);
                return true;
            }
            RelationalBGP.this.log("UArowNatSelectInfo.add_collist_for_var: colList already exists for var=" + string + " : colList=" + this.colList_for_var.get(string) + " | colList param :" + arrayList);
            return false;
        }

        public void addVarInfoFrom(UArowNatSelectInfo uArowNatSelectInfo) {
            for (String string : uArowNatSelectInfo.colList_for_var.keySet()) {
                if (this.colList_for_var.containsKey(string)) continue;
                ArrayList<String> arrayList = uArowNatSelectInfo.colList_for_var.get(string);
                this.colList_for_var.put(string, arrayList);
            }
        }

        public String natSelList_for_var(String string, String string2) {
            String string3 = "";
            ArrayList<String> arrayList = this.colList_for_var.get(string2);
            for (int i = 0; i < arrayList.size(); ++i) {
                string3 = string3 + ", " + string + "." + arrayList.get(i) + " AS x$" + i;
            }
            return string3;
        }

        public String toString() {
            return "sqlSubq=" + this.sqlSubq + " : selListEndpos=" + this.selListEndpos + " : colList_for_var=" + this.colList_for_var;
        }
    }

    private class RelExpr {
        public ASTTripleAtom L_atom;
        public String compOperator;
        public ASTTripleAtom R_atom;
        public Filter filterExprTree;
        public boolean eqBasedComp;
        public long RelExprFlags = 0L;
        public static final long RExF_NATIVE = 1L;
        public static final long RExF_GEOMETRY = 2L;
        public String procAtLevel;
        public static final String RExL_TPAT = "TPAT_LEVEL";
        public static final String RExL_UAROW = "UAROW_LEVEL";
        public static final String RExL_OUTER = "OUTER_LEVEL";
        public ASTTripleAtom MASK_atom;
        private int notNegatedFilterLevel;

        public void InvertRelExpr() {
            ASTTripleAtom aSTTripleAtom = this.L_atom;
            this.L_atom = this.R_atom;
            this.R_atom = aSTTripleAtom;
            if (this.compOperator.equals("<")) {
                this.compOperator = ">";
            } else if (this.compOperator.equals(">")) {
                this.compOperator = "<";
            } else if (this.compOperator.equals("<=")) {
                this.compOperator = ">=";
            } else if (this.compOperator.equals(">=")) {
                this.compOperator = "<=";
            }
        }

        public RelExpr(ASTTripleAtom aSTTripleAtom, String string, ASTTripleAtom aSTTripleAtom2, Filter filter, long l) {
            this.L_atom = aSTTripleAtom;
            this.compOperator = string;
            this.R_atom = aSTTripleAtom2;
            this.filterExprTree = filter;
            this.eqBasedComp = string.equals("=") || string.equals("!=") || string.equals("SAMETERM") || string.equals("DIFFTERM") ? true : (string.equals(">") || string.equals(">=") || string.equals("<") || string.equals("<=") ? false : false);
            this.RelExprFlags = l;
            this.procAtLevel = null;
            this.MASK_atom = null;
            this.notNegatedFilterLevel = 0;
        }

        public RelExpr(ASTTripleAtom aSTTripleAtom, String string, ASTTripleAtom aSTTripleAtom2, Filter filter, long l, ASTTripleAtom aSTTripleAtom3) {
            this(aSTTripleAtom, string, aSTTripleAtom2, filter, l);
            this.procAtLevel = null;
            this.MASK_atom = aSTTripleAtom3;
        }

        public String getMask() {
            return this.MASK_atom == null ? "" : this.MASK_atom.name;
        }

        public boolean isNegated() {
            return this.notNegatedFilterLevel % 2 == 1;
        }

        public void setNotNegatedFilterLevel(int n) {
            this.notNegatedFilterLevel = n;
        }

        public int getNotNegatedFilterLevel() {
            return this.notNegatedFilterLevel;
        }

        public String toString() {
            return "RelExpr [RelExprFlags=" + this.RelExprFlags + "]: filterExprTree =>\n" + this.filterExprTree.toString() + (this.isNegated() ? "\n negation is ON" : "\n negation is OFF") + (this.compOperator != null ? "\n " + this.compOperator : "") + (this.L_atom != null ? "\n  " + this.L_atom.toString() : "") + (this.R_atom != null ? "\n  " + this.R_atom.toString() : "") + "\n  procAtLevel=" + this.procAtLevel + (this.MASK_atom != null ? "\n  " + this.MASK_atom.toString() : "");
        }
    }

    private class TFTinfo {
        public int TFTidx;
        public String TFTsig;
        public String termType;
        public int exprType;
        public int numCols;
        public ArrayList<String> strList;
        public ArrayList<String> colTypeList;
        public String datatype;
        public String datatype_family;
        public String language;
        public ArrayList<String> strIsolList;
        public int numIsolStrs;
        public boolean ieq_optimizable;

        public TFTinfo(int n, String string, String string2, int n2, ArrayList<String> arrayList, ArrayList<String> arrayList2, String string3, String string4, String string5) throws RDFException {
            String string62;
            this.TFTidx = n;
            this.TFTsig = string;
            this.termType = string2;
            this.exprType = n2;
            this.strList = arrayList;
            this.colTypeList = arrayList2;
            if (arrayList.size() != arrayList2.size() + 1) {
                throw new RDFException("internal error in TFTinfo constructor: strList.size()=" + arrayList.size() + " colTypeList.size()=" + arrayList2.size());
            }
            this.numCols = arrayList2.size();
            this.datatype = string3;
            this.datatype_family = string4;
            this.language = string5;
            this.numIsolStrs = 0;
            this.strIsolList = new ArrayList(arrayList.size());
            if (arrayList.size() > 1) {
                this.strIsolList.add("leftmost");
            } else {
                this.strIsolList.add("leftmost-and-rightmost");
            }
            for (int i = 1; i < arrayList.size() - 1; ++i) {
                this.strIsolList.add(null);
                string62 = arrayList.get(i);
                String string7 = arrayList2.get(i - 1);
                String string8 = arrayList2.get(i);
                if (string7.equals("STRING") && string8.equals("STRING")) continue;
                if (string7.equals("DATE") || string7.indexOf(RelationalBGP.LTC_TYPE_TIMESTAMP) == 0) {
                    this.strIsolList.set(i, "(" + string7 + ",*)");
                    continue;
                }
                if (string8.equals("DATE") || string8.indexOf(RelationalBGP.LTC_TYPE_TIMESTAMP) == 0) {
                    this.strIsolList.set(i, "(*," + string8 + ")");
                    continue;
                }
                if (!(!string7.equals(RelationalBGP.LTC_TYPE_BFLOAT) && string7.indexOf(RelationalBGP.LTC_TYPE_BDOUBLE) != 0 || string8.equals(RelationalBGP.LTC_TYPE_NUMBER) || string8.equals("STRING"))) {
                    this.strIsolList.set(i, "(" + string7 + ",not-NUMBER-not-STRING)");
                    continue;
                }
                if (string8.equals(RelationalBGP.LTC_TYPE_BFLOAT) || string8.indexOf(RelationalBGP.LTC_TYPE_BDOUBLE) == 0) {
                    this.strIsolList.set(i, "(*," + string8 + ")");
                    continue;
                }
                boolean bl = true;
                boolean bl2 = true;
                if (string62.charAt(0) == '+') {
                    bl = false;
                    bl2 = false;
                } else {
                    if (string62.charAt(0) == '-') {
                        bl = false;
                    } else if (string62.charAt(0) == '0') {
                        bl2 = false;
                    }
                    if (string62.indexOf(46) == -1) {
                        try {
                            int n3 = Integer.parseInt(string62);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            bl2 = false;
                        }
                    } else if (string62.indexOf(46) == string62.lastIndexOf(46)) {
                        if (string62.charAt(string62.length() - 1) == '0') {
                            bl = false;
                        }
                        try {
                            int n4 = Integer.parseInt(string62.substring(0, string62.indexOf(46)));
                            int n5 = Integer.parseInt(string62.substring(string62.indexOf(46) + 1, string62.length()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            bl2 = false;
                        }
                    } else {
                        bl = false;
                        bl2 = false;
                    }
                }
                if ((string7.equals(RelationalBGP.LTC_TYPE_NUMBER) && bl || string7.equals("STRING")) && (string8.equals(RelationalBGP.LTC_TYPE_NUMBER) && bl2 || string8.equals("STRING"))) continue;
                this.strIsolList.set(i, "(" + string7 + "[db_form_num_suffix=" + bl + "]," + string8 + "[db_form_num_prefix=" + bl2 + "])");
            }
            if (arrayList.size() > 1) {
                this.strIsolList.add("rightmost");
            }
            for (String string62 : this.strIsolList) {
                if (string62 == null) continue;
                ++this.numIsolStrs;
            }
            boolean bl = false;
            if (string2.equals(RelationalBGP.rrLiteral)) {
                if (arrayList2.size() == 0) {
                    bl = true;
                } else if (arrayList2.size() == 1) {
                    string62 = arrayList2.get(0);
                    if (string62.equals(RelationalBGP.LTC_TYPE_NUMBER)) {
                        string62 = RelationalBGP.TYPE_FAM_NUMERIC;
                    } else if (string62.equals(RelationalBGP.LTC_TYPE_TIMESTAMP) || string62.equals(RelationalBGP.LTC_TYPE_TIMESTAMP_TZ) || string62.equals(RelationalBGP.LTC_TYPE_TIMESTAMP_LTZ)) {
                        string62 = RelationalBGP.TYPE_FAM_DATETIME;
                    } else if (string62.equals(RelationalBGP.LTC_TYPE_BFLOAT)) {
                        string62 = RelationalBGP.TYPE_FAM_FLOAT;
                    } else if (string62.equals(RelationalBGP.LTC_TYPE_BDOUBLE)) {
                        string62 = RelationalBGP.TYPE_FAM_DOUBLE;
                    }
                    if (string4 != null && (string4.equals(string62) || (string4.equals(RelationalBGP.TYPE_FAM_FLOAT) || string4.equals(RelationalBGP.TYPE_FAM_DOUBLE) || string4.equals(RelationalBGP.TYPE_FAM_NUMERIC)) && (string62.equals(RelationalBGP.TYPE_FAM_FLOAT) || string62.equals(RelationalBGP.TYPE_FAM_DOUBLE) || string62.equals(RelationalBGP.TYPE_FAM_NUMERIC)))) {
                        this.ieq_optimizable = true;
                    }
                }
            }
        }

        public String toString() {
            return "\nTFTinfo [TFTidx=" + this.TFTidx + ": TFTsig=" + this.TFTsig + "]:\n" + "  termType=" + this.termType + " exprType=" + this.exprType + "\n" + "  datatype=" + this.datatype + " datatype_family=" + this.datatype_family + " language=" + this.language + "\n" + "  numCols=" + this.numCols + "\n" + "  strList (size=" + this.strList.size() + ")=" + this.strList + "\n" + "  colTypeList (size=" + this.colTypeList.size() + ")=" + this.colTypeList + "\n" + "  numIsolStrs=" + this.numIsolStrs + "\n" + "  strIsolList (size=" + this.strIsolList.size() + ")=" + this.strIsolList + "\n" + "  ieq_optimizable=" + this.ieq_optimizable;
        }
    }

    private class String3 {
        public String str1;
        public String str2;
        public String str3;

        public String3(String string, String string2, String string3) {
            this.str1 = string;
            this.str2 = string2;
            this.str3 = string3;
        }

        public String toString() {
            return "[" + this.str1 + "]" + "<" + this.str2 + ">" + "[" + this.str3 + "]";
        }
    }

    private class String2 {
        public String str1;
        public String str2;

        private String2() {
        }
    }

    private class Pair_IntString {
        public int num;
        public String str;

        private Pair_IntString() {
        }
    }

    private class Pair_IntInt {
        public int num1;
        public int num2;

        private Pair_IntInt() {
        }
    }
}

