/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import oracle.spatial.rdf.server.OrderCond;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTOrderClause;
import oracle.spatial.rdf.server.parser.sparql.ASTOrderCondition;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectClause;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTSolutionModifier;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class OrderByExprRewriteOptimizer
implements SparqlQueryOptimizer {
    int totalVars = 0;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        if (((SimpleNode)node).id == 7) {
            ASTSelectQuery aSTSelectQuery = (ASTSelectQuery)node;
            if (aSTSelectQuery.solnMod.getOrderConds().size() > 0 && (aSTSelectQuery.solnMod.hasGroupBy() || aSTSelectQuery.getselDesc().containsAggregate())) {
                this.rewriteSelect(aSTSelectQuery);
            }
        }
        int n = ((SimpleNode)node).jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            this.optimizeQuery((SimpleNode)node.jjtGetChild(i));
        }
        return node;
    }

    private void rewriteSelect(ASTSelectQuery aSTSelectQuery) {
        ArrayList<OrderCond> arrayList = new ArrayList<OrderCond>();
        ASTSelectClause aSTSelectClause = null;
        for (int i = 0; i < aSTSelectQuery.jjtGetNumChildren(); ++i) {
            if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id == 8) {
                aSTSelectClause = (ASTSelectClause)aSTSelectQuery.jjtGetChild(i);
                continue;
            }
            if (((SimpleNode)aSTSelectQuery.jjtGetChild((int)i)).id != 13) continue;
            ASTSolutionModifier aSTSolutionModifier = (ASTSolutionModifier)aSTSelectQuery.jjtGetChild(i);
            for (int j = 0; j < aSTSolutionModifier.jjtGetNumChildren(); ++j) {
                if (((SimpleNode)aSTSolutionModifier.jjtGetChild((int)j)).id != 18) continue;
                ASTOrderClause aSTOrderClause = (ASTOrderClause)aSTSolutionModifier.jjtGetChild(j);
                for (int k = 0; k < aSTOrderClause.jjtGetNumChildren(); ++k) {
                    SimpleNode simpleNode;
                    if (((SimpleNode)aSTOrderClause.jjtGetChild((int)k)).id != 19) continue;
                    ASTOrderCondition aSTOrderCondition = (ASTOrderCondition)aSTOrderClause.jjtGetChild(k);
                    OrderCond orderCond = new OrderCond();
                    orderCond.setDir(aSTOrderCondition.dir);
                    arrayList.add(orderCond);
                    if (((SimpleNode)aSTOrderCondition.jjtGetChild((int)0)).id != 73) {
                        simpleNode = new ASTSelectExpression(9);
                        simpleNode.jjtSetInitCapacity(2);
                        Node node = aSTOrderCondition.jjtGetChild(0);
                        simpleNode.jjtAddChild(node, 0);
                        node.jjtSetParent(simpleNode);
                        ++this.totalVars;
                        String string = "A$" + this.totalVars;
                        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
                        aSTTripleAtom.type = 0;
                        aSTTripleAtom.name = string;
                        simpleNode.jjtAddChild(aSTTripleAtom, 1);
                        aSTTripleAtom.jjtSetParent(simpleNode);
                        aSTSelectClause.jjtAddChild(simpleNode, aSTSelectClause.jjtGetNumChildren());
                        simpleNode.jjtSetParent(aSTSelectClause);
                        aSTSelectQuery.getselDesc().addSelection(aSTTripleAtom, node, null);
                        aSTSelectQuery.selDesc.setHasExpression();
                        ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)aSTTripleAtom.cloneNode();
                        aSTOrderCondition.jjtAddChild(aSTTripleAtom2, 0);
                        aSTTripleAtom2.jjtSetParent(aSTOrderCondition);
                        orderCond.setVar(aSTTripleAtom2);
                        continue;
                    }
                    simpleNode = (ASTTripleAtom)aSTOrderCondition.jjtGetChild(0);
                    if (((ASTTripleAtom)simpleNode).type == 0) {
                        orderCond.setVar((ASTTripleAtom)simpleNode);
                        continue;
                    }
                    orderCond.setExprTree(simpleNode);
                }
            }
        }
        if (this.totalVars > 0) {
            aSTSelectQuery.getsolnMod().setOrderConds(arrayList);
        }
    }
}

