/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SelectExpression;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.SparqlSolnModDesc;

public class GroupByAliasRewriteOptimizer
implements SparqlQueryOptimizer {
    private static final int MAX_ITERS = 10000;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        int n;
        boolean bl = true;
        for (n = 0; bl && n < 10000; ++n) {
            bl = this.removeAlias(node);
        }
        if (n >= 10000) {
            throw new ParseException("GroupByAliasRewriteOptimizer: entered infinite loop when optimizing query tree");
        }
        return node;
    }

    private boolean removeAlias(Node node) throws ParseException {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        boolean bl = false;
        while (!stack.isEmpty() && !bl) {
            ASTSelectQuery aSTSelectQuery;
            SparqlSolnModDesc sparqlSolnModDesc;
            Node node2 = (Node)stack.pop();
            if (((SimpleNode)node2).id == 7 && (sparqlSolnModDesc = (aSTSelectQuery = (ASTSelectQuery)node2).getsolnMod()).hasGroupBy()) {
                Node node3;
                Node node4;
                SimpleNode simpleNode;
                List<SelectExpression> list = sparqlSolnModDesc.getGroupByConds();
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (SelectExpression selectExpression : list) {
                    if (!selectExpression.isAliased()) continue;
                    bl = true;
                    simpleNode = new ASTSelectExpression(9);
                    simpleNode.jjtSetInitCapacity(2);
                    node4 = selectExpression.getExprTree().cloneSubTree();
                    node3 = selectExpression.getVar().cloneNode();
                    simpleNode.jjtAddChild(node4, 0);
                    node4.jjtSetParent(simpleNode);
                    simpleNode.jjtAddChild(node3, 1);
                    node3.jjtSetParent(simpleNode);
                    arrayList.add(simpleNode);
                }
                if (bl) {
                    Object object;
                    ArrayList arrayList2 = new ArrayList();
                    int n = 0;
                    for (int i = 0; i < aSTSelectQuery.jjtGetNumChildren(); ++i) {
                        int n2;
                        node4 = aSTSelectQuery.jjtGetChild(i);
                        if (((SimpleNode)node4).id == 48) {
                            n = i;
                            for (n2 = 0; n2 < node4.jjtGetNumChildren(); ++n2) {
                                object = node4.jjtGetChild(n2);
                                arrayList2.add(object);
                            }
                        }
                        if (((SimpleNode)node4).id != 13) continue;
                        for (n2 = 0; n2 < node4.jjtGetNumChildren(); ++n2) {
                            object = node4.jjtGetChild(n2);
                            if (((SimpleNode)object).id != 14) continue;
                            OptimizerUtils.removeAliasedExpressions((Node)object);
                        }
                    }
                    simpleNode = OptimizerUtils.genSelectQuery(arrayList2, arrayList);
                    node4 = new ASTGroupGraphPattern(48);
                    node3 = new ASTGraphPatternNotTriples(49);
                    aSTSelectQuery.jjtAddChild(node4, n);
                    ((SimpleNode)node4).jjtSetParent(aSTSelectQuery);
                    ((SimpleNode)node4).jjtSetInitCapacity(1);
                    ((SimpleNode)node4).jjtAddChild(node3, 0);
                    ((SimpleNode)node3).jjtSetParent(node4);
                    ((SimpleNode)node3).jjtSetInitCapacity(1);
                    ((SimpleNode)node3).jjtAddChild(simpleNode, 0);
                    simpleNode.jjtSetParent(node3);
                    object = new SparqlSolnModDesc();
                    ((SparqlSolnModDesc)object).setSolnModExists(true);
                    ((SparqlSolnModDesc)object).populateSolnMod(aSTSelectQuery);
                    aSTSelectQuery.setsolnMod((SparqlSolnModDesc)object);
                }
            }
            if (bl) continue;
            for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
        return bl;
    }
}

