/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTBuiltInCall;
import oracle.spatial.rdf.server.parser.sparql.ASTEFilter;
import oracle.spatial.rdf.server.parser.sparql.ASTFilter;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class EFilterRewriteOptimizer
implements SparqlQueryOptimizer {
    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        int[] nArray = new int[]{0};
        boolean bl = this.transformSingleEFilter(node, nArray);
        while (bl) {
            bl = this.transformSingleEFilter(node, nArray);
        }
        return node;
    }

    private boolean transformSingleEFilter(Node node, int[] nArray) throws RDFException {
        Node node2 = null;
        boolean bl = false;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(node);
        while (!bl && !linkedList.isEmpty()) {
            int n;
            node2 = (Node)linkedList.remove();
            if (((SimpleNode)node2).id == 48) {
                for (n = 0; n < node2.jjtGetNumChildren() && !bl; ++n) {
                    bl = this.rewriteEFilter((ASTGroupGraphPattern)node2, node2.jjtGetChild(n), n, nArray);
                }
            }
            if (bl) continue;
            for (n = 0; n < node2.jjtGetNumChildren(); ++n) {
                linkedList.offer(node2.jjtGetChild(n));
            }
        }
        return bl;
    }

    private boolean rewriteEFilter(ASTGroupGraphPattern aSTGroupGraphPattern, Node node, int n, int[] nArray) throws RDFException {
        Node node2 = null;
        boolean bl = false;
        SimpleNode simpleNode = null;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(node);
        while (!bl && !linkedList.isEmpty()) {
            node2 = (Node)linkedList.remove();
            if (OptimizerUtils.isRewritableEFilterTB(node2)) {
                bl = true;
                simpleNode = (ASTTriplesBlock)node2;
                if (!OptimizerUtils.hasAncestorType(simpleNode, 51)) continue;
                throw new RDFException("EFILTER clauses are not supported inside EDGE clauses");
            }
            if (((SimpleNode)node2).id == 48) continue;
            for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                linkedList.offer(node2.jjtGetChild(i));
            }
        }
        if (bl) {
            if (((SimpleNode)simpleNode.jjtGetChild((int)0)).id == 73 && (((SimpleNode)simpleNode.jjtGetChild((int)1)).id == 67 || ((SimpleNode)simpleNode.jjtGetChild((int)1)).id == 64) && ((SimpleNode)simpleNode.jjtGetChild((int)2)).id == 73) {
                ASTGraphPatternNotTriples aSTGraphPatternNotTriples = this.buildEFilterGPNT((ASTTripleAtom)simpleNode.jjtGetChild(0), (SimpleNode)simpleNode.jjtGetChild(1), (ASTTripleAtom)simpleNode.jjtGetChild(2), nArray);
                boolean bl2 = simpleNode.jjtGetNumChildren() == 4;
                Node node3 = simpleNode.jjtGetParent();
                if (((SimpleNode)node3).id == 47) {
                    int n2;
                    node3.jjtRemoveChild(3);
                    int n3 = n + 1;
                    Node[] nodeArray = new Node[n3];
                    Node[] nodeArray2 = new Node[aSTGroupGraphPattern.jjtGetNumChildren() - n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        nodeArray[n2] = aSTGroupGraphPattern.jjtGetChild(n2);
                    }
                    n2 = n3;
                    int n4 = 0;
                    while (n2 < aSTGroupGraphPattern.jjtGetNumChildren()) {
                        nodeArray2[n4] = aSTGroupGraphPattern.jjtGetChild(n2);
                        ++n2;
                        ++n4;
                    }
                    n2 = aSTGroupGraphPattern.jjtGetNumChildren() + 1;
                    if (bl2) {
                        ++n2;
                    }
                    aSTGroupGraphPattern.jjtSetInitCapacity(n2);
                    for (n4 = 0; n4 < n3; ++n4) {
                        aSTGroupGraphPattern.jjtAddChild(nodeArray[n4], n4);
                    }
                    aSTGroupGraphPattern.jjtAddChild(aSTGraphPatternNotTriples, n3);
                    aSTGraphPatternNotTriples.jjtSetParent(aSTGroupGraphPattern);
                    n4 = n3 + 1;
                    if (bl2) {
                        Node node4 = simpleNode.jjtGetChild(3);
                        aSTGroupGraphPattern.jjtAddChild(node4, n4);
                        node4.jjtSetParent(aSTGroupGraphPattern);
                        ++n4;
                    }
                    int n5 = n4;
                    int n6 = 0;
                    while (n5 < n2) {
                        aSTGroupGraphPattern.jjtAddChild(nodeArray2[n6], n5);
                        ++n5;
                        ++n6;
                    }
                } else if (((SimpleNode)node3).id == 48) {
                    int n7;
                    int n8 = n;
                    Node[] nodeArray = new Node[n8];
                    Node[] nodeArray3 = new Node[aSTGroupGraphPattern.jjtGetNumChildren() - (n8 + 1)];
                    for (n7 = 0; n7 < n8; ++n7) {
                        nodeArray[n7] = aSTGroupGraphPattern.jjtGetChild(n7);
                    }
                    n7 = n8 + 1;
                    int n9 = 0;
                    while (n7 < aSTGroupGraphPattern.jjtGetNumChildren()) {
                        nodeArray3[n9] = aSTGroupGraphPattern.jjtGetChild(n7);
                        ++n7;
                        ++n9;
                    }
                    n7 = aSTGroupGraphPattern.jjtGetNumChildren();
                    if (bl2) {
                        ++n7;
                    }
                    aSTGroupGraphPattern.jjtSetInitCapacity(n7);
                    for (n9 = 0; n9 < n8; ++n9) {
                        aSTGroupGraphPattern.jjtAddChild(nodeArray[n9], n9);
                    }
                    aSTGroupGraphPattern.jjtAddChild(aSTGraphPatternNotTriples, n8);
                    aSTGraphPatternNotTriples.jjtSetParent(aSTGroupGraphPattern);
                    n9 = n8 + 1;
                    if (bl2) {
                        Node node5 = simpleNode.jjtGetChild(3);
                        aSTGroupGraphPattern.jjtAddChild(node5, n9);
                        node5.jjtSetParent(aSTGroupGraphPattern);
                        ++n9;
                    }
                    int n10 = n9;
                    int n11 = 0;
                    while (n10 < n7) {
                        aSTGroupGraphPattern.jjtAddChild(nodeArray3[n11], n10);
                        ++n10;
                        ++n11;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private ASTGraphPatternNotTriples buildEFilterGPNT(ASTTripleAtom aSTTripleAtom, SimpleNode simpleNode, ASTTripleAtom aSTTripleAtom2, int[] nArray) throws RDFException {
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
        ASTGraphGraphPattern aSTGraphGraphPattern = new ASTGraphGraphPattern(51);
        aSTGraphPatternNotTriples.jjtAddChild(aSTGraphGraphPattern, 0);
        aSTGraphGraphPattern.jjtSetParent(aSTGraphPatternNotTriples);
        ASTTripleAtom aSTTripleAtom3 = new ASTTripleAtom(73);
        aSTTripleAtom3.type = 0;
        aSTTripleAtom3.name = "G$" + nArray[0];
        nArray[0] = nArray[0] + 1;
        aSTGraphGraphPattern.jjtAddChild(aSTTripleAtom3, 0);
        aSTTripleAtom3.jjtSetParent(aSTGraphGraphPattern);
        ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
        aSTGraphGraphPattern.jjtAddChild(aSTGroupGraphPattern, 1);
        aSTGroupGraphPattern.jjtSetParent(aSTGraphGraphPattern);
        ASTTriplesBlock aSTTriplesBlock = new ASTTriplesBlock(47);
        aSTTriplesBlock.jjtAddChild(aSTTripleAtom, 0);
        aSTTripleAtom.jjtSetParent(aSTTriplesBlock);
        if (simpleNode.jjtGetNumChildren() != 2) {
            throw new RDFException("EFilterRewriteOptimizer: Unexpected number of children under predicate");
        }
        if (((SimpleNode)simpleNode.jjtGetChild((int)0)).id != 73 && ((SimpleNode)simpleNode.jjtGetChild((int)1)).id != 57) {
            throw new RDFException("EFilterRewriteOptimizer: Unexpected node type under predicate");
        }
        ASTTripleAtom aSTTripleAtom4 = (ASTTripleAtom)simpleNode.jjtGetChild(0);
        aSTTriplesBlock.jjtAddChild(aSTTripleAtom4, 1);
        aSTTripleAtom4.jjtSetParent(aSTTriplesBlock);
        aSTTriplesBlock.jjtAddChild(aSTTripleAtom2, 2);
        aSTTripleAtom2.jjtSetParent(aSTTriplesBlock);
        aSTGroupGraphPattern.jjtAddChild(aSTTriplesBlock, 0);
        aSTTriplesBlock.jjtSetParent(aSTGroupGraphPattern);
        ASTEFilter aSTEFilter = (ASTEFilter)simpleNode.jjtGetChild(1);
        if (aSTEFilter.jjtGetNumChildren() != 1) {
            throw new RDFException("EFilterRewriteOptimizer: Unexpected number of children under ASTEFilter");
        }
        ASTFilter aSTFilter = new ASTFilter(56);
        Node node = aSTEFilter.jjtGetChild(0);
        aSTFilter.jjtAddChild(node, 0);
        node.jjtSetParent(aSTFilter);
        simpleNode.jjtAddChild(aSTFilter, 1);
        aSTFilter.jjtSetParent(simpleNode);
        Set<String> set = this.getFilterPredicates(aSTFilter);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object2 : set) {
            hashMap.put(object2, "V$" + nArray[0]);
            nArray[0] = nArray[0] + 1;
        }
        this.updateFilterPredicates(aSTFilter, hashMap);
        Object object3 = aSTTriplesBlock;
        for (Map.Entry entry : hashMap.entrySet()) {
            ASTTriplesBlock aSTTriplesBlock2 = new ASTTriplesBlock(47);
            Node node2 = aSTTripleAtom3.cloneNode();
            ASTTripleAtom aSTTripleAtom5 = new ASTTripleAtom(73);
            aSTTripleAtom5.type = 1;
            aSTTripleAtom5.name = (String)entry.getKey();
            ASTTripleAtom aSTTripleAtom6 = new ASTTripleAtom(73);
            aSTTripleAtom6.type = 0;
            aSTTripleAtom6.name = (String)entry.getValue();
            aSTTriplesBlock2.jjtAddChild(node2, 0);
            node2.jjtSetParent(aSTTriplesBlock2);
            aSTTriplesBlock2.jjtAddChild(aSTTripleAtom5, 1);
            aSTTripleAtom5.jjtSetParent(aSTTriplesBlock2);
            aSTTriplesBlock2.jjtAddChild(aSTTripleAtom6, 2);
            aSTTripleAtom5.jjtSetParent(aSTTriplesBlock2);
            ((SimpleNode)object3).jjtAddChild(aSTTriplesBlock2, 3);
            aSTTriplesBlock2.jjtSetParent((Node)object3);
            object3 = aSTTriplesBlock2;
        }
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples2 = new ASTGraphPatternNotTriples(49);
        aSTGroupGraphPattern.jjtAddChild(aSTGraphPatternNotTriples2, 1);
        aSTGraphPatternNotTriples2.jjtSetParent(aSTGroupGraphPattern);
        aSTGraphPatternNotTriples2.jjtAddChild(aSTFilter, 0);
        aSTFilter.jjtSetParent(aSTGraphPatternNotTriples2);
        return aSTGraphPatternNotTriples;
    }

    private Set<String> getFilterPredicates(ASTFilter aSTFilter) throws RDFException {
        HashSet<String> hashSet = new HashSet<String>();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(aSTFilter);
        SimpleNode simpleNode = null;
        ASTTripleAtom aSTTripleAtom = null;
        ASTBuiltInCall aSTBuiltInCall = null;
        block5: while (!linkedList.isEmpty()) {
            int n;
            simpleNode = (SimpleNode)linkedList.remove();
            switch (simpleNode.id) {
                case 73: {
                    aSTTripleAtom = (ASTTripleAtom)simpleNode;
                    if (aSTTripleAtom.type != 1) continue block5;
                    hashSet.add(aSTTripleAtom.name);
                    continue block5;
                }
                case 58: 
                case 90: {
                    for (n = 1; n < simpleNode.jjtGetNumChildren(); ++n) {
                        linkedList.offer(simpleNode.jjtGetChild(n));
                    }
                    continue block5;
                }
                case 88: {
                    aSTBuiltInCall = (ASTBuiltInCall)simpleNode;
                    if (!aSTBuiltInCall.name.equals("EXISTS") && !aSTBuiltInCall.name.equals("NOT EXISTS")) break;
                    throw new RDFException("EXISTS statements are not supported inside EFILTER clauses");
                }
            }
            for (n = 0; n < simpleNode.jjtGetNumChildren(); ++n) {
                linkedList.offer(simpleNode.jjtGetChild(n));
            }
        }
        return hashSet;
    }

    private void updateFilterPredicates(ASTFilter aSTFilter, Map<String, String> map) throws RDFException {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(aSTFilter);
        SimpleNode simpleNode = null;
        ASTTripleAtom aSTTripleAtom = null;
        Object var6_6 = null;
        block4: while (!linkedList.isEmpty()) {
            int n;
            simpleNode = (SimpleNode)linkedList.remove();
            switch (simpleNode.id) {
                case 73: {
                    aSTTripleAtom = (ASTTripleAtom)simpleNode;
                    if (aSTTripleAtom.type != 1) continue block4;
                    aSTTripleAtom.type = 0;
                    aSTTripleAtom.name = map.get(aSTTripleAtom.name);
                    continue block4;
                }
                case 58: 
                case 90: {
                    for (n = 1; n < simpleNode.jjtGetNumChildren(); ++n) {
                        linkedList.offer(simpleNode.jjtGetChild(n));
                    }
                    continue block4;
                }
            }
            for (n = 0; n < simpleNode.jjtGetNumChildren(); ++n) {
                linkedList.offer(simpleNode.jjtGetChild(n));
            }
        }
    }
}

