/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintProvider;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public class BGPJoinHintProvider
extends HintProvider {
    static final HintProvider.HintToken BGP_JOIN_TOKEN = HintProvider.HintToken.createToken("BGP_JOIN");
    private static final Map<HintProvider.HintToken, Enum> TOKENS;
    private static final BGPJoinHintProvider instance;

    private BGPJoinHintProvider() {
    }

    public static BGPJoinHintProvider getInstance() {
        return instance;
    }

    @Override
    protected Map<HintProvider.HintToken, Enum> getParsableTokens() {
        return TOKENS;
    }

    @Override
    protected void parseToken(HintProvider.HintContext hintContext, HintProvider.HintToken hintToken, Enum enum_) throws ParseException {
        assert (hintToken != null) : "Received null token";
        assert (enum_ != null) : "Received null type for the BGP_JOIN hint '" + hintToken.getValue() + "'";
        HintProvider.HintBuilder hintBuilder = hintContext.getHintBuilder();
        if (enum_.getDeclaringClass() == Hint.QueryOption.class) {
            Hint.QueryOption queryOption = Hint.QueryOption.valueOf(enum_.name());
            assert (queryOption != null) : "Received invalid type, '" + enum_ + "', for the BGP_JOIN hint '" + hintToken.getValue() + "'";
            hintBuilder.addQueryOption(queryOption);
            return;
        }
        Hint.JoinHint joinHint = Hint.JoinHint.valueOf(enum_.name());
        assert (joinHint != null) : "Received invalid type, '" + enum_ + "', for the BGP_JOIN hint '" + hintToken.getValue() + "'";
        if (joinHint == Hint.JoinHint.SWAP_JOIN_INPUTS) {
            hintBuilder.addBGPJoinHint(Hint.JoinHint.USE_HASH);
        }
        hintBuilder.addBGPJoinHint(joinHint);
    }

    static {
        HashMap<HintProvider.HintToken, Enum> hashMap = new HashMap<HintProvider.HintToken, Enum>();
        for (Hint.JoinHint joinHint : Hint.JoinHint.values()) {
            hashMap.put(HintProvider.HintToken.createNoArgToken(BGP_JOIN_TOKEN, joinHint.getName()), joinHint);
        }
        hashMap.put(HintProvider.HintToken.createNoArgToken(BGP_JOIN_TOKEN, Hint.QueryOption.BGP_PUSH_DOWN.getName()), Hint.QueryOption.BGP_PUSH_DOWN);
        TOKENS = Collections.unmodifiableMap(hashMap);
        instance = new BGPJoinHintProvider();
    }
}

