/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;

public class WSAuthenticator
extends Authenticator {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static HashMap<String, PasswordAuthentication> credStore = new HashMap();
    private static final WSAuthenticator instance = new WSAuthenticator();

    private WSAuthenticator() {
        Authenticator.setDefault(this);
    }

    public static WSAuthenticator getInstance() {
        return instance;
    }

    public void reactivate() {
        Authenticator.setDefault(instance);
    }

    public void clear() {
        credStore.clear();
    }

    public final synchronized void addProtectedURL(String url, String userName, String password) {
        if (url == null || userName == null || password == null) {
            throw new IllegalArgumentException("Invalid url or credential.");
        }
        String key = url.toLowerCase();
        PasswordAuthentication pa = new PasswordAuthentication(userName, password.toCharArray());
        credStore.put(key, pa);
    }

    public final synchronized void removeProtectedURL(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Invalid url.");
        }
        String key = url.toLowerCase();
        credStore.remove(key);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        try {
            String u = super.getRequestingURL().toString().toLowerCase();
            for (String key : credStore.keySet()) {
                if (!u.startsWith(key)) continue;
                log.finest("Got required credential for URL: " + u + ".");
                return credStore.get(key);
            }
            log.info("Oops, cannot get required credential for URL: " + u + ".");
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

