/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JavaDBStyleStore;
import oracle.sdovis.MapTable;
import oracle.sdovis.StyleCache;
import oracle.sdovis.ThemeTable;
import oracle.sdovis.TileLayerTable;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.AllStyleTable;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.util.Base64OutputStream;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MMExport {
    static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static String delim = "|";
    static String ESC = "&#124;";
    static String styleTable = "USER_SDO_STYLES";
    static String themeTable = "USER_SDO_THEMES";
    static String mapTable = "USER_SDO_MAPS";
    static String tileTable = "USER_SDO_CACHED_MAPS";
    static String DS_NAME = "MMExport_temp_ds";
    static String[] baseMapList = null;

    public static void main(String[] args) throws Exception {
        if (args.length != 5 && args.length != 9 && args.length != 6) {
            System.out.println("Usage: java MMExport <host> <sid> <port> <user> <password>\n Or \n       java MMExport <host> <sid> <port> <user> <password> <style_table> <theme_table> <map_table> <tilelayer_table>\n Or \n       java MMExport <host> <sid> <port> <user> <password> maps=basemap1,basemap2");
            System.exit(1);
        }
        if (args.length == 9) {
            styleTable = args[5];
            themeTable = args[6];
            mapTable = args[7];
            tileTable = args[8];
        }
        System.out.println("metadata tables: " + styleTable + "," + themeTable + "," + mapTable + "," + tileTable);
        if (args.length == 6) {
            String mapsList = args[5].substring(5);
            baseMapList = mapsList.split(",");
        }
        System.out.println("connecting to " + args[0] + "...");
        DSManager.registerOracleJdbcDS(DS_NAME, args[0], args[2], args[1], args[3], args[4], "thin", 3);
        System.out.println("connected.");
        MMExport.export(args);
        DSManager.remove(DS_NAME);
    }

    public static void setDataSource(String ds) {
        DS_NAME = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(String[] args) throws IOException, SQLException {
        FileOutputStream fos = new FileOutputStream("mapmeta.dat");
        try (PrintStream os = new PrintStream(fos);){
            if (baseMapList == null) {
                MMExport.exportStyles(os, null, false);
                MMExport.exportThemes(os, null, null);
                MMExport.exportMaps(os, null, null);
                MMExport.exportTileLayers(os, null, null);
            } else {
                MMExport.exportBaseMaps(baseMapList, os);
            }
        }
        System.out.println("export of map metadata done. output is mapmeta.dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportMetadata(String dataSource, String fileName, boolean styles, boolean themes, boolean basemaps, boolean tilelayers) throws IOException, SQLException {
        if (dataSource == null || fileName == null) {
            return false;
        }
        if (DSManager.get(dataSource) == null) {
            return false;
        }
        DS_NAME = dataSource;
        FileOutputStream fos = new FileOutputStream(fileName);
        try (PrintStream os = new PrintStream(fos);){
            if (styles) {
                MMExport.exportStyles(os, null, false);
            }
            if (themes) {
                MMExport.exportThemes(os, null, null);
            }
            if (basemaps) {
                MMExport.exportMaps(os, null, null);
            }
            if (tilelayers) {
                MMExport.exportTileLayers(os, null, null);
            }
        }
        log.info("export of map metadata done. output is " + fileName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportMetadata(String dataSource, String fileName, String[] tilelayers, String[] basemaps, String[] themes, String[] styles, boolean inclDependencies) throws IOException, SQLException {
        if (dataSource == null || fileName == null || styles == null && themes == null && basemaps == null && tilelayers == null) {
            return false;
        }
        if (DSManager.get(dataSource) == null) {
            return false;
        }
        DS_NAME = dataSource;
        Hashtable<String, String> tiles = new Hashtable<String, String>();
        if (tilelayers != null) {
            for (int i = 0; i < tilelayers.length; ++i) {
                tiles.put(tilelayers[i].toUpperCase(), tilelayers[i].toUpperCase());
            }
        }
        Hashtable<String, String> maps = new Hashtable<String, String>();
        if (basemaps != null) {
            for (int i = 0; i < basemaps.length; ++i) {
                maps.put(basemaps[i].toUpperCase(), basemaps[i].toUpperCase());
            }
        }
        Hashtable<String, String> ths = new Hashtable<String, String>();
        if (themes != null) {
            for (int i = 0; i < themes.length; ++i) {
                ths.put(themes[i].toUpperCase(), themes[i].toUpperCase());
            }
        }
        Hashtable<String, String> stys = new Hashtable<String, String>();
        if (styles != null) {
            for (int i = 0; i < styles.length; ++i) {
                stys.put(styles[i].toUpperCase(), styles[i].toUpperCase());
            }
        }
        FileOutputStream fos = new FileOutputStream(fileName);
        try (PrintStream os = new PrintStream(fos);){
            if (!inclDependencies) {
                if (tiles.size() > 0) {
                    MMExport.exportTileLayers(os, tiles, null);
                }
                if (maps.size() > 0) {
                    MMExport.exportMaps(os, maps, null);
                }
                if (ths.size() > 0) {
                    MMExport.exportThemes(os, ths, null);
                }
                if (stys.size() > 0) {
                    MMExport.exportStyles(os, stys, false);
                }
            } else {
                if (tiles.size() > 0) {
                    MMExport.exportTileLayers(os, tiles, maps);
                }
                if (maps.size() > 0) {
                    MMExport.exportMaps(os, maps, ths);
                }
                if (ths.size() > 0) {
                    MMExport.exportThemes(os, ths, stys);
                }
                if (stys.size() > 0) {
                    MMExport.exportStyles(os, stys, true);
                }
            }
        }
        log.info("export of map metadata done. output is " + fileName);
        return true;
    }

    public static void exportStyles(PrintStream os, Hashtable styleList, boolean inclStyleDependency) throws SQLException, IOException {
        ByteArrayOutputStream bytes;
        byte[] img;
        DBTable st;
        String name;
        DataSourceI ds;
        log.info("exporting styles...");
        Hashtable<String, String> styleDependencyList = new Hashtable<String, String>();
        StyleCache sc = null;
        if (styleList != null && inclStyleDependency && (ds = DSManager.get(DS_NAME)) != null && (sc = ds.getStyleCache()) != null) {
            Enumeration e = styleList.keys();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                try {
                    String[] depStyles;
                    Style style = sc.getStyleStore().getStyleObject(name);
                    if (style == null || (depStyles = style.getModel().getStyleDependency()) == null || depStyles.length <= 0) continue;
                    for (int i = 0; i < depStyles.length; ++i) {
                        styleDependencyList.put(depStyles[i].toUpperCase(), depStyles[i].toUpperCase());
                    }
                }
                catch (Exception ex) {
                }
            }
        }
        os.println("--------STYLES BEGIN--------");
        int n = 0;
        if (DSManager.getDataSourceType(DS_NAME).equalsIgnoreCase("ORACLE")) {
            st = null;
            st = styleTable.equalsIgnoreCase("ALL_SDO_STYLES") ? new AllStyleTable(DS_NAME, styleTable) : new StyleTable(DS_NAME, styleTable);
            st.query("select * from " + styleTable);
            while (st.next()) {
                name = ((StyleTable)st).getName().toUpperCase();
                if (styleList != null && styleList.get(name) == null && styleDependencyList.get(name) == null) continue;
                os.println(((StyleTable)st).getName() + delim);
                os.println(StyleUtils.getTypeNameFromCode(((StyleTable)st).getType()) + delim);
                os.println(MMExport.escape(((StyleTable)st).getDescription()) + delim);
                os.println(MMExport.escape(((StyleTable)st).getDefinition().toString()) + delim);
                img = ((StyleTable)st).getImageData();
                if (img == null) {
                    os.println("null" + delim);
                } else {
                    bytes = new ByteArrayOutputStream();
                    Base64OutputStream bo = new Base64OutputStream(bytes, false);
                    bo.write(img);
                    bo.flush();
                    os.println(bytes.toString() + delim);
                    bo.close();
                }
                ++n;
            }
            st.closeQuery();
        } else {
            st = new JavaDBStyleStore(DS_NAME);
            st.query("select * from " + styleTable);
            while (st.next()) {
                name = ((JavaDBStyleStore)st).getName().toUpperCase();
                if (styleList != null && styleList.get(name) == null && styleDependencyList.get(name) == null) continue;
                os.println(((JavaDBStyleStore)st).getName() + delim);
                os.println(StyleUtils.getTypeNameFromCode(((JavaDBStyleStore)st).getType()) + delim);
                os.println(MMExport.escape(((JavaDBStyleStore)st).getDescription()) + delim);
                os.println(MMExport.escape(((JavaDBStyleStore)st).getDefinition().toString()) + delim);
                img = ((JavaDBStyleStore)st).getImageData();
                if (img == null) {
                    os.println("null" + delim);
                } else {
                    bytes = new ByteArrayOutputStream();
                    Base64OutputStream bo = new Base64OutputStream(bytes, false);
                    bo.write(img);
                    bo.flush();
                    os.println(bytes.toString() + delim);
                    bo.close();
                }
                ++n;
            }
            st.closeQuery();
        }
        os.println("--------STYLES END--------");
        log.info("# of Styles exported: " + n);
    }

    public static void exportThemes(PrintStream os, Hashtable themeList, Hashtable styleList) throws SQLException {
        log.info("exporting themes...\n");
        os.println("--------THEMES BEGIN--------");
        ThemeTable tt = new ThemeTable(DS_NAME, themeTable);
        tt.query("select * from " + themeTable);
        int n = 0;
        while (tt.next()) {
            String name = tt.getName().toUpperCase();
            if (themeList != null && themeList.get(name) == null) continue;
            os.println(tt.getName() + delim);
            os.println(MMExport.escape(tt.getDescription()) + delim);
            os.println(tt.getBaseTable() + delim);
            os.println(tt.getSpatialColumn() + delim);
            os.println(MMExport.escape(tt.getStylingRules()) + delim);
            if (themeList != null && styleList != null) {
                MMExport.populateStyleList(tt.getStylingRules(), styleList);
            }
            ++n;
        }
        tt.closeQuery();
        os.println("--------THEMES END--------");
        log.info("# of Themes exported: " + n);
    }

    public static void exportMaps(PrintStream os, Hashtable mapList, Hashtable themeList) throws SQLException {
        log.info("exporting base maps...");
        os.println("--------MAPS BEGIN--------");
        MapTable mt = new MapTable(DS_NAME, mapTable);
        mt.query("select * from " + mapTable);
        int n = 0;
        while (mt.next()) {
            String name = mt.getName().toUpperCase();
            if (mapList != null && mapList.get(name) == null) continue;
            os.println(mt.getName() + delim);
            os.println(mt.getDescription() + delim);
            os.println(mt.getMapDefinition() + delim);
            if (mapList != null && themeList != null) {
                MMExport.populateThemeList(mt.getMapDefinition(), themeList);
            }
            ++n;
        }
        mt.closeQuery();
        os.println("--------MAPS END--------");
        log.info("# of Base maps exported: " + n);
    }

    public static void exportTileLayers(PrintStream os, Hashtable tilelayerList, Hashtable mapList) throws SQLException, IOException {
        log.info("exporting tile layers...");
        os.println("--------TILELAYERS BEGIN--------");
        TileLayerTable st = new TileLayerTable(DS_NAME, tileTable);
        st.query("select * from " + tileTable);
        int n = 0;
        while (st.next()) {
            String name = st.getName().toUpperCase();
            if (tilelayerList != null && tilelayerList.get(name) == null) continue;
            os.println(st.getName() + delim);
            os.println(MMExport.escape(st.getDescription()) + delim);
            os.println(st.getTilesTable() + delim);
            os.println(st.isOnline() + delim);
            os.println(st.isInternal() + delim);
            os.println(MMExport.escape(st.getDefinition().toString()) + delim);
            os.println(st.getBaseMap() + delim);
            byte[] madpt = st.getMapAdapter();
            if (madpt == null) {
                os.println("null" + delim);
            } else {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                Base64OutputStream bo = new Base64OutputStream(bytes, false);
                bo.write(madpt);
                bo.flush();
                os.println(bytes.toString() + delim);
                bo.close();
            }
            if (tilelayerList != null && mapList != null && st.getBaseMap() != null) {
                mapList.put(st.getBaseMap().toUpperCase(), st.getBaseMap().toUpperCase());
            }
            ++n;
        }
        st.closeQuery();
        os.println("--------TILELAYERS END--------");
        log.info("# of tile layers exported: " + n);
    }

    public static String escape(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\|", "&#124;");
    }

    public static void exportBaseMaps(String[] baseMapNames, PrintStream myOs) throws SQLException, IOException {
        ByteArrayOutputStream baosStyles = new ByteArrayOutputStream(16000);
        ByteArrayOutputStream baosThemes = new ByteArrayOutputStream(16000);
        ByteArrayOutputStream baosMaps = new ByteArrayOutputStream(4000);
        PrintStream mapOs = new PrintStream(baosMaps);
        PrintStream styleOs = new PrintStream(baosStyles);
        PrintStream themeOs = new PrintStream(baosThemes);
        log.info("Exporting selected base maps: " + baseMapNames.length);
        mapOs.println("--------MAPS BEGIN--------");
        MapTable mt = new MapTable(DS_NAME, mapTable);
        mt.query("select * from " + mapTable);
        int n = 0;
        Hashtable themeList = new Hashtable(37);
        Hashtable styleList = new Hashtable(37);
        while (mt.next()) {
            String name = mt.getName();
            boolean matched = false;
            for (int i = 0; i < baseMapNames.length; ++i) {
                if (!baseMapNames[i].equalsIgnoreCase(name)) continue;
                matched = true;
                break;
            }
            if (!matched) continue;
            log.info("exporting base map '" + name + "' ...");
            mapOs.println(mt.getName() + delim);
            mapOs.println(mt.getDescription() + delim);
            mapOs.println(mt.getMapDefinition() + delim);
            MMExport.populateThemeList(mt.getMapDefinition(), themeList);
            ++n;
        }
        mt.closeQuery();
        mapOs.println("--------MAPS END--------");
        MMExport.exportThemes(themeOs, themeList, styleList);
        MMExport.exportStyles(styleOs, styleList, true);
        mapOs.flush();
        themeOs.flush();
        styleOs.flush();
        baosMaps.close();
        baosThemes.close();
        baosStyles.close();
        myOs.println(baosStyles.toString());
        myOs.println(baosThemes.toString());
        myOs.println(baosMaps.toString());
    }

    protected static void populateThemeList(String mapDef, Hashtable themeList) {
        log.info("Map definition is:\n" + mapDef);
        XMLDOMParser parser = new XMLDOMParser();
        boolean res = parser.parse(mapDef);
        if (!res) {
            System.err.println("Error: cannot parse base map definition!");
            return;
        }
        Document doc = parser.getDocument();
        Node root = parser.getElementNode("map_definition");
        ArrayList themes = XMLDOMParser.getSubElements(root, "theme");
        if (themes == null || themes.size() == 0) {
            return;
        }
        int i = 0;
        for (i = 0; i < themes.size(); ++i) {
            Node theme = (Node)themes.get(i);
            String tName = XMLDOMParser.getAttribute(theme, "name");
            themeList.put(tName.toUpperCase(), tName.toUpperCase());
        }
        log.info("" + i + " themes added to list for export.");
    }

    protected static void populateStyleList(String themeDef, Hashtable styleList) {
        String style;
        log.info("Theme definition is:\n" + themeDef);
        int idx = 0;
        int idx2 = 0;
        int i = 0;
        themeDef = themeDef.toUpperCase();
        idx = themeDef.indexOf("STYLE=\"");
        while (idx > 0) {
            idx2 = themeDef.indexOf("\"", idx + 8);
            style = themeDef.substring(idx + 7, idx2);
            if (style != null && style.length() > 0 && style.indexOf(":") < 0) {
                styleList.put(style.toUpperCase(), style.toUpperCase());
                ++i;
            }
            themeDef = themeDef.substring(idx2 + 1);
            idx = themeDef.indexOf("STYLE=\"");
        }
        idx = themeDef.indexOf("<RENDERING");
        if (idx > 0) {
            idx = themeDef.indexOf("<STYLE NAME=\"");
            while (idx > 0) {
                idx2 = themeDef.indexOf("\"", idx + 14);
                style = themeDef.substring(idx + 13, idx2);
                if (style != null && style.length() > 0 && style.indexOf(":") < 0) {
                    styleList.put(style.toUpperCase(), style.toUpperCase());
                    ++i;
                }
                themeDef = themeDef.substring(idx2 + 1);
                idx = themeDef.indexOf("<STYLE NAME=\"");
            }
            idx = themeDef.indexOf("<SUBSTYLE NAME=\"");
            while (idx > 0) {
                idx2 = themeDef.indexOf("\"", idx + 17);
                style = themeDef.substring(idx + 16, idx2);
                if (style != null && style.length() > 0 && style.indexOf(":") < 0) {
                    styleList.put(style.toUpperCase(), style.toUpperCase());
                    ++i;
                }
                themeDef = themeDef.substring(idx2 + 1);
                idx = themeDef.indexOf("<SUBSTYLE NAME=\"");
            }
        }
        log.info("" + i + " styles added to list for export.");
    }
}

