/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.MemoryImageSource;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;
import oracle.sdovis.util.Base64InputStream;

public class ImageUtils {
    private static final Component sComponent = new Component(){};
    private static final MediaTracker sTracker = new MediaTracker(sComponent);
    private static int sID = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image image, long ms) {
        int id;
        Component component = sComponent;
        synchronized (component) {
            id = sID++;
        }
        sTracker.addImage(image, id);
        try {
            sTracker.waitForID(id, ms);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(System.err);
            return false;
        }
        return !sTracker.isErrorID(id);
    }

    public static boolean waitForImage(Image image) {
        return ImageUtils.waitForImage(image, 0L);
    }

    public static void removeImageFromTracker(Image img) {
        if (img != null) {
            sTracker.removeImage(img);
        }
    }

    public static Image blockingLoad(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static Image blockingLoad(byte[] imgArray) {
        try {
            return ImageIO.read(new ByteArrayInputStream(imgArray));
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static BufferedImage makeBufferedImage(Image image) {
        return ImageUtils.makeBufferedImage(image, 1);
    }

    public static BufferedImage makeBufferedImage(Image image, int imageType) {
        if (!ImageUtils.waitForImage(image)) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), imageType);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, null, null);
        return bufferedImage;
    }

    public static int[] grabPixels(Image img, int w, int h) {
        BufferedImage bimg = (BufferedImage)img;
        DataBuffer buff = bimg.getRaster().getDataBuffer();
        DataBufferInt bi = (DataBufferInt)buff;
        int[] pixels = bi.getData();
        return Arrays.copyOf(pixels, pixels.length);
    }

    public static void sizeContainerToComponent(Container container, Component component) {
        if (!container.isDisplayable()) {
            container.addNotify();
        }
        Insets insets = container.getInsets();
        Dimension size = component.getPreferredSize();
        int width = insets.left + insets.right + size.width;
        int height = insets.top + insets.bottom + size.height;
        container.setSize(width, height);
    }

    public static Image loadFromBase64(String b64) {
        try {
            Base64InputStream in = new Base64InputStream(new ByteArrayInputStream(b64.getBytes()));
            byte[] big = new byte[65535];
            int size = in.read(big);
            if (size <= 0) {
                return null;
            }
            byte[] real = new byte[size];
            System.arraycopy(big, 0, real, 0, size);
            return ImageIO.read(new ByteArrayInputStream(real));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage duplicateBufferedImage(BufferedImage source, int w, int h) {
        ColorModel cm = source.getColorModel();
        int[] imageData = ImageUtils.grabPixels(source, w, h);
        MemoryImageSource imageSource = new MemoryImageSource(w, h, cm, imageData, 0, w);
        SampleModel sm = cm.createCompatibleSampleModel(w, h);
        DataBufferInt data = new DataBufferInt(imageData, w * h);
        WritableRaster raster = WritableRaster.createWritableRaster(sm, data, new Point(0, 0));
        return new BufferedImage(cm, raster, false, null);
    }

    public static void main(String[] args) {
        String url = "http://localhost:7777/mapviewer/images/omsmap601.png";
        BufferedImage img = new BufferedImage(640, 460, 2);
        Graphics2D g = (Graphics2D)((Image)img).getGraphics();
        g.drawLine(0, 0, 400, 400);
        g.dispose();
        ImageUtils.removeImageFromTracker(null);
    }
}

