/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;

public abstract class DBTable {
    protected String mTableName = null;
    protected PreparedStatement mDeleteStatement = null;
    protected PreparedStatement mInsertStatement = null;
    protected PreparedStatement mUpdateStatement = null;
    protected Connection mConnection = null;
    protected String mDataSource = null;
    protected Statement mStatement = null;
    protected ResultSet mResultSet = null;
    protected String mUser = null;
    protected String mDBtypename = null;

    public DBTable(String dataSrc, String tableName) {
        this.mDataSource = dataSrc;
        this.mTableName = tableName;
        try {
            DBDataSource ds = (DBDataSource)DSManager.get(dataSrc);
            this.mDBtypename = DSManager.getDataSourceType(dataSrc);
            Connection con = ds.getConnection();
            DatabaseMetaData meta = con.getMetaData();
            this.mUser = meta.getUserName().toUpperCase();
            con.close();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot get user name.");
        }
    }

    public String getDatabaseType() {
        return this.mDBtypename;
    }

    public int getId() throws SQLException {
        return 0;
    }

    public abstract int update() throws SQLException;

    public abstract int insert() throws SQLException;

    public abstract int delete() throws SQLException;

    public String getTableName() {
        return this.mTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryCount(String staticQuery) throws SQLException {
        try (Connection con = null;){
            DBDataSource ds = (DBDataSource)DSManager.get(this.mDataSource);
            con = ds.getConnection();
            Statement s = con.createStatement();
            ResultSet r = s.executeQuery(staticQuery);
            int count = 0;
            if (r.next()) {
                count = r.getInt(1);
            }
            s.close();
            int n = count;
            return n;
        }
    }

    public int queryCount() throws SQLException {
        return this.queryCount("select count(0) from " + this.getTableName());
    }

    public void query(String staticQuery) throws SQLException {
        DBDataSource ds = (DBDataSource)DSManager.get(this.mDataSource);
        this.mConnection = ds.getConnection();
        this.mStatement = this.mConnection.createStatement();
        this.mResultSet = this.mStatement.executeQuery(staticQuery);
    }

    public void query() throws SQLException {
        DBDataSource ds = (DBDataSource)DSManager.get(this.mDataSource);
        this.mConnection = ds.getConnection();
        this.mStatement = this.mConnection.createStatement();
        this.mResultSet = this.mStatement.executeQuery("select * from " + this.getTableName());
    }

    public void query(PreparedStatement statement) throws SQLException {
        this.mResultSet = statement.executeQuery();
    }

    public void queryID(String idColum, long id) throws SQLException {
        DBDataSource ds = (DBDataSource)DSManager.get(this.mDataSource);
        this.mConnection = ds.getConnection();
        this.mStatement = this.mConnection.createStatement();
        this.mResultSet = this.mStatement.executeQuery("select * from " + this.getTableName() + " where " + idColum + "=" + id);
    }

    public void closeQuery() throws SQLException {
        try {
            if (this.mStatement != null) {
                this.mStatement.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.mStatement = null;
        try {
            if (this.mResultSet != null) {
                this.mResultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mResultSet = null;
        if (this.mConnection != null) {
            this.mConnection.close();
        }
        this.mConnection = null;
    }

    public boolean next() throws SQLException {
        boolean retval = this.mResultSet.next();
        if (retval) {
            this.updateLocalData();
        }
        return retval;
    }

    public void truncate() throws SQLException {
        DBDataSource ds = (DBDataSource)DSManager.get(this.mDataSource);
        this.mConnection = ds.getConnection();
        Statement s = this.mConnection.createStatement();
        s.executeUpdate("truncate table " + this.getTableName());
        s.close();
        this.mConnection.close();
        this.mConnection = null;
    }

    public void close() throws SQLException {
        if (this.mDeleteStatement != null) {
            this.mDeleteStatement.close();
        }
        if (this.mInsertStatement != null) {
            this.mInsertStatement.close();
        }
        if (this.mUpdateStatement != null) {
            this.mUpdateStatement.close();
        }
        this.mDeleteStatement = null;
        this.mInsertStatement = null;
        this.mUpdateStatement = null;
        this.closeQuery();
    }

    protected boolean checkYesNo(String s) {
        return s != null && s.equals("YES");
    }

    protected abstract void initDeleteStatement() throws SQLException;

    protected abstract void initInsertStatement() throws SQLException;

    protected abstract void initUpdateStatement() throws SQLException;

    protected abstract void updateLocalData() throws SQLException;
}

