/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.TextPath;
import oracle.sdovis.util.BestFitInfo;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.ShapeUtil;

public class BestFitText {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static final FontRenderContext frc = new FontRenderContext(null, true, false);

    public Shape putTextOnBestFitLine(TextPath tp, Graphics2D g2, Shape shp, String text, double textLen, RectArray crRects, boolean forcedLabeling, boolean labelOnlyOnce, boolean upsideDownLabels) {
        TextStyleModel bean;
        Font f;
        boolean foundPlace = false;
        GeneralPath gp = new GeneralPath();
        CandidateRuns1[] crs = this.getCandidates(shp, textLen, tp);
        block0: for (int i = 0; !(i >= crs.length || foundPlace && labelOnlyOnce); ++i) {
            CandidateRuns1 cr = crs[i];
            if (cr.size <= 1 || cr.len < textLen) continue;
            int pidx = -1;
            for (int j = 0; j < 3; ++j) {
                int idx = cr.indexes[j];
                if (idx < 0 || idx == pidx) continue;
                Shape s = this.putTextOnBestFitLine(tp, g2, cr.x, cr.y, idx, cr.numPoints[j], text, crRects, forcedLabeling, upsideDownLabels);
                if (s != null) {
                    gp.append(s, false);
                    foundPlace = true;
                    continue block0;
                }
                pidx = idx;
            }
        }
        if (foundPlace || !forcedLabeling) {
            return gp;
        }
        Rectangle2D mbr = shp.getBounds2D();
        int cx = (int)mbr.getCenterX();
        int cy = (int)mbr.getCenterY();
        double[] endPts = ShapeUtil.getEndPoints(shp);
        double angle = 0.0;
        if (endPts != null) {
            if (!upsideDownLabels && endPts[2] < endPts[0]) {
                double x = endPts[0];
                double y = endPts[1];
                endPts[0] = endPts[2];
                endPts[1] = endPts[3];
                endPts[2] = x;
                endPts[3] = y;
            }
            angle = Math.atan2(endPts[3] - endPts[1], endPts[2] - endPts[0]);
        }
        if ((f = (bean = tp.getBean()).getFont()) != null && tp.getTextStyleModifiers() != null) {
            f = new Font(f.getFamily(), f.getStyle(), tp.getTextStyleModifiers().getFontSize());
        }
        GlyphVectorInfo gvinfo = new GlyphVectorInfo();
        gvinfo.txt = text;
        GlyphVector glyphVector = f.createGlyphVector(frc, text);
        glyphVector.performDefaultLayout();
        gvinfo.visualBounds = glyphVector.getVisualBounds();
        gvinfo.avgGW = gvinfo.visualBounds.getWidth() / (double)glyphVector.getNumGlyphs();
        gvinfo.visualCenterY = gvinfo.visualBounds.getCenterY();
        Point2D np = glyphVector.getGlyphPosition(0);
        gvinfo.ngx = np.getX();
        gvinfo.ngy = np.getY();
        Object hint = bean.getLabelingHint(LabelingHints.KEY_LINE_VALIGN);
        if (hint == null) {
            hint = LabelingHints.VALUE_LINE_VALIGN_BASELINE;
        }
        double[] offset = this.getGlyphOffset(gvinfo, 0.0, hint);
        return StyleText.getLayout(g2, text, cx, cy, LabelingHints.VALUE_OPOINT_HALIGN_CENTER, angle, (int)offset[1], bean, tp.getTextStyleModifiers());
    }

    private double[] getGlyphOffset(GlyphVectorInfo gvinfo, double rotationAngle, Object hint) {
        double gXOffset = 0.0;
        double gYOffset = 0.0;
        if (hint == LabelingHints.VALUE_LINE_VALIGN_MIDDLE) {
            gXOffset = 0.0;
            gYOffset = 0.0;
        } else if (hint == LabelingHints.VALUE_LINE_VALIGN_BASELINE) {
            double offset = gvinfo.visualCenterY - gvinfo.ngy;
            gXOffset = -offset * Math.sin(rotationAngle);
            gYOffset = offset * Math.cos(rotationAngle);
        } else if (hint == LabelingHints.VALUE_LINE_VALIGN_BOTTOM) {
            double offset = gvinfo.visualBounds.getHeight() / 2.0 + 1.0;
            gXOffset = offset * Math.sin(rotationAngle);
            gYOffset = -offset * Math.cos(rotationAngle);
        } else if (hint == LabelingHints.VALUE_LINE_VALIGN_TOP) {
            double offset = gvinfo.visualBounds.getHeight() / 2.0 + 1.0;
            gXOffset = -offset * Math.sin(rotationAngle);
            gYOffset = offset * Math.cos(rotationAngle);
        }
        return new double[]{gXOffset, gYOffset};
    }

    public Shape putTextOnBestFitLine(TextPath tp, Graphics g2d, float[] x_, float[] y_, int index, int numPoints, String text, RectArray crRects, boolean forcedLabeling, boolean upsideDownLabels) {
        double tol = 5.0;
        TextStyleModel bean = tp.getBean();
        Font font = bean.getFont();
        if (tp.getTextStyleModifiers() != null) {
            font = new Font(bean.getFont().getFamily(), bean.getFont().getStyle(), tp.getTextStyleModifiers().getFontSize());
        }
        FontRenderContext frc = tp.getFrc();
        GlyphVector glyphVector = font.createGlyphVector(frc, text);
        glyphVector.performDefaultLayout();
        Rectangle2D visualBounds = glyphVector.getVisualBounds();
        double visualCenterY = visualBounds.getCenterY();
        Point2D np = glyphVector.getGlyphPosition(0);
        bean.setLabelingHint(LabelingHints.KEY_LINE_HALIGN, LabelingHints.VALUE_LINE_HALIGN_CENTER);
        tp.setBean(bean);
        float[] x = new float[numPoints];
        float[] y = new float[numPoints];
        int ic = index;
        for (int ci = 0; ci < numPoints; ++ci) {
            x[ci] = x_[ic];
            y[ci] = y_[ic];
            ++ic;
        }
        Vector<Integer> indcs = new Vector<Integer>();
        boolean singleseg = false;
        double textlen = visualBounds.getWidth();
        Shape s = null;
        for (int in = 0; in < x.length; ++in) {
            Vector stats = this.getLongestSegment(x, y, indcs);
            int longestidx = (Integer)stats.elementAt(0);
            double seglen = (Double)stats.elementAt(1);
            if (seglen + 2.0 * tol >= visualBounds.getWidth()) {
                float[] newx0 = new float[]{x[longestidx], x[longestidx + 1]};
                float[] newy0 = new float[]{y[longestidx], y[longestidx + 1]};
                float[] mp = this.calcMidPoint(newx0, newy0);
                double a = (double)(newy0[1] - newy0[0]) / seglen * (textlen / 2.0);
                double b = (double)(newx0[1] - newx0[0]) / seglen * (textlen / 2.0);
                float[] newx = new float[]{(float)((double)mp[0] - b), (float)((double)mp[0] + b)};
                float[] newy = new float[]{(float)((double)mp[1] - a), (float)((double)mp[1] + a)};
                boolean conflict = crRects.conflicts(newx[0], newy[0], newx[1] - newx[0] + 1.0f, newy[1] - newy[0] + 1.0f);
                if (!conflict) {
                    singleseg = true;
                    s = this.placeText(newx, newy, text, bean, g2d, tp.getTextStyleModifiers(), upsideDownLabels);
                    break;
                }
            }
            indcs.addElement(new Integer(longestidx));
        }
        if (!singleseg) {
            int pid = 0;
            double[] sigX = new double[x.length];
            double[] sigY = new double[y.length];
            for (int xs = 0; xs < sigX.length; ++xs) {
                sigX[xs] = 1.0;
                sigY[xs] = 1.0;
            }
            Hashtable h = new Hashtable();
            double[] fitline = this.lsfit(x, y, sigX, sigY, x.length);
            double slope = fitline[1];
            double intercept = fitline[0];
            float y0 = (float)(slope * (double)x[0] + intercept);
            float y1 = (float)(slope * (double)x[x.length - 1] + intercept);
            Line2D.Float ln = new Line2D.Float(x[0], y0, x[x.length - 1], y1);
            Vector<BestFitInfo> v = new Vector<BestFitInfo>();
            double[] angles = this.getAngles(x, y);
            BestFitInfo pr = new BestFitInfo(pid, x, y, angles, ln);
            double diff = Math.abs(Math.toDegrees(pr.avg_angle) - 180.0);
            v.addElement(pr);
            Vector<BestFitInfo> prv = new Vector<BestFitInfo>();
            prv.addElement(pr);
            h.put(new Double(diff), prv);
            while (v.size() > 0) {
                Vector<BestFitInfo> prev;
                Double cd;
                double cur_diff;
                double cur_avg_angle;
                int ai;
                int si;
                BestFitInfo nextgroup = (BestFitInfo)v.elementAt(0);
                float[] xn = nextgroup.x;
                float[] yn = nextgroup.y;
                double[] an = nextgroup.angles;
                int pidn = nextgroup.id;
                int sepidx = 0;
                sepidx = this.getWorstAnglePt(an);
                float[] xa = new float[sepidx + 1];
                float[] ya = new float[sepidx + 1];
                double[] aa = new double[sepidx - 1];
                int cumidx = 0;
                for (si = 0; si <= sepidx; ++si) {
                    xa[si] = xn[cumidx];
                    ya[si] = yn[cumidx];
                    ++cumidx;
                }
                int cumai = 0;
                for (ai = 0; ai < aa.length; ++ai) {
                    aa[ai] = an[cumai];
                    ++cumai;
                }
                ++cumai;
                float[] xb = new float[xn.length - sepidx];
                float[] yb = new float[yn.length - sepidx];
                double[] ab = new double[xn.length - sepidx - 2];
                cumidx = sepidx;
                for (si = 0; si < xb.length; ++si) {
                    xb[si] = xn[cumidx];
                    yb[si] = yn[cumidx];
                    ++cumidx;
                }
                ai = 0;
                while (cumai < an.length) {
                    ab[ai] = an[cumai];
                    ++ai;
                    ++cumai;
                }
                float y0a = 0.0f;
                float y1a = 0.0f;
                double slpa = 0.0;
                double intcpa = 0.0;
                if (xa.length > 2) {
                    if (text.trim().toUpperCase().compareTo("HOSMER ST") == 0) {
                        System.out.println("lsfit a");
                    }
                    double[] ftlna = this.lsfit(xa, ya, sigX, sigY, xa.length);
                    slpa = ftlna[1];
                    intcpa = ftlna[0];
                    y0a = (float)(slpa * (double)xa[0] + intcpa);
                    y1a = (float)(slpa * (double)xa[xa.length - 1] + intcpa);
                } else {
                    y0a = ya[0];
                    y1a = ya[1];
                    slpa = (y1a - y0a) / (xa[0] - xa[1]);
                    intcpa = (double)y0a - slpa * (double)xa[0];
                }
                Line2D.Float lna = new Line2D.Float(xa[0], y0a, xa[xa.length - 1], y1a);
                double vara = this.calcVariance(xa, ya, lna, slpa, intcpa);
                float y0b = 0.0f;
                float y1b = 0.0f;
                double slpb = 0.0;
                double intcpb = 0.0;
                if (xb.length > 2) {
                    if (text.trim().toUpperCase().compareTo("HOSMER ST") == 0) {
                        System.out.println("lsfit b");
                    }
                    double[] ftlnb = this.lsfit(xb, yb, sigX, sigY, xb.length);
                    slpb = ftlnb[1];
                    intcpb = ftlnb[0];
                    y0b = (float)(slpb * (double)xb[0] + intcpb);
                    y1b = (float)(slpb * (double)xb[xb.length - 1] + intcpb);
                } else {
                    y0b = yb[0];
                    y1b = yb[1];
                    slpb = (y1b - y0b) / (xb[0] - xb[xb.length - 1]);
                    intcpb = (double)y0b - slpb * (double)xb[0];
                }
                Line2D.Float lnb = new Line2D.Float(xb[0], y0b, xb[xb.length - 1], y1b);
                double varb = this.calcVariance(xb, yb, lnb, slpb, intcpb);
                v.removeElementAt(0);
                double lena = this.calcLen(xa[0], y0a, xa[xa.length - 1], y1a);
                double lenb = this.calcLen(xb[0], y0b, xb[xb.length - 1], y1b);
                if (lena + 2.0 * tol >= visualBounds.getWidth()) {
                    BestFitInfo pa = new BestFitInfo(++pid, xa, ya, aa, lna);
                    v.addElement(pa);
                    cur_avg_angle = pa.avg_angle;
                    cur_diff = Math.abs(Math.toDegrees(cur_avg_angle) - 180.0);
                    cd = new Double(cur_diff);
                    prev = (Vector<BestFitInfo>)h.get(cd);
                    if (prev != null) {
                        prev.addElement(pa);
                        h.put(cd, prev);
                    } else {
                        prev = new Vector<BestFitInfo>();
                        prev.addElement(pa);
                        h.put(cd, prev);
                    }
                }
                if (!(lenb + 2.0 * tol >= visualBounds.getWidth())) continue;
                BestFitInfo pb = new BestFitInfo(++pid, xb, yb, ab, lnb);
                v.addElement(pb);
                cur_avg_angle = pb.avg_angle;
                cur_diff = Math.abs(Math.toDegrees(cur_avg_angle) - 180.0);
                cd = new Double(cur_diff);
                prev = (Vector<BestFitInfo>)h.get(cd);
                if (prev != null) {
                    prev.addElement(pb);
                    h.put(cd, prev);
                    continue;
                }
                prev = new Vector<BestFitInfo>();
                prev.addElement(pb);
                h.put(cd, prev);
            }
            boolean conflict = true;
            while (h.size() != 0) {
                Enumeration keys = h.keys();
                double min = (Double)keys.nextElement();
                while (keys.hasMoreElements()) {
                    double nextval = (Double)keys.nextElement();
                    if (!(nextval < min)) continue;
                    min = nextval;
                }
                Double mind = new Double(min);
                Vector optv = (Vector)h.get(mind);
                for (int iv = 0; iv < optv.size(); ++iv) {
                    BestFitInfo optimal = (BestFitInfo)optv.elementAt(iv);
                    Line2D.Float optln = optimal.line;
                    float[] optx0 = new float[]{(float)optln.getX1(), (float)optln.getX2()};
                    float[] opty0 = new float[]{(float)optln.getY1(), (float)optln.getY2()};
                    float[] mp = this.calcMidPoint(optx0, opty0);
                    double lnlen = this.calcLen(optx0[0], opty0[0], optx0[1], opty0[1]);
                    double a = (double)(opty0[1] - opty0[0]) / lnlen * (textlen / 2.0);
                    double b = (double)(optx0[1] - optx0[0]) / lnlen * (textlen / 2.0);
                    float[] optx = new float[]{(float)((double)mp[0] - b), (float)((double)mp[0] + b)};
                    float[] opty = new float[]{(float)((double)mp[1] - a), (float)((double)mp[1] + a)};
                    conflict = crRects.conflicts(optx[0], opty[0], optx[1] - optx[0] + 1.0f, opty[1] - opty[0] + 1.0f);
                    if (conflict) continue;
                    s = this.placeText(optx, opty, text, bean, g2d, tp.getTextStyleModifiers(), upsideDownLabels);
                    break;
                }
                if (!conflict) break;
                h.remove(mind);
            }
        }
        return s;
    }

    public void drawStreet(float[] x, float[] y, Graphics g2d) {
        g2d.setColor(Color.yellow);
        for (int i = 0; i < x.length - 1; ++i) {
            g2d.drawLine((int)x[i], (int)y[i], (int)x[i + 1], (int)y[i + 1]);
        }
    }

    public double[] lsfit(float[] x, float[] y, double[] sigmaX, double[] sigmaY, int numPoints) {
        double[] parameters = new double[4];
        double s = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        double sxx = 0.0;
        double sxy = 0.0;
        if (sigmaY != null) {
            for (int i = 0; i < numPoints; ++i) {
                s += 1.0 / (sigmaY[i] * sigmaY[i]);
                sx += (double)x[i] / (sigmaY[i] * sigmaY[i]);
                sy += (double)y[i] / (sigmaY[i] * sigmaY[i]);
                sxx += (double)(x[i] * x[i]) / (sigmaY[i] * sigmaY[i]);
                sxy += (double)(x[i] * y[i]) / (sigmaY[i] * sigmaY[i]);
            }
        } else {
            s = x.length;
            for (int i = 0; i < numPoints; ++i) {
                sx += (double)x[i];
                sy += (double)y[i];
                sxx += (double)(x[i] * x[i]);
                sxy += (double)(x[i] * y[i]);
            }
        }
        double del = s * sxx - sx * sx;
        parameters[0] = (sxx * sy - sx * sxy) / del;
        parameters[1] = (s * sxy - sx * sy) / del;
        parameters[2] = sxx / del;
        parameters[3] = s / del;
        return parameters;
    }

    public double calcVariance(float[] x, float[] y, Line2D.Float ln, double slope, double intcp) {
        double sum = 0.0;
        for (int i = 0; i < y.length; ++i) {
            double yln = slope * (double)x[i] + intcp;
            sum += Math.pow((double)y[i] - yln, 2.0) / (double)(y.length - 2);
        }
        return sum;
    }

    public int getWorstAnglePt(double[] angles) {
        double elim_angle = angles[0];
        double elim_diff = Math.abs(Math.toDegrees(angles[0]) - 180.0);
        int idx = 0;
        for (int i = 1; i < angles.length; ++i) {
            double diff = Math.abs(Math.toDegrees(angles[i]) - 180.0);
            if (!(diff > elim_diff)) continue;
            elim_diff = diff;
            idx = i;
        }
        return idx + 1;
    }

    public double[] getAngles(float[] x, float[] y) {
        double[] angles = new double[x.length - 2];
        for (int i = 0; i < x.length - 2; ++i) {
            double x0 = x[i];
            double x1 = x[i + 1];
            double x2 = x[i + 2];
            double y0 = y[i];
            double y1 = y[i + 1];
            double y2 = y[i + 2];
            Vector2d va = new Vector2d(x1 - x0, y1 - y0);
            Vector2d vb = new Vector2d(x2 - x1, y2 - y1);
            angles[i] = va.angle(vb);
        }
        return angles;
    }

    public double calcLen(float x0, float y0, float x1, float y1) {
        double len = Math.sqrt(Math.pow(Math.abs(x1 - x0), 2.0) + Math.pow(Math.abs(y1 - y0), 2.0));
        return len;
    }

    public Vector getLongestSegment(float[] x, float[] y, Vector indcs) {
        double maxlen = 0.0;
        int maxidx = 0;
        for (int i = 0; i < x.length - 1; ++i) {
            float x0 = x[i];
            float y0 = y[i];
            float x1 = x[i + 1];
            float y1 = y[i + 1];
            double len = this.calcLen(x0, y0, x1, y1);
            if (!(len > maxlen)) continue;
            boolean pass = false;
            for (int j = 0; j < indcs.size(); ++j) {
                if (i != (Integer)indcs.elementAt(j)) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            maxlen = len;
            maxidx = i;
        }
        Vector<Number> results = new Vector<Number>();
        results.addElement(new Integer(maxidx));
        results.addElement(new Double(maxlen));
        return results;
    }

    public float[] calcMidPoint(float[] x, float[] y) {
        float[] mp = new float[]{(x[0] + x[1]) / 2.0f, (y[0] + y[1]) / 2.0f};
        return mp;
    }

    private CandidateRuns1[] getCandidates(Shape shp, double textLen, TextPath tp) {
        Vector<CandidateRuns1> v = null;
        PathIterator pi = shp.getPathIterator(null);
        float[] coord = new float[6];
        float mx = 0.0f;
        float my = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        double len = 0.0;
        int count = 0;
        CandidateRuns1 cr = new CandidateRuns1();
        while (!pi.isDone()) {
            switch (pi.currentSegment(coord)) {
                case 0: {
                    mx = coord[0];
                    my = coord[1];
                    if (count == 0) {
                        cr.append(mx, my, textLen, tp);
                        break;
                    }
                    if (mx == x && my == y) break;
                    cr.setStartingIndexes(textLen);
                    if (v == null) {
                        v = new Vector<CandidateRuns1>(1);
                    }
                    v.add(cr);
                    cr = new CandidateRuns1();
                    cr.append(mx, my, textLen, tp);
                    break;
                }
                case 1: {
                    x = coord[0];
                    y = coord[1];
                    cr.append(x, y, textLen, tp);
                }
            }
            ++count;
            pi.next();
        }
        cr.setStartingIndexes(textLen);
        if (v == null) {
            return new CandidateRuns1[]{cr};
        }
        v.add(cr);
        return v.toArray(new CandidateRuns1[v.size()]);
    }

    private Shape placeText(float[] x, float[] y, String text, TextStyleModel bean, Graphics g2d, StyleModifiers stymods, boolean upsideDownLabels) {
        Shape s = null;
        float x1 = x[0];
        float y1 = y[0];
        float x2 = x[1];
        float y2 = y[1];
        if (!upsideDownLabels && x1 > x2) {
            x1 = x[1];
            y1 = y[1];
            x2 = x[0];
            y2 = y[0];
        }
        if (null != (s = StyleText.getStringOutline(text, bean, stymods))) {
            double rotation = Math.atan2(y2 - y1, x2 - x1);
            s = AffineTransform.getRotateInstance(rotation).createTransformedShape(s);
            s = AffineTransform.getTranslateInstance(x1, y1).createTransformedShape(s);
        }
        return s;
    }

    class CandidateRuns1 {
        float[] x;
        float[] y;
        int[] indexes = new int[3];
        int[] numPoints;
        int size;
        double len;

        public CandidateRuns1() {
            this.indexes[0] = -1;
            this.indexes[1] = -1;
            this.indexes[2] = 0;
            this.numPoints = new int[3];
            this.numPoints[0] = 0;
            this.numPoints[1] = 0;
            this.numPoints[2] = 0;
            this.size = 0;
        }

        public CandidateRuns1(int numPoints) {
            this();
            this.x = new float[numPoints];
            this.y = new float[numPoints];
        }

        public void append(float _x, float _y, double textLen, TextPath tp) {
            double ascent = tp.getAscent();
            if (this.size >= 1) {
                double dist = Point2D.distance(this.x[this.size - 1], this.y[this.size - 1], _x, _y);
                if (dist < ascent * 0.5) {
                    this.x[this.size - 1] = _x;
                    this.y[this.size - 1] = _y;
                    return;
                }
                if (dist > textLen) {
                    double dx = (double)(_x - this.x[this.size - 1]) / dist;
                    double dy = (double)(_y - this.y[this.size - 1]) / dist;
                    double off = (dist - textLen) / 2.0;
                    float mx = (float)((double)this.x[this.size - 1] + dx * (off - 2.0));
                    float my = (float)((double)this.y[this.size - 1] + dy * (off - 2.0));
                    this.ensureCapacity(this.size + 1, tp.getGROW_SIZE());
                    this.indexes[0] = this.size;
                    this.numPoints[0] = 2;
                    this.x[this.size] = mx;
                    this.y[this.size++] = my;
                }
            }
            this.ensureCapacity(this.size + 1, tp.getGROW_SIZE());
            this.x[this.size] = _x;
            this.y[this.size++] = _y;
        }

        public double getLength() {
            if (this.size == 0) {
                return 0.0;
            }
            this.len = 0.0;
            float x1 = this.x[0];
            float y1 = this.y[0];
            float x2 = 0.0f;
            float y2 = 0.0f;
            for (int i = 1; i < this.size; ++i) {
                x2 = this.x[i];
                y2 = this.y[i];
                this.len += Point2D.distance(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
            return this.len;
        }

        public void ensureCapacity(int n, int growSize) {
            if (this.x != null && this.x.length > n) {
                return;
            }
            float[] t = new float[n + growSize];
            if (this.x != null) {
                System.arraycopy(this.x, 0, t, 0, this.size);
            }
            this.x = t;
            t = new float[n + growSize];
            if (this.y != null) {
                System.arraycopy(this.y, 0, t, 0, this.size);
            }
            this.y = t;
        }

        public void setStartingIndexes(double textLen) {
            if (this.x == null || this.y == null) {
                this.indexes[1] = -1;
                return;
            }
            if (this.len <= 0.0) {
                this.getLength();
            }
            if (this.len < textLen) {
                this.indexes[1] = -1;
                return;
            }
            double off = (this.len - textLen) / 2.0;
            this.indexes[1] = this.findStartVertexForOffset(off);
            this.numPoints[1] = this.findEndVertexForOffset(off + textLen) - this.indexes[1] + 1;
            this.numPoints[2] = this.findEndVertexForOffset(textLen) + 1;
        }

        private int findStartVertexForOffset(double off) {
            if (this.x == null || this.y == null) {
                return -1;
            }
            double alen = 0.0;
            float x1 = this.x[0];
            float y1 = this.y[0];
            float x2 = 0.0f;
            float y2 = 0.0f;
            for (int i = 1; i < this.size; ++i) {
                x2 = this.x[i];
                y2 = this.y[i];
                if ((alen += Point2D.distance(x1, y1, x2, y2)) > off) {
                    return i - 1;
                }
                if (alen == off) {
                    return i;
                }
                x1 = x2;
                y1 = y2;
            }
            return -1;
        }

        private int findEndVertexForOffset(double off) {
            double alen = 0.0;
            float x1 = this.x[0];
            float y1 = this.y[0];
            float x2 = 0.0f;
            float y2 = 0.0f;
            for (int i = 1; i < this.size; ++i) {
                x2 = this.x[i];
                y2 = this.y[i];
                if ((alen += Point2D.distance(x1, y1, x2, y2)) >= off) {
                    return i;
                }
                x1 = x2;
                y1 = y2;
            }
            return this.size - 1;
        }
    }

    class GlyphVectorInfo {
        String txt = null;
        Rectangle2D visualBounds;
        double visualCenterY = 0.0;
        int ngi;
        double ngx;
        double ngy;
        double avgGW;

        GlyphVectorInfo() {
        }
    }
}

