/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.URLEncoder;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.mapviewer.share.OMSException;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.sdovis.DataException;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.WMTSTheme;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.WMTSThemeDefinition;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;

public class WMTSThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent wmtsSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "WMTS", "Producer", "Time spent preparing data");
    protected Theme owner;
    private WMTSThemeDefinition def;
    private byte[][] images;
    private double[][] mbrs;
    private boolean isErrorImage = false;
    private double denom = 0.0;
    private int tileW = 0;
    private int tileH = 0;
    private int tileLevel = -1;
    private double tileMtrxMinX = 0.0;
    private double tileMtrxMaxY = 0.0;
    private long matrixWidth = 0L;
    private long matrixHeight = 0L;
    private double pixelSpan = 0.0;
    private double tileSpanX = 0.0;
    private double tileSpanY = 0.0;
    private double tileMtrxMaxX = 0.0;
    private double tileMtrxMinY = 0.0;
    private double mapScale = -1.0;
    private double metersPerUnit = 1.0;

    public WMTSThemeProducer(Theme t) {
        this.owner = t;
        this.def = (WMTSThemeDefinition)t.getDefinition();
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    @Override
    public int size() {
        return this.images == null ? 0 : this.images.length;
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
    }

    @Override
    public void postPreparation(VisContext vc) {
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        return null;
    }

    @Override
    public double[] getDataMBR() {
        if (this.mbrs == null || this.mbrs.length == 0) {
            return null;
        }
        RectangularShape r2d = null;
        for (int i = 0; i < this.mbrs.length; ++i) {
            double[] mbr = this.mbrs[i];
            if (r2d == null) {
                r2d = new Rectangle2D.Double(mbr[0], mbr[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)r2d).add(mbr[0], mbr[1]);
            }
            ((Rectangle2D)r2d).add(mbr[2], mbr[3]);
        }
        double[] res = new double[]{r2d.getMinX(), r2d.getMinY(), r2d.getMaxX(), r2d.getMaxY()};
        return res;
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        return null;
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        return null;
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        return null;
    }

    public byte[][] getImages() {
        return this.images;
    }

    public void setImages(byte[][] imgs) {
        this.images = imgs;
    }

    public double[][] getMBRs() {
        return this.mbrs;
    }

    public void setImageMBRs(double[][] mbrs) {
        this.mbrs = mbrs;
    }

    @Override
    public void destroy() {
        int i;
        if (this.images != null) {
            for (i = 0; i < this.images.length; ++i) {
                this.images[i] = null;
            }
        }
        if (this.mbrs != null) {
            for (i = 0; i < this.mbrs.length; ++i) {
                this.mbrs[i] = null;
            }
        }
        this.images = null;
        this.mbrs = null;
    }

    @Override
    public void abort() {
    }

    private String buildURL_KVP(int level, long tileC, long tileR) {
        StringBuffer sb = new StringBuffer(1024);
        String theVersion = this.def.getWmtsVersion();
        sb.append("SERVICE=WMTS");
        sb.append("&REQUEST=GetTile");
        sb.append("&VERSION=" + theVersion);
        sb.append("&LAYER=" + this.def.getLayer());
        if (this.def.getStyle() != null) {
            sb.append("&STYLE=" + this.def.getStyle());
        } else {
            sb.append("&STYLE=default");
        }
        sb.append("&format=" + this.def.getFormat());
        if (this.def.getDimIDs() != null && this.def.getDimValues() != null) {
            String[] dimIDs = this.def.getDimIDs();
            String[] dimVals = this.def.getDimValues();
            for (int i = 0; i < dimIDs.length; ++i) {
                sb.append("&" + dimIDs[i] + "=" + dimVals[i]);
            }
        }
        sb.append("&TileMatrixSet=" + this.def.getTileMatrixSetID());
        sb.append("&TileMatrix=" + this.def.getTileMatrixID(level));
        sb.append("&TileRow=" + tileR);
        sb.append("&TileCol=" + tileC);
        String s = sb.toString();
        if (((WMTSTheme)this.owner).getUseURLEncoding()) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (Exception e) {
                log.severe(e.getMessage());
                return s;
            }
        }
        return s;
    }

    private String buildURL_REST(int level, long tileC, long tileR) {
        String strURL = this.def.getTileTemplateURL();
        strURL = strURL.replace("{Style}", this.def.getStyle());
        strURL = strURL.replace("{TileMatrixSet}", this.def.getTileMatrixSetID());
        strURL = strURL.replace("{TileMatrix}", this.def.getTileMatrixID(level));
        strURL = strURL.replace("{TileRow}", Long.toString(tileR));
        strURL = strURL.replace("{TileCol}", Long.toString(tileC));
        if (this.def.getDimIDs() != null && this.def.getDimValues() != null) {
            block2: while (strURL.indexOf(123) >= 0 && strURL.indexOf(125) >= 0) {
                int startp = strURL.indexOf(123);
                int endp = strURL.indexOf(125);
                String curTemplate = strURL.substring(startp + 1, endp);
                String[] dimIDs = this.def.getDimIDs();
                String[] dimVals = this.def.getDimValues();
                for (int i = 0; i < dimIDs.length; ++i) {
                    if (!dimIDs[i].equalsIgnoreCase(curTemplate)) continue;
                    strURL = strURL.replace("{" + curTemplate + "}", dimVals[i]);
                    continue block2;
                }
            }
        }
        String s = strURL;
        if (((WMTSTheme)this.owner).getUseURLEncoding()) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (Exception e) {
                log.severe(e.getMessage());
                return s;
            }
        }
        return s;
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return null;
    }

    public boolean isErrorImage() {
        return this.isErrorImage;
    }

    private double[] getTileMBR(int level, long tileC, long tileR) {
        double[] mbr = new double[4];
        double xl = this.tileMtrxMinX + (double)tileC * this.tileSpanX;
        double yl = this.tileMtrxMaxY - (double)(tileR + 1L) * this.tileSpanY;
        mbr[0] = xl;
        mbr[1] = yl;
        mbr[2] = xl + this.tileSpanX;
        mbr[3] = yl + this.tileSpanY;
        return mbr;
    }

    private long calcTiles(int level, long[] tiles, double[] win) {
        double xl = win[0];
        double yl = win[1];
        double xh = win[2];
        double yh = win[3];
        double tileCol = (xl - this.tileMtrxMinX) / this.tileSpanX;
        double tileRow = (this.tileMtrxMaxY - yh) / this.tileSpanY;
        if (tileCol > (double)this.def.getTileMatrixDim(level, 0) || tileRow > (double)this.def.getTileMatrixDim(level, 1)) {
            tiles[0] = -1L;
            tiles[1] = -1L;
            tiles[2] = -1L;
            tiles[3] = -1L;
            log.finer("Requested area is out of the service area: smallest Col or Row is larger than the dataset's.");
            return 0L;
        }
        if (this.def.hasTileLimits() && (Math.floor(tileCol) > (double)this.def.getTileMatrixLimitColMax(level) || Math.floor(tileRow) > (double)this.def.getTileMatrixLimitRowMax(level))) {
            tiles[0] = -1L;
            tiles[1] = -1L;
            tiles[2] = -1L;
            tiles[3] = -1L;
            log.info("Requested area is out of the valid service area: the requested smallest Col or Row is larger than the limits.");
            return 0L;
        }
        tiles[0] = (long)Math.floor(tileCol);
        tiles[2] = (long)Math.floor(tileRow);
        if (tiles[0] < 0L) {
            tiles[0] = 0L;
        }
        if (tiles[2] < 0L) {
            tiles[2] = 0L;
        }
        tileCol = (xh - this.tileMtrxMinX) / this.tileSpanX;
        tileRow = (this.tileMtrxMaxY - yl) / this.tileSpanY;
        if (tileCol < 0.0 || tileRow < 0.0) {
            tiles[0] = -1L;
            tiles[1] = -1L;
            tiles[2] = -1L;
            tiles[3] = -1L;
            log.info("Requested area is out of the service area: the requested max Col or Row is smaller than the dataset's.");
            return 0L;
        }
        if (this.def.hasTileLimits() && (Math.ceil(tileCol) < (double)this.def.getTileMatrixLimitColMin(level) || Math.ceil(tileRow) < (double)this.def.getTileMatrixLimitRowMin(level))) {
            tiles[0] = -1L;
            tiles[1] = -1L;
            tiles[2] = -1L;
            tiles[3] = -1L;
            log.info("Requested area is out of the valid service area: the requested max Col or Row is smaller than the limits.");
            return 0L;
        }
        tiles[1] = (long)Math.ceil(tileCol);
        tiles[3] = (long)Math.ceil(tileRow);
        if (tiles[1] > this.def.getTileMatrixDim(level, 0)) {
            tiles[1] = this.def.getTileMatrixDim(level, 0);
        }
        if (tiles[3] > this.def.getTileMatrixDim(level, 1)) {
            tiles[3] = this.def.getTileMatrixDim(level, 1);
        }
        log.finer("Tiles range: column [" + tiles[0] + ", " + (tiles[1] - 1L) + "], row [" + tiles[2] + ", " + (tiles[3] - 1L) + "]");
        return (tiles[1] - tiles[0]) * (tiles[3] - tiles[2]);
    }

    private void setMetersPerUnit(Rectangle2D queryWin) throws Exception {
        SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
        if (sc == null) {
            log.severe("SRSCache instance cannot be retrieved in setMetersPerUnit().");
            return;
        }
        SRS srs = sc.get(this.def.getSrid());
        if (srs == null) {
            log.severe("SRS instance cannot be retrieved in setMetersPerUnit().");
            return;
        }
        String strUnit = srs.getUnit();
        if (this.def.getLowerCorner() != null && this.def.getUpperCorner() != null) {
            try {
                this.metersPerUnit = Util.getWMTSMetersPerUnit(srs);
            }
            catch (Exception e) {
                throw new Exception("Failed to get meters per unit for: " + strUnit);
            }
        }
    }

    private void waitForData(ReadBinaryThread[] threads, int count) {
        long timeout = ((WMTSTheme)this.owner).getRequestTimeout();
        for (int k = 0; k < count; ++k) {
            try {
                threads[k].join(timeout);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private int LoadImageFromWMTSServer(int level, long[] tiles, Boolean isTileRequest) throws DataException {
        Vector<byte[]> _images = new Vector<byte[]>(3);
        Vector<double[]> _mbrs = new Vector<double[]>(3);
        int threadCap = ((WMTSTheme)this.owner).getCurrentThreads();
        byte[][] data = new byte[threadCap][];
        double[][] mbr = new double[threadCap][4];
        String[] urlsuffix = new String[threadCap];
        try {
            String tileURLPrefix = this.def.getGetTileUrlPrefix();
            if (this.def.isKVPEncoding()) {
                if (tileURLPrefix.lastIndexOf(63) > -1) {
                    if (!tileURLPrefix.endsWith("?") && !tileURLPrefix.endsWith("&")) {
                        tileURLPrefix = tileURLPrefix + "&";
                    }
                } else if (!tileURLPrefix.endsWith("&")) {
                    tileURLPrefix = tileURLPrefix + "?";
                }
            }
            int totalCount = 0;
            int count = 0;
            ReadBinaryThread[] threads = new ReadBinaryThread[threadCap];
            for (long curTileCol = tiles[0]; curTileCol < tiles[1]; ++curTileCol) {
                for (long curTileRow = tiles[2]; curTileRow < tiles[3]; ++curTileRow) {
                    if (!this.def.isInsideTileLimits(level, curTileCol, curTileRow)) {
                        log.finest("Tile at level: " + level + ", tile col: " + curTileCol + ", tile row: " + curTileRow + "is outside of TileMatixLimits.");
                        continue;
                    }
                    String reqstr = null;
                    if (this.def.isKVPEncoding()) {
                        urlsuffix[count] = this.buildURL_KVP(level, curTileCol, curTileRow);
                        reqstr = tileURLPrefix + urlsuffix[count];
                    } else {
                        urlsuffix[count] = this.buildURL_REST(level, curTileCol, curTileRow);
                        reqstr = urlsuffix[count];
                    }
                    log.finest("Tile request url: " + reqstr);
                    threads[count] = new ReadBinaryThread(reqstr);
                    threads[count].start();
                    mbr[count] = this.getTileMBR(level, curTileCol, curTileRow);
                    ++totalCount;
                    if (++count != threadCap) continue;
                    this.waitForData(threads, count);
                    for (int k = 0; k < count; ++k) {
                        data[k] = threads[k].getBinaryData();
                        if (data[k] == null) {
                            log.warning("No data received from " + urlsuffix[k]);
                            if (!isTileRequest.booleanValue()) continue;
                            throw new DataException("Failed to read binary data from " + urlsuffix[k]);
                        }
                        _images.add(data[k]);
                        _mbrs.add(mbr[k]);
                        log.finer("Tile: " + urlsuffix[k]);
                        log.finer("Tile MBR: minX " + mbr[k][0] + " maxX " + mbr[k][2] + " minY " + mbr[k][1] + " maxY " + mbr[k][3]);
                    }
                    count = 0;
                }
            }
            if (count > 0) {
                this.waitForData(threads, count);
                for (int k = 0; k < count; ++k) {
                    data[k] = threads[k].getBinaryData();
                    if (data[k] == null) {
                        log.warning("No data received from " + urlsuffix[k]);
                        if (!isTileRequest.booleanValue()) continue;
                        throw new DataException("Failed to read binary data from " + urlsuffix[k]);
                    }
                    _images.add(data[k]);
                    _mbrs.add(mbr[k]);
                    log.finer("Tile: " + urlsuffix[k]);
                    log.finer("Tile MBR: minX " + mbr[k][0] + " maxX " + mbr[k][2] + " minY " + mbr[k][1] + " maxY " + mbr[k][3]);
                }
            }
            if (totalCount > 0) {
                this.images = new byte[_images.size()][];
                this.mbrs = new double[_mbrs.size()][];
                for (int k = 0; k < this.images.length; ++k) {
                    this.images[k] = (byte[])_images.get(k);
                    this.mbrs[k] = (double[])_mbrs.get(k);
                }
                _images.clear();
                _images = null;
                _mbrs.clear();
                _mbrs = null;
                log.finest("[Tiles retrieved] " + this.images.length);
                return this.images.length;
            }
            return 0;
        }
        catch (DataException ee) {
            log.severe(ee.getMessage());
            _images.clear();
            _images = null;
            _mbrs.clear();
            _mbrs = null;
            throw ee;
        }
    }

    private double calcScale(Rectangle2D queryWin, VisContext vc) throws DataException {
        double xl = 0.0;
        double yl = 0.0;
        double xh = 0.0;
        double yh = 0.0;
        double scale = 0.0;
        if (queryWin == null) {
            log.warning("No query window was specified.");
            SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
            SRS srs = sc.get(this.def.getSrid());
            if (srs != null) {
                double masterScale = vc.getCurrentScale();
                return srs.getRatioScale(masterScale, null);
            }
            log.severe("The SRS is null. Failed to calculate the ratio scale.");
            vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01025"));
            throw new DataException("The SRS is null. Failed to calculate the ratio scale.");
        }
        xl = queryWin.getMinX();
        yl = queryWin.getMinY();
        xh = queryWin.getMaxX();
        yh = queryWin.getMaxY();
        double yi = yl;
        double yf = yh;
        if (this.def.getSrid() == 0) {
            String strsrs = this.def.getSupportedSrs();
            this.def.setSRS(strsrs);
        }
        double masterScale = vc.getCurrentScale();
        if (vc.getMasterSRID() == 0) {
            log.severe("Master SRID is not set.");
            throw new DataException("Master SRID is not set.");
        }
        if (this.def.getSrid() != vc.getMasterSRID()) {
            log.severe("Re-projection is not supported. WMTS SRID is [" + this.def.getSrid() + "], but request SRID is [" + vc.getMasterSRID() + "].");
            throw new DataException("Re-projection is not supported. WMTS SRID is [" + this.def.getSrid() + "], but request SRID is [" + vc.getMasterSRID() + "].");
        }
        SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
        SRS srs = sc.get(this.def.getSrid());
        if (srs == null) {
            log.severe("The SRS is null. Failed to calculate the ratio scale.");
            vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01025"));
            return -1.0;
        }
        if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
            double factor = Math.abs(yh - yl) / Math.abs(yf - yi);
            log.finer("[Master scale] " + masterScale + " [Theme scale factor] " + factor);
            scale = masterScale * factor;
            scale = srs.getRatioScale(masterScale, new Point2D.Double(queryWin.getCenterX(), queryWin.getCenterY()));
            if (this.getTheme().getScaleType() == "RATIO") {
                scale = srs.getRatioScale(masterScale, new Point2D.Double(queryWin.getCenterX(), queryWin.getCenterY()));
                log.finer("[Ratio scale] " + scale);
            }
            if (!this.getTheme().withinRenderScaleLimits(scale)) {
                log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                return -1.0;
            }
        }
        return scale;
    }

    private boolean getMetaData() {
        return this.def.getCapabilities() != null || this.def.readCapabilities(this.getTheme().getDecorator().getRequestTimeout()) != false;
    }

    private void rotateWindow(double[] win, VisContext vc) {
        if (MapMaker.isSpecial(win[0], win[1], win[2], win[3]) && vc.getRotation() != 0.0) {
            log.warning("Rotation is currently ignored for full extent.");
        } else if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(win[0], win[1], win[2], win[3])) {
            if (vc.getRotation() < -360.0 || vc.getRotation() > 360.0) {
                log.warning("Rotation value must be in between -360 to 360 degrees. Ignored");
            } else {
                double[] rmbr = Util.rotateMBR(win[0], win[1], win[2], win[3], vc.getRotation());
                if (rmbr != null) {
                    win[0] = Math.min(rmbr[0], win[0]);
                    win[1] = Math.min(rmbr[1], win[1]);
                    win[2] = Math.max(rmbr[2], win[2]);
                    win[3] = Math.max(rmbr[3], win[3]);
                    log.finest("Rotation angle: " + vc.getRotation());
                    log.finest("Search window for rotation: " + win[0] + "," + win[1] + "," + win[2] + "," + win[3]);
                } else {
                    log.info("Rotated MBR is null. Rotation ignored.");
                }
            }
        }
    }

    private boolean prepareTileParams(Rectangle2D queryWin, VisContext vc) throws DataException {
        if (!this.getMetaData()) {
            throw new DataException("Failed to get capabilities xml.");
        }
        this.mapScale = this.calcScale(queryWin, vc);
        if (this.mapScale < 0.0) {
            throw new DataException("Map scale calculation failed.");
        }
        this.tileLevel = this.getLevel(this.mapScale);
        if (this.tileLevel < 0) {
            log.severe("getLevel failed.");
            throw new DataException("getLevel failed.");
        }
        this.setTileParams(queryWin, this.tileLevel);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenW = 0L;
        try {
            tokenW = wmtsSensor.start();
            this.isErrorImage = false;
            long[] tiles = new long[]{0L, 0L, 0L, 0L};
            long t1 = 0L;
            long t2 = 0L;
            if (!this.prepareTileParams(queryWin, vc)) {
                log.severe("prepareTileParams faild.");
                int n = 0;
                return n;
            }
            double[] mbr = new double[]{queryWin.getMinX(), queryWin.getMinY(), queryWin.getMaxX(), queryWin.getMaxY()};
            this.rotateWindow(mbr, vc);
            if (this.calcTiles(this.tileLevel, tiles, mbr) > 0L) {
                t1 = System.currentTimeMillis();
                int tileCount = this.LoadImageFromWMTSServer(this.tileLevel, tiles, vc.isTileRequest());
                if (tileCount > 0) {
                    t2 = System.currentTimeMillis();
                    log.finest("Dynamic attributes: [timeout] " + ((WMTSTheme)this.owner).getRequestTimeout() + ", [snap_to_tile_scale] " + ((WMTSTheme)this.owner).getSnapToTileScale() + ", [tile_resizing_option] " + ((WMTSTheme)this.owner).getTileResizingOption() + ", [concurrent_threads] " + ((WMTSTheme)this.owner).getCurrentThreads());
                    log.info("[ " + this.def.name + " ] total time loading " + tileCount + " tiles: " + (t2 - t1) + "ms.");
                    TopThemeQueries.add(t2 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), "WMTS requests for tile level [" + this.tileLevel + "]", "tiles loaded = " + tileCount);
                    int n = tileCount;
                    return n;
                }
                if (this.def.hasTileLimits()) {
                    log.warning("No tiles within limits from WMTS server for level: " + this.tileLevel);
                    int n = 0;
                    return n;
                }
                throw new DataException("Failed to fetch any tile from WMTS server.");
            }
            log.info("No valid tiles.");
            int n = 0;
            return n;
        }
        finally {
            wmtsSensor.stop(tokenW);
        }
    }

    private void setTileParams(Rectangle2D queryWin, int level) {
        this.denom = this.def.getTileDenom(level);
        this.tileW = this.def.getTileDim(level, 0);
        this.tileH = this.def.getTileDim(level, 1);
        double tmptopleftX = this.def.getTopleftCorner(level, 0);
        double tmptopleftY = this.def.getTopleftCorner(level, 1);
        if (!Double.isNaN(this.def.getTopLeftCornerX()) && !Double.isNaN(this.def.getTopLeftCornerY())) {
            tmptopleftX = this.def.getTopLeftCornerX();
            tmptopleftY = this.def.getTopLeftCornerY();
        }
        this.tileMtrxMinX = tmptopleftX;
        this.tileMtrxMaxY = tmptopleftY;
        this.matrixWidth = this.def.getTileMatrixDim(level, 0);
        this.matrixHeight = this.def.getTileMatrixDim(level, 1);
        try {
            this.setMetersPerUnit(queryWin);
        }
        catch (Exception e) {
            log.warning("");
        }
        this.pixelSpan = this.denom * 2.8E-4 / this.metersPerUnit;
        this.tileSpanX = this.pixelSpan * (double)this.tileW;
        this.tileSpanY = this.pixelSpan * (double)this.tileH;
        this.tileMtrxMaxX = this.tileMtrxMinX + this.tileSpanX * (double)this.matrixWidth;
        this.tileMtrxMinY = this.tileMtrxMaxY - this.tileSpanY * (double)this.matrixHeight;
    }

    public double getTileScale() {
        return this.def.getTileDenom(this.tileLevel);
    }

    public Rectangle2D calAdjustedQueryWindow(Rectangle2D orgQueryWin, VisContext vc) throws OMSException {
        double cx = orgQueryWin.getCenterX();
        double cy = orgQueryWin.getCenterY();
        Rectangle2D rt = vc.getDeviceWindow();
        double devH = rt.getHeight();
        double devW = rt.getWidth();
        try {
            this.prepareTileParams(orgQueryWin, vc);
        }
        catch (DataException e) {
            e.printStackTrace();
            return null;
        }
        double xmin = cx - this.pixelSpan * devW / 2.0;
        double ymin = cy - this.pixelSpan * devH / 2.0;
        double queryW = this.pixelSpan * devW;
        double queryH = this.pixelSpan * devH;
        Rectangle2D.Double qwin = new Rectangle2D.Double(xmin, ymin, queryW, queryH);
        return qwin;
    }

    private int getLevel(double curScale) {
        int level = 0;
        level = this.getLevel_Weighted(curScale);
        return level;
    }

    private int getLevel_Weighted(double curScale) {
        double maxNeg = Double.NEGATIVE_INFINITY;
        double minPos = Double.POSITIVE_INFINITY;
        int maxNegIndex = this.def.getTileDenomLength() - 1;
        int minPosIndex = 0;
        double ratio = 1.0;
        if (((WMTSTheme)this.owner).getSnapToTileScale()) {
            ratio = 1.0;
        } else {
            String strTmp = ((WMTSTheme)this.owner).getTileResizingOption();
            if (strTmp.length() == 0 || strTmp.equalsIgnoreCase("unbiased")) {
                ratio = 1.0;
            } else if (strTmp.equalsIgnoreCase("expand_biased")) {
                ratio = 4.0;
            } else if (strTmp.equalsIgnoreCase("contract_biased")) {
                ratio = 0.25;
            } else {
                ratio = 1.0;
                log.warning("tile_resizing_option \"" + strTmp + "\" is not recognized. Must be in [unbiased, expand_biased, contract_biased]. \"unbiased\" is used.");
            }
        }
        int level = 0;
        if (curScale == Double.POSITIVE_INFINITY || curScale == Double.NEGATIVE_INFINITY) {
            level = 0;
        } else {
            if (curScale == 0.0) {
                log.severe("The ratio scale cannot be zero.");
                return -1;
            }
            double dCurAbsDiff = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.def.getTileDenomLength(); ++i) {
                double d;
                double dTmp = this.def.getTileDenom(i) - curScale;
                if (!(Math.abs(dTmp) < dCurAbsDiff)) continue;
                dCurAbsDiff = Math.abs(dTmp);
                if (dTmp > 0.0) {
                    d = Math.min(minPos, dTmp);
                    if (!(d < minPos)) continue;
                    minPos = d;
                    minPosIndex = i;
                    continue;
                }
                d = Math.max(maxNeg, dTmp);
                if (!(d > maxNeg)) continue;
                maxNeg = dTmp;
                maxNegIndex = i;
            }
            double r = Math.abs(minPos / maxNeg);
            level = r < ratio ? minPosIndex : maxNegIndex;
        }
        log.finer("[Tile level] " + level + ". [Tile scale denom.] " + this.def.getTileDenom(level) + ". [Request scale] " + curScale);
        if (level < 0) {
            log.warning("The tile level cannot be negative. No image tile is retrieved.");
        }
        return level;
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return -1L;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
    }

    public class ReadBinaryThread
    extends Thread {
        private String reqstr = null;
        private byte[] data = null;

        public ReadBinaryThread(String reqstr_) {
            this.reqstr = reqstr_;
        }

        @Override
        public void run() {
            this.data = Util.readBinaryFromURL(this.reqstr);
        }

        public byte[] getBinaryData() {
            return this.data;
        }
    }
}

