/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.mapviewer.share.ThemeStyleInfo;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.MapMaker;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.RSBundle;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.stylex.HeatMapStyle;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;

public class ThemeUtils {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static char KEY_NAME_DELIMITER = (char)44;
    public static String KEY_VALUE_DELIMITER = ";;";

    public static Theme loadPredefinedGeometryTheme(String themeName, String dataSrc, VisContext vc) throws SQLException {
        themeName = themeName.toUpperCase();
        PredefinedGeometryTheme theme = null;
        ThemeDefinition themeDef = null;
        ThemeCache tCache = null;
        AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(dataSrc);
        tCache = ads.getThemeCache();
        themeDef = tCache.getOrLoadThemeDefinition(themeName);
        if (themeDef == null) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01002") + " [" + themeName + "]");
            return null;
        }
        ThemeDecorator mods = new ThemeDecorator();
        mods.setLabelAlwaysOn(false);
        String tt = themeDef.getThemeType();
        if (!"GEOM_PREDEFINED".equals(tt)) {
            log.severe("Invalid theme type found. Requires simple predefined geometry theme ");
            return null;
        }
        PredGeomThemeDefinition pdef = (PredGeomThemeDefinition)themeDef;
        theme = new PredefinedGeometryTheme(themeName, pdef, null);
        theme.setDecorator(mods);
        return theme;
    }

    public static boolean isHeatMapTheme(ThemeDefinition td, VisContext vc) {
        ThemeStyleInfo[] styles = td.getStyleList(vc);
        if (styles == null) {
            return false;
        }
        for (int i = 0; i < styles.length; ++i) {
            String styName;
            Style sty;
            ThemeStyleInfo si = styles[i];
            if (!si.isRendering() || (sty = MapMaker.getStyleWithName(styName = si.getName(), td.getDataSourceName(), vc)) == null || !(sty instanceof HeatMapStyle)) continue;
            return true;
        }
        return false;
    }

    public static HeatMapStyle getHeatMapStyle(ThemeDefinition td, VisContext vc) {
        ThemeStyleInfo[] styles = td.getStyleList(vc);
        if (styles == null) {
            return null;
        }
        for (int i = 0; i < styles.length; ++i) {
            String styName;
            Style sty;
            ThemeStyleInfo si = styles[i];
            if (!si.isRendering() || (sty = MapMaker.getStyleWithName(styName = si.getName(), td.getDataSourceName(), vc)) == null || !(sty instanceof HeatMapStyle)) continue;
            return (HeatMapStyle)sty;
        }
        return null;
    }

    public static boolean isCompositeKey(String keyColumnName) {
        return keyColumnName != null && keyColumnName.indexOf(KEY_NAME_DELIMITER) > 0;
    }

    public static int getCompositeKeyCount(String keyColumnName) {
        int c = 1;
        for (char ch : keyColumnName.toCharArray()) {
            if (ch != ',') continue;
            ++c;
        }
        return c;
    }

    public static String[] getCompositeKeyColumns(String keyColumnName) {
        if (keyColumnName == null || keyColumnName.length() == 0) {
            return new String[0];
        }
        return keyColumnName.toUpperCase().split("" + KEY_NAME_DELIMITER);
    }

    public static boolean isPartOfCompositeKey(String col, String keyColumnName) {
        String[] cs;
        if (keyColumnName == null || keyColumnName.length() == 0) {
            return false;
        }
        for (String s : cs = ThemeUtils.getCompositeKeyColumns(keyColumnName)) {
            if (!s.equalsIgnoreCase(col)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompositeKeyValue(String keyValue) {
        return keyValue != null && keyValue.indexOf(KEY_VALUE_DELIMITER) > 0;
    }

    public static int getCompositeKeyValueCount(String keyValue) {
        int c = 1;
        int idx = keyValue.indexOf(KEY_VALUE_DELIMITER);
        while (idx >= 0) {
            ++c;
            keyValue = keyValue.substring(idx + KEY_VALUE_DELIMITER.length());
            idx = keyValue.indexOf(KEY_VALUE_DELIMITER);
        }
        return c;
    }

    public static void main(String[] as) {
        String[] a;
        for (String s : a = ThemeUtils.getCompositeKeyColumns("var,abcd,,")) {
            System.out.println("s = " + s);
        }
        System.out.println("isComposite: " + ThemeUtils.isCompositeKey("var,aabb"));
        int c = ThemeUtils.getCompositeKeyValueCount(";;abcd;;352af;;cc;");
        System.out.println("composite value count;" + c);
    }
}

