/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.ThemeStyleInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisConstants;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.theme.BasicThemeInfo;

public abstract class ThemeDefinition
implements Serializable,
VisConstants {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final String THEME_TYPE_LOCAL = "LOCAL";
    public static final String THEME_TYPE_GEOMETRY = "GEOMETRY";
    public static final String THEME_TYPE_DEFAULT = "GEOMETRY";
    public static final String THEME_TYPE_IMAGE = "IMAGE";
    public static final String THEME_TYPE_GEORASTER = "GEORASTER";
    public static final String THEME_TYPE_SHADED_RELIEF = "SHADED_RELIEF";
    public static final String THEME_TYPE_NETWORK = "NETWORK";
    public static final String THEME_TYPE_TOPOLOGY = "TOPOLOGY";
    public static final String THEME_TYPE_GEOM_PREDEFINED = "GEOM_PREDEFINED";
    public static final String THEME_TYPE_GEOM_DYNAMIC = "GEOM_DYNAMIC";
    public static final String THEME_TYPE_WMS = "WMS";
    public static final String THEME_TYPE_WMTS = "WMTS";
    public static final String THEME_TYPE_LRS = "LRS";
    public static final String THEME_TYPE_WFS = "WFS";
    public static final String THEME_TYPE_GEOM_CUSTOM = "GEOM_CUSTOM";
    public static final String THEME_TYPE_ANNOTATION_TEXT = "ANNOTATION";
    public static final String THEME_TYPE_GEOM_FILE = "GEOM_FILE";
    protected String name = null;
    protected String description = null;
    protected String dataSource = null;
    protected int srid = 0;
    protected boolean is9i = false;
    protected Hashtable customTags = new Hashtable();
    protected int fetchSize = 100;
    protected String resourceClassName;
    protected String scaleType = "MAPVIEWER_NATIVE";
    protected double maxRenderScale = Double.NEGATIVE_INFINITY;
    protected double minRenderScale = Double.POSITIVE_INFINITY;
    protected double minLabelScale = Double.POSITIVE_INFINITY;
    protected double maxLabelScale = Double.NEGATIVE_INFINITY;
    protected boolean metadataRegistered = false;

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public void setDataSourceName(String dsrc) {
        this.dataSource = dsrc;
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int s) {
        this.srid = s;
    }

    public String getThemeType() {
        return THEME_TYPE_LOCAL;
    }

    public boolean is9i() {
        return this.is9i;
    }

    public void set9i(boolean v) {
        this.is9i = v;
    }

    public abstract String getXMLDefinition();

    public Hashtable getCustomTags() {
        return this.customTags;
    }

    public void setCustomTags(Hashtable tags) {
        this.customTags = tags == null ? new Hashtable() : tags;
    }

    public String getCustomTag(String tag) {
        if (tag == null || this.customTags.size() == 0) {
            return null;
        }
        return (String)this.customTags.get(tag);
    }

    public void addCustomTag(String tag, String value) {
        if (tag == null || value == null) {
            return;
        }
        this.customTags.put(tag, value);
    }

    public void removeCustomTag(String tag) {
        if (tag == null) {
            return;
        }
        this.customTags.remove(tag);
    }

    public int getNumberOfCustomtags() {
        return this.customTags.size();
    }

    public void clearCustomTags() {
        this.customTags.clear();
    }

    public abstract BasicThemeInfo getBasicThemeInfo();

    public abstract String[] getRenderingStyles();

    public abstract String[] getLabelingStyles();

    public abstract String[] getHighlightStyles();

    public abstract String[] getLabelColumns();

    public abstract Field[] getDistinctAttrColumns();

    public ThemeStyleInfo[] getStyleList(VisContext vc) {
        String[] labelStyles;
        String[] highlightStyles;
        if (this.dataSource == null) {
            return null;
        }
        StyleCache sc = DSManager.getStyleCache(this.dataSource);
        if (sc == null) {
            log.warning("cannot locate the style cache for datasource: " + this.dataSource);
            return null;
        }
        Vector<ThemeStyleInfo> stylesV = new Vector<ThemeStyleInfo>();
        String[] renderStyles = this.getRenderingStyles();
        if (renderStyles != null) {
            for (int i = 0; i < renderStyles.length; ++i) {
                Style sty = null;
                if (vc != null) {
                    sty = vc.getDynamicStyle(renderStyles[i]);
                }
                if (sty == null) {
                    sty = sc.get(renderStyles[i]);
                }
                if (sty == null) {
                    log.warning("render style cannot be found [" + renderStyles[i] + "].");
                    continue;
                }
                ThemeStyleInfo si = new ThemeStyleInfo(renderStyles[i]);
                si.setRendering(true);
                si.setType(sty.getModel().getTypeName());
                si.setDescription(sty.getModel().getDescription());
                stylesV.add(si);
            }
        }
        if ((highlightStyles = this.getHighlightStyles()) != null) {
            for (int i = 0; i < highlightStyles.length; ++i) {
                Style sty = null;
                if (vc != null) {
                    sty = vc.getDynamicStyle(highlightStyles[i]);
                }
                if (sty == null) {
                    sty = sc.get(highlightStyles[i]);
                }
                if (sty == null) {
                    log.warning("highlight style cannot be found [" + highlightStyles[i] + "].");
                    continue;
                }
                ThemeStyleInfo si = new ThemeStyleInfo(highlightStyles[i]);
                si.setHighlighting(true);
                si.setType(sty.getModel().getTypeName());
                si.setDescription(sty.getModel().getDescription());
                stylesV.add(si);
            }
        }
        if ((labelStyles = this.getLabelingStyles()) != null) {
            for (int i = 0; i < labelStyles.length; ++i) {
                Style sty = null;
                if (vc != null) {
                    sty = vc.getDynamicStyle(labelStyles[i]);
                }
                if (sty == null) {
                    sty = sc.get(labelStyles[i]);
                }
                if (sty == null) {
                    log.warning("label style cannot be found [" + labelStyles[i] + "].");
                    continue;
                }
                ThemeStyleInfo si = new ThemeStyleInfo(labelStyles[i]);
                si.setLabeling(true);
                si.setType(sty.getModel().getTypeName());
                si.setDescription(sty.getModel().getDescription());
                stylesV.add(si);
            }
        }
        if (stylesV.size() == 0) {
            return null;
        }
        return stylesV.toArray(new ThemeStyleInfo[stylesV.size()]);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int size) {
        this.fetchSize = size < 1 ? 100 : size;
    }

    public void setResourceClassName(String resourceClassName) {
        this.resourceClassName = resourceClassName;
    }

    public String getResourceClassName() {
        return this.resourceClassName;
    }

    public String getScaleType() {
        return this.scaleType;
    }

    public void setScaleType(String type) {
        this.scaleType = type == null || type.equalsIgnoreCase("MAPVIEWER_NATIVE") ? "MAPVIEWER_NATIVE" : (type.equalsIgnoreCase("RATIO") ? "RATIO" : "MAPVIEWER_NATIVE");
    }

    public double getMinRenderScale() {
        return this.minRenderScale;
    }

    public void setMinRenderScale(double scale) {
        this.minRenderScale = scale;
    }

    public double getMaxRenderScale() {
        return this.maxRenderScale;
    }

    public void setMaxRenderScale(double scale) {
        this.maxRenderScale = scale;
    }

    public double getMinLabelScale() {
        return this.minLabelScale;
    }

    public void setMinLabelScale(double scale) {
        this.minLabelScale = scale;
    }

    public double getMaxLabelScale() {
        return this.maxLabelScale;
    }

    public void setMaxLabelScale(double scale) {
        this.maxLabelScale = scale;
    }

    public static boolean isValidPredefinedThemeType(String t) {
        if (t == null || t.length() <= 0) {
            return false;
        }
        return (t = t.toUpperCase()).equals("GEOMETRY") || t.equals(THEME_TYPE_ANNOTATION_TEXT) || t.equals(THEME_TYPE_GEOM_CUSTOM) || t.equals(THEME_TYPE_GEORASTER) || t.equals(THEME_TYPE_IMAGE) || t.equals(THEME_TYPE_LRS) || t.equals(THEME_TYPE_GEOM_FILE) || t.equals(THEME_TYPE_NETWORK) || t.equals(THEME_TYPE_TOPOLOGY) || t.equals(THEME_TYPE_WFS) || t.equals(THEME_TYPE_WMS) || t.equals(THEME_TYPE_WMTS);
    }

    public void setMetadataRegistered(boolean meta) {
        this.metadataRegistered = meta;
    }

    public boolean isMetadataRegistered() {
        return this.metadataRegistered;
    }
}

