/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.NetworkThemeDefinition;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.TopologyThemeProducer;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.network.Link;
import oracle.spatial.network.MBR;
import oracle.spatial.network.Network;
import oracle.spatial.network.NetworkFactory;
import oracle.spatial.network.NetworkManager;
import oracle.spatial.network.Path;

public class NetworkThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent networkSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "Network", "Producer", "Time spent preparing data");
    private static final int YIELD_COUNT = 20;
    protected Theme owner;
    protected NetworkThemeDefinition def;
    LocalThemeDataProducer features;
    int visSRID = 0;
    String dbVersion = null;
    double viewResX = Double.MIN_VALUE;
    double viewResY = Double.MIN_VALUE;
    double swxl = Double.MIN_VALUE;
    double swxh = Double.MAX_VALUE;
    double swyl = Double.MIN_VALUE;
    double swyh = Double.MAX_VALUE;
    boolean applyRotation = false;
    private long maxFeaturesToBePrepared = -1L;

    public NetworkThemeProducer(Theme t) {
        this.owner = t;
        this.def = (NetworkThemeDefinition)t.getDefinition();
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void abort() {
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenN = 0L;
        try {
            int n;
            JSDOGeometry ndgeom;
            String styquery;
            double[] low;
            TopologyThemeProducer prod;
            tokenN = networkSensor.start();
            if (this.def.getNetworkCategory() == null) {
                vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01043"));
                int n2 = 0;
                return n2;
            }
            if (this.def.getGeometryType() == null) {
                vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01044"));
                int n3 = 0;
                return n3;
            }
            if (!this.def.getNetworkCategory().equals("SPATIAL")) {
                log.warning("Only 'SPATIAL' networks of type 'SDO_GEOMETRY', 'LRS_GEOMETRY', or 'TOPO_GEOMETRY' are supported.");
                int n4 = 0;
                return n4;
            }
            Connection conn = null;
            try {
                conn = DSUtil.getDBConnection(this.def.getDataSourceName(), vc);
            }
            catch (Exception e) {
                throw new DataException("Cannot obtain a connection to database.");
            }
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                try {
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                            Util.gotoWorkspaceDate(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                        } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                            Util.gotoWorkspaceSavedPoint(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                        } else {
                            Util.gotoWorkspace(conn, this.getTheme().getDecorator().getWorkspaceName());
                        }
                    }
                }
                catch (Exception e) {
                    String err = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                    if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                        err = err + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                    } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                        err = err + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                    }
                    log.log(Level.SEVERE, err, e);
                    if (conn != null) {
                        try {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                        catch (Exception ce) {
                            // empty catch block
                        }
                    }
                    throw new DataException(err);
                }
            }
            this.visSRID = vc.getMasterSRID();
            ResultSet rs = null;
            Statement stmt = null;
            int cnt = 0;
            ArrayList<StyledFeatureI> featureSet = new ArrayList<StyledFeatureI>(128);
            ArrayList markerSet = new ArrayList(128);
            SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
            SRS srs = sc.get(this.def.getSrid());
            boolean isGeodetic = false;
            String unit = null;
            if (srs != null) {
                isGeodetic = srs.isGeodetic();
                unit = srs.getUnit();
            } else if (this.def.getSrid() > 0) {
                log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
            }
            double xl = queryWin.getMinX();
            double yl = queryWin.getMinY();
            double xh = queryWin.getMaxX();
            double yh = queryWin.getMaxY();
            boolean transformSRid = false;
            double xi = xl;
            double xf = xh;
            double yi = yl;
            double yf = yh;
            double masterScale = vc.getCurrentScale();
            this.getTheme().setShowLabels(true);
            if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                if (this.def.isPredefined()) {
                    this.def.createLinkCacheGroup(vc.getMasterSRID());
                    this.def.createNodeCacheGroup(vc.getMasterSRID());
                }
                if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                    double[] inmbr = new double[]{xl, yl, xh, yh};
                    double[] outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), this.def.getSrid(), conn);
                    if (outmbr == null) {
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(conn, "LIVE");
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                        }
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception e) {
                            log.warning(e.getMessage());
                        }
                        vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01024"));
                        int e = 0;
                        return e;
                    }
                    xl = outmbr[0];
                    yl = outmbr[1];
                    xh = outmbr[2];
                    yh = outmbr[3];
                    transformSRid = true;
                } else {
                    transformSRid = true;
                }
            }
            if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                double factor = Math.abs(yh - yl) / Math.abs(yf - yi);
                log.finest("[Master scale] " + masterScale + " [Scale factor for theme " + this.getTheme().getName() + "] " + factor);
                double scale = masterScale * factor;
                if (this.getTheme().getScaleType() == "RATIO") {
                    double centery;
                    double centerx;
                    if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                        srs = sc.get(vc.getMasterSRID());
                        centerx = (xi + xf) / 2.0;
                        centery = (yi + yf) / 2.0;
                        factor = 1.0;
                    } else {
                        centerx = (xl + xh) / 2.0;
                        centery = (yl + yh) / 2.0;
                    }
                    if (vc.isTileRequest() && srs.isGeodetic()) {
                        centerx = 0.0;
                        centery = 0.0;
                    }
                    if (srs != null) {
                        scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
                        log.finer("Ratio scale to compare: " + scale);
                    } else {
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(conn, "LIVE");
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception e) {
                            log.warning(e.getMessage());
                        }
                        vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01025"));
                        int e = 0;
                        return e;
                    }
                }
                if (!this.getTheme().withinRenderScaleLimits(scale)) {
                    log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception ex) {
                            log.warning(ex.getMessage());
                        }
                    }
                    try {
                        if (conn != null) {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception e) {
                        log.warning(e.getMessage());
                    }
                    int e = 0;
                    return e;
                }
                if (!this.getTheme().withinLabelScaleLimits(scale)) {
                    log.info("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                    this.getTheme().setShowLabels(false);
                }
            }
            boolean workaround = false;
            boolean bl = workaround = isGeodetic && xh - xl >= 2.0 && xh - xl < 120.0;
            if (workaround) {
                xl = Math.floor(xl);
                log.finest("ptvpxfmfxed: xl=" + xl);
            }
            Proj proj = vc.getProjection();
            this.viewResX = vc.getDeviceWindow().getWidth();
            this.viewResY = vc.getDeviceWindow().getHeight();
            this.dbVersion = Util.getDBVersion(conn);
            log.finest("[ " + this.def.getName() + " ]:  " + xl + "," + yl + "," + xh + "," + yh);
            this.swxl = xl;
            this.swxh = xh;
            this.swyl = yl;
            this.swyh = yh;
            this.applyRotation = false;
            if (MapMaker.isSpecial(xl, yl, xh, yh) && vc.getRotation() != 0.0) {
                log.warning("Rotation is currently ignored for full extent.");
            } else if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(xl, yl, xh, yh)) {
                if (vc.getRotation() < -360.0 || vc.getRotation() > 360.0) {
                    log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                } else {
                    double[] rmbr = Util.rotateMBR(xl, yl, xh, yh, vc.getRotation());
                    if (rmbr != null) {
                        xl = Math.min(rmbr[0], xl);
                        yl = Math.min(rmbr[1], yl);
                        xh = Math.max(rmbr[2], xh);
                        yh = Math.max(rmbr[3], yh);
                        log.finest("Rotation angle: " + vc.getRotation());
                        log.finest("Search window for rotation: " + xl + "," + yl + "," + xh + "," + yh);
                        this.applyRotation = true;
                        this.swxl = xl;
                        this.swxh = xh;
                        this.swyl = yl;
                        this.swyh = yh;
                    } else {
                        log.info("Rotated MBR is null. Rotation ignored.");
                    }
                }
            }
            if (transformSRid) {
                this.swxl = xi;
                this.swxh = xf;
                this.swyl = yi;
                this.swyh = yf;
            }
            log.finest("Max features to be prepared: " + this.maxFeaturesToBePrepared);
            if (this.def.getLinkQuery() != null) {
                String linkq = null;
                try {
                    if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                        linkq = this.rewriteLinkQuery(transformSRid, xl, yl, xh, yh, isGeodetic);
                        if (linkq != null) {
                            log.finest("[Geometry Network link query]:  " + linkq);
                            cnt = this.processGeomLinkQuery(conn, linkq, featureSet, markerSet, cnt, proj, vc, transformSRid, xl, yl, xh, yh);
                        }
                    } else if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                        linkq = this.getLRSDirectionQuery(transformSRid, xl, yl, xh, yh, isGeodetic);
                        if (linkq != null) {
                            log.finest("[LRS Network link query]:  " + linkq);
                            cnt = (this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null) && this.def.getDirectionStyle() == null && this.def.getBiDirectionStyle() == null ? this.processGeomLinkQuery(conn, linkq, featureSet, markerSet, cnt, proj, vc, transformSRid, xl, yl, xh, yh) : this.processLRSLinkQuery(conn, linkq, featureSet, markerSet, cnt, proj, vc, transformSRid);
                        }
                    } else if (this.def.getGeometryType().equals("TOPO_GEOMETRY") && this.def.getLinkTopologyTheme() != null) {
                        prod = (TopologyThemeProducer)this.def.getLinkTopologyTheme().getProducer();
                        cnt = prod.processPredefinedQuery(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc);
                        if (featureSet.size() > 0 && (this.def.getDirectionStyle() != null || this.def.getBiDirectionStyle() != null)) {
                            int dirMarkerSize = this.getMarkerSize(this.def.getDirectionStyleSize(), vc);
                            for (int i = 0; i < featureSet.size(); ++i) {
                                Field bf;
                                StyledFeatureI sf = (StyledFeatureI)featureSet.get(i);
                                String bidir = "";
                                if (this.def.hasBidirectionAttribute() && (bf = Util.getField("bidirected", sf.getAttributes())) != null && bf.getValue() != null) {
                                    bidir = bf.getValue().toString();
                                }
                                if ((this.def.getDirectionStyle() == null || bidir.equalsIgnoreCase("Y")) && (this.def.getBiDirectionStyle() == null || !bidir.equalsIgnoreCase("Y")) || this.def.getLinkDirection().equalsIgnoreCase("UNDIRECTED")) continue;
                                this.createDirectionMarkerFeature(sf, vc, markerSet, dirMarkerSize, bidir);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception ex) {
                            log.warning(ex.getMessage());
                        }
                    }
                    try {
                        if (conn != null) {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception exc) {
                        log.warning(exc.getMessage());
                    }
                    throw new DataException(e);
                }
            }
            if (this.def.getPathQueries() != null) {
                String[] pathQuery = this.def.getPathQueries();
                int[] idPaths = this.def.getPathIds();
                for (int i = 0; i < pathQuery.length; ++i) {
                    if (pathQuery[i] == null) continue;
                    String pathq = this.rewritePathQuery(i, transformSRid, xl, yl, xh, yh, isGeodetic);
                    log.finest("[Network path query][path_id=" + idPaths[i] + "] " + pathq);
                    try {
                        String[] pathStyles = this.def.getPathStyles();
                        int labelcolumn = 0;
                        if (this.def.getPathLabelStyle() != null && this.def.getPathLabelColumn() != null) {
                            labelcolumn = this.def.getGeometryType().equals("SDO_GEOMETRY") || this.def.getGeometryType().equals("TOPO_GEOMETRY") ? 2 : 5;
                        }
                        if (this.def.getGeometryType().equals("SDO_GEOMETRY") || this.def.getGeometryType().equals("TOPO_GEOMETRY")) {
                            cnt = this.processPathQuery(conn, pathq, pathStyles[i], this.def.getPathLabelStyle(), labelcolumn, featureSet, cnt, proj, vc);
                            continue;
                        }
                        cnt = this.processLRSPathQuery(conn, pathq, pathStyles[i], this.def.getPathLabelStyle(), labelcolumn, featureSet, cnt, proj, vc);
                        continue;
                    }
                    catch (Exception e) {
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(conn, "LIVE");
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                        }
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception exc) {
                            log.warning(exc.getMessage());
                        }
                        throw new DataException(e);
                    }
                }
            }
            if (this.def.getShortestPathAlgorithm() != null && (this.def.getShortestPathAlgorithm().equalsIgnoreCase("DIJKSTRA") || this.def.getShortestPathAlgorithm().equalsIgnoreCase("ASEARCH"))) {
                double[] ordinates = null;
                if (this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
                    ordinates = this.runShortestPathAnalysis(conn, null);
                } else {
                    low = new double[]{xl, yl};
                    double[] high = new double[]{xh, yh};
                    MBR mbr = NetworkFactory.createMBR((double[])low, (double[])high);
                    ordinates = this.runShortestPathAnalysis(conn, mbr);
                }
                if (ordinates != null) {
                    JSDOGeometry geom = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])ordinates, (int)2, (int)this.def.getSrid()));
                    if (transformSRid) {
                        String srid = "NULL";
                        if (this.def.getSrid() != 0) {
                            srid = String.valueOf(this.def.getSrid());
                        }
                        String geomstr = "MDSYS.SDO_GEOMETRY(2002, " + srid + ", NULL, " + "MDSYS.SDO_ELEM_INFO_ARRAY(1, 2, 1), " + "MDSYS.SDO_ORDINATE_ARRAY(";
                        for (int k = 0; k < ordinates.length; ++k) {
                            geomstr = k > 0 ? geomstr + "," + ordinates[k] : geomstr + ordinates[k];
                        }
                        geomstr = geomstr + "))";
                        String transfSRid = "select sdo_cs.transform(" + geomstr + "," + vc.getMasterSRID() + ") from dual";
                        try {
                            stmt = conn.prepareStatement(transfSRid);
                            rs = stmt.executeQuery();
                            boolean unpickle = this.getTheme().getDecorator().isFastUnpickle();
                            geom = JDBCUtil.loadGeometry(rs, 1, unpickle);
                        }
                        catch (Exception e) {
                            log.warning(e.getMessage());
                            try {
                                if (conn != null) {
                                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                }
                            }
                            catch (Exception exc) {
                                log.warning(exc.getMessage());
                            }
                            throw new DataException(e);
                        }
                        finally {
                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                try {
                                    Util.gotoWorkspace(conn, "LIVE");
                                }
                                catch (Exception ex) {
                                    log.warning(ex.getMessage());
                                }
                            }
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                        }
                    }
                    StyledFeatureI sf = this.getNewStyledFeatureInstance();
                    boolean usegeom = true;
                    if (proj != null) {
                        Proj.P2 p = proj.getOpposite();
                        if (geom.pointInPolygon(p.x, p.y)) {
                            usegeom = false;
                        } else {
                            JGeometry geomRot;
                            if (this.applyRotation && (geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, vc.getRotation())) != null) {
                                geom = JSDOGeometry.recast(geomRot);
                            }
                            if ((geom = vc.getSrs().shift(geom, vc.getQueryWindow())) != null) {
                                geom = SRS.proj(geom, proj, 0);
                            }
                        }
                    }
                    if (usegeom && geom != null) {
                        sf.setGeometry(geom);
                        sf.setDataSource(this.def.getDataSourceName());
                        sf.setFeatureStyleName(this.def.getShortestPathStyle());
                        featureSet.add(sf);
                        if (++cnt % 20 == 0) {
                            Thread.currentThread();
                            Thread.yield();
                        }
                    }
                }
                if (this.def.getShortestPathStartStyle() != null) {
                    try {
                        if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                            styquery = this.getStyleNodeQuery(transformSRid, this.def.getShortestPathStartNode());
                            if (styquery != null) {
                                log.finest("[Start node style query]:  " + styquery);
                                cnt = this.processQuery(conn, styquery, this.def.getShortestPathStartStyle(), null, 0, featureSet, cnt, proj, vc);
                            }
                        } else if (this.def.getGeometryType().equals("LRS_GEOMETRY") && (ndgeom = this.getLRSNodeGeometry(conn, transformSRid, this.def.getShortestPathStartNode(), proj, vc)) != null) {
                            StyledFeatureI sf = this.getNewStyledFeatureInstance();
                            sf.setGeometry(ndgeom);
                            sf.setFeatureStyleName(this.def.getShortestPathStartStyle());
                            sf.setDataSource(this.def.getDataSourceName());
                            featureSet.add(sf);
                        }
                    }
                    catch (Exception e) {
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(conn, "LIVE");
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                        }
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception exc) {
                            log.warning(exc.getMessage());
                        }
                        throw new DataException(e);
                    }
                }
                if (this.def.getShortestPathEndStyle() != null) {
                    try {
                        if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                            styquery = this.getStyleNodeQuery(transformSRid, this.def.getShortestPathEndNode());
                            if (styquery != null) {
                                log.finest("[End node style query]:  " + styquery);
                                cnt = this.processQuery(conn, styquery, this.def.getShortestPathEndStyle(), null, 0, featureSet, cnt, proj, vc);
                            }
                        } else if (this.def.getGeometryType().equals("LRS_GEOMETRY") && (ndgeom = this.getLRSNodeGeometry(conn, transformSRid, this.def.getShortestPathEndNode(), proj, vc)) != null) {
                            StyledFeatureI sf = this.getNewStyledFeatureInstance();
                            sf.setGeometry(ndgeom);
                            sf.setFeatureStyleName(this.def.getShortestPathEndStyle());
                            sf.setDataSource(this.def.getDataSourceName());
                            featureSet.add(sf);
                        }
                    }
                    catch (Exception e) {
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(conn, "LIVE");
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                        }
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception exc) {
                            log.warning(exc.getMessage());
                        }
                        throw new DataException(e);
                    }
                }
            }
            if (this.def.getShortestPathAlgorithm() != null && this.def.getShortestPathAlgorithm().equalsIgnoreCase("WITHINCOST")) {
                String lrsquery;
                int[] ids = null;
                if (this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
                    ids = this.runWithinCostAnalysis(conn, null);
                } else {
                    low = new double[]{xl, yl};
                    double[] high = new double[]{xh, yh};
                    MBR mbr = NetworkFactory.createMBR((double[])low, (double[])high);
                    ids = this.runWithinCostAnalysis(conn, mbr);
                }
                if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                    String spquery = this.rewriteSpatialQuery(transformSRid, ids);
                    if (spquery != null) {
                        log.finest("[Within Cost path query]:  " + spquery);
                        try {
                            cnt = this.processQuery(conn, spquery, this.def.getShortestPathStyle(), null, 0, featureSet, cnt, proj, vc);
                        }
                        catch (Exception e) {
                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                try {
                                    Util.gotoWorkspace(conn, "LIVE");
                                }
                                catch (Exception ex) {
                                    log.warning(ex.getMessage());
                                }
                            }
                            try {
                                if (conn != null) {
                                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                }
                            }
                            catch (Exception exc) {
                                log.warning(exc.getMessage());
                            }
                            throw new DataException(e);
                        }
                    }
                } else if (this.def.getGeometryType().equals("LRS_GEOMETRY") && (lrsquery = this.getLRSLinkQuery(transformSRid, ids)) != null) {
                    try {
                        stmt = conn.prepareStatement(lrsquery);
                        stmt.setFetchSize(this.owner.getFetchSize());
                        log.finer("Fetch size: " + stmt.getFetchSize());
                        rs = stmt.executeQuery();
                        int last_geomid = 0;
                        JSDOGeometry last_geom = null;
                        while (rs.next()) {
                            Vector linkPoints;
                            JGeometry geomRot;
                            JSDOGeometry geom = null;
                            double start_measure = -9999.0;
                            double end_measure = -9999.0;
                            int link_id = 0;
                            int geom_id = 0;
                            link_id = rs.getInt(2);
                            geom_id = rs.getInt(3);
                            start_measure = rs.getDouble(4);
                            end_measure = rs.getDouble(5);
                            if (geom_id == last_geomid) {
                                geom = last_geom;
                            } else {
                                boolean unpickle = this.getTheme().getDecorator().isFastUnpickle();
                                geom = JDBCUtil.loadGeometry(rs, 1, unpickle);
                            }
                            if (geom == null || geom_id != last_geomid && this.applyRotation && ((geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, vc.getRotation())) == null || (geom = JSDOGeometry.recast(geomRot)) == null) || (geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) continue;
                            last_geomid = geom_id;
                            last_geom = geom;
                            if (proj != null) {
                                Proj.P2 p = proj.getOpposite();
                                if (geom.pointInPolygon(p.x, p.y) || (geom = SRS.proj(geom, proj, 0)) == null) continue;
                            }
                            if ((linkPoints = this.getLRSLink(geom, start_measure, end_measure)) == null) continue;
                            int size = linkPoints.size();
                            double[] finallink = new double[size * 2];
                            for (int j = 0; j < size; ++j) {
                                Point2D pt = (Point2D)linkPoints.get(j);
                                finallink[2 * j] = pt.getX();
                                finallink[2 * j + 1] = pt.getY();
                            }
                            StyledFeatureI sf = this.getNewStyledFeatureInstance();
                            JSDOGeometry sfgeom = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])finallink, (int)2, (int)this.def.getSrid()));
                            sf.setGeometry(sfgeom);
                            sf.setDataSource(this.def.getDataSourceName());
                            sf.setFeatureStyleName(this.def.getShortestPathStyle());
                            featureSet.add(sf);
                        }
                    }
                    catch (Exception e) {
                        log.warning(e.getMessage());
                        throw new DataException(e);
                    }
                    finally {
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(conn, "LIVE");
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                        }
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (Exception ex) {
                            log.warning(ex.getMessage());
                        }
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (Exception ex) {
                            log.warning(ex.getMessage());
                        }
                    }
                }
                if (this.def.getShortestPathStartStyle() != null) {
                    try {
                        if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                            styquery = this.getStyleNodeQuery(transformSRid, this.def.getShortestPathStartNode());
                            if (styquery != null) {
                                log.finest("[Start node style query]:  " + styquery);
                                cnt = this.processQuery(conn, styquery, this.def.getShortestPathStartStyle(), null, 0, featureSet, cnt, proj, vc);
                            }
                        } else if (this.def.getGeometryType().equals("LRS_GEOMETRY") && (ndgeom = this.getLRSNodeGeometry(conn, transformSRid, this.def.getShortestPathStartNode(), proj, vc)) != null) {
                            StyledFeatureI sf = this.getNewStyledFeatureInstance();
                            sf.setGeometry(ndgeom);
                            sf.setFeatureStyleName(this.def.getShortestPathStartStyle());
                            sf.setDataSource(this.def.getDataSourceName());
                            featureSet.add(sf);
                        }
                    }
                    catch (Exception e) {
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(conn, "LIVE");
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                        }
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception exc) {
                            log.warning(exc.getMessage());
                        }
                        throw new DataException(e);
                    }
                }
            }
            if (this.def.getNodeQuery() != null) {
                int ndMarkerSize = this.getMarkerSize(this.def.getNodeStyleSize(), vc);
                try {
                    if (this.def.getGeometryType().equals("TOPO_GEOMETRY")) {
                        if (this.def.getNodeTopologyTheme() != null) {
                            prod = (TopologyThemeProducer)this.def.getNodeTopologyTheme().getProducer();
                            int numFeat = featureSet.size();
                            cnt = prod.processPredefinedQuery(conn, transformSRid, xl, yl, xh, yh, featureSet, proj, isGeodetic, cnt, vc);
                            if (featureSet.size() > numFeat) {
                                for (int i = numFeat; i < featureSet.size(); ++i) {
                                    StyledFeatureI sf = (StyledFeatureI)featureSet.get(i);
                                    sf.setMarkerStyleSize(ndMarkerSize);
                                }
                            }
                        }
                    } else {
                        String nodeq = this.rewriteNodeQuery(transformSRid, xl, yl, xh, yh, isGeodetic);
                        log.finest("[Network node query]:  " + nodeq);
                        stmt = conn.prepareStatement(nodeq);
                        stmt.setFetchSize(this.owner.getFetchSize());
                        log.finer("Fetch size: " + stmt.getFetchSize());
                        rs = stmt.executeQuery();
                        String key = null;
                        String cacheKey = null;
                        String cacheGroup = null;
                        if (this.def.isPredefined()) {
                            if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                                cacheGroup = this.def.getNodeCacheGroup();
                                if (transformSRid) {
                                    cacheGroup = this.def.getNodeCacheGroup(vc.getMasterSRID());
                                }
                            } else if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                                cacheGroup = this.def.getLinkCacheGroup();
                                if (transformSRid) {
                                    cacheGroup = this.def.getLinkCacheGroup(vc.getMasterSRID());
                                }
                            }
                        }
                        int geom_id = 0;
                        int last_geomid = -999;
                        JSDOGeometry last_geom = null;
                        while (rs.next() && (this.maxFeaturesToBePrepared <= 0L || (long)cnt < this.maxFeaturesToBePrepared)) {
                            JGeometry geomRot;
                            JSDOGeometry geom = null;
                            double lrs_measure = 0.0;
                            String nodelabel = null;
                            if (!this.def.isPredefined()) {
                                if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                                    lrs_measure = rs.getDouble(2);
                                    geom_id = rs.getInt(3);
                                    if (this.def.getNodeLabelStyle() != null && this.def.getNodeLabelColumn() != null) {
                                        nodelabel = rs.getString(4);
                                    }
                                } else if (this.def.getNodeLabelStyle() != null && this.def.getNodeLabelColumn() != null) {
                                    nodelabel = rs.getString(2);
                                }
                                if (last_geomid == geom_id) {
                                    geom = last_geom;
                                } else {
                                    boolean unpickle = this.getTheme().getDecorator().isFastUnpickle();
                                    geom = JDBCUtil.loadGeometry(rs, 1, unpickle);
                                }
                            } else {
                                cacheKey = key = rs.getString(1);
                                if (transformSRid) {
                                    cacheKey = key + vc.getMasterSRID();
                                }
                                if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                                    lrs_measure = rs.getDouble(3);
                                    geom_id = rs.getInt(4);
                                    if (this.def.getNodeLabelStyle() != null && this.def.getNodeLabelColumn() != null) {
                                        nodelabel = rs.getString(5);
                                    }
                                } else if (this.def.getNodeLabelStyle() != null && this.def.getNodeLabelColumn() != null) {
                                    nodelabel = rs.getString(3);
                                }
                                if (this.def.getGeometryType().equals("LRS_GEOMETRY") && last_geomid == geom_id) {
                                    geom = last_geom;
                                } else {
                                    CacheGroup cg = CacheMgr2.getGroup(this.def.getCacheSubRegion(), cacheGroup);
                                    geom = this.loadGeom(cg, rs, cacheKey, false);
                                }
                            }
                            if (this.applyRotation && (this.def.getGeometryType().equals("LRS_GEOMETRY") && geom_id != last_geomid || !this.def.getGeometryType().equals("LRS_GEOMETRY")) && ((geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, vc.getRotation())) == null || (geom = JSDOGeometry.recast(geomRot)) == null) || geom == null || (geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) continue;
                            if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
                                last_geomid = geom_id;
                                last_geom = geom;
                            }
                            StyledFeatureI sf = this.getNewStyledFeatureInstance();
                            if (proj != null) {
                                Proj.P2 p = proj.getOpposite();
                                if (geom.pointInPolygon(p.x, p.y) || (geom = SRS.proj(geom, proj, 0)) == null) continue;
                            }
                            if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
                                sf.setGeometry(geom);
                                sf.setDataSource(this.def.getDataSourceName());
                                sf.setFeatureStyleName(this.def.getNodeStyle());
                                sf.setMarkerStyleSize(ndMarkerSize);
                                if (nodelabel != null) {
                                    sf.setLabel(nodelabel);
                                    sf.setLabelStyleName(this.def.getNodeLabelStyle());
                                }
                                featureSet.add(sf);
                                if (++cnt % 20 != 0) continue;
                                Thread.currentThread();
                                Thread.yield();
                                continue;
                            }
                            if (!this.def.getGeometryType().equals("LRS_GEOMETRY")) continue;
                            double[] coords = geom.getOrdinatesArray();
                            double min_measure = coords[2];
                            double max_measure = coords[coords.length - 1];
                            if (lrs_measure < min_measure || lrs_measure > max_measure) continue;
                            double[] newPt = new double[2];
                            for (int i = 0; i < coords.length / 3; ++i) {
                                if (coords[3 * i + 2] == lrs_measure) {
                                    newPt[0] = coords[3 * i];
                                    newPt[1] = coords[3 * i + 1];
                                    break;
                                }
                                if (!(coords[3 * i + 2] > lrs_measure)) continue;
                                double pos = lrs_measure / max_measure;
                                double[] bicoords = new double[coords.length / 3 * 2];
                                for (int j = 0; j < coords.length / 3; ++j) {
                                    bicoords[2 * j] = coords[3 * j];
                                    bicoords[2 * j + 1] = coords[3 * j + 1];
                                }
                                Point2D pt = Util.getLinePoint(bicoords, pos);
                                newPt[0] = pt.getX();
                                newPt[1] = pt.getY();
                                break;
                            }
                            JSDOGeometry ptgeom = JSDOGeometry.recast(JSDOGeometry.createPoint((double[])newPt, (int)2, (int)this.def.getSrid()));
                            StyledFeatureI sfpt = this.getNewStyledFeatureInstance();
                            sfpt.setGeometry(ptgeom);
                            sfpt.setDataSource(this.def.getDataSourceName());
                            sfpt.setFeatureStyleName(this.def.getNodeStyle());
                            sfpt.setMarkerStyleSize(ndMarkerSize);
                            if (nodelabel != null) {
                                sfpt.setLabel(nodelabel);
                                sfpt.setLabelStyleName(this.def.getNodeLabelStyle());
                            }
                            featureSet.add(sfpt);
                            if (++cnt % 20 != 0) continue;
                            Thread.currentThread();
                            Thread.yield();
                        }
                    }
                    if (MapMaker.isSpecial(xl, yl, xh, yh)) {
                        this.loadNewNodes(featureSet);
                    } else {
                        Rectangle2D.Double rc = new Rectangle2D.Double(xl, yl, xh - xl, yh - yl);
                        this.loadEditNodes(rc, featureSet);
                    }
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                    throw new DataException(e);
                }
                finally {
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception ex) {
                            log.warning(ex.getMessage());
                        }
                    }
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    try {
                        if (conn != null) {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception exc) {
                        log.warning(exc.getMessage());
                    }
                }
            }
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
            }
            try {
                if (conn != null) {
                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            for (int m = 0; m < markerSet.size(); ++m) {
                featureSet.add((StyledFeatureI)markerSet.get(m));
            }
            if (featureSet.size() <= 0) {
                n = 0;
                return n;
            }
            this.setStyledFeatures(featureSet);
            featureSet = null;
            n = this.features.size();
            return n;
        }
        finally {
            networkSensor.stop(tokenN);
        }
    }

    private int processQuery(Connection conn, String query, String style, String labelStyle, int labelColumn, ArrayList featSet, int numFeat, Proj proj, VisContext vc) throws DataException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int totfeat = numFeat;
        try {
            stmt = conn.prepareStatement(query);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("[ " + this.def.getName() + " ] Fetch size: " + stmt.getFetchSize());
            rs = stmt.executeQuery();
            while (rs.next()) {
                JGeometry geomRot;
                JSDOGeometry geom = null;
                String labelvalue = null;
                boolean unpickle = this.getTheme().getDecorator().isFastUnpickle();
                geom = JDBCUtil.loadGeometry(rs, 1, unpickle);
                if (geom == null || this.applyRotation && ((geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, vc.getRotation())) == null || (geom = JSDOGeometry.recast(geomRot)) == null) || (geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) continue;
                if (proj != null) {
                    Proj.P2 p = proj.getOpposite();
                    if (geom.pointInPolygon(p.x, p.y) || (geom = SRS.proj(geom, proj, 0)) == null) continue;
                }
                if (labelColumn > 0) {
                    labelvalue = rs.getString(labelColumn);
                }
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setGeometry(geom);
                sf.setFeatureStyleName(style);
                sf.setDataSource(this.def.getDataSourceName());
                if (labelvalue != null) {
                    sf.setLabel(labelvalue);
                    sf.setLabelStyleName(labelStyle);
                }
                featSet.add(sf);
                if (++totfeat % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        return totfeat;
    }

    private int processPathQuery(Connection conn, String query, String style, String labelStyle, int labelColumn, ArrayList featSet, int numFeat, Proj proj, VisContext vc) throws DataException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int totfeat = numFeat;
        try {
            stmt = conn.prepareStatement(query);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("[ " + this.def.getName() + " ] Fetch size: " + stmt.getFetchSize());
            rs = stmt.executeQuery();
            double[] finalcoords = null;
            String labelvalue = null;
            while (rs.next()) {
                JGeometry geomRot;
                JSDOGeometry geom = null;
                boolean unpickle = this.getTheme().getDecorator().isFastUnpickle();
                geom = JDBCUtil.loadGeometry(rs, 1, unpickle);
                if (geom == null || this.applyRotation && ((geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, vc.getRotation())) == null || (geom = JSDOGeometry.recast(geomRot)) == null) || (geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) continue;
                if (proj != null) {
                    Proj.P2 p = proj.getOpposite();
                    if (geom.pointInPolygon(p.x, p.y)) continue;
                    geom = SRS.proj(geom, proj, 0);
                }
                if (labelColumn > 0 && labelvalue == null) {
                    labelvalue = rs.getString(labelColumn);
                }
                if (finalcoords == null) {
                    finalcoords = geom.getOrdinatesArray();
                    continue;
                }
                double[] nextcoords = geom.getOrdinatesArray();
                double[] temp = new double[finalcoords.length];
                System.arraycopy(finalcoords, 0, temp, 0, finalcoords.length);
                finalcoords = null;
                finalcoords = new double[temp.length + nextcoords.length - 2];
                System.arraycopy(temp, 0, finalcoords, 0, temp.length);
                for (int k = 2; k < nextcoords.length; ++k) {
                    finalcoords[temp.length + k - 2] = nextcoords[k];
                }
            }
            if (finalcoords != null) {
                if (labelvalue != null && finalcoords[0] > finalcoords[finalcoords.length - 2]) {
                    int size = finalcoords.length;
                    for (int i = 0; i < (size - 2) / 2; i += 2) {
                        void temp_x = finalcoords[i];
                        double temp_y = finalcoords[i + 1];
                        finalcoords[i] = finalcoords[size - 2 - i];
                        finalcoords[i + 1] = finalcoords[size - 1 - i];
                        finalcoords[size - 2 - i] = temp_x;
                        finalcoords[size - 1 - i] = temp_y;
                    }
                }
                JSDOGeometry geo = JSDOGeometry.recast(JSDOGeometry.createLinearLineString(finalcoords, (int)2, (int)this.def.getSrid()));
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setGeometry(geo);
                sf.setFeatureStyleName(style);
                sf.setDataSource(this.def.getDataSourceName());
                if (labelvalue != null) {
                    sf.setLabel(labelvalue);
                    sf.setLabelStyleName(labelStyle);
                }
                featSet.add(sf);
                if (++totfeat % 20 == 0) {
                    Thread.currentThread();
                    Thread.yield();
                }
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        return totfeat;
    }

    private int processLRSPathQuery(Connection conn, String query, String style, String labelStyle, int labelColumn, ArrayList featSet, int numFeat, Proj proj, VisContext vc) throws DataException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int totfeat = numFeat;
        try {
            stmt = conn.prepareStatement(query);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("[ " + this.def.getName() + " ] Fetch size: " + stmt.getFetchSize());
            rs = stmt.executeQuery();
            double[] finalcoords = null;
            String labelvalue = null;
            while (rs.next()) {
                Vector linkPoints;
                JGeometry geomRot;
                JSDOGeometry geom = null;
                boolean unpickle = this.getTheme().getDecorator().isFastUnpickle();
                geom = JDBCUtil.loadGeometry(rs, 1, unpickle);
                if (geom == null || this.applyRotation && ((geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, vc.getRotation())) == null || (geom = JSDOGeometry.recast(geomRot)) == null) || (geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) continue;
                if (proj != null) {
                    Proj.P2 p = proj.getOpposite();
                    if (geom.pointInPolygon(p.x, p.y) || (geom = SRS.proj(geom, proj, 0)) == null) continue;
                }
                int link_id = rs.getInt(2);
                double start_measure = rs.getDouble(3);
                double end_measure = rs.getDouble(4);
                if (labelColumn > 0 && labelvalue == null) {
                    labelvalue = rs.getString(labelColumn);
                }
                if ((linkPoints = this.getLRSLink(geom, start_measure, end_measure)) == null) continue;
                int size = linkPoints.size();
                double[] finallink = new double[size * 2];
                if (link_id > 0) {
                    for (int j = 0; j < size; ++j) {
                        Point2D pt = (Point2D)linkPoints.get(j);
                        finallink[2 * j] = pt.getX();
                        finallink[2 * j + 1] = pt.getY();
                    }
                } else {
                    int k = 0;
                    for (int j = size - 1; j >= 0; --j) {
                        Point2D pt = (Point2D)linkPoints.get(j);
                        finallink[2 * k] = pt.getX();
                        finallink[2 * k + 1] = pt.getY();
                        ++k;
                    }
                }
                if (finalcoords == null) {
                    finalcoords = new double[size * 2];
                    System.arraycopy(finallink, 0, finalcoords, 0, finallink.length);
                    continue;
                }
                double[] temp = new double[finalcoords.length];
                System.arraycopy(finalcoords, 0, temp, 0, finalcoords.length);
                finalcoords = null;
                finalcoords = new double[temp.length + finallink.length - 2];
                System.arraycopy(temp, 0, finalcoords, 0, temp.length);
                for (int k = 2; k < finallink.length; ++k) {
                    finalcoords[temp.length + k - 2] = finallink[k];
                }
            }
            if (finalcoords != null) {
                if (labelvalue != null && finalcoords[0] > finalcoords[finalcoords.length - 2]) {
                    int size = finalcoords.length;
                    for (int i = 0; i < (size - 2) / 2; i += 2) {
                        void temp_x = finalcoords[i];
                        void temp_y = finalcoords[i + 1];
                        finalcoords[i] = finalcoords[size - 2 - i];
                        finalcoords[i + 1] = finalcoords[size - 1 - i];
                        finalcoords[size - 2 - i] = temp_x;
                        finalcoords[size - 1 - i] = temp_y;
                    }
                }
                JSDOGeometry geo = JSDOGeometry.recast(JSDOGeometry.createLinearLineString(finalcoords, (int)2, (int)this.def.getSrid()));
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setGeometry(geo);
                sf.setFeatureStyleName(style);
                sf.setDataSource(this.def.getDataSourceName());
                if (labelvalue != null) {
                    sf.setLabel(labelvalue);
                    sf.setLabelStyleName(labelStyle);
                }
                featSet.add(sf);
                if (++totfeat % 20 == 0) {
                    Thread.currentThread();
                    Thread.yield();
                }
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        return totfeat;
    }

    private String rewriteLinkQuery(boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        if (this.def.getLinkQuery() == null) {
            return null;
        }
        String querystr = null;
        String linkQuery = this.def.getLinkQuery();
        String linkGeomColumn = null;
        if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
            linkGeomColumn = this.def.getLinkGeometryColumn();
        } else if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            linkGeomColumn = this.def.getLRSGeometryColumn();
        } else {
            return null;
        }
        if (transformSRID) {
            String tochange = linkGeomColumn;
            String changeto = "sdo_cs.transform(" + linkGeomColumn + "," + this.visSRID + ") " + linkGeomColumn;
            querystr = linkQuery.replaceFirst(tochange, changeto);
        } else {
            querystr = linkQuery;
        }
        if (this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            return querystr;
        }
        String filter = this.getFilter(linkGeomColumn, this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        return querystr + " WHERE " + filter;
    }

    private String rewriteNodeQuery(boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        if (this.def.getNodeQuery() == null) {
            return null;
        }
        String querystr = null;
        String nodeQuery = this.def.getNodeQuery();
        String nodeGeomColumn = null;
        if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
            nodeGeomColumn = this.def.getNodeGeometryColumn();
        } else if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            nodeGeomColumn = this.def.getLRSGeometryColumn();
        } else {
            return null;
        }
        if (transformSRID) {
            String tochange = nodeGeomColumn;
            String changeto = "sdo_cs.transform(" + nodeGeomColumn + "," + this.visSRID + ") " + nodeGeomColumn;
            querystr = nodeQuery.replaceFirst(tochange, changeto);
        } else {
            querystr = nodeQuery;
        }
        if (this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            return querystr;
        }
        String filter = this.getFilter(nodeGeomColumn, this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        return querystr + " WHERE " + filter;
    }

    private String rewritePathQuery(int index, boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String[] pathQuery = this.def.getPathQueries();
        if (pathQuery != null && pathQuery[index] == null) {
            return null;
        }
        String querystr = null;
        String pathGeomColumn = null;
        if (this.def.getGeometryType().equals("SDO_GEOMETRY")) {
            pathGeomColumn = this.def.getLinkGeometryColumn();
        } else if (this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            pathGeomColumn = this.def.getLRSGeometryColumn();
        } else if (this.def.getGeometryType().equals("TOPO_GEOMETRY")) {
            pathGeomColumn = this.def.getPathGeometryColumn();
        } else {
            return null;
        }
        if (transformSRID) {
            if (this.def.getGeometryType().equals("SDO_GEOMETRY") && this.def.getPathLabelColumn() != null && this.def.getPathLabelStyle() != null) {
                String tochange = this.def.getLinkTableName() + "." + pathGeomColumn;
                String changeto = "sdo_cs.transform(" + pathGeomColumn + "," + this.visSRID + ") " + pathGeomColumn;
                querystr = pathQuery[index].replaceFirst(tochange, changeto);
            } else {
                String tochange = pathGeomColumn;
                String changeto = "sdo_cs.transform(" + pathGeomColumn + "," + this.visSRID + ") " + pathGeomColumn;
                querystr = pathQuery[index].replaceFirst(tochange, changeto);
            }
        } else {
            querystr = pathQuery[index];
        }
        return querystr;
    }

    private String rewriteSpatialQuery(boolean transformSRID, int[] ids) {
        if (ids == null) {
            return null;
        }
        String tbSchema = "";
        if (this.def.getConnectionUser() != null && this.def.getNetworkOwner() != null && !this.def.getConnectionUser().equalsIgnoreCase(this.def.getNetworkOwner())) {
            tbSchema = this.def.getNetworkOwner() + ".";
        }
        String querystr = null;
        String linkGeomColumn = this.def.getLinkGeometryColumn();
        String linkTableName = this.def.getLinkTableName();
        String inquery = "select " + linkGeomColumn + " from " + tbSchema + linkTableName + " where link_id in (";
        for (int j = 0; j < ids.length; ++j) {
            inquery = j == 0 ? inquery + ids[j] : inquery + "," + ids[j];
        }
        querystr = inquery = inquery + ")";
        if (transformSRID) {
            String tochange = linkGeomColumn;
            String changeto = "sdo_cs.transform(" + linkGeomColumn + "," + this.visSRID + ") " + linkGeomColumn;
            querystr = inquery.replaceFirst(tochange, changeto);
        }
        return querystr;
    }

    private String getLRSDirectionQuery(boolean transformSRID, double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String lrsquery = null;
        if (!this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            return null;
        }
        String tbSchema = "";
        if (this.def.getConnectionUser() != null && this.def.getNetworkOwner() != null && !this.def.getConnectionUser().equalsIgnoreCase(this.def.getNetworkOwner())) {
            tbSchema = this.def.getNetworkOwner() + ".";
        }
        if ((this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null) && this.def.getDirectionStyle() == null && this.def.getBiDirectionStyle() == null) {
            return this.rewriteLinkQuery(transformSRID, xl, yl, xh, yh, isGeodetic);
        }
        String bidirAttr = "";
        if (this.def.hasBidirectionAttribute()) {
            bidirAttr = ", bidirected";
        }
        String lrsTableName = this.def.getLRSTableName();
        String lrsGeomColumn = this.def.getLRSGeometryColumn();
        String linkTableName = this.def.getLinkTableName();
        lrsquery = !this.def.isPredefined() ? (this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? "select " + lrsGeomColumn + ", link_id, " + tbSchema + lrsTableName + ".geom_id, start_measure, end_measure " + bidirAttr + " from " + tbSchema + lrsTableName + " inner join " + tbSchema + linkTableName + " on " + tbSchema + lrsTableName + ".geom_id = " + tbSchema + linkTableName + ".geom_id" : "select " + lrsGeomColumn + ", link_id, " + tbSchema + lrsTableName + ".geom_id, start_measure, end_measure, " + tbSchema + linkTableName + "." + this.def.getLinkLabelColumn() + bidirAttr + " from " + tbSchema + lrsTableName + " inner join " + tbSchema + linkTableName + " on " + tbSchema + lrsTableName + ".geom_id = " + tbSchema + linkTableName + ".geom_id") : (this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? "select " + tbSchema + lrsTableName + ".rowid, " + lrsGeomColumn + ", link_id, " + tbSchema + lrsTableName + ".geom_id, start_measure, end_measure " + bidirAttr + " from " + tbSchema + lrsTableName + " inner join " + tbSchema + linkTableName + " on " + tbSchema + lrsTableName + ".geom_id = " + tbSchema + linkTableName + ".geom_id" : "select " + tbSchema + lrsTableName + ".rowid, " + lrsGeomColumn + ", link_id, " + tbSchema + lrsTableName + ".geom_id, start_measure, end_measure, " + tbSchema + linkTableName + "." + this.def.getLinkLabelColumn() + bidirAttr + " from " + tbSchema + lrsTableName + " inner join " + tbSchema + linkTableName + " on " + tbSchema + lrsTableName + ".geom_id = " + tbSchema + linkTableName + ".geom_id");
        String querystr = null;
        if (transformSRID) {
            String tochange = lrsGeomColumn;
            String changeto = "sdo_cs.transform(" + lrsGeomColumn + "," + this.visSRID + ") " + lrsGeomColumn;
            querystr = lrsquery.replaceFirst(tochange, changeto);
        } else {
            querystr = lrsquery;
        }
        if (this.isFullExtent(this.def.getASIS(), xl, yl, xh, yh)) {
            return querystr + " order by " + tbSchema + lrsTableName + ".geom_id";
        }
        String filter = this.getFilter(lrsGeomColumn, this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        return querystr + " WHERE " + filter + " order by " + tbSchema + lrsTableName + ".geom_id";
    }

    private String getLRSLinkQuery(boolean transformSRID, int[] ids) {
        String lrsquery = null;
        if (!this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            return null;
        }
        String tbSchema = "";
        if (this.def.getConnectionUser() != null && this.def.getNetworkOwner() != null && !this.def.getConnectionUser().equalsIgnoreCase(this.def.getNetworkOwner())) {
            tbSchema = this.def.getNetworkOwner() + ".";
        }
        String lrsTableName = this.def.getLRSTableName();
        String lrsGeomColumn = this.def.getLRSGeometryColumn();
        String linkTableName = this.def.getLinkTableName();
        lrsquery = "select " + lrsGeomColumn + ", link_id, " + tbSchema + lrsTableName + ".geom_id, start_measure, end_measure from " + tbSchema + lrsTableName + " inner join " + tbSchema + linkTableName + " on " + tbSchema + lrsTableName + ".geom_id = " + tbSchema + linkTableName + ".geom_id";
        String querystr = null;
        if (transformSRID) {
            String tochange = lrsGeomColumn;
            String changeto = "sdo_cs.transform(" + lrsGeomColumn + "," + this.visSRID + ") " + lrsGeomColumn;
            querystr = lrsquery.replaceFirst(tochange, changeto);
        } else {
            querystr = lrsquery;
        }
        querystr = querystr + " where link_id in (";
        for (int j = 0; j < ids.length; ++j) {
            querystr = j == 0 ? querystr + ids[j] : querystr + "," + ids[j];
        }
        querystr = querystr + ")";
        return querystr + " order by " + tbSchema + lrsTableName + ".geom_id";
    }

    final String getFilter(String spatialColumn, int srid, double xl, double yl, double xh, double yh, boolean is9i, boolean geodetic) {
        StringBuffer sb = new StringBuffer(256);
        String params = "'querytype=WINDOW'";
        if (this.getTheme().getDecorator().getMinimumFeatureSizePx() > 0 && (this.dbVersion.indexOf(" 10.2") > 0 || this.dbVersion.indexOf(" 10.1.0.3") > 0 || this.dbVersion.indexOf(" 10.1.0.4") > 0 || Util.is11gOrAfter(this.dbVersion))) {
            double resx = (xh - xl) / this.viewResX;
            double resy = (yh - yl) / this.viewResY;
            double res = Math.min(resx, resy) * (double)this.getTheme().getDecorator().getMinimumFeatureSizePx();
            if (geodetic) {
                double earthRadius = 6378137.0;
                res *= Math.PI * earthRadius / 180.0;
            }
            params = "'min_resolution=" + res + " querytype=WINDOW'";
        }
        if (is9i && geodetic) {
            sb.append("MDSYS.SDO_FILTER(" + spatialColumn + ", ");
            sb.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            sb.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + "))" + ", " + srid + " ), " + params + ") = 'TRUE'");
            return sb.toString();
        }
        sb.append("MDSYS.SDO_FILTER(" + spatialColumn + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (srid == 0) {
            sb.append("NULL");
        } else {
            sb.append(srid);
        }
        sb.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + ")), " + params + ") = 'TRUE'");
        return sb.toString();
    }

    private double[] runShortestPathAnalysis(Connection conn, MBR mbr) {
        int spEndNode;
        int[] spIDS = null;
        int spStartNode = this.def.getShortestPathStartNode();
        if (spStartNode == (spEndNode = this.def.getShortestPathEndNode())) {
            log.severe("Start Node (" + spStartNode + ") and End Node (" + spEndNode + ") must be different.");
            return null;
        }
        Network network = null;
        try {
            long t1 = System.currentTimeMillis();
            log.finest("SP: Calling NetworkManager.readNetwork to load network data.");
            network = NetworkManager.readNetwork((Connection)conn, (String)this.def.getNetworkName(), (MBR)mbr, (boolean)false);
            long t2 = System.currentTimeMillis();
            log.finest("Time spent loading network (mbr:" + (mbr != null ? mbr.toString() : "null") + "): " + (t2 - t1) + " ms");
            log.finest("network: #nodes=" + network.getNoOfNodes() + ", #links=" + network.getNoOfLinks());
            log.finest("End of NetworkManager.readNetwork call.");
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            return null;
        }
        Path path = null;
        Link[] linkArray = null;
        double[] ordinates = null;
        try {
            log.finest("Calling NetworkManager Shortest Path Algorithm");
            path = this.def.getShortestPathAlgorithm().equalsIgnoreCase("DIJKSTRA") ? NetworkManager.shortestPathDijkstra((Network)network, (int)spStartNode, (int)spEndNode) : NetworkManager.shortestPathAStar((Network)network, (int)spStartNode, (int)spEndNode);
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            return null;
        }
        log.finest("End of Shortest Path Algorithm.");
        if (path != null) {
            linkArray = path.getLinkArray();
            spIDS = new int[linkArray.length];
            for (int i = 0; i < linkArray.length; ++i) {
                spIDS[i] = linkArray[i].getID();
            }
            path.computeGeometry(0.0);
            JGeometry geomd = path.getGeometry();
            ordinates = geomd.getOrdinatesArray();
        } else {
            log.warning("Result of Shortest Path algorithm is null.");
        }
        this.def.setShortestPathIds(spIDS);
        return ordinates;
    }

    private int[] runWithinCostAnalysis(Connection conn, MBR mbr) {
        int[] spIDS = null;
        Path[] pathArray = null;
        Link[] linkArray = null;
        Network network = null;
        try {
            log.finest("WC: Calling NetworkManager.readNetwork to load network data.");
            long t1 = System.currentTimeMillis();
            network = NetworkManager.readNetwork((Connection)conn, (String)this.def.getNetworkName(), (MBR)mbr, (boolean)false);
            long t2 = System.currentTimeMillis();
            log.finest("Time spent loading network (mbr:" + (mbr != null ? mbr.toString() : "null") + "): " + (t2 - t1) + " ms");
            log.finest("network: #nodes=" + network.getNoOfNodes() + ", #links=" + network.getNoOfLinks());
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            return null;
        }
        int spStartNode = this.def.getShortestPathStartNode();
        double spCost = this.def.getShortestPathCost();
        try {
            log.finest("Calling NetworkManager.withinCost method.");
            pathArray = NetworkManager.withinCost((Network)network, (int)spStartNode, (double)spCost);
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            return null;
        }
        log.finest("End of NetworkManager.withinCost call.");
        if (pathArray != null) {
            Hashtable<String, String> numbers = new Hashtable<String, String>();
            for (int j = 0; j < pathArray.length; ++j) {
                linkArray = pathArray[j].getLinkArray();
                for (int i = 0; i < linkArray.length; ++i) {
                    if (numbers.containsKey(String.valueOf(linkArray[i].getID()))) continue;
                    String value = String.valueOf(linkArray[i].getID());
                    numbers.put(value, value);
                }
            }
            Object[] ids = numbers.values().toArray();
            spIDS = new int[ids.length];
            for (int k = 0; k < ids.length; ++k) {
                spIDS[k] = Integer.parseInt(ids[k].toString());
            }
        }
        this.def.setShortestPathIds(spIDS);
        return spIDS;
    }

    private String getStyleNodeQuery(boolean transformSRID, int nodeid) {
        String query;
        String tbSchema = "";
        if (this.def.getConnectionUser() != null && this.def.getNetworkOwner() != null && !this.def.getConnectionUser().equalsIgnoreCase(this.def.getNetworkOwner())) {
            tbSchema = this.def.getNetworkOwner() + ".";
        }
        String nodeGeomColumn = this.def.getNodeGeometryColumn();
        String nodeTableName = this.def.getNodeTableName();
        String querystr = query = "select " + nodeGeomColumn + " from " + tbSchema + nodeTableName + " where node_id = " + nodeid;
        if (transformSRID) {
            String tochange = nodeGeomColumn;
            String changeto = "sdo_cs.transform(" + nodeGeomColumn + "," + this.visSRID + ") " + nodeGeomColumn;
            querystr = query.replaceFirst(tochange, changeto);
        }
        return querystr;
    }

    private JSDOGeometry getLRSNodeGeometry(Connection conn, boolean transformSRID, int nodeid, Proj proj, VisContext vc) throws DataException {
        String query;
        if (!this.def.getGeometryType().equals("LRS_GEOMETRY")) {
            return null;
        }
        String tbSchema = "";
        if (this.def.getConnectionUser() != null && this.def.getNetworkOwner() != null && !this.def.getConnectionUser().equalsIgnoreCase(this.def.getNetworkOwner())) {
            tbSchema = this.def.getNetworkOwner() + ".";
        }
        String lrsGeomColumn = this.def.getLRSGeometryColumn();
        String lrsTableName = this.def.getLRSTableName();
        String nodeTableName = this.def.getNodeTableName();
        String querystr = query = "select " + lrsGeomColumn + ", measure from " + tbSchema + lrsTableName + " inner join " + tbSchema + nodeTableName + " on " + tbSchema + lrsTableName + ".geom_id = " + tbSchema + nodeTableName + ".geom_id where node_id = " + nodeid;
        if (transformSRID) {
            String tochange = lrsGeomColumn;
            String changeto = "sdo_cs.transform(" + lrsGeomColumn + "," + this.visSRID + ") " + lrsGeomColumn;
            querystr = query.replaceFirst(tochange, changeto);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(querystr);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("[ " + this.def.getName() + " ] Fetch size: " + stmt.getFetchSize());
            rs = stmt.executeQuery();
            if (rs.next()) {
                JSDOGeometry geom = null;
                boolean unpickle = this.getTheme().getDecorator().isFastUnpickle();
                geom = JDBCUtil.loadGeometry(rs, 1, unpickle);
                double measure = rs.getDouble(2);
                boolean validgeom = true;
                if (geom != null && proj != null) {
                    Proj.P2 p = proj.getOpposite();
                    if (geom.pointInPolygon(p.x, p.y)) {
                        validgeom = false;
                    } else {
                        if (this.applyRotation) {
                            JGeometry geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, vc.getRotation());
                            if (geomRot == null) {
                                validgeom = false;
                            } else {
                                geom = JSDOGeometry.recast(geomRot);
                                if (geom == null) {
                                    validgeom = false;
                                }
                            }
                        }
                        if ((geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) {
                            validgeom = false;
                        }
                        if ((geom = SRS.proj(geom, proj, 0)) == null) {
                            validgeom = false;
                        }
                    }
                }
                if (validgeom) {
                    double[] coords = geom.getOrdinatesArray();
                    double max_measure = coords[coords.length - 1];
                    double[] newPt = null;
                    for (int i = 0; i < coords.length / 3; ++i) {
                        if (coords[3 * i + 2] == measure) {
                            newPt = new double[]{coords[3 * i], coords[3 * i + 1]};
                            break;
                        }
                        if (!(coords[3 * i + 2] > measure)) continue;
                        double pos = measure / max_measure;
                        double[] bicoords = new double[coords.length / 3 * 2];
                        for (int j = 0; j < coords.length / 3; ++j) {
                            bicoords[2 * j] = coords[3 * j];
                            bicoords[2 * j + 1] = coords[3 * j + 1];
                        }
                        Point2D pt = Util.getLinePoint(bicoords, pos);
                        newPt = new double[]{pt.getX(), pt.getY()};
                        break;
                    }
                    if (newPt != null) {
                        JSDOGeometry ptgeom;
                        JSDOGeometry jSDOGeometry = ptgeom = JSDOGeometry.recast(JSDOGeometry.createPoint(newPt, (int)2, (int)this.def.getSrid()));
                        return jSDOGeometry;
                    }
                }
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        return null;
    }

    private Vector getLRSLink(JSDOGeometry lrsgeom, double start_measure, double end_measure) {
        Vector<Point2D> linkPoints = new Vector<Point2D>(10);
        double[] coords = lrsgeom.getOrdinatesArray();
        double min_measure = coords[2];
        double max_measure = coords[coords.length - 1];
        int start_idx = -1;
        int end_idx = -1;
        double[] bicoords = new double[coords.length / 3 * 2];
        for (int j = 0; j < coords.length / 3; ++j) {
            bicoords[2 * j] = coords[3 * j];
            bicoords[2 * j + 1] = coords[3 * j + 1];
        }
        for (int i = 0; i < coords.length / 3; ++i) {
            Point2D newPt;
            Point2D.Double newPt2;
            if (start_idx == -1) {
                if (coords[3 * i + 2] == start_measure) {
                    start_idx = i;
                    newPt2 = new Point2D.Double();
                    ((Point2D)newPt2).setLocation(coords[3 * i], coords[3 * i + 1]);
                    linkPoints.add(newPt2);
                } else if (coords[3 * i + 2] > start_measure) {
                    double pos = start_measure / max_measure;
                    newPt = Util.getLinePoint(bicoords, pos);
                    linkPoints.add(newPt);
                    start_idx = i;
                }
            }
            if (end_idx == -1) {
                if (coords[3 * i + 2] == end_measure) {
                    end_idx = i;
                    newPt2 = new Point2D.Double();
                    ((Point2D)newPt2).setLocation(coords[3 * i], coords[3 * i + 1]);
                    linkPoints.add(newPt2);
                } else if (coords[3 * i + 2] > end_measure) {
                    double pos = end_measure / max_measure;
                    newPt = Util.getLinePoint(bicoords, pos);
                    linkPoints.add(newPt);
                    end_idx = i;
                } else if (coords[3 * i + 2] != start_measure && start_idx != -1) {
                    newPt2 = new Point2D.Double();
                    ((Point2D)newPt2).setLocation(coords[3 * i], coords[3 * i + 1]);
                    linkPoints.add(newPt2);
                }
            }
            if (start_idx > -1 && end_idx > -1) break;
        }
        if (start_idx == -1 || end_idx == -1) {
            return null;
        }
        return linkPoints;
    }

    public void setStyledFeatures(ArrayList sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        if (this.features != null) {
            return this.features.getStyledFeatures();
        }
        return null;
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(window);
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(idx);
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(window, name);
    }

    @Override
    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    @Override
    public void postPreparation(VisContext vc) {
        if (this.features != null) {
            this.features.postPreparation(vc);
        }
    }

    @Override
    public int size() {
        if (this.features != null) {
            return this.features.size();
        }
        return 0;
    }

    private int processGeomLinkQuery(Connection conn, String query, ArrayList featSet, ArrayList markerSet, int numFeat, Proj proj, VisContext vc, boolean transformSRid, double xl, double yl, double xh, double yh) throws DataException {
        Statement stmt = null;
        ResultSet rs = null;
        int cnt = numFeat;
        try {
            int dirMarkerSize = this.getMarkerSize(this.def.getDirectionStyleSize(), vc);
            String key = null;
            String cacheKey = null;
            String cacheGroup = null;
            if (this.def.isPredefined()) {
                cacheGroup = this.def.getLinkCacheGroup();
                if (transformSRid) {
                    cacheGroup = this.def.getLinkCacheGroup(vc.getMasterSRID());
                }
            }
            stmt = conn.prepareStatement(query);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("[ " + this.def.getName() + " ] Fetch size: " + stmt.getFetchSize());
            rs = stmt.executeQuery();
            block15: while (rs.next() && (this.maxFeaturesToBePrepared <= 0L || (long)cnt < this.maxFeaturesToBePrepared)) {
                double[] coords;
                JGeometry geomRot;
                String bidir = "";
                JSDOGeometry geom = null;
                if (!this.def.isPredefined()) {
                    boolean unpickle = this.getTheme().getDecorator().isFastUnpickle();
                    geom = JDBCUtil.loadGeometry(rs, 1, unpickle);
                    if (this.def.hasBidirectionAttribute()) {
                        bidir = this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? rs.getString(2) : rs.getString(3);
                    }
                } else {
                    cacheKey = key = rs.getString(1);
                    if (transformSRid) {
                        cacheKey = key + vc.getMasterSRID();
                    }
                    CacheGroup cg = CacheMgr2.getGroup(this.def.getCacheSubRegion(), cacheGroup);
                    geom = this.loadGeom(cg, rs, cacheKey, false);
                    if (this.def.hasBidirectionAttribute()) {
                        bidir = this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? rs.getString(3) : rs.getString(4);
                    }
                }
                if (geom == null || this.applyRotation && ((geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, vc.getRotation())) == null || (geom = JSDOGeometry.recast(geomRot)) == null) || (geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) continue;
                String linklabel = null;
                if (this.def.getLinkLabelStyle() != null && this.def.getLinkLabelColumn() != null) {
                    linklabel = this.def.isPredefined() ? rs.getString(3) : rs.getString(2);
                }
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                if (proj != null) {
                    Proj.P2 p = proj.getOpposite();
                    if (geom.pointInPolygon(p.x, p.y) || (geom = SRS.proj(geom, proj, 0)) == null) continue;
                }
                if (linklabel != null) {
                    coords = geom.getOrdinatesArray();
                    int size = coords.length;
                    double[] finalcoords = new double[size];
                    JSDOGeometry geor = geom;
                    if (coords[0] > coords[size - 2]) {
                        for (int k = 0; k < coords.length; k += 2) {
                            finalcoords[k] = coords[coords.length - 1 - k - 1];
                            finalcoords[k + 1] = coords[coords.length - 1 - k];
                        }
                        geor = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])finalcoords, (int)2, (int)this.def.getSrid()));
                    }
                    sf.setLabel(linklabel);
                    sf.setLabelStyleName(this.def.getLinkLabelStyle());
                    sf.setGeometry(geor);
                } else {
                    sf.setGeometry(geom);
                }
                sf.setFeatureStyleName(this.def.getLinkStyle());
                sf.setDataSource(this.def.getDataSourceName());
                featSet.add(sf);
                if (++cnt % 20 == 0) {
                    Thread.currentThread();
                    Thread.yield();
                }
                if ((this.def.getDirectionStyle() == null || bidir.equalsIgnoreCase("Y")) && (this.def.getBiDirectionStyle() == null || !bidir.equalsIgnoreCase("Y")) || this.def.getLinkDirection().equalsIgnoreCase("UNDIRECTED") || this.def.getGeometryType().equals("LRS_GEOMETRY") || (coords = geom.getOrdinatesArray()).length < 4) continue;
                double masterScale = vc.getCurrentScale();
                boolean accept = false;
                double length = 0.0;
                double dirlength = 0.0;
                if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                    double dpi = vc.getDPI();
                    dirlength = (double)dirMarkerSize / dpi * masterScale;
                    double x2 = coords[2];
                    double x1 = coords[0];
                    double y2 = coords[3];
                    double y1 = coords[1];
                    double dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    if (0.6 * dist >= dirlength) {
                        accept = true;
                    } else {
                        for (int k = 2; k < coords.length; k += 2) {
                            x2 = coords[k];
                            y2 = coords[k + 1];
                            length += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                            x1 = x2;
                            y1 = y2;
                        }
                    }
                } else {
                    accept = true;
                }
                if (!accept && !(dirlength <= 0.6 * length)) continue;
                for (double dirpos = this.def.getLinkDirectionPosition(); dirpos > 0.0 && dirpos < 1.0; dirpos += this.def.getLinkDirectionPosition()) {
                    Point2D pt = Util.getLinePoint(coords, dirpos);
                    if (pt != null) {
                        double[] newPt = new double[]{pt.getX(), pt.getY()};
                        double[] segpoints = Util.getLineSegment(coords, dirpos);
                        double dx = segpoints[2] - segpoints[0];
                        double dy = segpoints[3] - segpoints[1];
                        JSDOGeometry ptgeom = JSDOGeometry.recast(JSDOGeometry.createPoint((double[])newPt, (int)2, (int)this.def.getSrid()));
                        StyledFeatureI sfpt = this.getNewStyledFeatureInstance();
                        sfpt.setGeometry(ptgeom);
                        sfpt.setDataSource(this.def.getDataSourceName());
                        if (!bidir.equalsIgnoreCase("Y")) {
                            sfpt.setFeatureStyleName(this.def.getDirectionStyle());
                        } else {
                            sfpt.setFeatureStyleName(this.def.getBiDirectionStyle());
                        }
                        sfpt.setMarkerStyleSize(dirMarkerSize);
                        sfpt.setMarkerStyleOrientation(dx, dy, 0.0);
                        markerSet.add(sfpt);
                    }
                    if (!this.def.hasMultipleDirectionMarkers()) continue block15;
                }
            }
            if (MapMaker.isSpecial(xl, yl, xh, yh)) {
                this.loadNewLinks(featSet);
            } else {
                Rectangle2D.Double rc = new Rectangle2D.Double(xl, yl, xh - xl, yh - yl);
                this.loadEditLinks(rc, featSet);
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            try {
                if (conn != null) {
                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                }
            }
            catch (Exception exc) {
                log.warning(exc.getMessage());
            }
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        return cnt;
    }

    private int processLRSLinkQuery(Connection conn, String query, ArrayList featSet, ArrayList markerSet, int numFeat, Proj proj, VisContext vc, boolean transformSRid) throws DataException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int cnt = numFeat;
        try {
            int dirMarkerSize = this.getMarkerSize(this.def.getDirectionStyleSize(), vc);
            stmt = conn.prepareStatement(query);
            stmt.setFetchSize(this.owner.getFetchSize());
            log.finer("[ " + this.def.getName() + " ] Fetch size: " + stmt.getFetchSize());
            rs = stmt.executeQuery();
            String key = null;
            String cacheKey = null;
            String cacheGroup = null;
            if (this.def.isPredefined()) {
                cacheGroup = this.def.getLinkCacheGroup();
                if (transformSRid) {
                    cacheGroup = this.def.getLinkCacheGroup(vc.getMasterSRID());
                }
            }
            int last_geomid = 0;
            JSDOGeometry last_geom = null;
            while (rs.next()) {
                Vector linkPoints;
                JGeometry geomRot;
                if (this.maxFeaturesToBePrepared > 0L && (long)cnt >= this.maxFeaturesToBePrepared) {
                    break;
                }
                String bidir = "";
                JSDOGeometry geom = null;
                double start_measure = -9999.0;
                double end_measure = -9999.0;
                int link_id = 0;
                int geom_id = 0;
                String linklabel = null;
                if (!this.def.isPredefined()) {
                    link_id = rs.getInt(2);
                    geom_id = rs.getInt(3);
                    start_measure = rs.getDouble(4);
                    end_measure = rs.getDouble(5);
                    if (this.def.getLinkLabelStyle() != null && this.def.getLinkLabelColumn() != null) {
                        linklabel = rs.getString(6);
                    }
                    if (geom_id == last_geomid) {
                        geom = last_geom;
                    } else {
                        boolean unpickle = this.getTheme().getDecorator().isFastUnpickle();
                        geom = JDBCUtil.loadGeometry(rs, 1, unpickle);
                    }
                    if (this.def.hasBidirectionAttribute()) {
                        bidir = this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? rs.getString(6) : rs.getString(7);
                    }
                } else {
                    cacheKey = key = rs.getString(1);
                    if (transformSRid) {
                        cacheKey = key + vc.getMasterSRID();
                    }
                    link_id = rs.getInt(3);
                    geom_id = rs.getInt(4);
                    start_measure = rs.getDouble(5);
                    end_measure = rs.getDouble(6);
                    if (this.def.getLinkLabelStyle() != null && this.def.getLinkLabelColumn() != null) {
                        linklabel = rs.getString(7);
                    }
                    if (geom_id == last_geomid) {
                        geom = last_geom;
                    } else if (this.def.getCachingMode() != 3 && this.getTheme().getDecorator().getWorkspaceName() == null) {
                        CacheGroup cg = CacheMgr2.getGroup(this.def.getCacheSubRegion(), cacheGroup);
                        if (cg != null) {
                            geom = (JSDOGeometry)cg.get(cacheKey);
                        }
                        if (geom == null && (geom = JDBCUtil.loadGeometry(rs, 2, false)) != null) {
                            cg.put(cacheKey, geom, geom.getSize());
                        }
                    } else {
                        geom = JDBCUtil.loadGeometry(rs, 2, false);
                    }
                    if (this.def.hasBidirectionAttribute()) {
                        bidir = this.def.getLinkLabelStyle() == null || this.def.getLinkLabelColumn() == null ? rs.getString(7) : rs.getString(8);
                    }
                }
                if (geom == null || geom_id != last_geomid && this.applyRotation && ((geomRot = Util.rotateGeometry(geom, (this.swxl + this.swxh) / 2.0, (this.swyl + this.swyh) / 2.0, vc.getRotation())) == null || (geom = JSDOGeometry.recast(geomRot)) == null) || (geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null) continue;
                last_geomid = geom_id;
                last_geom = geom;
                if (proj != null) {
                    Proj.P2 p = proj.getOpposite();
                    if (geom.pointInPolygon(p.x, p.y) || (geom = SRS.proj(geom, proj, 0)) == null) continue;
                }
                if ((linkPoints = this.getLRSLink(geom, start_measure, end_measure)) == null) continue;
                int size = linkPoints.size();
                double[] finallink = new double[size * 2];
                if (link_id > 0) {
                    for (int j = 0; j < size; ++j) {
                        Point2D pt = (Point2D)linkPoints.get(j);
                        finallink[2 * j] = pt.getX();
                        finallink[2 * j + 1] = pt.getY();
                    }
                } else {
                    int k = 0;
                    for (int j = size - 1; j >= 0; --j) {
                        Point2D pt = (Point2D)linkPoints.get(j);
                        finallink[2 * k] = pt.getX();
                        finallink[2 * k + 1] = pt.getY();
                        ++k;
                    }
                }
                if ((this.def.getDirectionStyle() != null && !bidir.equalsIgnoreCase("Y") || this.def.getBiDirectionStyle() != null && bidir.equalsIgnoreCase("Y")) && !this.def.getLinkDirection().equalsIgnoreCase("UNDIRECTED")) {
                    if (finallink.length < 4) continue;
                    double masterScale = vc.getCurrentScale();
                    boolean accept = false;
                    double length = 0.0;
                    double dirlength = 0.0;
                    if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                        double dpi = vc.getDPI();
                        dirlength = (double)dirMarkerSize / dpi * masterScale;
                        double x2 = finallink[2];
                        double x1 = finallink[0];
                        double y2 = finallink[3];
                        double y1 = finallink[1];
                        double dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                        if (0.6 * dist >= dirlength) {
                            accept = true;
                        } else {
                            for (int k = 2; k < finallink.length; k += 2) {
                                x2 = finallink[k];
                                y2 = finallink[k + 1];
                                length += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                                x1 = x2;
                                y1 = y2;
                            }
                        }
                    } else {
                        accept = true;
                    }
                    if (accept || dirlength <= 0.6 * length) {
                        for (double dirpos = this.def.getLinkDirectionPosition(); dirpos > 0.0 && dirpos < 1.0; dirpos += this.def.getLinkDirectionPosition()) {
                            Point2D pt = Util.getLinePoint(finallink, dirpos);
                            if (pt != null) {
                                double[] segpoints = Util.getLineSegment(finallink, dirpos);
                                double dx = segpoints[2] - segpoints[0];
                                double dy = segpoints[3] - segpoints[1];
                                double[] dirPt = new double[]{pt.getX(), pt.getY()};
                                JSDOGeometry ptdir = JSDOGeometry.recast(JSDOGeometry.createPoint((double[])dirPt, (int)2, (int)this.def.getSrid()));
                                StyledFeatureI sfdir = this.getNewStyledFeatureInstance();
                                sfdir.setGeometry(ptdir);
                                sfdir.setDataSource(this.def.getDataSourceName());
                                if (!bidir.equalsIgnoreCase("Y")) {
                                    sfdir.setFeatureStyleName(this.def.getDirectionStyle());
                                } else {
                                    sfdir.setFeatureStyleName(this.def.getBiDirectionStyle());
                                }
                                sfdir.setMarkerStyleSize(dirMarkerSize);
                                sfdir.setMarkerStyleOrientation(dx, dy, 0.0);
                                markerSet.add(sfdir);
                            }
                            if (!this.def.hasMultipleDirectionMarkers()) break;
                        }
                    }
                }
                JSDOGeometry geor = null;
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                if (linklabel != null) {
                    int length = finallink.length;
                    double[] finalcoords = new double[length];
                    if (finallink[0] > finallink[length - 2]) {
                        for (int k = 0; k < finallink.length; k += 2) {
                            finalcoords[k] = finallink[length - 1 - k - 1];
                            finalcoords[k + 1] = finallink[length - 1 - k];
                        }
                        geor = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])finalcoords, (int)2, (int)this.def.getSrid()));
                    } else {
                        geor = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])finallink, (int)2, (int)this.def.getSrid()));
                    }
                    sf.setLabel(linklabel);
                    sf.setLabelStyleName(this.def.getLinkLabelStyle());
                    sf.setGeometry(geor);
                } else {
                    geor = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])finallink, (int)2, (int)this.def.getSrid()));
                }
                sf.setGeometry(geor);
                sf.setFeatureStyleName(this.def.getLinkStyle());
                sf.setDataSource(this.def.getDataSourceName());
                featSet.add(sf);
                if (++cnt % 20 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
        return cnt;
    }

    private boolean isFullExtent(boolean passThrough, double xl, double yl, double xh, double yh) {
        return passThrough || Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh);
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    private int getMarkerSize(SizeDefinition size, VisContext vc) {
        if (size != null && size.isPixelUnit()) {
            return (int)size.getValue();
        }
        if (size == null || vc == null || Util.isFullExtent(vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMaxX(), vc.getQueryWindow().getMaxY()) || vc.getQueryWindow().getWidth() == 0.0 && vc.getQueryWindow().getHeight() == 0.0) {
            return 8;
        }
        Rectangle2D devW = vc.getDeviceWindow();
        Rectangle2D queW = vc.getQueryWindow();
        double pixelY = queW.getHeight() / devW.getHeight();
        Double convFactor = SRS.getDistanceConversionFactor(size.getUnit());
        if (convFactor == null) {
            return 8;
        }
        double mkheight = size.getValue() * convFactor;
        if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
            double dgh = SphereCG.convertRadius(0.0, 0.0, mkheight);
            return (int)(dgh / pixelY + 0.5);
        }
        return (int)(mkheight / pixelY + 0.5);
    }

    protected JSDOGeometry loadGeom(ResultSet rs, boolean unpickler) throws Exception {
        return JDBCUtil.loadGeometry(rs, 2, unpickler);
    }

    protected JSDOGeometry loadGeom(CacheGroup cg, ResultSet rs, String cacheKey, boolean unpickler) throws Exception {
        JSDOGeometry geom = null;
        if (this.def.getCachingMode() != 3 && cg != null && this.getTheme().getDecorator().getWorkspaceName() == null) {
            geom = (JSDOGeometry)cg.get(cacheKey);
            if (geom == null && (geom = this.loadGeom(rs, unpickler)) != null) {
                cg.put(cacheKey, geom, geom.getSize());
            }
        } else {
            geom = this.loadGeom(rs, unpickler);
        }
        return geom;
    }

    protected void loadNewLinks(ArrayList featVector) {
    }

    protected void loadNewNodes(ArrayList featVector) {
    }

    protected void loadEditLinks(Rectangle2D mbr, ArrayList featVector) {
    }

    protected void loadEditNodes(Rectangle2D mbr, ArrayList featVector) {
    }

    private void createDirectionMarkerFeature(StyledFeatureI sf, VisContext vc, ArrayList markerSet, int dirMarkerSize, String bidir) {
        if (sf == null || vc == null || markerSet == null) {
            return;
        }
        JSDOGeometry geom = sf.getGeometry();
        if (geom == null) {
            return;
        }
        double[] coords = geom.getOrdinatesArray();
        if (coords == null || coords.length < 4) {
            return;
        }
        double masterScale = vc.getCurrentScale();
        boolean accept = false;
        double length = 0.0;
        double dirlength = 0.0;
        if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
            double dpi = vc.getDPI();
            dirlength = (double)dirMarkerSize / dpi * masterScale;
            double x2 = coords[2];
            double x1 = coords[0];
            double y2 = coords[3];
            double y1 = coords[1];
            double dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            if (0.6 * dist >= dirlength) {
                accept = true;
            } else {
                for (int k = 2; k < coords.length; k += 2) {
                    x2 = coords[k];
                    y2 = coords[k + 1];
                    length += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    x1 = x2;
                    y1 = y2;
                }
            }
        } else {
            accept = true;
        }
        if (accept || dirlength <= 0.6 * length) {
            for (double dirpos = this.def.getLinkDirectionPosition(); dirpos > 0.0 && dirpos < 1.0; dirpos += this.def.getLinkDirectionPosition()) {
                Point2D pt = Util.getLinePoint(coords, dirpos);
                if (pt != null) {
                    double[] newPt = new double[]{pt.getX(), pt.getY()};
                    double[] segpoints = Util.getLineSegment(coords, dirpos);
                    double dx = segpoints[2] - segpoints[0];
                    double dy = segpoints[3] - segpoints[1];
                    JSDOGeometry ptgeom = JSDOGeometry.recast(JSDOGeometry.createPoint((double[])newPt, (int)2, (int)this.def.getSrid()));
                    StyledFeatureI sfpt = this.getNewStyledFeatureInstance();
                    sfpt.setGeometry(ptgeom);
                    sfpt.setDataSource(this.def.getDataSourceName());
                    if (!bidir.equalsIgnoreCase("Y")) {
                        sfpt.setFeatureStyleName(this.def.getDirectionStyle());
                    } else {
                        sfpt.setFeatureStyleName(this.def.getBiDirectionStyle());
                    }
                    sfpt.setMarkerStyleSize(dirMarkerSize);
                    sfpt.setMarkerStyleOrientation(dx, dy, 0.0);
                    markerSet.add(sfpt);
                }
                if (!this.def.hasMultipleDirectionMarkers()) break;
            }
        }
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return this.maxFeaturesToBePrepared;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
        this.maxFeaturesToBePrepared = size;
    }
}

