/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonThemeAttrs {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public int cacheMode = 1;
    public String keyColumn = "ROWID";
    public StylingRule[] styleRules = null;
    public String[] identifiableColumns = null;
    public String[] identifiableNames = null;
    public String table_Alias = null;
    public Vector tagNames = new Vector();
    public Vector tagValues = new Vector();
    public String highlightStyleName = null;
    public int fetchSize = 100;
    public String resourceClass = null;
    public String scaleType = "MAPVIEWER_NATIVE";
    public double maxRenderScale = Double.NEGATIVE_INFINITY;
    public double minRenderScale = Double.POSITIVE_INFINITY;
    public double minLabelScale = Double.POSITIVE_INFINITY;
    public double maxLabelScale = Double.NEGATIVE_INFINITY;

    public void reset() {
        this.cacheMode = 1;
        this.keyColumn = "ROWID";
        this.styleRules = null;
        this.identifiableColumns = null;
        this.identifiableNames = null;
        this.table_Alias = null;
        this.fetchSize = 100;
        this.tagNames.clear();
        this.tagValues.clear();
        this.highlightStyleName = null;
        this.resourceClass = null;
        this.scaleType = "MAPVIEWER_NATIVE";
        this.maxRenderScale = Double.NEGATIVE_INFINITY;
        this.minRenderScale = Double.POSITIVE_INFINITY;
        this.minLabelScale = Double.POSITIVE_INFINITY;
        this.maxLabelScale = Double.NEGATIVE_INFINITY;
    }

    public void getAttributes(String name, XMLDOMParser parser, Node root, String baseTable, String geoColumn) {
        Node scaleRanges;
        NodeList tagList;
        Node tags;
        int i;
        Node rb;
        this.reset();
        String v = XMLDOMParser.getAttribute(root, "key_column");
        if (v != null && v.length() > 0) {
            this.keyColumn = v;
            log.finest("key_column specified by user: " + this.keyColumn);
        } else {
            log.finest("key_column using default: " + this.keyColumn);
        }
        v = XMLDOMParser.getAttribute(root, "caching");
        if (v != null && v.length() > 0) {
            if ("none".equalsIgnoreCase(v)) {
                this.cacheMode = 3;
            } else if ("all".equalsIgnoreCase(v)) {
                this.cacheMode = 2;
            }
        }
        if ((v = XMLDOMParser.getAttribute(root, "table_alias")) != null && v.trim().length() > 0) {
            this.table_Alias = v.trim();
        }
        if ((v = XMLDOMParser.getAttribute(root, "highlight_style")) != null && v.trim().length() > 0) {
            this.highlightStyleName = v.trim().toUpperCase();
        }
        if ((v = XMLDOMParser.getAttribute(root, "fetch_size")) != null && v.trim().length() > 0) {
            try {
                this.fetchSize = Integer.parseInt(v);
            }
            catch (Exception e) {
                this.fetchSize = 100;
            }
        }
        if ((rb = parser.getElementNode("resource_bundle")) != null) {
            this.resourceClass = XMLDOMParser.getElementValue(rb);
        }
        root = parser.getElementNode("info");
        NodeList nl = parser.getElementNodes("field");
        if (nl.getLength() > 0) {
            this.identifiableColumns = new String[nl.getLength()];
            this.identifiableNames = new String[nl.getLength()];
            for (i = 0; i < nl.getLength(); ++i) {
                Node nd = nl.item(i);
                this.identifiableColumns[i] = XMLDOMParser.getAttribute(nd, "column");
                this.identifiableNames[i] = XMLDOMParser.getAttribute(nd, "name");
                if (this.identifiableNames[i] != null && this.identifiableNames[i].length() != 0) continue;
                this.identifiableNames[i] = this.identifiableColumns[i];
            }
        }
        if ((nl = parser.getElementNodes("rule")).getLength() > 0) {
            this.styleRules = new StylingRule[nl.getLength()];
            for (i = 0; i < nl.getLength(); ++i) {
                this.styleRules[i] = new StylingRule(baseTable, geoColumn, parser, nl.item(i));
            }
        }
        if ((tags = parser.getElementNode("custom_tags")) != null && (tagList = parser.getElementNodes("tag")) != null && tagList.getLength() > 0) {
            for (int i2 = 0; i2 < tagList.getLength(); ++i2) {
                Node tag = tagList.item(i2);
                NodeList tagChildren = tag.getChildNodes();
                if (tagChildren == null) continue;
                String tagName = null;
                String tagValue = null;
                for (int j = 0; j < tagChildren.getLength(); ++j) {
                    Node tgc = tagChildren.item(j);
                    if (tgc != null && tgc.getNodeName().equalsIgnoreCase("name")) {
                        tagName = tgc.getChildNodes().item(0).getNodeValue();
                        if (tagName == null || tagName.trim().length() >= 1) continue;
                        tagName = null;
                        continue;
                    }
                    if (tgc == null || !tgc.getNodeName().equalsIgnoreCase("value") || (tagValue = tgc.getChildNodes().item(0).getNodeValue()) == null || tagValue.trim().length() >= 1) continue;
                    tagValue = null;
                }
                if (tagName == null || tagValue == null) continue;
                this.tagNames.add(tagName.trim());
                this.tagValues.add(tagValue.trim());
            }
        }
        if ((scaleRanges = parser.getElementNode("scale_ranges")) != null) {
            Node maxlscale;
            Node minlscale;
            Node maxrscale;
            Node minrscale;
            Node mode = XMLDOMParser.getSubElement(scaleRanges, "mode");
            if (mode != null) {
                String md = XMLDOMParser.getElementValue(mode);
                if (md != null) {
                    this.scaleType = md;
                }
            }
            if ((minrscale = XMLDOMParser.getSubElement(scaleRanges, "min_rendering_scale")) != null) {
                String val = XMLDOMParser.getElementValue(minrscale);
                if (val != null) {
                    try {
                        this.minRenderScale = Double.parseDouble(val);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if ((maxrscale = XMLDOMParser.getSubElement(scaleRanges, "max_rendering_scale")) != null) {
                String val = XMLDOMParser.getElementValue(maxrscale);
                if (val != null) {
                    try {
                        this.maxRenderScale = Double.parseDouble(val);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if ((minlscale = XMLDOMParser.getSubElement(scaleRanges, "min_labeling_scale")) != null) {
                String val = XMLDOMParser.getElementValue(minlscale);
                if (val != null) {
                    try {
                        this.minLabelScale = Double.parseDouble(val);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if ((maxlscale = XMLDOMParser.getSubElement(scaleRanges, "max_labeling_scale")) != null) {
                String val = XMLDOMParser.getElementValue(maxlscale);
                if (val != null) {
                    try {
                        this.maxLabelScale = Double.parseDouble(val);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void updateThemeDefinitionCustomTags(ThemeDefinition tdef) {
        tdef.clearCustomTags();
        if (tdef == null) {
            return;
        }
        if (this.tagNames.size() == 0 || this.tagValues.size() == 0 || this.tagNames.size() != this.tagValues.size()) {
            return;
        }
        for (int i = 0; i < this.tagNames.size(); ++i) {
            tdef.addCustomTag(this.tagNames.get(i).toString(), this.tagValues.get(i).toString());
        }
    }
}

