/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.text;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.SRS;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.theme.AnnotationTextThemeProducer;
import oracle.sdovis.util.GMLGeometryUtils;
import oracle.sdovis.util.StringOutputStream;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import org.w3c.dom.Node;

public class AnnotationText
implements Cloneable {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    JGeometry envelope = null;
    AnnotationTextElement[] elements = null;

    public Object clone() {
        try {
            AnnotationText obj = (AnnotationText)super.clone();
            if (this.envelope != null) {
                obj.envelope = (JGeometry)this.envelope.clone();
            }
            if (this.elements != null) {
                obj.elements = new AnnotationTextElement[this.elements.length];
                for (int i = 0; i < this.elements.length; ++i) {
                    obj.elements[i] = (AnnotationTextElement)this.elements[i].clone();
                }
            }
            return obj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public static final AnnotationText load(STRUCT st) throws SQLException {
        Datum[] delems;
        ARRAY elems;
        if (st == null) {
            return null;
        }
        AnnotationText atext = new AnnotationText();
        Datum[] attrs = st.getOracleAttributes();
        STRUCT extent = (STRUCT)attrs[0];
        if (extent != null) {
            atext.envelope = JGeometry.load((STRUCT)extent);
        }
        STRUCT elemarray = (STRUCT)attrs[1];
        Datum[] elemattrs = null;
        if (elemarray != null && (elemattrs = elemarray.getOracleAttributes()) != null && (elems = (ARRAY)elemattrs[0]) != null && (delems = elems.getOracleArray()) != null) {
            JAXBContext jc = null;
            Unmarshaller u = null;
            Vector<AnnotationTextElement> aelems = new Vector<AnnotationTextElement>();
            for (int i = 0; i < delems.length; ++i) {
                STRUCT elem = (STRUCT)delems[i];
                Datum[] elemdata = elem.getOracleAttributes();
                if (elemdata == null) continue;
                AnnotationTextElement aelem = new AnnotationTextElement();
                if (elemdata[0] != null) {
                    aelem.setValue(elemdata[0].stringValue());
                }
                if (elemdata[1] != null) {
                    aelem.setLocation(JGeometry.load((STRUCT)((STRUCT)elemdata[1])));
                }
                if (elemdata[2] != null) {
                    aelem.setLeaderLine(JGeometry.load((STRUCT)((STRUCT)elemdata[2])));
                }
                if (elemdata[3] != null) {
                    try {
                        if (jc == null) {
                            jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                            u = jc.createUnmarshaller();
                        }
                        StringBuffer xmlStr = new StringBuffer(elemdata[3].stringValue());
                        JAXBElement jaxbEl = (JAXBElement)u.unmarshal((InputStream)new ByteArrayInputStream(xmlStr.toString().getBytes()));
                        TextAttributesType txtattrs = (TextAttributesType)jaxbEl.getValue();
                        aelem.setAttributes(txtattrs);
                    }
                    catch (Exception e) {
                        log.severe(e.getMessage());
                        log.info("Attributes for text element " + i + " are ignored.");
                    }
                }
                aelems.add(aelem);
            }
            atext.setElements(aelems);
        }
        return atext;
    }

    public STRUCT store(Connection conn, Object[] annotextDescriptors) throws SQLException {
        StructDescriptor annotextDesc = null;
        StructDescriptor annotextElemArrayDesc = null;
        ArrayDescriptor annottextElemArrayDesc = null;
        StructDescriptor annotextElemDesc = null;
        if (annotextDescriptors != null && annotextDescriptors.length == 4) {
            annotextDesc = (StructDescriptor)annotextDescriptors[0];
            annotextElemArrayDesc = (StructDescriptor)annotextDescriptors[1];
            annottextElemArrayDesc = (ArrayDescriptor)annotextDescriptors[2];
            annotextElemDesc = (StructDescriptor)annotextDescriptors[3];
        } else {
            annotextDesc = StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATION_TEXT", (Connection)conn);
            annotextElemArrayDesc = StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATIONTEXTELEMENT_ARRAY", (Connection)conn);
            annottextElemArrayDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.ST_ANNOT_TEXTELEMENT_ARRAY", (Connection)conn);
            annotextElemDesc = StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATIONTEXTELEMENT", (Connection)conn);
        }
        if (annotextDesc == null || annotextElemArrayDesc == null || annottextElemArrayDesc == null || annotextElemDesc == null) {
            throw new SQLException("st_annotation_text descriptors are not defined.");
        }
        STRUCT struct1 = null;
        if (this.envelope != null) {
            struct1 = JGeometry.store((JGeometry)this.envelope, (Connection)conn);
        }
        ARRAY attr2 = null;
        STRUCT[] elems = null;
        if (this.elements != null && this.elements.length > 0) {
            JAXBContext jc = null;
            Marshaller marsh = null;
            elems = new STRUCT[this.elements.length];
            CharacterSet cs = CharacterSet.make((int)-1);
            for (int i = 0; i < this.elements.length; ++i) {
                CHAR elem_attr1 = null;
                if (this.elements[i].getValue() != null) {
                    elem_attr1 = new CHAR(this.elements[i].getValue(), cs);
                }
                STRUCT elem_attr2 = null;
                if (this.elements[i].getLocation() != null) {
                    elem_attr2 = JGeometry.store((JGeometry)this.elements[i].getLocation(), (Connection)conn);
                }
                STRUCT elem_attr3 = null;
                if (this.elements[i].getLeaderLine() != null) {
                    elem_attr3 = JGeometry.store((JGeometry)this.elements[i].getLeaderLine(), (Connection)conn);
                }
                CHAR elem_attr4 = null;
                if (this.elements[i].getAttributes() != null) {
                    try {
                        if (jc == null) {
                            jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                            marsh = jc.createMarshaller();
                            marsh.setProperty("jaxb.formatted.output", (Object)true);
                        }
                        StringOutputStream attrstream = new StringOutputStream(null);
                        marsh.marshal((Object)new JAXBElement(new QName(null, "textAttributes"), TextAttributesType.class, (Object)this.elements[i].getAttributes()), (OutputStream)attrstream);
                        elem_attr4 = new CHAR(attrstream.getString(), cs);
                    }
                    catch (Exception e) {
                        log.severe(e.getMessage());
                        log.info("Unable to marshal attributes for text element " + i + ". Assigning null.");
                    }
                }
                Object[] attrs = new Object[]{elem_attr1, elem_attr2, elem_attr3, elem_attr4};
                elems[i] = new STRUCT(annotextElemDesc, conn, attrs);
            }
        }
        attr2 = new ARRAY(annottextElemArrayDesc, conn, elems);
        Object[] attr2obj = new Object[]{attr2};
        STRUCT struct2 = new STRUCT(annotextElemArrayDesc, conn, attr2obj);
        Object[] result = new Object[]{struct1, struct2};
        return new STRUCT(annotextDesc, conn, result);
    }

    public static Object[] getDBDescriptors(Connection conn) throws SQLException {
        if (conn == null) {
            return null;
        }
        Object[] objDesc = new Object[]{StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATION_TEXT", (Connection)conn), StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATIONTEXTELEMENT_ARRAY", (Connection)conn), ArrayDescriptor.createDescriptor((String)"MDSYS.ST_ANNOT_TEXTELEMENT_ARRAY", (Connection)conn), StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATIONTEXTELEMENT", (Connection)conn)};
        return objDesc;
    }

    public int getNumberOfElements() {
        if (this.elements == null) {
            return 0;
        }
        return this.elements.length;
    }

    public AnnotationTextElement[] getElements() {
        return this.elements;
    }

    public void setElements(AnnotationTextElement[] elems) {
        this.elements = elems;
    }

    public void setElements(Vector elems) {
        this.elements = elems == null || elems.size() == 0 ? null : elems.toArray(new AnnotationTextElement[elems.size()]);
    }

    public boolean addElement(AnnotationTextElement etext) {
        if (etext == null) {
            return false;
        }
        Vector<AnnotationTextElement> velems = new Vector<AnnotationTextElement>();
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                velems.add(this.elements[i]);
            }
        }
        velems.add(etext);
        this.setElements(velems);
        return true;
    }

    public boolean removeElement(int index) {
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (index < 0 || index >= this.elements.length) {
            return false;
        }
        Vector<AnnotationTextElement> velems = new Vector<AnnotationTextElement>();
        for (int i = 0; i < this.elements.length; ++i) {
            if (index == i) continue;
            velems.add(this.elements[i]);
        }
        this.setElements(velems);
        return true;
    }

    public JGeometry getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(JGeometry geom) {
        this.envelope = geom;
    }

    public Rectangle2D getMBR() {
        if (this.envelope == null || this.envelope.getMBR() == null) {
            return null;
        }
        double[] mbr = this.envelope.getMBR();
        Rectangle2D.Double out = new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]);
        return out;
    }

    public JGeometry getElementLocation(int index) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (index < 0 || index >= this.elements.length) {
            return null;
        }
        return this.elements[index].getLocation();
    }

    public boolean setElementLocation(int index, JGeometry location) {
        if (this.elements == null || this.elements.length == 0 || location == null) {
            return false;
        }
        if (index < 0 || index >= this.elements.length) {
            return false;
        }
        this.elements[index].setLocation(location);
        return true;
    }

    public JGeometry getElementLeaderLine(int index) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (index < 0 || index >= this.elements.length) {
            return null;
        }
        return this.elements[index].getLeaderLine();
    }

    public boolean setElementLeaderLine(int index, JGeometry leaderline) {
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (index < 0 || index >= this.elements.length) {
            return false;
        }
        this.elements[index].setLeaderLine(leaderline);
        return true;
    }

    public TextAttributesType getElementAttributes(int index) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (index < 0 || index >= this.elements.length) {
            return null;
        }
        return this.elements[index].getAttributes();
    }

    public TextAttributesType getOGCElementAttributes(int index, TextAttributesType metaAttributes) {
        TextAttributesType attrs = this.getElementAttributes(index);
        if (attrs == null) {
            return metaAttributes;
        }
        return attrs;
    }

    public boolean setElementAttributes(int index, TextAttributesType attrs) {
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (index < 0 || index >= this.elements.length) {
            return false;
        }
        this.elements[index].setAttributes(attrs);
        return true;
    }

    public String getElementValue(int index) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (index < 0 || index >= this.elements.length) {
            return null;
        }
        return this.elements[index].getValue();
    }

    public String getOGCElementValue(int index, String metaValue) {
        String value = this.getElementValue(index);
        if (value == null) {
            for (int i = index - 1; i > -1 && (value = this.getElementValue(i)) == null; --i) {
            }
        }
        if (value == null) {
            return metaValue;
        }
        return value;
    }

    public boolean setElementValue(int index, String value) {
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (index < 0 || index >= this.elements.length) {
            return false;
        }
        this.elements[index].setValue(value);
        return true;
    }

    public AnnotationTextElement getElement(int index) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (index < 0 || index >= this.elements.length) {
            return null;
        }
        return this.elements[index];
    }

    public JGeometry updateEnvelope(String metaValue, double metaScale, TextAttributesType metaAttributes, boolean isGeodetic, int Srid) {
        Rectangle2D mbr = this.getElementsMBR(metaValue, metaScale, metaAttributes, isGeodetic);
        if (mbr == null) {
            this.envelope = null;
        } else {
            double minX = mbr.getMinX();
            double maxX = mbr.getMaxX();
            double minY = mbr.getMinY();
            double maxY = mbr.getMaxY();
            this.envelope = new JGeometry(minX, minY, maxX, maxY, Srid);
        }
        return this.envelope;
    }

    public Rectangle2D getElementsMBR(String metaValue, double metaScale, TextAttributesType metaAttributes, boolean isGeodetic) {
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Rectangle2D embr = this.getElementMBR(i, metaValue, metaScale, metaAttributes, isGeodetic);
            if (embr == null) continue;
            if (i == 0) {
                xmin = embr.getMinX();
                xmax = embr.getMaxX();
                ymin = embr.getMinY();
                ymax = embr.getMaxY();
                continue;
            }
            xmin = Math.min(xmin, embr.getMinX());
            xmax = Math.max(xmax, embr.getMaxX());
            ymin = Math.min(ymin, embr.getMinY());
            ymax = Math.max(ymax, embr.getMaxY());
        }
        if (xmin > xmax || ymin > ymax) {
            return null;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return rect;
    }

    public Rectangle2D getElementMBR(int index, String metaValue, double metaScale, TextAttributesType metaAttributes, boolean isGeodetic) {
        Rectangle2D elemRect;
        double[] llMBR;
        JGeometry leaderline;
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (index < 0 || index >= this.elements.length) {
            return null;
        }
        JGeometry location = this.elements[index].getLocation();
        if (location == null) {
            return null;
        }
        double locx = 0.0;
        double locy = 0.0;
        double[] locMBR = location.getMBR();
        if (locMBR != null) {
            xmin = locMBR[0];
            xmax = locMBR[2];
            ymin = locMBR[1];
            ymax = locMBR[3];
            locx = xmin + (xmax - xmin) / 2.0;
            locy = ymin + (ymax - ymin) / 2.0;
        }
        if ((leaderline = this.elements[index].getLeaderLine()) != null && (llMBR = leaderline.getMBR()) != null) {
            xmin = Math.min(xmin, llMBR[0]);
            xmax = Math.max(xmax, llMBR[2]);
            ymin = Math.min(ymin, llMBR[1]);
            ymax = Math.max(ymax, llMBR[3]);
        }
        if ((elemRect = this.getElementValueMBR(index, metaValue, metaScale, metaAttributes, isGeodetic)) != null) {
            xmin = Math.min(xmin, elemRect.getMinX());
            xmax = Math.max(xmax, elemRect.getMaxX());
            ymin = Math.min(ymin, elemRect.getMinY());
            ymax = Math.max(ymax, elemRect.getMaxY());
        }
        if (xmin > xmax || ymin > ymax) {
            return null;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return rect;
    }

    public Rectangle2D getElementValueMBR(int index, String metaValue, double metaScale, TextAttributesType metaAttributes, boolean isGeodetic) {
        Rectangle2D.Double mbr = null;
        if (Double.isNaN(metaScale) || metaScale < 1.0) {
            return mbr;
        }
        JGeometry location = this.getElementLocation(index);
        String value = this.getOGCElementValue(index, metaValue);
        if (value != null && location != null) {
            StyleText elemStyle;
            TextAttributesType elemAttrs;
            double[] locMBR;
            double locx = 0.0;
            double locy = 0.0;
            if (location != null && (locMBR = location.getMBR()) != null) {
                locx = locMBR[0] + (locMBR[2] - locMBR[0]) / 2.0;
                locy = locMBR[3] + (locMBR[3] - locMBR[1]) / 2.0;
            }
            if ((elemAttrs = this.getOGCElementAttributes(index, metaAttributes)) != null && (elemStyle = AnnotationTextThemeProducer.getTextStyle(elemAttrs)) != null && elemStyle.getFont() != null) {
                double inmeter;
                Shape shp = StyleText.getStringOutline(value, (TextStyleModel)elemStyle.getModel(), null);
                Rectangle2D textRect = shp.getBounds2D();
                double pxsize = inmeter = metaScale * 0.0254 / SRS.getDPI();
                if (isGeodetic) {
                    pxsize = SphereCG.convertRadius(0.0, 0.0, inmeter);
                }
                double sx = locx;
                double sy = locy;
                LabelingHints hints = ((TextStyleModel)elemStyle.getModel()).getLabelingHints();
                Object halign = hints.get(LabelingHints.KEY_OPOINT_HALIGN);
                Object valign = hints.get(LabelingHints.KEY_OPOINT_VALIGN);
                if (halign == null) {
                    halign = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
                }
                if (valign == null) {
                    valign = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
                }
                double w = textRect.getWidth() * pxsize;
                double h = textRect.getHeight() * pxsize;
                double cx = 0.0;
                double cy = 0.0;
                cx = LabelingHints.VALUE_OPOINT_HALIGN_CENTER == halign ? sx : (LabelingHints.VALUE_OPOINT_HALIGN_START == halign ? sx + w / 2.0 : sx - w / 2.0);
                cy = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE == valign ? sy : (LabelingHints.VALUE_OPOINT_VALIGN_TOP == valign ? sy - h / 2.0 : sy + h / 2.0);
                mbr = new Rectangle2D.Double(cx - w / 2.0, cy - h / 2.0, w, h);
                if (location.isOrientedPoint()) {
                    double[] rotmbr;
                    JGeometry mbrGeom = new JGeometry(cx - w / 2.0, cy - h / 2.0, cx + w / 2.0, cy + h / 2.0, location.getSRID());
                    double[] oords = location.getOrdinatesArray();
                    int dim = location.getDimensions();
                    double angle = Math.atan2(oords[dim + 1], oords[dim]);
                    JGeometry rotGeom = Util.rotateGeometry(mbrGeom, sx, sy, angle = angle * 180.0 / Math.PI);
                    if (rotGeom != null && (rotmbr = rotGeom.getMBR()) != null) {
                        mbr = new Rectangle2D.Double(rotmbr[0], rotmbr[1], rotmbr[2] - rotmbr[0], rotmbr[3] - rotmbr[1]);
                    }
                }
            }
        }
        return mbr;
    }

    public Rectangle2D getElementsMBR(String metaValue, TextAttributesType metaAttributes, double pixelResolution) {
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Rectangle2D embr = this.getElementMBR(i, metaValue, metaAttributes, pixelResolution);
            if (embr == null) continue;
            if (i == 0) {
                xmin = embr.getMinX();
                xmax = embr.getMaxX();
                ymin = embr.getMinY();
                ymax = embr.getMaxY();
                continue;
            }
            xmin = Math.min(xmin, embr.getMinX());
            xmax = Math.max(xmax, embr.getMaxX());
            ymin = Math.min(ymin, embr.getMinY());
            ymax = Math.max(ymax, embr.getMaxY());
        }
        if (xmin > xmax || ymin > ymax) {
            return null;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return rect;
    }

    public Rectangle2D getElementMBR(int index, String metaValue, TextAttributesType metaAttributes, double pixelResolution) {
        Rectangle2D elemRect;
        double[] llMBR;
        JGeometry leaderline;
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (index < 0 || index >= this.elements.length) {
            return null;
        }
        JGeometry location = this.elements[index].getLocation();
        if (location == null) {
            return null;
        }
        double locx = 0.0;
        double locy = 0.0;
        double[] locMBR = location.getMBR();
        if (locMBR != null) {
            xmin = locMBR[0];
            xmax = locMBR[2];
            ymin = locMBR[1];
            ymax = locMBR[3];
            locx = xmin + (xmax - xmin) / 2.0;
            locy = ymin + (ymax - ymin) / 2.0;
        }
        if ((leaderline = this.elements[index].getLeaderLine()) != null && (llMBR = leaderline.getMBR()) != null) {
            xmin = Math.min(xmin, llMBR[0]);
            xmax = Math.max(xmax, llMBR[2]);
            ymin = Math.min(ymin, llMBR[1]);
            ymax = Math.max(ymax, llMBR[3]);
        }
        if ((elemRect = this.getElementValueMBR(index, metaValue, metaAttributes, pixelResolution)) != null) {
            xmin = Math.min(xmin, elemRect.getMinX());
            xmax = Math.max(xmax, elemRect.getMaxX());
            ymin = Math.min(ymin, elemRect.getMinY());
            ymax = Math.max(ymax, elemRect.getMaxY());
        }
        if (xmin > xmax || ymin > ymax) {
            return null;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return rect;
    }

    public Rectangle2D getElementValueMBR(int index, String metaValue, TextAttributesType metaAttributes, double pixelResolution) {
        Rectangle2D.Double mbr = null;
        if (Double.isNaN(pixelResolution) || pixelResolution <= 0.0) {
            return mbr;
        }
        JGeometry location = this.getElementLocation(index);
        String value = this.getOGCElementValue(index, metaValue);
        if (value != null && location != null) {
            StyleText elemStyle;
            TextAttributesType elemAttrs;
            double[] locMBR;
            double locx = 0.0;
            double locy = 0.0;
            if (location != null && (locMBR = location.getMBR()) != null) {
                locx = locMBR[0] + (locMBR[2] - locMBR[0]) / 2.0;
                locy = locMBR[3] + (locMBR[3] - locMBR[1]) / 2.0;
            }
            if ((elemAttrs = this.getOGCElementAttributes(index, metaAttributes)) != null && (elemStyle = AnnotationTextThemeProducer.getTextStyle(elemAttrs)) != null && elemStyle.getFont() != null) {
                Shape shp = StyleText.getStringOutline(value, (TextStyleModel)elemStyle.getModel(), null);
                Rectangle2D textRect = shp.getBounds2D();
                double sx = locx;
                double sy = locy;
                LabelingHints hints = ((TextStyleModel)elemStyle.getModel()).getLabelingHints();
                Object halign = hints.get(LabelingHints.KEY_OPOINT_HALIGN);
                Object valign = hints.get(LabelingHints.KEY_OPOINT_VALIGN);
                if (halign == null) {
                    halign = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
                }
                if (valign == null) {
                    valign = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
                }
                double w = textRect.getWidth() * pixelResolution;
                double h = textRect.getHeight() * pixelResolution;
                double cx = 0.0;
                double cy = 0.0;
                cx = LabelingHints.VALUE_OPOINT_HALIGN_CENTER == halign ? sx : (LabelingHints.VALUE_OPOINT_HALIGN_START == halign ? sx + w / 2.0 : sx - w / 2.0);
                cy = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE == valign ? sy : (LabelingHints.VALUE_OPOINT_VALIGN_TOP == valign ? sy - h / 2.0 : sy + h / 2.0);
                mbr = new Rectangle2D.Double(cx - w / 2.0, cy - h / 2.0, w, h);
                if (location.isOrientedPoint()) {
                    double[] rotmbr;
                    JGeometry mbrGeom = new JGeometry(cx - w / 2.0, cy - h / 2.0, cx + w / 2.0, cy + h / 2.0, location.getSRID());
                    double[] oords = location.getOrdinatesArray();
                    int dim = location.getDimensions();
                    double angle = Math.atan2(oords[dim + 1], oords[dim]);
                    JGeometry rotGeom = Util.rotateGeometry(mbrGeom, sx, sy, angle = angle * 180.0 / Math.PI);
                    if (rotGeom != null && (rotmbr = rotGeom.getMBR()) != null) {
                        mbr = new Rectangle2D.Double(rotmbr[0], rotmbr[1], rotmbr[2] - rotmbr[0], rotmbr[3] - rotmbr[1]);
                    }
                }
            }
        }
        return mbr;
    }

    public String toXML() {
        StringBuilder xml = new StringBuilder("<annotation_text>\n");
        if (this.getEnvelope() != null) {
            try {
                String envelopeGML = GMLGeometryUtils.toGML(this.getEnvelope());
                if (envelopeGML != null && !envelopeGML.isEmpty()) {
                    xml.append("\t<envelope>\n");
                    xml.append("\t\t" + envelopeGML + "\n");
                    xml.append("\t</envelope>\n");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.getNumberOfElements() > 0) {
            JAXBContext jc = null;
            Marshaller marsh = null;
            xml.append("\t<elements>\n");
            for (AnnotationTextElement element : this.getElements()) {
                String gml;
                xml.append("\t\t<element>\n");
                if (element.getLocation() != null) {
                    try {
                        gml = GMLGeometryUtils.toGML(element.getLocation());
                        if (gml != null && !gml.isEmpty()) {
                            xml.append("\t\t\t<location>\n");
                            xml.append("\t\t\t\t" + gml + "\n");
                            xml.append("\t\t\t</location>\n");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (element.getValue() != null) {
                    xml.append("\t\t\t<text_value>" + element.getValue() + "</text_value>\n");
                }
                if (element.getLeaderLine() != null) {
                    try {
                        gml = GMLGeometryUtils.toGML(element.getLeaderLine());
                        if (gml != null && !gml.isEmpty()) {
                            xml.append("\t\t\t<leader_line>\n");
                            xml.append("\t\t\t\t" + gml + "\n");
                            xml.append("\t\t\t</leader_line>\n");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (element.getAttributes() != null) {
                    try {
                        if (jc == null) {
                            jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                            marsh = jc.createMarshaller();
                            marsh.setProperty("jaxb.formatted.output", (Object)true);
                        }
                        StringOutputStream attrstream = new StringOutputStream(null);
                        marsh.marshal((Object)new JAXBElement(new QName(null, "textAttributes"), TextAttributesType.class, (Object)element.getAttributes()), (OutputStream)attrstream);
                        String textAttrs = attrstream.getString();
                        if (textAttrs != null && !textAttrs.isEmpty()) {
                            xml.append("\t\t\t<text_attributes>\n");
                            xml.append("\t\t\t\t<![CDATA[" + textAttrs + "]]>\n");
                            xml.append("\t\t\t</text_attributes>\n");
                        }
                    }
                    catch (JAXBException ex) {
                        ex.printStackTrace();
                    }
                }
                xml.append("\t\t</element>\n");
            }
            xml.append("\t</elements>\n");
        }
        xml.append("</annotation_text>");
        return xml.toString();
    }

    public static AnnotationText fromXMLNodeToAnnotationText(Node atextNode) throws Exception {
        Node elementsNode;
        JAXBContext jc = null;
        Unmarshaller u = null;
        if (atextNode == null) {
            return null;
        }
        String nodeName = atextNode.getNodeName();
        if (nodeName == null) {
            return null;
        }
        if (nodeName.indexOf(":") >= 0) {
            nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
        }
        if (!nodeName.equalsIgnoreCase("annotation_text")) {
            return null;
        }
        AnnotationText atext = new AnnotationText();
        Node envelopeNode = XMLDOMParser.getSubElement(atextNode, "envelope");
        if (envelopeNode != null) {
            JGeometry envelope = null;
            if (envelopeNode.getFirstChild() != null) {
                envelope = GMLGeometryUtils.parseGML(envelopeNode);
                atext.setEnvelope(envelope);
            }
        }
        if ((elementsNode = XMLDOMParser.getSubElement(atextNode, "elements")) == null) {
            return atext;
        }
        ArrayList childElements = XMLDOMParser.getSubElements(elementsNode, "element");
        if (childElements != null && childElements.size() > 0) {
            for (int i = 0; i < childElements.size(); ++i) {
                Node leaderlineNode;
                Node textvalueNode;
                Node child = (Node)childElements.get(i);
                AnnotationTextElement elem = new AnnotationTextElement();
                Node locationNode = XMLDOMParser.getSubElement(child, "location");
                if (locationNode != null) {
                    JGeometry geom = null;
                    if (locationNode.getFirstChild() != null) {
                        geom = GMLGeometryUtils.parseGML(locationNode);
                        elem.setLocation(geom);
                    }
                }
                if ((textvalueNode = XMLDOMParser.getSubElement(child, "text_value")) != null && textvalueNode.getFirstChild() != null) {
                    elem.setValue(textvalueNode.getFirstChild().getNodeValue());
                }
                if ((leaderlineNode = XMLDOMParser.getSubElement(child, "leader_line")) != null) {
                    JGeometry geom = null;
                    if (leaderlineNode.getFirstChild() != null) {
                        geom = GMLGeometryUtils.parseGML(leaderlineNode);
                        elem.setLeaderLine(geom);
                    }
                }
                Node textattrsNode = XMLDOMParser.getSubElement(child, "text_attributes");
                String textAttrs = null;
                if (textattrsNode != null && textattrsNode.getFirstChild() != null) {
                    textAttrs = textattrsNode.getFirstChild().getNodeValue();
                }
                if (textAttrs != null) {
                    textAttrs = textAttrs.trim();
                    try {
                        StringBuffer xmlStr;
                        JAXBElement jaxbEl;
                        if (jc == null) {
                            jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                            u = jc.createUnmarshaller();
                        }
                        if ((jaxbEl = (JAXBElement)u.unmarshal((InputStream)new ByteArrayInputStream((xmlStr = new StringBuffer(textAttrs)).toString().getBytes()))) != null) {
                            TextAttributesType txtattrs = (TextAttributesType)jaxbEl.getValue();
                            elem.setAttributes(txtattrs);
                        }
                    }
                    catch (Exception e) {
                        log.warning("Text attributes of element [" + i + "]. " + e.getMessage());
                    }
                }
                atext.addElement(elem);
            }
        }
        return atext;
    }
}

