/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.style.LineStyleModel;
import oracle.mapviewer.share.style.MarkerStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.stylex.AbstractBucketStyleModel;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.BucketStyleModel;
import oracle.mapviewer.share.stylex.CollectionBucket;
import oracle.mapviewer.share.stylex.PieChartStyleModel;
import oracle.mapviewer.share.stylex.RangedBucket;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CasedLineHelper;
import oracle.sdovis.DataException;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.PieChartStyleModifiers;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BucketStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final int EQUALRANGED = 1;
    public static final int RANGEDBUCKET = 2;
    public static final int COLLECTIONBUCKET = 3;
    private static FontRenderContext frc = new FontRenderContext(null, true, false);
    protected AbstractBucketStyleModel bean;
    double equalRangeMin = 0.0;
    double equalRangeMax = 0.0;
    private boolean hasCasedLineStyles = false;

    public BucketStyle() {
        this.bean = new BucketStyleModel();
    }

    public BucketStyle(BucketSeries bkts) {
        this.bean = new BucketStyleModel(bkts);
    }

    public BucketStyle(StyleModel model) {
        this.setModel(model);
    }

    public BucketStyle(Document doc) throws StyleException {
        this.bean = new BucketStyleModel();
        try {
            Node node = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
            node = XMLDOMParser.getSubElement(node, "BucketStyle");
            node = XMLDOMParser.getSubElement(node, "Buckets");
            BucketStyle.fetchBuckets(node, this.bean.getBucketSeries());
        }
        catch (Exception e) {
            throw new StyleException("Invalid Bucket style definition.");
        }
    }

    public Object clone() {
        try {
            BucketStyle sty = (BucketStyle)super.clone();
            sty.setModel((StyleModel)this.bean.clone());
            return sty;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public void setDefaultStyleName(String defStyle) {
        this.bean.getBucketSeries().setDefaultRenderStyleName(defStyle);
        this.bean.getBucketSeries().setDefaultRenderStyle(null);
    }

    public void setDefaultStyle(Style sty) {
        this.bean.getBucketSeries().setDefaultRenderStyleName(null);
        this.bean.getBucketSeries().setDefaultRenderStyle(sty);
    }

    public Style getDefaultStyle() {
        return (Style)this.bean.getBucketSeries().getDefaultRenderStyle();
    }

    public String getDefaultStyleName() {
        return this.bean.getBucketSeries().getDefaultRenderStyleName();
    }

    public static BucketSeries fetchBuckets(Node elem, BucketSeries buckets) {
        String defLabelStyleName;
        boolean equalranged = false;
        ArrayList nl = XMLDOMParser.getRealChildNodes(elem);
        int nBuckets = 0;
        Node aNode = null;
        nBuckets = nl != null ? nl.size() : 0;
        if (nBuckets == 0) {
            equalranged = true;
            nBuckets = Integer.parseInt(XMLDOMParser.getAttribute(elem, "nbuckets"));
        }
        if (buckets == null) {
            buckets = new BucketSeries();
        } else {
            buckets.removeAll();
        }
        String defStyleName = XMLDOMParser.getAttribute(elem, "default_style");
        if (defStyleName != null && defStyleName.length() > 0) {
            buckets.setDefaultRenderStyleName(defStyleName);
        }
        if ((defLabelStyleName = XMLDOMParser.getAttribute(elem, "default_label_style")) != null && defLabelStyleName.length() > 0) {
            buckets.setDefaultLabelStyleName(defLabelStyleName);
        }
        if (equalranged) {
            int i;
            String[] styleNames;
            ArrayList al;
            double low = Double.parseDouble(XMLDOMParser.getAttribute(elem, "low"));
            double high = Double.parseDouble(XMLDOMParser.getAttribute(elem, "high"));
            String stylenames = XMLDOMParser.getAttribute(elem, "styles");
            buckets.setupEqualRangedBuckets(low, high, nBuckets);
            if (stylenames != null && stylenames.length() > 0) {
                al = Util.splitBy(stylenames, ",");
                styleNames = al.toArray(new String[al.size()]);
                for (i = 0; i < styleNames.length; ++i) {
                    buckets.getBucketById("" + i).setRenderStyleName(styleNames[i]);
                }
            }
            if ((stylenames = XMLDOMParser.getAttribute(elem, "label_styles")) != null && stylenames.length() > 0) {
                al = Util.splitBy(stylenames, ",");
                styleNames = al.toArray(new String[al.size()]);
                for (i = 0; i < styleNames.length; ++i) {
                    buckets.getBucketById("" + i).setLabelStyleName(styleNames[i]);
                }
            }
            buckets.setScheme(2);
        } else {
            buckets.setScheme(1);
            for (int i = 0; i < nBuckets; ++i) {
                String label;
                Node e = (Node)nl.get(i);
                if (e.getNodeName().equalsIgnoreCase("RangedBucket")) {
                    String highstr;
                    label = XMLDOMParser.getAttribute(e, "label");
                    Field low = null;
                    Field high = null;
                    String lowstr = XMLDOMParser.getAttribute(e, "low");
                    if (lowstr != null && lowstr.length() > 0) {
                        low = new Field(Double.parseDouble(lowstr));
                    }
                    if ((highstr = XMLDOMParser.getAttribute(e, "high")) != null && highstr.length() > 0) {
                        high = new Field(Double.parseDouble(highstr));
                    }
                    RangedBucket rb = new RangedBucket("" + i, low, high);
                    if (label != null && label.length() > 0) {
                        rb.setBucketLabel(label);
                    }
                    buckets.add(rb);
                    String stystr = XMLDOMParser.getAttribute(e, "style");
                    if (stystr != null && stystr.length() > 0) {
                        rb.setRenderStyleName(stystr);
                    }
                    if ((stystr = XMLDOMParser.getAttribute(e, "label_style")) == null || stystr.length() <= 0) continue;
                    rb.setLabelStyleName(stystr);
                    continue;
                }
                if (!e.getNodeName().equalsIgnoreCase("CollectionBucket")) continue;
                label = XMLDOMParser.getAttribute(e, "label");
                String delim = XMLDOMParser.getAttribute(e, "delimiter");
                String type = XMLDOMParser.getAttribute(e, "type");
                boolean keepWS = false;
                String keepWS_ = XMLDOMParser.getAttribute(e, "keep_white_space");
                if (keepWS_ != null && keepWS_.length() > 0 && "TRUE".equalsIgnoreCase(keepWS_)) {
                    keepWS = true;
                }
                if (delim == null || delim.length() == 0) {
                    delim = ",";
                }
                aNode = e.getFirstChild();
                String els = keepWS ? aNode.getNodeValue() : aNode.getNodeValue().trim();
                ArrayList al = Util.splitBy(els, delim);
                ArrayList<Field> al2 = new ArrayList<Field>(al.size());
                if (al.size() > 0) {
                    for (int k = 0; k < al.size(); ++k) {
                        String sv;
                        String string = sv = keepWS ? (String)al.get(k) : ((String)al.get(k)).trim();
                        if (sv.toUpperCase().indexOf("#DEFAULT#") == 0) {
                            sv = "#DEFAULT#";
                        }
                        al2.add(Field.createField(sv, type));
                    }
                } else {
                    String sv = els;
                    if (sv.toUpperCase().indexOf("#DEFAULT#") == 0) {
                        sv = "#DEFAULT#";
                    }
                    al2.add(Field.createField(sv, type));
                }
                CollectionBucket cb = new CollectionBucket("" + i, al2);
                if (label != null && label.length() > 0) {
                    cb.setBucketLabel(label);
                }
                buckets.add(cb);
                String stystr = XMLDOMParser.getAttribute(e, "style");
                if (stystr != null && stystr.length() > 0) {
                    cb.setRenderStyleName(stystr);
                }
                if ((stystr = XMLDOMParser.getAttribute(e, "label_style")) != null && stystr.length() > 0) {
                    cb.setLabelStyleName(stystr);
                }
                cb.setDelimiter(delim);
                cb.setType(type);
                cb.setKeepWhiteSpace(keepWS);
            }
        }
        return buckets;
    }

    public double getEqualRangeMinValue() {
        return this.equalRangeMin;
    }

    public double getEqualRangeMaxValue() {
        return this.equalRangeMax;
    }

    public void addBucket(Bucket bkt) {
        this.bean.getBucketSeries().add(bkt);
    }

    public void linkStyleToBucket(Style sty, String id) {
        Bucket bkt = this.bean.getBucketSeries().getBucketById(id);
        if (bkt != null) {
            bkt.setRenderStyle(sty);
        }
    }

    public void linkLabelStyleToBucket(Style sty, String id) {
        Bucket bkt = this.bean.getBucketSeries().getBucketById(id);
        if (bkt != null) {
            bkt.setLabelStyle(sty);
        }
    }

    public int getNumBuckets() {
        return this.bean.getBucketSeries().size();
    }

    public Bucket getBucketById(String id) {
        return this.bean.getBucketSeries().getBucketById(id);
    }

    public Bucket getBucket(int index) {
        return this.bean.getBucketSeries().getBucket(index);
    }

    public int getBucketIndex(Field value) {
        return this.bean.getBucketSeries().getBucketIndex(value);
    }

    public Style chooseStyle(Field value) {
        Bucket bkt = this.pickBucket(value);
        if (bkt == null) {
            return (Style)this.bean.getBucketSeries().getDefaultRenderStyle();
        }
        return (Style)bkt.getRenderStyle();
    }

    public Style chooseLabelStyle(Field value) {
        Bucket bkt = this.pickBucket(value);
        if (bkt == null) {
            return (Style)this.bean.getBucketSeries().getDefaultLabelStyle();
        }
        return (Style)bkt.getLabelStyle();
    }

    public boolean hasCasedLineStyles() {
        return this.hasCasedLineStyles;
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        this.hasCasedLineStyles = false;
        boolean res = true;
        if (this.bean.getBucketSeries().size() == 0) {
            return true;
        }
        ArrayList list = this.bean.getBucketSeries().getBuckets();
        for (int i = 0; i < list.size(); ++i) {
            Style sty;
            Bucket bkt = (Bucket)list.get(i);
            String name = bkt.getRenderStyleName();
            if (name != null) {
                sty = Util.getStyle(name, sc, dynaStyles);
                if (sty != null) {
                    bkt.setRenderStyle(sty);
                    if (!(sty instanceof AdvancedStyle)) {
                        sty.resolveStyles(sc, dynaStyles);
                    }
                    if (sty instanceof StyleLine && ((StyleLine)sty).supportCasedLine()) {
                        this.hasCasedLineStyles = true;
                    }
                } else {
                    res = false;
                }
            }
            if ((name = bkt.getLabelStyleName()) == null) continue;
            sty = Util.getStyle(name, sc, dynaStyles);
            if (sty != null) {
                bkt.setLabelStyle(sty);
                if (sty instanceof AdvancedStyle) continue;
                sty.resolveStyles(sc, dynaStyles);
                continue;
            }
            res = false;
        }
        String defaultStyleName = this.bean.getBucketSeries().getDefaultRenderStyleName();
        Style defaultStyle = (Style)this.bean.getBucketSeries().getDefaultRenderStyle();
        if (defaultStyleName != null && defaultStyle == null) {
            defaultStyle = Util.getStyle(defaultStyleName, sc, dynaStyles);
            this.bean.getBucketSeries().setDefaultRenderStyle(defaultStyle);
        }
        if (defaultStyle != null && !(defaultStyle instanceof AdvancedStyle)) {
            defaultStyle.resolveStyles(sc, dynaStyles);
        }
        defaultStyleName = this.bean.getBucketSeries().getDefaultLabelStyleName();
        defaultStyle = (Style)this.bean.getBucketSeries().getDefaultLabelStyle();
        if (defaultStyleName != null && defaultStyle == null) {
            defaultStyle = Util.getStyle(defaultStyleName, sc, dynaStyles);
            this.bean.getBucketSeries().setDefaultLabelStyle(defaultStyle);
        }
        if (defaultStyle != null && !(defaultStyle instanceof AdvancedStyle)) {
            defaultStyle.resolveStyles(sc, dynaStyles);
        }
        return res;
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        if (this.bean.getBucketSeries() == null || this.bean.getBucketSeries().size() == 0) {
            return true;
        }
        ArrayList list = this.bean.getBucketSeries().getBuckets();
        for (int i = 0; i < list.size(); ++i) {
            Bucket bkt = (Bucket)list.get(i);
            Style sty = (Style)bkt.getRenderStyle();
            if (sty != null && !(sty instanceof AdvancedStyle)) {
                sty.refreshResolvedStyles(sc, dynaStyles);
                bkt.setRenderStyle(null);
            }
            if ((sty = (Style)bkt.getLabelStyle()) == null || sty instanceof AdvancedStyle) continue;
            sty.refreshResolvedStyles(sc, dynaStyles);
            bkt.setLabelStyle(null);
        }
        this.bean.getBucketSeries().setDefaultRenderStyle(null);
        this.bean.getBucketSeries().setDefaultLabelStyle(null);
        return this.resolveStyles(sc, dynaStyles);
    }

    public Bucket pickBucket(Field value) {
        return this.bean.getBucketSeries().getBucket(value);
    }

    public Style getStyle(String bucketId) {
        Bucket bkt = this.bean.getBucketSeries().getBucketById(bucketId);
        if (bkt != null) {
            return (Style)bkt.getRenderStyle();
        }
        return null;
    }

    public Style getLabelStyle(String bucketId) {
        Bucket bkt = this.bean.getBucketSeries().getBucketById(bucketId);
        if (bkt != null) {
            return (Style)bkt.getLabelStyle();
        }
        return null;
    }

    @Override
    public int getMaxLegendWidth(Graphics2D g, int fontSize) {
        Font defaultFont;
        int curWidth = 0;
        int maxWidth = 0;
        Font theFont = defaultFont = new Font("Serif", 0, fontSize);
        String label = null;
        Style labelStyle = null;
        int maxMarkerWidth = 0;
        StyleModifiers stymods = this.convertToPixelSize(null);
        for (int i = 0; i < this.getNumBuckets(); ++i) {
            StyleModifiers smods;
            int w;
            Bucket bucket = this.bean.getBucketSeries().getBucket(i);
            Style sty = (Style)bucket.getRenderStyle();
            if (sty != null && this instanceof VariableMarkerStyle && stymods != null) {
                w = ((StyleMarker)sty).getDesiredWidth();
                String basemarker = ((VariableMarkerStyle)this).getBaseMarkerName();
                StyleModifiers smods2 = ((AdvancedStyleModifiers)stymods).getStyleModifiers(basemarker.toUpperCase() + "_" + i);
                if (smods2 != null && smods2 instanceof MarkerStyleModifiers) {
                    w = ((MarkerStyleModifiers)smods2).getWidth();
                }
                if (maxMarkerWidth < w) {
                    maxMarkerWidth = w;
                }
            } else if (sty != null && this instanceof VariablePieChartStyle && stymods != null) {
                w = ((PieChartStyle)sty).getPieRadius() * 2;
                smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers("PIECHART_" + i);
                if (smods != null && smods instanceof PieChartStyleModifiers) {
                    w = ((PieChartStyleModifiers)smods).getPieRadius() * 2;
                }
                if (maxMarkerWidth < w) {
                    maxMarkerWidth = w;
                }
            } else if (sty != null && sty instanceof StyleMarker) {
                w = ((StyleMarker)sty).getDesiredWidth();
                if (stymods != null && stymods instanceof AdvancedStyleModifiers && (smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(this.bean.getBucketSeries().getBucket(i).getRenderStyleName().toUpperCase() + "_" + i)) != null && smods instanceof MarkerStyleModifiers) {
                    w = ((MarkerStyleModifiers)smods).getWidth();
                }
                if (maxMarkerWidth < w) {
                    maxMarkerWidth = w;
                }
            }
            label = bucket.getBucketLabel();
            if (label == null || label.length() == 0) continue;
            label = label + " ";
            labelStyle = (Style)bucket.getLabelStyle();
            theFont = labelStyle != null && labelStyle instanceof StyleText ? ((StyleText)labelStyle).getFont() : defaultFont;
            curWidth = g != null ? (int)theFont.getStringBounds(label, g.getFontRenderContext()).getWidth() : (int)theFont.getStringBounds(label, frc).getWidth();
            if (curWidth <= maxWidth) continue;
            maxWidth = curWidth;
        }
        double styW = (double)maxWidth / 0.8 * 0.2 + 3.0;
        maxWidth = (double)maxMarkerWidth > styW ? (maxWidth += maxMarkerWidth + 3) : (int)((double)maxWidth + styW);
        return maxWidth;
    }

    public void print() {
        int nBuckets = this.bean.getBucketSeries().size();
        String[] types = new String[]{"UNDEFINEDBUCKET", "EQUALRANGED", "RANGEDBUCKET", "COLLECTIONBUCKET"};
        System.out.println("Bucket contents:");
        System.out.println("#buckets: " + nBuckets);
        for (int i = 0; i < nBuckets; ++i) {
            String haslabel = "";
            String hasstyle = "";
            Bucket bucket = this.bean.getBucketSeries().getBucket(i);
            if (bucket.getBucketLabel() != null) {
                haslabel = bucket.getBucketLabel();
            }
            hasstyle = bucket.getRenderStyleName();
            System.out.println("  " + i + " - label: " + haslabel + "  style: " + hasstyle + "\n");
        }
    }

    public static AdvancedStyle create(Document doc, StyleCache sc, Hashtable dynaStyles) throws DataException {
        return null;
    }

    public static AdvancedStyle create(Document doc, StyleTable st) throws DataException {
        return null;
    }

    public static String[] getStyleNames(Document doc) throws DataException {
        return new String[0];
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof BucketStyleModel)) {
            throw new IllegalArgumentException("Not a BucketStyleModel instance.");
        }
        this.bean = (BucketStyleModel)model;
    }

    protected void drawBucketWithLabel(Graphics2D g, Bucket bucket, Rectangle2D rect, float styPercentage, float lblPercentage, StyleModifiers stymods) throws StyleNotApplicableException {
        String label;
        double h = rect.getHeight();
        double w = rect.getWidth();
        Style sty = (Style)bucket.getRenderStyle();
        if (sty != null) {
            Rectangle2D.Double srect = new Rectangle2D.Double(rect.getMinX(), rect.getMinY(), w * (double)styPercentage, h);
            sty.apply(null, g, srect, stymods);
        }
        if ((label = bucket.getBucketLabel()) == null) {
            return;
        }
        Style labelStyle = (Style)bucket.getLabelStyle();
        LineMetrics theLM = null;
        int theAscent = 0;
        int textHeight = 0;
        if (labelStyle == null || !(labelStyle instanceof StyleText)) {
            Font theFont = null;
            theFont = h < 10.0 ? new Font("Serif", 0, 9) : new Font("Serif", 0, 10);
            g.setFont(theFont);
            theLM = theFont.getLineMetrics(label, g.getFontRenderContext());
            theAscent = (int)theLM.getAscent();
            textHeight = (int)theLM.getHeight();
            g.setColor(Color.black);
            int x = 0;
            x = lblPercentage <= 0.0f ? (int)(rect.getMinX() + w * (double)styPercentage + 3.0) : (int)(rect.getMaxX() - w * (double)lblPercentage + 3.0);
            int spaceShift = (int)(h - (double)textHeight) / 2;
            if (spaceShift < 0) {
                spaceShift = 0;
            }
            int y = (int)(rect.getMinY() + (double)theAscent + (double)spaceShift);
            g.drawString(label, x, y);
        } else {
            Font oldFont = ((StyleText)labelStyle).getFont();
            Font newFont = null;
            Color oldColor = null;
            float oldFW = -1.0f;
            if (h <= (double)oldFont.getSize()) {
                StyleText stx = (StyleText)labelStyle;
                newFont = new Font(oldFont.getName(), oldFont.getStyle(), (int)h);
                oldColor = stx.getColor();
                oldFW = ((TextStyleModel)stx.getModel()).getHaloWidth();
                labelStyle = new StyleText(newFont, oldColor, oldFW);
            } else {
                newFont = oldFont;
            }
            g.setFont(newFont);
            int x = 0;
            x = lblPercentage <= 0.0f ? (int)(rect.getMinX() + w * (double)styPercentage + 3.0) : (int)(rect.getMaxX() - w * (double)lblPercentage + 3.0);
            int y = (int)(rect.getMinY() + rect.getHeight() / 2.0);
            ((StyleText)labelStyle).apply(g, x, y, LabelingHints.VALUE_OPOINT_HALIGN_START, 0.0, 0, label, null);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply BucketStyle to a point.");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        int nBuckets = this.bean.getBucketSeries().size();
        try {
            StyleModifiers smods;
            double sx = rect.getMinX();
            double sy = rect.getMinY();
            double incr = (rect.getHeight() - 4.0) / (double)nBuckets;
            int maxMarkerW = 0;
            for (int i = 0; i < nBuckets; ++i) {
                int mw;
                Style sty = (Style)this.bean.getBucketSeries().getBucket(i).getRenderStyle();
                if (sty != null && sty instanceof StyleMarker) {
                    mw = ((StyleMarker)sty).getDesiredWidth();
                    if (stymods != null && stymods instanceof AdvancedStyleModifiers && (smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(this.bean.getBucketSeries().getBucket(i).getRenderStyleName().toUpperCase() + "_" + i)) != null && smods instanceof MarkerStyleModifiers) {
                        mw = ((MarkerStyleModifiers)smods).getWidth();
                    }
                    if (maxMarkerW >= mw) continue;
                    maxMarkerW = mw;
                    continue;
                }
                if (sty == null || !(sty instanceof PieChartStyle)) continue;
                mw = ((PieChartStyle)sty).getPieRadius() * 2;
                if (stymods != null && stymods instanceof AdvancedStyleModifiers && (smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(this.bean.getBucketSeries().getBucket(i).getRenderStyleName().toUpperCase() + "_" + i)) != null && smods instanceof PieChartStyleModifiers) {
                    mw = ((PieChartStyleModifiers)smods).getPieRadius() * 2;
                }
                if (maxMarkerW >= mw) continue;
                maxMarkerW = mw;
            }
            float styPercentage = 0.2f;
            if (rect.getWidth() * (double)styPercentage < (double)maxMarkerW) {
                styPercentage = (float)((double)maxMarkerW / rect.getWidth());
            }
            Rectangle2D.Float sr = new Rectangle2D.Float();
            for (int i = 0; i < nBuckets; ++i) {
                smods = null;
                if (stymods != null && stymods instanceof AdvancedStyleModifiers) {
                    smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(this.bean.getBucketSeries().getBucket(i).getRenderStyleName().toUpperCase() + "_" + i);
                }
                Bucket bucket = this.bean.getBucketSeries().getBucket(i);
                ((Rectangle2D)sr).setRect(sx, sy + (double)i * incr, rect.getWidth(), incr);
                this.drawBucketWithLabel(g, bucket, sr, styPercentage, 1.0f - styPercentage, smods);
            }
        }
        catch (Exception e) {
            g.drawString(" * bad style *", 10, 10);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        if (!(shp instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attr value.");
        }
        this.apply(null, g, (Rectangle2D)shp, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        if (values == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        BucketDescription bd = this.chooseRenderStyle(values[0], stymods);
        if (bd.style != null) {
            if (bd.style instanceof StyleMarker && bd.styleMods != null && bd.styleMods instanceof MarkerStyleModifiers && (((MarkerStyleModifiers)bd.styleMods).getWidth() < 1 || ((MarkerStyleModifiers)bd.styleMods).getHeight() < 1)) {
                return;
            }
            bd.style.apply(null, g, shp, gtype, label, labelPoint, cr, values, bd.styleMods);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        if (values == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        if (styleColumns == null) {
            this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
        } else {
            Field[] svalue = new Field[]{null};
            String column = styleColumns[0];
            svalue[0] = Util.getField(column, values);
            if (svalue[0] == null) {
                throw new StyleNotApplicableException("Unable to find column " + column + " for BucketStyle.");
            }
            this.apply(null, g, shp, gtype, label, labelPoint, cr, svalue, stymods);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        if (values == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        if (subStyle == null && (substyleColumns == null || substyleColumns.length == 0)) {
            this.apply(null, g, shp, gtype, label, labelPoint, cr, values, styleColumns, stymods);
        } else {
            this.applySubStyle(g, shp, gtype, label, labelPoint, cr, values, styleColumns, subStyle, substyleColumns, changeProperty, stymods, false, null, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applySubStyle(Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods, boolean deferCasedLines, VisContext vc, StyledFeatureI sf) throws StyleNotApplicableException {
        if (subStyle == null && (substyleColumns == null || substyleColumns.length == 0)) {
            return;
        }
        if (subStyle == null) {
            if (changeProperty == null || !changeProperty.equalsIgnoreCase(RenderingRule.MARKER_SIZE_SCALE_FACTOR_CHANGE)) {
                throw new StyleNotApplicableException("Currently just " + RenderingRule.MARKER_SIZE_SCALE_FACTOR_CHANGE + " change property is supported for null sub style");
            }
            Field svalue = null;
            String column = substyleColumns[0];
            svalue = Util.getField(column, values);
            if (svalue == null) {
                throw new StyleNotApplicableException("Unable to find attribute " + column + " for Sub style column.");
            }
            double factor = Double.NaN;
            try {
                factor = Double.parseDouble(svalue.toString());
                if (factor <= 0.0) {
                    throw new StyleNotApplicableException("Size [" + svalue.toString() + "] is not a valid scale factor");
                }
            }
            catch (Exception ex) {
                throw new StyleNotApplicableException("Size [" + svalue.toString() + "] is not a valid scale factor");
            }
            svalue = values[0];
            if (styleColumns != null && (svalue = Util.getField(styleColumns[0], values)) == null) {
                throw new StyleNotApplicableException("Unable to find attribute " + styleColumns[0] + " for Bucket Style.");
            }
            BucketDescription bdsty = this.chooseRenderStyle(svalue, stymods);
            Style sty = bdsty.style;
            if (sty == null) {
                log.warning("Cannot find a suitable style based on your values [" + svalue + "].");
                return;
            }
            if (!(sty instanceof StyleMarker)) {
                throw new StyleNotApplicableException(RenderingRule.MARKER_SIZE_SCALE_FACTOR_CHANGE + " change property can just be applied in marker styles");
            }
            StyleModifiers mkmods = bdsty.styleMods;
            if (mkmods == null || !(mkmods instanceof MarkerStyleModifiers)) {
                mkmods = new MarkerStyleModifiers();
                ((MarkerStyleModifiers)mkmods).setWidth((int)((MarkerStyleModel)sty.getModel()).getMarkerWidth());
                ((MarkerStyleModifiers)mkmods).setHeight((int)((MarkerStyleModel)sty.getModel()).getMarkerHeight());
                if (((MarkerStyleModel)sty.getModel()).getLabelFont() != null) {
                    ((MarkerStyleModifiers)mkmods).setFontSize(((MarkerStyleModel)sty.getModel()).getLabelFont().getSize());
                } else {
                    ((MarkerStyleModifiers)mkmods).setFontSize(12);
                }
                ((MarkerStyleModifiers)mkmods).setLabelOffsetX((int)((MarkerStyleModel)sty.getModel()).getLabelOffsetSizeX());
                ((MarkerStyleModifiers)mkmods).setLabelOffsetY((int)((MarkerStyleModel)sty.getModel()).getLabelOffsetSizeY());
                ((MarkerStyleModifiers)mkmods).setOrientationAngle(((StyleMarker)sty).getOrientation());
            }
            int backWidth = ((MarkerStyleModifiers)mkmods).getWidth();
            int backHeight = ((MarkerStyleModifiers)mkmods).getHeight();
            ((MarkerStyleModifiers)mkmods).setWidth((int)((double)((MarkerStyleModifiers)mkmods).getWidth() * factor));
            ((MarkerStyleModifiers)mkmods).setHeight((int)((double)((MarkerStyleModifiers)mkmods).getHeight() * factor));
            sty.apply(null, g, shp, gtype, label, labelPoint, cr, values, mkmods);
            ((MarkerStyleModifiers)mkmods).setWidth(backWidth);
            ((MarkerStyleModifiers)mkmods).setHeight(backHeight);
            return;
        }
        if (!(subStyle instanceof AdvancedStyle)) throw new StyleNotApplicableException("Just Bucket Styles are accepted as sub-styles");
        if (substyleColumns == null) {
            throw new StyleNotApplicableException("Sub style column must be defined.");
        }
        if (changeProperty != null && !changeProperty.equalsIgnoreCase(RenderingRule.FILL_COLOR_CHANGE)) {
            throw new StyleNotApplicableException("Currently just " + RenderingRule.FILL_COLOR_CHANGE + " change property is supported for a sub style");
        }
        if (!(subStyle instanceof BucketStyle)) throw new StyleNotApplicableException("Can not use Advanced Style " + subStyle.getModel().getName() + " as sub-style");
        Field svalue = null;
        String column = substyleColumns[0];
        svalue = Util.getField(column, values);
        if (svalue == null) {
            throw new StyleNotApplicableException("Unable to find attribute " + column + " for Sub style.");
        }
        Style substy = ((BucketStyle)subStyle).chooseStyle(svalue);
        if (substy == null) {
            log.warning("cannot find a suitable sub style based on your values [" + svalue + "].");
            return;
        }
        svalue = values[0];
        if (styleColumns != null && (svalue = Util.getField(styleColumns[0], values)) == null) {
            throw new StyleNotApplicableException("Unable to find attribute " + styleColumns[0] + " for Bucket Style.");
        }
        BucketDescription bdsty = this.chooseRenderStyle(svalue, stymods);
        Style sty = bdsty.style;
        if (sty == null) {
            log.warning("cannot find a suitable style based on your values [" + svalue + "].");
            return;
        }
        Color substyColor = null;
        if (substy instanceof StyleColor) {
            substyColor = ((StyleColor)substy).getFillColor();
        } else if (substy instanceof StyleLine) {
            substyColor = ((LineStyleModel)substy.getModel()).getFillColor();
        } else {
            if (!(substy instanceof StyleMarker)) throw new StyleNotApplicableException("Invalid bucket style type of substyle.");
            StyleMarker mk = (StyleMarker)substy;
            int mktype = ((MarkerStyleModel)mk.getModel()).getMarkerType();
            if (mktype == 5 || mktype == 6) {
                throw new StyleNotApplicableException("Substyle marker type must be of vector type.");
            }
            substyColor = mk.getColorStyle().getFillColor();
        }
        if (substyColor == null) return;
        Object styStrokeColor = null;
        if (sty instanceof StyleColor) {
            StyleColor cloneColor = (StyleColor)((StyleColor)sty).clone();
            cloneColor.setFillColor(substyColor);
            cloneColor.apply(null, g, shp, gtype, label, labelPoint, cr, values, null);
            return;
        } else if (sty instanceof StyleLine) {
            Color savedfillColor = ((LineStyleModel)sty.getModel()).getFillColor();
            ((LineStyleModel)sty.getModel()).setFillColor(substyColor);
            if (!deferCasedLines || !((StyleLine)sty).supportCasedLine() || gtype != 2 && gtype != 6) {
                sty.apply(null, g, shp, gtype, label, labelPoint, cr, values, bdsty.styleMods);
            } else {
                StyleLine lclone = (StyleLine)((StyleLine)sty).clone();
                CasedLineHelper ch = vc.getCasedLines();
                ch.addStyledFeature(sf, shp, lclone);
            }
            ((LineStyleModel)sty.getModel()).setFillColor(savedfillColor);
            return;
        } else {
            if (!(sty instanceof StyleMarker)) throw new StyleNotApplicableException("Invalid bucket style type of base style.");
            Color stkColor = ((StyleMarker)sty).getColorStyle().getStrokeColor();
            StyleMarker smClone = (StyleMarker)((StyleMarker)sty).clone();
            StyleColor newColor = new StyleColor(substyColor, stkColor);
            smClone.setColorStyle(newColor);
            smClone.apply(null, g, shp, gtype, label, labelPoint, cr, values, bdsty.styleMods);
        }
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        boolean undefArea = false;
        if (vc == null || Util.isFullExtent(vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMaxX(), vc.getQueryWindow().getMaxY()) || vc.getQueryWindow().getWidth() == 0.0 && vc.getQueryWindow().getHeight() == 0.0) {
            undefArea = true;
        }
        int size = 7;
        int increment = 4;
        AdvancedStyleModifiers advmods = new AdvancedStyleModifiers();
        StyleModifiers stymods = null;
        Style defaultStyle = this.getDefaultStyle();
        if (defaultStyle != null && (stymods = defaultStyle.convertToPixelSize(vc)) != null) {
            if (this.getDefaultStyleName() != null) {
                advmods.addStyleModifiers(this.getDefaultStyleName().toUpperCase(), stymods);
            } else {
                log.warning("Default style name is null. Not added to style modifiers list.");
            }
        }
        int n = this.getNumBuckets();
        for (int i = 0; i < n; ++i) {
            Style lstybkt;
            Style rstybkt = (Style)this.getBucket(i).getRenderStyle();
            if (rstybkt != null && (stymods = rstybkt.convertToPixelSize(vc)) != null) {
                String styname = this.getBucket(i).getRenderStyleName();
                if (this instanceof VariableMarkerStyle) {
                    styname = ((VariableMarkerStyle)this).getBaseMarkerName();
                    if (undefArea && !((MarkerStyleModel)rstybkt.getModel()).getMarkerSize().isPixelUnit()) {
                        ((MarkerStyleModifiers)stymods).setWidth(size);
                        ((MarkerStyleModifiers)stymods).setHeight(size);
                        size += increment;
                    }
                } else if (this instanceof VariablePieChartStyle) {
                    styname = "PIECHART";
                    if (undefArea && !((PieChartStyleModel)rstybkt.getModel()).getPieRadiusSize().isPixelUnit()) {
                        ((PieChartStyleModifiers)stymods).setPieRadius(size);
                        size += increment;
                    }
                }
                if (styname != null) {
                    advmods.addStyleModifiers(styname.toUpperCase() + "_" + i, stymods);
                } else {
                    log.warning("Bucket " + i + " render style name is null. Not added to style modifiers list.");
                }
            }
            if ((lstybkt = (Style)this.getBucket(i).getLabelStyle()) == null || (stymods = lstybkt.convertToPixelSize(vc)) == null) continue;
            if (this.getBucket(i).getLabelStyleName() != null) {
                advmods.addStyleModifiers(this.getBucket(i).getLabelStyleName().toUpperCase() + "_" + i, stymods);
                continue;
            }
            log.warning("Bucket " + i + " label style name is null. Not added to style modifiers list.");
        }
        if (advmods.getStyleModifiers().size() == 0) {
            return null;
        }
        return advmods;
    }

    public BucketDescription chooseRenderStyle(Field value, StyleModifiers stymods) {
        int bkidx;
        BucketDescription bd = new BucketDescription();
        if (value == null) {
            return bd;
        }
        bd.bucketIndex = bkidx = this.bean.getBucketSeries().getBucketIndex(value);
        bd.style = bkidx < 0 ? (Style)this.bean.getBucketSeries().getDefaultRenderStyle() : (Style)this.bean.getBucketSeries().getBucket(bkidx).getRenderStyle();
        if (bd.style != null && bkidx > -1 && stymods != null && stymods instanceof AdvancedStyleModifiers) {
            String styname = this.bean.getBucketSeries().getBucket(bkidx).getRenderStyleName();
            if (this instanceof VariableMarkerStyle) {
                styname = ((VariableMarkerStyle)this).getBaseMarkerName();
            } else if (this instanceof VariablePieChartStyle) {
                styname = "PIECHART";
            }
            bd.styleMods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(styname.toUpperCase() + "_" + bkidx);
        }
        return bd;
    }

    public void applyDeferringCasedLines(Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods, VisContext vc, StyledFeatureI sf) throws StyleNotApplicableException {
        if (values == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        BucketDescription bd = this.chooseRenderStyle(values[0], stymods);
        if (bd.style != null) {
            if (bd.style instanceof StyleMarker && bd.styleMods != null && bd.styleMods instanceof MarkerStyleModifiers && (((MarkerStyleModifiers)bd.styleMods).getWidth() < 1 || ((MarkerStyleModifiers)bd.styleMods).getHeight() < 1)) {
                return;
            }
            if ((gtype == 2 || gtype == 6) && bd.style instanceof StyleLine && ((StyleLine)bd.style).supportCasedLine()) {
                CasedLineHelper ch = vc.getCasedLines();
                ch.addStyledFeature(sf, shp, bd.style);
            } else {
                bd.style.apply(null, g, shp, gtype, label, labelPoint, cr, values, bd.styleMods);
            }
        }
    }

    public void applyDeferringCasedLines(Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods, VisContext vc, StyledFeatureI sf) throws StyleNotApplicableException {
        if (values == null) {
            throw new StyleNotApplicableException("BucketStyle not applicable without an attribute value.");
        }
        if (subStyle == null && (substyleColumns == null || substyleColumns.length == 0)) {
            if (styleColumns == null) {
                this.applyDeferringCasedLines(g, shp, gtype, label, labelPoint, cr, values, stymods, vc, sf);
            } else {
                Field[] svalue = new Field[]{null};
                String column = styleColumns[0];
                svalue[0] = Util.getField(column, values);
                if (svalue[0] == null) {
                    throw new StyleNotApplicableException("Unable to find column " + column + " for BucketStyle.");
                }
                this.applyDeferringCasedLines(g, shp, gtype, label, labelPoint, cr, svalue, stymods, vc, sf);
            }
        } else {
            this.applySubStyle(g, shp, gtype, label, labelPoint, cr, values, styleColumns, subStyle, substyleColumns, changeProperty, stymods, true, vc, sf);
        }
    }

    public boolean hasMarkerWithURLColumn() {
        MarkerStyleModel stm;
        Style defaultStyle = this.getDefaultStyle();
        if (defaultStyle != null && defaultStyle instanceof StyleMarker && (stm = (MarkerStyleModel)((StyleMarker)defaultStyle).getModel()).getMarkerType() == 5 && stm.getUrlColumn() != null) {
            return true;
        }
        int n = this.getNumBuckets();
        for (int i = 0; i < n; ++i) {
            MarkerStyleModel stm2;
            Style stybkt = (Style)this.getBucket(i).getRenderStyle();
            if (stybkt == null || !(stybkt instanceof StyleMarker) || (stm2 = (MarkerStyleModel)((StyleMarker)stybkt).getModel()).getMarkerType() != 5 || stm2.getUrlColumn() == null) continue;
            return true;
        }
        return false;
    }

    public class BucketDescription {
        public Style style = null;
        public StyleModifiers styleMods = null;
        public int bucketIndex = -1;
    }
}

