/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.MarkerStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.svg.SVGDomUtil;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.GIFMaker;
import oracle.sdovis.util.ImageUtils;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;

public class StyleMarker
implements Style {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static final AffineTransform idTransform = new AffineTransform();
    static final FontRenderContext frc = new FontRenderContext(null, true, false);
    MarkerStyleModel bean = null;
    transient Shape markerShp = null;
    private transient Image image = null;
    transient StyleColor styColor = null;
    transient Rectangle2D mbr = null;
    private transient Image urlImage = null;
    private transient String currentUrl = null;
    private transient GraphicsNode svgRootNode = null;

    public StyleMarker() {
        this.bean = new MarkerStyleModel();
    }

    public StyleMarker(StyleModel model) {
        this.setModel(model);
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof MarkerStyleModel)) {
            throw new IllegalArgumentException("Not a valid Marker style model");
        }
        this.bean = (MarkerStyleModel)model;
        this.refreshThis();
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    public StyleMarker(String svg) throws StyleException {
        this.bean = new MarkerStyleModel();
        if (!this.parseMarker(svg)) {
            throw new StyleException("Invalid marker style definition.");
        }
    }

    public StyleMarker(int imageType, byte[] imageData, String svg) throws StyleException {
        this.bean = new MarkerStyleModel();
        this.bean.setMarkerType(5);
        this.bean.setMarkerImageBinary(imageData);
        this.bean.setMarkerImageType(imageType);
        this.recreateImageMarker();
        if (svg != null && !this.parseMarker(svg)) {
            throw new StyleException("Invalid marker style definition.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMarker(Image img, String svg) {
        this.bean = new MarkerStyleModel();
        this.bean.setMarkerType(5);
        ImageUtils.waitForImage(img);
        this.image = img;
        this.mbr = new Rectangle2D.Double(0.0, 0.0, img.getWidth(null), img.getHeight(null));
        this.bean.setForcedWidth(img.getWidth(null));
        this.bean.setForcedHeight(img.getHeight(null));
        BufferedImage bimg = null;
        try {
            bimg = (BufferedImage)img;
        }
        catch (ClassCastException e) {
            bimg = ImageUtils.makeBufferedImage(img);
        }
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            BufferedOutputStream bufs = new BufferedOutputStream(bs);
            GIFMaker gifM = new GIFMaker(bufs);
            gifM.encode(bimg);
            this.bean.setMarkerImageBinary(bs.toByteArray());
            this.bean.setMarkerImageType(0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            ImageUtils.removeImageFromTracker(img);
        }
        if (svg != null && svg.length() > 0) {
            this.parseMarker(svg);
        }
    }

    public StyleMarker(Font ttFont, char code) {
        this.bean = new MarkerStyleModel();
        this.bean.setMarkerType(6);
        this.bean.setTruetypeFont(ttFont);
        this.bean.setGlyphCharCode(code);
    }

    public Object clone() {
        try {
            StyleMarker sty = (StyleMarker)super.clone();
            sty.setModel((StyleModel)this.bean.clone());
            return sty;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    private void recreateImageMarker() {
        if (this.bean.getUrl() != null) {
            try {
                if (this.urlImage == null || this.bean.getUrl() != this.currentUrl) {
                    byte[] bs = null;
                    CacheGroup cg = null;
                    if (this.bean.getUrlColumn() != null) {
                        if (!CacheMgr2.isReady()) {
                            CacheMgr2.init();
                        }
                        if ((cg = CacheMgr2.getGroup("IMAGE_URL", "IMAGE_OBJECT")) != null) {
                            this.urlImage = (Image)cg.get(this.bean.getUrl());
                        } else {
                            CacheMgr2.createSubRegion("IMAGE_URL");
                            CacheMgr2.createImageURLGroup("IMAGE_URL", "IMAGE_OBJECT");
                            cg = CacheMgr2.getGroup("IMAGE_URL", "IMAGE_OBJECT");
                        }
                    }
                    if (this.urlImage == null) {
                        try {
                            bs = Util.readBinaryFromURL(this.bean.getUrl());
                        }
                        catch (Exception ex) {
                            bs = null;
                        }
                        if (bs == null) {
                            log.warning("cannot load url-based marker: " + this.bean.getUrl());
                            this.urlImage = null;
                            return;
                        }
                        BufferedImage img = null;
                        try {
                            img = ImageIO.read(new ByteArrayInputStream(bs));
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        this.urlImage = ImageUtils.makeBufferedImage(img, 2);
                        if (this.bean.getUrlColumn() != null) {
                            cg.put(this.bean.getUrl(), this.urlImage, 0L);
                        }
                    }
                    this.currentUrl = this.bean.getUrl();
                }
                this.mbr = new Rectangle2D.Double(0.0, 0.0, this.urlImage.getWidth(null), this.urlImage.getHeight(null));
                if (this.bean.getForcedWidth() == 0 || this.bean.getForcedHeight() == 0) {
                    this.bean.setForcedWidth(this.urlImage.getWidth(null));
                    this.bean.setForcedHeight(this.urlImage.getHeight(null));
                }
                return;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "cannot load url-based marker: " + this.bean.getUrl(), e);
                this.urlImage = null;
                return;
            }
        }
        if (this.bean.getUrlColumn() != null) {
            return;
        }
        BufferedImage img = null;
        try {
            img = ImageIO.read(new ByteArrayInputStream(this.bean.getMarkerImageBinary()));
        }
        catch (IOException ex) {
            log.warning("Cannot create marker image instance:" + ex.getMessage());
        }
        this.image = img;
        this.mbr = new Rectangle2D.Double(0.0, 0.0, ((Image)img).getWidth(null), ((Image)img).getHeight(null));
        if (this.bean.getForcedWidth() == 0 || this.bean.getForcedHeight() == 0) {
            this.bean.setForcedWidth(((Image)img).getWidth(null));
            this.bean.setForcedHeight(((Image)img).getHeight(null));
        }
    }

    private void recreateSVGMarker() {
        String s = this.bean.getRawSVGString();
        if (s == null || s.length() == 0) {
            return;
        }
        try {
            Document svgDom = SVGDomUtil.parseSVGFromString(s);
            double[] dim = SVGDomUtil.getSVGPreferredSize(svgDom);
            this.mbr = new Rectangle2D.Double(0.0, 0.0, dim[0], dim[1]);
            this.svgRootNode = SVGDomUtil.getGraphicsRootNode(svgDom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean parseMarker(String svg) {
        this.bean.setRotation(0.0);
        XMLDOMParser parser = new XMLDOMParser();
        if (!parser.parse(svg)) {
            return false;
        }
        String t = parser.getAttribute("g", "class");
        if (t == null) {
            return false;
        }
        if (!t.toUpperCase().equals("MARKER")) {
            log.warning("svg error: wrong type (expecting MARKER)");
            return false;
        }
        String style = parser.getAttribute("g", "style");
        String strbackground = StyleUtils.getNamedString(style, "background");
        if (strbackground != null) {
            this.bean.setBackgroundColor(StyleUtils.getColor("background", style));
        }
        this.extractCommonAttributes(style, parser);
        String s = null;
        s = parser.getAttribute("polygon", "points");
        if (s != null) {
            this.bean.setMarkerType(1);
        } else {
            s = parser.getAttribute("polyline", "points");
            if (s != null) {
                this.bean.setMarkerType(2);
            } else {
                s = parser.getAttribute("circle", "r");
                if (s != null || parser.getElementNode("circle") != null) {
                    this.bean.setMarkerType(3);
                } else {
                    s = parser.getAttribute("rect", "points");
                    if (s != null) {
                        this.bean.setMarkerType(4);
                    } else {
                        s = parser.getAttribute("image", "width");
                        if (s != null) {
                            this.bean.setMarkerType(5);
                        } else {
                            s = parser.getAttribute("ttfSymbol", "fontName");
                            if (s != null) {
                                this.bean.setMarkerType(6);
                            } else if (parser.getElementNode("svgSymbol") != null) {
                                this.bean.setMarkerType(7);
                            }
                        }
                    }
                }
            }
        }
        if (parser.getElementNode("svgSymbol") != null) {
            s = parser.getElementValue("svgSymbol");
            if (s != null) {
                s = s.trim();
            }
            return this.parseSVGSymbol(s);
        }
        if (s != null && s.length() > 0 && this.bean.getMarkerType() != 6 && this.bean.getMarkerType() != 5) {
            double[] coord = Util.convert(s);
            if (coord.length < 1) {
                return false;
            }
            this.bean.setVector(coord);
        }
        this.recreateVectorMarker();
        try {
            this.styColor = new StyleColor(svg);
            if (this.styColor.getFillColor() == null && this.styColor.getStrokeColor() == null) {
                this.styColor = null;
            } else {
                this.bean.setVectorFillColor(this.styColor.getFillColor());
                this.bean.setVectorStrokeColor(this.styColor.getStrokeColor());
                this.bean.setVectorStrokeWidth(this.styColor.getStrokeWidth());
            }
        }
        catch (Exception e) {
            this.styColor = null;
        }
        try {
            if (this.bean.getMarkerType() == 6) {
                this.bean.setTruetypeFontName(parser.getAttribute("ttfSymbol", "fontName"));
                this.bean.setGlyphCharCode(Integer.parseInt(parser.getAttribute("ttfSymbol", "charCode")));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        if (this.bean.getMarkerType() == 5) {
            String href;
            String mktype = parser.getAttribute("image", "markerType");
            if (mktype != null && mktype.trim().length() > 0) {
                this.bean.setUrlMarkerImageFormat(mktype.trim());
            }
            if ((href = parser.getAttribute("image", "href")) != null && !href.equalsIgnoreCase("dummy.gif")) {
                this.bean.setUrl(href);
                this.recreateImageMarker();
            } else {
                String hrefColumn = parser.getAttribute("image", "hrefColumn");
                if (hrefColumn != null && hrefColumn.trim().length() > 0) {
                    this.bean.setUrlColumn(hrefColumn.trim());
                }
            }
        }
        return true;
    }

    private boolean parseSVGSymbol(String svg) {
        try {
            Document svgDom = SVGDomUtil.parseSVGFromString(svg);
            double[] dim = SVGDomUtil.getSVGPreferredSize(svgDom);
            this.mbr = new Rectangle2D.Double(0.0, 0.0, dim[0], dim[1]);
            if (this.bean.getSVGNaturalSize() == null) {
                this.bean.setSVGNaturalSize(dim);
            }
            if (this.bean.getForcedWidth() == 0 || this.bean.getForcedHeight() == 0) {
                this.bean.setForcedWidth((int)dim[0]);
                this.bean.setForcedHeight((int)dim[1]);
            }
            this.bean.setMarkerType(7);
            this.bean.setRawSVGString(svg);
            this.svgRootNode = SVGDomUtil.getGraphicsRootNode(svgDom);
            return true;
        }
        catch (Exception e) {
            log.warning("Error parsing embedded SVG symbol doc: " + e.getMessage());
            return false;
        }
    }

    public void recreateColorStyle() {
        this.styColor = new StyleColor(this.bean.getVectorFillColor(), this.bean.getVectorStrokeColor());
        this.styColor.setStrokeWidth(this.bean.getVectorStrokeWidth());
    }

    public void recreateVectorMarker() {
        int type = this.bean.getMarkerType();
        if (type == 6 || type == 5 || type == 0) {
            return;
        }
        double[] coord = this.bean.getVector();
        if (coord == null) {
            log.warning("Unable to create vector representation due to undefined vector value(s)");
            return;
        }
        switch (type) {
            case 1: 
            case 2: {
                GeneralPath path = new GeneralPath(0);
                path.moveTo((float)coord[0], (float)coord[1]);
                for (int i = 0; i < coord.length / 2; ++i) {
                    path.lineTo((float)coord[i * 2 + 0], (float)coord[i * 2 + 1]);
                }
                if (type == 1) {
                    path.closePath();
                }
                this.markerShp = path;
                this.mbr = Util.mbr(coord);
                if (this.mbr.getMinX() != 0.0 || this.mbr.getMinY() != 0.0) {
                    AffineTransform at = AffineTransform.getTranslateInstance(-this.mbr.getMinX(), -this.mbr.getMinY());
                    this.markerShp = at.createTransformedShape(path);
                }
                this.mbr = this.markerShp.getBounds2D();
                break;
            }
            case 3: {
                int radius = 16;
                Ellipse2D.Float e = new Ellipse2D.Float(0.0f, 0.0f, radius, radius);
                this.markerShp = e;
                this.mbr = new Rectangle2D.Double(0.0, 0.0, radius, radius);
                break;
            }
            case 4: {
                this.markerShp = new Rectangle2D.Float((float)coord[0], (float)coord[1], (float)coord[2], (float)coord[3]);
                this.mbr = this.markerShp.getBounds2D();
                if (this.mbr.getMinX() == 0.0 && this.mbr.getMinY() == 0.0) break;
                AffineTransform at = AffineTransform.getTranslateInstance(-this.mbr.getMinX(), -this.mbr.getMinY());
                this.markerShp = at.createTransformedShape(this.markerShp);
            }
        }
    }

    public Rectangle2D getMBR() {
        return this.mbr;
    }

    public void setMBR(Rectangle2D rect) {
        this.mbr = rect;
    }

    public int getDesiredWidth() {
        if (this.bean.getForcedWidth() > 0) {
            return this.bean.getForcedWidth();
        }
        return -1;
    }

    public int getDesiredHeight() {
        if (this.bean.getForcedHeight() > 0) {
            return this.bean.getForcedHeight();
        }
        return -1;
    }

    public void setDesiredWidth(int width) {
        this.bean.setForcedWidth(width);
    }

    public void setDesiredHeight(int height) {
        this.bean.setForcedHeight(height);
    }

    public void setDesiredWidth(double width) {
        this.bean.setMarkerWidth(width);
    }

    public double getDoubleDesiredWidth() {
        return this.bean.getMarkerWidth();
    }

    public void setDesiredHeight(double height) {
        this.bean.setMarkerHeight(height);
    }

    public double getDoubleDesiredHeight() {
        return this.bean.getMarkerHeight();
    }

    public void setDesiredUnit(String unit) {
        this.bean.setMarkerSizeUnit(unit);
    }

    public double setOrientation(double x, double y, double z) {
        return this.bean.setOrientation(x, y, z);
    }

    public double getOrientation() {
        return this.bean.getRotation();
    }

    public void setOrientation(double radians) {
        this.bean.setRotation(radians);
    }

    public void resetOrientation() {
        this.bean.resetOrientation();
    }

    private void extractCommonAttributes(String rootStyle, XMLDOMParser parser) {
        String offY;
        if (rootStyle == null) {
            return;
        }
        String w = StyleUtils.getNamedString(rootStyle, "width");
        String h = StyleUtils.getNamedString(rootStyle, "height");
        if (w != null && h != null) {
            this.bean.setMarkerSize(SizeDefinition2D.parse(w, h));
        } else {
            this.bean.setMarkerSize(new SizeDefinition2D(16.0, 16.0, null));
        }
        String _anchorX = null;
        String _anchorY = null;
        _anchorX = parser.getAttribute("anchor", "x");
        _anchorY = parser.getAttribute("anchor", "y");
        if (_anchorX != null || _anchorY != null) {
            double ay;
            double ax;
            if (_anchorX != null && (ax = Double.parseDouble(_anchorX)) >= 0.0) {
                this.bean.setAnchorX(ax);
            }
            if (_anchorY != null && (ay = Double.parseDouble(_anchorY)) >= 0.0) {
                this.bean.setAnchorY(ay);
            }
        }
        SizeDefinition ofx = null;
        SizeDefinition ofy = null;
        String offX = StyleUtils.getNamedString(rootStyle, "text-offset-x");
        if (offX != null && offX.length() > 0 && (ofx = SizeDefinition.parse(offX)) != null) {
            this.bean.setLabelOffsetSizeX(ofx.getValue());
            this.bean.setLabelOffsetUnit(ofx.getUnit());
        }
        if ((offY = StyleUtils.getNamedString(rootStyle, "text-offset-y")) != null && offY.length() > 0 && (ofy = SizeDefinition.parse(offY)) != null) {
            this.bean.setLabelOffsetSizeY(ofy.getValue());
            if (ofx == null) {
                this.bean.setLabelOffsetUnit(ofy.getUnit());
            }
        }
        String fontFamily = StyleUtils.getNamedString(rootStyle, "font-family");
        String fontSize = StyleUtils.getNamedString(rootStyle, "font-size");
        String fontWeight = StyleUtils.getNamedString(rootStyle, "font-weight");
        String fontStyle = StyleUtils.getNamedString(rootStyle, "font-style");
        String fill = StyleUtils.getNamedString(rootStyle, "font-fill");
        if (fill == null || fill.length() == 0) {
            fill = StyleUtils.getNamedString(rootStyle, "fill");
        }
        if (fill != null) {
            String f1 = StyleUtils.getNamedString(rootStyle, "font-fill");
            if (f1 != null && f1.length() > 0) {
                this.bean.setLabelFontColor(StyleUtils.getColor("font-fill", rootStyle));
            } else {
                this.bean.setLabelFontColor(StyleUtils.getColor("fill", rootStyle));
            }
        }
        int jfStyle = 0;
        if (fontStyle != null && fontStyle.toUpperCase().equals("ITALIC")) {
            jfStyle = 2;
        }
        if (fontWeight != null && fontWeight.toUpperCase().equals("BOLD")) {
            jfStyle = jfStyle == 2 ? (jfStyle |= 1) : 1;
        }
        int jfSize = 12;
        SizeDefinition fsize = SizeDefinition.parse(fontSize);
        if (fsize != null) {
            jfSize = (int)fsize.getValue();
            this.bean.setLabelFontSizeValue((float)fsize.getValue());
            this.bean.setLabelFontSizeUnit(fsize.getUnit());
        }
        this.bean.setLabelFont(new Font(fontFamily, jfStyle, jfSize));
    }

    private String getImageTypeString() {
        if (this.bean.getMarkerImageType() == 0) {
            return "GIF";
        }
        if (this.bean.getMarkerImageType() == 1) {
            return "JPEG";
        }
        return "PNG";
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.refreshThis();
    }

    public void refreshThis() {
        if (this.bean.getMarkerType() == 5) {
            this.recreateImageMarker();
        } else if (this.bean.getMarkerType() == 7) {
            this.recreateSVGMarker();
        } else {
            this.recreateVectorMarker();
            this.recreateColorStyle();
            this.getGlyphShape();
        }
    }

    private void drawTTFMarker(Graphics2D g, Rectangle2D rect, int realw, int realh, double theta) {
        if (this.bean.getMarkerType() == 6 && rect != null) {
            int x = (int)rect.getCenterX();
            int y = (int)rect.getCenterY();
            int w = (int)rect.getWidth();
            int h = (int)rect.getHeight();
            AffineTransform xf = g.getTransform();
            Color bkc = g.getColor();
            Font bkf = g.getFont();
            Font f = this.bean.getTruetypeFont().getFont().deriveFont((float)realh);
            char[] cs = new char[]{(char)this.bean.getGlyphCharCode()};
            GlyphVector gv = f.createGlyphVector(frc, cs);
            Shape shp = gv.getGlyphOutline(0);
            Rectangle2D mbrg = shp.getBounds2D();
            Color c = Color.blue;
            if (this.styColor != null && (c = this.styColor.getFillColor()) == null) {
                c = this.styColor.getStrokeColor();
            }
            g.setColor(c);
            g.setFont(f);
            int dx = 0;
            double anchorX = mbrg.getWidth() * this.bean.getAnchorX();
            double anchorY = mbrg.getHeight() * this.bean.getAnchorY();
            dx = (int)((double)w / 2.0 - anchorX - mbrg.getMinX() + 0.5);
            int dy = 0;
            dy = mbrg.getMinY() < 0.0 ? (int)((double)h - Math.abs(mbrg.getMinY()) - ((double)h / 2.0 - anchorY) + 0.5) : (int)((double)h / 2.0 - anchorY - mbrg.getMinY() + 0.5);
            g.translate(dx + (int)rect.getMinX(), h - dy + (int)rect.getMinY());
            if (theta != 0.0) {
                g.rotate(theta, w / 2 - dx, -(h / 2) + dy);
            }
            g.drawString(Character.toString(cs[0]), 0, 0);
            g.setTransform(xf);
            g.setColor(bkc);
            g.setFont(bkf);
        }
    }

    private void drawMarker(Graphics2D g) {
        if (this.bean.getUrl() != null) {
            if (this.urlImage == null) {
                log.warning("URL image is null. Check http address of image URL.");
                return;
            }
            Object hint = g.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (hint == null) {
                hint = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (this.urlImage != null) {
                g.drawImage(this.urlImage, null, null);
            }
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            return;
        }
        if (this.bean.getMarkerType() == 5) {
            Object hint = g.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (hint == null) {
                hint = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (this.image != null) {
                g.drawImage(this.image, null, null);
            }
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            return;
        }
        if (this.markerShp != null) {
            if (this.bean.getMarkerType() == 6) {
                log.finest("We should never be here!");
                Color c = Color.blue;
                if (this.styColor != null && (c = this.styColor.getFillColor()) == null) {
                    c = this.styColor.getStrokeColor();
                }
                g.setColor(c);
                g.fill(this.markerShp);
            } else {
                this.drawVectorMarker(g);
            }
            return;
        }
        if (this.bean.getMarkerType() == 7) {
            if (this.svgRootNode == null) {
                log.warning("SVG graphics node does not exist!");
                return;
            }
            this.svgRootNode.paint(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawVectorMarker(Graphics2D g) {
        Shape shp = this.markerShp;
        AffineTransform xfm = g.getTransform();
        if (xfm != null && shp != null) {
            shp = xfm.createTransformedShape(shp);
        }
        g.setTransform(VisContext.ID_TRANSFORM);
        try {
            if (this.styColor != null) {
                this.styColor.apply(g, shp);
            } else {
                g.draw(shp);
            }
        }
        catch (Exception ex) {
        }
        finally {
            g.setTransform(xfm);
        }
    }

    private void getGlyphShape() {
        if (this.markerShp != null) {
            return;
        }
        TruetypeFont ttf = this.bean.getTruetypeFont();
        if (ttf == null || this.bean.getGlyphCharCode() == 0) {
            return;
        }
        Font font = ttf.getFont();
        if (font == null) {
            return;
        }
        char[] cs = new char[]{(char)this.bean.getGlyphCharCode()};
        GlyphVector gv = font.createGlyphVector(frc, cs);
        this.markerShp = gv.getGlyphOutline(0);
        this.mbr = this.markerShp.getBounds2D();
        if (this.mbr.getMinX() != 0.0 || this.mbr.getMinY() != 0.0) {
            AffineTransform at = AffineTransform.getTranslateInstance(-this.mbr.getMinX(), -this.mbr.getMinY());
            this.markerShp = at.createTransformedShape(this.markerShp);
        }
        this.mbr = this.markerShp.getBounds2D();
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        TruetypeFont ttFont;
        if (this.markerShp != null) {
            return true;
        }
        if (this.bean.getMarkerType() == 6 && this.bean.getTruetypeFont() != null && this.bean.getTruetypeFont().getFont() == null && (ttFont = sc.getFont(this.bean.getTruetypeFontName())) != null) {
            this.bean.setTruetypeFont(ttFont.getFont());
        }
        this.getGlyphShape();
        return true;
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        this.markerShp = null;
        if (this.bean.getMarkerType() != 5 && this.bean.getMarkerType() != 7) {
            this.refreshThis();
        }
        if (this.bean.getMarkerType() == 6 && this.bean.getTruetypeFont() != null && this.bean.getTruetypeFont().getFont() != null) {
            this.bean.getTruetypeFont().setFont(null);
        }
        return this.resolveStyles(sc, dynaStyles);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        Rectangle2D.Float rect = new Rectangle2D.Float((float)((double)x - this.mbr.getWidth() / 2.0), (float)((double)y - this.mbr.getHeight() / 2.0), (float)this.mbr.getWidth(), (float)this.mbr.getHeight());
        this.apply(null, g, rect, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        int forcedWidth = this.bean.getForcedWidth();
        int forcedHeight = this.bean.getForcedHeight();
        double theta = this.bean.getRotation();
        if (stymods != null && stymods instanceof MarkerStyleModifiers) {
            forcedWidth = ((MarkerStyleModifiers)stymods).getWidth();
            forcedHeight = ((MarkerStyleModifiers)stymods).getHeight();
            theta = ((MarkerStyleModifiers)stymods).getOrientationAngle();
        }
        Rectangle2D.Double rectMBR = new Rectangle2D.Double(rect.getCenterX() - (double)forcedWidth / 2.0, rect.getCenterY() - (double)forcedHeight / 2.0, forcedWidth, forcedHeight);
        this.fillMarkerBackground(g, rectMBR, this.bean.getAnchorX(), this.bean.getAnchorY(), theta);
        if (this.bean.getMarkerType() == 6) {
            this.drawTTFMarker(g, rect, forcedWidth, forcedHeight, theta);
            return;
        }
        int x = (int)rect.getCenterX();
        int y = (int)rect.getCenterY();
        int w = (int)rect.getWidth();
        int h = (int)rect.getHeight();
        if (forcedWidth > 0) {
            w = forcedWidth;
        }
        if (forcedHeight > 0) {
            h = forcedHeight;
        }
        double xF = (double)w / this.mbr.getWidth();
        if (this.mbr.getWidth() == 0.0) {
            xF = 1.0;
        }
        double yF = (double)h / this.mbr.getHeight();
        if (this.mbr.getHeight() == 0.0) {
            yF = 1.0;
        }
        double anchorX = (double)w * this.bean.getAnchorX();
        double anchorY = (double)h * this.bean.getAnchorY();
        double sx = (double)x - (this.mbr.getMinX() + anchorX);
        double sy = (double)y - (this.mbr.getMinY() + anchorY);
        Rectangle2D oldMbr = this.mbr;
        boolean backupCircle = false;
        if (this.bean.getMarkerType() == 3 && (xF > 1.0 || yF > 1.0)) {
            Ellipse2D.Float e = new Ellipse2D.Float(0.0f, 0.0f, w, h);
            this.markerShp = e;
            this.mbr = new Rectangle2D.Double(0.0, 0.0, w, h);
            xF = 1.0;
            yF = 1.0;
            backupCircle = true;
        }
        AffineTransform xf = g.getTransform();
        g.transform(AffineTransform.getTranslateInstance(sx, sy));
        if (theta != 0.0) {
            g.rotate(theta, this.mbr.getMinX() + anchorX, this.mbr.getMinY() + anchorY);
        }
        g.transform(AffineTransform.getScaleInstance(xF, yF));
        this.drawMarker(g);
        g.setTransform(xf);
        if (backupCircle) {
            Ellipse2D.Float e = new Ellipse2D.Float(0.0f, 0.0f, (float)oldMbr.getWidth(), (float)oldMbr.getHeight());
            this.markerShp = e;
            this.mbr = oldMbr;
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        if (shp != null && shp instanceof Rectangle2D) {
            this.apply(null, g, (Rectangle2D)shp, stymods);
            return;
        }
        if (shp != null && (gtype == 2 || gtype == 6)) {
            Rectangle2D rect = shp.getBounds2D();
            this.apply(null, g, (float)rect.getCenterX(), (float)rect.getCenterY(), stymods);
            return;
        }
        if (gtype != 3 && gtype != 7) {
            throw new StyleNotApplicableException("cannot apply MARKER to gtype " + gtype);
        }
        double w = this.getDesiredWidth();
        double h = this.getDesiredHeight();
        if (stymods != null && stymods instanceof MarkerStyleModifiers) {
            w = ((MarkerStyleModifiers)stymods).getWidth();
            h = ((MarkerStyleModifiers)stymods).getHeight();
        }
        float[] pos = LabelHelper.findLoc4RectInPolygon(shp, w, h, null, true, true);
        try {
            this.apply(null, g, new Rectangle2D.Float(pos[0], (float)((double)pos[1] - h), (float)w, (float)h), stymods);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        if (this.bean.getMarkerType() == 5 && this.bean.getUrlColumn() != null) {
            String urlColumn = this.bean.getUrlColumn();
            Field urlcol = Util.getField(urlColumn, values);
            if (urlcol == null) {
                throw new StyleNotApplicableException("URL column [" + urlColumn + "] is not part of feature attributes.");
            }
            if (this.bean.getUrl() == null || !this.bean.getUrl().equalsIgnoreCase(urlcol.getValue().toString())) {
                this.bean.setUrl(urlcol.getValue().toString());
                this.refreshThis();
            }
        }
        AffineTransform xfm = g.getTransform();
        float[] pos = null;
        if (labelPoint != null) {
            this.apply(null, g, (float)labelPoint.getX(), (float)labelPoint.getY(), stymods);
            return;
        }
        if (shp != null && shp instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shp;
            double w = rect.getWidth();
            double h = rect.getHeight();
            this.apply(null, g, rect, stymods);
            double[] anchorPoint = this.bean.getAnchorPoint();
            if (cr != null) {
                Rectangle2D.Float r2anchored = new Rectangle2D.Float((float)(rect.getMinX() + (0.5 - anchorPoint[0]) * rect.getWidth()), (float)(rect.getMinY() + (0.5 - anchorPoint[1]) * rect.getHeight()), (float)rect.getWidth(), (float)rect.getHeight());
                cr.insert(r2anchored);
            }
            pos = new float[]{(float)(rect.getCenterX() + (0.5 - anchorPoint[0]) * rect.getWidth()), (float)(rect.getCenterY() + (0.5 - anchorPoint[1]) * rect.getHeight())};
        } else {
            if (shp != null && (gtype == 2 || gtype == 6)) {
                Rectangle2D rect = shp.getBounds2D();
                this.apply(null, g, (float)rect.getCenterX(), (float)rect.getCenterY(), stymods);
                return;
            }
            if (shp != null && gtype == 1) {
                Rectangle2D rect = shp.getBounds2D();
                this.apply(null, g, (float)rect.getCenterX(), (float)rect.getCenterY(), stymods);
            } else if (shp != null && (gtype == 3 || gtype == 7)) {
                double w = this.getDesiredWidth();
                double h = this.getDesiredHeight();
                if (stymods != null && stymods instanceof MarkerStyleModifiers) {
                    w = ((MarkerStyleModifiers)stymods).getWidth();
                    h = ((MarkerStyleModifiers)stymods).getHeight();
                }
                pos = LabelHelper.findLoc4RectInPolygon(shp, w, h, null, true, true);
                Rectangle2D.Float rect = new Rectangle2D.Float(pos[0], (float)((double)pos[1] - h), (float)w, (float)h);
                this.apply(null, g, rect, stymods);
                if (cr != null) {
                    cr.insert(rect);
                }
                pos[0] = (float)((double)pos[0] + w / 2.0);
                pos[1] = (float)((double)pos[1] - h / 2.0);
            } else if (shp != null && gtype == 4) {
                Rectangle2D rect = shp.getBounds2D();
                this.apply(null, g, rect, stymods);
                pos = new float[]{(float)rect.getCenterX(), (float)rect.getCenterY(), 0.0f};
            }
        }
        if (label != null) {
            g.setTransform(idTransform);
            Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            StyleText st = null;
            if (this.bean.getLabelFont() != null) {
                if (stymods != null && stymods instanceof MarkerStyleModifiers) {
                    Font f = new Font(this.bean.getLabelFont().getFamily(), this.bean.getLabelFont().getStyle(), ((MarkerStyleModifiers)stymods).getFontSize());
                    st = new StyleText(f, this.bean.getLabelFontColor());
                } else {
                    st = new StyleText(this.bean.getLabelFont(), this.bean.getLabelFontColor());
                }
            } else {
                st = new StyleText();
                g.setColor(Color.white);
            }
            int lboffX = this.bean.getLabelOffsetX();
            int lboffY = this.bean.getLabelOffsetY();
            if (stymods != null && stymods instanceof MarkerStyleModifiers) {
                lboffX = ((MarkerStyleModifiers)stymods).getLabelOffsetX();
                lboffY = ((MarkerStyleModifiers)stymods).getLabelOffsetY();
            }
            st.apply(g, pos[0] + (float)lboffX, pos[1] - (float)lboffY, label, stymods);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
        }
        g.setTransform(xfm);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    public void setMarkerShp(Shape markerShp) {
        this.markerShp = markerShp;
    }

    public Shape getMarkerShp() {
        return this.markerShp;
    }

    public StyleColor getColorStyle() {
        return this.styColor;
    }

    public void setColorStyle(StyleColor color) {
        if (color.getFillColor() == null && color.getStrokeColor() == null) {
            this.styColor = null;
            this.bean.setVectorFillColor(null);
            this.bean.setVectorStrokeColor(null);
        } else {
            this.styColor = color;
            this.bean.setVectorFillColor(this.styColor.getFillColor());
            this.bean.setVectorStrokeColor(this.styColor.getStrokeColor());
            this.bean.setVectorStrokeWidth(this.styColor.getStrokeWidth());
        }
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        if (this.bean.getMarkerSize().isPixelUnit() && this.isPixelUnit(this.bean.getLabelFontSizeUnit()) && this.bean.getLabelOffsetSize().isPixelUnit()) {
            return null;
        }
        MarkerStyleModifiers mkmods = new MarkerStyleModifiers();
        if (vc == null || Util.isFullExtent(vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMaxX(), vc.getQueryWindow().getMaxY()) || vc.getQueryWindow().getWidth() == 0.0 && vc.getQueryWindow().getHeight() == 0.0) {
            SizeDefinition2D txtoffset;
            SizeDefinition2D mksize = this.bean.getMarkerSize();
            if (mksize.isPixelUnit()) {
                mkmods.setWidth((int)this.bean.getMarkerWidth());
                mkmods.setHeight((int)this.bean.getMarkerHeight());
            }
            if (this.isPixelUnit(this.bean.getLabelFontSizeUnit())) {
                if (this.bean.getLabelFont() != null) {
                    mkmods.setFontSize(this.bean.getLabelFont().getSize());
                } else {
                    mkmods.setFontSize(12);
                }
            }
            if ((txtoffset = this.bean.getLabelOffsetSize()).isPixelUnit()) {
                mkmods.setLabelOffsetX((int)this.bean.getLabelOffsetSizeX());
                mkmods.setLabelOffsetY((int)this.bean.getLabelOffsetSizeY());
            }
        } else {
            double pixelY;
            Rectangle2D devW = vc.getDeviceWindow();
            Rectangle2D queW = vc.getQueryWindow();
            double pixelX = queW.getWidth() / devW.getWidth();
            pixelX = pixelY = queW.getHeight() / devW.getHeight();
            Double convFactor = null;
            SizeDefinition2D mksize = this.bean.getMarkerSize();
            if (mksize.getUnit() != null) {
                convFactor = SRS.getDistanceConversionFactor(mksize.getUnit());
            }
            if (mksize.isPixelUnit()) {
                mkmods.setWidth((int)this.bean.getMarkerWidth());
                mkmods.setHeight((int)this.bean.getMarkerHeight());
            } else if (convFactor == null) {
                mkmods.setWidth(8);
                mkmods.setHeight(8);
            } else {
                double mkwidth = this.bean.getMarkerWidth() * convFactor;
                double mkheight = this.bean.getMarkerHeight() * convFactor;
                if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                    double dgw = SphereCG.convertRadius(0.0, 0.0, mkwidth);
                    mkmods.setWidth((int)(dgw / pixelX + 0.5));
                    double dgh = SphereCG.convertRadius(0.0, 0.0, mkheight);
                    mkmods.setHeight((int)(dgh / pixelY + 0.5));
                } else {
                    mkmods.setWidth(Math.max((int)(mkwidth / pixelX + 0.5), 1));
                    mkmods.setHeight(Math.max((int)(mkheight / pixelY + 0.5), 1));
                }
            }
            if (this.isPixelUnit(this.bean.getLabelFontSizeUnit())) {
                if (this.bean.getLabelFont() != null) {
                    mkmods.setFontSize(this.bean.getLabelFont().getSize());
                } else {
                    mkmods.setFontSize(12);
                }
            } else {
                double fsize = 12.0;
                convFactor = null;
                if (this.bean.getLabelFontSizeUnit() != null) {
                    convFactor = SRS.getDistanceConversionFactor(this.bean.getLabelFontSizeUnit());
                }
                if (this.bean.getLabelFont() != null && convFactor != null) {
                    fsize = (double)this.bean.getLabelFont().getSize() * convFactor;
                    if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                        fsize = SphereCG.convertRadius(0.0, 0.0, fsize);
                        mkmods.setFontSize((int)(fsize / pixelY + 0.5));
                    } else {
                        mkmods.setFontSize((int)(fsize / pixelY + 0.5));
                    }
                } else {
                    mkmods.setFontSize(12);
                }
            }
            SizeDefinition2D txtoffset = this.bean.getLabelOffsetSize();
            convFactor = null;
            if (txtoffset.getUnit() != null) {
                convFactor = SRS.getDistanceConversionFactor(txtoffset.getUnit());
            }
            if (txtoffset.isPixelUnit()) {
                mkmods.setLabelOffsetX((int)this.bean.getLabelOffsetSizeX());
                mkmods.setLabelOffsetY((int)this.bean.getLabelOffsetSizeY());
            } else if (convFactor == null) {
                mkmods.setLabelOffsetX(0);
                mkmods.setLabelOffsetY(0);
            } else {
                double lbwidth = this.bean.getLabelOffsetSizeX() * convFactor;
                double lbheight = this.bean.getLabelOffsetSizeY() * convFactor;
                if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                    double dgw = SphereCG.convertRadius(0.0, 0.0, lbwidth);
                    mkmods.setLabelOffsetX((int)(dgw / pixelX + 0.5));
                    double dgh = SphereCG.convertRadius(0.0, 0.0, lbheight);
                    mkmods.setLabelOffsetY((int)(dgh / pixelY + 0.5));
                } else {
                    mkmods.setLabelOffsetX((int)(lbwidth / pixelX + 0.5));
                    mkmods.setLabelOffsetY((int)(lbheight / pixelY + 0.5));
                }
            }
        }
        return mkmods;
    }

    private boolean isPixelUnit(String unit) {
        return unit == null || unit.equalsIgnoreCase("px") || unit.equalsIgnoreCase("pt");
    }

    private void fillMarkerBackground(Graphics2D g, Rectangle2D rectMBR, double OffsetCoefX, double OffsetCoefY, double theta) {
        if (g == null || rectMBR == null) {
            return;
        }
        Color backColor = this.bean.getBackgroundColor();
        if (backColor == null) {
            return;
        }
        Paint backupPaint = g.getPaint();
        AffineTransform backupAffTr = g.getTransform();
        g.setPaint(backColor);
        double offsetX = rectMBR.getWidth() * OffsetCoefX;
        double offsetY = rectMBR.getHeight() * OffsetCoefY;
        AffineTransform afftr = new AffineTransform();
        afftr.setToRotation(theta, rectMBR.getMinX() + offsetX, rectMBR.getMinY() + offsetY);
        Shape shp = afftr.createTransformedShape(rectMBR);
        g.translate(rectMBR.getCenterX() - (rectMBR.getMinX() + offsetX), rectMBR.getCenterY() - (rectMBR.getMinY() + offsetY));
        g.fill(shp);
        g.setPaint(backupPaint);
        g.setTransform(backupAffTr);
    }
}

