/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class SDOFilter
implements SpatialOp {
    protected String dataSource;
    protected String targetGeometryColumn;
    protected JGeometry filterGeometry;
    protected double minResolution = Double.NaN;
    protected double maxResolution = Double.NaN;

    public SDOFilter(String dataSrc, String targetGeomColumn) {
        this.dataSource = dataSrc;
        this.targetGeometryColumn = targetGeomColumn;
    }

    @Override
    public void setOperationGeometry(JGeometry geom) {
        this.filterGeometry = geom;
    }

    @Override
    public JGeometry getOperationGeometry() {
        return this.filterGeometry;
    }

    @Override
    public int getSrid() {
        return this.filterGeometry != null ? this.filterGeometry.getSRID() : 0;
    }

    @Override
    public void prepare(PreparedStatement stmt) throws SQLException {
        STRUCT st = null;
        Connection conn = stmt.getConnection();
        Object[] descs = Util.createDBGeomDescriptors(conn);
        st = JGeometry.store((JGeometry)this.filterGeometry, (Connection)conn, (Object[])descs);
        OraclePreparedStatement ops = (OraclePreparedStatement)stmt;
        ops.setObjectAtName("svqfilterg", (Object)st);
        AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (ads == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        if (!ads.is9i() && !ads.isPre9i()) {
            if (!Double.isNaN(this.minResolution)) {
                ops.setDoubleAtName("svqminres", this.minResolution);
            }
            if (!Double.isNaN(this.maxResolution)) {
                ops.setDoubleAtName("svqmaxres", this.maxResolution);
            }
        }
    }

    @Override
    public String getSpatialPredicate() {
        AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (ads == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        StringBuffer sb = new StringBuffer(512);
        if (ads.is9i() || ads.isPre9i()) {
            sb.append("MDSYS.SDO_FILTER(" + this.targetGeometryColumn + ", " + ":svqfilterg, " + "'querytype=WINDOW'" + ") = 'TRUE'");
        } else if (Double.isNaN(this.minResolution) && Double.isNaN(this.maxResolution)) {
            sb.append("MDSYS.SDO_FILTER(" + this.targetGeometryColumn + ", " + ":svqfilterg" + ") = 'TRUE'");
        } else {
            String p1;
            String string = p1 = Double.isNaN(this.minResolution) ? "" : "min_resolution=:svqminres";
            String p2 = Double.isNaN(this.maxResolution) ? "" : (Double.isNaN(this.minResolution) ? "max_resolution=:svqmaxres" : " max_resolution=:svqmaxres");
            String p = "'" + p1 + p2 + "'";
            sb.append("MDSYS.SDO_FILTER(" + this.targetGeometryColumn + ", " + ":svqfilterg, " + p + ") = 'TRUE'");
        }
        return sb.toString();
    }

    @Override
    public void setDataSource(String dataSrc) {
        this.dataSource = dataSrc;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    public void setTargetGeometryColumn(String geomCol) {
        this.targetGeometryColumn = geomCol;
    }

    public String getTargetGeometryColumn() {
        return this.targetGeometryColumn;
    }

    public void setMinResoultion(double min) {
        this.minResolution = min;
    }

    public double getMinResoultion() {
        return this.minResolution;
    }

    public void setMaxResoultion(double max) {
        this.maxResolution = max;
    }

    public double getMaxResoultion() {
        return this.maxResolution;
    }

    @Override
    public int getNumBindingVariables() {
        return SDOFilter.getNumBindingVariables(this.dataSource, this.minResolution, this.maxResolution);
    }

    public static int getNumBindingVariables(String ds, double minResolution, double maxResolution) {
        AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(ds);
        if (ads == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        if (ads.is9i() || ads.isPre9i()) {
            return 1;
        }
        if (Double.isNaN(minResolution) && Double.isNaN(maxResolution)) {
            return 1;
        }
        int cnt = 0;
        if (!Double.isNaN(minResolution)) {
            ++cnt;
        }
        if (!Double.isNaN(maxResolution)) {
            // empty if block
        }
        int n = ++cnt;
        ++cnt;
        return n;
    }
}

