/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.georss;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.mapviewer.share.Field;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.georss.GeoFeedParser;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RssParser
extends GeoFeedParser {
    private Document doc;
    private Hashtable groups;
    private String dataSrc;

    public RssParser(String dsrc) {
        this.dataSrc = dsrc;
    }

    @Override
    public StyledFeatureI[] parse(Document content) throws Exception {
        this.doc = content;
        ArrayList<StyledFeatureI> features = new ArrayList<StyledFeatureI>();
        this.parseRoot(features);
        this.parseGroups();
        NodeList nl = this.doc.getElementsByTagName("item");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node ent = nl.item(i);
            StyledFeatureI f = this.extractFeature(ent);
            if (f == null) continue;
            features.add(f);
        }
        return features.toArray(new StyledFeatureI[features.size()]);
    }

    protected void parseRoot(List features) {
    }

    protected void parseGroups() {
        NodeList nl = this.doc.getElementsByTagName("omv:group");
        if (nl == null || nl.getLength() == 0) {
            nl = this.doc.getElementsByTagName("group");
        }
        if (nl == null || nl.getLength() == 0) {
            return;
        }
        this.groups = new Hashtable();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            Group g = new Group();
            String a = XMLDOMParser.getAttribute(node, "name");
            if (a != null) {
                g.setName(a);
            }
            if ((a = XMLDOMParser.getAttribute(node, "title")) != null) {
                g.setTitle(a);
            }
            if ((a = XMLDOMParser.getAttribute(node, "description")) != null) {
                g.setDefaultIcon(a);
            }
            if ((a = XMLDOMParser.getAttribute(node, "default-style")) != null) {
                g.setDefaultStyle(a);
            }
            this.groups.put(g.getName(), g);
        }
    }

    protected StyledFeatureI extractFeature(Node node) {
        Group g;
        Field f;
        JSDOGeometry geom;
        StyledFeature sf = null;
        String title = null;
        Node _title = XMLDOMParser.getSubElement(node, "title");
        if (_title != null) {
            title = XMLDOMParser.getElementValue(_title);
        }
        String link = null;
        Node _link = XMLDOMParser.getSubElement(node, "link");
        if (_link != null) {
            link = XMLDOMParser.getElementValue(_link);
        }
        String desc = null;
        Node _desc = XMLDOMParser.getSubElement(node, "description");
        if (_desc != null) {
            desc = XMLDOMParser.getElementValue(_desc);
        }
        String group = null;
        Node _group = XMLDOMParser.getSubElement(node, "omv:group-name");
        if (_group != null) {
            group = XMLDOMParser.getElementValue(_group);
        }
        Object value = null;
        ArrayList _values = XMLDOMParser.getSubElements(node, "value");
        Field[] valueFields = null;
        if (_values != null && _values.size() > 0) {
            valueFields = new Field[_values.size()];
            for (int i = 0; i < _values.size(); ++i) {
                Node vn = (Node)_values.get(i);
                String type = XMLDOMParser.getAttribute(vn, "type");
                if (type == null) {
                    type = "number";
                }
                String v = XMLDOMParser.getElementValue(vn);
                if ("number".equalsIgnoreCase(type) || "double".equalsIgnoreCase(type)) {
                    double iv = Double.parseDouble(v);
                    valueFields[i] = new Field(iv);
                    continue;
                }
                if ("int".equalsIgnoreCase(type)) {
                    int iv = Integer.parseInt(v);
                    valueFields[i] = new Field(iv);
                    continue;
                }
                valueFields[i] = new Field(v);
            }
        }
        if ((geom = RssParser.extractLocation(node)) == null) {
            System.out.println("geom is Null!");
            return null;
        }
        double[] mbr = geom.getMBR();
        sf = new StyledFeature();
        sf.setLabel(title);
        ArrayList<Field> fields = new ArrayList<Field>(5);
        if (title != null) {
            f = new Field(title);
            f.setNameAndKey("Title", false, "Title");
            fields.add(f);
        }
        if (link != null) {
            f = new Field(link);
            f.setNameAndKey("Link", false, "Link");
            fields.add(f);
        }
        if (desc != null) {
            f = new Field(desc);
            f.setNameAndKey("Description", false, "Description");
            fields.add(f);
        }
        sf.setDataSource(this.dataSrc);
        sf.setGeometry(geom);
        sf.setIdentifiableAttributes(fields.toArray(new Field[fields.size()]));
        if (valueFields != null) {
            sf.setRenderableAttributes(valueFields);
        }
        if (group != null && this.groups != null && (g = (Group)this.groups.get(group)) != null) {
            sf.setFeatureStyleName(g.getDefaultStyle());
        }
        return sf;
    }

    public static class Group {
        String defaultIcon;
        String defaultStyle;
        String description;
        String name;
        String title;

        public void setDefaultIcon(String defaultIcon) {
            this.defaultIcon = defaultIcon;
        }

        public String getDefaultIcon() {
            return this.defaultIcon;
        }

        public void setDefaultStyle(String defaultStyle) {
            this.defaultStyle = defaultStyle;
        }

        public String getDefaultStyle() {
            return this.defaultStyle;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

