/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.georss;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.georss.AtomParser;
import oracle.sdovis.georss.GMLParser;
import oracle.sdovis.georss.RssParser;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WorldMercatorUtil;
import oracle.sdovis.util.XMLDOMParser;
import oracle.spatial.geometry.JGeometry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class GeoFeedParser {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public abstract StyledFeatureI[] parse(Document var1) throws Exception;

    public static StyledFeatureI[] loadFeatures(String url, String dataSrc, int toSrid) throws Exception {
        byte[] bs = Util.readBinaryFromURL(url);
        if (bs == null) {
            throw new Exception("Unable to read data from URL: " + url);
        }
        if (bs.length < 10) {
            return new StyledFeature[0];
        }
        log.finest("GeoRss feed:" + new String(bs, 0, bs.length > 80 ? 80 : bs.length));
        String str = new String(bs);
        XMLDOMParser p = new XMLDOMParser();
        boolean res = p.parse(str);
        if (!res) {
            throw new Exception("cannot parse a GeoRss feed.");
        }
        StyledFeatureI[] result = null;
        Document doc = p.getDocument();
        boolean rdfExists = GeoFeedParser.nodeExists(doc, "rdf:RDF");
        boolean rssExists = GeoFeedParser.nodeExists(doc, "rss");
        if (rdfExists || rssExists) {
            RssParser rp = new RssParser(dataSrc);
            result = rp.parse(doc);
        } else if (GeoFeedParser.nodeExists(doc, "feed")) {
            AtomParser ap = new AtomParser(dataSrc);
            result = ap.parse(doc);
        }
        if (result == null || result.length == 0) {
            log.warning("Not a recognized GeoRss feed or the feed is empty.");
            return new StyledFeature[0];
        }
        if (toSrid != 0 && toSrid != 8307 && toSrid != 8265) {
            GeoFeedParser.transformFeatures(result, toSrid, dataSrc);
        }
        return result;
    }

    public static JSDOGeometry extractLocation(Node node) {
        JSDOGeometry geom = null;
        double[] xy = new double[]{-9999.0, -9999.0};
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node e = nl.item(i);
            String nodeName = e.getNodeName();
            if ((nodeName.startsWith("georss:") || nodeName.startsWith("gml:")) && (geom = GeoFeedParser.parseGeoRSS(e)) != null) {
                return geom;
            }
            if (nodeName.startsWith("geo:lat")) {
                String _lat = XMLDOMParser.getElementValue(e);
                xy[1] = Double.parseDouble(_lat);
            }
            if (!nodeName.startsWith("geo:long")) continue;
            String _long = XMLDOMParser.getElementValue(e);
            xy[0] = Double.parseDouble(_long);
        }
        if (xy[0] == -9999.0 || xy[1] == -9999.0) {
            return null;
        }
        return JSDOGeometry.recast(JSDOGeometry.createPoint((double[])xy, (int)2, (int)8307));
    }

    public static JSDOGeometry parseGeoRSS(Node node) {
        String nodeName = node.getNodeName();
        if ("georss:where".equals(nodeName = nodeName.toLowerCase(Locale.ENGLISH))) {
            Node e = XMLDOMParser.getFirstRealChildNode(node);
            return GeoFeedParser.parseGeoRSS(e);
        }
        if ("georss:point".equals(nodeName)) {
            String coord = XMLDOMParser.getElementValue(node);
            ArrayList l = Util.splitBy(coord, " ");
            double[] xy = new double[2];
            xy[1] = Double.parseDouble((String)l.get(0));
            xy[0] = Double.parseDouble((String)l.get(1));
            return JSDOGeometry.recast(JSDOGeometry.createPoint((double[])xy, (int)2, (int)8307));
        }
        if ("georss:line".equals(nodeName)) {
            String coord = XMLDOMParser.getElementValue(node);
            ArrayList l = Util.splitBy(coord, " ");
            double[] coords = new double[l.size()];
            for (int i = 0; i < l.size() / 2; ++i) {
                coords[i * 2] = Double.parseDouble((String)l.get(i * 2 + 1));
                coords[i * 2 + 1] = Double.parseDouble((String)l.get(i * 2));
            }
            return JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])coords, (int)2, (int)8307));
        }
        if ("georss:polygon".equals(nodeName)) {
            String coord = XMLDOMParser.getElementValue(node);
            ArrayList l = Util.splitBy(coord, " ");
            double[] coords = new double[l.size()];
            for (int i = 0; i < l.size() / 2; ++i) {
                coords[i * 2] = Double.parseDouble((String)l.get(i * 2 + 1));
                coords[i * 2 + 1] = Double.parseDouble((String)l.get(i * 2));
            }
            return JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])coords, (int)2, (int)8307));
        }
        if ("georss:box".equals(nodeName)) {
            String coord = XMLDOMParser.getElementValue(node);
            ArrayList l = Util.splitBy(coord, " ");
            double x1 = Double.parseDouble((String)l.get(1));
            double y1 = Double.parseDouble((String)l.get(0));
            double x2 = Double.parseDouble((String)l.get(3));
            double y2 = Double.parseDouble((String)l.get(2));
            JSDOGeometry g = new JSDOGeometry(Math.min(x1, x2), Math.min(y1, y2), Math.max(x1, x2), Math.max(y1, y2), 8307);
            return JSDOGeometry.recast(g);
        }
        if (nodeName.startsWith("gml:")) {
            JGeometry g = GMLParser.getGeometry(node);
            return g != null ? JSDOGeometry.recast(g) : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transformFeatures(StyledFeatureI[] result, int toSrid, String dataSrc) {
        Connection c = null;
        JSDOGeometry geom1 = null;
        JSDOGeometry geom2 = null;
        try {
            long t1 = System.currentTimeMillis();
            int inSrid = 0;
            int i = 0;
            for (i = 0; i < result.length; ++i) {
                StyledFeatureI sf = result[i];
                geom1 = sf.getGeometry();
                if (geom1 == null) continue;
                inSrid = geom1.getSRID();
                if (inSrid == 8307 && toSrid == 54004) {
                    geom2 = WorldMercatorUtil.geodeticToMercator(geom1);
                } else if (inSrid == 54004 && toSrid == 8307) {
                    geom2 = WorldMercatorUtil.mercatorToGeodetic(geom1);
                } else {
                    if (c == null && (c = DSUtil.getDBConnection(dataSrc, null)) == null) {
                        log.severe("Cannot obtain connection from data source " + dataSrc + ".");
                        return;
                    }
                    geom2 = Util.transform(c, geom1, inSrid, toSrid);
                }
                if (geom2 == null) continue;
                sf.setGeometry(geom2);
            }
            long t2 = System.currentTimeMillis();
            log.finest("Time transforming " + i + " features from " + inSrid + " to " + toSrid + ": " + (t2 - t1) + "ms.");
        }
        catch (Exception e) {
            log.warning("Error transforming geometry:\n" + e.getMessage());
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        XMLDOMParser p = new XMLDOMParser();
        String str = new String(Util.readFile("/tmp/rss.xml"));
        boolean res = p.parse(str);
        if (!res) {
            throw new Exception("cannot parse a GeoRss feed.");
        }
        Document doc = p.getDocument();
        RssParser rp = new RssParser("mvdemo");
        StyledFeatureI[] sf = rp.parse(doc);
        p = new XMLDOMParser();
        str = new String(Util.readFile("/tmp/atom.xml"));
        res = p.parse(str);
        if (!res) {
            throw new Exception("cannot parse a GeoRss feed.");
        }
        doc = p.getDocument();
        AtomParser ap = new AtomParser("mvdemo");
        sf = ap.parse(doc);
    }

    private static boolean nodeExists(Document doc, String tagName) {
        if (doc == null) {
            return false;
        }
        NodeList nl = doc.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            return true;
        }
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!tagName.equals(n.getNodeName())) continue;
            return true;
        }
        return false;
    }
}

