/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.edit.session;

import java.awt.Color;
import java.util.Vector;
import oracle.sdovis.edit.session.EditSessionAttributes;
import oracle.sdovis.edit.session.EditSessionView;
import oracle.sdovis.edit.session.layer.EditSessionLayer;
import oracle.spatial.geometry.JGeometry;

public class EditSessionDescriptor {
    public static String INACTIVE_STATUS = "INACTIVE";
    public static String ACTIVE_STATUS = "ACTIVE";
    private String name = null;
    private String description = null;
    private String editor = null;
    private JGeometry area = null;
    private String workspace = null;
    private String status = INACTIVE_STATUS;
    private Vector<EditSessionLayer> layers = new Vector();
    private EditSessionView view = new EditSessionView();
    private EditSessionAttributes attributes = new EditSessionAttributes();
    private String definition = null;

    public EditSessionDescriptor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String user) {
        this.editor = user;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setArea(JGeometry geom) {
        this.area = geom;
    }

    public JGeometry getArea() {
        return this.area;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String wksp) {
        this.workspace = wksp;
        this.view.setWorkspaceName(wksp);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String st) {
        this.status = st;
    }

    public EditSessionLayer getLayer(String name) {
        if (name == null || this.layers == null || this.layers.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            EditSessionLayer td = this.layers.get(i);
            if (td.getName() == null || !td.getName().equalsIgnoreCase(name)) continue;
            return td;
        }
        return null;
    }

    public EditSessionLayer getLayer(int index) {
        if (index < 0 || index >= this.layers.size()) {
            return null;
        }
        return this.layers.get(index);
    }

    public boolean addLayer(EditSessionLayer layer) {
        if (layer == null || this.getLayer(layer.getName()) != null) {
            return false;
        }
        return this.layers.add(layer);
    }

    public void clearLayers() {
        this.layers.clear();
    }

    public boolean removeLayer(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            EditSessionLayer td = this.layers.get(i);
            if (!td.getName().equalsIgnoreCase(name)) continue;
            return this.layers.remove(td);
        }
        return false;
    }

    public int getLayerIndex(String name) {
        if (name == null) {
            return -1;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            EditSessionLayer td = this.layers.get(i);
            if (!td.getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public void moveLayerUp(String name) {
        int index = this.getLayerIndex(name);
        if (index < 1) {
            return;
        }
        EditSessionLayer t = this.layers.remove(index);
        this.layers.insertElementAt(t, index - 1);
    }

    public void moveLayerDown(String name) {
        int index = this.getLayerIndex(name);
        if (index == -1 || index == this.layers.size() - 1) {
            return;
        }
        EditSessionLayer t = this.layers.remove(index);
        this.layers.insertElementAt(t, index + 1);
    }

    public void moveLayerAllUp(String layer) {
        int index = this.getLayerIndex(layer);
        if (index < 1) {
            return;
        }
        EditSessionLayer t = this.layers.remove(index);
        this.layers.insertElementAt(t, 0);
    }

    public void moveLayerAllDown(String layer) {
        int index = this.getLayerIndex(layer);
        if (index == -1 || index == this.layers.size() - 1) {
            return;
        }
        EditSessionLayer t = this.layers.remove(index);
        this.layers.insertElementAt(t, this.layers.size());
    }

    public Vector<EditSessionLayer> getEditLayers() {
        return this.layers;
    }

    public int getNumberOfLayers() {
        if (this.layers == null) {
            return 0;
        }
        return this.layers.size();
    }

    public EditSessionView getEditView() {
        return this.view;
    }

    public EditSessionAttributes getEditAttributes() {
        return this.attributes;
    }

    public void setEditAttributes(EditSessionAttributes attrs) {
        this.attributes = attrs;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String xmlDef) {
        this.definition = xmlDef;
    }

    private double parseDoubleNumber(String value) {
        if (value == null) {
            return Double.NaN;
        }
        try {
            double v = Double.parseDouble(value);
            return v;
        }
        catch (Exception ex) {
            return Double.NaN;
        }
    }

    public boolean isLayerEditable(String layer) {
        EditSessionLayer ly = this.getLayer(layer);
        if (ly == null) {
            return false;
        }
        return ly.isEditable();
    }

    public void setLayerEditable(String layer, boolean editable) {
        EditSessionLayer ly = this.getLayer(layer);
        if (ly == null) {
            return;
        }
        ly.setEditable(editable);
    }

    public boolean isLayerVisible(String layer) {
        EditSessionLayer ly = this.getLayer(layer);
        if (ly == null) {
            return false;
        }
        return ly.isVisible();
    }

    public void setLayerVisible(String layer, boolean visible) {
        EditSessionLayer ly = this.getLayer(layer);
        if (ly == null) {
            return;
        }
        ly.setVisible(visible);
    }

    public boolean isLayerShareBoundary(String layer) {
        EditSessionLayer ly = this.getLayer(layer);
        if (layer == null) {
            return false;
        }
        return ly.isSharedBoundary();
    }

    public void setLayerShareBoundary(String layer, boolean share) {
        EditSessionLayer ly = this.getLayer(layer);
        if (ly == null) {
            return;
        }
        ly.setSharedBoundary(share);
    }

    public boolean isLayerMVPredefined(String layer) {
        EditSessionLayer ly = this.getLayer(layer);
        if (ly == null) {
            return false;
        }
        String type = ly.getSpatialType();
        return type != null && type.equalsIgnoreCase(EditSessionLayer.PREDEFINEDTHEME_TYPE);
    }

    public EditSessionLayer[] getLayers() {
        if (this.layers.size() == 0) {
            return null;
        }
        return this.layers.toArray(new EditSessionLayer[this.layers.size()]);
    }

    public boolean hasEditableLayers() {
        if (this.layers.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            EditSessionLayer el = this.layers.get(i);
            if (!el.isEditable()) continue;
            return true;
        }
        return false;
    }

    public boolean hasValidArea() {
        return !Double.isNaN(this.view.getMapCenterX()) && !Double.isNaN(this.view.getMapCenterY()) && !Double.isNaN(this.view.getMapHeight());
    }

    private boolean haveEqualRGB(Color color1, Color color2) {
        if (color1 == null || color2 == null) {
            return false;
        }
        int red = color1.getRed();
        int green = color1.getGreen();
        int blue = color1.getBlue();
        int r = color2.getRed();
        int g = color2.getGreen();
        int b = color2.getBlue();
        return red == r && green == g && blue == b;
    }
}

