/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts.piechart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.charts.Chart;
import oracle.sdovis.charts.internal.Errorfcn;
import oracle.sdovis.charts.internal.MsgUtil;
import oracle.sdovis.charts.internal.Precision;
import oracle.sdovis.charts.internal.RoundGradientPaint;
import oracle.sdovis.charts.internal.SliceLabelBreak;
import oracle.sdovis.charts.types.ChartException;
import oracle.sdovis.charts.types.GaugeStyleDesc;
import oracle.sdovis.charts.types.ImageMapAreaDesc;
import oracle.sdovis.charts.types.PieSliceDesc;
import oracle.sdovis.charts.types.PieStyleDesc;

public class PieChart
extends Chart {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private final int PIECHART = 0;
    private final int GAUGE = 1;
    private int PieSubType = 0;
    double GaugeSpanPrivate = 120.0;
    double GaugeLevelPrivate = 50.0;
    double GaugeWidthFraction = 1.0;
    Color GaugeNeedleColorPrivate = Color.black;
    double GaugeLevelDegreesPrivate = 0.0;
    double GaugeNeedleX = 0.0;
    double GaugeNeedleY = 0.0;
    double initialStartAngle = 0.0;
    PieSliceDesc[] SliceDesc;
    PieSliceAngle[] SliceAngle;
    PieSliceLabelLoc[] SliceLabelLoc;
    String[] SliceSecondLabel;
    String[] SliceOriginalLabel;
    StoredLayout[] SliceStoredLayout;
    Arc2D[] Arc;
    boolean[] interiorLabel;
    boolean AutoColorAdjustSliceLabel = true;
    boolean DrawLegend = false;
    BufferedImage BI = null;
    int displayHeight = super.getHeight();
    int displayWidth = super.getWidth();
    double PieDiameterFraction = 0.6;
    int PieDiameter = (int)((double)Math.min(this.displayWidth, this.displayHeight) * this.PieDiameterFraction);
    double PieRadius = (double)this.PieDiameter / 2.0;
    int PieDiameterHeight = this.PieDiameter;
    int PieDiameterWidth = this.PieDiameter;
    Color colorStart = new Color(0.9f, 0.9f, 0.9f);
    Color colorEnd = new Color(0.4f, 0.4f, 0.4f);
    boolean userDefinedPieColors = false;
    int XOffset = (int)Math.round((double)(this.displayWidth - this.PieDiameter) / 2.0);
    int YOffset = (int)Math.round((double)(this.displayHeight - this.PieDiameter) / 2.0);
    static final int DRAWNOTHING = 0;
    static final int DRAWALL = 1;
    static final int DRAWSLICEONLY = 2;
    int HilightIndex = -1;
    int HilightLabelIndex = -1;
    Color HilightColor = Color.blue;
    Color HilightLabelColor = Color.white;
    boolean testInSlice = false;
    boolean testPie = false;
    boolean testPlace90 = false;
    boolean testRect = false;
    boolean testcomputeScore = false;
    boolean test = false;
    boolean testdrawBuffer = false;
    boolean test2 = false;
    boolean testAutoDiameter = false;
    boolean drawText = true;
    private boolean fontMetricsGot = false;
    private Font font = new Font("sansserif", 1, 12);
    private FontMetrics fontmet;
    boolean disableLegend = false;
    boolean drawBackgroundRect = true;
    boolean lastWordNewline = false;
    String SeparateLineChars = "";
    char[] SeparateLineCharsC = new char[0];
    boolean userDefinedDelimiters = false;
    char[] userDelimiters;
    int LabelPrecision = -1;
    int CircumfVerticalSpace = 0;
    int CircumfHorizontalSpace = 0;
    int LegendPieYSpacer = 5;
    int LegendPieXSpacer = 5;
    int MIN_PIE = 0;
    CrescentAdjust Adjust3D = new CrescentAdjust();
    boolean deriveLabelPct = false;
    boolean deriveLabelVal = false;
    boolean useNumberFormat = false;
    NumberFormat numFormat = null;
    boolean labelInteriorPct = false;
    boolean labelInteriorVal = false;
    PieStyleDesc StyleDesc = new PieStyleDesc();
    GaugeStyleDesc GaugeStyleDesc = new GaugeStyleDesc();
    double[] savedSliceValues;
    boolean clockwise = false;
    Color Grey5 = new Color(0.5f, 0.5f, 0.5f);
    final double almostZero = 0.001;
    final double almostOne = 0.999;
    LayoutScore LScore;
    ScoreDesc ScoreD = new ScoreDesc();
    double xMinNormalized = -1.0;
    double yMinNormalized = -1.0;
    double xMaxNormalized = 1.0;
    double yMaxNormalized = 1.0;
    double xMinTextNormalized = -1.0;
    double yMinTextNormalized = -1.0;
    double xMaxTextNormalized = 1.0;
    double yMaxTextNormalized = 1.0;
    double CircumLabelHeightOffset = 0.0;
    double CircumLabelWidthOffset = 0.0;
    int CircumLabelHeightOffsetInt = 0;
    int CircumLabelWidthOffsetInt = 0;
    double CircumLabelNorthExtra = 0.0;
    double CircumLabelSouthExtra = 0.0;
    int CircumLabelNorthExtraInt = 0;
    int CircumLabelSouthExtraInt = 0;
    double CircumLabelEastExtra = 0.0;
    double CircumLabelWestExtra = 0.0;
    int CircumLabelEastExtraInt = 0;
    int CircumLabelWestExtraInt = 0;
    int minX = Integer.MAX_VALUE;
    int maxX = Integer.MIN_VALUE;
    int minY = Integer.MAX_VALUE;
    int maxY = Integer.MIN_VALUE;
    boolean[] IEGlobal;
    BasicStroke PieStroke = new BasicStroke(1.0f, 0, 2);
    BasicStroke ConnectorStroke = new BasicStroke(1.0f, 0, 1);
    Color Foreground = Color.black;
    Color ConnectorColor = Color.black;
    boolean simpleApproach = false;
    boolean forceLegendApproach = false;
    boolean DrawBufferCalled = false;
    RenderingHints RHOriginal = null;
    Effect3D E3D = new Effect3D();
    private static final int POINTER_BACKGROUND = 0;
    private static final int POINTER_HIGHLIGHT = 1;
    float CenterX;
    float CenterY;
    int NumMinorTicks = 20;
    int MajorTickLength = 11;
    int MinorTickLength = 7;
    BasicStroke MajorTickStroke = new BasicStroke(2.0f, 1, 1);
    double InnerTickPos = this.PieRadius * 0.75;
    int InnerTickLength = 6;
    boolean DrawFirstAndLastMajorTicks = true;
    boolean genImageMapCoords = false;
    int[][] ImageMapCoords;
    int ImageMapShape = 1;
    boolean SizeChanged = false;
    boolean circumferenceCalled = false;
    private double PieRadiusCircumL = 0.0;
    double NormalizationFactor = 1.0;
    ExLabelLayout exLayout;

    public PieChart() {
        this.initPie();
    }

    public String getChartState() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.emitVersion());
        sbuf.append("PieChart chs = new PieChart();\n\n");
        sbuf.append(this.emitSize());
        sbuf.append(this.emitBackground());
        sbuf.append(this.emitEdgeColor());
        sbuf.append(this.emitSetFont());
        sbuf.append(this.emitTitle());
        sbuf.append(this.emitBorders());
        sbuf.append(this.emitSeriesDirection());
        sbuf.append(this.emitStartAngle());
        sbuf.append(this.emitSeries());
        return sbuf.toString();
    }

    protected String emitStartAngle() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("chs.setStartAngle(");
        sbuf.append(this.initialStartAngle);
        sbuf.append(");\n");
        return sbuf.toString();
    }

    protected String emitSetFont() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("chs.");
        sbuf.append(this.emitFont(this.font));
        return sbuf.toString();
    }

    protected String emitSeries() {
        int i;
        StringBuffer sbuf = new StringBuffer();
        int length = this.SliceDesc.length;
        sbuf.append("\n");
        sbuf.append("PieSliceDesc slices[] = {\n");
        for (i = 0; i < length; ++i) {
            if (this.SliceDesc[i] == null) continue;
            sbuf.append("  new PieSliceDesc(\"");
            sbuf.append(this.SliceOriginalLabel[i]);
            sbuf.append("\", ");
            sbuf.append(this.savedSliceValues[i]);
            sbuf.append("),\n");
        }
        sbuf.append("};\n\n");
        for (i = 0; i < length; ++i) {
            if (this.SliceDesc[i] == null) continue;
            sbuf.append("slices[");
            sbuf.append(i);
            sbuf.append("].setBackground(");
            sbuf.append(this.emitNewColor(this.SliceDesc[i].getBackground()));
            sbuf.append(");\n");
        }
        sbuf.append("chs.setSeries(slices);\n");
        sbuf.append(this.emitStyle());
        return sbuf.toString();
    }

    protected String emitSeriesDirection() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("chs.setSeriesDirection(");
        sbuf.append(this.getSeriesDirection());
        sbuf.append(");\n");
        return sbuf.toString();
    }

    protected String emitStyle() {
        StringBuffer sbuf = new StringBuffer();
        if (this.StyleDesc.getStyleType() == 2) {
            sbuf.append("\n// 3D style \n");
            sbuf.append("PieStyleDesc styleD = new PieStyleDesc();\n");
            sbuf.append("styleD.setStyleType(PieStyleDesc.STYLE_EFFECT_3D);\n");
            sbuf.append("styleD.setExtrusionAngle(");
            sbuf.append(this.StyleDesc.getExtrusionAngle());
            sbuf.append(");\n");
            sbuf.append("styleD.setExtrusionThickness(");
            sbuf.append(this.StyleDesc.getExtrusionThickness());
            sbuf.append(");\n");
            sbuf.append("styleD.setPerspectiveDistance(");
            sbuf.append(this.StyleDesc.getPerspectiveDistance());
            sbuf.append(");\n");
            sbuf.append("chs.setChartAttributes(styleD);\n");
        }
        return sbuf.toString();
    }

    protected void initPie() {
        this.assertPieChart();
        try {
            this.L2.getLegendDesc().setLegendAlignment(-1);
            this.L2.resetLegendAlignment();
        }
        catch (ChartException chartException) {
            // empty catch block
        }
        this.L2.setPieChartType(true);
        this.L2.setMaximumSize(this.getWidth(), this.getHeight());
        this.L2.setBorders(this.getBorderLeft(), this.getBorderRight(), this.getBorderTop(), this.getBorderBottom());
    }

    protected void initGauge(double gaugeSpanDegrees, double gaugeLevel, Color needleFillColor) {
        this.assertPieChart();
        try {
            this.L2.getLegendDesc().setLegendAlignment(4);
        }
        catch (ChartException e) {
            // empty catch block
        }
        this.setGaugeSpanPrivate(gaugeSpanDegrees);
        this.setGaugeLevelPrivate(gaugeLevel);
        this.setGaugeNeedleColorPrivate(needleFillColor);
        this.PieSubType = 1;
        this.initGaugeStyleParams();
    }

    protected void initGaugeStyleParams() {
        this.E3D.setExtrusionAngle(this.GaugeStyleDesc.getShadowAngle());
        this.E3D.setExtrusionThickness(this.GaugeStyleDesc.getShadowThickness());
        this.MajorTickLength = (int)Math.round(this.PieRadius * this.GaugeStyleDesc.getTickLengthMajor());
        this.MinorTickLength = (int)Math.round(this.PieRadius * this.GaugeStyleDesc.getTickLengthMinor());
    }

    protected void setGaugeSpanPrivate(double gaugeDegrees) {
        this.GaugeSpanPrivate = gaugeDegrees;
        this.initialStartAngle = (180.0 - gaugeDegrees) / 2.0;
        this.GaugeWidthFraction = Math.cos(Math.toRadians(this.initialStartAngle));
        if (this.SliceDesc != null && this.savedSliceValues.length > 0) {
            this.recomputeSliceValues();
        }
    }

    protected void setGaugeLevelPrivate(double gaugeLevel) {
        this.GaugeLevelPrivate = gaugeLevel;
    }

    protected void setGaugeNeedleColorPrivate(Color c) {
        this.GaugeNeedleColorPrivate = c;
    }

    private void computeGaugeNeedle() {
        int gaugeNeedleLengthReduce = this.MinorTickLength / 2;
        if (gaugeNeedleLengthReduce < 0) {
            gaugeNeedleLengthReduce = 0;
        }
        this.GaugeLevelDegreesPrivate = this.initialStartAngle + this.GaugeSpanPrivate * (this.GaugeLevelPrivate / 100.0);
        double gaugeNeedleRadians = Math.toRadians(this.GaugeLevelDegreesPrivate);
        double centerX = (double)this.XOffset + (double)this.CircumLabelWidthOffsetInt + this.PieRadius;
        double centerY = (double)this.YOffset + (double)this.CircumLabelHeightOffsetInt + this.PieRadius;
        this.GaugeNeedleX = Math.cos(gaugeNeedleRadians) * (this.PieRadius - (double)gaugeNeedleLengthReduce) + centerX;
        this.GaugeNeedleY = -Math.sin(gaugeNeedleRadians) * (this.PieRadius - (double)gaugeNeedleLengthReduce) + centerY;
    }

    public void setChartLocale(Locale Locale2) {
        this.ChartLocale = Locale2;
    }

    public Locale getChartLocale() {
        return this.ChartLocale;
    }

    @Override
    public void setFont(Font f) {
        this.font = f;
        this.fontMetricsGot = false;
    }

    private void getFMetrics(Graphics2D g2) {
        if (this.fontMetricsGot) {
            return;
        }
        this.fontmet = g2.getFontMetrics(this.font);
        this.fontMetricsGot = true;
    }

    public void setStartAngle(double angle) {
        this.initialStartAngle = angle;
    }

    public void setExternalLabelsOff() {
        this.simpleApproach = true;
    }

    public void setLegendForceOn() {
        this.forceLegendApproach = true;
    }

    public void setLegendDisable(boolean disable) {
        this.disableLegend = true;
    }

    public boolean getLegendDisable() {
        return this.disableLegend;
    }

    public void setBackgroundRectOff() {
        this.drawBackgroundRect = false;
    }

    public void setLastWordNewline() {
        this.lastWordNewline = true;
    }

    public void setSeparateLine(char delimiter) {
        this.SeparateLineCharsC = new char[1];
        this.SeparateLineCharsC[0] = delimiter;
    }

    public void setSeparateLine(char[] delimiters) {
        this.SeparateLineCharsC = delimiters;
    }

    public void setDelimiter(char delimiter) {
        this.userDefinedDelimiters = true;
        this.userDelimiters = new char[]{delimiter};
    }

    public void setDelimiter(char[] delimiters) {
        this.userDefinedDelimiters = true;
        this.userDelimiters = delimiters;
    }

    public void setEnableAutoColorAdjustSliceLabel(boolean enable) {
        this.AutoColorAdjustSliceLabel = enable;
    }

    public boolean getEnableAutoColorAdjustSliceLabel() {
        return this.AutoColorAdjustSliceLabel;
    }

    private void dumpDelimiters() {
        System.out.println("dumpDelimiters" + this.userDelimiters.length);
        for (int i = 0; i < this.userDelimiters.length; ++i) {
            System.out.println("|" + this.userDelimiters[i] + "|");
        }
    }

    private boolean containsDelimiters(PieSliceDesc SliceD) {
        String label = SliceD.getLabel();
        if (label == null || label == "") {
            return false;
        }
        label = label.trim();
        if (!this.userDefinedDelimiters) {
            int delimiterIndex = label.indexOf(32);
            if (delimiterIndex > -1) {
                return true;
            }
        } else {
            for (int i = 0; i < this.userDelimiters.length; ++i) {
                int delimiterIndex = label.indexOf(this.userDelimiters[i]);
                if (delimiterIndex <= -1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsSeparateLineDelimiters(PieSliceDesc SliceD) {
        String label = SliceD.getLabel();
        if (label == null || label == "") {
            return false;
        }
        for (int i = 0; i < this.SeparateLineCharsC.length; ++i) {
            int delimiterIndex = label.indexOf(this.SeparateLineCharsC[i]);
            if (delimiterIndex <= -1) continue;
            return true;
        }
        return false;
    }

    private int evenPieDiameter(int diameter) {
        if (diameter % 2 != 0) {
            --diameter;
        }
        return diameter;
    }

    private void setPieDiameter2() {
        int halfVerticalSpace;
        boolean testPie = false;
        testPie = false;
        int maxPieWidth = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.ScoreD.space_left_needed - this.ScoreD.space_right_needed;
        int maxPieHeight = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - this.ScoreD.space_top_needed - this.ScoreD.space_bottom_needed;
        if (maxPieHeight < 0) {
            maxPieHeight = 10;
        }
        if (maxPieWidth < 0) {
            maxPieWidth = 10;
        }
        PieDim maxSpace = new PieDim();
        if (this.StyleDesc.getStyleType() != 0) {
            maxSpace.width = maxPieWidth;
            maxSpace.height = maxPieHeight;
            maxSpace = this.Adjust3D.setAdjustPieDiameter(maxSpace);
            maxPieWidth = maxSpace.width;
            maxPieHeight = maxSpace.height;
        }
        if (this.PieSubType == 1) {
            if (this.GaugeSpanPrivate <= 180.0) {
                maxPieHeight *= 2;
            }
            maxPieWidth = (int)((double)maxPieWidth + (double)maxPieWidth * (1.0 - this.GaugeWidthFraction));
        }
        this.PieDiameter = Math.min(maxPieWidth, maxPieHeight);
        this.PieDiameter = this.evenPieDiameter(this.PieDiameter);
        this.PieRadius = (double)this.PieDiameter / 2.0;
        this.PieDiameterHeight = this.PieDiameter;
        this.PieDiameterWidth = this.PieDiameter;
        if (this.PieSubType == 1) {
            this.PieDiameterHeight = this.PieDiameter / 2;
            this.PieDiameterWidth = this.PieDiameter;
        }
        int xWhiteSpace = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.ScoreD.space_left_needed - this.ScoreD.space_right_needed - this.PieDiameterWidth - this.CircumLabelEastExtraInt - this.CircumLabelWestExtraInt;
        int yWhiteSpace = this.displayHeight - super.getBorderTop() - this.ScoreD.space_top_needed - super.getBorderBottom() - this.ScoreD.space_bottom_needed - this.PieDiameterHeight - this.CircumLabelNorthExtraInt - this.CircumLabelSouthExtraInt;
        this.YOffset = super.getBorderTop() + this.ScoreD.space_top_needed + (yWhiteSpace -= this.Adjust3D.Offset3D_Bottom + this.Adjust3D.Offset3D_Top) / 2;
        this.XOffset = super.getBorderLeft() + this.ScoreD.space_left_needed + (xWhiteSpace -= this.Adjust3D.Offset3D_Left + this.Adjust3D.Offset3D_Right) / 2;
        this.XOffset += this.Adjust3D.Offset3D_Left;
        this.YOffset += this.Adjust3D.Offset3D_Top;
        int halfHorizontalSpace = this.getAvailableHorizontalSpace() / 2;
        this.ScoreD.space_top_available = halfVerticalSpace = this.getAvailableVerticalSpace() / 2;
        this.ScoreD.space_bottom_available = halfVerticalSpace;
        this.ScoreD.space_left_available = halfHorizontalSpace;
        this.ScoreD.space_right_available = halfHorizontalSpace;
    }

    private int getAvailableHorizontalSpace() {
        int horizontalSpace = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.PieDiameter - this.CircumLabelEastExtraInt - this.CircumLabelWestExtraInt;
        return horizontalSpace -= this.Adjust3D.Offset3D_Left + this.Adjust3D.Offset3D_Right;
    }

    private int getAvailableVerticalSpace() {
        int verticalSpace = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - this.PieDiameter - this.CircumLabelNorthExtraInt - this.CircumLabelSouthExtraInt;
        return verticalSpace -= this.Adjust3D.Offset3D_Bottom + this.Adjust3D.Offset3D_Top;
    }

    private void setPieCenter() {
        int freeVertical = this.ScoreD.space_top_available + this.ScoreD.space_bottom_available - (this.ScoreD.space_top_needed + this.ScoreD.space_bottom_needed);
        int freeHorizontal = this.ScoreD.space_left_available + this.ScoreD.space_right_available - (this.ScoreD.space_left_needed + this.ScoreD.space_right_needed);
        this.XOffset = super.getBorderLeft() + this.ScoreD.space_left_needed + freeHorizontal / 2;
        this.YOffset = super.getBorderTop() + this.ScoreD.space_top_needed + freeVertical / 2;
        this.XOffset += this.Adjust3D.Offset3D_Left;
        this.YOffset += this.Adjust3D.Offset3D_Top;
    }

    protected int countLegendColumns(int width) {
        int maxCols;
        int legWidth = this.L2.getLegendColumnWidth();
        int numItems = this.L2.getLegendNumItems();
        if (numItems < (maxCols = width / legWidth)) {
            return numItems;
        }
        int numRows = Precision.IntCeil(numItems, maxCols);
        int numCols = Precision.IntCeil(numItems, numRows);
        return numCols;
    }

    protected int countLegendColsHeight(int height, int width) {
        int legendHeightProjected = this.L2.getLegendHeightProjected(1);
        int numCols = Precision.IntCeil(legendHeightProjected, height);
        int lw = this.L2.getLegendWidth() * numCols;
        if (lw > width - this.MIN_PIE) {
            numCols = this.countLegendColumns(width - this.MIN_PIE);
        }
        return numCols;
    }

    private int getAvailableWidth() {
        return this.getAvailableWidth(false);
    }

    private int getAvailableWidth(boolean maxWidthFraction) {
        int availableWidth = this.displayWidth - super.getBorderLeft() - super.getBorderRight();
        if (maxWidthFraction) {
            availableWidth = (int)((double)availableWidth * this.L2.getLegendDesc().getLegendMaxWidthFraction());
        }
        return availableWidth;
    }

    private int getAvailableHeight() {
        return this.getAvailableHeight(false);
    }

    private int getAvailableHeight(boolean maxHeightFraction) {
        int availableHeight = this.displayHeight - super.getBorderTop() - super.getBorderBottom();
        if (maxHeightFraction) {
            availableHeight = (int)((double)availableHeight * this.L2.getLegendDesc().getLegendMaxHeightFraction());
        }
        return availableHeight;
    }

    private boolean setPieDiameterLegend(int legendWidth, int legendHeight) {
        boolean testPie = false;
        testPie = false;
        int legendColumnsProjected = 0;
        int legendHeightProjected = 0;
        int alignment = this.L2.getLegendDesc().getLegendAlignment();
        switch (alignment) {
            case -1: 
            case 4: 
            case 7: {
                legendColumnsProjected = this.countLegendColumns(this.displayWidth);
                legendHeightProjected = this.L2.getLegendHeightProjected(legendColumnsProjected);
                break;
            }
            case 2: 
            case 3: {
                boolean reduce;
                if (legendWidth > this.getAvailableWidth(true) && !(reduce = this.L2.setLegendReduceWidth(this.getAvailableWidth(true)))) {
                    return false;
                }
                legendHeightProjected = legendHeight;
                if (legendHeightProjected <= this.getAvailableHeight()) break;
                legendColumnsProjected = this.countLegendColsHeight(this.getAvailableHeight(), this.getAvailableWidth(true));
            }
        }
        PieDim maxSpace = new PieDim();
        int maxHorzSpace = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - legendWidth;
        int maxVertSpace = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - legendHeightProjected;
        if (this.StyleDesc.getStyleType() != 0) {
            maxSpace.width = maxHorzSpace;
            maxSpace.height = maxVertSpace;
            maxSpace = this.Adjust3D.setAdjustPieDiameter(maxSpace);
            maxHorzSpace = maxSpace.width;
            maxVertSpace = maxSpace.height;
        }
        int maxPieHeight = 0;
        int maxPieWidth = 0;
        if (alignment == -1 && maxVertSpace > maxHorzSpace || alignment == 4 || alignment == 7) {
            int xWhiteSpaceLegend;
            this.L2.setLegendColumns(legendColumnsProjected);
            double availableHeight = this.displayHeight - super.getBorderTop() - super.getBorderBottom();
            double legendSpace = availableHeight * this.L2.getLegendDesc().getLegendMaxHeightFraction();
            this.L2.setLegendMaxHeight((int)Math.round(legendSpace));
            this.L2.reduceLegendElements();
            legendHeight = this.L2.getLegendHeight();
            legendWidth = this.L2.getLegendWidth();
            maxHorzSpace = this.displayWidth - super.getBorderLeft() - super.getBorderRight();
            maxVertSpace = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - legendHeight;
            if (this.StyleDesc.getStyleType() != 0) {
                maxSpace.width = maxHorzSpace;
                maxSpace.height = maxVertSpace;
                maxSpace = this.Adjust3D.setAdjustPieDiameter(maxSpace);
                maxHorzSpace = maxSpace.width;
                maxVertSpace = maxSpace.height;
            }
            maxPieHeight = maxVertSpace;
            maxPieWidth = maxHorzSpace;
            if (this.PieSubType == 1) {
                maxPieHeight *= 2;
                maxPieWidth = (int)((double)maxPieWidth + (double)maxPieWidth * (1.0 - this.GaugeWidthFraction));
            }
            this.PieDiameter = Math.min(maxPieWidth, maxPieHeight);
            this.PieDiameterHeight = this.PieDiameter = this.evenPieDiameter(this.PieDiameter);
            this.PieDiameterWidth = this.PieDiameter;
            if (this.PieSubType == 1) {
                this.PieDiameterHeight = this.PieDiameter / 2;
                this.PieDiameterWidth = maxPieHeight > maxPieWidth ? this.PieDiameter : this.PieDiameter;
            }
            if ((xWhiteSpaceLegend = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - legendWidth) < 0) {
                xWhiteSpaceLegend = 0;
            }
            int xWhiteSpace = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.PieDiameterWidth;
            if (this.PieSubType != 1 && (xWhiteSpace -= this.Adjust3D.Offset3D_Left + this.Adjust3D.Offset3D_Right) < 0) {
                xWhiteSpace = 0;
            }
            int yWhiteSpace = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - this.PieDiameterHeight - legendHeight - this.LegendPieYSpacer - this.CircumLabelSouthExtraInt - this.CircumLabelNorthExtraInt;
            if ((yWhiteSpace -= this.Adjust3D.Offset3D_Bottom + this.Adjust3D.Offset3D_Top) < 0) {
                yWhiteSpace = 0;
            }
            alignment = this.L2.getLegendDesc().getLegendAlignment();
            int xOffsetLegend = 0;
            int yOffsetLegend = 0;
            switch (alignment) {
                case -1: 
                case 4: {
                    this.YOffset = super.getBorderTop() + yWhiteSpace / 2;
                    this.XOffset = super.getBorderLeft() + xWhiteSpace / 2;
                    this.YOffset += this.Adjust3D.Offset3D_Top;
                    this.XOffset += this.Adjust3D.Offset3D_Left;
                    yOffsetLegend = super.getBorderTop() + this.PieDiameterHeight + yWhiteSpace / 2 + this.LegendPieYSpacer;
                    xOffsetLegend = super.getBorderLeft() + xWhiteSpaceLegend / 2;
                    this.L2.setLegendLocation(xOffsetLegend, yOffsetLegend += this.Adjust3D.Offset3D_Bottom + this.Adjust3D.Offset3D_Top);
                    break;
                }
                case 7: {
                    this.YOffset = super.getBorderTop() + legendHeight + yWhiteSpace / 2 + this.LegendPieYSpacer - this.CircumLabelSouthExtraInt / 2 + this.CircumLabelNorthExtraInt;
                    this.XOffset = super.getBorderLeft() + xWhiteSpace / 2;
                    this.YOffset += this.Adjust3D.Offset3D_Top;
                    this.XOffset += this.Adjust3D.Offset3D_Left;
                    yOffsetLegend = super.getBorderTop();
                    xOffsetLegend = super.getBorderLeft() + xWhiteSpaceLegend / 2;
                    this.L2.setLegendLocation(xOffsetLegend, yOffsetLegend);
                }
            }
            this.CircumfVerticalSpace = maxVertSpace - this.PieDiameter - legendHeight;
            this.CircumfHorizontalSpace = maxHorzSpace - this.PieDiameter;
        } else {
            if (alignment == -1) {
                this.L2.setLegendColumns(1);
                legendHeight = this.L2.getLegendHeight();
                legendWidth = this.L2.getLegendWidth();
                legendHeightProjected = legendHeight;
                legendColumnsProjected = 1;
                if (legendWidth > this.getAvailableWidth(true)) {
                    return false;
                }
                if (legendHeightProjected > this.getAvailableHeight()) {
                    legendColumnsProjected = this.countLegendColsHeight(this.getAvailableHeight(), this.getAvailableWidth(true));
                }
            }
            this.L2.setLegendColumns(legendColumnsProjected);
            legendHeight = this.L2.getLegendHeight();
            legendWidth = this.L2.getLegendWidth();
            double availableHeight = this.getAvailableHeight();
            if (availableHeight < (double)legendHeight) {
                this.L2.setLegendMaxHeight((int)Math.round(availableHeight));
                this.L2.reduceLegendElements();
                legendHeight = this.L2.getLegendHeight();
            }
            maxVertSpace = this.displayHeight - super.getBorderTop() - super.getBorderBottom();
            maxHorzSpace = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - legendWidth;
            if (this.StyleDesc.getStyleType() != 0) {
                maxSpace.width = maxHorzSpace;
                maxSpace.height = maxVertSpace;
                maxSpace = this.Adjust3D.setAdjustPieDiameter(maxSpace);
                maxHorzSpace = maxSpace.width;
                maxVertSpace = maxSpace.height;
            }
            maxPieHeight = maxVertSpace;
            maxPieWidth = maxHorzSpace;
            this.PieDiameter = Math.min(maxPieWidth, maxPieHeight);
            this.PieDiameter = this.evenPieDiameter(this.PieDiameter);
            int availableXSpace = this.displayWidth - legendWidth - this.LegendPieYSpacer - super.getBorderLeft() - super.getBorderRight();
            if (availableXSpace < this.PieDiameter) {
                this.PieDiameter = availableXSpace;
            }
            int yWhiteSpace = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - this.PieDiameter;
            if ((yWhiteSpace -= this.Adjust3D.Offset3D_Bottom + this.Adjust3D.Offset3D_Top) < 0) {
                yWhiteSpace = 0;
            }
            legendHeight = this.L2.getLegendHeight();
            legendWidth = this.L2.getLegendWidth();
            int xAvailableSpace = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.PieDiameter - this.LegendPieYSpacer;
            int yWhiteSpaceLegend = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - legendHeight;
            if (yWhiteSpaceLegend < 0) {
                yWhiteSpaceLegend = 0;
            }
            int xWhiteSpace = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - this.PieDiameter - legendWidth - this.LegendPieXSpacer - this.CircumLabelEastExtraInt - this.CircumLabelWestExtraInt;
            if ((xWhiteSpace -= this.Adjust3D.Offset3D_Left + this.Adjust3D.Offset3D_Right) < 0) {
                xWhiteSpace = 0;
            }
            alignment = this.L2.getLegendDesc().getLegendAlignment();
            int xOffsetLegend = 0;
            int yOffsetLegend = 0;
            switch (alignment) {
                case -1: 
                case 3: {
                    this.XOffset = super.getBorderLeft() + xWhiteSpace / 3;
                    this.YOffset = super.getBorderTop() + yWhiteSpace / 2;
                    this.YOffset += this.Adjust3D.Offset3D_Top;
                    this.XOffset += this.Adjust3D.Offset3D_Left;
                    xOffsetLegend = super.getBorderLeft() + this.PieDiameter + 2 * xWhiteSpace / 3 + this.LegendPieXSpacer;
                    yOffsetLegend = super.getBorderTop() + yWhiteSpaceLegend / 2;
                    this.L2.setLegendLocation(xOffsetLegend += this.Adjust3D.Offset3D_Right + this.Adjust3D.Offset3D_Left, yOffsetLegend);
                    break;
                }
                case 2: {
                    this.XOffset = super.getBorderLeft() + legendWidth + 2 * xWhiteSpace / 3 + this.LegendPieXSpacer;
                    this.YOffset = super.getBorderTop() + yWhiteSpace / 2;
                    this.YOffset += this.Adjust3D.Offset3D_Top;
                    this.XOffset += this.Adjust3D.Offset3D_Left;
                    xOffsetLegend = super.getBorderLeft() + xWhiteSpace / 3;
                    yOffsetLegend = super.getBorderTop() + yWhiteSpaceLegend / 2;
                    this.L2.setLegendLocation(xOffsetLegend, yOffsetLegend);
                }
            }
            this.CircumfVerticalSpace = maxVertSpace - this.PieDiameter;
            this.CircumfHorizontalSpace = maxHorzSpace - this.PieDiameter;
        }
        this.PieRadius = (double)this.PieDiameter / 2.0;
        return true;
    }

    private void adjustLegendPlacement() {
        int alignment = this.L2.getLegendDesc().getLegendAlignment();
        int legendHeight = this.L2.getLegendHeight();
        int legendWidth = this.L2.getLegendWidth();
        int maxHorzSpace = this.displayWidth - super.getBorderLeft() - super.getBorderRight() - legendWidth;
        int maxVertSpace = this.displayHeight - super.getBorderTop() - super.getBorderBottom() - legendHeight;
        int legendX = this.L2.getLegendX();
        int legendY = this.L2.getLegendY();
        if (alignment == -1 && maxVertSpace > maxHorzSpace || alignment == 4 || alignment == 7) {
            alignment = this.L2.getLegendDesc().getLegendAlignment();
            switch (alignment) {
                case -1: 
                case 4: {
                    if (this.CircumLabelSouthExtraInt == 0) break;
                    this.L2.setLegendLocation(legendX, legendY += this.CircumLabelSouthExtraInt);
                    break;
                }
            }
        } else {
            switch (alignment) {
                case -1: 
                case 3: {
                    if (this.CircumLabelEastExtraInt == 0) break;
                    this.L2.setLegendLocation(legendX += this.CircumLabelEastExtraInt, legendY);
                    break;
                }
                case 2: {
                    if (this.CircumLabelWestExtraInt == 0) break;
                    this.L2.setLegendLocation(legendX -= this.CircumLabelWestExtraInt, legendY);
                }
            }
        }
        this.PieRadius = (double)this.PieDiameter / 2.0;
    }

    private void setPieDiameter(int diameter) {
        if (diameter <= 0) {
            return;
        }
        if (diameter > this.displayHeight) {
            return;
        }
        if (diameter > this.displayWidth) {
            return;
        }
        this.PieDiameter = diameter;
    }

    public void setAutoSliceColor(Color c12, Color c2) {
        this.colorStart = c12;
        this.colorEnd = c2;
        this.userDefinedPieColors = true;
        this.autoSliceColor();
    }

    public PieSliceDesc getPieSliceDesc(int index) throws ChartException {
        String fcn = "getPieSliceDesc()";
        if (this.SliceDesc == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-001"));
        }
        if (this.SliceDesc.length > index && index >= 0) {
            return this.SliceDesc[index];
        }
        Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-004"));
        return this.SliceDesc[0];
    }

    public void setDeriveLabelPct() throws ChartException {
        String fcn = "setDeriveLabelPct()";
        if (this.labelInteriorVal) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-006"));
        }
        this.deriveLabelPct = true;
        this.useNumberFormat = true;
        this.numFormat = NumberFormat.getPercentInstance();
        if (this.SliceDesc != null) {
            this.deriveNumericalLabelPct(false);
        }
    }

    public void setDeriveLabelPct(NumberFormat numFormat) throws ChartException {
        String fcn = "setDeriveLabelPct()";
        if (this.labelInteriorVal) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-006"));
        }
        this.useNumberFormat = true;
        this.numFormat = numFormat;
        this.deriveLabelPct = true;
        if (this.SliceDesc != null) {
            this.deriveNumericalLabelPct(false);
        }
    }

    public void setDeriveLabelPctOff() {
        this.deriveLabelPct = false;
        this.deriveNumericalLabelValOrPctOff();
    }

    public void setDeriveLabelPct(int nDigits) throws ChartException {
        String fcn = "setDeriveLabelPct()";
        if (this.labelInteriorVal) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-006"));
        }
        if (nDigits >= 0) {
            this.LabelPrecision = nDigits;
        }
        this.setDeriveLabelPct();
    }

    public void setLabelInteriorPct() throws ChartException {
        String fcn = "setLabelInteriorPct()";
        if (this.labelInteriorVal) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-006"));
        }
        this.labelInteriorPct = true;
        this.deriveLabelPct = true;
        if (!this.useNumberFormat) {
            this.useNumberFormat = true;
            this.numFormat = NumberFormat.getPercentInstance();
        }
        if (this.SliceDesc != null) {
            this.deriveNumericalLabelPct(false);
        }
    }

    public void setLabelInteriorPctOff() {
        this.labelInteriorPct = false;
        this.deriveLabelVal = false;
        this.deriveLabelPct = false;
        this.deriveNumericalLabelValOrPctOff();
    }

    public void setLabelInteriorVal() {
        this.labelInteriorVal = true;
        this.deriveLabelVal = true;
        if (!this.useNumberFormat) {
            this.useNumberFormat = true;
            this.numFormat = NumberFormat.getInstance(this.ChartLocale);
        }
        if (this.SliceDesc != null) {
            this.deriveNumericalLabelVal(this.savedSliceValues, false);
        }
    }

    public void setLabelInteriorValOff() {
        this.labelInteriorVal = false;
        this.deriveLabelVal = false;
        this.deriveLabelPct = false;
        this.deriveNumericalLabelValOrPctOff();
    }

    public void setDeriveLabelVal() throws ChartException {
        String fcn = "setDeriveLabelVal()";
        if (this.labelInteriorPct) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-005"));
        }
        this.deriveLabelVal = true;
        if (this.SliceDesc != null && this.savedSliceValues.length > 0) {
            this.deriveNumericalLabelVal(this.savedSliceValues, false);
        }
    }

    public void setDeriveLabelVal(NumberFormat numFormat) throws ChartException {
        String fcn = "setDeriveLabelVal()";
        if (this.labelInteriorPct) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-005"));
        }
        this.useNumberFormat = true;
        this.numFormat = numFormat;
        this.deriveLabelVal = true;
        if (this.SliceDesc != null && this.savedSliceValues.length > 0) {
            this.deriveNumericalLabelVal(this.savedSliceValues, false);
        }
    }

    public void setDeriveLabelValOff() {
        this.deriveLabelVal = false;
        this.deriveNumericalLabelValOrPctOff();
    }

    public void setDeriveLabelVal(int nDigits) throws ChartException {
        String fcn = "setDeriveLabelVal()";
        if (this.labelInteriorPct) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-005"));
        }
        if (nDigits >= 0) {
            this.LabelPrecision = nDigits;
        }
        this.setDeriveLabelVal();
    }

    private void autoSliceColor() {
        if (this.SliceDesc == null) {
            return;
        }
        if (this.SliceDesc.length != 0) {
            int numIntervals = this.SliceDesc.length - 1;
            int r1 = this.colorStart.getRed();
            int g1 = this.colorStart.getGreen();
            int b1 = this.colorStart.getBlue();
            this.SliceDesc[0].setBackground(new Color(r1, g1, b1));
            if (numIntervals > 0) {
                int r2 = this.colorEnd.getRed();
                int rdelta = (r2 - r1) / numIntervals;
                int g2 = this.colorEnd.getGreen();
                int gdelta = (g2 - g1) / numIntervals;
                int b2 = this.colorEnd.getBlue();
                int bdelta = (b2 - b1) / numIntervals;
                this.SliceDesc[this.SliceDesc.length - 1].setBackground(new Color(r2, g2, b2));
                for (int i = 1; i < this.SliceDesc.length - 1; ++i) {
                    int rtemp = r1 + i * rdelta;
                    int gtemp = g1 + i * gdelta;
                    int btemp = b1 + i * bdelta;
                    this.SliceDesc[i].setBackground(new Color(rtemp, gtemp, btemp));
                }
            }
        }
    }

    public void setChartAttributes(PieStyleDesc styleDesc) throws ChartException {
        this.StyleDesc = styleDesc;
        if (styleDesc.getStyleType() == 2) {
            this.E3D.setExtrusionAngle(styleDesc.getExtrusionAngle());
            this.E3D.setExtrusionThickness(styleDesc.getExtrusionThickness());
            this.E3D.setPerspectiveDistance(styleDesc.getPerspectiveDistance());
        } else if (styleDesc.getStyleType() == 1) {
            this.E3D.setExtrusionAngle(styleDesc.getExtrusionAngle());
            this.E3D.setExtrusionThickness(styleDesc.getExtrusionThickness());
            this.E3D.setPerspectiveDistance(styleDesc.getPerspectiveDistance());
        }
    }

    protected void setGaugeAttributes(GaugeStyleDesc styleDesc) throws ChartException {
        this.GaugeStyleDesc = styleDesc;
        this.initGaugeStyleParams();
    }

    public void setSeries(PieSliceDesc[] SliceDesc) throws ChartException {
        int i;
        String fcn = "setSeries()";
        int length = SliceDesc.length;
        this.SliceDesc = new PieSliceDesc[length];
        this.SliceAngle = new PieSliceAngle[length];
        this.SliceLabelLoc = new PieSliceLabelLoc[length];
        this.SliceSecondLabel = new String[length];
        this.SliceOriginalLabel = new String[length];
        this.SliceStoredLayout = new StoredLayout[length];
        this.IEGlobal = new boolean[length];
        this.interiorLabel = new boolean[length];
        for (i = 0; i < length; ++i) {
            if (SliceDesc[i] == null) {
                Errorfcn.chartError("setSeries()", MsgUtil.getMsg("CHT-000"));
            }
            this.interiorLabel[i] = false;
            this.SliceAngle[i] = new PieSliceAngle();
            this.SliceLabelLoc[i] = new PieSliceLabelLoc();
            this.SliceStoredLayout[i] = new StoredLayout();
            this.SliceSecondLabel[i] = "";
            String label = SliceDesc[i].getLabel();
            if (label != null) continue;
            SliceDesc[i].setLabel("");
        }
        double total = 0.0;
        for (i = 0; i < length; ++i) {
            double value = SliceDesc[i].getValue();
            if (value < 0.0) {
                log.info(MsgUtil.getMsg("CHT-002"));
            }
            total += value;
        }
        total = this.PieSubType == 1 ? (total /= this.GaugeSpanPrivate / 360.0 * 100.0) : (total /= 100.0);
        boolean test = false;
        this.savedSliceValues = new double[length];
        for (i = 0; i < length; ++i) {
            double value;
            this.savedSliceValues[i] = value = SliceDesc[i].getValue();
            this.SliceOriginalLabel[i] = SliceDesc[i].getLabel();
            this.SliceDesc[i] = new PieSliceDesc(SliceDesc[i].getLabel(), value / total);
            this.SliceDesc[i].setBackground(SliceDesc[i].getBackground());
            this.SliceDesc[i].setLabelColor(SliceDesc[i].getLabelColor());
        }
        if (total == 0.0) {
            this.rewriteZeroPct(this.savedSliceValues);
        }
        if (this.deriveLabelVal) {
            this.deriveNumericalLabelVal(this.savedSliceValues, false);
        } else if (this.deriveLabelPct) {
            this.deriveNumericalLabelPct(false);
        }
        if (this.genImageMapCoords) {
            this.ImageMapCoords = new int[SliceDesc.length][0];
        }
        if (this.userDefinedPieColors) {
            this.autoSliceColor();
        }
    }

    public void setSeriesDirection(boolean clockwise) {
        this.clockwise = clockwise;
    }

    public boolean getSeriesDirection() {
        return this.clockwise;
    }

    private void recomputeSliceValues() {
        int i;
        double total = 0.0;
        int length = this.savedSliceValues.length;
        for (i = 0; i < length; ++i) {
            total += this.savedSliceValues[i];
        }
        total = this.PieSubType == 1 ? (total /= this.GaugeSpanPrivate / 360.0 * 100.0) : (total /= 100.0);
        for (i = 0; i < length; ++i) {
            this.SliceDesc[i].setValue(this.savedSliceValues[i] / total);
        }
    }

    void rewriteZeroPct(double[] ssv) {
        double value;
        int i;
        int length = ssv.length;
        boolean allzeros = true;
        for (i = 0; i < length; ++i) {
            value = ssv[i];
            if (value == 0.0) continue;
            allzeros = false;
            break;
        }
        if (allzeros) {
            for (i = 0; i < length; ++i) {
                value = ssv[i];
                this.SliceDesc[i] = new PieSliceDesc(this.SliceDesc[i].getLabel(), 100.0 / (double)length);
                value = this.SliceDesc[i].getValue();
            }
        }
    }

    private void deriveNumericalLabelPct(boolean forceExterior) {
        int length = this.SliceDesc.length;
        if (this.deriveLabelPct && this.useNumberFormat) {
            for (int i = 0; i < length; ++i) {
                double slicePercent = this.SliceDesc[i].getValue() / 100.0;
                String stringPercent = this.numFormat.format(slicePercent);
                if (this.labelInteriorPct && !forceExterior) {
                    this.SliceSecondLabel[i] = stringPercent;
                    this.SliceDesc[i].setLabel(this.SliceOriginalLabel[i]);
                    continue;
                }
                String newLabel = this.SliceOriginalLabel[i];
                newLabel = newLabel != null && newLabel.length() > 0 ? newLabel.trim() + " " + stringPercent : stringPercent;
                this.SliceDesc[i].setLabel(newLabel);
            }
        }
    }

    private void deriveNumericalLabelVal(double[] d, boolean forceExterior) {
        block7: {
            int length = d.length;
            if (!this.deriveLabelVal) break block7;
            if (this.useNumberFormat) {
                for (int i = 0; i < length; ++i) {
                    String stringValue = this.numFormat.format(d[i]);
                    if (this.labelInteriorVal && !forceExterior) {
                        this.SliceSecondLabel[i] = stringValue;
                        this.SliceDesc[i].setLabel(this.SliceOriginalLabel[i]);
                        continue;
                    }
                    String newLabel = this.SliceOriginalLabel[i];
                    newLabel = newLabel != null && newLabel.length() > 0 ? newLabel.trim() + " " + stringValue : stringValue;
                    this.SliceDesc[i].setLabel(newLabel);
                }
            } else {
                boolean integerLabels = !this.isFractional(d);
                int dig = 0;
                if (!integerLabels) {
                    dig = Precision.computeSignif(d);
                }
                for (int i = 0; i < length; ++i) {
                    String stringValue = this.LabelPrecision != -1 ? (this.LabelPrecision == 0 ? String.valueOf((int)d[i]) : Precision.roundNSig(d[i], this.LabelPrecision - 1)) : (integerLabels ? String.valueOf((int)d[i]) : Precision.roundNSig(d[i], dig));
                    if (this.labelInteriorVal && !forceExterior) {
                        this.SliceSecondLabel[i] = stringValue;
                        continue;
                    }
                    String newLabel = this.SliceOriginalLabel[i];
                    newLabel = newLabel != null && newLabel.length() > 0 ? newLabel.trim() + " " + stringValue : stringValue;
                    this.SliceDesc[i].setLabel(newLabel);
                }
            }
        }
    }

    private void deriveNumericalLabelValOrPctOff() {
        if (this.SliceOriginalLabel != null) {
            int length = this.SliceOriginalLabel.length;
            for (int i = 0; i < length; ++i) {
                this.SliceDesc[i].setLabel(this.SliceOriginalLabel[i]);
            }
        }
    }

    private boolean isFractionalSlicePct() {
        if (this.SliceDesc != null) {
            int length = this.SliceDesc.length;
            for (int i = 0; i < length; ++i) {
                int iSlice;
                double dSlice;
                double slicePercent = this.SliceDesc[i].getValue();
                double diff = slicePercent - (dSlice = (double)(iSlice = (int)Math.round(slicePercent)));
                if (diff == 0.0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFractional(double[] d) {
        for (double dvalue : d) {
            int ivalue = (int)dvalue;
            double dround = ivalue;
            double diff = dvalue - dround;
            if (diff == 0.0) continue;
            return true;
        }
        return false;
    }

    private int getQuadNumber(double angle) {
        double a = this.getNormalizedAngle(angle);
        if (a > 0.0 && a <= 90.0) {
            return 1;
        }
        if (a > 90.0 && a <= 180.0) {
            return 2;
        }
        if (a > 180.0 && a <= 270.0) {
            return 3;
        }
        if (a > 270.0 && a <= 360.0) {
            return 4;
        }
        return 1;
    }

    private boolean inQuad1(double angle) {
        return angle >= 0.0 && angle <= 90.0;
    }

    private boolean inQuad2(double angle) {
        return angle >= 90.0 && angle < 180.0;
    }

    private boolean inQuad3(double angle) {
        return angle >= 180.0 && angle < 270.0;
    }

    private boolean inQuad4(double angle) {
        return angle >= 270.0 && angle <= 360.0;
    }

    private boolean openTopHemisphere(double start, double end) {
        int delta;
        int leftB = delta = 10;
        int rightB = 180 - delta;
        if (end < (double)delta) {
            end += 360.0;
        }
        return start <= (double)leftB || start >= (double)rightB && start <= 360.0 && end >= (double)rightB && end <= (double)(360 + delta) && start > end;
    }

    private boolean openBottomHemisphere(double start, double end) {
        double trans_start = start + 180.0;
        double trans_end = end + 180.0;
        return this.openTopHemisphere(trans_start, trans_end);
    }

    private double getNormalizedAngle(double angle) {
        if (angle < 360.0 && angle >= 0.0) {
            return angle;
        }
        if (Math.abs(angle) < 0.001) {
            return 0.0;
        }
        while (angle >= 360.0) {
            angle -= 360.0;
        }
        while (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    private void initCircumference() {
        this.xMinTextNormalized = -1.0;
        this.yMinTextNormalized = -1.0;
        this.xMaxTextNormalized = 1.0;
        this.yMaxTextNormalized = 1.0;
        this.xMinNormalized = -1.0;
        this.yMinNormalized = -1.0;
        this.xMaxNormalized = 1.0;
        this.yMaxNormalized = 1.0;
        this.CircumLabelHeightOffset = 0.0;
        this.CircumLabelWidthOffset = 0.0;
        this.CircumLabelNorthExtra = 0.0;
        this.CircumLabelSouthExtra = 0.0;
        this.CircumLabelEastExtra = 0.0;
        this.CircumLabelWestExtra = 0.0;
    }

    private void initCircumference2() {
        this.CircumLabelEastExtraInt = 0;
        this.CircumLabelWestExtraInt = 0;
        this.CircumLabelHeightOffsetInt = 0;
        this.CircumLabelWidthOffsetInt = 0;
        this.CircumLabelNorthExtraInt = 0;
        this.CircumLabelSouthExtraInt = 0;
    }

    private void printXYNormal() {
        System.out.println("   printXYNormal " + this.xMinTextNormalized + " " + this.yMinTextNormalized + " " + this.xMaxTextNormalized + " " + this.yMaxTextNormalized);
    }

    private void printXYNormal2() {
        System.out.println("printXYNormal " + this.xMinNormalized + " " + this.yMinNormalized + " " + this.xMaxNormalized + " " + this.yMaxNormalized);
    }

    private void convertCircumLabelOffset() {
        this.CircumLabelHeightOffsetInt = (int)Math.round(this.CircumLabelHeightOffset * this.PieRadius);
        this.CircumLabelWidthOffsetInt = (int)Math.round(this.CircumLabelWidthOffset * this.PieRadius);
        this.CircumLabelNorthExtraInt = (int)Math.round(this.CircumLabelNorthExtra * this.PieRadius);
        this.CircumLabelSouthExtraInt = (int)Math.round(this.CircumLabelSouthExtra * this.PieRadius);
        this.CircumLabelEastExtraInt = (int)Math.round(this.CircumLabelEastExtra * this.PieRadius);
        this.CircumLabelWestExtraInt = (int)Math.round(this.CircumLabelWestExtra * this.PieRadius);
    }

    private void convertCircumEastWest() {
        this.CircumLabelEastExtraInt = (int)Math.round(this.CircumLabelEastExtra * this.PieRadius);
        this.CircumLabelWestExtraInt = (int)Math.round(this.CircumLabelWestExtra * this.PieRadius);
    }

    private void convertCircumNorthSouth() {
        this.CircumLabelNorthExtraInt = (int)Math.round(this.CircumLabelNorthExtra * this.PieRadius);
        this.CircumLabelSouthExtraInt = (int)Math.round(this.CircumLabelSouthExtra * this.PieRadius);
    }

    private double allocateCircumNorthSouth() {
        double t1 = 1.0;
        if (this.yMinNormalized == -1.0) {
            double halfTextHeight;
            this.CircumLabelHeightOffset = halfTextHeight = (this.yMaxNormalized - 1.0) / 2.0;
            t1 = 1.0 + halfTextHeight;
        } else if (this.yMaxNormalized == 1.0) {
            double halfTextHeight;
            this.CircumLabelHeightOffset = halfTextHeight = (this.yMinNormalized + 1.0) / 2.0;
            t1 = 1.0 + Math.abs(halfTextHeight);
        } else {
            t1 = Math.max(Math.abs(this.yMinNormalized), Math.abs(this.yMaxNormalized));
        }
        return t1;
    }

    private double allocateCircumEastWest() {
        double t2 = 1.0;
        if (this.xMinNormalized == -1.0) {
            double halfTextWidth = (this.xMaxNormalized - 1.0) / 2.0;
            this.CircumLabelWidthOffset = -halfTextWidth;
            t2 = 1.0 + halfTextWidth;
        } else if (this.xMaxNormalized == 1.0) {
            double halfTextWidth = (this.xMinNormalized + 1.0) / 2.0;
            this.CircumLabelWidthOffset = Math.abs(halfTextWidth);
            t2 = 1.0 + Math.abs(halfTextWidth);
        } else {
            t2 = Math.max(Math.abs(this.xMinNormalized), Math.abs(this.xMaxNormalized));
        }
        return t2;
    }

    private void adjustCircumEastWest() {
        if (this.xMaxNormalized > Math.abs(this.xMinNormalized)) {
            double textWidth;
            this.CircumLabelEastExtra = textWidth = this.xMaxNormalized - 1.0;
        } else {
            double textWidth = this.xMinNormalized + 1.0;
            this.CircumLabelWestExtra = Math.abs(textWidth);
        }
    }

    private void adjustCircumNorthSouth() {
        double halfTextHeight;
        this.CircumLabelNorthExtra = halfTextHeight = (this.yMaxNormalized - 1.0) / 2.0;
        halfTextHeight = (this.yMinNormalized + 1.0) / 2.0;
        this.CircumLabelSouthExtra = Math.abs(halfTextHeight);
    }

    private double getMaxXYNormalized() {
        if (this.CircumfHorizontalSpace > 0) {
            double t1 = this.allocateCircumNorthSouth();
            this.adjustCircumEastWest();
            this.convertCircumEastWest();
            if (this.CircumLabelEastExtraInt + this.CircumLabelWestExtraInt < this.CircumfHorizontalSpace) {
                return t1;
            }
            double t2 = this.allocateCircumEastWest();
            this.CircumLabelEastExtra = 0.0;
            this.CircumLabelWestExtra = 0.0;
            return Math.max(t1, t2);
        }
        if (this.CircumfVerticalSpace > 0) {
            double t2 = this.allocateCircumEastWest();
            this.adjustCircumNorthSouth();
            this.convertCircumNorthSouth();
            if (this.CircumLabelNorthExtraInt + this.CircumLabelSouthExtraInt < this.CircumfVerticalSpace) {
                return t2;
            }
            double t1 = this.allocateCircumNorthSouth();
            this.CircumLabelNorthExtra = 0.0;
            this.CircumLabelSouthExtra = 0.0;
            return Math.max(t1, t2);
        }
        double t1 = Math.max(Math.abs(this.yMinNormalized), Math.abs(this.yMaxNormalized));
        double t2 = Math.max(Math.abs(this.xMinNormalized), Math.abs(this.xMaxNormalized));
        this.CircumLabelHeightOffset = 0.0;
        this.CircumLabelWidthOffset = 0.0;
        return Math.max(t1, t2);
    }

    private void test500() {
        PieLayout pl = new PieLayout();
        double x = 0.8;
        double angle = 10.0;
        pl.getBottomEdge2(x, Math.toRadians(10.0));
        pl.getBottomEdge2(x, Math.toRadians(45.0));
        pl.getBottomEdge2(x, Math.toRadians(80.0));
    }

    void drawLabelInSlice(Graphics2D g2, PieLayout pl, boolean isMulti, String label, Vector SliceLabelLines, int sliceIndex) {
        if (label == null || label == "") {
            return;
        }
        boolean testInSlice = false;
        if (testInSlice) {
            System.out.println("");
            System.out.println("######## drawLabelInSlice ######### " + sliceIndex);
            System.out.println("PieRadius" + this.PieRadius);
            System.out.println("PieDiameter" + this.PieDiameter);
        }
        if (testInSlice) {
            System.out.println("drawLabelInSlice: XTr(), YTr(): (" + pl.getXTr() + "," + pl.getYTr() + ")");
        }
        if (testInSlice) {
            System.out.println("drawLabelInSlice: XTr(), YTr() * PieRadius: (" + pl.getXTr() * this.PieRadius + "," + pl.getYTr() * this.PieRadius + ")");
        }
        int x = (int)Math.round(pl.getXTr() * this.PieRadius) + this.XOffset + this.CircumLabelWidthOffsetInt;
        int y = (int)Math.round(pl.getYTr() * this.PieRadius) + this.YOffset + this.CircumLabelHeightOffsetInt;
        if (testInSlice) {
            System.out.println("drawLabelInSlice: x,y: (" + x + "," + y + ")");
        }
        int w = (int)Math.round(pl.getWidth() * this.PieRadius);
        int h = (int)Math.round(pl.getHeight() * this.PieRadius);
        if (testInSlice) {
            System.out.println("drawLabelInSlice: w,h: (" + w + "," + h + ")");
        }
        int base = this.fontmet.getMaxAscent();
        testInSlice = false;
        int labelWidth = this.getFontMetrics(this.font).stringWidth(label);
        if (this.testRect) {
            Rectangle2D.Float rect = new Rectangle2D.Float();
            ((Rectangle2D)rect).setRect(x, y, w, h);
            g2.draw(rect);
        }
        int x_center = x + (w - labelWidth) / 2;
        if (!isMulti) {
            if (this.drawText) {
                if (this.HilightLabelIndex == sliceIndex) {
                    g2.setColor(this.HilightLabelColor);
                    if (this.DrawLegend) {
                        this.L2.setLegendLabelColor(this.SliceDesc[sliceIndex].getLabel(), this.HilightLabelColor);
                    }
                } else if (!this.AutoColorAdjustSliceLabel) {
                    g2.setColor(this.SliceDesc[sliceIndex].getLabelColor());
                } else {
                    float[] sliceHSBvals = new float[3];
                    Color.RGBtoHSB(this.SliceDesc[sliceIndex].getBackground().getRed(), this.SliceDesc[sliceIndex].getBackground().getGreen(), this.SliceDesc[sliceIndex].getBackground().getBlue(), sliceHSBvals);
                    if (sliceHSBvals[2] < 0.6f) {
                        float[] labelHSBvals = new float[3];
                        Color.RGBtoHSB(this.SliceDesc[sliceIndex].getLabelColor().getRed(), this.SliceDesc[sliceIndex].getLabelColor().getGreen(), this.SliceDesc[sliceIndex].getLabelColor().getBlue(), labelHSBvals);
                        if (labelHSBvals[2] < 0.6f) {
                            g2.setColor(Color.getHSBColor(labelHSBvals[0], labelHSBvals[2], 0.8f));
                        } else {
                            g2.setColor(this.SliceDesc[sliceIndex].getLabelColor());
                        }
                    } else {
                        g2.setColor(this.SliceDesc[sliceIndex].getLabelColor());
                    }
                }
                g2.setFont(this.font);
                this.SliceLabelLoc[sliceIndex].drawStringSetLocSize(g2, label, x_center, y + base, labelWidth, base);
            }
        } else {
            int fontHeight = this.fontmet.getMaxAscent() + this.fontmet.getLeading();
            int y_start = y;
            int currentLabelWidth = 0;
            for (int j = 0; j < SliceLabelLines.size(); ++j) {
                String s = (String)SliceLabelLines.elementAt(j);
                if (this.test) {
                    System.out.println("*** label *** " + j + " " + s);
                }
                currentLabelWidth = this.fontmet.stringWidth(s);
                x_center = x + (w - currentLabelWidth) / 2;
                if (this.drawText) {
                    g2.setFont(this.font);
                    if (this.HilightLabelIndex == sliceIndex) {
                        g2.setColor(this.HilightLabelColor);
                        if (this.DrawLegend) {
                            this.L2.setLegendLabelColor(this.SliceDesc[sliceIndex].getLabel(), this.HilightLabelColor);
                        }
                    } else {
                        g2.setColor(this.SliceDesc[sliceIndex].getLabelColor());
                    }
                    if (j == 0) {
                        this.SliceLabelLoc[sliceIndex].drawStringSetLocSize(g2, s, x_center, y_start + base, labelWidth, base);
                    } else {
                        this.SliceLabelLoc[sliceIndex].drawString(g2, s, x_center, y_start + base);
                    }
                }
                y_start += fontHeight;
            }
            this.SliceLabelLoc[sliceIndex].setSize(labelWidth, y_start - y);
        }
        if (this.test) {
            System.out.println("xywh (" + x + "," + y + "," + w + "," + h + ")");
        }
        if (this.test) {
            System.out.println("");
        }
    }

    void hilightLegendText(Graphics2D g2) {
        if (!this.DrawLegend) {
            return;
        }
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            if (this.HilightLabelIndex != i) continue;
            this.L2.setLegendLabelColor(this.SliceDesc[i].getLabel(), this.HilightLabelColor);
        }
    }

    void initMinMax() {
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
    }

    public void redrawBuffer(Graphics2D g2) throws ChartException {
        if (this.isZeroMask(this.IEGlobal)) {
            this.layoutL(g2);
        } else {
            this.doLayout(g2);
        }
        if (this.DrawLegend) {
            this.L2.drawLegendBuffer(g2, this.genImageMapCoords);
        }
    }

    private boolean isZeroMask(boolean[] mask) {
        for (int i = 0; i < mask.length; ++i) {
            if (!mask[i]) continue;
            return false;
        }
        return true;
    }

    public BasicStroke getPieStroke() {
        return this.PieStroke;
    }

    public void setPieStroke(BasicStroke stroke) {
        this.PieStroke = stroke;
    }

    public BasicStroke getConnectorStroke() {
        return this.ConnectorStroke;
    }

    public void setConnectorStroke(BasicStroke stroke) {
        this.ConnectorStroke = stroke;
    }

    @Override
    public Color getForeground() {
        return this.Foreground;
    }

    @Override
    public void setForeground(Color c) {
        this.Foreground = c;
        super.setTitlesForeground(c);
        if (this.SliceDesc != null) {
            for (int i = 0; i < this.SliceDesc.length; ++i) {
                this.SliceDesc[i].setLabelColor(c);
            }
        }
    }

    private Color getConnectorColor() {
        return this.ConnectorColor;
    }

    private void setConnectorColor(Color color) {
        this.ConnectorColor = color;
    }

    public void drawBuffer(Graphics2D g2) throws ChartException {
        int i;
        String fcn = "drawBuffer()";
        this.DrawBufferCalled = true;
        if (this.PieSubType == 1) {
            this.initGaugeStyleParams();
        }
        if (this.testdrawBuffer) {
            System.out.println();
            System.out.println("drawBuffer " + super.getWidth() + " " + super.getWidth());
            System.out.println("---------- ");
        }
        if (this.testAutoDiameter) {
            System.out.println();
            System.out.println();
            System.out.println("drawBuffer ");
            System.out.println("---------------------------------------------- ");
            System.out.println("---------------------------------------------- ");
        }
        if (this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(super.getRenderingHintsChart());
        }
        if (this.SliceDesc == null) {
            Errorfcn.chartError("drawBuffer()", MsgUtil.getMsg("CHT-000"));
        }
        if (this.SliceDesc.length <= 0) {
            return;
        }
        LayoutScore LScore = new LayoutScore();
        double totalPercent = 0.0;
        for (int i2 = 0; i2 < this.SliceDesc.length; ++i2) {
            totalPercent += this.SliceDesc[i2].getValue();
        }
        if (totalPercent > 100.5) {
            Errorfcn.chartError("drawBuffer()", MsgUtil.getMsg("CHT-003"));
        }
        super.getTitle().setFontMetrics(g2);
        super.getSubtitle().setFontMetrics(g2);
        super.getFootnote().setFontMetrics(g2);
        int tempBordertop = 0;
        if (super.getTitle().getText() != "") {
            tempBordertop += super.getTitle().getHeight();
            super.getTitle().setLocation(0, 0);
            super.getTitle().setWidth(this.displayWidth);
        }
        if (super.getSubtitle().getText() != "") {
            tempBordertop += super.getSubtitle().getHeight();
            if (super.getTitle().getText() != "") {
                super.getSubtitle().setLocation(0, super.getTitle().getHeight());
            } else {
                super.getSubtitle().setLocation(0, 0);
            }
            super.getSubtitle().setWidth(this.displayWidth);
        }
        if (super.getTitle().getText() != "" && super.getSubtitle().getText() == "") {
            int whiteSp = super.getTitle().getHeight() / 6;
            tempBordertop += whiteSp;
        }
        if (tempBordertop != 0) {
            this.setBorderTopInternal(tempBordertop);
        }
        if (super.getFootnote().getText() != "") {
            int footnoteHeight = super.getFootnote().getHeight();
            int footnoteYOffset = (int)Math.round(1.5 * (double)footnoteHeight);
            super.getFootnote().setLocation(0, this.displayHeight - footnoteYOffset);
            super.getFootnote().setWidth(this.displayWidth);
            int padding = 10;
            super.setBorderBottomInternal(footnoteHeight + padding);
        }
        g2.setFont(this.font);
        this.getFMetrics(g2);
        g2.setStroke(this.getPieStroke());
        if (this.testAutoDiameter) {
            System.out.println("Display " + this.displayWidth + " " + this.displayHeight);
        }
        boolean[] IELocal = new boolean[this.SliceDesc.length];
        this.ScoreD.init();
        this.DrawLegend = false;
        boolean allFit = false;
        if (this.labelInteriorPct || this.labelInteriorVal) {
            for (i = 0; i < this.SliceDesc.length; ++i) {
                this.IEGlobal[i] = true;
            }
            if (this.forceLegendApproach) {
                this.addLegend();
                this.deriveNumericalLabelVal(this.savedSliceValues, true);
                this.deriveNumericalLabelPct(true);
                if (this.DrawLegend) {
                    this.L2.drawLegendBuffer(g2, this.genImageMapCoords);
                }
                this.layoutL(g2);
            } else {
                this.addLegend();
                allFit = this.layoutCircumferenceAllFit(g2);
                if (allFit) {
                    this.deriveNumericalLabelVal(this.savedSliceValues, false);
                    this.deriveNumericalLabelPct(false);
                }
                if (!allFit) {
                    if (!this.simpleApproach) {
                        this.layoutCircumference(g2);
                    }
                    if (this.simpleApproach) {
                        this.deriveNumericalLabelVal(this.savedSliceValues, true);
                        this.deriveNumericalLabelPct(true);
                    }
                }
                this.adjustLegendPlacement();
                if (this.DrawLegend) {
                    this.L2.drawLegendBuffer(g2, this.genImageMapCoords);
                }
            }
        }
        if (this.simpleApproach && !this.labelInteriorPct && !this.labelInteriorVal || this.simpleApproach && (this.labelInteriorPct || this.labelInteriorVal) && !allFit) {
            this.setPieDiameter2();
            IELocal = this.layout(g2, 0, false, IELocal);
            if (this.testAutoDiameter) {
                this.ScoreD.dumpScoreDesc(IELocal);
            }
            this.setPieDiameter2();
            if (LScore.isAllOnesMask(IELocal)) {
                this.layout(g2, 1, true, IELocal);
            } else {
                if (this.testAutoDiameter) {
                    System.out.println();
                    System.out.println("&&&&&&&&&& Duplicate or Zero &&&&&&&&&&");
                    System.out.println();
                }
                this.ScoreD.init();
                for (i = 0; i < this.SliceDesc.length; ++i) {
                    this.IEGlobal[i] = false;
                }
                this.layoutL(g2);
            }
        } else if (!this.labelInteriorPct && !this.labelInteriorVal) {
            for (int j = 0; j < 8; ++j) {
                if (this.testAutoDiameter) {
                    System.out.println();
                    System.out.println("j " + j);
                    System.out.println("================================================");
                }
                if (this.testAutoDiameter) {
                    System.out.println("YOffset " + this.YOffset);
                }
                this.setPieDiameter2();
                this.ScoreD.initSpaceNeeded();
                IELocal = this.layout(g2, 0, false, IELocal);
                if (this.testAutoDiameter) {
                    System.out.print("First Score Descriptor - ");
                    this.ScoreD.dumpScoreDesc(IELocal);
                }
                if (this.PieDiameter > 0) {
                    if (this.testAutoDiameter) {
                        System.out.print("Second Score Descriptor - ");
                        this.ScoreD.dumpScoreDesc(IELocal);
                    }
                    if (this.testAutoDiameter) {
                        System.out.println("ScoreD[" + j + "] =  ( " + this.ScoreD.space_top_needed + " " + this.ScoreD.space_bottom_needed + " " + this.ScoreD.space_left_needed + " " + this.ScoreD.space_right_needed + ")");
                        System.out.println("YOffset " + this.YOffset + " PD " + this.PieDiameter);
                        System.out.println("min/max Y " + this.minY + " " + this.maxY);
                    }
                    if (this.ScoreD.enoughYSpace() && this.ScoreD.enoughXSpace() && !LScore.isZeroMask(IELocal)) {
                        if (this.testAutoDiameter) {
                            System.out.println();
                            System.out.println("&&&&&&&&&& enoughYSpace &&&&&&&&&&");
                            System.out.println();
                        }
                        if (this.testAutoDiameter) {
                            System.out.print("Score Descriptor - ");
                            this.ScoreD.dumpScoreDesc(IELocal);
                        }
                        this.setPieCenter();
                        this.layout(g2, 1, true, IELocal);
                        this.computeArc();
                        this.IEGlobal = IELocal;
                        break;
                    }
                }
                if (LScore.isDuplicateMask(IELocal) || LScore.isZeroMask(IELocal) || this.PieDiameter < 0) {
                    if (this.testAutoDiameter) {
                        System.out.println();
                        System.out.println("&&&&&&&&&& Duplicate or Zero &&&&&&&&&&");
                        System.out.println();
                    }
                    this.ScoreD.init();
                    for (int i3 = 0; i3 < this.SliceDesc.length; ++i3) {
                        this.IEGlobal[i3] = false;
                    }
                    this.layoutL(g2);
                    break;
                }
                ScoreDesc s = new ScoreDesc();
                s.setBottomSpaceAvailable(this.ScoreD.space_bottom_available);
                s.setBottomSpaceNeeded(this.ScoreD.space_bottom_needed);
                s.setTopSpaceAvailable(this.ScoreD.space_top_available);
                s.setTopSpaceNeeded(this.ScoreD.space_top_needed);
                s.setMask(IELocal);
                LScore.LabelIntExt.addElement(s);
                if (!this.testAutoDiameter) continue;
                s.dumpScoreDesc();
            }
        }
        if (this.testAutoDiameter) {
            LScore.dumpScore();
        }
        if (this.DrawLegend && this.forceLegendApproach || this.DrawLegend && !this.labelInteriorPct && !this.labelInteriorVal || this.simpleApproach && (this.labelInteriorPct || this.labelInteriorVal) && !allFit) {
            this.L2.drawLegendBuffer(g2, this.genImageMapCoords);
        }
    }

    private double percentToAngle(double percent) {
        return percent * 3.6;
    }

    private void setSliceRenderingHints(Graphics2D g2) {
        if (this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(super.getRenderingHintsChart());
        } else {
            this.RHOriginal = g2.getRenderingHints();
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g2.setRenderingHints(hints);
        }
    }

    private Shape getPolyShape(float cx1, float cy1, float cx2, float cy2) {
        GeneralPath poly = new GeneralPath();
        Point2D.Double vPoint = this.E3D.getVanishPoint();
        float directX1 = -((float)((double)cx1 - vPoint.x));
        float directY1 = -((float)((double)cy1 - vPoint.y));
        float directX2 = -((float)((double)cx2 - vPoint.x));
        float directY2 = -((float)((double)cy2 - vPoint.y));
        poly.moveTo((float)vPoint.x, (float)vPoint.y);
        poly.lineTo(cx1 - directX1, cy1 - directY1);
        poly.lineTo(cx2 - directX2, cy2 - directY2);
        poly.lineTo((float)vPoint.x, (float)vPoint.y);
        return poly;
    }

    private Shape getCircleConeShape(Effect3D effect) {
        GeneralPath poly = new GeneralPath();
        poly.moveTo((float)effect.startCircumXShadow, (float)effect.startCircumYShadow);
        poly.lineTo((float)effect.endCircumXShadow, (float)effect.endCircumYShadow);
        poly.lineTo((float)effect.endCircumX, (float)effect.endCircumY);
        poly.lineTo((float)effect.startCircumX, (float)effect.startCircumY);
        poly.lineTo((float)effect.startCircumXShadow, (float)effect.startCircumYShadow);
        return poly;
    }

    private Shape getTriangleShape(float cx1, float cy1, float cx2, float cy2, float cx3, float cy3) {
        GeneralPath poly = new GeneralPath();
        poly.moveTo(cx1, cy1);
        poly.lineTo(cx2, cy2);
        poly.lineTo(cx3, cy3);
        poly.lineTo(cx1, cy1);
        return poly;
    }

    private Shape getNeedleArrow(float cx1, float cy1, float cx2, float cy2) {
        GeneralPath poly = new GeneralPath();
        poly.moveTo(cx1, cy1);
        poly.lineTo(cx2, cy2);
        poly.lineTo(cx2 + 2.0f, cy2);
        poly.lineTo(cx1 + 2.0f, cy1);
        poly.lineTo(cx1, cy1);
        return poly;
    }

    private Shape getNeedleArrow2(float cx1, float cy1, float cx2, float cy2) {
        GeneralPath poly = new GeneralPath();
        float arrowHeadPosition = 0.9f;
        float arrowStemWidthBase = (float)(this.PieRadius * 0.01);
        float arrowStemWidth = (float)(this.PieRadius * 0.02);
        float arrowHeadWidth = (float)(this.PieRadius * 0.05);
        double gauageNeedleNormalRadians = Math.toRadians(this.GaugeLevelDegreesPrivate + 90.0);
        float xOffsetStemBase = (float)Math.cos(gauageNeedleNormalRadians) * arrowStemWidthBase;
        float yOffsetStemBase = (float)(-Math.sin(gauageNeedleNormalRadians)) * arrowStemWidthBase;
        poly.moveTo(cx1 + xOffsetStemBase, cy1 + yOffsetStemBase);
        float xOffsetStem = (float)Math.cos(gauageNeedleNormalRadians) * arrowStemWidth;
        float yOffsetStem = (float)(-Math.sin(gauageNeedleNormalRadians)) * arrowStemWidth;
        float xOffsetHead = (float)Math.cos(gauageNeedleNormalRadians) * arrowHeadWidth;
        float yOffsetHead = (float)(-Math.sin(gauageNeedleNormalRadians)) * arrowHeadWidth;
        float xArrowBase = arrowHeadPosition * (cx2 - cx1);
        float yArrowBase = arrowHeadPosition * (cy2 - cy1);
        poly.lineTo(cx1 + xArrowBase + xOffsetStem, cy1 + yArrowBase + yOffsetStem);
        poly.lineTo(cx1 + xArrowBase + xOffsetHead, cy1 + yArrowBase + yOffsetHead);
        poly.lineTo(cx2, cy2);
        poly.lineTo(cx1 + xArrowBase - xOffsetHead, cy1 + yArrowBase - yOffsetHead);
        poly.lineTo(cx1 + xArrowBase - xOffsetStem, cy1 + yArrowBase - yOffsetStem);
        poly.lineTo(cx1 - xOffsetStemBase, cy1 - yOffsetStemBase);
        poly.lineTo(cx1 + xOffsetStemBase, cy1 + yOffsetStemBase);
        return poly;
    }

    private Shape getNeedlePointer(int highLight, float cx1, float cy1, float cx2, float cy2) {
        GeneralPath poly = new GeneralPath();
        float pointerMidPosition1 = 0.15f;
        float pointerMidPosition2 = 0.9f;
        float pointerMidWidth1 = (float)(this.PieRadius * 0.06);
        float pointerMidWidth2 = (float)(this.PieRadius * 0.037);
        float xMid1 = pointerMidPosition1 * (cx2 - cx1);
        float yMid1 = pointerMidPosition1 * (cy2 - cy1);
        float xMid2 = pointerMidPosition2 * (cx2 - cx1);
        float yMid2 = pointerMidPosition2 * (cy2 - cy1);
        double gauageNeedleNormalRadians = Math.toRadians(this.GaugeLevelDegreesPrivate + 90.0);
        float xOffsetMid1 = (float)Math.cos(gauageNeedleNormalRadians) * pointerMidWidth1;
        float yOffsetMid1 = (float)(-Math.sin(gauageNeedleNormalRadians)) * pointerMidWidth1;
        float xOffsetMid2 = (float)Math.cos(gauageNeedleNormalRadians) * pointerMidWidth2;
        float yOffsetMid2 = (float)(-Math.sin(gauageNeedleNormalRadians)) * pointerMidWidth2;
        switch (highLight) {
            case 0: {
                poly.moveTo(cx1, cy1);
                poly.lineTo(cx1 + xMid1 + xOffsetMid1, cy1 + yMid1 + yOffsetMid1);
                poly.lineTo(cx1 + xMid2 + xOffsetMid2, cy1 + yMid2 + yOffsetMid2);
                poly.lineTo(cx2, cy2);
                poly.lineTo(cx1 + xMid2 - xOffsetMid2, cy1 + yMid2 - yOffsetMid2);
                poly.lineTo(cx1 + xMid1 - xOffsetMid1, cy1 + yMid1 - yOffsetMid1);
                poly.lineTo(cx1, cy1);
                break;
            }
            case 1: {
                poly.moveTo(cx1, cy1);
                poly.lineTo(cx1 + xMid1, cy1 + yMid1);
                poly.lineTo(cx1 + xMid2, cy1 + yMid2);
                poly.lineTo(cx2, cy2);
                poly.lineTo(cx1 + xMid2 - xOffsetMid2, cy1 + yMid2 - yOffsetMid2);
                poly.lineTo(cx1 + xMid1 - xOffsetMid1, cy1 + yMid1 - yOffsetMid1);
                poly.lineTo(cx1, cy1);
            }
        }
        return poly;
    }

    private void drawGaugeNeedle(Graphics2D g2) {
        Shape polyshape = this.getNeedlePointer(0, this.CenterX, this.CenterY, (float)this.GaugeNeedleX, (float)this.GaugeNeedleY);
        Area boundingPolyArea = new Area(polyshape);
        g2.setColor(this.GaugeNeedleColorPrivate);
        g2.fill(boundingPolyArea);
        Shape polyshape2 = this.getNeedlePointer(1, this.CenterX, this.CenterY, (float)this.GaugeNeedleX, (float)this.GaugeNeedleY);
        Area boundingPolyArea2 = new Area(polyshape2);
        if (this.GaugeNeedleColorPrivate.equals(Color.black)) {
            g2.setColor(new Color(60, 60, 60));
        } else {
            g2.setColor(this.getDarkerColor(this.GaugeNeedleColorPrivate));
        }
        g2.fill(boundingPolyArea2);
    }

    private void drawSlices(Graphics2D g2, int draw) {
        this.CenterX = (float)this.XOffset + (float)this.CircumLabelWidthOffsetInt + (float)this.PieRadius;
        this.CenterY = (float)this.YOffset + (float)this.CircumLabelHeightOffsetInt + (float)this.PieRadius;
        boolean test = false;
        boolean testCosmetics = false;
        double startAngle = this.initialStartAngle;
        double deltaAngle = 0.0;
        this.setSliceRenderingHints(g2);
        this.Arc = new Arc2D[this.SliceDesc.length];
        Object boundingRect = null;
        Area boundingPolyArea = null;
        Area AreaCrescent = null;
        Area AreaShadowTemp = null;
        Area areaOne = null;
        Object sideShadow = null;
        Area sideShadowArea = null;
        Point2D.Double effectCenter = this.E3D.getShadowOffset();
        if (this.StyleDesc.getStyleType() != 0 && draw != 0) {
            this.E3D.computeCircumference();
            this.E3D.computeShadowCircumference();
            double shadowDiameter = this.E3D.getShadowDiameter();
            double radiusDiff = ((double)this.PieDiameter - shadowDiameter) / 2.0;
            Ellipse2D.Double shapeShadow = new Ellipse2D.Double((double)(this.XOffset + this.CircumLabelWidthOffsetInt) + effectCenter.x + radiusDiff, (double)(this.YOffset + this.CircumLabelHeightOffsetInt) + effectCenter.y + radiusDiff, shadowDiameter, shadowDiameter);
            Ellipse2D.Double shapeOriginal = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
            AreaShadowTemp = new Area(shapeShadow);
            areaOne = new Area(shapeShadow);
            AreaCrescent = new Area(shapeOriginal);
            Shape polyshape = this.getCircleConeShape(this.E3D);
            sideShadowArea = new Area(polyshape);
            areaOne.add(sideShadowArea);
            AreaCrescent.exclusiveOr(areaOne);
            AreaCrescent.intersect(areaOne);
        }
        Color sliceBGColor = Color.gray;
        if (this.PieSubType == 1) {
            this.drawGaugeBackground2(g2, false);
        }
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            this.SliceAngle[i].deltaAngle = deltaAngle = this.percentToAngle(this.SliceDesc[i].getValue());
            this.SliceAngle[i].startAngle = !this.clockwise ? startAngle : 360.0 + startAngle - deltaAngle;
            int halfXOffset = (this.XOffset + this.CircumLabelWidthOffsetInt) / 2;
            int halfYOffset = (this.YOffset + this.CircumLabelHeightOffsetInt) / 2;
            if (draw != 0) {
                this.Arc[i] = new Arc2D.Double(2);
                this.Arc[i].setFrame(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
                this.Arc[i].setAngleStart(this.SliceAngle[i].startAngle);
                this.Arc[i].setAngleExtent(deltaAngle);
                sliceBGColor = this.SliceDesc[i].getBackground();
                if (this.HilightIndex == i) {
                    g2.setColor(this.HilightColor);
                    sliceBGColor = this.HilightColor;
                    if (this.DrawLegend) {
                        this.L2.setLegendItemColor(this.SliceDesc[i].getLabel(), this.HilightColor);
                    }
                }
                if (this.StyleDesc.getStyleType() == 2) {
                    Rectangle2D sliceBounds = new Rectangle2D.Double();
                    sliceBounds = this.Arc[i].getBounds2D();
                    double angleStartNM = this.getNormalizedAngle(this.SliceAngle[i].startAngle);
                    double angleEndNM = this.getNormalizedAngle(this.SliceAngle[i].startAngle + deltaAngle);
                    double angleMidNM = this.getNormalizedAngle(this.SliceAngle[i].startAngle + deltaAngle / 2.0);
                    if (this.E3D.oneSliceShadow(angleStartNM, angleEndNM, deltaAngle)) {
                        Color sliceShadowColor = this.getDarkerColor(sliceBGColor);
                        g2.setColor(sliceShadowColor);
                        g2.fill(AreaCrescent);
                        g2.setColor(sliceShadowColor);
                        g2.draw(AreaCrescent);
                    } else if (this.E3D.inShadow(angleStartNM) || this.E3D.inShadow(angleEndNM) || this.E3D.inShadow(angleMidNM)) {
                        double cx1 = this.SliceAngle[i].startCircumX;
                        double cy1 = this.SliceAngle[i].startCircumY;
                        double cx2 = this.SliceAngle[i].endCircumX;
                        double cy2 = this.SliceAngle[i].endCircumY;
                        if (this.E3D.inInOutShadow(angleStartNM, angleEndNM, angleMidNM)) {
                            Shape polyshape1 = this.getPolyShape((float)cx1, (float)cy1, (float)this.E3D.endCircumX, (float)this.E3D.endCircumY);
                            Shape polyshape2 = this.getPolyShape((float)cx2, (float)cy2, (float)this.E3D.startCircumX, (float)this.E3D.startCircumY);
                            Color sliceShadowColor = this.getDarkerColor(sliceBGColor);
                            boundingPolyArea = new Area(polyshape1);
                            boundingPolyArea.intersect(AreaCrescent);
                            g2.setColor(sliceShadowColor);
                            g2.fill(boundingPolyArea);
                            g2.setColor(sliceShadowColor);
                            g2.draw(boundingPolyArea);
                            boundingPolyArea = new Area(polyshape2);
                            boundingPolyArea.intersect(AreaCrescent);
                            g2.setColor(sliceShadowColor);
                            g2.fill(boundingPolyArea);
                            g2.setColor(sliceShadowColor);
                            g2.draw(boundingPolyArea);
                        } else {
                            if (this.E3D.inOutShadow(angleStartNM, angleEndNM)) {
                                cx2 = this.E3D.endCircumX;
                                cy2 = this.E3D.endCircumY;
                            }
                            if (this.E3D.outInShadow(angleStartNM, angleEndNM)) {
                                cx1 = this.E3D.startCircumX;
                                cy1 = this.E3D.startCircumY;
                            }
                            Shape polyshape = this.getPolyShape((float)cx1, (float)cy1, (float)cx2, (float)cy2);
                            boundingPolyArea = new Area(polyshape);
                            boundingPolyArea.intersect(AreaCrescent);
                            Color sliceShadowColor = this.getDarkerColor(sliceBGColor);
                            g2.setColor(sliceShadowColor);
                            g2.fill(boundingPolyArea);
                            g2.setColor(sliceShadowColor);
                            g2.draw(boundingPolyArea);
                        }
                    }
                }
                g2.setColor(sliceBGColor);
                boolean ring = true;
                if (this.PieSubType == 1 && ring) {
                    this.drawRings(g2, i, sliceBGColor);
                } else {
                    g2.setColor(sliceBGColor);
                    g2.fill(this.Arc[i]);
                }
                if (this.StyleDesc.getStyleType() != 0 || this.PieSubType == 1) {
                    g2.setColor(this.getDarkerColor(sliceBGColor));
                } else {
                    g2.setColor(this.getForeground());
                }
                if (this.PieSubType != 1) {
                    g2.draw(this.Arc[i]);
                }
            }
            if (this.clockwise) {
                startAngle -= this.percentToAngle(this.SliceDesc[i].getValue());
                continue;
            }
            startAngle += this.percentToAngle(this.SliceDesc[i].getValue());
        }
        if (this.SliceDesc.length == 1 && deltaAngle >= 360.0) {
            sliceBGColor = this.SliceDesc[0].getBackground();
            if (this.HilightIndex == 0) {
                sliceBGColor = this.HilightColor;
                if (this.DrawLegend) {
                    this.L2.setLegendItemColor(this.SliceDesc[0].getLabel(), this.HilightColor);
                }
            }
            Color sliceShadowColor = this.getDarkerColor(sliceBGColor);
            if (this.StyleDesc.getStyleType() != 0 && draw != 0) {
                g2.setColor(sliceShadowColor);
                g2.fill(AreaCrescent);
                g2.setColor(sliceShadowColor);
                g2.draw(AreaCrescent);
            }
            Ellipse2D.Double e = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
            g2.setColor(sliceBGColor);
            g2.fill(e);
            if (this.StyleDesc.getStyleType() != 0 || this.PieSubType == 1) {
                g2.setColor(sliceShadowColor);
            } else {
                g2.setColor(this.getForeground());
            }
            g2.draw(e);
        }
        if (draw != 0 && this.PieSubType == 1) {
            this.drawAllGaugeTicks(g2);
            this.drawGaugeMinorTicks(g2);
            this.computeGaugeNeedle();
            this.drawGaugeNeedle(g2);
            this.drawRingOutline(g2);
        }
        if (!this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(this.RHOriginal);
        }
    }

    private void drawGaugeMinorTicks(Graphics2D g2) {
        double startAngleRad = Math.toRadians(this.initialStartAngle);
        double endAngleRad = Math.toRadians(this.initialStartAngle + this.GaugeSpanPrivate);
        g2.setStroke(this.MajorTickStroke);
        if (this.DrawFirstAndLastMajorTicks) {
            double tickShave = 1.0;
            this.drawSingleGaugeTick(g2, startAngleRad, this.MajorTickLength, this.GaugeStyleDesc.getTickColor(), tickShave);
            this.drawSingleGaugeTick(g2, endAngleRad, this.MajorTickLength, this.GaugeStyleDesc.getTickColor(), tickShave);
        }
        g2.setStroke(this.getPieStroke());
        this.NumMinorTicks = 20 / this.SliceDesc.length * this.SliceDesc.length;
        for (int i = 1; i < this.NumMinorTicks; ++i) {
            double a = startAngleRad + (endAngleRad - startAngleRad) * ((double)i / (double)this.NumMinorTicks);
            this.drawSingleGaugeTick(g2, a, this.MinorTickLength, this.GaugeStyleDesc.getTickColor(), 0.5);
        }
    }

    private void drawSingleGaugeTick(Graphics2D g2, double angleRad, int tickLength, Color tickColor, double tickShave) {
        double innerX = Math.cos(angleRad) * (this.PieRadius - (double)tickLength) + (double)this.CenterX;
        double innerY = -Math.sin(angleRad) * (this.PieRadius - (double)tickLength) + (double)this.CenterY;
        double outerX = Math.cos(angleRad) * (this.PieRadius - tickShave) + (double)this.CenterX;
        double outerY = -Math.sin(angleRad) * (this.PieRadius - tickShave) + (double)this.CenterY;
        g2.setColor(this.GaugeStyleDesc.getTickColor());
        g2.drawLine((int)Math.round(innerX), (int)Math.round(innerY), (int)Math.round(outerX), (int)Math.round(outerY));
    }

    private void drawAllGaugeTicks(Graphics2D g2) {
        int i;
        double endAngleRad = Math.toRadians(this.initialStartAngle + this.GaugeSpanPrivate);
        int tickX = (int)Math.round(Math.cos(endAngleRad) * this.InnerTickPos + (double)this.CenterX);
        int tickY = (int)Math.round(-Math.sin(endAngleRad) * this.InnerTickPos + (double)this.CenterY);
        int tickX2 = (int)Math.round(Math.cos(endAngleRad) * (this.InnerTickPos - (double)this.InnerTickLength) + (double)this.CenterX);
        int tickY2 = (int)Math.round(-Math.sin(endAngleRad) * (this.InnerTickPos - (double)this.InnerTickLength) + (double)this.CenterY);
        g2.setColor(this.GaugeStyleDesc.getTickInnerColor());
        g2.drawLine(tickX, tickY, tickX2, tickY2);
        g2.setStroke(this.getPieStroke());
        for (i = 0; i < this.SliceDesc.length; ++i) {
            this.drawGaugeSliceInnerTick(g2, i);
        }
        g2.setStroke(this.MajorTickStroke);
        for (i = 1; i < this.SliceDesc.length; ++i) {
            this.drawGaugeSliceMajorTick(g2, i);
        }
    }

    private void drawGaugeSliceInnerTick(Graphics2D g2, int i) {
        g2.setColor(this.GaugeStyleDesc.getTickInnerColor());
        g2.drawLine((int)Math.round(this.SliceAngle[i].startCircumXInnerTick), (int)Math.round(this.SliceAngle[i].startCircumYInnerTick), (int)Math.round(this.SliceAngle[i].startCircumXInnerTick2), (int)Math.round(this.SliceAngle[i].startCircumYInnerTick2));
    }

    private void drawGaugeSliceMajorTick(Graphics2D g2, int i) {
        int tickX = (int)Math.round(this.SliceAngle[i].startCircumXTick);
        int tickY = (int)Math.round(this.SliceAngle[i].startCircumYTick);
        int tickX2 = (int)Math.round(this.SliceAngle[i].startCircumX);
        int tickY2 = (int)Math.round(this.SliceAngle[i].startCircumY);
        g2.setColor(this.GaugeStyleDesc.getTickColor());
        g2.drawLine(tickX, tickY, tickX2, tickY2);
    }

    private void drawGaugeBackground(Graphics2D g2) {
        Ellipse2D.Double e = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
        RoundGradientPaint rgp = new RoundGradientPaint((double)(this.XOffset + this.CircumLabelWidthOffsetInt) + this.PieRadius, (double)(this.YOffset + this.CircumLabelHeightOffsetInt) + this.PieRadius, new Color(255, 0, 0, 128), 0.0, this.PieRadius, new Color(0, 0, 255, 128));
        g2.setPaint(rgp);
        g2.fill(e);
    }

    private void drawGaugeBackground2(Graphics2D g2, boolean raised) {
        this.E3D.computeCircumference();
        this.E3D.computeShadowCircumference();
        Point2D.Double effectCenter = this.E3D.getShadowOffset();
        double factor = Math.pow(this.PieDiameter, 0.3) * 0.04;
        Ellipse2D.Double shapeShadow = new Ellipse2D.Double((double)(this.XOffset + this.CircumLabelWidthOffsetInt) + effectCenter.x * factor, (double)(this.YOffset + this.CircumLabelHeightOffsetInt) + effectCenter.y * factor, this.PieDiameter, this.PieDiameter);
        double innerFract = 0.66;
        Ellipse2D.Double shapeInnerShadow = new Ellipse2D.Double((double)(this.XOffset + this.CircumLabelWidthOffsetInt) - innerFract * effectCenter.x, (double)(this.YOffset + this.CircumLabelHeightOffsetInt) - innerFract * effectCenter.y, this.PieDiameter, this.PieDiameter);
        Ellipse2D.Double shapeOriginal = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
        Area areaInnerShadow = new Area(shapeInnerShadow);
        Area areaShadow = new Area(shapeShadow);
        Area areaCrescent = new Area(shapeOriginal);
        Rectangle2D.Double r = new Rectangle2D.Double();
        int expand = this.PieDiameter / 3;
        int expandHalf = expand / 2;
        r.setFrame(this.XOffset + this.CircumLabelWidthOffsetInt - expandHalf, this.YOffset + this.CircumLabelHeightOffsetInt - expandHalf, this.PieDiameter + expand, this.PieDiameter + expand);
        double startAngleRad = Math.toRadians(this.initialStartAngle);
        Arc2D.Double allSlices = new Arc2D.Double(r, this.initialStartAngle, this.GaugeSpanPrivate, 2);
        Area areaAllSlices = new Area(allSlices);
        areaCrescent.exclusiveOr(areaShadow);
        areaCrescent.intersect(areaShadow);
        areaCrescent.intersect(areaAllSlices);
        int c_fill = 180;
        int c_alpha = 200;
        g2.setColor(new Color(c_fill, c_fill, c_fill, c_alpha));
        g2.fill(areaCrescent);
        areaCrescent = new Area(shapeOriginal);
        areaInnerShadow.exclusiveOr(areaCrescent);
        areaInnerShadow.intersect(areaCrescent);
        areaInnerShadow.intersect(areaAllSlices);
        c_fill = 150;
        c_alpha = 100;
        g2.setColor(new Color(c_fill, c_fill, c_fill, c_alpha));
        g2.fill(areaInnerShadow);
    }

    private Shape getInnerRingShape() {
        double ringThickness = this.PieRadius * this.GaugeStyleDesc.getRingWidth();
        Ellipse2D.Double innerRingShape = new Ellipse2D.Double((double)this.XOffset + ringThickness + (double)this.CircumLabelWidthOffsetInt, (double)this.YOffset + ringThickness + (double)this.CircumLabelHeightOffsetInt, (double)this.PieDiameter - 2.0 * ringThickness, (double)this.PieDiameter - 2.0 * ringThickness);
        return innerRingShape;
    }

    private void drawRings(Graphics2D g2, int i, Color sliceBGColor) {
        Shape polyshape1 = this.getTriangleShape(this.CenterX, this.CenterY, (float)this.SliceAngle[i].startCircumXExtra, (float)this.SliceAngle[i].startCircumYExtra, (float)this.SliceAngle[i].endCircumXExtra, (float)this.SliceAngle[i].endCircumYExtra);
        Ellipse2D.Double outerRingShape = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
        Area outerRingArea = new Area(outerRingShape);
        Shape innerRingShape = this.getInnerRingShape();
        Area innerRingArea = new Area(innerRingShape);
        Area boundingPolyArea = new Area(polyshape1);
        outerRingArea.exclusiveOr(innerRingArea);
        boundingPolyArea.intersect(outerRingArea);
        g2.setColor(sliceBGColor);
        g2.fill(boundingPolyArea);
    }

    private void drawRingOutline(Graphics2D g2) {
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            Color sliceBGColor = this.SliceDesc[0].getBackground();
            Shape polyshape1 = this.getTriangleShape(this.CenterX, this.CenterY, (float)this.SliceAngle[i].startCircumXExtra, (float)this.SliceAngle[i].startCircumYExtra, (float)this.SliceAngle[i].endCircumXExtra, (float)this.SliceAngle[i].endCircumYExtra);
            int ringInnerLineOffset = 3;
            int ringInnerLineOffsetHalf = ringInnerLineOffset / 2;
            Ellipse2D.Double innerLineRingShape = new Ellipse2D.Double(this.XOffset + ringInnerLineOffsetHalf + this.CircumLabelWidthOffsetInt, this.YOffset + ringInnerLineOffsetHalf + this.CircumLabelHeightOffsetInt, this.PieDiameter - ringInnerLineOffset, this.PieDiameter - ringInnerLineOffset);
            Area innerLineRingArea = new Area(innerLineRingShape);
            Area boundingPolyArea = new Area(polyshape1);
            Ellipse2D.Double outerRingShape = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
            Area outerRingArea = new Area(outerRingShape);
            outerRingArea.exclusiveOr(innerLineRingArea);
            boundingPolyArea.intersect(outerRingArea);
            g2.setColor(this.getDarkerColor(sliceBGColor));
            g2.fill(boundingPolyArea);
        }
    }

    private void copyImageMapSlice(int sliceIndex, double[] x, double[] y) {
        this.ImageMapCoords[sliceIndex] = new int[x.length + y.length];
        this.ImageMapShape = 2;
        for (int i = 0; i < x.length; ++i) {
            this.ImageMapCoords[sliceIndex][i * 2] = (int)Math.round(x[i]);
            this.ImageMapCoords[sliceIndex][i * 2 + 1] = (int)Math.round(y[i]);
        }
    }

    private void copyImageMapSingleSlice(int sliceIndex, int centerX, int centerY, int radius) {
        this.ImageMapShape = 1;
        this.ImageMapCoords[sliceIndex] = new int[3];
        this.ImageMapCoords[sliceIndex][0] = centerX;
        this.ImageMapCoords[sliceIndex][1] = centerY;
        this.ImageMapCoords[sliceIndex][2] = radius;
    }

    public void setEnableImageMapArea() throws ChartException {
        this.genImageMapCoords = true;
        if (this.SliceDesc != null) {
            this.ImageMapCoords = new int[this.SliceDesc.length][0];
        }
    }

    public ImageMapAreaDesc getImageMapAreaDesc() {
        ImageMapAreaDesc imap = new ImageMapAreaDesc();
        imap.setCoords(this.ImageMapCoords);
        imap.setShape(this.ImageMapShape);
        return imap;
    }

    private void computeArc() {
        double startAngle = this.initialStartAngle;
        double deltaAngle = 0.0;
        double centerX = 0.0;
        double centerY = 0.0;
        centerX = (double)this.XOffset + (double)this.CircumLabelWidthOffsetInt + this.PieRadius;
        centerY = (double)this.YOffset + (double)this.CircumLabelHeightOffsetInt + this.PieRadius;
        Point2D.Double effectCenter = this.E3D.getShadowOffset();
        this.Arc = new Arc2D[this.SliceDesc.length];
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            this.SliceAngle[i].deltaAngle = deltaAngle = this.percentToAngle(this.SliceDesc[i].getValue());
            this.SliceAngle[i].startAngle = !this.clockwise ? startAngle : 360.0 + startAngle - deltaAngle;
            this.Arc[i] = new Arc2D.Double(2);
            this.Arc[i].setFrame(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
            this.Arc[i].setAngleStart(this.SliceAngle[i].startAngle);
            this.Arc[i].setAngleExtent(deltaAngle);
            if (this.SliceDesc.length == 1) {
                if (this.genImageMapCoords && this.genImageMapCoords) {
                    this.copyImageMapSingleSlice(i, (int)centerX, (int)centerY, (int)this.PieRadius);
                }
            } else {
                double startX = 0.0;
                double startY = 0.0;
                double endX = 0.0;
                double endY = 0.0;
                double startAngleRad = Math.toRadians(this.SliceAngle[i].startAngle);
                double endAngleRad = Math.toRadians(this.SliceAngle[i].startAngle + deltaAngle);
                double midAngleRad = Math.toRadians(this.SliceAngle[i].startAngle + deltaAngle / 2.0);
                startX = Math.cos(startAngleRad) * this.PieRadius + centerX;
                startY = -Math.sin(startAngleRad) * this.PieRadius + centerY;
                endX = Math.cos(endAngleRad) * this.PieRadius + centerX;
                endY = -Math.sin(endAngleRad) * this.PieRadius + centerY;
                if (this.genImageMapCoords) {
                    double degreeIncrement = 720.0 / this.PieRadius;
                    int numBetween = (int)Math.round(deltaAngle / degreeIncrement);
                    double[] circumferenceX = new double[numBetween + 3];
                    double[] circumferenceY = new double[numBetween + 3];
                    for (int k = 0; k < numBetween; ++k) {
                        double interpolatedAngleRad = Math.toRadians(this.SliceAngle[i].startAngle + (double)k * degreeIncrement);
                        circumferenceX[k + 1] = Math.cos(interpolatedAngleRad) * this.PieRadius + centerX;
                        circumferenceY[k + 1] = -Math.sin(interpolatedAngleRad) * this.PieRadius + centerY;
                    }
                    circumferenceX[0] = centerX;
                    circumferenceY[0] = centerY;
                    circumferenceX[numBetween + 1] = Math.cos(endAngleRad) * this.PieRadius + centerX;
                    circumferenceY[numBetween + 1] = -Math.sin(endAngleRad) * this.PieRadius + centerY;
                    circumferenceX[numBetween + 2] = centerX;
                    circumferenceY[numBetween + 2] = centerY;
                    if (this.genImageMapCoords) {
                        this.copyImageMapSlice(i, circumferenceX, circumferenceY);
                    }
                }
                double tickShave = 1.5;
                this.SliceAngle[i].startCircumX = Math.cos(startAngleRad) * (this.PieRadius - tickShave) + centerX;
                this.SliceAngle[i].startCircumY = -Math.sin(startAngleRad) * (this.PieRadius - tickShave) + centerY;
                this.SliceAngle[i].startCircumXTick = Math.cos(startAngleRad) * (this.PieRadius - (double)this.MajorTickLength) + centerX;
                this.SliceAngle[i].startCircumYTick = -Math.sin(startAngleRad) * (this.PieRadius - (double)this.MajorTickLength) + centerY;
                this.SliceAngle[i].startCircumXInnerTick = Math.cos(startAngleRad) * this.InnerTickPos + centerX;
                this.SliceAngle[i].startCircumYInnerTick = -Math.sin(startAngleRad) * this.InnerTickPos + centerY;
                this.SliceAngle[i].startCircumXInnerTick2 = Math.cos(startAngleRad) * (this.InnerTickPos - (double)this.InnerTickLength) + centerX;
                this.SliceAngle[i].startCircumYInnerTick2 = -Math.sin(startAngleRad) * (this.InnerTickPos - (double)this.InnerTickLength) + centerY;
                this.SliceAngle[i].startCircumXExtra = Math.cos(startAngleRad) * 2.0 * this.PieRadius + centerX;
                this.SliceAngle[i].startCircumYExtra = -Math.sin(startAngleRad) * 2.0 * this.PieRadius + centerY;
                this.SliceAngle[i].endCircumX = Math.cos(endAngleRad) * this.PieRadius + centerX;
                this.SliceAngle[i].endCircumY = -Math.sin(endAngleRad) * this.PieRadius + centerY;
                this.SliceAngle[i].endCircumXExtra = Math.cos(endAngleRad) * 2.0 * this.PieRadius + centerX;
                this.SliceAngle[i].endCircumYExtra = -Math.sin(endAngleRad) * 2.0 * this.PieRadius + centerY;
                this.SliceAngle[i].midCircumShadowX = Math.cos(midAngleRad) * this.PieRadius + centerX + effectCenter.x;
                this.SliceAngle[i].midCircumShadowY = -Math.sin(midAngleRad) * this.PieRadius + centerY + effectCenter.y;
            }
            if (this.clockwise) {
                startAngle -= this.percentToAngle(this.SliceDesc[i].getValue());
                continue;
            }
            startAngle += this.percentToAngle(this.SliceDesc[i].getValue());
        }
    }

    private void redrawEmptySlices(Graphics2D g2, int draw) {
        this.setSliceRenderingHints(g2);
        if (draw == 1) {
            for (int i = 0; i < this.SliceDesc.length; ++i) {
                if (this.interiorLabel[i]) continue;
                Color sliceBGColor = this.SliceDesc[i].getBackground();
                g2.setStroke(this.getPieStroke());
                if (this.HilightIndex == i) {
                    g2.setColor(this.HilightColor);
                    if (this.DrawLegend) {
                        this.L2.setLegendItemColor(this.SliceDesc[i].getLabel(), this.HilightColor);
                    }
                } else {
                    g2.setColor(sliceBGColor);
                }
                float centerX = (float)this.XOffset + (float)this.CircumLabelWidthOffsetInt + (float)this.PieRadius;
                float centerY = (float)this.YOffset + (float)this.CircumLabelHeightOffsetInt + (float)this.PieRadius;
                int cx1 = (int)Math.round((this.SliceAngle[i].startCircumX + this.SliceAngle[i].endCircumX) / 2.0 + (double)centerX);
                int cy1 = (int)Math.round((this.SliceAngle[i].startCircumY + this.SliceAngle[i].endCircumY) / 2.0 + (double)centerY);
                GradientPaint gp = new GradientPaint(centerX, centerY, Color.white, cx1, cx1, sliceBGColor);
                g2.setPaint(gp);
                g2.fill(this.Arc[i]);
                if (this.StyleDesc.getStyleType() != 0 || this.PieSubType == 1) {
                    g2.setColor(this.getDarkerColor(sliceBGColor));
                } else {
                    g2.setColor(this.getForeground());
                }
                g2.draw(this.Arc[i]);
            }
        }
        if (!this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(this.RHOriginal);
        }
    }

    private void redrawLabeledSlices(Graphics2D g2, int draw) {
        this.setSliceRenderingHints(g2);
        if (draw == 1) {
            for (int i = 0; i < this.SliceDesc.length; ++i) {
                if (!this.interiorLabel[i]) continue;
                g2.setStroke(this.getPieStroke());
                if (this.HilightIndex == i) {
                    g2.setColor(this.HilightColor);
                    if (this.DrawLegend) {
                        this.L2.setLegendItemColor(this.SliceDesc[i].getLabel(), this.HilightColor);
                    }
                } else {
                    g2.setColor(this.SliceDesc[i].getBackground());
                }
                g2.fill(this.Arc[i]);
                g2.setColor(this.getForeground());
                g2.draw(this.Arc[i]);
            }
        }
        double deltaAngle = this.percentToAngle(this.SliceDesc[0].getValue());
        if (this.SliceDesc.length == 1 && deltaAngle >= 360.0) {
            if (this.HilightIndex == 0) {
                g2.setColor(this.HilightColor);
                if (this.DrawLegend) {
                    this.L2.setLegendItemColor(this.SliceDesc[0].getLabel(), this.HilightColor);
                }
            } else {
                g2.setColor(this.SliceDesc[0].getBackground());
            }
            Ellipse2D.Double e = new Ellipse2D.Double(this.XOffset + this.CircumLabelWidthOffsetInt, this.YOffset + this.CircumLabelHeightOffsetInt, this.PieDiameter, this.PieDiameter);
            g2.fill(e);
            g2.setColor(this.getForeground());
            g2.draw(e);
        }
        if (!this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(this.RHOriginal);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (w > 0 || h > 0) {
            this.setSize(w, h);
        }
        super.setBounds(x, y, w, h);
    }

    @Override
    public void setBounds(Rectangle rect) {
        if (rect.width > 0 || rect.height > 0) {
            this.setSize(rect.width, rect.height);
        }
        super.setBounds(rect);
    }

    @Override
    public void setSize(Dimension d) {
        if (d.width > 0 || d.height > 0) {
            this.setSize(d.height, d.width);
        }
    }

    @Override
    public void setSize(int width, int height) {
        if (width <= 0 && height <= 0) {
            return;
        }
        this.SizeChanged = true;
        if (width == 0) {
            this.setHeightInternal(height);
        } else if (height == 0) {
            this.setWidthInternal(width);
        } else {
            super.setSizeInternal(width, height);
        }
        this.displayHeight = super.getHeight();
        this.displayWidth = super.getWidth();
        this.setPieDiameter2();
    }

    private void drawBackground(Graphics2D g2) {
        if (this.drawBackgroundRect) {
            g2.setColor(super.getBackground());
            g2.fillRect(0, 0, this.displayWidth, this.displayHeight);
            g2.setColor(this.getEdgeColor());
            g2.drawRect(0, 0, this.displayWidth - 1, this.displayHeight - 1);
        }
        super.getTitle().drawBuffer(g2);
        super.getSubtitle().drawBuffer(g2);
        super.getFootnote().drawBuffer(g2);
    }

    private void addLegend() {
        this.L2.clearLegend();
        this.L2.resetLegendReduce();
        if (this.disableLegend) {
            return;
        }
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            int j = this.PieSubType == 1 ? this.SliceDesc.length - i - 1 : i;
            String label = this.SliceDesc[j].getLabel();
            String href = null;
            this.L2.setAddLegendItem(label, this.SliceDesc[j].getBackground());
            this.L2.setUpdateLegendItemXLink(label, href);
        }
        if (!this.disableLegend) {
            this.DrawLegend = true;
        }
        this.L2.setLegendColumns(1);
        this.L2.getLegendHeight();
        this.L2.getLegendWidth();
        Dimension d = this.L2.getLegendSize();
        boolean needsLegend = this.setPieDiameterLegend(d.width, d.height);
        if (!needsLegend) {
            this.setPieDiameter2();
            this.DrawLegend = false;
        }
    }

    private void layoutL(Graphics2D g2) {
        this.addLegend();
        this.drawBackground(g2);
        this.computeArc();
        this.drawSlices(g2, 1);
        if (this.HilightLabelIndex > -1) {
            this.hilightLegendText(g2);
        }
    }

    private boolean[] layout(Graphics2D g2, int draw, boolean knownLayout, boolean[] IE) throws ChartException {
        this.initMinMax();
        this.computeArc();
        if (draw != 0) {
            this.drawBackground(g2);
        }
        this.drawSlices(g2, draw);
        boolean test = false;
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            Vector SliceLabelLines = null;
            boolean isMulti = false;
            PieLayout pl = new PieLayout();
            String label = this.SliceDesc[i].getLabel();
            this.interiorLabel[i] = false;
            if (!knownLayout) {
                IE[i] = false;
            }
            int labelHeight = this.fontmet.getAscent();
            int labelWidth = label != null ? this.fontmet.stringWidth(label) : 0;
            double labelHeightNormalized = (double)labelHeight / this.PieRadius;
            double labelWidthNormalized = (double)labelWidth / this.PieRadius;
            int base = this.fontmet.getMaxAscent();
            boolean fits = false;
            boolean containsDelim = this.containsDelimiters(this.SliceDesc[i]);
            boolean containsSeparateLineDelim = this.containsSeparateLineDelimiters(this.SliceDesc[i]);
            if ((!containsDelim || !this.lastWordNewline && !containsSeparateLineDelim) && (!knownLayout || knownLayout && IE[i])) {
                fits = label == null || label == "" ? true : this.deriveRect(g2, pl, this.SliceAngle[i].startAngle, this.SliceAngle[i].deltaAngle, labelWidthNormalized, labelHeightNormalized, null);
                if (fits) {
                    isMulti = false;
                    if (draw == 1) {
                        this.drawLabelInSlice(g2, pl, isMulti, label, null, i);
                    }
                    this.interiorLabel[i] = true;
                    if (!knownLayout) {
                        IE[i] = true;
                    }
                }
            } else {
                fits = false;
                this.interiorLabel[i] = false;
                if (!knownLayout) {
                    IE[i] = false;
                }
            }
            if (!fits && (!knownLayout || knownLayout && IE[i])) {
                SliceLabelBreak SliceLabel = new SliceLabelBreak(label);
                if (this.lastWordNewline) {
                    SliceLabel.setLastWordNewline();
                }
                if (this.userDefinedDelimiters) {
                    SliceLabel.setDelimiters(this.userDelimiters);
                }
                SliceLabel.init(new String(this.SeparateLineCharsC));
                int numDelimiters = SliceLabel.getNumDelimiters();
                for (int k = 0; k < numDelimiters; ++k) {
                    String maxLine = "";
                    SliceLabelLines = SliceLabel.getLabel(k);
                    if (SliceLabelLines == null) continue;
                    boolean test2 = false;
                    for (int j = 0; j < SliceLabelLines.size(); ++j) {
                        String s = (String)SliceLabelLines.elementAt(j);
                        if (s.length() <= maxLine.length()) continue;
                        maxLine = s;
                    }
                    labelHeight = this.fontmet.getAscent() * SliceLabelLines.size();
                    labelHeightNormalized = (double)labelHeight / this.PieRadius;
                    labelWidth = this.fontmet.stringWidth(maxLine);
                    labelWidthNormalized = (double)labelWidth / this.PieRadius;
                    fits = label == null || label == "" ? true : this.deriveRect(g2, pl, this.SliceAngle[i].startAngle, this.SliceAngle[i].deltaAngle, labelWidthNormalized, labelHeightNormalized, SliceLabelLines);
                    if (fits) {
                        if (!knownLayout) {
                            IE[i] = true;
                        }
                        isMulti = true;
                        if (draw == 1) {
                            this.drawLabelInSlice(g2, pl, isMulti, maxLine, SliceLabelLines, i);
                        }
                        this.interiorLabel[i] = true;
                    } else {
                        this.interiorLabel[i] = false;
                    }
                    if (fits) break;
                }
            }
            this.SliceStoredLayout[i].isMulti = isMulti;
            this.SliceStoredLayout[i].interiorLabel = this.interiorLabel[i];
            this.SliceStoredLayout[i].label = label;
            this.SliceStoredLayout[i].pl = pl;
            this.SliceStoredLayout[i].SliceLabelLines = SliceLabelLines;
        }
        this.exLayout = new ExLabelLayout();
        this.exLayout.init();
        boolean flag = false;
        if (draw == 1) {
            flag = true;
        }
        this.exLayout.draw(g2, 0, flag);
        this.exLayout.draw(g2, 1, flag);
        return IE;
    }

    double getNormalizedFactor(double labelHeight, boolean shrink) {
        this.NormalizationFactor = this.getMaxXYNormalized();
        double scaleFactor = 0.0;
        double labelHeightNormalized = 0.0;
        if (this.NormalizationFactor >= 1.0 && this.NormalizationFactor < 2.0) {
            scaleFactor = 2.0 - this.NormalizationFactor;
            double OldPieRadius = this.PieRadiusCircumL;
            this.PieRadius = this.PieRadiusCircumL * scaleFactor;
            this.PieDiameter = (int)(this.PieRadius * 2.0);
            labelHeightNormalized = labelHeight / this.PieRadius;
            int diff = (int)(OldPieRadius - this.PieRadius);
            this.XOffset += diff;
            this.YOffset += diff;
        }
        return labelHeightNormalized;
    }

    private boolean layoutCircumferenceAllFit(Graphics2D g2) throws ChartException {
        int i;
        this.initMinMax();
        this.initCircumference();
        this.initCircumference2();
        PieLayout pl = null;
        Object SliceLabelLines = null;
        this.drawSlices(g2, 0);
        int labelHeight = this.fontmet.getAscent();
        double labelHeightNormalized = (double)labelHeight / this.PieRadius;
        boolean allFit = true;
        String label = "";
        for (i = 0; i < this.SliceDesc.length; ++i) {
            pl = new PieLayout();
            boolean fits = false;
            label = this.SliceSecondLabel[i];
            if (label == null || label == "") {
                fits = true;
            } else {
                int labelWidth = this.fontmet.stringWidth(label);
                double labelWidthNormalized = (double)labelWidth / this.PieRadius;
                fits = label == null || label == "" ? true : this.deriveRect(g2, pl, this.SliceAngle[i].startAngle, this.SliceAngle[i].deltaAngle, labelWidthNormalized, labelHeightNormalized, null);
            }
            if (!fits) {
                allFit = false;
                break;
            }
            if (fits) {
                this.interiorLabel[i] = true;
            }
            this.SliceStoredLayout[i].isMulti = false;
            this.SliceStoredLayout[i].interiorLabel = this.interiorLabel[i];
            this.SliceStoredLayout[i].label = label;
            this.SliceStoredLayout[i].pl = pl;
            this.SliceStoredLayout[i].SliceLabelLines = SliceLabelLines;
        }
        if (allFit) {
            this.drawBackground(g2);
            this.computeArc();
            this.drawSlices(g2, 1);
            for (i = 0; i < this.SliceDesc.length; ++i) {
                this.drawLabelInSlice(g2, this.SliceStoredLayout[i].pl, false, this.SliceStoredLayout[i].label, null, i);
            }
            return true;
        }
        this.PieRadiusCircumL = this.PieRadius;
        return false;
    }

    private void layoutCircumference(Graphics2D g2) throws ChartException {
        boolean fits;
        double labelWidthNormalized;
        int labelWidth;
        int i;
        PieLayout pl = null;
        Object SliceLabelLines = null;
        int labelHeight = this.fontmet.getAscent();
        double labelHeightNormalized = (double)labelHeight / this.PieRadius;
        String label = "";
        for (i = 0; i < this.SliceDesc.length; ++i) {
            pl = new PieLayout();
            this.interiorLabel[i] = false;
            label = this.SliceSecondLabel[i];
            labelWidth = this.fontmet.stringWidth(label);
            labelWidthNormalized = (double)labelWidth / this.PieRadius;
            pl.placeCircumference(this.SliceAngle[i].startAngle, this.SliceAngle[i].deltaAngle, labelWidthNormalized, labelHeightNormalized);
        }
        double OriginalPieRadius = this.PieRadius;
        int OriginalXOffset = this.XOffset;
        int OriginalYOffset = this.YOffset;
        labelHeightNormalized = this.getNormalizedFactor(labelHeight, false);
        boolean noRoom = false;
        if (this.NormalizationFactor >= 2.0) {
            noRoom = true;
        }
        this.initMinMax();
        this.initCircumference();
        for (i = 0; i < this.SliceDesc.length; ++i) {
            pl = new PieLayout();
            label = this.SliceSecondLabel[i];
            labelWidth = this.fontmet.stringWidth(label);
            labelWidthNormalized = (double)labelWidth / this.PieRadius;
            fits = false;
            if (label == null || label == "") {
                fits = true;
            } else {
                fits = this.deriveRect(g2, pl, this.SliceAngle[i].startAngle, this.SliceAngle[i].deltaAngle, labelWidthNormalized, labelHeightNormalized, null);
                if (fits) {
                    // empty if block
                }
            }
            if (fits || noRoom) continue;
            pl.placeCircumference(this.SliceAngle[i].startAngle, this.SliceAngle[i].deltaAngle, labelWidthNormalized, labelHeightNormalized);
        }
        this.NormalizationFactor = this.getMaxXYNormalized();
        this.PieRadius = OriginalPieRadius;
        this.XOffset = OriginalXOffset;
        this.YOffset = OriginalYOffset;
        labelHeightNormalized = this.getNormalizedFactor(labelHeight, false);
        this.PieRadius = this.PieDiameter / 2;
        this.convertCircumLabelOffset();
        this.drawBackground(g2);
        this.computeArc();
        this.drawSlices(g2, 1);
        for (i = 0; i < this.SliceDesc.length; ++i) {
            pl = new PieLayout();
            label = this.SliceSecondLabel[i];
            labelWidth = this.fontmet.stringWidth(label);
            labelWidthNormalized = (double)labelWidth / this.PieRadius;
            fits = false;
            fits = label == null || label == "" ? true : this.deriveRect(g2, pl, this.SliceAngle[i].startAngle, this.SliceAngle[i].deltaAngle, labelWidthNormalized, labelHeightNormalized, null);
            if (fits) {
                this.interiorLabel[i] = true;
                this.drawLabelInSlice(g2, pl, false, label, null, i);
            }
            if (!fits && !noRoom) {
                pl.placeCircumference(this.SliceAngle[i].startAngle, this.SliceAngle[i].deltaAngle, labelWidthNormalized, labelHeightNormalized);
                this.interiorLabel[i] = false;
            }
            this.SliceStoredLayout[i].isMulti = false;
            this.SliceStoredLayout[i].interiorLabel = this.interiorLabel[i];
            this.SliceStoredLayout[i].label = label;
            this.SliceStoredLayout[i].pl = pl;
            this.SliceStoredLayout[i].SliceLabelLines = SliceLabelLines;
        }
        this.SpreadCircumferenceLabels(g2, this.PieRadius);
        for (i = 0; i < this.SliceDesc.length; ++i) {
            if (this.SliceStoredLayout[i].interiorLabel) continue;
            this.drawLabelInSlice(g2, this.SliceStoredLayout[i].pl, false, this.SliceStoredLayout[i].label, null, i);
        }
    }

    private void SpreadCircumferenceLabels(Graphics2D g2, double pieRadius) {
        int firstInteriorLabelIndex = -1;
        int lastInteriorLabelIndex = -1;
        int prevInteriorLabelIndex = 0;
        int spreadComplete = -1;
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            if (this.SliceStoredLayout[i].interiorLabel) continue;
            if (firstInteriorLabelIndex == -1) {
                firstInteriorLabelIndex = i;
                lastInteriorLabelIndex = i;
            } else if (i == prevInteriorLabelIndex + 1) {
                lastInteriorLabelIndex = i;
            } else {
                this.doSpread(firstInteriorLabelIndex, lastInteriorLabelIndex);
                spreadComplete = firstInteriorLabelIndex;
                firstInteriorLabelIndex = i;
                lastInteriorLabelIndex = i;
            }
            prevInteriorLabelIndex = i;
        }
        if (spreadComplete != firstInteriorLabelIndex) {
            this.doSpread(firstInteriorLabelIndex, lastInteriorLabelIndex);
        }
    }

    private void doSpread(int firstIndex, int lastIndex) {
        double crowdRadialSpread = 0.0;
        double crowdRadialSpreadThreshold = 105.0;
        if (firstIndex != -1) {
            double startAngle = this.SliceAngle[firstIndex].startAngle;
            double endAngle = this.SliceAngle[lastIndex].startAngle;
            crowdRadialSpread = this.clockwise ? startAngle + this.SliceAngle[firstIndex].deltaAngle - endAngle : endAngle + this.SliceAngle[lastIndex].deltaAngle - startAngle;
        }
        if (crowdRadialSpread > crowdRadialSpreadThreshold) {
            return;
        }
        boolean debug = false;
        Rectangle2D.Double rect_prev = null;
        Rectangle2D.Double rect_curr = null;
        boolean firstOverlap = true;
        Vector<SpreadCircumferenceLabels> overlappingLabels = new Vector<SpreadCircumferenceLabels>();
        Vector<SpreadCircumferenceLabels> overlappingLabelsBefore = new Vector<SpreadCircumferenceLabels>();
        Vector<SpreadCircumferenceLabels> overlappingLabelsAfter = new Vector<SpreadCircumferenceLabels>();
        int prev_index = firstIndex;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            if (this.SliceStoredLayout[i].interiorLabel) continue;
            PieLayout px = this.SliceStoredLayout[i].pl;
            double curr_x = px.getX();
            double curr_y = px.getY();
            rect_curr = new Rectangle2D.Double(curr_x, curr_y, px.labelWidthNormalized, px.labelHeightNormalized);
            RectangleMinMaxTheta minMaxTheta = new RectangleMinMaxTheta();
            minMaxTheta.getRectTheta(rect_curr);
            if (i > 0 && rect_prev != null) {
                if (this.overlap(rect_curr, rect_prev)) {
                    if (firstOverlap) {
                        firstOverlap = false;
                        overlappingLabels.add(new SpreadCircumferenceLabels(prev_index, rect_prev));
                    }
                    overlappingLabels.add(new SpreadCircumferenceLabels(i, rect_curr));
                } else if (overlappingLabels.size() == 0) {
                    overlappingLabelsBefore.add(new SpreadCircumferenceLabels(prev_index, rect_prev));
                } else {
                    overlappingLabelsAfter.add(new SpreadCircumferenceLabels(i, rect_curr));
                }
            }
            rect_prev = rect_curr;
            prev_index = i;
        }
        int midIndex = overlappingLabels.size() / 2;
        boolean positiveAngle = false;
        if (overlappingLabels.size() > 0) {
            SpreadCircumferenceLabels s2;
            SpreadCircumferenceLabels s;
            if (overlappingLabels.size() % 2 == 0) {
                s = (SpreadCircumferenceLabels)overlappingLabels.elementAt(midIndex - 1);
                s2 = (SpreadCircumferenceLabels)overlappingLabels.elementAt(midIndex);
                this.adjustFirstPairCircumfereceLabel(s, s2, this.clockwise);
                int i = midIndex;
                while (i + 1 < overlappingLabels.size()) {
                    s = (SpreadCircumferenceLabels)overlappingLabels.elementAt(i);
                    s2 = (SpreadCircumferenceLabels)overlappingLabels.elementAt(i + 1);
                    positiveAngle = !this.clockwise;
                    this.adjustCircumfereceLabel(s, s2, positiveAngle);
                    ++i;
                }
                for (i = midIndex; i > 0; --i) {
                    s = (SpreadCircumferenceLabels)overlappingLabels.elementAt(i);
                    s2 = (SpreadCircumferenceLabels)overlappingLabels.elementAt(i - 1);
                    positiveAngle = this.clockwise;
                    this.adjustCircumfereceLabel(s, s2, positiveAngle);
                }
            } else {
                this.adjustFirstCircumfereceLabel((SpreadCircumferenceLabels)overlappingLabels.elementAt(midIndex));
                int i = midIndex;
                while (i + 1 < overlappingLabels.size()) {
                    s = (SpreadCircumferenceLabels)overlappingLabels.elementAt(i);
                    s2 = (SpreadCircumferenceLabels)overlappingLabels.elementAt(i + 1);
                    positiveAngle = !this.clockwise;
                    this.adjustCircumfereceLabel(s, s2, positiveAngle);
                    ++i;
                }
                for (i = midIndex; i > 0; --i) {
                    s = (SpreadCircumferenceLabels)overlappingLabels.elementAt(i);
                    s2 = (SpreadCircumferenceLabels)overlappingLabels.elementAt(i - 1);
                    positiveAngle = this.clockwise;
                    this.adjustCircumfereceLabel(s, s2, positiveAngle);
                }
            }
            if (overlappingLabelsBefore.size() > 0 || overlappingLabelsAfter.size() > 0) {
                // empty if block
            }
            if (overlappingLabelsBefore.size() > 0) {
                s = (SpreadCircumferenceLabels)overlappingLabelsBefore.elementAt(overlappingLabelsBefore.size() - 1);
                s2 = (SpreadCircumferenceLabels)overlappingLabels.elementAt(0);
                if (this.overlapAny(overlappingLabels, s.boundingRect)) {
                    positiveAngle = this.clockwise;
                    this.adjustCircumfereceLabel(s2, s, positiveAngle);
                }
            }
            if (overlappingLabelsAfter.size() > 0) {
                s = (SpreadCircumferenceLabels)overlappingLabelsAfter.elementAt(0);
                s2 = (SpreadCircumferenceLabels)overlappingLabels.elementAt(overlappingLabels.size() - 1);
                if (this.overlapAny(overlappingLabels, s.boundingRect)) {
                    positiveAngle = !this.clockwise;
                    this.adjustCircumfereceLabel(s2, s, positiveAngle);
                }
            }
        }
    }

    public Rectangle2D.Double getBoundingRect(int i) {
        PieLayout px = this.SliceStoredLayout[i].pl;
        Rectangle2D.Double rect_curr = new Rectangle2D.Double(px.getX(), px.getY(), px.labelWidthNormalized, px.labelHeightNormalized);
        return rect_curr;
    }

    private void adjustFirstCircumfereceLabel(SpreadCircumferenceLabels s) {
        RectangleMinMaxTheta thisLabel = new RectangleMinMaxTheta();
        thisLabel.getRectTheta(s.boundingRect);
        double thisLabelDegrees = Math.toDegrees(thisLabel.thetaMax - thisLabel.thetaMin);
        double deltaAngleAdjust = (thisLabelDegrees - this.SliceAngle[s.index].deltaAngle) / 2.0;
        this.SliceAngle[s.index].startAngleCirLabel = this.SliceAngle[s.index].startAngle - deltaAngleAdjust;
        this.SliceAngle[s.index].deltaAngleCirLabel = thisLabelDegrees;
    }

    private void adjustFirstPairCircumfereceLabel(SpreadCircumferenceLabels s, SpreadCircumferenceLabels s2, boolean clockwise) {
        RectangleMinMaxTheta s_label = new RectangleMinMaxTheta();
        RectangleMinMaxTheta s2_label = new RectangleMinMaxTheta();
        s_label.getRectTheta(s.boundingRect);
        s2_label.getRectTheta(s2.boundingRect);
        double s_labelDegrees = Math.toDegrees(s_label.thetaMax - s_label.thetaMin);
        double s2_labelDegrees = Math.toDegrees(s2_label.thetaMax - s2_label.thetaMin);
        double s_deltaAngleAdjust = s_labelDegrees - this.SliceAngle[s.index].deltaAngle;
        double s2_deltaAngleAdjust = s2_labelDegrees - this.SliceAngle[s2.index].deltaAngle;
        if (!clockwise) {
            this.SliceAngle[s.index].startAngleCirLabel = this.SliceAngle[s.index].startAngle - s_deltaAngleAdjust;
            this.SliceAngle[s.index].deltaAngleCirLabel = s_labelDegrees;
            this.SliceAngle[s2.index].startAngleCirLabel = this.SliceAngle[s2.index].startAngle;
            this.SliceAngle[s2.index].deltaAngleCirLabel = s2_labelDegrees;
        } else {
            this.SliceAngle[s.index].startAngleCirLabel = this.SliceAngle[s.index].startAngle;
            this.SliceAngle[s.index].deltaAngleCirLabel = s_labelDegrees;
            this.SliceAngle[s2.index].startAngleCirLabel = this.SliceAngle[s2.index].startAngle - s2_deltaAngleAdjust;
            this.SliceAngle[s2.index].deltaAngleCirLabel = s2_labelDegrees;
        }
        this.SliceStoredLayout[s.index].pl.placeCircumference(this.SliceAngle[s.index].startAngleCirLabel, this.SliceAngle[s.index].deltaAngleCirLabel, this.SliceStoredLayout[s.index].pl.labelWidthNormalized, this.SliceStoredLayout[s.index].pl.labelHeightNormalized);
        this.SliceStoredLayout[s2.index].pl.placeCircumference(this.SliceAngle[s2.index].startAngleCirLabel, this.SliceAngle[s2.index].deltaAngleCirLabel, this.SliceStoredLayout[s2.index].pl.labelWidthNormalized, this.SliceStoredLayout[s2.index].pl.labelHeightNormalized);
    }

    private void adjustCircumfereceLabel(SpreadCircumferenceLabels s, SpreadCircumferenceLabels s2, boolean positiveAngle) {
        boolean debug = false;
        RectangleMinMaxTheta adjustedLabel = new RectangleMinMaxTheta();
        adjustedLabel.getRectTheta(s2.boundingRect);
        double adjustedLabelDegrees = Math.toDegrees(adjustedLabel.thetaMax - adjustedLabel.thetaMin);
        double startAngleCirLabel = 0.0;
        double deltaAngleCirLabel = 0.0;
        double prevLabelDegrees = this.SliceAngle[s.index].deltaAngleCirLabel;
        double newStartAngle = positiveAngle ? this.SliceAngle[s.index].startAngleCirLabel + prevLabelDegrees : this.SliceAngle[s.index].startAngleCirLabel - prevLabelDegrees;
        this.SliceAngle[s2.index].startAngleCirLabel = newStartAngle;
        this.SliceAngle[s2.index].deltaAngleCirLabel = adjustedLabelDegrees;
        this.SliceStoredLayout[s2.index].pl.placeCircumference(newStartAngle, adjustedLabelDegrees, this.SliceStoredLayout[s2.index].pl.labelWidthNormalized, this.SliceStoredLayout[s2.index].pl.labelHeightNormalized);
    }

    private boolean overlapAny(Vector overlappingLabels, Rectangle2D.Double otherRect) {
        for (int i = 0; i < overlappingLabels.size(); ++i) {
            SpreadCircumferenceLabels s = (SpreadCircumferenceLabels)overlappingLabels.elementAt(i);
            Rectangle2D.Double sRect = this.getBoundingRect(s.index);
            if (!otherRect.intersects(sRect.x, sRect.y, sRect.width, sRect.height)) continue;
            return true;
        }
        return false;
    }

    private boolean overlap(Rectangle2D.Double rect_prev, Rectangle2D.Double rect_curr) {
        return rect_curr.intersects(rect_prev.x, rect_prev.y, rect_prev.width, rect_prev.height);
    }

    private void doLayout(Graphics2D g2) throws ChartException {
        this.drawBackground(g2);
        this.computeArc();
        this.exLayout.draw(g2, 0, true);
        this.exLayout.draw(g2, 1, true);
        this.redrawEmptySlices(g2, 1);
        this.redrawLabeledSlices(g2, 1);
        for (int i = 0; i < this.SliceDesc.length; ++i) {
            if (!this.SliceStoredLayout[i].interiorLabel) continue;
            this.drawLabelInSlice(g2, this.SliceStoredLayout[i].pl, this.SliceStoredLayout[i].isMulti, this.SliceStoredLayout[i].label, this.SliceStoredLayout[i].SliceLabelLines, i);
        }
    }

    boolean deriveRect(Graphics2D g2, PieLayout pl, double startAngle, double deltaAngle, double labelWidthNormalized, double labelHeightNormalized, Vector SliceLabelLines) {
        boolean test = false;
        if (labelWidthNormalized < 0.0) {
            return true;
        }
        boolean fits = false;
        if (deltaAngle <= 90.0) {
            g2.setColor(Color.white);
            fits = pl.deriveRect90(startAngle, deltaAngle, (startAngle + startAngle + deltaAngle) / 2.0, labelWidthNormalized, labelHeightNormalized, SliceLabelLines);
        } else if (deltaAngle < 180.0) {
            fits = pl.deriveRect180(startAngle, deltaAngle, labelWidthNormalized, labelHeightNormalized, SliceLabelLines);
            double endAngle = startAngle + deltaAngle;
            if (this.inQuad3(startAngle) && this.inQuad4(endAngle) || this.inQuad4(startAngle) && this.inQuad1(endAngle) || this.inQuad1(startAngle) && this.inQuad2(endAngle) || this.inQuad2(startAngle) && this.inQuad3(endAngle)) {
                g2.setColor(Color.green);
            } else {
                g2.setColor(Color.blue);
            }
        } else {
            fits = pl.deriveRect360(startAngle, deltaAngle, labelWidthNormalized, labelHeightNormalized);
        }
        String temp = "";
        int size = 0;
        if (SliceLabelLines != null) {
            temp = (String)SliceLabelLines.elementAt(0);
            size = SliceLabelLines.size();
        }
        return fits;
    }

    @Override
    public void paint(Graphics g) {
        if (this.BI == null || this.SizeChanged) {
            this.SizeChanged = false;
            this.displayWidth = this.getWidth();
            this.displayHeight = this.getHeight();
            this.BI = new BufferedImage(this.displayWidth, this.displayHeight, 1);
        }
        Graphics2D g2 = this.BI.createGraphics();
        try {
            this.drawBuffer(g2);
        }
        catch (ChartException e) {
            System.out.println(e.getMessage());
        }
        g.drawImage(this.BI, 0, 0, this);
    }

    private final class ExLabel {
        String pieLabel;
        double startAngle;
        double deltaAngle;
        double midpointAngle;
        int sliceIndex;
        boolean topHemi = false;
        double poleDistance = 0.0;
        int rank = -1;
        boolean rightSide = false;

        boolean isTopHemi() {
            return this.topHemi;
        }

        boolean isBottomHemi() {
            return !this.topHemi;
        }

        boolean notRank() {
            return this.rank == -1;
        }

        double getPoleDistance() {
            return this.poleDistance;
        }

        void setRank(int rank) {
            this.rank = rank;
        }

        int getRank() {
            return this.rank;
        }

        boolean isRightSide() {
            return this.rightSide;
        }

        ExLabel(String label, double startAngle, double deltaAngle, int sliceIndex) {
            this.pieLabel = label.trim();
            this.startAngle = startAngle;
            this.deltaAngle = deltaAngle;
            this.midpointAngle = PieChart.this.getNormalizedAngle(startAngle + deltaAngle / 2.0);
            this.sliceIndex = sliceIndex;
            if (this.midpointAngle < 180.0) {
                this.topHemi = true;
                if (this.midpointAngle <= 90.0) {
                    this.poleDistance = 90.0 - this.midpointAngle;
                    this.rightSide = true;
                } else {
                    this.poleDistance = this.midpointAngle - 90.0;
                    this.rightSide = false;
                }
            } else {
                this.topHemi = false;
                if (this.midpointAngle <= 270.0) {
                    this.poleDistance = 270.0 - this.midpointAngle;
                    this.rightSide = false;
                } else {
                    this.poleDistance = this.midpointAngle - 270.0;
                    this.rightSide = true;
                }
            }
        }
    }

    private final class ExLabelLayout {
        Vector ExteriorLabels = new Vector();
        LinkedList[][] ExteriorLabelsQuad = new LinkedList[2][2];
        static final int TOP = 0;
        static final int BOTTOM = 1;
        static final int RIGHT = 0;
        static final int LEFT = 1;
        int TopStemLength = 8;
        int minStemHeight = 15;
        int BaseStemLength = 4;
        double SideThreshI2 = 22.0;
        double SideThreshC = 30.0;

        private ExLabelLayout() {
        }

        void init() {
            double startAngle = PieChart.this.initialStartAngle;
            String label = "";
            for (int i = 0; i < PieChart.this.SliceDesc.length; ++i) {
                label = PieChart.this.SliceDesc[i].getLabel();
                if (!PieChart.this.interiorLabel[i]) {
                    this.ExteriorLabels.addElement(new ExLabel(label, startAngle, PieChart.this.percentToAngle(PieChart.this.SliceDesc[i].getValue()), i));
                }
                startAngle += PieChart.this.percentToAngle(PieChart.this.SliceDesc[i].getValue());
            }
            this.partitionQuad();
        }

        void partitionQuad() {
            int hemi = 0;
            int side = 0;
            for (hemi = 0; hemi < 2; ++hemi) {
                for (side = 0; side < 2; ++side) {
                    this.ExteriorLabelsQuad[hemi][side] = new LinkedList();
                }
            }
            for (int k = 0; k < this.ExteriorLabels.size(); ++k) {
                ExLabel e = (ExLabel)this.ExteriorLabels.elementAt(k);
                hemi = e.isTopHemi() ? 0 : 1;
                if (this.ExteriorLabelsQuad[hemi][side = e.isRightSide() ? 0 : 1].isEmpty()) {
                    this.ExteriorLabelsQuad[hemi][side].addFirst(e);
                    continue;
                }
                ListIterator L = this.ExteriorLabelsQuad[hemi][side].listIterator();
                boolean added = false;
                for (int i = 0; i < this.ExteriorLabelsQuad[hemi][side].size(); ++i) {
                    ExLabel c = (ExLabel)L.next();
                    if (!(c.getPoleDistance() > e.getPoleDistance())) continue;
                    this.ExteriorLabelsQuad[hemi][side].add(i, e);
                    added = true;
                    break;
                }
                if (added) continue;
                this.ExteriorLabelsQuad[hemi][side].add(e);
            }
        }

        void drawL(Graphics2D g2, int x, int y, int topStemLength, int stemHeight) {
            g2.setColor(PieChart.this.getConnectorColor());
            g2.setStroke(PieChart.this.getConnectorStroke());
            g2.drawLine(x, y, x, y - stemHeight);
            g2.drawLine(x - topStemLength, y - stemHeight, x, y - stemHeight);
        }

        void drawLorDiag(Graphics2D g2, double midpointAngle, int x, int y, int topStemLength, int stemHeight) {
            if (PieChart.this.StyleDesc.getStyleType() != 2) {
                this.drawL(g2, x, y, topStemLength, stemHeight);
            } else if (PieChart.this.E3D.inShadow(midpointAngle)) {
                this.drawLDiag(g2, x, y, topStemLength, stemHeight);
            } else {
                this.drawL(g2, x, y, topStemLength, stemHeight);
            }
        }

        void drawLDiag(Graphics2D g2, int x, int y, int topStemLength, int stemHeight) {
            g2.setColor(PieChart.this.getConnectorColor());
            g2.setStroke(PieChart.this.getConnectorStroke());
            int xcorner = x - topStemLength / 2;
            g2.drawLine(x, y, xcorner, y - stemHeight);
            g2.drawLine(x - topStemLength, y - stemHeight, xcorner, y - stemHeight);
        }

        void drawI(Graphics2D g2, int x, int y, int stemHeight) {
            g2.setColor(PieChart.this.getConnectorColor());
            g2.setStroke(PieChart.this.getConnectorStroke());
            g2.drawLine(x, y, x, y - stemHeight);
        }

        void drawI2(Graphics2D g2, int x, int y, int topStemLength, int stemHeight) {
            g2.setColor(PieChart.this.getConnectorColor());
            g2.setStroke(PieChart.this.getConnectorStroke());
            g2.drawLine(x, y, x + topStemLength, y);
            g2.drawLine(x + topStemLength, y, x + topStemLength, y - stemHeight);
        }

        void drawC(Graphics2D g2, int x, int y, int baseStemWidth, int topStemWidth, int stemHeight) {
            g2.setColor(PieChart.this.getConnectorColor());
            g2.setStroke(PieChart.this.getConnectorStroke());
            g2.drawLine(x, y, x + baseStemWidth, y);
            g2.drawLine(x + baseStemWidth, y, x + baseStemWidth, y - stemHeight);
            g2.drawLine(x + baseStemWidth, y - stemHeight, x - topStemWidth, y - stemHeight);
        }

        void draw(Graphics2D g2, int hemiIndex, boolean draw) {
            int rightCount = this.ExteriorLabelsQuad[hemiIndex][0].size();
            int leftCount = this.ExteriorLabelsQuad[hemiIndex][1].size();
            int fontHeight = PieChart.this.fontmet.getAscent();
            int base = PieChart.this.fontmet.getMaxAscent();
            boolean x = false;
            int y = 0;
            if (leftCount > 0 || rightCount > 0) {
                switch (hemiIndex) {
                    case 0: {
                        y = PieChart.this.YOffset - base;
                        PieStyleDesc cfr_ignored_0 = PieChart.this.StyleDesc;
                        if (PieChart.this.StyleDesc.getStyleType() == 0) break;
                        y -= PieChart.this.Adjust3D.Offset3D_Top;
                        break;
                    }
                    case 1: {
                        y = (int)((double)PieChart.this.YOffset + 2.0 * PieChart.this.PieRadius + (double)base);
                        PieStyleDesc cfr_ignored_1 = PieChart.this.StyleDesc;
                        if (PieChart.this.StyleDesc.getStyleType() == 0) break;
                        y += PieChart.this.Adjust3D.Offset3D_Bottom;
                    }
                }
                ListIterator L = null;
                int leftx = 0;
                if (leftCount == 1 && rightCount == 1 || leftCount == 0 || rightCount == 0) {
                    if (leftCount == 1 && rightCount == 1) {
                        L = this.ExteriorLabelsQuad[hemiIndex][1].listIterator();
                        leftx = this.getmidPointSliceX(L) + PieChart.this.fontmet.getMaxAdvance() / 2;
                    }
                    int side = 0;
                    if (rightCount > 0) {
                        side = 0;
                        L = this.ExteriorLabelsQuad[hemiIndex][side].listIterator();
                        this.drawList(g2, hemiIndex, L, y, side, leftx, draw);
                        y = hemiIndex == 1 ? (y += fontHeight) : (y -= fontHeight);
                    }
                    if (leftCount > 0) {
                        side = 1;
                        L = this.ExteriorLabelsQuad[hemiIndex][side].listIterator();
                        this.drawList(g2, hemiIndex, L, y, side, leftx, draw);
                    }
                } else {
                    L = this.ExteriorLabelsQuad[hemiIndex][0].listIterator(this.ExteriorLabelsQuad[hemiIndex][0].size());
                    this.drawListSplit(g2, hemiIndex, L, y, 0, draw);
                    L = this.ExteriorLabelsQuad[hemiIndex][1].listIterator(this.ExteriorLabelsQuad[hemiIndex][1].size());
                    this.drawListSplit(g2, hemiIndex, L, y, 1, draw);
                }
            }
        }

        private int getmidPointSliceX(ListIterator L) {
            int midpointSliceX = 0;
            if (L.hasNext()) {
                ExLabel e = (ExLabel)L.next();
                double angleMidRad = Math.toRadians(e.midpointAngle);
                midpointSliceX = (int)Math.round(PieChart.this.PieRadius + (double)PieChart.this.XOffset + PieChart.this.PieRadius * Math.cos(angleMidRad));
            }
            return midpointSliceX;
        }

        void drawList(Graphics2D g2, int hemiIndex, ListIterator L, int y, int side, int leftx, boolean draw) {
            boolean testDrawList = false;
            Point2D.Double effectCenter = PieChart.this.E3D.getShadowOffset();
            ExLabel e = null;
            int fontHeight = PieChart.this.fontmet.getAscent();
            int base = PieChart.this.fontmet.getMaxAscent();
            int k = 0;
            int rightCount = this.ExteriorLabelsQuad[hemiIndex][0].size();
            int leftCount = this.ExteriorLabelsQuad[hemiIndex][1].size();
            int minTextY = PieChart.this.YOffset;
            int maxTextY = PieChart.this.YOffset + PieChart.this.PieDiameter;
            int textX = 0;
            int labelWidth = 0;
            int drawCRightCount = 0;
            int drawCLeftCount = 0;
            PieConnectorHelper pieConn = new PieConnectorHelper();
            while (L.hasNext()) {
                e = (ExLabel)L.next();
                int sliceIndex = e.sliceIndex;
                labelWidth = PieChart.this.fontmet.stringWidth(e.pieLabel);
                pieConn.getSliceMidpoint(e.midpointAngle);
                int midpointSliceX = pieConn.midpointSliceX;
                int midpointSliceY = pieConn.midpointSliceY;
                int textY = 0;
                textX = 0;
                textY = hemiIndex == 0 ? y - k * fontHeight : y + k * fontHeight;
                if (side == 0) {
                    if (rightCount > 1) {
                        textX = midpointSliceX - labelWidth - 2 * this.TopStemLength;
                        if (draw) {
                            if (this.rightSideThreshold(e.midpointAngle, this.SideThreshC)) {
                                this.drawC(g2, midpointSliceX, midpointSliceY, this.BaseStemLength + 2 * drawCRightCount, this.TopStemLength, midpointSliceY - textY);
                                ++drawCRightCount;
                            } else {
                                this.drawLorDiag(g2, e.midpointAngle, midpointSliceX, midpointSliceY, this.TopStemLength, midpointSliceY - textY);
                            }
                        }
                    } else {
                        double adjust = hemiIndex == 0 ? (double)(-(2 * base / 3)) : (double)(2 * base / 3);
                        if (draw) {
                            if (this.rightSideThreshold(e.midpointAngle, this.SideThreshI2)) {
                                this.drawI2(g2, midpointSliceX, midpointSliceY, this.BaseStemLength, (int)((double)(midpointSliceY - textY) + adjust));
                            } else {
                                this.drawI(g2, midpointSliceX, midpointSliceY, (int)((double)(midpointSliceY - textY) + adjust));
                            }
                        }
                        textX = (int)((double)PieChart.this.XOffset + PieChart.this.PieRadius - (double)(labelWidth / 2));
                        textX = Math.max(textX, midpointSliceX - labelWidth + PieChart.this.fontmet.getMaxAdvance() / 2);
                        if (leftx != 0) {
                            textX = Math.max(textX, leftx);
                        }
                    }
                } else if (leftCount > 1) {
                    textX = midpointSliceX + 2 * this.TopStemLength;
                    if (draw) {
                        if (this.leftSideThreshold(e.midpointAngle, this.SideThreshC)) {
                            this.drawC(g2, midpointSliceX, midpointSliceY, -this.BaseStemLength - 2 * drawCLeftCount, -this.TopStemLength, midpointSliceY - textY);
                            ++drawCLeftCount;
                        } else {
                            this.drawLorDiag(g2, e.midpointAngle, midpointSliceX, midpointSliceY, -this.TopStemLength, midpointSliceY - textY);
                        }
                    }
                } else {
                    double adjust = hemiIndex == 0 ? (double)(-(2 * base / 3)) : (double)(2 * base / 3);
                    if (draw) {
                        if (this.leftSideThreshold(e.midpointAngle, this.SideThreshI2)) {
                            this.drawI2(g2, midpointSliceX, midpointSliceY, -this.BaseStemLength, (int)((double)(midpointSliceY - textY) + adjust));
                        } else {
                            this.drawI(g2, midpointSliceX, midpointSliceY, (int)((double)(midpointSliceY - textY) + adjust));
                        }
                    }
                    textX = (int)((double)PieChart.this.XOffset + PieChart.this.PieRadius - (double)(labelWidth / 2));
                    textX = Math.min(textX, midpointSliceX - PieChart.this.fontmet.getMaxAdvance() / 2);
                }
                minTextY = textY + base / 3 - fontHeight;
                if (draw) {
                    g2.setFont(PieChart.this.font);
                    if (PieChart.this.HilightLabelIndex == sliceIndex) {
                        g2.setColor(PieChart.this.HilightLabelColor);
                    } else {
                        g2.setColor(PieChart.this.SliceDesc[sliceIndex].getLabelColor());
                    }
                    PieChart.this.SliceLabelLoc[sliceIndex].drawStringSetLocSize(g2, e.pieLabel, textX, textY + base / 3, labelWidth, base);
                }
                maxTextY = textY + base / 3;
                this.setMinMax(textX, textX + labelWidth, minTextY, maxTextY);
                ++k;
                int space_needed = PieChart.this.XOffset - textX;
                if ((space_needed -= PieChart.this.Adjust3D.Offset3D_Left) > 0) {
                    PieChart.this.ScoreD.setLeftSpaceNeeded(space_needed);
                }
                space_needed = textX + labelWidth - (PieChart.this.XOffset + PieChart.this.PieDiameter);
                if ((space_needed -= PieChart.this.Adjust3D.Offset3D_Right) <= 0) continue;
                PieChart.this.ScoreD.setRightSpaceNeeded(space_needed);
            }
            if (k > 0) {
                int new_space_needed;
                if (hemiIndex == 0) {
                    new_space_needed = PieChart.this.YOffset - minTextY - PieChart.this.Adjust3D.Offset3D_Top;
                    PieChart.this.ScoreD.setTopSpaceNeeded(new_space_needed);
                } else {
                    new_space_needed = maxTextY - (PieChart.this.YOffset + PieChart.this.PieDiameter + PieChart.this.Adjust3D.Offset3D_Bottom + PieChart.this.Adjust3D.Offset3D_Top);
                    PieChart.this.ScoreD.setBottomSpaceNeeded(new_space_needed);
                }
            }
        }

        private boolean rightSideThreshold(double angle, double threshhold) {
            return angle < 180.0 ? angle < threshhold : angle > 360.0 - threshhold;
        }

        private boolean leftSideThreshold(double angle, double threshhold) {
            return angle <= 180.0 + threshhold && angle >= 180.0 - threshhold;
        }

        void setMinMax(int x_min, int x_max, int y_min, int y_max) {
            if (x_min < PieChart.this.minX) {
                PieChart.this.minX = x_min;
            }
            if (x_max > PieChart.this.maxX) {
                PieChart.this.maxX = x_max;
            }
            if (y_min < PieChart.this.minY) {
                PieChart.this.minY = y_min;
            }
            if (y_max > PieChart.this.maxY) {
                PieChart.this.maxY = y_max;
            }
        }

        void drawListSplit(Graphics2D g2, int hemiIndex, ListIterator L, int y, int side, boolean draw) {
            ExLabel e = null;
            Point2D.Double effectCenter = PieChart.this.E3D.getShadowOffset();
            int fontHeight = PieChart.this.fontmet.getAscent();
            int base = PieChart.this.fontmet.getMaxAscent();
            int minTextY = PieChart.this.YOffset;
            int maxTextY = PieChart.this.YOffset + PieChart.this.PieDiameter;
            int k = 0;
            int textX = 0;
            int lastTextY = 0;
            int labelWidth = 0;
            PieConnectorHelper pieConn = new PieConnectorHelper();
            while (L.hasPrevious()) {
                e = (ExLabel)L.previous();
                int sliceIndex = e.sliceIndex;
                labelWidth = PieChart.this.fontmet.stringWidth(e.pieLabel);
                pieConn.getSliceMidpoint(e.midpointAngle);
                int midpointSliceX = pieConn.midpointSliceX;
                int midpointSliceY = pieConn.midpointSliceY;
                textX = 0;
                int textY = 0;
                if (hemiIndex == 0) {
                    textY = midpointSliceY - this.minStemHeight;
                    if (lastTextY != 0 && lastTextY - fontHeight < textY) {
                        textY = lastTextY - fontHeight;
                    }
                    lastTextY = textY;
                } else {
                    textY = midpointSliceY + this.minStemHeight;
                    if (lastTextY != 0 && lastTextY + fontHeight > textY) {
                        textY = lastTextY + fontHeight;
                    }
                    lastTextY = textY;
                }
                if (side == 1) {
                    textX = midpointSliceX - labelWidth - 2 * this.TopStemLength;
                    if (draw) {
                        this.drawLorDiag(g2, e.midpointAngle, midpointSliceX, midpointSliceY, this.TopStemLength, midpointSliceY - textY);
                    }
                } else {
                    textX = midpointSliceX + 2 * this.TopStemLength;
                    if (draw) {
                        this.drawLorDiag(g2, e.midpointAngle, midpointSliceX, midpointSliceY, -this.TopStemLength, midpointSliceY - textY);
                    }
                }
                minTextY = textY + base / 3 - fontHeight;
                if (draw) {
                    g2.setFont(PieChart.this.font);
                    if (PieChart.this.HilightLabelIndex == sliceIndex) {
                        g2.setColor(PieChart.this.HilightLabelColor);
                    } else {
                        g2.setColor(PieChart.this.SliceDesc[sliceIndex].getLabelColor());
                    }
                    PieChart.this.SliceLabelLoc[sliceIndex].drawStringSetLocSize(g2, e.pieLabel, textX, textY + base / 3, labelWidth, base);
                }
                maxTextY = textY + base / 3;
                this.setMinMax(textX, textX + labelWidth, minTextY, maxTextY);
                ++k;
                int space_needed = PieChart.this.XOffset - textX;
                if ((space_needed -= PieChart.this.Adjust3D.Offset3D_Left) > 0) {
                    PieChart.this.ScoreD.setLeftSpaceNeeded(space_needed);
                }
                space_needed = textX + labelWidth - (PieChart.this.XOffset + PieChart.this.PieDiameter);
                if ((space_needed -= PieChart.this.Adjust3D.Offset3D_Right) <= 0) continue;
                PieChart.this.ScoreD.setRightSpaceNeeded(space_needed);
            }
            if (k > 0) {
                int new_space_needed;
                if (hemiIndex == 0) {
                    new_space_needed = PieChart.this.YOffset - minTextY;
                    PieChart.this.ScoreD.setTopSpaceNeeded(new_space_needed);
                } else {
                    new_space_needed = maxTextY - (PieChart.this.YOffset + PieChart.this.PieDiameter + PieChart.this.Adjust3D.Offset3D_Bottom + PieChart.this.Adjust3D.Offset3D_Top);
                    PieChart.this.ScoreD.setBottomSpaceNeeded(new_space_needed);
                }
            }
        }
    }

    private final class PieConnectorHelper {
        private double midpointSliceXDouble;
        private double midpointSliceYDouble;
        public int midpointSliceX;
        public int midpointSliceY;

        PieConnectorHelper() {
        }

        public void getSliceMidpoint(double midpointAngleDegrees) {
            double angleMidRad = Math.toRadians(midpointAngleDegrees);
            this.midpointSliceXDouble = PieChart.this.PieRadius + (double)PieChart.this.XOffset + PieChart.this.PieRadius * Math.cos(angleMidRad);
            this.midpointSliceYDouble = (double)PieChart.this.YOffset + PieChart.this.PieRadius - PieChart.this.PieRadius * Math.sin(angleMidRad);
            PieStyleDesc cfr_ignored_0 = PieChart.this.StyleDesc;
            if (PieChart.this.StyleDesc.getStyleType() != 0 && PieChart.this.E3D.inShadow(midpointAngleDegrees)) {
                Point2D.Double effectCenter = PieChart.this.E3D.getShadowOffset();
                this.midpointSliceXDouble += effectCenter.x * 0.9;
                this.midpointSliceYDouble += effectCenter.y * 0.9;
            }
            this.midpointSliceX = (int)Math.round(this.midpointSliceXDouble);
            this.midpointSliceY = (int)Math.round(this.midpointSliceYDouble);
        }
    }

    private final class SpreadCircumferenceLabels {
        public Rectangle2D.Double boundingRect;
        public int index;
        double theta1;
        double theta2;
        double theta3;
        double theta4;
        double r1;
        double r2;
        double r3;
        double r4;

        public SpreadCircumferenceLabels(int i, Rectangle2D.Double r) {
            this.index = i;
            this.boundingRect = r;
        }
    }

    private final class RectangleMinMaxTheta {
        double thetaMin;
        double thetaMax;
        double TwoPI = Math.PI * 2;
        double HalfPI = 1.5707963267948966;
        double theta1;
        double theta2;
        double theta3;
        double theta4;

        private boolean inQuad2() {
            if (this.theta1 >= this.HalfPI && this.theta1 <= 180.0) {
                return true;
            }
            if (this.theta2 >= this.HalfPI && this.theta2 <= 180.0) {
                return true;
            }
            if (this.theta3 >= this.HalfPI && this.theta3 <= 180.0) {
                return true;
            }
            return this.theta4 >= this.HalfPI && this.theta4 <= 180.0;
        }

        private boolean inQuad2(double theta) {
            return theta >= this.HalfPI && theta <= 180.0;
        }

        private boolean inQuad3() {
            if (this.theta1 <= -this.HalfPI && this.theta1 >= -180.0) {
                return true;
            }
            if (this.theta2 <= -this.HalfPI && this.theta2 >= -180.0) {
                return true;
            }
            if (this.theta3 <= -this.HalfPI && this.theta3 >= -180.0) {
                return true;
            }
            return this.theta4 <= -this.HalfPI && this.theta4 >= -180.0;
        }

        private boolean inQuad3(double theta) {
            return theta <= -this.HalfPI && theta >= -180.0;
        }

        private void adjustTheta() {
            if (this.theta1 >= 0.0 && this.theta2 >= 0.0 && this.theta3 >= 0.0 && this.theta4 >= 0.0) {
                return;
            }
            if (this.theta1 <= 0.0 && this.theta2 <= 0.0 && this.theta3 <= 0.0 && this.theta4 <= 0.0) {
                return;
            }
            if (this.inQuad2() && this.inQuad3()) {
                if (this.inQuad3(this.theta1)) {
                    this.theta1 = this.TwoPI + this.theta1;
                }
                if (this.inQuad3(this.theta2)) {
                    this.theta2 = this.TwoPI + this.theta2;
                }
                if (this.inQuad3(this.theta3)) {
                    this.theta3 = this.TwoPI + this.theta3;
                }
                if (this.inQuad3(this.theta4)) {
                    this.theta4 = this.TwoPI + this.theta4;
                }
            }
        }

        private void getRectTheta(Rectangle2D.Double rect) {
            double halfWidth = rect.width / 2.0;
            double halfHeight = rect.height / 2.0;
            double x = rect.x - halfWidth;
            double y = rect.y - halfHeight;
            this.theta1 = Math.atan2(y, x);
            x = rect.x + halfWidth;
            y = rect.y + halfHeight;
            this.theta2 = Math.atan2(y, x);
            x = rect.x - halfWidth;
            y = rect.y + halfHeight;
            this.theta3 = Math.atan2(y, x);
            x = rect.x + halfWidth;
            y = rect.y - halfHeight;
            this.theta4 = Math.atan2(y, x);
            this.adjustTheta();
            this.thetaMin = Math.min(Math.min(this.theta1, this.theta2), Math.min(this.theta3, this.theta4));
            this.thetaMax = Math.max(Math.max(this.theta1, this.theta2), Math.max(this.theta3, this.theta4));
        }
    }

    private final class Effect3D {
        public double extrusionAngle = 0.0;
        public double extrusionAngleRad = Math.toRadians(this.extrusionAngle);
        public double extrusionThickness = 0.1;
        double vanishConstant = 10.0;
        double vanishAdjustRad = Math.atan(1.0 / this.vanishConstant);
        double vanishAdjustDeg = Math.toDegrees(this.vanishAdjustRad);
        Point2D.Double shadowOffsetPoint = new Point2D.Double();
        Point2D.Double vanishPoint = new Point2D.Double();
        public double startCircumX;
        public double startCircumY;
        public double endCircumX;
        public double endCircumY;
        public double midCircumX;
        public double midCircumY;
        public double startCircumXShadow;
        public double startCircumYShadow;
        public double endCircumXShadow;
        public double endCircumYShadow;

        Effect3D() {
        }

        public void setExtrusionThickness(double length) {
            this.extrusionThickness = length;
        }

        private double getExtrusionThickness() {
            return this.extrusionThickness;
        }

        public void setPerspectiveDistance(double vanishingConstant) {
            if (vanishingConstant >= 1.0) {
                this.vanishConstant = vanishingConstant;
            }
            this.setVanishAdjust();
        }

        public void setVanishAdjust() {
            this.vanishAdjustRad = Math.atan(1.0 / this.vanishConstant);
            this.vanishAdjustDeg = Math.toDegrees(this.vanishAdjustRad);
        }

        public void setExtrusionAngle(double extrusionAngle) {
            this.extrusionAngle = extrusionAngle;
            this.extrusionAngleRad = Math.toRadians(this.extrusionAngle);
        }

        public double getExtrusionAngle() {
            return this.extrusionAngle;
        }

        public double getExtrusionAngleRad() {
            return this.extrusionAngleRad;
        }

        public double getShadowStartAngle() {
            return PieChart.this.getNormalizedAngle(this.extrusionAngle - 90.0 + this.vanishAdjustDeg);
        }

        public double getShadowEndAngle() {
            return PieChart.this.getNormalizedAngle(this.extrusionAngle + 90.0 - this.vanishAdjustDeg);
        }

        private boolean outShadow(double angle) {
            return !this.inShadow(angle);
        }

        public boolean inShadow(double angle) {
            double endShadow;
            double startShadow = this.getShadowStartAngle();
            if (startShadow > (endShadow = this.getShadowEndAngle())) {
                if (angle > startShadow) {
                    return true;
                }
                return angle < endShadow;
            }
            return angle > startShadow && angle < endShadow;
        }

        public boolean inOutShadow(double angleStart, double angleEnd) {
            return this.inShadow(angleStart) && this.outShadow(angleEnd);
        }

        public boolean outInShadow(double angleStart, double angleEnd) {
            return this.outShadow(angleStart) && this.inShadow(angleEnd);
        }

        public boolean outOutShadow(double angleStart, double angleEnd) {
            return this.outShadow(angleStart) && this.outShadow(angleEnd);
        }

        public boolean oneSliceShadow(double angleStart, double angleEnd, double delta) {
            if (this.outShadow(angleStart) && this.outShadow(angleEnd)) {
                double effectiveShadowStart = this.getShadowStartAngle();
                if (angleStart > this.getShadowStartAngle()) {
                    effectiveShadowStart += 360.0;
                }
                if (angleStart + delta > effectiveShadowStart) {
                    return true;
                }
            }
            return false;
        }

        public boolean inInOutShadow(double angleStart, double angleEnd, double angleMid) {
            return this.inShadow(angleStart) && this.inShadow(angleEnd) && this.outShadow(angleMid);
        }

        public Point2D.Double getShadowOffset() {
            boolean testget = false;
            double shadowRadius = PieChart.this.PieRadius;
            if (testget) {
                System.out.println("shadowoffset pieRadius " + shadowRadius + " et " + this.extrusionThickness);
            }
            double temp = shadowRadius * this.extrusionThickness;
            this.shadowOffsetPoint.x = Math.cos(this.extrusionAngleRad) * temp;
            this.shadowOffsetPoint.y = -Math.sin(this.extrusionAngleRad) * temp;
            if (testget) {
                System.out.println("shadowoffset (" + this.shadowOffsetPoint.x + ", " + this.shadowOffsetPoint.y + ")");
            }
            return this.shadowOffsetPoint;
        }

        public Point2D.Double getShadowOffsetNormalized() {
            Point2D.Double shadowOffsetNormalized = new Point2D.Double();
            shadowOffsetNormalized = this.getShadowOffset();
            shadowOffsetNormalized.x /= PieChart.this.PieRadius;
            shadowOffsetNormalized.y /= PieChart.this.PieRadius;
            return shadowOffsetNormalized;
        }

        public void computeCircumference() {
            double shadowStartRad = Math.toRadians(this.getShadowStartAngle());
            double shadowEndRad = Math.toRadians(this.getShadowEndAngle());
            double shadowMidRad = this.extrusionAngleRad;
            double centerX = (double)PieChart.this.XOffset + (double)PieChart.this.CircumLabelWidthOffsetInt + PieChart.this.PieRadius;
            double centerY = (double)PieChart.this.YOffset + (double)PieChart.this.CircumLabelHeightOffsetInt + PieChart.this.PieRadius;
            this.startCircumX = Math.cos(shadowStartRad) * PieChart.this.PieRadius + centerX;
            this.startCircumY = -Math.sin(shadowStartRad) * PieChart.this.PieRadius + centerY;
            this.endCircumX = Math.cos(shadowEndRad) * PieChart.this.PieRadius + centerX;
            this.endCircumY = -Math.sin(shadowEndRad) * PieChart.this.PieRadius + centerY;
            this.midCircumX = Math.cos(shadowMidRad) * PieChart.this.PieRadius + centerX;
            this.midCircumY = -Math.sin(shadowMidRad) * PieChart.this.PieRadius + centerY;
        }

        public void computeShadowCircumference() {
            this.getShadowOffset();
            double shadowRadius = this.getShadowDiameter() / 2.0;
            double centerX = (double)(PieChart.this.XOffset + PieChart.this.CircumLabelWidthOffsetInt) + PieChart.this.PieRadius + this.shadowOffsetPoint.x;
            double centerY = (double)(PieChart.this.YOffset + PieChart.this.CircumLabelHeightOffsetInt) + PieChart.this.PieRadius + this.shadowOffsetPoint.y;
            double shadowStartRad = Math.toRadians(this.getShadowStartAngle());
            double shadowEndRad = Math.toRadians(this.getShadowEndAngle());
            this.startCircumXShadow = Math.cos(shadowStartRad) * shadowRadius + centerX;
            this.startCircumYShadow = -Math.sin(shadowStartRad) * shadowRadius + centerY;
            this.endCircumXShadow = Math.cos(shadowEndRad) * shadowRadius + centerX;
            this.endCircumYShadow = -Math.sin(shadowEndRad) * shadowRadius + centerY;
        }

        double getVanishOffsetX() {
            double vanishOffsetX = Math.cos(this.extrusionAngleRad) * PieChart.this.PieRadius * this.vanishConstant;
            return vanishOffsetX;
        }

        double getVanishOffsetY() {
            double vanishOffsetY = -Math.sin(this.extrusionAngleRad) * PieChart.this.PieRadius * this.vanishConstant;
            return vanishOffsetY;
        }

        public Point2D.Double getVanishPoint() {
            double vanishOffsetX = Math.cos(this.extrusionAngleRad) * PieChart.this.PieRadius;
            double vanishOffsetY = -Math.sin(this.extrusionAngleRad) * PieChart.this.PieRadius;
            this.vanishPoint.x = this.midCircumX + this.getVanishOffsetX();
            this.vanishPoint.y = this.midCircumY + this.getVanishOffsetY();
            return this.vanishPoint;
        }

        public double getVanishLength() {
            double x = this.getVanishOffsetX();
            double y = this.getVanishOffsetY();
            return Math.sqrt(x * x + y * y);
        }

        public double getShadowDiameter() {
            double extrusionThicknessPixels = PieChart.this.PieRadius * this.extrusionThickness;
            double vLength = this.getVanishLength();
            return (vLength - extrusionThicknessPixels) / vLength * (double)PieChart.this.PieDiameter;
        }

        public boolean isShadow(double angleStartNM, double angleEndNM, double deltaAngle) {
            double angleMidNM = PieChart.this.getNormalizedAngle(angleStartNM + deltaAngle / 2.0);
            if (PieChart.this.E3D.oneSliceShadow(angleStartNM, angleEndNM, deltaAngle)) {
                return true;
            }
            return PieChart.this.E3D.inShadow(angleStartNM) || PieChart.this.E3D.inShadow(angleEndNM) || PieChart.this.E3D.inShadow(angleMidNM);
        }
    }

    private final class StoredLayout {
        public PieLayout pl;
        public boolean isMulti;
        public String label;
        public Vector SliceLabelLines;
        public boolean interiorLabel;

        private StoredLayout() {
        }
    }

    private final class PieLayout {
        double x1;
        double y1;
        double x2;
        double y2;
        double score = -1.0;
        double separationTop;
        double separationBottom;
        double separationTopEvaluate;
        double separationBottomEvaluate;
        final double almostZero = 0.001;
        public double labelWidthNormalized;
        public double labelHeightNormalized;
        public double x_cir;
        public double y_cir;
        double angleMidRad;

        public double getX() {
            return this.x1;
        }

        public double getY() {
            return this.y1;
        }

        public double getWidth() {
            return this.x2 - this.x1;
        }

        public double getHeight() {
            return this.y2 - this.y1;
        }

        public double getXTr() {
            return this.x1 + 1.0;
        }

        public double getYTr() {
            return 1.0 - this.y2;
        }

        private void offsetCircumference(double angleDeltaRad) {
            System.out.println("");
            System.out.println("  offsetCircumference ");
            double y = Math.sin(angleDeltaRad);
            double x = Math.cos(angleDeltaRad);
            double xdelta = x - this.x_cir;
            double ydelta = y - this.y_cir;
            System.out.println("xdelta " + xdelta);
            System.out.println("ydelta " + ydelta);
            this.x1 += xdelta;
            this.y1 += ydelta;
        }

        private void placeCircumference(double startAngle, double deltaAngle, double labelWidthNormalized, double labelHeightNormalized) {
            double angleMid;
            double xcircumfPoint;
            boolean debug = false;
            this.labelWidthNormalized = labelWidthNormalized;
            this.labelHeightNormalized = labelHeightNormalized;
            if (debug) {
                System.out.println("");
                System.out.println("  placeCircumference " + startAngle + " " + deltaAngle);
                System.out.println("  placeCircumference " + labelWidthNormalized + " " + labelHeightNormalized);
            }
            double angleStartRad = Math.toRadians(startAngle);
            double angleDeltaRad = Math.toRadians(deltaAngle);
            this.angleMidRad = angleStartRad + angleDeltaRad / 2.0;
            double ycircumfPoint = Math.sin(this.angleMidRad);
            this.x_cir = xcircumfPoint = Math.cos(this.angleMidRad);
            this.y_cir = ycircumfPoint;
            double ycircumfPointOuter = ycircumfPoint;
            double xcircumfPointOuter = xcircumfPoint;
            xcircumfPoint *= 1.0 + labelWidthNormalized * 0.65;
            ycircumfPoint *= 1.0 + labelHeightNormalized * 0.9;
            xcircumfPointOuter *= 1.0 + labelWidthNormalized * 0.9;
            ycircumfPointOuter *= 1.0 + labelHeightNormalized * 0.9;
            PieStyleDesc cfr_ignored_0 = PieChart.this.StyleDesc;
            if (PieChart.this.StyleDesc.getStyleType() != 0 && PieChart.this.E3D.inShadow(angleMid = startAngle + deltaAngle / 2.0)) {
                Point2D.Double shadowOffset = PieChart.this.E3D.getShadowOffsetNormalized();
                xcircumfPoint += shadowOffset.x;
                ycircumfPoint -= shadowOffset.y;
            }
            this.x1 = xcircumfPoint;
            this.x1 = xcircumfPoint + labelHeightNormalized * 0.1;
            this.y1 = ycircumfPoint + labelHeightNormalized * 0.65;
            this.x2 = this.x1;
            this.y2 = this.y1;
            if (PieChart.this.xMinTextNormalized > this.x1) {
                PieChart.this.xMinTextNormalized = this.x1;
            }
            if (PieChart.this.yMinTextNormalized > this.y1) {
                PieChart.this.yMinTextNormalized = this.y1;
            }
            if (PieChart.this.xMaxTextNormalized < this.x1) {
                PieChart.this.xMaxTextNormalized = this.x1;
            }
            if (PieChart.this.yMaxTextNormalized < this.y1) {
                PieChart.this.yMaxTextNormalized = this.y1;
            }
            if (PieChart.this.xMinNormalized > xcircumfPointOuter) {
                PieChart.this.xMinNormalized = xcircumfPointOuter;
            }
            if (PieChart.this.yMinNormalized > ycircumfPointOuter) {
                PieChart.this.yMinNormalized = ycircumfPointOuter;
            }
            if (PieChart.this.xMaxNormalized < xcircumfPointOuter) {
                PieChart.this.xMaxNormalized = xcircumfPointOuter;
            }
            if (PieChart.this.yMaxNormalized < ycircumfPointOuter) {
                PieChart.this.yMaxNormalized = ycircumfPointOuter;
            }
        }

        public int getQuadDistance(double angle1, double angle2) {
            int n2;
            int n1 = PieChart.this.getQuadNumber(angle1);
            if (n1 == (n2 = PieChart.this.getQuadNumber(angle2))) {
                return 0;
            }
            if (Math.abs(n1 - n2) == 1) {
                return 1;
            }
            if (n1 == 4 && n2 == 1) {
                return 1;
            }
            if (n1 == 1 && n2 == 4) {
                return 1;
            }
            return 2;
        }

        public boolean deriveRect360(double angleStart, double angleIncrement, double rectWidth, double rectHeight) {
            boolean fits = false;
            double angleEnd = angleStart + angleIncrement;
            angleEnd = PieChart.this.getNormalizedAngle(angleEnd);
            angleStart = PieChart.this.getNormalizedAngle(angleStart);
            boolean test = false;
            double angleStartRad = Math.toRadians(angleStart);
            double angleEndRad = Math.toRadians(angleEnd);
            if (angleIncrement >= 360.0) {
                double yCenter = 0.0;
                this.y1 = yCenter - rectHeight / 2.0;
                this.y2 = this.y1 + rectHeight;
                this.x1 = -this.getCircleIntersect(this.y2);
                this.x2 = -this.x1;
                return rectWidth < this.x2 - this.x1;
            }
            if (PieChart.this.openTopHemisphere(angleStart, angleEnd)) {
                double yCenter = 0.4;
                this.y1 = yCenter - rectHeight / 2.0;
                this.y2 = this.y1 + rectHeight;
                this.x1 = -this.getCircleIntersect(this.y2);
                this.x2 = -this.x1;
            } else if (PieChart.this.openBottomHemisphere(angleStart, angleEnd)) {
                double yCenter = -0.4;
                this.y1 = yCenter - rectHeight / 2.0;
                this.y2 = this.y1 + rectHeight;
                this.x1 = -this.getCircleIntersect(this.y1);
                this.x2 = -this.x1;
            } else {
                int delta = 15;
                if (angleStart > (double)(90 - delta) && angleStart < (double)(90 + delta) && angleEnd > (double)(270 - delta) && angleEnd < (double)(270 + delta)) {
                    double yCenter = 0.0;
                    this.y1 = yCenter - rectHeight / 2.0;
                    this.y2 = this.y1 + rectHeight;
                    this.x1 = -this.getCircleIntersect(this.y1);
                    this.x2 = 0.0;
                    return rectWidth < this.x2 - this.x1;
                }
                if (angleStart > (double)(270 - delta) && angleStart < (double)(270 + delta) && angleEnd > (double)(90 - delta) && angleEnd < (double)(90 + delta)) {
                    double yCenter = 0.0;
                    this.y1 = yCenter - rectHeight / 2.0;
                    this.y2 = this.y1 + rectHeight;
                    this.x1 = 0.0;
                    this.x2 = this.getCircleIntersect(this.y2);
                    return rectWidth < this.x2 - this.x1;
                }
                if (angleStart < 180.0) {
                    double topDegrees = 180.0 - angleStart;
                    double bottomDegrees = angleEnd - 180.0;
                    if (topDegrees > bottomDegrees) {
                        double yCenter = 0.4;
                        this.y1 = yCenter - rectHeight / 2.0;
                        this.y2 = this.y1 + rectHeight;
                        this.x1 = -this.getCircleIntersect(this.y2);
                        this.x2 = Math.min(this.getXLineIntersect(this.y1, angleStartRad), this.getCircleIntersect(this.y2));
                    } else {
                        double yCenter = -0.4;
                        this.y1 = yCenter - rectHeight / 2.0;
                        this.y2 = this.y1 + rectHeight;
                        this.x1 = -this.getCircleIntersect(this.y1);
                        this.x2 = Math.min(this.getXLineIntersect(this.y2, angleEndRad), this.getCircleIntersect(this.y1));
                    }
                } else {
                    double topDegrees = angleEnd;
                    double bottomDegrees = 360.0 - angleStart;
                    if (topDegrees > bottomDegrees) {
                        double yCenter = 0.4;
                        this.y1 = yCenter - rectHeight / 2.0;
                        this.y2 = this.y1 + rectHeight;
                        this.x1 = Math.max(this.getXLineIntersect(this.y1, angleEndRad), -this.getCircleIntersect(this.y2));
                        this.x2 = this.getCircleIntersect(this.y2);
                    } else {
                        double yCenter = -0.4;
                        this.y1 = yCenter - rectHeight / 2.0;
                        this.y2 = this.y1 + rectHeight;
                        this.x1 = Math.max(this.getXLineIntersect(this.y2, angleStartRad), -this.getCircleIntersect(this.y1));
                        this.x2 = this.getCircleIntersect(this.y1);
                    }
                }
            }
            return rectWidth < this.x2 - this.x1;
        }

        public boolean deriveRect180(double angleStart, double angleIncrement, double rectWidth, double rectHeight, Vector SliceLabelLines) {
            boolean fits = false;
            double angleEnd = angleStart + angleIncrement;
            angleEnd = PieChart.this.getNormalizedAngle(angleEnd);
            angleStart = PieChart.this.getNormalizedAngle(angleStart);
            double angleEndMirror = angleEnd;
            double angleStartMirror = angleStart;
            double threshHold = 77.0;
            boolean mirrorX = false;
            boolean mirrorY = false;
            double angleStartRad = 0.0;
            double angleEndRad = 0.0;
            PieChart.this.test = false;
            if (PieChart.this.inQuad1(angleStart) && PieChart.this.inQuad2(angleEnd) || PieChart.this.inQuad4(angleStart) && PieChart.this.inQuad1(angleEnd) || PieChart.this.inQuad4(angleStart) && PieChart.this.inQuad2(angleEnd)) {
                angleStartRad = Math.toRadians(angleStart);
                angleEndRad = Math.toRadians(angleEnd);
            } else if (PieChart.this.inQuad3(angleStart) && PieChart.this.inQuad4(angleEnd) || PieChart.this.inQuad3(angleStart) && PieChart.this.inQuad1(angleEnd)) {
                angleStartRad = this.mirrorAngleXAxis(angleEnd);
                angleEndRad = this.mirrorAngleXAxis(angleStart);
                mirrorX = true;
            } else if (PieChart.this.inQuad1(angleStart) && PieChart.this.inQuad3(angleEnd) || PieChart.this.inQuad2(angleStart) && PieChart.this.inQuad3(angleEnd)) {
                mirrorY = true;
                angleStartRad = this.mirrorAngleYAxis(angleEnd);
                angleEndRad = this.mirrorAngleYAxis(angleStart);
            } else if (PieChart.this.inQuad2(angleStart) && PieChart.this.inQuad4(angleEnd)) {
                angleStartRad = this.mirrorAngleXYAxis(angleStart);
                angleEndRad = this.mirrorAngleXYAxis(angleEnd);
                mirrorY = true;
                mirrorX = true;
            }
            fits = this.straddleQuadLayout(angleStartRad, angleEndRad, rectWidth, rectHeight, 0.0, mirrorX, SliceLabelLines);
            if (this.score >= 0.0) {
                this.improveScoreIterate(angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            }
            if (mirrorY || mirrorX) {
                if (mirrorY && mirrorX) {
                    this.mirrorCoordXYAxis();
                } else if (mirrorY) {
                    this.mirrorCoordYAxis();
                } else if (mirrorX) {
                    this.mirrorCoordXAxis();
                }
            }
            return fits;
        }

        private boolean straddleQuadLayout(double angleStartRad, double angleEndRad, double rectWidth, double rectHeight, double threshHold, boolean mirrorX, Vector SliceLabelLines) {
            double ytopright;
            boolean straddleTest = false;
            if (straddleTest) {
                System.out.println("");
                System.out.println("straddleQuad start/end  " + Math.toDegrees(angleStartRad) + "," + Math.toDegrees(angleEndRad) + " @@@");
            }
            double yCenter = (Math.sin(angleStartRad) + Math.sin(angleEndRad)) / 2.0;
            double yAngleStart = Math.sin(angleStartRad);
            double yAngleEnd = Math.sin(angleEndRad);
            this.y1 = yCenter - rectHeight / 2.0;
            this.y2 = this.y1 + rectHeight;
            double bottomLeftEdge = this.y1 < 0.0 ? this.getLeftEdge2(this.y1, angleStartRad) : this.getLeftEdge2(this.y1, angleEndRad);
            double topLeftEdge = this.y2 < 0.0 ? this.getLeftEdge2(this.y2, angleStartRad) : this.getLeftEdge2(this.y2, angleEndRad);
            this.x1 = Math.max(bottomLeftEdge, topLeftEdge);
            this.x2 = Math.min(this.getRightEdge2(this.y1, angleStartRad), this.getRightEdge2(this.y2, angleStartRad));
            if (straddleTest) {
                System.out.println("StraddleQuad y1/y2/x1/x2 (" + this.y1 + "," + this.y2 + "," + this.x1 + "," + this.x2 + ")");
            }
            this.score = this.computeScore(this.x1, this.x2, this.y1, this.y2, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            this.separationTop = this.separationTopEvaluate;
            this.separationBottom = this.separationBottomEvaluate;
            if (straddleTest) {
                System.out.println("StraddleQuad sep " + this.separationTop + " " + this.separationBottom);
                System.out.println("* initial score is " + this.score);
            }
            if (this.score >= 0.0) {
                return true;
            }
            double ytopleft = this.getCircleIntersect(this.x1);
            double y2b = Math.min(ytopleft, ytopright = this.getCircleIntersect(this.x2));
            double y1b = y2b - rectHeight;
            if (y1b >= -1.0 && y2b < 1.0) {
                this.assignScore(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            y2b = Math.max(yAngleStart, yAngleEnd) + rectHeight / 2.0;
            y1b = y2b - rectHeight;
            if (y1b >= -1.0 && y2b < 1.0) {
                this.assignScore(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            y2b = Math.min(yAngleStart, yAngleEnd) + rectHeight / 2.0;
            y1b = y2b - rectHeight;
            if (y1b >= -1.0 && y2b < 1.0) {
                this.assignScore(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            y1b = Math.max(yAngleStart, yAngleEnd);
            y2b = y1b + rectHeight;
            if (y1b >= -1.0 && y2b < 1.0) {
                this.assignScore(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            y1b = Math.min(yAngleStart, yAngleEnd);
            y2b = y1b + rectHeight;
            if (y1b >= -1.0 && y2b < 1.0) {
                this.assignScore(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            }
            if (straddleTest) {
                System.out.println("final score is " + this.score);
                System.out.println("y1 y2 " + this.y1 + " " + this.y2);
                System.out.println("x1 x2 " + this.x1 + " " + this.x2);
            }
            if (this.score >= 0.0) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                return true;
            }
            return false;
        }

        void assignScore(double y1b, double y2b, double angleStartRad, double angleEndRad, double rectWidth, double rectHeight, Vector SliceLabelLines, boolean mirrorX) {
            double x2b;
            double x1b = Math.max(this.getLeftEdge2(y1b, angleEndRad), this.getLeftEdge2(y2b, angleEndRad));
            double currentScore = this.computeScore(x1b, x2b = Math.min(this.getRightEdge2(y1b, angleStartRad), this.getRightEdge2(y2b, angleStartRad)), y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (currentScore > this.score) {
                this.score = currentScore;
                this.x1 = x1b;
                this.x2 = x2b;
                this.y1 = y1b;
                this.y2 = y2b;
            }
        }

        void computeRectXCoords(double y1a, double y2a, double angleStartRad, double angleEndRad) {
            double x1a = this.getLeftEdge(y1a, y2a, angleEndRad);
            double x2a = this.getRightEdge(y1a, y2a, angleStartRad);
            if (x2a - x1a > this.x2 - this.x1) {
                this.x1 = x1a;
                this.x2 = x2a;
                this.y1 = y1a;
                this.y2 = y2a;
            }
        }

        void assign(double x1b, double x2b, double y1b, double y2b) {
            this.x1 = x1b;
            this.x2 = x2b;
            this.y1 = y1b;
            this.y2 = y2b;
        }

        double getLeftEdge(double y1p, double y2p, double angleEndRad) {
            if (y2p > 1.0) {
                return 0.0;
            }
            if (y1p < 0.0) {
                return 0.0;
            }
            double x1bottomLine = this.getXLineIntersect(y1p, angleEndRad);
            double x1topLine = this.getXLineIntersect(y2p, angleEndRad);
            double x1top = -this.getCircleIntersect(y2p);
            double x1temp = Math.max(x1bottomLine, x1top);
            x1temp = Math.max(x1topLine, x1temp);
            return x1temp;
        }

        double getRightEdge(double y1p, double y2p, double angleStartRad) {
            double x2top;
            if (y1p < 0.0) {
                return 0.0;
            }
            if (y2p > 1.0) {
                return 0.0;
            }
            double x2bottomLine = this.getXLineIntersect(y1p, angleStartRad);
            double x2topLine = this.getXLineIntersect(y1p, angleStartRad);
            double x2temp = x2top = this.getCircleIntersect(y2p);
            if (x2bottomLine >= 0.0) {
                x2temp = Math.min(x2bottomLine, x2top);
            }
            if (x2topLine >= 0.0) {
                x2temp = Math.min(x2topLine, x2temp);
            }
            return x2temp;
        }

        private void mirrorCoordYAxis() {
            double tempx1 = this.x1;
            this.x1 = -this.x2;
            this.x2 = -tempx1;
        }

        private void mirrorCoordXAxis() {
            double tempy1 = this.y1;
            this.y1 = -this.y2;
            this.y2 = -tempy1;
        }

        private void mirrorCoordXYAxis() {
            this.mirrorCoordXAxis();
            this.mirrorCoordYAxis();
        }

        private double mirrorAngleYAxis(double angleDeg) {
            double result = 180.0 - angleDeg;
            if (result < 0.0) {
                result += 360.0;
            }
            return Math.toRadians(result);
        }

        private double mirrorAngleXAxis(double angleDeg) {
            double result = 360.0 - angleDeg;
            if (result < 0.0) {
                result += 360.0;
            }
            return Math.toRadians(result);
        }

        private double mirrorAngleXYAxis(double angleDeg) {
            double result = 180.0 + angleDeg;
            if (result > 360.0) {
                result -= 360.0;
            }
            return Math.toRadians(result);
        }

        public double getXLineIntersect(double y, double angle) {
            if (Math.abs(Math.sin(angle)) < 0.001) {
                return Math.cos(angle);
            }
            double x = y / Math.tan(angle);
            return x;
        }

        public double getYLineIntersect(double x, double angle) {
            if (Math.abs(Math.cos(angle)) < 0.001) {
                return Math.sin(angle);
            }
            double y = x * Math.tan(angle);
            return y;
        }

        public void swapy1y2() {
            double temp = this.y1;
            this.y1 = this.y2;
            this.y2 = temp;
        }

        public boolean deriveRect90(double angleStart, double angleIncrement, double angleNew, double rectWidth, double rectHeight, Vector SliceLabelLines) {
            boolean fits = false;
            double angleEnd = angleStart + angleIncrement;
            angleEnd = PieChart.this.getNormalizedAngle(angleEnd);
            angleStart = PieChart.this.getNormalizedAngle(angleStart);
            angleNew = PieChart.this.getNormalizedAngle(angleNew);
            double angleStartRad = Math.toRadians(angleStart);
            double angleEndRad = Math.toRadians(angleEnd);
            double angleNewRad = Math.toRadians(angleNew);
            boolean mirrorX = false;
            boolean mirrorY = false;
            double Rstart = 0.0;
            double Rend = 0.0;
            if (PieChart.this.inQuad1(angleEnd)) {
                Rstart = angleStartRad;
                Rend = angleEndRad;
                fits = this.place90(angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            } else if (PieChart.this.inQuad3(angleEnd)) {
                mirrorX = true;
                mirrorY = true;
                Rstart = this.mirrorAngleXYAxis(angleStart);
                Rend = this.mirrorAngleXYAxis(angleEnd);
                fits = this.place90(Rstart, Rend, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            } else if (PieChart.this.inQuad2(angleEnd)) {
                mirrorY = true;
                Rstart = this.mirrorAngleYAxis(angleEnd);
                Rend = this.mirrorAngleYAxis(angleStart);
                fits = this.place90(Rstart, Rend, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            } else if (PieChart.this.inQuad4(angleEnd)) {
                mirrorX = true;
                Rstart = this.mirrorAngleXAxis(angleEnd);
                Rend = this.mirrorAngleXAxis(angleStart);
                fits = this.place90(Rstart, Rend, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            }
            if (fits) {
                this.improveScoreIterate(Rstart, Rend, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            }
            if (mirrorY || mirrorX) {
                if (mirrorY && mirrorX) {
                    this.mirrorCoordXYAxis();
                } else if (mirrorY) {
                    this.mirrorCoordYAxis();
                } else if (mirrorX) {
                    this.mirrorCoordXAxis();
                }
            }
            return fits;
        }

        boolean place90(double angleStartRad, double angleEndRad, double rectWidth, double rectHeight, Vector SliceLabelLines, boolean mirrorX) {
            boolean testPlace90 = false;
            double ymax = Math.sin(angleEndRad);
            double ymin = Math.sin(angleStartRad);
            double yCenter = (ymax + ymin) / 2.0;
            this.score = -1.0;
            this.y1 = yCenter - rectHeight / 2.0;
            this.y2 = this.y1 + rectHeight;
            if (Math.abs(this.y1) < 1.0 && Math.abs(this.y2) < 1.0) {
                double bottomLeftEdge = this.y1 < 0.0 ? this.getLeftEdge2(this.y1, angleStartRad) : this.getLeftEdge2(this.y1, angleEndRad);
                double topLeftEdge = this.y2 < 0.0 ? this.getLeftEdge2(this.y2, angleStartRad) : this.getLeftEdge2(this.y2, angleEndRad);
                this.x1 = Math.max(bottomLeftEdge, topLeftEdge);
                this.x2 = Math.min(this.getRightEdge2(this.y1, angleStartRad), this.getRightEdge2(this.y2, angleStartRad));
                this.score = this.computeScore(this.x1, this.x2, this.y1, this.y2, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
            }
            if (this.score >= 0.0) {
                return true;
            }
            yCenter = (ymax + ymin) / 2.0 + rectHeight / 4.0;
            double y1b = yCenter - rectHeight / 2.0;
            double y2b = y1b + rectHeight;
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (this.score >= 0.0) {
                return true;
            }
            yCenter = (ymax + ymin) / 2.0 - rectHeight / 4.0;
            y1b = yCenter - rectHeight / 2.0;
            y2b = y1b + rectHeight;
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (this.score >= 0.0) {
                return true;
            }
            yCenter = (2.0 * ymin + ymax) / 3.0;
            y1b = yCenter - rectHeight / 2.0;
            y2b = y1b + rectHeight;
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (this.score >= 0.0) {
                return true;
            }
            yCenter = (ymin + 2.0 * ymax) / 3.0;
            y1b = yCenter - rectHeight / 2.0;
            y2b = y1b + rectHeight;
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (this.score >= 0.0) {
                return true;
            }
            y2b = Math.max(ymin, ymax) + rectHeight / 2.0;
            y1b = y2b - rectHeight;
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (this.score >= 0.0) {
                return true;
            }
            y2b = Math.min(ymin, ymax) + rectHeight / 2.0;
            y1b = y2b - rectHeight;
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (this.score >= 0.0) {
                return true;
            }
            y1b = ymin;
            y2b = y1b + rectHeight;
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (this.score >= 0.0) {
                return true;
            }
            y2b = ymin;
            y1b = y2b - rectHeight;
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (this.score >= 0.0) {
                return true;
            }
            y1b = ymax;
            y2b = y1b + rectHeight;
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (this.score >= 0.0) {
                return true;
            }
            y2b = ymax;
            y1b = y2b - rectHeight;
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (this.score >= 0.0) {
                return true;
            }
            return this.score >= 0.0;
        }

        void guessY(double y1b, double y2b, double angleStartRad, double angleEndRad, double rectWidth, double rectHeight, Vector SliceLabelLines, boolean mirrorX) {
            double x2b;
            double topLeftEdge;
            double bottomLeftEdge;
            double x1b;
            double score2 = -1.0;
            if (Math.abs(y1b) < 1.0 && Math.abs(y2b) < 1.0 && (score2 = this.computeScore(x1b = Math.max(bottomLeftEdge = y1b < 0.0 ? this.getLeftEdge2(y1b, angleStartRad) : this.getLeftEdge2(y1b, angleEndRad), topLeftEdge = y2b < 0.0 ? this.getLeftEdge2(y2b, angleStartRad) : this.getLeftEdge2(y2b, angleEndRad)), x2b = Math.min(this.getRightEdge2(y1b, angleStartRad), this.getRightEdge2(y2b, angleStartRad)), y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX)) > this.score) {
                this.separationTop = this.separationTopEvaluate;
                this.separationBottom = this.separationBottomEvaluate;
                this.assign(x1b, x2b, y1b, y2b);
                this.score = score2;
            }
        }

        void improveScoreIterate(double angleStartRad, double angleEndRad, double rectWidth, double rectHeight, Vector SliceLabelLines, boolean mirrorX) {
            boolean testImproveScore = false;
            if (testImproveScore) {
                System.out.println();
            }
            if (testImproveScore) {
                System.out.println("*** Improving Score *** ");
            }
            if (testImproveScore) {
                System.out.println();
            }
            double saveScore = this.score;
            this.improveScore(0.9, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            this.improveScore(0.7, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            this.improveScore(0.5, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            this.improveScore(0.3, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
            if (testImproveScore && this.score != saveScore) {
                System.out.println("Improved score " + saveScore + " -> " + this.score);
            }
        }

        void improveScore(double fraction, double angleStartRad, double angleEndRad, double rectWidth, double rectHeight, Vector SliceLabelLines, boolean mirrorX) {
            double difference = (this.separationTop - this.separationBottom) / 2.0;
            boolean testImproveScore = false;
            if (testImproveScore) {
                System.out.println("sep " + this.separationTop + " " + this.separationBottom);
            }
            if (testImproveScore) {
                System.out.println("difference " + difference);
            }
            double saveScore = this.score;
            double y1b = this.y1 + (difference *= fraction);
            double y2b = this.y2 + difference;
            if (testImproveScore) {
                System.out.println("improveScore: try y1b, y2b (" + y1b + "," + y2b + ")");
            }
            this.guessY(y1b, y2b, angleStartRad, angleEndRad, rectWidth, rectHeight, SliceLabelLines, mirrorX);
        }

        double computeScore(double x1, double x2, double y1, double y2, double angleStartRad, double angleEndRad, double rectWidth, double rectHeight, Vector SliceLabelLines, boolean mirrorX) {
            double x2Right;
            double x2Left;
            double x1Right;
            double x1Left;
            double angleStartDeg = Math.toDegrees(angleStartRad);
            double angleEndDeg = Math.toDegrees(angleEndRad);
            double Ymin = -1.0;
            double Ymax = 1.0;
            if (angleStartDeg < 90.0 || angleStartDeg >= 270.0) {
                Ymin = Math.min(0.0, Math.sin(angleStartRad));
            }
            if (angleEndDeg < 90.0 || angleEndDeg >= 270.0) {
                Ymax = Math.max(0.0, Math.sin(angleEndRad));
            }
            if (y1 < Ymin) {
                return -1.0;
            }
            if (y2 < Ymin) {
                return -1.0;
            }
            if (y1 > Ymax) {
                return -1.0;
            }
            if (y2 > Ymax) {
                return -1.0;
            }
            boolean currentLabelWidth = false;
            boolean testcomputeScore = false;
            if (testcomputeScore) {
                System.out.println();
                System.out.println("compute score " + angleStartDeg + " % " + angleEndDeg);
                System.out.println("x1 x2 y1 y2 " + x1 + " " + x2 + " " + y1 + " " + y2);
                if (PieChart.this.inQuad1(angleStartDeg)) {
                    System.out.print("Start Q1 ");
                } else if (PieChart.this.inQuad2(angleStartDeg)) {
                    System.out.print("Start Q2 ");
                } else if (PieChart.this.inQuad3(angleStartDeg)) {
                    System.out.print("Start Q3 ");
                } else if (PieChart.this.inQuad4(angleStartDeg)) {
                    System.out.print("Start Q4 ");
                }
                if (PieChart.this.inQuad1(angleEndDeg)) {
                    System.out.println("End Q1");
                } else if (PieChart.this.inQuad2(angleEndDeg)) {
                    System.out.println("End Q2");
                } else if (PieChart.this.inQuad3(angleEndDeg)) {
                    System.out.println("End Q3");
                } else if (PieChart.this.inQuad4(angleEndDeg)) {
                    System.out.println("End Q4 ");
                }
            }
            if (testcomputeScore) {
                System.out.println();
                System.out.println("computeScore: " + Math.toDegrees(angleStartRad) + ", " + Math.toDegrees(angleEndRad) + "| @@@");
            }
            if (SliceLabelLines == null) {
                double xCenter = (x1 + x2) / 2.0;
                x1Left = xCenter - rectWidth / 2.0;
                x1Right = xCenter + rectWidth / 2.0;
                x2Left = x1Left;
                x2Right = x1Right;
            } else {
                String sBottom;
                String sTop;
                int lastIndex = SliceLabelLines.size() - 1;
                if (!mirrorX) {
                    sTop = (String)SliceLabelLines.elementAt(0);
                    sBottom = (String)SliceLabelLines.elementAt(lastIndex);
                } else {
                    sTop = (String)SliceLabelLines.elementAt(lastIndex);
                    sBottom = (String)SliceLabelLines.elementAt(0);
                }
                double w0 = (double)PieChart.this.fontmet.stringWidth(sTop) / PieChart.this.PieRadius;
                double w1 = (double)PieChart.this.fontmet.stringWidth(sBottom) / PieChart.this.PieRadius;
                double xCenter = (x1 + x2) / 2.0;
                x1Left = xCenter - w0 / 2.0;
                x1Right = xCenter + w0 / 2.0;
                x2Left = xCenter - w1 / 2.0;
                x2Right = xCenter + w1 / 2.0;
            }
            if (testcomputeScore) {
                System.out.println(" x1  " + x1 + " x2 " + x2);
                System.out.println(" y1  " + y1 + " y2 " + y2);
                System.out.println(" " + x1Left + " " + x1Right + " " + x2Left + " " + x2Right);
            }
            double XRightBottom = this.getCircleIntersect(y1);
            double XRightBottomDelta = 0.0;
            double YRightBottom = -this.getCircleIntersect(x1Right);
            double YRightBottomDelta = 0.0;
            double XLeftBottom = -XRightBottom;
            double XLeftBottomDelta = 0.0;
            double YLeftBottom = -this.getCircleIntersect(x1Left);
            double YLeftBottomDelta = 0.0;
            double XRightTop = this.getCircleIntersect(y2);
            double XRightTopDelta = 0.0;
            double YRightTop = this.getCircleIntersect(x2Right);
            double YRightTopDelta = 0.0;
            double XLeftTop = -XRightTop;
            double XLeftTopDelta = 0.0;
            double YLeftTop = this.getCircleIntersect(x2Left);
            double YLeftTopDelta = 0.0;
            if (PieChart.this.inQuad1(angleStartDeg)) {
                XRightBottom = this.getRightEdge2(y1, angleStartRad);
                YRightBottom = this.getBottomEdge2(x1Right, angleStartRad);
                YLeftBottom = this.getBottomEdge2(x1Left, angleStartRad);
            } else if (PieChart.this.inQuad4(angleStartDeg)) {
                YLeftBottom = this.getBottomEdge2(x1Left, angleStartRad);
                XLeftBottom = this.getLeftEdge2(y1, angleStartRad);
            }
            if (PieChart.this.inQuad1(angleEndDeg) || PieChart.this.inQuad4(angleEndDeg)) {
                if (y1 > 0.0) {
                    XLeftBottom = this.getLeftEdge2(y1, angleEndRad);
                }
                if (y2 > 0.0) {
                    XLeftTop = this.getLeftEdge2(y2, angleEndRad);
                }
                XLeftTop = this.getLeftEdge2(y2, angleEndRad);
                YLeftTop = this.getTopEdge2(x2Left, angleEndRad);
            } else if (PieChart.this.inQuad2(angleEndDeg) || PieChart.this.inQuad3(angleEndDeg)) {
                if (!PieChart.this.inQuad4(angleStartDeg)) {
                    XLeftBottom = this.getLeftEdge2(y1, angleEndRad);
                }
                if (x1Right <= 0.0) {
                    YRightBottom = this.getBottomEdge2(x1Right, angleEndRad);
                }
                if (x1Left <= 0.0) {
                    YLeftBottom = this.getBottomEdge2(x1Left, angleEndRad);
                }
                if (y2 > 0.0) {
                    XLeftTop = this.getLeftEdge2(y2, angleEndRad);
                }
                if (y1 > 0.0) {
                    XLeftBottom = this.getLeftEdge2(y1, angleEndRad);
                }
            } else {
                System.out.println("*** NO QUAD angle End *** ");
            }
            if (testcomputeScore) {
                System.out.println("XRightBottom " + XRightBottom);
                System.out.println("YRightBottom " + YRightBottom);
                System.out.println("XLeftBottom " + XLeftBottom);
                System.out.println("YLeftBottom " + YLeftBottom);
                System.out.println("XRightTop " + XRightTop);
                System.out.println("YRightTop " + YRightTop);
                System.out.println("XLeftTop " + XLeftTop);
                System.out.println("YLeftTop " + YLeftTop);
            }
            XLeftBottomDelta = x1Left - XLeftBottom;
            XRightBottomDelta = XRightBottom - x2Right;
            YLeftBottomDelta = y1 - YLeftBottom;
            YRightBottomDelta = y1 - YRightBottom;
            XLeftTopDelta = x1Left - XLeftTop;
            XRightTopDelta = XRightTop - x2Right;
            YLeftTopDelta = YLeftTop - y2;
            YRightTopDelta = YRightTop - y2;
            if (testcomputeScore) {
                System.out.println("XRightBottomDelta " + XRightBottomDelta);
                System.out.println("XLeftBottomDelta " + XLeftBottomDelta);
                System.out.println("YRightBottomDelta " + YRightBottomDelta);
                System.out.println("YLeftBottomDelta " + YLeftBottomDelta);
                System.out.println("XRightTopDelta " + XRightTopDelta);
                System.out.println("XLeftTopDelta " + XLeftTopDelta);
                System.out.println("YRightTopDelta " + YRightTopDelta);
                System.out.println("YLeftTopDelta " + YLeftTopDelta);
            }
            double XLeftDelta = Math.min(XLeftTopDelta, XLeftBottomDelta);
            double XRightDelta = Math.min(XRightTopDelta, XRightBottomDelta);
            double YBottomDelta = Math.min(YLeftBottomDelta, YRightBottomDelta);
            double YTopDelta = Math.min(YLeftTopDelta, YRightTopDelta);
            double minXDelta = Math.min(XRightDelta, XLeftDelta);
            double minYDelta = Math.min(YTopDelta, YBottomDelta);
            if (PieChart.this.testPlace90) {
                System.out.println("left, right XDelta [" + XLeftDelta + " , " + XRightDelta + "]");
                System.out.println("bottom, top YDelta [" + YBottomDelta + " , " + YTopDelta + "]");
            }
            this.separationTopEvaluate = YTopDelta;
            this.separationBottomEvaluate = YBottomDelta;
            return Math.min(minXDelta, minYDelta);
        }

        double getRightEdge2(double y1, double angleStartRad) {
            double XRightCirc = this.getCircleIntersect(y1);
            double angleStart = Math.toDegrees(angleStartRad);
            if (!(angleStart <= 90.0) || !(angleStart > 0.0)) {
                return XRightCirc;
            }
            double XRightLine = this.getXLineIntersect(y1, angleStartRad);
            if (PieChart.this.test2) {
                System.out.println("XRightCirc " + XRightCirc);
                System.out.println("XRightLine " + XRightLine);
            }
            double XRight = Math.min(XRightCirc, XRightLine);
            return XRight;
        }

        double getCornerIntersect(double x1, double y1, double angle) {
            if (Math.abs(Math.cos(angle)) < 0.001) {
                return 1.0;
            }
            if (Math.abs(Math.sin(angle)) < 0.001) {
                return 1.0;
            }
            double m1 = Math.sin(angle) / Math.cos(angle);
            double m2 = Math.cos(angle) / Math.sin(angle);
            double b = y1 - m2 * x1;
            double line_x = -b / (m2 - m1);
            double line_y = m1 * line_x;
            double distance = Math.abs(x1 - line_x) + Math.abs(y1 - line_y);
            if (PieChart.this.test2) {
                System.out.println("getCornerIntersect " + distance);
            }
            return distance;
        }

        double getLeftCorner(double x1, double y1, double angleEndRad) {
            double XLeftCirc = -this.getCircleIntersect(y1);
            double XLeftLine = this.getXLineIntersect(y1, angleEndRad);
            if (PieChart.this.test2) {
                System.out.println("XLeftLine " + XLeftLine);
            }
            double XLeft = Math.max(XLeftCirc, XLeftLine);
            double distance = this.getCornerIntersect(x1, y1, angleEndRad);
            return XLeft;
        }

        double getCircleIntersect(double y1) {
            double x1 = 0.0;
            x1 = Math.abs(y1) >= 1.0 ? 0.0 : Math.sqrt(1.0 - y1 * y1);
            return x1;
        }

        double getLeftEdge2(double y1, double angleEndRad) {
            double XLeftCirc = -this.getCircleIntersect(y1);
            double XLeftLine = this.getXLineIntersect(y1, angleEndRad);
            if (PieChart.this.test2) {
                System.out.println("XLeftLine " + XLeftLine + " " + XLeftCirc);
            }
            if (XLeftLine == 1.0) {
                return XLeftCirc;
            }
            double XLeft = Math.max(XLeftCirc, XLeftLine);
            return XLeft;
        }

        double getTopEdge2(double x, double angleEndRad) {
            double YTopCirc = this.getCircleIntersect(x);
            double angleEnd = Math.toDegrees(angleEndRad);
            double YTopLine = this.getYLineIntersect(x, angleEndRad);
            double YTop = Math.min(YTopCirc, YTopLine);
            return YTop;
        }

        double getBottomEdge2(double x, double angleStartRad) {
            double YBottomCirc = -this.getCircleIntersect(x);
            double YBottomLine = this.getYLineIntersect(x, angleStartRad);
            double YBottom = Math.max(YBottomCirc, YBottomLine);
            return YBottom;
        }
    }

    private final class ExternalLabelSpace {
        int space_top = 0;
        int space_bottom = 0;
        int space_left = 0;
        int space_right = 0;

        ExternalLabelSpace() {
        }

        public void init() {
        }
    }

    private final class LayoutScore {
        Vector LabelIntExt = new Vector();

        private LayoutScore() {
        }

        protected void dumpScore() {
            System.out.println();
            System.out.println("Internal/External Labeling");
            for (int i = 0; i < this.LabelIntExt.size(); ++i) {
                ScoreDesc s = (ScoreDesc)this.LabelIntExt.elementAt(i);
                s.dumpScoreDesc();
            }
        }

        protected boolean isDuplicateMask(boolean[] mask) {
            for (int i = 0; i < this.LabelIntExt.size(); ++i) {
                ScoreDesc s = (ScoreDesc)this.LabelIntExt.elementAt(i);
                if (!s.equalMask(mask)) continue;
                return true;
            }
            return false;
        }

        protected boolean isZeroMask(boolean[] mask) {
            for (int i = 0; i < mask.length; ++i) {
                if (!mask[i]) continue;
                return false;
            }
            return true;
        }

        protected boolean isAllOnesMask(boolean[] mask) {
            for (int i = 0; i < mask.length; ++i) {
                if (mask[i]) continue;
                return false;
            }
            return true;
        }
    }

    private final class ScoreDesc {
        boolean[] IE;
        int space_top_needed = 0;
        int space_bottom_needed = 0;
        int space_left_needed = 0;
        int space_right_needed = 0;
        int space_top_available = 0;
        int space_bottom_available = 0;
        int space_left_available = 0;
        int space_right_available = 0;

        ScoreDesc() {
        }

        protected void init() {
            this.space_top_available = 0;
            this.space_bottom_available = 0;
            this.space_left_available = 0;
            this.space_right_available = 0;
            this.space_top_needed = 0;
            this.space_bottom_needed = 0;
            this.space_left_needed = 0;
            this.space_right_needed = 0;
        }

        protected boolean equalMask(boolean[] mask) {
            if (this.IE.length != mask.length) {
                return false;
            }
            for (int k = 0; k < mask.length; ++k) {
                if (this.IE[k] == mask[k]) continue;
                return false;
            }
            return true;
        }

        protected void initSpaceNeeded() {
            this.space_top_needed = 0;
            this.space_bottom_needed = 0;
            this.space_left_needed = 0;
            this.space_right_needed = 0;
        }

        protected void setTopSpaceNeeded(int space_top_needed) {
            if (space_top_needed > this.space_top_needed) {
                this.space_top_needed = space_top_needed;
            }
        }

        protected void setBottomSpaceNeeded(int space_bottom_needed) {
            if (space_bottom_needed > this.space_bottom_needed) {
                this.space_bottom_needed = space_bottom_needed;
            }
        }

        protected void setLeftSpaceNeeded(int space_left_needed) {
            if (space_left_needed > this.space_left_needed) {
                this.space_left_needed = space_left_needed;
            }
        }

        protected void setRightSpaceNeeded(int space_right_needed) {
            if (space_right_needed > this.space_right_needed) {
                this.space_right_needed = space_right_needed;
            }
        }

        protected void setTopSpaceAvailable(int space_top_available) {
            this.space_top_available = space_top_available;
        }

        protected void setBottomSpaceAvailable(int space_bottom_available) {
            this.space_bottom_available = space_bottom_available;
        }

        protected void setLeftSpaceAvailable(int space_left_available) {
            this.space_left_available = space_left_available;
        }

        protected void setRightSpaceAvailable(int space_right_available) {
            this.space_right_available = space_right_available;
        }

        protected void setMask(boolean[] mask) {
            this.IE = new boolean[mask.length];
            for (int k = 0; k < mask.length; ++k) {
                this.IE[k] = mask[k];
            }
        }

        void dumpScoreDesc() {
            for (int k = 0; k < this.IE.length; ++k) {
                if (this.IE[k]) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println();
        }

        void dumpScoreDesc(boolean[] mask) {
            boolean testAutoDiameter = true;
            for (int k = 0; k < mask.length; ++k) {
                if (mask[k]) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println();
        }

        boolean enoughYSpace() {
            return this.space_top_available + this.space_bottom_available >= this.space_top_needed + this.space_bottom_needed;
        }

        boolean enoughXSpace() {
            return this.space_left_available + this.space_right_available >= this.space_left_needed + this.space_right_needed;
        }

        protected int getScore() {
            int score = 0;
            for (int k = 0; k < this.IE.length; ++k) {
                if (!this.IE[k]) continue;
                ++score;
            }
            if (score == 0) {
                return score;
            }
            if (this.space_top_available + this.space_bottom_available < this.space_top_needed + this.space_bottom_needed) {
                return -1;
            }
            return score;
        }
    }

    private final class PieSliceLabelLoc {
        public int x = -1;
        public int y = -1;
        public int w = -1;
        public int h = -1;
        int labelHeight = -1;
        int labelWidth = -1;
        int xoffset = 0;
        int yoffset = 0;

        PieSliceLabelLoc() {
        }

        public void drawStringSetLocSize(Graphics2D g2, String label, int x, int y, int labelWidth, int labelHeight) {
            g2.drawString(label, x + this.xoffset, y + this.yoffset);
            this.setLocation(x + this.xoffset, y + this.yoffset - labelHeight);
            this.w = labelWidth;
            this.h = labelHeight;
        }

        public void drawString(Graphics2D g2, String label, int x, int y) {
            g2.drawString(label, x + this.xoffset, y + this.yoffset);
        }

        protected void setLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }

        protected void setSize(int width, int height) {
            this.w = width;
            this.h = height;
        }

        protected boolean contains(int x, int y) {
            int xmax = this.x + this.w;
            int ymax = this.y + this.h;
            return x >= this.x && x <= xmax && y >= this.y && y <= ymax;
        }

        protected void drawLabel(String sliceLabel) {
        }

        PieSliceLabelLoc(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }

    private final class PieSliceLabelOffset {
        PieSliceLabelOffset() {
        }
    }

    private final class PieSliceAngle {
        double startAngle = 0.0;
        double deltaAngle = 0.0;
        double startAngleCirLabel = 0.0;
        double deltaAngleCirLabel = 0.0;
        public String[] imageMap = new String[]{null, null};
        public int[] shadowX;
        public int[] shadowY;
        public double startCircumX;
        public double startCircumY;
        public double startCircumXExtra;
        public double startCircumYExtra;
        public double startCircumXTick;
        public double startCircumYTick;
        public double startCircumXInnerTick;
        public double startCircumYInnerTick;
        public double startCircumXInnerTick2;
        public double startCircumYInnerTick2;
        public double endCircumXTick;
        public double endCircumYTick;
        public double endCircumX;
        public double endCircumY;
        public double endCircumXExtra;
        public double endCircumYExtra;
        public double midCircumShadowX;
        public double midCircumShadowY;

        PieSliceAngle() {
        }

        public void setStartAngle(double startAngle) {
            this.startAngle = startAngle;
        }

        public void setDeltaAngle(double deltaAngle) {
            this.deltaAngle = deltaAngle;
        }
    }

    private final class CrescentAdjust {
        boolean testCrescent = false;
        public int Offset3D_Top = 0;
        public int Offset3D_Bottom = 0;
        public int Offset3D_Right = 0;
        public int Offset3D_Left = 0;
        public int maxHorzSpace_3DoffsetX = 0;
        public int maxVertSpace_3DoffsetY = 0;

        CrescentAdjust() {
        }

        public PieDim setAdjustPieDiameter(PieDim maxSpace) {
            PieDim space = new PieDim();
            PieStyleDesc cfr_ignored_0 = PieChart.this.StyleDesc;
            if (PieChart.this.StyleDesc.getStyleType() == 0) {
                return space;
            }
            double fract = PieChart.this.E3D.getExtrusionThickness() / 2.0;
            double fractX = fract * Math.abs(Math.cos(PieChart.this.E3D.getExtrusionAngleRad()));
            double fractY = fract * Math.abs(Math.sin(PieChart.this.E3D.getExtrusionAngleRad()));
            space.width = (int)Math.round((double)maxSpace.width / (1.0 + fractX));
            space.height = (int)Math.round((double)maxSpace.height / (1.0 + fractY));
            this.maxHorzSpace_3DoffsetX = maxSpace.width - space.width;
            this.maxVertSpace_3DoffsetY = maxSpace.height - space.height;
            if (Math.sin(PieChart.this.E3D.getExtrusionAngleRad()) > 0.0) {
                this.Offset3D_Top = this.maxVertSpace_3DoffsetY;
            } else {
                this.Offset3D_Bottom = this.maxVertSpace_3DoffsetY;
            }
            if (Math.cos(PieChart.this.E3D.getExtrusionAngleRad()) > 0.0) {
                this.Offset3D_Right = this.maxHorzSpace_3DoffsetX;
            } else {
                this.Offset3D_Left = this.maxHorzSpace_3DoffsetX;
            }
            return space;
        }
    }

    private final class PieDim {
        public int width = 0;
        public int height = 0;

        PieDim() {
        }
    }
}

