/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.cache;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.cache.MVHashMap;
import oracle.sdovis.cache.PermCacheGroup;

public class SubRegion
extends MVHashMap {
    private String name;
    private Hashtable groups;
    long memSize;

    public SubRegion(String name) {
        this.name = name;
        this.groups = new Hashtable(37, 0.85f);
    }

    public CacheGroup createNewGroup(String grp, int initialCapacity, boolean pinned) {
        CacheGroup group = null;
        initialCapacity = initialCapacity <= 0 ? 256 : initialCapacity;
        group = pinned ? new PermCacheGroup(grp, initialCapacity, 0.95f) : new CacheGroup(grp, initialCapacity, 0.95f);
        this.groups.put(grp, group);
        return group;
    }

    public void removeGroup(String grp) {
        if (grp == null) {
            return;
        }
        CacheGroup g = (CacheGroup)this.groups.get(grp);
        if (g != null) {
            g.clear();
        }
        this.groups.remove(grp);
    }

    public CacheGroup getGroup(String grp) {
        if (grp == null) {
            return null;
        }
        return (CacheGroup)this.groups.get(grp);
    }

    @Override
    public void clear() {
        Enumeration enumer = this.groups.elements();
        while (enumer.hasMoreElements()) {
            CacheGroup g = (CacheGroup)enumer.nextElement();
            g.clear();
        }
        this.groups.clear();
    }

    public void invalidate() {
        Enumeration enumer = this.groups.elements();
        while (enumer.hasMoreElements()) {
            CacheGroup g = (CacheGroup)enumer.nextElement();
            g.clear();
        }
    }

    public boolean groupExists(String gr) {
        return gr == null ? false : this.groups.containsKey(gr);
    }

    public long getMemorySize() {
        long s = 0L;
        Enumeration enumer = this.groups.elements();
        while (enumer.hasMoreElements()) {
            CacheGroup g = (CacheGroup)enumer.nextElement();
            if (g == null) continue;
            s += g.getMemorySize();
        }
        return s;
    }

    @Override
    public String report(int ntab) {
        String tabs = "";
        for (int i = 0; i < ntab; ++i) {
            tabs = tabs + "\t";
        }
        StringBuffer sb = new StringBuffer(1024);
        sb.append(tabs + "SubRegion " + this.name + ":\n");
        Enumeration enumer = this.groups.elements();
        while (enumer.hasMoreElements()) {
            CacheGroup g = (CacheGroup)enumer.nextElement();
            sb.append(g.report(ntab + 1));
        }
        return sb.toString();
    }
}

