/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.lbs.foi.foiUtil;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.style.MarkerStyleModel;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.stylex.BarChartStyleModel;
import oracle.mapviewer.share.stylex.CollectionStyleModel;
import oracle.mapviewer.share.stylex.PieChartStyleModel;
import oracle.mapviewer.share.stylex.VariablePieChartStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CasedLineHelper;
import oracle.sdovis.HeatMapRenderer;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.MapMaker;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.PDFTTFcache;
import oracle.sdovis.RSBundle;
import oracle.sdovis.Renderer;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.TextLabeler;
import oracle.sdovis.Theme;
import oracle.sdovis.UTFGrid;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.TextStroke;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.stylex.BarChartStyle;
import oracle.sdovis.stylex.BarChartStyleModifiers;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.CollectionStyle;
import oracle.sdovis.stylex.ColorSchemeStyle;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.PieChartStyleModifiers;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.theme.AnnotationTextThemeProducer;
import oracle.sdovis.theme.DynGeomThemeProducer;
import oracle.sdovis.theme.PredGeomThemeProducer;
import oracle.sdovis.theme.ThemeUtils;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.ShapeUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.xdo.generator.graphics2d.XDOGraphics2D;

public class VectorRenderer
implements Renderer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private int wrap_step_x = 0;
    static double[] trys = new double[]{0.5, 0.33333, 0.66666, 0.18, 0.82};

    public void prepare(VisContext vc) {
        Rectangle2D mDeviceView = vc.getDeviceWindow();
        if (vc.getCRArray() == null) {
            vc.setCRArray(new RectArray(111));
        }
        if (vc.getMarkerCRArray() == null) {
            vc.setMarkerCRArray(new RectArray(111));
        }
        if (vc.getRenderedMarkerCRArray() == null) {
            vc.setRenderedMarkerCRArray(new RectArray(111));
        }
        vc.getCRArray().freeAll();
        vc.getMarkerCRArray().freeAll();
        vc.getRenderedMarkerCRArray().freeAll();
        if (vc.getTextStroke() == null) {
            vc.setTextStroke(new TextStroke(new Font("Serif", 0, 12), false, -1.0f, 0.2));
        }
        vc.getTextStroke().setDeviceView(mDeviceView.getMinX(), mDeviceView.getMinY(), mDeviceView.getWidth(), mDeviceView.getHeight());
    }

    private JSDOGeometry buildRectGeom(VisContext vc, double[] mbr) {
        int[] elemInfo = new int[]{1, 1003, 3};
        double[] ordinates = new double[]{mbr[0], mbr[1], mbr[2], mbr[3]};
        JSDOGeometry rectGeom = new JSDOGeometry(2003, vc.getMasterSRID(), Double.NaN, Double.NaN, Double.NaN, elemInfo, ordinates);
        return rectGeom;
    }

    private int getWrapAroundXStep(VisContext vc, Theme t) throws Exception {
        double[] tmpmbr = null;
        if (t.getProducer() instanceof PredGeomThemeProducer) {
            tmpmbr = ((PredGeomThemeProducer)t.getProducer()).getRequestMBR();
        } else if (t.getProducer() instanceof DynGeomThemeProducer) {
            tmpmbr = ((DynGeomThemeProducer)t.getProducer()).getRequestMBR();
        } else {
            throw new Exception("Theme is not supported for wraparound.");
        }
        double[] bounds = new double[4];
        SRS.getSRSBounds(vc.getMasterSRID(), bounds);
        tmpmbr[0] = bounds[0];
        tmpmbr[2] = bounds[2];
        AffineTransform xfm = vc.getAffineXF();
        Rectangle rectBounds = this.buildRectGeom(vc, tmpmbr).createShape(xfm, true).getBounds();
        double minx = rectBounds.getMinX();
        double maxx = rectBounds.getMaxX();
        return (int)(maxx - minx + 0.5);
    }

    private int getValidMapWidth(VisContext vc, Theme t) {
        double[] inmbrValid = null;
        double[] inmbrValid2 = null;
        Rectangle rectBounds = null;
        RectangularShape rectBounds2 = null;
        if (t.getProducer() instanceof PredGeomThemeProducer) {
            inmbrValid = ((PredGeomThemeProducer)t.getProducer()).getRequestMBR();
            inmbrValid2 = ((PredGeomThemeProducer)t.getProducer()).getRequestMBR2();
        }
        if (inmbrValid != null && !Double.isNaN((double)inmbrValid[0])) {
            AffineTransform xfm = vc.getAffineXF();
            rectBounds = this.buildRectGeom(vc, inmbrValid).createShape(xfm, true).getBounds();
            if (inmbrValid2 != null && !Double.isNaN(inmbrValid2[0])) {
                rectBounds2 = this.buildRectGeom(vc, inmbrValid2).createShape(xfm, true).getBounds();
            }
        } else {
            log.warning("wraparound map width on screen error.");
            return 10000;
        }
        double minx = 10000.0;
        double maxx = -10000.0;
        if (rectBounds2 == null) {
            minx = rectBounds.getMinX();
            maxx = rectBounds.getMaxX();
        } else {
            minx = Math.min(rectBounds.getMinX(), rectBounds2.getMinX());
            maxx = Math.max(rectBounds.getMaxX(), rectBounds2.getMaxX());
        }
        return (int)(maxx - minx + 0.5);
    }

    @Override
    public void render(Graphics2D g2, Theme t, VisContext vc) {
        if (vc.isInterrupted()) {
            return;
        }
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        boolean aa = vc.getAntialiasing();
        if (aa) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Rectangle2D qw = vc.getExtendedQueryWindow(t.windowBuffer);
        StyledFeatureI sf = null;
        long t0 = System.currentTimeMillis();
        if (this.isHeatMapTheme(t, vc)) {
            HeatMapRenderer.renderHeatMap(g2, t, vc);
        } else {
            vc.enableMarkerSequence(t.getDecorator().markerSequence);
            vc.resetMarkerSequence();
            String decoRenderStyleName = t.getDecorator().renderStyleName;
            Style decoSty = null;
            if (decoRenderStyleName != null) {
                decoSty = MapMaker.getStyleWithName(decoRenderStyleName, t.getDataSourceName(), vc);
            }
            NsDpHandler nsdp = Theme.getNsdpHandler(vc, t.getDefinition().getName());
            if (vc.getWrapAround()) {
                if (t.getProducer() instanceof PredGeomThemeProducer || t.getProducer() instanceof DynGeomThemeProducer) {
                    try {
                        this.wrap_step_x = this.getWrapAroundXStep(vc, t);
                    }
                    catch (Exception e) {
                        log.severe(e.getMessage());
                    }
                } else {
                    this.wrap_step_x = 0;
                }
            }
            for (int i = 0; i < t.size(); ++i) {
                sf = t.getStyledFeature(i);
                if (sf == null) continue;
                if (decoSty != null) {
                    if (nsdp == null) {
                        sf.setFeatureStyle(decoSty);
                    } else {
                        String featureStyleName = sf.getFeatureStyleName();
                        if (featureStyleName == null || decoRenderStyleName.equalsIgnoreCase(featureStyleName)) {
                            sf.setFeatureStyle(decoSty);
                        }
                    }
                }
                if (!vc.getWrapAround() && !VectorRenderer.visible(sf, qw)) continue;
                if (!t.getDecorator().isClickable()) {
                    VectorRenderer.renderStyledFeature(g2, sf, vc);
                    if (!vc.getWrapAround() || this.wrap_step_x <= 0) continue;
                    int minx = 0;
                    int maxx = 0;
                    if (sf.getGeomType() == 1) {
                        maxx = minx = (int)(sf.getCenterX() + 0.5);
                    } else {
                        minx = (int)(sf.getShape().getBounds().getMinX() + 0.5);
                        maxx = (int)(sf.getShape().getBounds().getMaxX() + 0.5);
                    }
                    int totalShift = 0;
                    for (int rightEdge = maxx - this.wrap_step_x; rightEdge > 0 && this.wrap_step_x > 0; rightEdge -= this.wrap_step_x) {
                        g2.translate(-this.wrap_step_x, 0);
                        totalShift += this.wrap_step_x;
                        VectorRenderer.renderStyledFeature(g2, sf, vc);
                    }
                    g2.translate(totalShift, 0);
                    int leftEdge = minx + this.wrap_step_x;
                    totalShift = 0;
                    while ((double)leftEdge < vc.getDeviceWindow().getMaxX() && this.wrap_step_x > 0) {
                        g2.translate(this.wrap_step_x, 0);
                        totalShift += this.wrap_step_x;
                        VectorRenderer.renderStyledFeature(g2, sf, vc);
                        leftEdge += this.wrap_step_x;
                    }
                    g2.translate(-totalShift, 0);
                    continue;
                }
                try {
                    VectorRenderer.renderStyledFeature(null, sf, vc);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                vc.addLiveFeature(sf);
            }
        }
        long t1 = System.currentTimeMillis();
        log.finer("time to render theme " + t.getName() + " with " + t.size() + " styled features: " + (t1 - t0) + "ms");
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    public void renderUTFGrid(Graphics2D g2, Theme t, VisContext vc, int styOption) {
        if (vc.isInterrupted()) {
            return;
        }
        Rectangle2D qw = vc.getExtendedQueryWindow(t.windowBuffer);
        StyledFeatureI sf = null;
        long t0 = System.currentTimeMillis();
        NsDpHandler nsdp = Theme.getNsdpHandler(vc, t.getDefinition().getName());
        if (vc.getWrapAround()) {
            if (t.getProducer() instanceof PredGeomThemeProducer || t.getProducer() instanceof DynGeomThemeProducer) {
                try {
                    this.wrap_step_x = this.getWrapAroundXStep(vc, t);
                }
                catch (Exception e) {
                    log.severe(e.getMessage());
                }
            } else {
                this.wrap_step_x = 0;
            }
        }
        UTFGrid utfGrid = vc.getUTFGrid();
        utfGrid.init();
        int[] elemInfo = new int[]{1, 1003, 3};
        double[] mbr = new double[]{vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMinY(), vc.getQueryWindow().getMaxX(), vc.getQueryWindow().getMaxY()};
        JGeometry geomRect = new JGeometry(2003, vc.getMasterSRID(), elemInfo, mbr);
        double tol = Math.max((mbr[2] - mbr[0]) / 1000.0, (mbr[2] - mbr[1]) / 1000.0);
        String isGeo = "false";
        if (vc.getSrs().isGeodetic()) {
            isGeo = "true";
        }
        String strNames = null;
        String[] attrArray = null;
        StringBuilder sb = new StringBuilder();
        int utfCount = 1;
        for (int i = 0; i < t.size(); ++i) {
            block21: {
                sf = t.getStyledFeature(i);
                if (sf == null) continue;
                JSDOGeometry geom = sf.getGeometry();
                try {
                    if (!geomRect.anyInteract((JGeometry)geom, tol, isGeo)) {
                    }
                    break block21;
                }
                catch (Exception e) {
                    log.warning("Failed in checking if a styled feature interacts the query window.");
                    log.warning(e.getMessage());
                }
                continue;
            }
            if (!vc.getWrapAround() && !VectorRenderer.visible(sf, qw) || t.getDecorator().isClickable()) continue;
            VectorRenderer.renderStyledFeatureUTFGrid(g2, sf, vc, styOption, utfCount);
            if (utfCount == 1) {
                strNames = foiUtil.getJSONAttrNamesString((Field[])Util.getFeatureAttributes(sf, false));
                if (strNames == null || strNames.trim().length() == 0) {
                    log.warning("Failed to get attribute names from styled features.");
                    break;
                }
                attrArray = Util.convertJSONArrayToStringArray(strNames);
                if (attrArray == null || attrArray.length == 0) {
                    log.warning("Failed to get the attribute names from: " + strNames);
                    break;
                }
            }
            String strVal = foiUtil.getJSONAttrString((Field[])Util.getFeatureAttributes(sf, false));
            String[] valArray = Util.convertJSONArrayToStringArray(strVal);
            if (attrArray == null || valArray == null || attrArray.length != valArray.length) {
                log.warning("The length of the attribute names does not match the values'.");
                break;
            }
            sb.setLength(0);
            sb.append("{\"" + attrArray[0] + "\":\"" + valArray[0] + "\"");
            for (int k = 1; k < attrArray.length; ++k) {
                sb.append(",\"" + attrArray[k] + "\":\"" + valArray[k] + "\"");
            }
            sb.append("}");
            utfGrid.appendKey(utfCount);
            utfGrid.appendKVP(utfCount, sb.toString());
            if (vc.getWrapAround() && this.wrap_step_x > 0) {
                int minx = 0;
                int maxx = 0;
                if (sf.getGeomType() == 1) {
                    maxx = minx = (int)(sf.getCenterX() + 0.5);
                } else {
                    minx = (int)(sf.getShape().getBounds().getMinX() + 0.5);
                    maxx = (int)(sf.getShape().getBounds().getMaxX() + 0.5);
                }
                int totalShift = 0;
                for (int rightEdge = maxx - this.wrap_step_x; rightEdge > 0 && this.wrap_step_x > 0; rightEdge -= this.wrap_step_x) {
                    g2.translate(-this.wrap_step_x, 0);
                    totalShift += this.wrap_step_x;
                    VectorRenderer.renderStyledFeatureUTFGrid(g2, sf, vc, styOption, utfCount);
                }
                g2.translate(totalShift, 0);
                int leftEdge = minx + this.wrap_step_x;
                totalShift = 0;
                while ((double)leftEdge < vc.getDeviceWindow().getMaxX() && this.wrap_step_x > 0) {
                    g2.translate(this.wrap_step_x, 0);
                    totalShift += this.wrap_step_x;
                    VectorRenderer.renderStyledFeatureUTFGrid(g2, sf, vc, styOption, utfCount);
                    leftEdge += this.wrap_step_x;
                }
                g2.translate(-totalShift, 0);
            }
            ++utfCount;
        }
        long t1 = System.currentTimeMillis();
        log.finer("time to render UTFGrid for theme " + t.getName() + " with " + t.size() + " styled features: " + (t1 - t0) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void label(Graphics2D g2, Theme t, VisContext vc) {
        boolean updwl;
        boolean laon;
        boolean loo;
        if (vc.isInterrupted()) {
            return;
        }
        if (t.getDecorator().isClickable()) {
            return;
        }
        if (!t.getDecorator().isRenderLabels()) {
            return;
        }
        if (this.isHeatMapTheme(t, vc)) {
            return;
        }
        vc.setThemeWindowBuffer(t.windowBuffer);
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        boolean taa = vc.getTextAntialiasing();
        if (taa) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        float[] coords = new float[6];
        boolean looDecor = loo = t.getDecorator().noRepetitiveLabel;
        boolean laonDecor = laon = t.getDecorator().labelAlwaysOn;
        boolean updwlDecor = updwl = t.getDecorator().upsideDownLabels;
        Hashtable<String, Integer> segmentLabelHelper = null;
        Integer flag = null;
        if (loo) {
            segmentLabelHelper = new Hashtable<String, Integer>();
            flag = new Integer(1);
        }
        Rectangle2D qw = vc.getExtendedQueryWindow(t.windowBuffer);
        StyledFeatureI sf = null;
        long t0 = System.currentTimeMillis();
        try {
            for (int i = 0; i < t.size(); ++i) {
                sf = t.getStyledFeature(i);
                if (sf == null) continue;
                if (sf.getAnnotationTextLabel() != null) {
                    if (!VectorRenderer.visible(sf, qw)) continue;
                    this.labelStyledFeatureWithAnnotationText(g2, sf, sf.getAnnotationTextLabel(), t.getDecorator().getNoRepetitiveLabel(), t.getDecorator().isLabelAlwaysOn(), vc);
                    continue;
                }
                String label = sf.getLabel();
                if (label == null || label.length() == 0 || (loo = looDecor) && segmentLabelHelper.get(label) != null || !VectorRenderer.visible(sf, qw)) continue;
                for (int k = 0; k < 6; ++k) {
                    coords[k] = 0.0f;
                }
                boolean isWithinScaleRange = true;
                laon = laonDecor;
                updwl = updwlDecor;
                try {
                    boolean labeld;
                    RenderingRule[] rrules = sf.getRenderingRules();
                    double currentRatioScale = vc.getCurrentRatioScale();
                    if (rrules != null && rrules.length > 0) {
                        int countScaleSkipped = 0;
                        for (int k = 0; k < rrules.length; ++k) {
                            String upsidedwnlabels;
                            String noreplabels;
                            RenderingRule rule = rrules[k];
                            if (!rule.isWithinScaleLimits(currentRatioScale)) {
                                ++countScaleSkipped;
                                continue;
                            }
                            String labelalwayson = rule.getLabelProperty(RenderingRule.LABEL_ALWAYS_ON_PROPERTY);
                            if (labelalwayson != null) {
                                if (labelalwayson.equalsIgnoreCase("true")) {
                                    laon = true;
                                } else if (labelalwayson.equalsIgnoreCase("false")) {
                                    laon = false;
                                }
                            }
                            if ((noreplabels = rule.getLabelProperty(RenderingRule.NO_REPETITIVE_LABEL_PROPERTY)) != null) {
                                if (noreplabels.equalsIgnoreCase("true")) {
                                    loo = true;
                                } else if (noreplabels.equalsIgnoreCase("false")) {
                                    loo = false;
                                }
                            }
                            if ((upsidedwnlabels = rule.getLabelProperty(RenderingRule.UPSIDE_DOWN_LABELS_PROPERTY)) == null) continue;
                            if (upsidedwnlabels.equalsIgnoreCase("true")) {
                                updwl = true;
                                continue;
                            }
                            if (!upsidedwnlabels.equalsIgnoreCase("false")) continue;
                            updwl = false;
                        }
                        if (countScaleSkipped == rrules.length) {
                            isWithinScaleRange = false;
                        }
                    }
                    if (!isWithinScaleRange) continue;
                    if (loo && loo != looDecor) {
                        if (segmentLabelHelper == null) {
                            segmentLabelHelper = new Hashtable();
                            flag = new Integer(1);
                        }
                        if (segmentLabelHelper.get(label) != null) continue;
                    }
                    if (!(labeld = this.labelStyledFeature(g2, sf, coords, laon, loo, updwl, vc)) || !loo) continue;
                    if (segmentLabelHelper == null) {
                        segmentLabelHelper = new Hashtable();
                        flag = new Integer(1);
                    }
                    segmentLabelHelper.put(label, flag);
                    continue;
                }
                catch (StyleNotApplicableException se) {
                    log.warning(se.getMessage());
                }
            }
            vc.getCRArray().addAll(vc.getRenderedMarkerCRArray());
            vc.getRenderedMarkerCRArray().freeAll();
        }
        finally {
            if (segmentLabelHelper != null) {
                segmentLabelHelper.clear();
                segmentLabelHelper = null;
            }
        }
        long t1 = System.currentTimeMillis();
        log.finer("time to label theme " + t.getName() + " with " + t.size() + " styled features: " + (t1 - t0) + "ms");
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    public static boolean visible(StyledFeatureI sf, Rectangle2D qr) {
        JSDOGeometry geom = sf.getGeometry();
        if (geom == null) {
            return true;
        }
        if (qr == null) {
            return true;
        }
        double[] mbr = geom.getMBR();
        if (mbr == null) {
            return true;
        }
        double w = 0.0;
        double h = 0.0;
        if (mbr.length == 4) {
            w = mbr[2] - mbr[0];
            h = mbr[3] - mbr[1];
        } else {
            w = mbr[3] - mbr[0];
            h = mbr[4] - mbr[1];
        }
        if (w == 0.0 && h == 0.0) {
            return qr.contains(mbr[0], mbr[1]);
        }
        if (w == 0.0 || h == 0.0) {
            if (mbr.length == 4) {
                return qr.intersectsLine(mbr[0], mbr[1], mbr[2], mbr[3]);
            }
            return qr.intersectsLine(mbr[0], mbr[1], mbr[3], mbr[4]);
        }
        return qr.intersects(mbr[0], mbr[1], w, h);
    }

    private static StyleCache getSytleCache(String dataSource, VisContext vc) {
        if (vc.getTemporaryStyleCache() != null) {
            return vc.getTemporaryStyleCache();
        }
        return DSManager.getStyleCache(dataSource);
    }

    public static Point2D renderStyledFeature(Graphics2D g2, StyledFeatureI sf, VisContext vc) {
        boolean res;
        Point2D labelPoint = null;
        if (!sf.hasRenderableShape()) {
            sf.buildShapeFromGeometry(vc.getAffineXF());
        }
        if (g2 == null) {
            return null;
        }
        Shape shp = null;
        Object pt = null;
        Style sty = null;
        int gType = sf.getGeomType();
        if (gType == 1) {
            VectorRenderer.renderStyledPoint(g2, sf, vc);
            return null;
        }
        shp = sf.getShape();
        if (shp == null) {
            return null;
        }
        sty = sf.getFeatureStyle();
        if (sty == null) {
            sty = MapMaker.getStyleWithName(sf.getFeatureStyleName(), sf.getDataSource(), vc);
        }
        if (sty == null) {
            sty = StyleFactory.getDefaultStyle(gType);
        }
        if (!(res = sty.resolveStyles(VectorRenderer.getSytleCache(sf.getDataSource(), vc), vc.getDynamicStyles()))) {
            log.warning("cannot resolve referenced styles for style " + sty.getModel().getName());
        }
        if (vc.isPDFformatRequest()) {
            VectorRenderer.checkRegisterTTFforPDF(sf.getFeatureStyleName(), sty, sf.getDataSource(), g2);
        }
        if (gType == 4) {
            VectorRenderer.renderStyledCollection(g2, sty, sf, vc);
        } else if (gType == 5) {
            VectorRenderer.renderStyledMultiPoint(g2, sty, sf, vc);
        } else {
            Rectangle2D.Double clip = new Rectangle2D.Double();
            clip.setFrame(vc.getDeviceWindow().getMinX() - (double)VisContext.BUFFER_VECTOR_THEME, vc.getDeviceWindow().getMinY() - (double)VisContext.BUFFER_VECTOR_THEME, vc.getDeviceWindow().getWidth() + (double)(VisContext.BUFFER_VECTOR_THEME * 2), vc.getDeviceWindow().getHeight() + (double)(VisContext.BUFFER_VECTOR_THEME * 2));
            if (gType == 2 || gType == 6) {
                if ((shp = ShapeUtil.clipLineString(clip, shp)) == null) {
                    return null;
                }
                if (!vc.isTileRequest()) {
                    sf.setShape(shp);
                }
            }
            if (gType == 3 || gType == 7) {
                // empty if block
            }
            try {
                if ((gType == 2 || gType == 6) && sty instanceof StyleLine && ((StyleLine)sty).supportCasedLine() && sf.getRenderingRules() == null) {
                    CasedLineHelper ch = vc.getCasedLines();
                    ch.addStyledFeature(sf, shp, sty);
                } else {
                    StyleModifiers stymods = sty.convertToPixelSize(vc);
                    RenderingRule[] rrules = sf.getRenderingRules();
                    if ((vc.isTileRequest() || vc.isFOIRequest()) && (gType == 3 || gType == 7) && (sty instanceof PieChartStyle || sty instanceof BarChartStyle || sty instanceof VariablePieChartStyle)) {
                        labelPoint = VectorRenderer.getChartPointForPolygon(sty, vc, sf, shp);
                    }
                    if (rrules == null) {
                        if (VectorRenderer.isNativeBucketStyle(sty)) {
                            ((BucketStyle)sty).applyDeferringCasedLines(g2, shp, sf.getGeomType(), null, null, vc.getCRArray(), sf.getRenderableAttributes(), stymods, vc, sf);
                        } else {
                            sty.apply(vc, g2, shp, sf.getGeomType(), null, null, vc.getCRArray(), sf.getRenderableAttributes(), stymods);
                        }
                    } else {
                        VectorRenderer.applyFeatureRR(sf, rrules, shp, sty, vc, g2, null, stymods);
                    }
                }
            }
            catch (StyleNotApplicableException ex) {
                log.warning(ex.getMessage());
            }
        }
        if (vc.isFOIRequest() && labelPoint != null) {
            try {
                labelPoint = vc.getAffineXF().inverseTransform(labelPoint, null);
            }
            catch (Exception e) {}
        } else {
            labelPoint = null;
        }
        return labelPoint;
    }

    public static Point2D renderStyledFeatureUTFGrid(Graphics2D g2, StyledFeatureI sf, VisContext vc, int styOption, int key) {
        Point2D labelPoint = null;
        if (!sf.hasRenderableShape()) {
            sf.buildShapeFromGeometry(vc.getAffineXF());
        }
        if (g2 == null) {
            return null;
        }
        Shape shp = null;
        Object pt = null;
        StyleColor sty = null;
        sty = new StyleColor(new Color(key / 256 / 256, key / 256, key % 256), new Color(key / 256 / 256, key / 256, key % 256));
        int gType = sf.getGeomType();
        if (gType == 1) {
            VectorRenderer.renderStyledPointUTFGrid(g2, sf, vc, sty);
            return null;
        }
        shp = sf.getShape();
        if (shp == null) {
            return null;
        }
        boolean res = sty.resolveStyles(VectorRenderer.getSytleCache(sf.getDataSource(), vc), vc.getDynamicStyles());
        if (!res) {
            log.warning("cannot resolve referenced styles for style " + sty.getModel().getName());
        }
        if (gType == 4) {
            VectorRenderer.renderStyledCollection(g2, sty, sf, vc);
        } else if (gType == 5) {
            VectorRenderer.renderStyledMultiPointUTFGrid(g2, sty, sf, vc);
        } else {
            Rectangle2D.Double clip = new Rectangle2D.Double();
            clip.setFrame(vc.getDeviceWindow().getMinX() - (double)VisContext.BUFFER_VECTOR_THEME, vc.getDeviceWindow().getMinY() - (double)VisContext.BUFFER_VECTOR_THEME, vc.getDeviceWindow().getWidth() + (double)(VisContext.BUFFER_VECTOR_THEME * 2), vc.getDeviceWindow().getHeight() + (double)(VisContext.BUFFER_VECTOR_THEME * 2));
            if (gType == 2 || gType == 6) {
                if ((shp = ShapeUtil.clipLineString(clip, shp)) == null) {
                    return null;
                }
                if (!vc.isTileRequest()) {
                    sf.setShape(shp);
                }
            }
            if (gType == 3 || gType == 7) {
                // empty if block
            }
            try {
                if ((gType == 2 || gType == 6) && sty instanceof StyleLine && ((StyleLine)((Object)sty)).supportCasedLine() && sf.getRenderingRules() == null) {
                    CasedLineHelper ch = vc.getCasedLines();
                    ch.addStyledFeature(sf, shp, sty);
                } else {
                    StyleModifiers stymods = sty.convertToPixelSize(vc);
                    RenderingRule[] rrules = sf.getRenderingRules();
                    if ((vc.isTileRequest() || vc.isFOIRequest()) && (gType == 3 || gType == 7) && (sty instanceof PieChartStyle || sty instanceof BarChartStyle || sty instanceof VariablePieChartStyle)) {
                        labelPoint = VectorRenderer.getChartPointForPolygon(sty, vc, sf, shp);
                    }
                    if (rrules == null) {
                        if (VectorRenderer.isNativeBucketStyle(sty)) {
                            ((BucketStyle)((Object)sty)).applyDeferringCasedLines(g2, shp, sf.getGeomType(), null, null, vc.getCRArray(), sf.getRenderableAttributes(), stymods, vc, sf);
                        } else {
                            sty.apply(vc, g2, shp, sf.getGeomType(), null, null, vc.getCRArray(), sf.getRenderableAttributes(), stymods);
                        }
                    } else {
                        VectorRenderer.applyFeatureRR(sf, rrules, shp, sty, vc, g2, null, stymods);
                    }
                }
            }
            catch (StyleNotApplicableException ex) {
                log.warning(ex.getMessage());
            }
        }
        if (vc.isFOIRequest() && labelPoint != null) {
            try {
                labelPoint = vc.getAffineXF().inverseTransform(labelPoint, null);
            }
            catch (Exception e) {}
        } else {
            labelPoint = null;
        }
        return labelPoint;
    }

    private static void renderStyledCollection(Graphics2D g2, Style sty, StyledFeatureI sf, VisContext vc) {
        long t0 = System.currentTimeMillis();
        RenderingRule[] rrules = sf.getRenderingRules();
        try {
            StyleModifiers stymods;
            if (sty instanceof CollectionStyle) {
                if (rrules != null) {
                    log.warning("Rendering rules are currently ignored for lines and polygons with collection style");
                }
                stymods = sty.convertToPixelSize(vc);
                GeneralPath gpLines = new GeneralPath();
                GeneralPath gpRings = new GeneralPath();
                ShapeUtil.extractLinesAndRings(sf.getShape(), gpLines, gpRings);
                if (gpRings != null) {
                    sty.apply(vc, g2, gpRings, 3, null, null, null, sf.getRenderableAttributes(), stymods);
                }
                if (gpLines != null) {
                    sty.apply(vc, g2, gpLines, 2, null, null, null, sf.getRenderableAttributes(), stymods);
                }
            } else {
                stymods = sty.convertToPixelSize(vc);
                if (rrules == null) {
                    sty.apply(vc, g2, sf.getShape(), sf.getGeomType(), null, null, null, sf.getRenderableAttributes(), stymods);
                } else {
                    VectorRenderer.applyFeatureRR(sf, rrules, sf.getShape(), sty, vc, g2, null, stymods);
                }
            }
        }
        catch (StyleNotApplicableException ex) {
            log.warning(ex.getMessage());
        }
        long t1 = System.currentTimeMillis();
        Point2D[] pts = Util.getJavaPointsForGeometryCollection(sf.getGeometry());
        if (pts != null) {
            for (int i = 0; i < pts.length; ++i) {
                StyledFeature sf2 = new StyledFeature();
                JSDOGeometry ptgeom = new JSDOGeometry(pts[i].getX(), pts[i].getY(), 0);
                sf2.setGeometry(ptgeom);
                sf2.setMarkerStyleOrientation(sf.getMarkerStyleOrientation());
                sf2.setRenderableAttributes(sf.getRenderableAttributes());
                sf2.setGeomType(1);
                sf2.setFeatureStyle(sty);
                sf2.setRenderingRules(sf.getRenderingRules());
                VectorRenderer.renderStyledPoint(g2, sf2, vc);
            }
        }
        long t2 = System.currentTimeMillis();
        log.finer("non-point styled collection time: " + (t1 - t0));
        log.finer("    point styled collection time: " + (t2 - t1));
    }

    private static void renderStyledMultiPoint(Graphics2D g2, Style sty, StyledFeatureI sf, VisContext vc) {
        int[] elemInfo = sf.getGeometry().getElemInfo();
        double[] oordsArray = sf.getGeometry().getOrdinatesArray();
        float[] segCoords = new float[6];
        PathIterator pi = sf.getShape().getPathIterator(null);
        int index = 0;
        Vector<Rectangle2D> shpMbrs = new Vector<Rectangle2D>();
        Vector<Boolean> shpMbrIsNull = new Vector<Boolean>();
        while (!pi.isDone()) {
            int t = pi.currentSegment(segCoords);
            if (t == 0 || t == 1) {
                StyledFeature sf2 = new StyledFeature();
                sf2.setPoint(new Point2D.Double(segCoords[0], segCoords[1]));
                sf2.setGeomType(1);
                sf2.setFeatureStyle(sty);
                sf2.setFeatureStyleName(sf.getFeatureStyleName());
                sf2.setMarkerStyleOrientation(sf.getMarkerStyleOrientation());
                sf2.setRenderableAttributes(sf.getRenderableAttributes());
                sf2.setRenderingRules(sf.getRenderingRules());
                if (sf.getGeometry().isOrientedMultiPoint()) {
                    int orientStart = elemInfo[index * 6 + 3] - 1;
                    double ox = oordsArray[orientStart];
                    double oy = oordsArray[orientStart + 1];
                    sf2.setMarkerStyleOrientation(Math.atan2(-oy, ox));
                }
                VectorRenderer.renderStyledPoint(g2, sf2, vc);
                if (sf2.shpMBR != null) {
                    shpMbrs.add(sf2.shpMBR);
                    shpMbrIsNull.add(new Boolean(false));
                } else {
                    shpMbrIsNull.add(new Boolean(true));
                }
            }
            pi.next();
            ++index;
        }
        if (shpMbrIsNull.size() > 0) {
            Rectangle2D[] mbrs = new Rectangle2D[index];
            int added = 0;
            for (int i = 0; i < shpMbrIsNull.size(); ++i) {
                if (((Boolean)shpMbrIsNull.get(i)).booleanValue()) continue;
                mbrs[i] = (Rectangle2D)shpMbrs.get(added);
                ++added;
            }
            sf.setMultiPointShapeMBRs(mbrs);
        }
    }

    private static void renderStyledMultiPointUTFGrid(Graphics2D g2, Style sty, StyledFeatureI sf, VisContext vc) {
        int[] elemInfo = sf.getGeometry().getElemInfo();
        double[] oordsArray = sf.getGeometry().getOrdinatesArray();
        float[] segCoords = new float[6];
        PathIterator pi = sf.getShape().getPathIterator(null);
        int index = 0;
        Vector<Rectangle2D> shpMbrs = new Vector<Rectangle2D>();
        Vector<Boolean> shpMbrIsNull = new Vector<Boolean>();
        while (!pi.isDone()) {
            int t = pi.currentSegment(segCoords);
            if (t == 0 || t == 1) {
                StyledFeature sf2 = new StyledFeature();
                sf2.setPoint(new Point2D.Double(segCoords[0], segCoords[1]));
                sf2.setGeomType(1);
                sf2.setFeatureStyle(sty);
                sf2.setFeatureStyleName(sf.getFeatureStyleName());
                sf2.setMarkerStyleOrientation(sf.getMarkerStyleOrientation());
                sf2.setRenderableAttributes(sf.getRenderableAttributes());
                sf2.setRenderingRules(sf.getRenderingRules());
                if (sf.getGeometry().isOrientedMultiPoint()) {
                    int orientStart = elemInfo[index * 6 + 3] - 1;
                    double ox = oordsArray[orientStart];
                    double oy = oordsArray[orientStart + 1];
                    sf2.setMarkerStyleOrientation(Math.atan2(-oy, ox));
                }
                VectorRenderer.renderStyledPointUTFGrid(g2, sf2, vc, sty);
                if (sf2.shpMBR != null) {
                    shpMbrs.add(sf2.shpMBR);
                    shpMbrIsNull.add(new Boolean(false));
                } else {
                    shpMbrIsNull.add(new Boolean(true));
                }
            }
            pi.next();
            ++index;
        }
    }

    public static Point2D getPointOfPointFeature(StyledFeatureI sf, VisContext vc) {
        Point2D pt;
        if (!sf.hasRenderableShape()) {
            sf.buildShapeFromGeometry(vc.getAffineXF());
        }
        if ((pt = sf.getPoint()) == null) {
            Shape shp = sf.getShape();
            if (shp != null) {
                Rectangle2D r2 = shp.getBounds2D();
                pt = new Point2D.Double(r2.getCenterX(), r2.getCenterY());
                sf.setPoint(pt);
                return pt;
            }
            log.warning(RSBundle.getMsg("MAPVIEWER-01007"));
            return null;
        }
        return pt;
    }

    private static void renderStyledPoint(Graphics2D g2, StyledFeatureI sf, VisContext vc) {
        VectorRenderer.renderStyledPoint(g2, sf, vc, false);
    }

    public static void renderStyledPointUTFGrid(Graphics2D g2, StyledFeatureI sf, VisContext vc, Style sty) {
        Point2D pt = VectorRenderer.getPointOfPointFeature(sf, vc);
        if (pt == null) {
            return;
        }
        if (g2 == null) {
            return;
        }
        int x = (int)pt.getX();
        int y = (int)pt.getY();
        g2.setColor(((StyleColor)sty).getFillColor());
        g2.drawLine(x, y, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderStyledPoint(Graphics2D g2, StyledFeatureI sf, VisContext vc, boolean renderLableInside) {
        Point2D pt = VectorRenderer.getPointOfPointFeature(sf, vc);
        if (pt == null) {
            return;
        }
        Style sty = null;
        if (g2 == null) {
            return;
        }
        sty = sf.getFeatureStyle();
        if (sty == null) {
            sty = MapMaker.getStyleWithName(sf.getFeatureStyleName(), sf.getDataSource(), vc);
        }
        if (sty == null) {
            sty = StyleFactory.getDefaultStyle(1);
        }
        if (sty != null) {
            boolean res = sty.resolveStyles(VectorRenderer.getSytleCache(sf.getDataSource(), vc), vc.getDynamicStyles());
            if (vc.isPDFformatRequest()) {
                VectorRenderer.checkRegisterTTFforPDF(sf.getFeatureStyleName(), sty, sf.getDataSource(), g2);
            }
        }
        if (sty instanceof CollectionStyle) {
            VectorRenderer.renderStyledPointWithCollectionStyle(g2, sf, vc, sty);
            return;
        }
        int realw = 9;
        int realh = 9;
        try {
            StyleMarker msty = (StyleMarker)sty;
            VectorRenderer.drawMarkerOnPoint(g2, msty, sf, pt, vc, realw, realh, renderLableInside);
            if (sf.getRadius() != null) {
                VectorRenderer.renderRadius(g2, sf, vc);
            }
            return;
        }
        catch (ClassCastException e) {
            try {
                StyleColor csty = (StyleColor)sty;
                boolean draw = false;
                if (csty.getFillColor() != null && csty.getFillColor().getAlpha() != 0) {
                    draw = true;
                }
                if (csty.getStrokeColor() != null && csty.getStrokeColor().getAlpha() != 0) {
                    draw = true;
                }
                if (draw) {
                    int x = (int)pt.getX();
                    int y = (int)pt.getY();
                    if (csty.getFillColor() != null) {
                        g2.setColor(csty.getFillColor());
                    }
                    if (csty.getStrokeColor() != null) {
                        g2.setColor(csty.getStrokeColor());
                    }
                    realw = 6;
                    realh = 6;
                    g2.drawLine(x - 3, y - 3, x + 3, y + 3);
                    g2.drawLine(x - 3, y + 3, x + 3, y - 3);
                    Rectangle2D.Float r2 = new Rectangle2D.Float(x - 3, y - 3, 6.0f, 6.0f);
                    vc.getCRArray().insert(r2);
                    sf.setShpMBR(r2);
                }
                if (sf.getRadius() != null) {
                    VectorRenderer.renderRadius(g2, sf, vc);
                }
                return;
            }
            catch (ClassCastException e2) {
                try {
                    Rectangle2D r2;
                    block63: {
                        BucketStyle bs = (BucketStyle)sty;
                        int x = (int)pt.getX();
                        int y = (int)pt.getY();
                        StyleModifiers stymods = bs.convertToPixelSize(vc);
                        if (sf.getMarkerStyleOrientation() != 0.0 || bs.hasMarkerWithURLColumn()) {
                            boolean cloned = false;
                            Style defaultStyle = bs.getDefaultStyle();
                            if (defaultStyle != null && defaultStyle instanceof StyleMarker) {
                                if (stymods == null) {
                                    if (!cloned) {
                                        bs = (BucketStyle)bs.clone();
                                        cloned = true;
                                        defaultStyle = bs.getDefaultStyle();
                                    }
                                    try {
                                        defaultStyle = (StyleMarker)((StyleMarker)defaultStyle).clone();
                                        ((StyleMarker)defaultStyle).setOrientation(sf.getMarkerStyleOrientation());
                                        bs.setDefaultStyle(defaultStyle);
                                    }
                                    catch (Exception e3) {}
                                } else {
                                    StyleModifiers smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(bs.getDefaultStyleName().toUpperCase());
                                    if (smods != null && smods instanceof MarkerStyleModifiers) {
                                        ((MarkerStyleModifiers)smods).setOrientationAngle(sf.getMarkerStyleOrientation());
                                    }
                                }
                            }
                            int n = bs.getNumBuckets();
                            for (int i = 0; i < n; ++i) {
                                Style stybkt = (Style)bs.getBucket(i).getRenderStyle();
                                if (stybkt == null || !(stybkt instanceof StyleMarker)) continue;
                                if (stymods == null) {
                                    if (!cloned) {
                                        bs = (BucketStyle)bs.clone();
                                        cloned = true;
                                        stybkt = (Style)bs.getBucket(i).getRenderStyle();
                                    }
                                    try {
                                        stybkt = (StyleMarker)((StyleMarker)stybkt).clone();
                                    }
                                    catch (Exception e4) {
                                        continue;
                                    }
                                    ((StyleMarker)stybkt).setOrientation(sf.getMarkerStyleOrientation());
                                    bs.getBucket(i).setRenderStyle(stybkt);
                                    continue;
                                }
                                StyleModifiers smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(bs.getBucket(i).getRenderStyleName().toUpperCase() + "_" + i);
                                if (smods == null || !(smods instanceof MarkerStyleModifiers)) continue;
                                ((MarkerStyleModifiers)smods).setOrientationAngle(sf.getMarkerStyleOrientation());
                            }
                        }
                        r2 = new Rectangle2D.Float(x - 3, y - 3, 6.0f, 6.0f);
                        GeneralPath gp = new GeneralPath();
                        gp.moveTo(x - 3, y - 3);
                        gp.lineTo(x + 3, y + 3);
                        gp.moveTo(x - 3, y + 3);
                        gp.lineTo(x + 3, y - 3);
                        Point2D.Double lbpt = null;
                        if (bs instanceof VariablePieChartStyle) {
                            lbpt = new Point2D.Double(x, y);
                        }
                        try {
                            RenderingRule[] rrules = sf.getRenderingRules();
                            if (rrules == null) {
                                bs.apply(vc, g2, gp, 2, null, lbpt, null, sf.getRenderableAttributes(), stymods);
                            } else {
                                VectorRenderer.applyFeatureRR(sf, rrules, gp, bs, vc, g2, lbpt, stymods);
                            }
                            Rectangle2D ptr2 = VectorRenderer.getPointFeatureMbr(pt, sf, bs, rrules, stymods);
                            if (ptr2 == null) break block63;
                            r2 = ptr2;
                        }
                        catch (Exception ex) {
                            log.warning(ex.getMessage());
                        }
                        finally {
                            Style defaultStyle = bs.getDefaultStyle();
                            if (defaultStyle != null && defaultStyle instanceof StyleMarker) {
                                ((StyleMarker)defaultStyle).resetOrientation();
                            }
                            for (int i = 0; i < bs.getNumBuckets(); ++i) {
                                Style stybkt = (Style)bs.getBucket(i).getRenderStyle();
                                if (stybkt == null || !(stybkt instanceof StyleMarker)) continue;
                                ((StyleMarker)stybkt).resetOrientation();
                            }
                        }
                    }
                    vc.getCRArray().insert(r2);
                    sf.setShpMBR(r2);
                    return;
                }
                catch (ClassCastException e5) {
                    StyleModifiers stymods;
                    RenderingRule[] rrules = sf.getRenderingRules();
                    String[] styleColumns = null;
                    if (rrules != null) {
                        for (int r = 0; r < rrules.length; ++r) {
                            String basestyle = rrules[r].getStyleName();
                            if (basestyle == null || !basestyle.equalsIgnoreCase(sf.getFeatureStyleName())) continue;
                            styleColumns = rrules[r].getStyleColumns();
                            break;
                        }
                    }
                    try {
                        int w;
                        PieChartStyle pcs = (PieChartStyle)sty;
                        stymods = pcs.convertToPixelSize(vc);
                        Point2D lpt = null;
                        lpt = sf.getPoint();
                        try {
                            pcs.apply(vc, g2, sf.getShape(), sf.getGeomType(), null, lpt, null, sf.getRenderableAttributes(), styleColumns, stymods);
                        }
                        catch (Exception ex) {
                            log.warning(ex.getMessage());
                        }
                        int cx = (int)lpt.getX();
                        int cy = (int)lpt.getY();
                        int h = w = (int)((double)pcs.getPieRadius() * 2.5);
                        if (stymods != null && stymods instanceof PieChartStyleModifiers) {
                            h = w = (int)((double)((PieChartStyleModifiers)stymods).getPieRadius() * 2.5);
                        }
                        Rectangle2D.Float r2 = new Rectangle2D.Float(cx - w / 2, cy - h / 2, w, h);
                        vc.getCRArray().insert(r2);
                        sf.setShpMBR(r2);
                        return;
                    }
                    catch (ClassCastException e6) {
                        try {
                            BarChartStyle bcs = (BarChartStyle)sty;
                            stymods = bcs.convertToPixelSize(vc);
                            Point2D lpt = null;
                            lpt = sf.getPoint();
                            try {
                                bcs.apply(vc, g2, sf.getShape(), sf.getGeomType(), null, lpt, null, sf.getRenderableAttributes(), styleColumns, stymods);
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                            int cx = (int)lpt.getX();
                            int cy = (int)lpt.getY();
                            int w = ((BarChartStyleModel)bcs.getModel()).getWidth();
                            int h = ((BarChartStyleModel)bcs.getModel()).getHeight();
                            if (stymods != null && stymods instanceof BarChartStyleModifiers) {
                                w = ((BarChartStyleModifiers)stymods).getBarWidth();
                                h = ((BarChartStyleModifiers)stymods).getBarHeight();
                            }
                            Rectangle2D.Float r2 = new Rectangle2D.Float(cx - w / 2, cy - h / 2, w, h);
                            vc.getCRArray().insert(r2);
                            sf.setShpMBR(r2);
                            return;
                        }
                        catch (ClassCastException e7) {
                            block64: {
                                try {
                                    VariableMarkerStyle vms = (VariableMarkerStyle)sty;
                                    Shape trfshp = sf.getShape();
                                    Point2D lpt = sf.getPoint();
                                    Field[] values = sf.getRenderableAttributes();
                                    StyleMarker stmk = (StyleMarker)vms.chooseStyle(values[0]);
                                    if (stmk == null) {
                                        log.warning("cannot find a suitable variable marker style based on your values [" + values[0] + "].");
                                        break block64;
                                    }
                                    stmk.setOrientation(sf.getMarkerStyleOrientation());
                                    try {
                                        vms.apply(vc, g2, trfshp, sf.getGeomType(), null, lpt, null, sf.getRenderableAttributes(), null);
                                    }
                                    catch (Exception ex) {
                                        log.warning(ex.getMessage());
                                    }
                                    finally {
                                        stmk.resetOrientation();
                                    }
                                    int stw = stmk.getDesiredWidth();
                                    int sth = stmk.getDesiredHeight();
                                    int cx = (int)lpt.getX();
                                    int cy = (int)lpt.getY();
                                    vc.getCRArray().insert(cx - stw / 2, cy - sth / 2, stw, sth);
                                }
                                catch (ClassCastException e8) {
                                    log.severe(RSBundle.getMsg("MAPVIEWER-01006"));
                                }
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    static void drawMarkerOnPoint(Graphics2D g2, StyleMarker msty, StyledFeatureI sf, Point2D pt, VisContext vc, int realw, int realh) {
        VectorRenderer.drawMarkerOnPoint(g2, msty, sf, pt, vc, realw, realh, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void drawMarkerOnPoint(Graphics2D g2, StyleMarker msty, StyledFeatureI sf, Point2D pt, VisContext vc, int realw, int realh, boolean renderLabelInside) {
        Rectangle2D.Float r2anchored;
        double oldh;
        double oldw;
        int msz;
        block26: {
            MarkerStyleModifiers stymods = (MarkerStyleModifiers)msty.convertToPixelSize(vc);
            if (stymods != null) {
                stymods.setOrientationAngle(sf.getMarkerStyleOrientation());
            }
            boolean cloned = false;
            if (sf.getMarkerStyleOrientation() != 0.0) {
                msty = (StyleMarker)msty.clone();
                msty.setOrientation(sf.getMarkerStyleOrientation());
                cloned = true;
            }
            if (((MarkerStyleModel)msty.getModel()).getMarkerType() == 5 && ((MarkerStyleModel)msty.getModel()).getUrl() == null && ((MarkerStyleModel)msty.getModel()).getUrlColumn() != null) {
                Field[] attributes;
                String urlColumn = ((MarkerStyleModel)msty.getModel()).getUrlColumn();
                Field urlcol = Util.getField(urlColumn, attributes = sf.getAttributes());
                if (urlcol == null) {
                    log.warning("URL column [" + urlColumn + "] is not part of feature attributes. Check theme query.");
                    return;
                }
                if (!cloned) {
                    msty = (StyleMarker)msty.clone();
                }
                ((MarkerStyleModel)msty.getModel()).setUrl(urlcol.getValue().toString());
                msty.refreshThis();
            }
            msz = sf.getMarkerStyleSize();
            oldw = 0.0;
            oldh = 0.0;
            if (msz > 0) {
                oldw = msty.getDoubleDesiredWidth();
                oldh = msty.getDoubleDesiredHeight();
                msty.setDesiredWidth(msz);
                msty.setDesiredHeight(msz);
                if (stymods != null) {
                    stymods.setWidth(msz);
                    stymods.setHeight(msz);
                }
            }
            if (stymods == null) {
                if (msty.getDesiredWidth() > 0) {
                    realw = msty.getDesiredWidth();
                }
                if (msty.getDesiredHeight() > 0) {
                    realh = msty.getDesiredHeight();
                }
            } else {
                if (stymods.getWidth() < 1 || stymods.getHeight() < 1) {
                    if (msz > 0) {
                        msty.setDesiredWidth(oldw);
                        msty.setDesiredHeight(oldh);
                    }
                    return;
                }
                realw = stymods.getWidth();
                realh = stymods.getHeight();
            }
            Rectangle2D.Float r2 = new Rectangle2D.Float((float)(pt.getX() - (double)(realw / 2)), (float)(pt.getY() - (double)(realh / 2)), realw, realh);
            double[] anchorPoint = ((MarkerStyleModel)msty.getModel()).getAnchorPoint();
            r2anchored = new Rectangle2D.Float((float)(pt.getX() - (double)(realw / 2) + (0.5 - anchorPoint[0]) * (double)realw), (float)(pt.getY() - (double)(realh / 2) + (0.5 - anchorPoint[1]) * (double)realh), realw, realh);
            try {
                if (!sf.isAllowNakedPoints() && sf.getLabel() != null && (sf.getLabelStyleName() != null || sf.getLabelStyle() != null)) break block26;
                if (vc.getRenderedMarkerCRArray() != null) {
                    vc.getRenderedMarkerCRArray().insert(r2anchored);
                }
                if (vc.shouldRenderMarkerSequence()) {
                    if (vc.getDeviceWindow().contains(pt)) {
                        String sequence = vc.getNextMarkerSequence();
                        if (sequence != null) {
                            msty.apply(vc, g2, r2, 1, sequence, null, null, null, stymods);
                        } else {
                            msty.apply(vc, g2, r2, stymods);
                        }
                    } else {
                        msty.apply(vc, g2, r2, stymods);
                    }
                    break block26;
                }
                if (renderLabelInside) {
                    msty.apply(vc, g2, r2, 1, sf.getLabel(), null, null, null, stymods);
                    break block26;
                }
                msty.apply(vc, g2, r2, stymods);
            }
            catch (StyleNotApplicableException ex) {
                log.warning(ex.getMessage());
            }
        }
        if (vc.getMarkerCRArray() != null) {
            vc.getMarkerCRArray().insert(r2anchored);
        }
        sf.setShpMBR(r2anchored);
        if (msz > 0) {
            msty.setDesiredWidth(oldw);
            msty.setDesiredHeight(oldh);
        }
    }

    private static void renderStyledPointWithCollectionStyle(Graphics2D g2, StyledFeatureI sf, VisContext vc, Style sty) {
        if (sty == null || sf == null || !(sty instanceof CollectionStyle)) {
            return;
        }
        StyledFeature sf2 = new StyledFeature();
        sf2.setShape(sf.getShape());
        sf2.setPoint(sf.getPoint());
        sf2.setGeometry(sf.getGeometry());
        sf2.setGeomType(1);
        sf2.setMarkerStyleOrientation(sf.getMarkerStyleOrientation());
        sf2.setRenderableAttributes(sf.getRenderableAttributes());
        sf2.setRenderingRules(sf.getRenderingRules());
        CollectionStyleModel model = (CollectionStyleModel)sty.getModel();
        for (int i = 0; i < model.getNumberOfStyles(); ++i) {
            Style style = (Style)model.getStyle(i);
            sf2.setFeatureStyle(style);
            sf2.setFeatureStyleName(model.getStyleName(i));
            String shape = model.getStyleShape(i);
            if (shape != null && (shape == null || !shape.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE))) continue;
            VectorRenderer.renderStyledPoint(g2, sf2, vc);
        }
    }

    private static void renderRadius(Graphics2D g2, StyledFeatureI sf, VisContext vc) {
        Point2D pt = sf.getPoint();
        if (pt != null) {
            StyleColor sc = new StyleColor(null, Color.red);
            StyledFeature sf2 = new StyledFeature();
            double[] ptmbr = sf.getGeometry().getMBR();
            double[] rt = new double[4];
            double[] rs = sf.getRadius();
            for (int i = 0; i < rs.length; ++i) {
                double r = rs[i];
                rt[0] = ptmbr[0] - r;
                rt[1] = ptmbr[1] - r;
                rt[2] = ptmbr[0] + r;
                rt[3] = ptmbr[1] + r;
                vc.getAffineXF().transform(rt, 0, rt, 0, 2);
                Ellipse2D.Double cir = new Ellipse2D.Double(Math.min(rt[0], rt[2]), Math.min(rt[1], rt[3]), Math.abs(rt[2] - rt[0]), Math.abs(rt[3] - rt[1]));
                sf2.setShape(cir);
                sf2.setFeatureStyle(sc);
                sf2.setGeomType(2);
                VectorRenderer.renderStyledFeature(g2, sf2, vc);
            }
        }
    }

    public boolean labelStyledFeature(Graphics2D g2, StyledFeatureI sf, float[] coords, boolean forcedLabeling, boolean labelOnlyOnce, boolean upsideDownLabels, VisContext vc) throws StyleNotApplicableException {
        String label = sf.getTranslatedLabel();
        if (label == null) {
            label = sf.getLabel();
        }
        if (label == null || label.length() == 0) {
            return false;
        }
        Style sty = null;
        Shape shp = null;
        boolean w = false;
        boolean h = false;
        sty = sf.getLabelStyle();
        if (sty == null) {
            sty = MapMaker.getStyleWithName(sf.getLabelStyleName(), sf.getDataSource(), vc);
        }
        if (sty == null) {
            sty = StyleFactory.getDefaultTextStyle();
        }
        switch (sty.getModel().getType()) {
            case 5: {
                StyleText stx = (StyleText)sty;
                sty.resolveStyles(VectorRenderer.getSytleCache(sf.getDataSource(), vc), vc.getDynamicStyles());
                if (vc.isPDFformatRequest()) {
                    VectorRenderer.checkRegisterTTFforPDF(sf.getFeatureStyleName(), sty, sf.getDataSource(), g2);
                }
                return TextLabeler.applyTextLabel(g2, sf, stx, label, forcedLabeling, labelOnlyOnce, upsideDownLabels, vc);
            }
            case 2: {
                StyleMarker stm = (StyleMarker)sty;
                if (!this.labelFeatureWithMarker(g2, stm, sf, vc, coords, forcedLabeling)) break;
                return true;
            }
            case 9: {
                if (sty instanceof PieChartStyle || sty instanceof BarChartStyle) {
                    Point2D lpt = null;
                    shp = sf.getShape();
                    lpt = sf.getPoint();
                    if (lpt == null && shp != null) {
                        if (sf.getGeomType() == 3 || sf.getGeomType() == 7) {
                            lpt = null;
                        } else if (sf.getGeomType() == 2 || sf.getGeomType() == 6) {
                            if (this.findLabelPointOnLinearFeature(shp, coords, 5, 5, true, vc) != null) {
                                lpt = new Point2D.Double(coords[0], coords[1]);
                            }
                        } else {
                            Rectangle r = shp.getBounds();
                            lpt = new Point2D.Double(r.getCenterX(), r.getCenterY());
                        }
                    }
                    StyleModifiers stymods = sty.convertToPixelSize(vc);
                    sty.apply(vc, g2, shp, sf.getGeomType(), null, lpt, vc.getCRArray(), sf.getRenderableAttributes(), stymods);
                    return true;
                }
                if (sty instanceof VariableMarkerStyle || sty instanceof VariablePieChartStyle) {
                    sty.resolveStyles(VectorRenderer.getSytleCache(sf.getDataSource(), vc), vc.getDynamicStyles());
                    if (vc.isPDFformatRequest()) {
                        VectorRenderer.checkRegisterTTFforPDF(sf.getFeatureStyleName(), sty, sf.getDataSource(), g2);
                    }
                    Point2D lpt = null;
                    shp = sf.getShape();
                    lpt = sf.getPoint();
                    if (lpt == null && shp != null) {
                        if (sf.getGeomType() == 3 || sf.getGeomType() == 7) {
                            float[] res = LabelHelper.findLoc4RectInPolygon(shp, 5.0, 5.0, vc.getCRArray(), true, !vc.isTileRequest(), vc.isTileRequest() ? vc.deviceWindow : null);
                            if (res != null) {
                                lpt = new Point2D.Double((double)res[0] + 2.5, (double)res[1] - 2.5);
                            }
                        } else if (sf.getGeomType() == 2 || sf.getGeomType() == 6) {
                            if (this.findLabelPointOnLinearFeature(shp, coords, 5, 5, true, vc) != null) {
                                lpt = new Point2D.Double(coords[0], coords[1]);
                            }
                        } else {
                            Rectangle r = shp.getBounds();
                            lpt = new Point2D.Double(r.getCenterX(), r.getCenterY());
                        }
                    }
                    if (lpt != null) {
                        if (sty instanceof VariableMarkerStyle) {
                            VariableMarkerStyle vms = (VariableMarkerStyle)sty;
                            StyleModifiers stymods = vms.convertToPixelSize(vc);
                            Field[] values = sf.getRenderableAttributes();
                            BucketStyle.BucketDescription bd = vms.chooseRenderStyle(values[0], stymods);
                            StyleMarker stmk = (StyleMarker)bd.style;
                            if (stmk == null) {
                                log.warning("cannot find a suitable variable marker style based on your values [" + values[0] + "].");
                                return false;
                            }
                            vms.apply(vc, g2, shp, sf.getGeomType(), null, lpt, null, sf.getRenderableAttributes(), stymods);
                            int stw = stmk.getDesiredWidth();
                            int sth = stmk.getDesiredHeight();
                            if (bd.styleMods != null && bd.styleMods instanceof MarkerStyleModifiers) {
                                stw = ((MarkerStyleModifiers)bd.styleMods).getWidth();
                                sth = ((MarkerStyleModifiers)bd.styleMods).getHeight();
                            }
                            int cx = (int)lpt.getX();
                            int cy = (int)lpt.getY();
                            vc.getCRArray().insert(cx - stw / 2, cy - sth / 2, stw, sth);
                            return true;
                        }
                        VariablePieChartStyle vpc = (VariablePieChartStyle)sty;
                        StyleModifiers stymods = vpc.convertToPixelSize(vc);
                        Field[] values = sf.getRenderableAttributes();
                        double total = 0.0;
                        for (int i = 0; i < values.length; ++i) {
                            if (values[i].getShortJavaTypeName().equalsIgnoreCase("string")) {
                                try {
                                    total += Double.parseDouble(values[i].getString());
                                }
                                catch (Exception e) {
                                    log.warning("Attribute for VariablePieChartStyle is not numeric.");
                                }
                                continue;
                            }
                            total += values[i].getDouble();
                        }
                        Field value = new Field(total);
                        BucketStyle.BucketDescription bd = vpc.chooseRenderStyle(value, stymods);
                        PieChartStyle vpcsty = (PieChartStyle)bd.style;
                        if (vpcsty == null) {
                            log.warning("cannot find a suitable variable pie chart style based on your value [" + value + "].");
                            return false;
                        }
                        vpcsty.apply(vc, g2, shp, sf.getGeomType(), null, lpt, null, sf.getRenderableAttributes(), bd.styleMods);
                        int stw = vpcsty.getPieRadius() * 2;
                        int sth = vpcsty.getPieRadius() * 2;
                        int cx = (int)lpt.getX();
                        int cy = (int)lpt.getY();
                        vc.getCRArray().insert(cx - stw / 2, cy - sth / 2, stw, sth);
                        return true;
                    }
                    log.warning("cannot find a suitable place to draw variable marker.");
                    return false;
                }
                if (!(sty instanceof BucketStyle)) break;
                BucketStyle bsty = (BucketStyle)sty;
                Field[] values = sf.getRenderableAttributes();
                if (values == null) break;
                Style lblSty = bsty.chooseLabelStyle(values[0]);
                if (lblSty != null && lblSty instanceof StyleText) {
                    return TextLabeler.applyTextLabel(g2, sf, (StyleText)lblSty, label, forcedLabeling, labelOnlyOnce, upsideDownLabels, vc);
                }
                if (lblSty != null && lblSty instanceof StyleMarker) {
                    return this.labelFeatureWithMarker(g2, (StyleMarker)lblSty, sf, vc, coords, forcedLabeling);
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private boolean labelFeatureWithMarker(Graphics2D g2, StyleMarker stm, StyledFeatureI sf, VisContext vc, float[] coords, boolean forcedLabeling) {
        Shape shp = null;
        if (stm == null || sf == null) {
            return false;
        }
        int w = stm.getDesiredWidth();
        int h = stm.getDesiredHeight();
        MarkerStyleModifiers mkmods = (MarkerStyleModifiers)stm.convertToPixelSize(vc);
        if (mkmods != null) {
            w = mkmods.getWidth();
            h = mkmods.getHeight();
        }
        double[] anchorPoint = ((MarkerStyleModel)stm.getModel()).getAnchorPoint();
        if (sf.getGeomType() == 1) {
            Point2D pt = sf.getPoint();
            if (pt == null) {
                shp = sf.getShape();
                if (shp != null) {
                    Rectangle2D r2 = shp.getBounds2D();
                    pt = new Point2D.Double(r2.getCenterX(), r2.getCenterY());
                    sf.setPoint(pt);
                } else {
                    log.warning(RSBundle.getMsg("MAPVIEWER-01007"));
                    return false;
                }
            }
            coords[0] = (float)pt.getX();
            coords[1] = (float)pt.getY();
        } else {
            shp = sf.getShape();
            if (this.findLabelPointOnLinearFeature(shp, coords, w, h, forcedLabeling || sf.getForceLabel(), vc) == null) {
                return false;
            }
        }
        if (VectorRenderer.contains(vc, (double)coords[0] + (0.5 - anchorPoint[0]) * (double)w, (double)coords[1] + (0.5 - anchorPoint[1]) * (double)h, w, h)) {
            Rectangle2D.Float r2 = new Rectangle2D.Float(coords[0] - (float)(w / 2), coords[1] - (float)(h / 2), w, h);
            try {
                if (((MarkerStyleModel)stm.getModel()).getMarkerType() == 5 && ((MarkerStyleModel)stm.getModel()).getUrl() == null && ((MarkerStyleModel)stm.getModel()).getUrlColumn() != null) {
                    stm = (StyleMarker)stm.clone();
                }
                stm.apply(vc, g2, r2, 3, sf.getLabel(), null, null, sf.getRenderableAttributes(), mkmods);
                Rectangle2D.Float r2anchored = new Rectangle2D.Float((float)(r2.getMinX() + (0.5 - anchorPoint[0]) * ((RectangularShape)r2).getWidth()), (float)(r2.getMinY() + (0.5 - anchorPoint[1]) * ((RectangularShape)r2).getHeight()), (float)((RectangularShape)r2).getWidth(), (float)((RectangularShape)r2).getHeight());
                vc.getCRArray().insert(r2anchored);
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
                return false;
            }
        }
        return true;
    }

    public boolean labelStyledFeatureWithAnnotationText(Graphics2D g2, StyledFeatureI sf, AnnotationText atext, boolean labelOnlyOnce, boolean forcedLabeling, VisContext vc) {
        int i;
        if (atext == null) {
            return false;
        }
        AnnotationTextElement[] elements = atext.getElements();
        if (elements == null || elements.length == 0) {
            return false;
        }
        boolean status = false;
        boolean labeled = false;
        boolean haspolygon = false;
        boolean hasleaderline = false;
        for (i = 0; i < elements.length; ++i) {
            String label = elements[i].getValue();
            JGeometry location = elements[i].getLocation();
            JGeometry leaderline = elements[i].getLeaderLine();
            TextAttributesType textattrs = elements[i].getAttributes();
            if (location == null || location.getType() != 1) continue;
            Point2D backpt = sf.getPoint();
            JSDOGeometry backgeom = sf.getGeometry();
            Shape backshape = sf.getShape();
            if (!(backgeom.getType() != 3 && backgeom.getType() != 7 || leaderline == null || forcedLabeling)) {
                haspolygon = true;
                hasleaderline = true;
                continue;
            }
            StyleText stx = AnnotationTextThemeProducer.getTextStyle(textattrs);
            ((TextStyleModel)stx.getModel()).setApplyOPointsHintsToSimplePoints(true);
            Shape txtOutline = StyleText.getStringOutline(label, (TextStyleModel)stx.getModel(), null);
            if (txtOutline == null) continue;
            Rectangle2D outlineMBR = txtOutline.getBounds2D();
            Point2D p2 = location.getJavaPoint();
            Point2D p2new = null;
            if (vc.getAffineXF() != null) {
                p2new = (Point2D)p2.clone();
                vc.getAffineXF().transform(p2, p2new);
            } else {
                p2new = p2;
            }
            if (!(backgeom.getType() != 3 && backgeom.getType() != 7 || forcedLabeling)) {
                Rectangle2D shpMBR;
                if (sf.getShape() == null || (shpMBR = sf.getShape().getBounds2D()) == null) continue;
                LabelingHints hints = ((TextStyleModel)stx.getModel()).getLabelingHints();
                Object halign = hints.get(LabelingHints.KEY_OPOINT_HALIGN);
                Object valign = hints.get(LabelingHints.KEY_OPOINT_VALIGN);
                if (halign == null) {
                    halign = LabelingHints.VALUE_OPOINT_HALIGN_START;
                }
                if (valign == null) {
                    valign = LabelingHints.VALUE_OPOINT_VALIGN_TOP;
                }
                float sx = (float)p2new.getX();
                float sy = (float)p2new.getY();
                float hgap = (float)shpMBR.getWidth() / 2.0f + 2.0f;
                float vgap = (float)shpMBR.getHeight() / 2.0f + 2.0f;
                float cx = 0.0f;
                float cy = 0.0f;
                float w = (float)outlineMBR.getWidth();
                float h = (float)outlineMBR.getHeight();
                cx = LabelingHints.VALUE_OPOINT_HALIGN_CENTER == halign ? sx : (LabelingHints.VALUE_OPOINT_HALIGN_START == halign ? (float)((double)(sx + hgap) + (double)w / 2.0) : (float)((double)(sx - hgap) - (double)w / 2.0));
                cy = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE == valign ? sy : (LabelingHints.VALUE_OPOINT_VALIGN_TOP == valign ? (float)((double)(sy + vgap) + (double)h / 2.0) : (float)((double)(sy - vgap) - (double)h / 2.0));
                outlineMBR.setRect((double)cx - (double)w / 2.0, (double)cy - (double)h / 2.0, w, h);
                if (!location.isOrientedPoint()) {
                    if (!(sf.getShape().contains(outlineMBR.getMinX(), outlineMBR.getMinY()) && sf.getShape().contains(outlineMBR.getMaxX(), outlineMBR.getMaxY()) && sf.getShape().contains(outlineMBR.getMinX(), outlineMBR.getMaxY()) && sf.getShape().contains(outlineMBR.getMaxX(), outlineMBR.getMinY()))) {
                        continue;
                    }
                } else {
                    double[] coords = location.getOrdinatesArray();
                    int dim = location.getDimensions();
                    if (coords == null) continue;
                    AffineTransform at = new AffineTransform();
                    double rotation = Math.atan2(-coords[dim + 1], coords[dim]);
                    at.setToRotation(rotation, sx, sy);
                    Shape shp = at.createTransformedShape(outlineMBR);
                    double[] outsegs = ShapeUtil.lrSegmentPoints(shp);
                    if (outsegs == null || outsegs.length != 20 || !sf.getShape().contains(outsegs[0], outsegs[1]) || !sf.getShape().contains(outsegs[2], outsegs[3]) || !sf.getShape().contains(outsegs[6], outsegs[7]) || !sf.getShape().contains(outsegs[10], outsegs[11])) continue;
                }
            }
            sf.setGeometry(JSDOGeometry.recast(location));
            sf.setShape(null);
            sf.setPoint(p2new);
            try {
                status = TextLabeler.applyTextLabel(g2, sf, stx, label, forcedLabeling, labelOnlyOnce, false, vc);
                if (status) {
                    labeled = true;
                }
            }
            catch (StyleNotApplicableException ex) {
                // empty catch block
            }
            sf.setPoint(backpt);
            sf.setGeometry(backgeom);
            sf.setShape(backshape);
            if (leaderline == null) continue;
            StyledFeature llf = new StyledFeature();
            llf.setDataSource(sf.getDataSource());
            llf.setGeometry(JSDOGeometry.recast(leaderline));
            llf.setFeatureStyleName(sf.getLabelLeaderLineStyleName());
            llf.setFeatureStyle(sf.getLabelLeaderLineStyle());
            VectorRenderer.renderStyledFeature(g2, llf, vc);
        }
        if (!labeled && haspolygon && hasleaderline && !forcedLabeling) {
            for (i = 0; i < elements.length; ++i) {
                JGeometry location = elements[i].getLocation();
                JGeometry leaderline = elements[i].getLeaderLine();
                if (location == null || location.getType() != 1 || leaderline == null) continue;
                this.labelStyledFeatureWithAnnotationTextElement(g2, sf, elements[i], labelOnlyOnce, forcedLabeling, vc);
            }
        }
        return true;
    }

    private boolean labelStyledFeatureWithAnnotationTextElement(Graphics2D g2, StyledFeatureI sf, AnnotationTextElement atextElem, boolean labelOnlyOnce, boolean forcedLabeling, VisContext vc) {
        if (atextElem == null) {
            return false;
        }
        String label = atextElem.getValue();
        JGeometry location = atextElem.getLocation();
        JGeometry leaderline = atextElem.getLeaderLine();
        TextAttributesType textattrs = atextElem.getAttributes();
        if (location == null || location.getType() != 1) {
            return false;
        }
        StyleText stx = AnnotationTextThemeProducer.getTextStyle(textattrs);
        ((TextStyleModel)stx.getModel()).setApplyOPointsHintsToSimplePoints(true);
        Point2D backpt = sf.getPoint();
        JSDOGeometry backgeom = sf.getGeometry();
        Shape backshape = sf.getShape();
        Point2D p2 = location.getJavaPoint();
        Point2D p2new = null;
        if (vc.getAffineXF() != null) {
            p2new = (Point2D)p2.clone();
            vc.getAffineXF().transform(p2, p2new);
        } else {
            p2new = p2;
        }
        sf.setGeometry(JSDOGeometry.recast(location));
        sf.setShape(null);
        sf.setPoint(p2new);
        boolean status = false;
        try {
            status = TextLabeler.applyTextLabel(g2, sf, stx, label, forcedLabeling, labelOnlyOnce, false, vc);
        }
        catch (StyleNotApplicableException ex) {
            // empty catch block
        }
        sf.setPoint(backpt);
        sf.setGeometry(backgeom);
        sf.setShape(backshape);
        if (leaderline != null) {
            StyledFeature llf = new StyledFeature();
            llf.setDataSource(sf.getDataSource());
            llf.setGeometry(JSDOGeometry.recast(leaderline));
            llf.setFeatureStyleName(sf.getLabelLeaderLineStyleName());
            llf.setFeatureStyle(sf.getLabelLeaderLineStyle());
            VectorRenderer.renderStyledFeature(g2, llf, vc);
        }
        return status;
    }

    private float[] findLabelPointOnLinearFeature(Shape shp, float[] coords, int w, int h, boolean forcedLabeling, VisContext vc) {
        if (shp == null) {
            return null;
        }
        double length = ShapeUtil.lengthOf(shp);
        if ((length < (double)w || length < (double)h) && !forcedLabeling) {
            return null;
        }
        shp = ShapeUtil.clipLineString(vc.getDeviceWindow(), shp);
        if (shp == null || shp.getBounds().getWidth() == 0.0) {
            return null;
        }
        double off = 0.75;
        double inc = 0.098;
        for (int i = 0; i <= 5; ++i) {
            double thisOff = off + inc * (double)i;
            ShapeUtil.lrPoint(shp, thisOff, coords);
            if (vc.getDeviceWindow().contains(coords[0], coords[1]) && (forcedLabeling || !vc.getCRArray().conflicts((int)(coords[0] - (float)(w / 2)), (int)(coords[1] - (float)(h / 2)), w, h) && !vc.getMarkerCRArray().conflicts((int)(coords[0] - (float)(w / 2)), (int)(coords[1] - (float)(h / 2)), w, h))) {
                return coords;
            }
            if (i == 0) continue;
            thisOff = off - inc * (double)i;
            ShapeUtil.lrPoint(shp, thisOff, coords);
            if (!vc.getDeviceWindow().contains(coords[0], coords[1]) || !forcedLabeling && (vc.getCRArray().conflicts((int)(coords[0] - (float)(w / 2)), (int)(coords[1] - (float)(h / 2)), w, h) || vc.getMarkerCRArray().conflicts((int)(coords[0] - (float)(w / 2)), (int)(coords[1] - (float)(h / 2)), w, h))) continue;
            return coords;
        }
        if (forcedLabeling) {
            Rectangle2D mbr = shp.getBounds2D();
            if (mbr == null) {
                return null;
            }
            coords[0] = (float)mbr.getCenterX();
            coords[1] = (float)mbr.getCenterY();
            return coords;
        }
        return null;
    }

    private float[] findTextLabelPointOnAreaFeature(StyledFeatureI sf, float[] coords, StyleText stx, String label, boolean forcedLabeling, VisContext vc) {
        float h;
        Shape shp = sf.getShape();
        if (shp == null) {
            return null;
        }
        float off = 5.0f;
        Rectangle2D textRect = stx.getVisualBounds(label, null);
        Rectangle shpRect = shp.getBounds();
        float tx = (float)textRect.getMinX();
        float ty = (float)textRect.getMinY();
        float w = (float)textRect.getWidth();
        float[] res = LabelHelper.findLoc4RectInPolygon(shp, (int)w, (int)(h = (float)textRect.getHeight()), vc.getCRArray(), forcedLabeling, !vc.isTileRequest(), vc.isTileRequest() ? vc.deviceWindow : null);
        if (res != null) {
            coords[2] = res[2];
            if (res[2] == 0.0f) {
                coords[0] = res[0] + tx;
                coords[1] = res[1];
            } else if ((double)res[2] == -1.5707963267948966) {
                coords[0] = res[0];
                coords[1] = res[1] + tx;
            } else {
                coords[0] = res[0];
                coords[1] = res[1];
            }
            return coords;
        }
        return null;
    }

    public void drawLimits(Graphics2D g2, VisContext vc) {
        g2.setColor(Color.red);
        g2.setStroke(new BasicStroke());
        for (int i = 0; i < vc.getCRArray().size(); ++i) {
            Rectangle2D r2 = vc.getCRArray().elementAt(i);
            g2.draw(r2);
        }
    }

    private static boolean contains(VisContext vc, double cx, double cy, int w, int h) {
        double x = cx - (double)(w / 2) - 1.0;
        double y = cy - (double)(h / 2) - 1.0;
        return vc.getDeviceWindow().contains(x, y, w += 2, h += 2);
    }

    public static void applyFeatureRR(StyledFeatureI sf, RenderingRule[] rrules, Shape shp, Style sty, VisContext vc, Graphics2D g2, Point2D lbpt, StyleModifiers stymods) throws StyleNotApplicableException {
        Style substyle;
        int k;
        if (rrules == null || rrules.length == 0) {
            return;
        }
        Point2D labelPoint = null;
        if (sty instanceof VariablePieChartStyle) {
            labelPoint = lbpt;
        }
        boolean basestylefound = false;
        double currentRatioScale = vc.getCurrentRatioScale();
        for (k = 0; k < rrules.length; ++k) {
            String basestyle = rrules[k].getStyleName();
            if (basestyle == null || !basestyle.equalsIgnoreCase(sf.getFeatureStyleName())) continue;
            basestylefound = true;
            if (!rrules[k].isWithinScaleLimits(currentRatioScale)) break;
            String allowNakedPoints = rrules[k].getLabelProperty(RenderingRule.ALLOW_NAKED_POINTS_PROPERTY);
            if (allowNakedPoints != null) {
                if (allowNakedPoints.equalsIgnoreCase("true")) {
                    sf.setAllowNakedPoints(true);
                } else if (allowNakedPoints.equalsIgnoreCase("false")) {
                    sf.setAllowNakedPoints(false);
                }
            }
            substyle = null;
            if (rrules[k].getSubStyleName() != null) {
                substyle = MapMaker.getStyleWithName(rrules[k].getSubStyleName(), sf.getDataSource(), vc);
                substyle.resolveStyles(VectorRenderer.getSytleCache(sf.getDataSource(), vc), vc.getDynamicStyles());
                if (vc.isPDFformatRequest()) {
                    VectorRenderer.checkRegisterTTFforPDF(rrules[k].getSubStyleName(), substyle, sf.getDataSource(), g2);
                }
            }
            if ((sf.getGeomType() == 2 || sf.getGeomType() == 6) && sty instanceof StyleLine && ((StyleLine)sty).supportCasedLine()) {
                CasedLineHelper ch = vc.getCasedLines();
                ch.addStyledFeature(sf, shp, sty);
                break;
            }
            if (VectorRenderer.isNativeBucketStyle(sty)) {
                ((BucketStyle)sty).applyDeferringCasedLines(g2, shp, sf.getGeomType(), null, labelPoint, vc.getCRArray(), sf.getRenderableAttributes(), rrules[k].getStyleColumns(), substyle, rrules[k].getSubStyleColumns(), rrules[k].getSubStyleChangeProperty(), stymods, vc, sf);
                break;
            }
            sty.apply(vc, g2, shp, sf.getGeomType(), null, labelPoint, vc.getCRArray(), sf.getRenderableAttributes(), rrules[k].getStyleColumns(), substyle, rrules[k].getSubStyleColumns(), rrules[k].getSubStyleChangeProperty(), stymods);
            break;
        }
        if (!basestylefound) {
            if ((sf.getGeomType() == 2 || sf.getGeomType() == 6) && sty instanceof StyleLine && ((StyleLine)sty).supportCasedLine()) {
                CasedLineHelper ch = vc.getCasedLines();
                ch.addStyledFeature(sf, shp, sty);
            } else if (VectorRenderer.isNativeBucketStyle(sty)) {
                ((BucketStyle)sty).applyDeferringCasedLines(g2, shp, sf.getGeomType(), null, labelPoint, vc.getCRArray(), sf.getRenderableAttributes(), stymods, vc, sf);
            } else {
                sty.apply(vc, g2, shp, sf.getGeomType(), null, labelPoint, vc.getCRArray(), sf.getRenderableAttributes(), stymods);
            }
        }
        for (k = 0; k < rrules.length; ++k) {
            Style nextsty;
            String nextstyle = rrules[k].getStyleName();
            if (nextstyle != null && nextstyle.equalsIgnoreCase(sf.getFeatureStyleName()) || !rrules[k].isWithinScaleLimits(currentRatioScale) || (nextsty = MapMaker.getStyleWithName(nextstyle, sf.getDataSource(), vc)) == null) continue;
            nextsty.resolveStyles(VectorRenderer.getSytleCache(sf.getDataSource(), vc), vc.getDynamicStyles());
            if (vc.isPDFformatRequest()) {
                VectorRenderer.checkRegisterTTFforPDF(nextstyle, nextsty, sf.getDataSource(), g2);
            }
            substyle = null;
            if (rrules[k].getSubStyleName() != null) {
                substyle = MapMaker.getStyleWithName(rrules[k].getSubStyleName(), sf.getDataSource(), vc);
                substyle.resolveStyles(VectorRenderer.getSytleCache(sf.getDataSource(), vc), vc.getDynamicStyles());
                if (vc.isPDFformatRequest()) {
                    VectorRenderer.checkRegisterTTFforPDF(rrules[k].getSubStyleName(), substyle, sf.getDataSource(), g2);
                }
            }
            StyleModifiers nxmods = nextsty.convertToPixelSize(vc);
            labelPoint = null;
            if (nextsty instanceof VariablePieChartStyle) {
                labelPoint = lbpt;
            }
            if ((sf.getGeomType() == 2 || sf.getGeomType() == 6) && nextsty instanceof StyleLine && ((StyleLine)nextsty).supportCasedLine()) {
                CasedLineHelper ch = vc.getCasedLines();
                ch.addStyledFeature(sf, shp, nextsty);
                continue;
            }
            if (VectorRenderer.isNativeBucketStyle(nextsty)) {
                ((BucketStyle)nextsty).applyDeferringCasedLines(g2, shp, sf.getGeomType(), null, labelPoint, vc.getCRArray(), sf.getRenderableAttributes(), rrules[k].getStyleColumns(), substyle, rrules[k].getSubStyleColumns(), rrules[k].getSubStyleChangeProperty(), nxmods, vc, sf);
                continue;
            }
            nextsty.apply(vc, g2, shp, sf.getGeomType(), null, labelPoint, vc.getCRArray(), sf.getRenderableAttributes(), rrules[k].getStyleColumns(), substyle, rrules[k].getSubStyleColumns(), rrules[k].getSubStyleChangeProperty(), nxmods);
        }
    }

    private static boolean isNativeBucketStyle(Style sty) {
        if (sty == null) {
            return false;
        }
        return sty instanceof BucketStyle && !(sty instanceof ColorSchemeStyle) && !(sty instanceof VariableMarkerStyle) && !(sty instanceof VariablePieChartStyle);
    }

    private static Rectangle2D getPointFeatureMbr(Point2D pt, StyledFeatureI sf, BucketStyle bs, RenderingRule[] rrules, StyleModifiers stymods) {
        if (pt == null || bs == null) {
            return null;
        }
        double x = pt.getX();
        double y = pt.getY();
        Rectangle2D.Float r2 = null;
        if (!(bs instanceof ColorSchemeStyle) && !(bs instanceof VariablePieChartStyle) && sf.getRenderableAttributes() != null && sf.getRenderableAttributes().length > 0) {
            String[] styleColumns = null;
            if (rrules != null && rrules.length > 0) {
                for (int k = 0; k < rrules.length; ++k) {
                    String basestyle = rrules[k].getStyleName();
                    if (basestyle == null || !basestyle.equalsIgnoreCase(sf.getFeatureStyleName())) continue;
                    styleColumns = rrules[k].getStyleColumns();
                    break;
                }
            }
            BucketStyle.BucketDescription bd = null;
            if (styleColumns == null) {
                bd = bs.chooseRenderStyle(sf.getRenderableAttributes()[0], stymods);
            } else {
                Field[] svalue = new Field[]{null};
                void column = styleColumns[0];
                svalue[0] = Util.getField((String)column, sf.getRenderableAttributes());
                if (svalue[0] != null) {
                    bd = bs.chooseRenderStyle(svalue[0], stymods);
                }
            }
            if (bd != null && bd.style != null && bd.style instanceof StyleMarker) {
                double dw = ((StyleMarker)bd.style).getDoubleDesiredWidth();
                double dh = ((StyleMarker)bd.style).getDoubleDesiredHeight();
                if (bd.styleMods != null && bd.styleMods instanceof MarkerStyleModifiers) {
                    dw = ((MarkerStyleModifiers)bd.styleMods).getWidth();
                    dh = ((MarkerStyleModifiers)bd.styleMods).getHeight();
                }
                if (dw > 0.0 && dh > 0.0) {
                    double[] anchorPoint = ((MarkerStyleModel)bd.style.getModel()).getAnchorPoint();
                    r2 = new Rectangle2D.Float((float)(x - dw / 2.0 + (0.5 - anchorPoint[0]) * dw), (float)(y - dh / 2.0 + (0.5 - anchorPoint[1]) * dh), (float)dw, (float)dh);
                }
            }
        } else if (bs instanceof VariablePieChartStyle && sf.getRenderableAttributes() != null && sf.getRenderableAttributes().length > 0) {
            int i;
            Field[] values = sf.getRenderableAttributes();
            String[] styleColumns = null;
            if (rrules != null && rrules.length > 0) {
                for (int k = 0; k < rrules.length; ++k) {
                    String basestyle = rrules[k].getStyleName();
                    if (basestyle == null || !basestyle.equalsIgnoreCase(sf.getFeatureStyleName())) continue;
                    styleColumns = rrules[k].getStyleColumns();
                    break;
                }
            }
            if (styleColumns != null) {
                Field[] svalue = null;
                int numSlices = ((VariablePieChartStyleModel)bs.getModel()).getNumSlices();
                if (styleColumns.length < numSlices) {
                    log.warning("Not enough style columns for VariablePieChartStyle to compute point feature mbr.");
                } else {
                    svalue = new Field[numSlices];
                    for (i = 0; i < styleColumns.length; ++i) {
                        svalue[i] = null;
                        String column = styleColumns[i];
                        svalue[i] = Util.getField(column, values);
                        if (svalue[i] != null) continue;
                        log.warning("Unable to find attribute " + column + " for VariablePieChartStyle while computing point feature mbr.");
                        svalue = null;
                        break;
                    }
                }
                values = svalue;
            }
            if (values != null) {
                double total = 0.0;
                for (i = 0; i < values.length; ++i) {
                    if (values[i].getShortJavaTypeName().equalsIgnoreCase("string")) {
                        try {
                            total += Double.parseDouble(values[i].getString());
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    total += values[i].getDouble();
                }
                Field value = new Field(total);
                BucketStyle.BucketDescription bd = bs.chooseRenderStyle(value, stymods);
                if (bd != null && bd.style != null && bd.style instanceof PieChartStyle) {
                    double dw;
                    double dh = dw = (double)((PieChartStyle)bd.style).getPieRadius() * 2.5;
                    if (bd.styleMods != null && bd.styleMods instanceof PieChartStyleModifiers) {
                        dh = dw = (double)((PieChartStyleModifiers)bd.styleMods).getPieRadius() * 2.5;
                    }
                    if (dw > 0.0 && dh > 0.0) {
                        r2 = new Rectangle2D.Float((float)(x - dw / 2.0), (float)(y - dh / 2.0), (float)dw, (float)dh);
                    }
                }
            }
        }
        return r2;
    }

    private static Point2D getChartPointForPolygon(Style sty, VisContext vc, StyledFeatureI sf, Shape shp) {
        float[] pos = null;
        Point2D.Double emptyPos = new Point2D.Double(-999.0, -999.0);
        int h = 5;
        int w = 5;
        Rectangle2D tileMBR = vc.getDeviceWindow();
        pos = LabelHelper.findLoc4RectInPolygon(shp, 5.0, 5.0, vc.getCRArray(), true, false, null);
        StyleModifiers stymods = sty.convertToPixelSize(vc);
        if (sty instanceof BarChartStyle || sty instanceof PieChartStyle) {
            if (sty instanceof BarChartStyle) {
                BarChartStyleModifiers bcmods = (BarChartStyleModifiers)stymods;
                if (bcmods != null) {
                    h = bcmods.getBarWidth();
                    w = bcmods.getBarHeight();
                } else {
                    h = ((BarChartStyleModel)sty.getModel()).getHeight();
                    w = ((BarChartStyleModel)sty.getModel()).getWidth();
                }
            }
            if (sty instanceof PieChartStyle) {
                PieChartStyleModifiers pcmods = (PieChartStyleModifiers)stymods;
                if (pcmods != null) {
                    h = w = (int)((double)pcmods.getPieRadius() * 2.5);
                } else {
                    w = h = (int)(2.5 * (double)((PieChartStyleModel)sty.getModel()).getPieRadius());
                }
            }
        } else if (sty instanceof VariablePieChartStyle) {
            Field[] values = sf.getAttributes();
            if (values == null) {
                return null;
            }
            double total = 0.0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i].getShortJavaTypeName().equalsIgnoreCase("string")) {
                    try {
                        total += Double.parseDouble(values[i].getString());
                        continue;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                total += values[i].getDouble();
            }
            Field value = new Field(total);
            BucketStyle.BucketDescription bd = ((VariablePieChartStyle)sty).chooseRenderStyle(value, (AdvancedStyleModifiers)stymods);
            PieChartStyle stpc = (PieChartStyle)bd.style;
            if (stpc == null) {
                return null;
            }
            w = h = (int)(2.5 * (double)((PieChartStyleModel)stpc.getModel()).getPieRadius());
            if (bd.styleMods != null && bd.styleMods instanceof PieChartStyleModifiers) {
                h = w = (int)((double)((PieChartStyleModifiers)bd.styleMods).getPieRadius() * 2.5);
            }
        }
        if (pos == null || (double)pos[0] <= tileMBR.getMinX() || (double)pos[0] > tileMBR.getMaxX() || (double)pos[1] <= tileMBR.getMinY() || (double)pos[1] > tileMBR.getMaxY()) {
            return emptyPos;
        }
        if ((double)(pos[0] - (float)(w / 2)) <= tileMBR.getMinX()) {
            pos[0] = (float)(tileMBR.getMinX() + (double)(w / 2) + 1.0);
        }
        if ((double)(pos[1] - (float)(h / 2)) <= tileMBR.getMinY()) {
            pos[1] = (float)(tileMBR.getMinY() + (double)(h / 2) + 1.0);
        }
        if ((double)(pos[0] + (float)(w / 2)) >= tileMBR.getMaxX()) {
            pos[0] = (float)(tileMBR.getMaxX() - (double)(w / 2) - 1.0);
        }
        if ((double)(pos[1] + (float)(h / 2)) >= tileMBR.getMaxY()) {
            pos[1] = (float)(tileMBR.getMaxY() - (double)(h / 2) - 1.0);
        }
        return new Point2D.Double(pos[0], pos[1]);
    }

    public boolean isHeatMapTheme(Theme t, VisContext vc) {
        return ThemeUtils.isHeatMapTheme(t.getDefinition(), vc);
    }

    public static void checkRegisterTTFforPDF(String name, Style sty, String dataSource, Graphics2D g2d) {
        String tempDir = PDFTTFcache.getTemporaryDirectory();
        if (sty == null || dataSource == null || tempDir == null) {
            return;
        }
        if (g2d != null && g2d instanceof XDOGraphics2D && name != null) {
            DataSourceI ds = DSManager.get(dataSource);
            if (ds == null) {
                return;
            }
            if (sty instanceof StyleMarker || sty instanceof StyleText) {
                String owner = ds.getOwner();
                String sname = name;
                if (name.indexOf(58) > 0) {
                    int idx = name.indexOf(58);
                    owner = name.substring(0, idx);
                    sname = name.substring(idx + 1, name.length());
                }
                VectorRenderer.registerTTFforPDF(sty, dataSource, owner, g2d);
            }
        }
    }

    private static void registerTTFforPDF(Style sty, String dsrc, String owner, Graphics2D g2dPdf) {
        StyleText st;
        String tempDir = PDFTTFcache.getTemporaryDirectory();
        if (sty == null || g2dPdf == null || tempDir == null || dsrc == null || owner == null) {
            return;
        }
        if (!(g2dPdf instanceof XDOGraphics2D)) {
            return;
        }
        Font ttfont = null;
        if (sty instanceof StyleMarker) {
            StyleMarker sm = (StyleMarker)sty;
            if (((MarkerStyleModel)sm.getModel()).getMarkerType() == 6) {
                ttfont = ((MarkerStyleModel)sm.getModel()).getTruetypeFont().getFont();
            }
        } else if (sty instanceof StyleText && ((TextStyleModel)(st = (StyleText)sty).getModel()).getEmbeddedTTFont() != null) {
            ttfont = ((TextStyleModel)st.getModel()).getFont();
        }
        if (ttfont == null) {
            return;
        }
        String ttfName = ttfont.getFontName();
        if (ttfName == null) {
            return;
        }
        String ttfreg = PDFTTFcache.getFilePathForTTF(ttfName);
        String fileName = dsrc + "_" + owner + "_-_";
        String tfname = ttfName.replaceAll(" ", "-_-");
        fileName = fileName.toLowerCase() + tfname + ".ttf";
        if (ttfreg == null || !ttfreg.equalsIgnoreCase(tempDir + fileName)) {
            PDFTTFcache.registerTTF(ttfName, fileName, (XDOGraphics2D)g2dPdf);
        }
    }
}

