/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import com.teradata.jdbc.TeraConnectionPoolDataSource;
import java.awt.geom.Rectangle2D;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import oracle.mapviewer.share.ArrayParameter;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.ext.SDataProvider;
import oracle.mapviewer.share.ext.SDataSet;
import oracle.mapviewer.share.ext.SObject;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SharedUtils;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.WKT;

public class TeradataDataProvider
implements SDataProvider {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static Hashtable<String, TeraConnectionPoolDataSource> dsrcPool = new Hashtable();
    private static Hashtable<String, TessellationMetaData> tessellationMetadata = null;
    private static Hashtable<String, String> tessellationKeys = new Hashtable();

    @Override
    public synchronized boolean destroy() {
        this.clearCache();
        return true;
    }

    @Override
    public synchronized String[] getInitParameterNames() {
        return null;
    }

    @Override
    public synchronized String[] getRuntimeParameterNames() {
        return new String[]{"jdbcurl", "user", "password", "containerds", "basetable", "geomcolumn", "fetchsize"};
    }

    @Override
    public synchronized String getRuntimeParameterHintValue(String runtimeParam) {
        if (runtimeParam == null) {
            return null;
        }
        if (runtimeParam.equals("jdbcurl")) {
            return "jdbc:teradata://<hostname>/DATABASE=<dbname>,DBS_PORT=1025,TMODE=ANSI,CHARSET=UTF8";
        }
        return null;
    }

    @Override
    public synchronized boolean init(Properties params) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SDataSet buildDataSet(Rectangle2D queryWin, String[] nonSpatialColumns, String queryCondition, Object[] bindingParameters, Properties params) {
        Object[] values;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String url = params.getProperty("jdbcurl");
        String containerDS = params.getProperty("containerds");
        if (!(url != null && url.trim().length() != 0 || containerDS != null && containerDS.trim().length() != 0)) {
            log.warning("\"jdbcurl\" and \"containerds\" parameter are null. At least one must be defined.");
            return null;
        }
        String user = params.getProperty("user");
        if (user == null) {
            log.warning("\"user\" parameter is null");
            return null;
        }
        String pwd = params.getProperty("password");
        if (pwd == null) {
            log.warning("\"password\" parameter is null");
            return null;
        }
        String basetable = params.getProperty("basetable");
        if (basetable == null) {
            log.warning("\"basetable\" parameter is null");
            return null;
        }
        String geomcolumn = params.getProperty("geomcolumn");
        if (geomcolumn == null) {
            log.warning("\"geomcolumn\" parameter is null");
            return null;
        }
        int fetchSize = 100;
        String fetchsizeStr = params.getProperty("fetchsize");
        if (fetchsizeStr != null) {
            try {
                fetchSize = Integer.parseInt(fetchsizeStr);
                if (fetchSize < 1) {
                    fetchSize = 100;
                }
            }
            catch (Exception ex) {
                fetchSize = 100;
            }
        }
        boolean fullExtent = this.isFullExtent(queryWin);
        SDataSet dataset = new SDataSet();
        SObject obj = null;
        String basequery = "select \"" + geomcolumn + "\"" + " as " + "\"" + geomcolumn + "\", " + "CASE WHEN CHARACTERS(cast(" + "\"" + geomcolumn + "\"" + " as clob)) > 30000 THEN NULL ELSE CAST (" + "\"" + geomcolumn + "\"" + " as VARCHAR(30000)) END as " + "\"" + geomcolumn + "_inline\"";
        if (nonSpatialColumns != null && nonSpatialColumns.length > 0) {
            for (int i = 0; i < nonSpatialColumns.length; ++i) {
                if (nonSpatialColumns[i] == null || nonSpatialColumns[i].trim().length() <= 0) continue;
                basequery = basequery + "," + nonSpatialColumns[i];
            }
        }
        basequery = basequery + " from " + basetable;
        String sptClause = null;
        String conditionClause = null;
        String nsdpClause = null;
        if (!fullExtent) {
            sptClause = geomcolumn + ".ST_INTERSECTS(" + "new ST_GEOMETRY('POLYGON ((" + queryWin.getMinX() + " " + queryWin.getMinY() + "," + queryWin.getMaxX() + " " + queryWin.getMinY() + "," + queryWin.getMaxX() + " " + queryWin.getMaxY() + "," + queryWin.getMinX() + " " + queryWin.getMaxY() + "," + queryWin.getMinX() + " " + queryWin.getMinY() + "))')) = 1";
        }
        if (queryCondition != null) {
            String[] paramNames;
            String condition = queryCondition;
            if (bindingParameters != null && bindingParameters.length > 0 && (paramNames = SharedUtils.getBindingVariablesNames(condition)) != null && paramNames.length > 0) {
                if (bindingParameters.length != paramNames.length) {
                    log.warning("Number of binding parameters not equal to binding parameters in query condition.");
                    return null;
                }
                String changedcondition = "";
                for (int i = 0; i < paramNames.length; ++i) {
                    if (bindingParameters[i] instanceof ArrayParameter) {
                        Object bdvalues = ((ArrayParameter)bindingParameters[i]).getValue();
                        values = (Object[])bdvalues;
                        for (int l = 0; l < values.length; ++l) {
                            if (l > 0) {
                                changedcondition = changedcondition + ",";
                            }
                            changedcondition = changedcondition + "'" + values[l].toString() + "'";
                        }
                    } else {
                        changedcondition = "'" + bindingParameters[i].toString() + "'";
                    }
                    condition = condition.replaceFirst(":" + paramNames[i], changedcondition);
                }
            }
            conditionClause = condition;
        }
        String nsdpKeyColumn = params.getProperty("nsdpkeycolumn");
        String nsdpKeyValues = params.getProperty("nsdpkeyvalues");
        if (nsdpKeyColumn != null && nsdpKeyValues != null) {
            nsdpClause = nsdpKeyColumn + " in (" + nsdpKeyValues + ")";
        }
        try {
            String keyname;
            TessellationMetaData tmd;
            String dbName;
            DataSource dsrc;
            long t1 = System.currentTimeMillis();
            log.finest("Getting connection ...");
            if (containerDS != null && containerDS.trim().length() > 0) {
                dsrc = this.getContainerDataSource(containerDS.trim());
                if (dsrc != null) {
                    conn = dsrc.getConnection();
                }
                if (conn == null) {
                    if (url == null) {
                        log.warning("Unable to get JDBC connection from container data source [" + containerDS.trim() + "].");
                        values = null;
                        return values;
                    }
                    log.warning("Unable to get JDBC connection from container data source [" + containerDS.trim() + "]. " + "Will try from \"jdbcurl\" parameter.");
                } else {
                    log.finest("Got connection from container data source [" + containerDS.trim() + "].");
                }
            }
            if (conn == null) {
                conn = this.getJDBCConnection(url, user, pwd);
            }
            if (conn == null) {
                log.warning("Unable to get JDBC connection.");
                dsrc = null;
                return dsrc;
            }
            long t2 = System.currentTimeMillis();
            log.finest("Got connection in " + (t2 - t1) + "ms");
            if (tessellationMetadata == null) {
                this.readTessellationTable(conn);
            }
            if ((dbName = this.getDatabaseName(url)) != null && (tmd = tessellationMetadata.get((keyname = dbName + ":" + basetable + ":" + geomcolumn).toUpperCase())) != null) {
                String tessellationKey = tessellationKeys.get(keyname.toUpperCase());
                if (tessellationKey == null && (tessellationKey = this.getTesselationIndexKey(conn, dbName, basetable, geomcolumn)) != null) {
                    tessellationKeys.put(keyname.toUpperCase(), tessellationKey);
                }
                if (tessellationKey != null) {
                    sptClause = tessellationKey + " in " + "(select distinct " + tessellationKey + " from " + basetable + "_" + geomcolumn + "_idx t," + " TABLE (SYSSPATIAL.tessellate_search(1," + queryWin.getMinX() + "," + queryWin.getMinY() + "," + queryWin.getMaxX() + "," + queryWin.getMaxY() + "," + tmd.getUxMin() + "," + tmd.getUyMin() + "," + tmd.getUxMax() + "," + tmd.getUyMax() + "," + tmd.getG_nx() + "," + tmd.getG_ny() + "," + tmd.getLevels() + "," + tmd.getScale() + "," + (int)tmd.getShift() + ")) as i " + "where t.cellid = i.cellid) and " + geomcolumn + ".ST_INTERSECTS(" + "new ST_GEOMETRY('POLYGON ((" + queryWin.getMinX() + " " + queryWin.getMinY() + "," + queryWin.getMaxX() + " " + queryWin.getMinY() + "," + queryWin.getMaxX() + " " + queryWin.getMaxY() + "," + queryWin.getMinX() + " " + queryWin.getMaxY() + "," + queryWin.getMinX() + " " + queryWin.getMinY() + "))')) = 1";
                }
            }
            String query = this.buildFinalQuery(basequery, conditionClause, nsdpClause, sptClause);
            log.finest("Preparing Query: " + query);
            stmt = conn.prepareStatement(query);
            stmt.setFetchSize(fetchSize);
            log.finest("Executing query...");
            rs = stmt.executeQuery();
            ResultSetMetaData rsmeta = rs.getMetaData();
            log.finest("Fetching records (fetch size=" + fetchSize + ")...");
            while (rs.next()) {
                JGeometry jgeom = null;
                try {
                    jgeom = this.loadGeometry(rs, geomcolumn);
                }
                catch (Exception ex) {
                    jgeom = null;
                }
                if (jgeom == null) continue;
                ArrayList<Field> fields = new ArrayList<Field>();
                if (nonSpatialColumns != null && nonSpatialColumns.length > 0) {
                    for (int i = 1; i <= rsmeta.getColumnCount(); ++i) {
                        Field f = null;
                        String column = rsmeta.getColumnName(i);
                        if (column.equalsIgnoreCase(geomcolumn)) continue;
                        int sqlType = rsmeta.getColumnType(i);
                        switch (sqlType) {
                            case 16: {
                                f = Field.createField(rs.getString(column), "boolean");
                                break;
                            }
                            case 1: 
                            case 12: {
                                f = new Field(rs.getString(column));
                                break;
                            }
                            case 4: 
                            case 5: {
                                f = new Field(rs.getInt(column));
                                break;
                            }
                            case -5: {
                                f = new Field(rs.getLong(column));
                                break;
                            }
                            case 6: 
                            case 7: {
                                f = new Field(rs.getFloat(column));
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 8: {
                                f = new Field(rs.getDouble(column));
                                break;
                            }
                            case 91: {
                                f = Field.createField(rs.getString(column), "date");
                                break;
                            }
                        }
                        if (f == null) continue;
                        f.setName(column);
                        fields.add(f);
                    }
                }
                Field[] attrFields = null;
                if (fields.size() > 0) {
                    attrFields = fields.toArray(new Field[fields.size()]);
                }
                obj = new SObject(jgeom, attrFields);
                dataset.addObject(obj);
            }
        }
        catch (Exception ex) {
            log.warning("Exception: " + ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        if (dataset.getSize() == 0) {
            return null;
        }
        return dataset;
    }

    private synchronized String buildFinalQuery(String basequery, String conditionClause, String nsdpClause, String sptClause) {
        if (basequery == null) {
            return null;
        }
        String query = basequery;
        String whereClause = null;
        if (conditionClause != null) {
            whereClause = " where (" + conditionClause + ")";
        }
        if (nsdpClause != null) {
            whereClause = whereClause != null ? whereClause + " and (" + nsdpClause + ")" : " where (" + nsdpClause + ")";
        }
        if (sptClause != null) {
            whereClause = whereClause != null ? whereClause + " and (" + sptClause + ")" : " where (" + sptClause + ")";
        }
        if (whereClause == null) {
            return query;
        }
        return query + whereClause;
    }

    private synchronized JGeometry loadGeometry(ResultSet rs, String column) throws Exception {
        Clob shapeClob = null;
        StringBuffer mShape = null;
        String wktStr = null;
        try {
            wktStr = rs.getString(column + "_inline");
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (wktStr != null) {
            mShape = new StringBuffer(wktStr);
        } else {
            shapeClob = rs.getClob(column);
            mShape = new StringBuffer(shapeClob.getSubString(1L, (int)shapeClob.length()));
        }
        JGeometry geom = null;
        if (mShape != null) {
            WKT wkt = new WKT();
            byte[] wktb = mShape.toString().getBytes();
            if (wktb != null) {
                geom = wkt.toJGeometry(wktb);
            }
        }
        return geom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Field[] getAttributeList(Properties params) {
        String url = params.getProperty("jdbcurl");
        String containerDS = params.getProperty("containerds");
        if (!(url != null && url.trim().length() != 0 || containerDS != null && containerDS.trim().length() != 0)) {
            log.warning("\"jdbcurl\" and \"containerds\" parameter are null. At least one must be defined.");
            return null;
        }
        String user = params.getProperty("user");
        if (user == null) {
            log.warning("\"user\" parameter is null");
            return null;
        }
        String pwd = params.getProperty("password");
        if (pwd == null) {
            log.warning("\"password\" parameter is null");
            return null;
        }
        String basetable = params.getProperty("basetable");
        if (basetable == null) {
            log.warning("\"basetable\" parameter is null");
            return null;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        Vector<Field> fields = new Vector<Field>();
        String dbname = null;
        String query = null;
        try {
            DataSource dsrc;
            long t1 = System.currentTimeMillis();
            log.finest("Getting connection ...");
            if (containerDS != null && containerDS.trim().length() == 0) {
                dsrc = this.getContainerDataSource(containerDS.trim());
                if (dsrc != null) {
                    conn = dsrc.getConnection();
                }
                if (conn == null && url == null) {
                    log.warning("Unable to get JDBC connection from container data source [" + containerDS.trim() + "].");
                    Field[] fieldArray = null;
                    return fieldArray;
                }
            }
            if (conn == null) {
                conn = this.getJDBCConnection(url, user, pwd);
            }
            if (conn == null) {
                log.warning("Unable to get JDBC connection.");
                dsrc = null;
                return dsrc;
            }
            long t2 = System.currentTimeMillis();
            log.finest("Got connection in " + (t2 - t1) + "ms");
            dbname = this.getDatabaseName(url);
            if (dbname != null) {
                query = "select columnname, columntype from dbc.columns where  upper(databasename) = ? and upper(tablename) = ?";
                stmt = conn.prepareStatement(query);
                stmt.setString(1, dbname.toUpperCase());
                stmt.setString(2, basetable.toUpperCase());
            } else {
                query = "select columnname, columntype from dbc.columns where upper(tablename) = ?";
                stmt = conn.prepareStatement(query);
                stmt.setString(1, basetable.toUpperCase());
            }
            log.finest("Table attribute query: " + query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String colname = rs.getString(1);
                String coltype = rs.getString(2);
                int javaType = 0;
                if (coltype != null) {
                    if ((coltype = coltype.trim()).equalsIgnoreCase("CF") || coltype.equalsIgnoreCase("CV")) {
                        javaType = 8;
                    } else if (coltype.equalsIgnoreCase("I2") || coltype.equalsIgnoreCase("I")) {
                        javaType = 3;
                    } else if (coltype.equalsIgnoreCase("F") || coltype.equalsIgnoreCase("D")) {
                        javaType = 6;
                    } else if (coltype.equalsIgnoreCase("DA")) {
                        javaType = 10;
                    }
                }
                if (javaType == 0) continue;
                Field f = new Field();
                f.setName(colname.trim());
                f.setType(javaType);
                fields.add(f);
            }
            log.finest("# of columns: " + fields.size());
        }
        catch (Exception ex) {
            log.warning("Exception: " + ex.getMessage());
            Field[] fieldArray = null;
            return fieldArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        if (fields.size() == 0) {
            return null;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    @Override
    public synchronized Rectangle2D getDataExtents(Properties params) {
        return null;
    }

    @Override
    public synchronized boolean buildSpatialIndex(Properties params) {
        return true;
    }

    private synchronized boolean isFullExtent(Rectangle2D queryWin) {
        if (queryWin == null) {
            return true;
        }
        double xl = queryWin.getMinX();
        double yl = queryWin.getMinY();
        double xh = queryWin.getMaxX();
        double yh = queryWin.getMaxY();
        return Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh);
    }

    private synchronized DataSource getContainerDataSource(String jndiLocation) {
        try {
            InitialContext ic = new InitialContext();
            DataSource ds = (DataSource)ic.lookup(jndiLocation);
            return ds;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private synchronized TeraConnectionPoolDataSource getJDBCurlFromConnectionPool(String jdbcURL, String user, String password) {
        if (jdbcURL == null || user == null || password == null) {
            return null;
        }
        return dsrcPool.get(jdbcURL + ":" + user + ":" + password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TeraConnectionPoolDataSource addJDBCurlToConnectionPool(String jdbcURL, String user, String password) {
        if (jdbcURL == null || user == null || password == null) {
            return null;
        }
        TeraConnectionPoolDataSource dsrc = dsrcPool.get(jdbcURL + ":" + user + ":" + password);
        if (dsrc != null) {
            return null;
        }
        int index = jdbcURL.indexOf("//");
        if (index == -1) {
            return null;
        }
        int endserverIdx = jdbcURL.indexOf("/", index + 2);
        if (endserverIdx == -1) {
            return null;
        }
        String server = jdbcURL.substring(index + 2, endserverIdx);
        String params = jdbcURL.substring(endserverIdx + 1);
        List paramAttrs = SharedUtils.splitBy(params, ",");
        if (paramAttrs == null || paramAttrs.size() == 0) {
            return null;
        }
        String database = null;
        String dbsport = null;
        String tmode = null;
        String charset = null;
        String fieldSep = null;
        String lobTempTable = null;
        String logValue = null;
        String tcp = null;
        String tnano = null;
        String tsnano = null;
        String type = null;
        for (int i = 0; i < paramAttrs.size(); ++i) {
            String param = paramAttrs.get(i).toString();
            int idx = param.indexOf("=");
            if (idx == -1) continue;
            String paramName = param.substring(0, idx);
            String paramValue = param.substring(idx + 1);
            if (paramName == null || paramName.length() == 0 || paramValue == null || paramValue.length() == 0) {
                return null;
            }
            if (paramName.equals("DATABASE")) {
                database = paramValue;
                continue;
            }
            if (paramName.equals("DBS_PORT")) {
                dbsport = paramValue;
                continue;
            }
            if (paramName.equals("TMODE")) {
                tmode = paramValue;
                continue;
            }
            if (paramName.equals("CHARSET")) {
                charset = paramValue;
                continue;
            }
            if (paramName.equals("FIELD_SEP")) {
                fieldSep = paramValue;
                continue;
            }
            if (paramName.equals("LOB_TEMP_TABLE")) {
                lobTempTable = paramValue;
                continue;
            }
            if (paramName.equals("LOG")) {
                logValue = paramValue;
                continue;
            }
            if (paramName.equals("TCP")) {
                tcp = paramValue;
                continue;
            }
            if (paramName.equals("TNANO")) {
                tnano = paramValue;
                continue;
            }
            if (paramName.equals("TSNANO")) {
                tsnano = paramValue;
                continue;
            }
            if (!paramName.equals("TYPE")) continue;
            type = paramValue;
        }
        if (database == null) {
            return null;
        }
        dsrc = new TeraConnectionPoolDataSource();
        dsrc.setDSName(server);
        dsrc.setDatabaseName(database);
        dsrc.setUser(user);
        dsrc.setPassword(password);
        if (dbsport != null) {
            dsrc.setDBS_PORT(dbsport);
        }
        if (tmode != null) {
            dsrc.setTMODE(tmode);
        }
        if (charset != null) {
            dsrc.setCHARSET(charset);
        }
        if (fieldSep != null) {
            dsrc.setFIELD_SEP(fieldSep);
        }
        if (lobTempTable != null) {
            dsrc.setLOB_TEMP_TABLE(lobTempTable);
        }
        if (logValue != null) {
            dsrc.setLOG(logValue);
        }
        if (tcp != null) {
            dsrc.setTCP(tcp);
        }
        if (tnano != null) {
            dsrc.setTNANO(tnano);
        }
        if (tsnano != null) {
            dsrc.setTSNANO(tsnano);
        }
        if (type != null) {
            dsrc.setTYPE(type);
        }
        dsrc.setInitialPoolSize(3);
        dsrc.setMinPoolSize(3);
        Connection conn = null;
        try {
            conn = dsrc.getPooledConnection().getConnection();
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            TeraConnectionPoolDataSource teraConnectionPoolDataSource = null;
            return teraConnectionPoolDataSource;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        dsrcPool.put(jdbcURL + ":" + user + ":" + password, dsrc);
        return dsrc;
    }

    private synchronized String getDatabaseName(String url) {
        int index;
        String dbName = null;
        if (url != null && (index = url.indexOf("DATABASE=")) > -1) {
            int endIndex = url.indexOf(",", index + 9);
            dbName = endIndex > -1 ? url.substring(index + 9, endIndex) : url.substring(index + 9);
        }
        return dbName;
    }

    @Override
    public synchronized void clearCache() {
        if (dsrcPool.size() == 0) {
            return;
        }
        Enumeration<TeraConnectionPoolDataSource> e = dsrcPool.elements();
        while (e.hasMoreElements()) {
            TeraConnectionPoolDataSource dsrc = e.nextElement();
            try {
                PooledConnection pc = dsrc.getPooledConnection();
                pc.close();
            }
            catch (Exception exception) {}
        }
        dsrcPool.clear();
        tessellationMetadata = null;
        tessellationKeys.clear();
    }

    @Override
    public synchronized boolean canBuildSpatialIndex() {
        return false;
    }

    @Override
    public synchronized String[] getParametersToQuerySpatialMetadata() {
        return new String[]{"jdbcurl", "user", "password"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String[][] getSpatialTables(Properties params) {
        Object dbname;
        String url = params.getProperty("jdbcurl");
        if (url == null) {
            log.warning("\"jdbcurl\" parameter is null");
            return null;
        }
        String user = params.getProperty("user");
        if (user == null) {
            log.warning("\"user\" parameter is null");
            return null;
        }
        String pwd = params.getProperty("password");
        if (pwd == null) {
            log.warning("\"password\" parameter is null");
            return null;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String[]> tbcolumns = new ArrayList<String[]>();
        try {
            TeraConnectionPoolDataSource dsPool = this.getJDBCurlFromConnectionPool(url, user, pwd);
            if (dsPool == null) {
                dsPool = this.addJDBCurlToConnectionPool(url, user, pwd);
            }
            if (dsPool != null) {
                conn = dsPool.getPooledConnection().getConnection();
            }
            if (conn == null) {
                log.warning("Unable to get database connection");
                String[][] stringArray = null;
                return stringArray;
            }
            dbname = null;
            int index = url.indexOf("DATABASE=");
            if (index > -1) {
                int endIndex = url.indexOf(",", index + 9);
                dbname = endIndex > -1 ? url.substring(index + 9, endIndex) : url.substring(index + 9);
            }
            if (dbname == null) {
                log.warning("jdbcurl parameter must defined database name (...DATABASE=...)");
                String[][] endIndex = null;
                return endIndex;
            }
            String query = "select tablename,columnname from dbc.columns where  upper(databasename) = ? and upper(columnudtname) = ?";
            stmt = conn.prepareStatement(query);
            stmt.setString(1, dbname.toUpperCase());
            stmt.setString(2, "ST_GEOMETRY");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String table = rs.getString(1);
                String column = rs.getString(2);
                if (table == null) continue;
                String[] values = new String[2];
                values[0] = table.trim();
                if (column != null) {
                    values[1] = column.trim();
                }
                tbcolumns.add(values);
            }
        }
        catch (Exception ex) {
            log.warning("Exception; " + ex.getMessage());
            dbname = null;
            return dbname;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        if (tbcolumns.size() == 0) {
            return null;
        }
        String[][] output = new String[tbcolumns.size()][];
        int i = 0;
        while (i < tbcolumns.size()) {
            output[i] = (String[])tbcolumns.get(i);
            ++i;
        }
        return output;
    }

    private synchronized Connection getJDBCConnection(String url, String user, String pwd) {
        Connection conn = null;
        try {
            TeraConnectionPoolDataSource dsPool = this.getJDBCurlFromConnectionPool(url, user, pwd);
            if (dsPool == null) {
                dsPool = this.addJDBCurlToConnectionPool(url, user, pwd);
            }
            if (dsPool != null) {
                conn = dsPool.getPooledConnection().getConnection();
            }
        }
        catch (Exception ex) {
            conn = null;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readTessellationTable(Connection conn) {
        if (tessellationMetadata == null) {
            tessellationMetadata = new Hashtable();
        } else {
            tessellationMetadata.clear();
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String query = "select * from SYSSPATIAL.tessellation";
        try {
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                TessellationMetaData tmd = new TessellationMetaData();
                tmd.setF_Table_Schema(rs.getString("F_TABLE_SCHEMA"));
                tmd.setF_Table_Name(rs.getString("F_TABLE_NAME"));
                tmd.setF_Geometry_Column(rs.getString("F_GEOMETRY_COLUMN"));
                tmd.setUxMin(rs.getDouble("U_XMIN"));
                tmd.setUyMin(rs.getDouble("U_YMIN"));
                tmd.setUxMax(rs.getDouble("U_XMAX"));
                tmd.setUyMax(rs.getDouble("U_YMAX"));
                tmd.setG_nx(rs.getInt("G_NX"));
                tmd.setG_ny(rs.getInt("G_NY"));
                tmd.setLevels(rs.getInt("LEVELS"));
                tmd.setScale(rs.getDouble("SCALE"));
                tmd.setShift(rs.getDouble("SHIFT"));
                String key = tmd.getF_Table_Schema() + ":" + tmd.getF_Table_Name() + ":" + tmd.getF_Geometry_Column();
                tessellationMetadata.put(key.toUpperCase(), tmd);
            }
        }
        catch (Exception ex) {
            tessellationMetadata.clear();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getTesselationIndexKey(Connection conn, String dbName, String table, String geomColumn) {
        if (conn == null || dbName == null || table == null || geomColumn == null) {
            return null;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String query = "select columnname from dbc.columns where  upper(databasename) = ? and upper(tablename) = ?";
        try {
            stmt = conn.prepareStatement(query);
            stmt.setString(1, dbName.toUpperCase());
            stmt.setString(2, table.toUpperCase() + "_" + geomColumn.toUpperCase() + "_IDX");
            rs = stmt.executeQuery();
            while (true) {
                if (rs.next()) {
                    String colname = rs.getString(1);
                    if (colname.trim().equalsIgnoreCase(geomColumn)) continue;
                    String string = colname.trim();
                    return string;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            String string = null;
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
        }
        return null;
    }

    @Override
    public String getGlobalDataDirectory() {
        return null;
    }

    @Override
    public void setGlobalDataDirectory(String dir) {
    }

    private class TessellationMetaData {
        private String f_table_schema;
        private String f_table_name;
        private String f_geometry_column;
        private double uxMin;
        private double uyMin;
        private double uxMax;
        private double uyMax;
        private int g_nx;
        private int g_ny;
        private int levels;
        private double scale;
        private double shift;
        int columnCount;

        public void setF_Table_Schema(String schema) {
            this.f_table_schema = schema;
        }

        public String getF_Table_Schema() {
            return this.f_table_schema;
        }

        public void setF_Table_Name(String name) {
            this.f_table_name = name;
        }

        public String getF_Table_Name() {
            return this.f_table_name;
        }

        public void setF_Geometry_Column(String col) {
            this.f_geometry_column = col;
        }

        public String getF_Geometry_Column() {
            return this.f_geometry_column;
        }

        public void setUxMin(double val) {
            this.uxMin = val;
        }

        public double getUxMin() {
            return this.uxMin;
        }

        public void setUyMin(double val) {
            this.uyMin = val;
        }

        public double getUyMin() {
            return this.uyMin;
        }

        public void setUxMax(double val) {
            this.uxMax = val;
        }

        public double getUxMax() {
            return this.uxMax;
        }

        public void setUyMax(double val) {
            this.uyMax = val;
        }

        public double getUyMax() {
            return this.uyMax;
        }

        public void setG_nx(int nx) {
            this.g_nx = nx;
        }

        public int getG_nx() {
            return this.g_nx;
        }

        public void setG_ny(int ny) {
            this.g_ny = ny;
        }

        public int getG_ny() {
            return this.g_ny;
        }

        public void setLevels(int levs) {
            this.levels = levs;
        }

        public int getLevels() {
            return this.levels;
        }

        public void setScale(double scl) {
            this.scale = scl;
        }

        public double getScale() {
            return this.scale;
        }

        public void setShift(double shft) {
            this.shift = shft;
        }

        public double getShift() {
            return this.shift;
        }
    }
}

