/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.ext.SDataProvider;
import oracle.mapviewer.share.ext.SDataSet;
import oracle.mapviewer.share.ext.SObject;
import oracle.mapviewer.share.util.LogFactory;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.shape.rtree.Rtree;
import oracle.spatial.util.DBFReaderJGeom;
import oracle.spatial.util.ShapefileFeatureJGeom;
import oracle.spatial.util.ShapefileReaderJGeom;

public class ShapefileDataProvider
implements SDataProvider {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String dataDirectory = null;
    private String globalDataDirectory = null;
    private Point2D filterResolution = null;
    private Hashtable<String, Rtree> dataIndexes = new Hashtable();

    @Override
    public synchronized boolean destroy() {
        this.clearCache();
        return true;
    }

    @Override
    public synchronized String[] getInitParameterNames() {
        return new String[]{"datadir"};
    }

    @Override
    public synchronized String[] getRuntimeParameterNames() {
        return new String[]{"filename", "nodecachesize"};
    }

    @Override
    public synchronized String getRuntimeParameterHintValue(String runtimeParam) {
        if (runtimeParam == null) {
            return null;
        }
        if (runtimeParam.equals("filename")) {
            return "<filedirectory>" + File.separator + "<filename>.shp";
        }
        return null;
    }

    @Override
    public synchronized boolean init(Properties params) {
        this.dataDirectory = null;
        if (params == null) {
            return true;
        }
        this.dataDirectory = params.getProperty("datadir");
        if (this.dataDirectory == null || this.dataDirectory.trim().length() == 0) {
            this.dataDirectory = params.getProperty("DATADIR");
            if (this.dataDirectory == null || this.dataDirectory.trim().length() == 0) {
                log.fine("Init properties does not define \"datadir\" parameter.");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized SDataSet buildDataSet(Rectangle2D queryWin, String[] nonSpatialColumns, String queryCondition, Object[] bindingParameters, Properties params) {
        String fileName = this.getFileNameToUse(params);
        if (fileName == null) {
            return null;
        }
        boolean fullExtent = this.isFullExtent(queryWin);
        String cacheSize = params.getProperty("nodecachesize");
        int nodeCacheSize = 300;
        if (cacheSize != null) {
            try {
                nodeCacheSize = Integer.parseInt(cacheSize);
            }
            catch (Exception ex) {
                nodeCacheSize = 300;
            }
        }
        SDataSet dataset = new SDataSet();
        SObject obj = null;
        DBFReaderJGeom dbfr = null;
        ShapefileReaderJGeom sfh = null;
        String shapefileName = fileName;
        int index = fileName.toLowerCase().indexOf(".shp");
        if (index > -1) {
            shapefileName = fileName.substring(0, index);
        }
        Rtree rtree = null;
        int currentRecord = -1;
        ArrayList entries = new ArrayList();
        long[] objPointers = null;
        boolean hasRtree = false;
        if (!fullExtent) {
            hasRtree = this.isRtreeAvailable(shapefileName);
        }
        try {
            if (!fullExtent && hasRtree) {
                Rtree dataTree = this.dataIndexes.get(shapefileName.toUpperCase());
                if (dataTree.getNodeCacheSize() == nodeCacheSize) {
                    rtree = dataTree;
                } else {
                    rtree = Rtree.open((String)shapefileName, (boolean)true);
                    rtree.setNodeCacheSize(nodeCacheSize);
                    dataTree = rtree;
                }
                log.info("Rtree node cache size: " + rtree.getNodeCacheSize());
                double[][] box = new double[2][2];
                box[0][0] = queryWin.getMinX();
                box[0][1] = queryWin.getMaxX();
                box[1][0] = queryWin.getMinY();
                box[1][1] = queryWin.getMaxY();
                log.info("Tree search window: [X range] " + box[0][0] + "," + box[0][1] + " [Y range] " + box[1][0] + "," + box[1][1]);
                double[] filter = null;
                if (this.filterResolution != null) {
                    filter = new double[]{this.filterResolution.getX(), this.filterResolution.getY()};
                    log.finer("Filter resolution: " + filter[0] + " , " + filter[1]);
                }
                long t1 = System.currentTimeMillis();
                if (rtree.search(box, filter, -1.0, entries)) {
                    long t2 = System.currentTimeMillis();
                    log.info("Found " + entries.size() + " tree records in " + (t2 - t1) + " ms.");
                    if (entries.size() == 0) {
                        SDataSet sDataSet = null;
                        return sDataSet;
                    }
                    objPointers = new long[entries.size()];
                    for (int i = 0; i < entries.size(); ++i) {
                        objPointers[i] = ((Integer)entries.get(i)).longValue();
                    }
                } else {
                    log.warning("Unable to search shapefile indexes.");
                    SDataSet t2 = null;
                    return t2;
                }
            }
            dbfr = new DBFReaderJGeom(shapefileName);
            sfh = new ShapefileReaderJGeom(shapefileName);
            ShapefileFeatureJGeom sf = new ShapefileFeatureJGeom();
            int shpFileType = sfh.getShpFileType();
            int numNonSptCols = 0;
            if (nonSpatialColumns != null) {
                numNonSptCols = nonSpatialColumns.length;
            }
            int numFields = dbfr.numFields();
            int numRecords = dbfr.numRecords();
            String[] colNames = null;
            int[] fieldIndexes = null;
            byte[] fieldTypes = null;
            if (numNonSptCols > 0) {
                fieldTypes = new byte[numNonSptCols];
                fieldIndexes = new int[numNonSptCols];
                block22: for (int colN = 0; colN < numNonSptCols; ++colN) {
                    for (int field = 0; field < numFields; ++field) {
                        String fieldN = dbfr.getFieldName(field);
                        if (!fieldN.equalsIgnoreCase(nonSpatialColumns[colN])) continue;
                        fieldTypes[colN] = dbfr.getFieldType(field);
                        fieldIndexes[colN] = field;
                        continue block22;
                    }
                }
                colNames = ShapefileFeatureJGeom.getOraFieldNames((DBFReaderJGeom)dbfr, (byte[])fieldTypes, (int[])fieldIndexes);
            }
            int error_cnt = 0;
            if (objPointers != null) {
                numRecords = objPointers.length;
            }
            log.info("Reading " + numRecords + " shape records...");
            for (int i = 0; i < numRecords; ++i) {
                Hashtable ht = null;
                if (objPointers == null) {
                    ht = ShapefileFeatureJGeom.fromRecordToFeature((DBFReaderJGeom)dbfr, (ShapefileReaderJGeom)sfh, (String[])colNames, (int[])fieldIndexes, (byte[])fieldTypes, (int)i, (int)0);
                    currentRecord = i;
                } else {
                    ht = ShapefileFeatureJGeom.fromRecordToFeature((DBFReaderJGeom)dbfr, (ShapefileReaderJGeom)sfh, (String[])colNames, (int[])fieldIndexes, (byte[])fieldTypes, (int)((int)(objPointers[i] - 1L)), (int)0);
                    currentRecord = (int)(objPointers[i] - 1L);
                }
                ArrayList<Field> fields = new ArrayList<Field>();
                try {
                    Field[] attrFields;
                    JGeometry geom;
                    int j;
                    Field f;
                    String column;
                    if (shpFileType == 5 || shpFileType == 15 || shpFileType == 25) {
                        if (nonSpatialColumns != null) {
                            block25: for (int l = 0; l < nonSpatialColumns.length; ++l) {
                                column = nonSpatialColumns[l];
                                f = null;
                                for (j = 0; j < colNames.length; ++j) {
                                    if (!column.equalsIgnoreCase(colNames[j])) continue;
                                    if (ht.get(colNames[j]) instanceof String) {
                                        f = Field.createField((String)ht.get(colNames[j]), "string");
                                        f.setName(column);
                                    } else if (ht.get(colNames[j]) instanceof Integer) {
                                        f = new Field((Integer)ht.get(colNames[j]));
                                        f.setName(column);
                                    } else if (ht.get(colNames[j]) instanceof Double) {
                                        f = new Field((Double)ht.get(colNames[j]));
                                        f.setName(column);
                                    }
                                    if (f == null) continue block25;
                                    fields.add(f);
                                    continue block25;
                                }
                            }
                        }
                        if ((geom = (JGeometry)ht.get("geometry")) != null) {
                            attrFields = null;
                            if (fields.size() > 0) {
                                attrFields = fields.toArray(new Field[fields.size()]);
                            }
                            obj = new SObject(geom, attrFields);
                            dataset.addObject(obj);
                            continue;
                        }
                        log.warning("Record " + (i + 1) + " has null geometry. Ignored.");
                        continue;
                    }
                    if (nonSpatialColumns != null) {
                        block27: for (int l = 0; l < nonSpatialColumns.length; ++l) {
                            column = nonSpatialColumns[l];
                            f = null;
                            for (j = 0; j < colNames.length; ++j) {
                                if (!column.equalsIgnoreCase(colNames[j])) continue;
                                if (ht.get(colNames[j]) instanceof String) {
                                    f = Field.createField((String)ht.get(colNames[j]), "string");
                                    f.setName(column);
                                } else if (ht.get(colNames[j]) instanceof Integer) {
                                    f = new Field((Integer)ht.get(colNames[j]));
                                    f.setName(column);
                                } else if (ht.get(colNames[j]) instanceof Double) {
                                    f = new Field((Double)ht.get(colNames[j]));
                                    f.setName(column);
                                }
                                if (f == null) continue block27;
                                fields.add(f);
                                continue block27;
                            }
                        }
                    }
                    if ((geom = (JGeometry)ht.get("geometry")) != null) {
                        attrFields = null;
                        if (fields.size() > 0) {
                            attrFields = fields.toArray(new Field[fields.size()]);
                        }
                        obj = new SObject(geom, attrFields);
                        dataset.addObject(obj);
                        continue;
                    }
                    log.warning("Record " + (i + 1) + " has null geometry. ignored.");
                    continue;
                }
                catch (Exception e) {
                    ++error_cnt;
                    log.warning(e + "\nRecord #" + (i + 1) + " not retrieved.");
                }
            }
        }
        catch (Exception e) {
            log.warning("Exception at record: " + currentRecord);
            log.log(Level.SEVERE, "Exception: ", e);
        }
        finally {
            try {
                if (rtree != null) {
                    rtree.close();
                }
                if (dbfr != null) {
                    dbfr.closeDBF();
                }
                if (sfh != null) {
                    sfh.closeShapefile();
                }
            }
            catch (Exception ex) {}
        }
        log.info("Done.");
        if (dataset.getSize() != 0) return dataset;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Field[] getAttributeList(Properties params) {
        String fileName = this.getFileNameToUse(params);
        if (fileName == null) {
            return null;
        }
        DBFReaderJGeom dbfr = null;
        String shapefileName = fileName;
        int index = fileName.toLowerCase().indexOf(".shp");
        if (index > -1) {
            shapefileName = fileName.substring(0, index);
        }
        Vector<Field> fields = new Vector<Field>();
        try {
            dbfr = new DBFReaderJGeom(shapefileName);
            int numFields = dbfr.numFields();
            for (int field = 0; field < numFields; ++field) {
                Field f = null;
                int javaType = 0;
                switch (dbfr.getFieldType(field)) {
                    case 66: {
                        log.warning("Field type B not yet supported. Attribute ignored.");
                        break;
                    }
                    case 67: 
                    case 76: {
                        javaType = 8;
                        break;
                    }
                    case 68: {
                        javaType = 10;
                        break;
                    }
                    case 71: {
                        log.warning("Field type G not yet supported. Attribute ignored.");
                        break;
                    }
                    case 73: {
                        javaType = 3;
                        break;
                    }
                    case 70: {
                        javaType = 5;
                        break;
                    }
                    case 78: 
                    case 79: {
                        javaType = 6;
                        break;
                    }
                    case 77: {
                        log.warning("Field type M not yet supported");
                        break;
                    }
                    default: {
                        log.warning("Undefined DBF field type (1) " + dbfr.getFieldType(field));
                    }
                }
                if (javaType == 0) continue;
                f = new Field();
                f.setName(dbfr.getFieldName(field).toUpperCase());
                f.setType(javaType);
                fields.add(f);
            }
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            Field[] fieldArray = null;
            return fieldArray;
        }
        finally {
            if (dbfr != null) {
                try {
                    dbfr.closeDBF();
                }
                catch (Exception ex) {}
            }
        }
        if (fields.size() == 0) {
            return null;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    @Override
    public synchronized Rectangle2D getDataExtents(Properties params) {
        String fileName = this.getFileNameToUse(params);
        if (fileName == null) {
            return null;
        }
        String shapefileName = fileName;
        int index = fileName.toLowerCase().indexOf(".shp");
        if (index > -1) {
            shapefileName = fileName.substring(0, index);
        }
        try {
            ShapefileReaderJGeom sfh = new ShapefileReaderJGeom(shapefileName);
            double x1 = sfh.getMinX();
            double x2 = sfh.getMaxX();
            double y1 = sfh.getMinY();
            double y2 = sfh.getMaxY();
            return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return null;
        }
    }

    @Override
    public synchronized boolean buildSpatialIndex(Properties params) {
        String rtreefilename;
        File fl;
        String fileName = this.getFileNameToUse(params);
        if (fileName == null) {
            return false;
        }
        String shapefileName = fileName;
        int index = fileName.toLowerCase().indexOf(".shp");
        if (index > -1) {
            shapefileName = fileName.substring(0, index);
        }
        if ((fl = new File(rtreefilename = shapefileName + ".oix")).exists()) {
            fl.delete();
        }
        log.info("Building RTree in disk...");
        Rtree rtree = Rtree.createPackedShapeRtree((String)shapefileName, (int)2, (int)8192);
        if (rtree == null) {
            log.info("Unable to create RTree in disk.");
            return false;
        }
        log.info("RTree creation is done. Index file is: " + rtreefilename);
        rtree.close();
        return true;
    }

    private synchronized boolean isFullExtent(Rectangle2D queryWin) {
        if (queryWin == null) {
            return true;
        }
        double xl = queryWin.getMinX();
        double yl = queryWin.getMinY();
        double xh = queryWin.getMaxX();
        double yh = queryWin.getMaxY();
        return Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh);
    }

    private synchronized boolean isRtreeAvailable(String shapefileName) {
        if (shapefileName == null) {
            return false;
        }
        if (this.dataIndexes.get(shapefileName.toUpperCase()) != null) {
            return true;
        }
        String rtreefilename = shapefileName + ".oix";
        File fl = new File(rtreefilename);
        if (!fl.exists()) {
            log.info("Building RTree in disk...");
            Rtree rtree = Rtree.createPackedShapeRtree((String)shapefileName, (int)2, (int)8192);
            if (rtree == null) {
                log.warning("Unable to create RTree in disk. Will do a sequential search.");
                return false;
            }
            log.info("RTree creation is done.");
            rtree.close();
            this.dataIndexes.put(shapefileName.toUpperCase(), rtree);
            return true;
        }
        try {
            Rtree rtree = Rtree.open((String)shapefileName, (boolean)true);
            rtree.close();
            this.dataIndexes.put(shapefileName.toUpperCase(), rtree);
            return true;
        }
        catch (Exception ex) {
            log.warning("Unable to open RTree file. Will do a sequential search.");
            return false;
        }
    }

    public synchronized void setFilterResolution(Point2D filter) {
        this.filterResolution = filter;
    }

    public synchronized Point2D getFilterResolution() {
        return this.filterResolution;
    }

    private synchronized String getFileNameToUse(Properties params) {
        if (params == null) {
            return null;
        }
        String fileName = params.getProperty("filename");
        if (!(fileName != null && fileName.trim().length() != 0 || (fileName = params.getProperty("FILENAME")) != null && fileName.trim().length() != 0)) {
            log.severe("Input properties must define \"filename\" parameter.");
            return null;
        }
        String fileNameOut = null;
        String directory = null;
        File fl = new File(fileName);
        if (!fl.exists()) {
            File flg;
            int lastindex;
            log.warning("Can not access file from original path: " + fileName);
            if (this.dataDirectory == null && this.globalDataDirectory == null) {
                return null;
            }
            if (this.dataDirectory != null) {
                log.finest("Trying provider local directory: " + this.dataDirectory);
                fileNameOut = null;
                directory = this.dataDirectory;
                lastindex = fileName.lastIndexOf(File.separator);
                fileNameOut = lastindex == -1 ? (directory.endsWith(File.separator) ? directory + fileName : directory + File.separator + fileName) : (directory.endsWith(File.separator) ? directory + fileName.substring(lastindex + 1, fileName.length()) : directory + File.separator + fileName.substring(lastindex + 1, fileName.length()));
                flg = new File(fileNameOut);
                if (!flg.exists()) {
                    log.warning("File can not be accessed on provider local data directory.");
                    fileNameOut = null;
                }
            }
            if (fileNameOut == null && this.globalDataDirectory != null) {
                log.finest("Trying provider global directory: " + this.globalDataDirectory);
                directory = this.globalDataDirectory;
                lastindex = fileName.lastIndexOf(File.separator);
                fileNameOut = lastindex == -1 ? (directory.endsWith(File.separator) ? directory + fileName : directory + File.separator + fileName) : (directory.endsWith(File.separator) ? directory + fileName.substring(lastindex + 1, fileName.length()) : directory + File.separator + fileName.substring(lastindex + 1, fileName.length()));
                flg = new File(fileNameOut);
                if (!flg.exists()) {
                    log.severe("File can not be accessed on providers local or global data directory. Copy files there.");
                    return null;
                }
            }
            log.info("Provider data directory being used: " + directory);
            log.info("File to be processed: " + fileNameOut);
        } else {
            fileNameOut = fileName;
        }
        return fileNameOut;
    }

    @Override
    public synchronized void clearCache() {
        this.dataIndexes.clear();
    }

    @Override
    public synchronized boolean canBuildSpatialIndex() {
        return true;
    }

    @Override
    public synchronized String[] getParametersToQuerySpatialMetadata() {
        return null;
    }

    @Override
    public synchronized String[][] getSpatialTables(Properties params) {
        return null;
    }

    @Override
    public String getGlobalDataDirectory() {
        return this.globalDataDirectory;
    }

    @Override
    public void setGlobalDataDirectory(String dir) {
        this.globalDataDirectory = dir;
    }
}

