/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import oracle.sdovis.CoordArray;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.Proj;
import oracle.sdovis.Spheroid;

public class ProjRobinson
implements Proj {
    private static final double[][] Constants = new double[][]{{1.0, 0.0}, {0.9986, 0.062}, {0.9954, 0.124}, {0.99, 0.186}, {0.9822, 0.248}, {0.973, 0.31}, {0.96, 0.372}, {0.9427, 0.434}, {0.9216, 0.4958}, {0.8962, 0.5571}, {0.8679, 0.6176}, {0.835, 0.6769}, {0.7986, 0.7346}, {0.7597, 0.7903}, {0.7186, 0.8435}, {0.6732, 0.8936}, {0.6213, 0.9394}, {0.5722, 0.9761}, {0.5322, 1.0}, {0.5322, 1.0}};
    private double R;
    private double clat;
    private double clon;
    private double easting;
    private double northing;
    private double MultX;
    private double MultY;
    private JSDOGeometry bg;

    public ProjRobinson(double cLongitude) {
        this(Spheroid.clarke1866.getSemiMajorAxis(), cLongitude, 0.0);
    }

    public ProjRobinson(double cLongitude, double cLatitude) {
        this(Spheroid.clarke1866.getSemiMajorAxis(), cLongitude, cLatitude);
    }

    public ProjRobinson(double earthRadius, double cLongitude, double cLatitude) {
        this.R = earthRadius;
        this.clon = Proj.util.Clip(cLongitude * (Math.PI / 180), Math.PI * -2, Math.PI * 2);
        this.clat = cLatitude * (Math.PI / 180);
        this.init();
    }

    @Override
    public double[] save() {
        return new double[]{this.getProjId(), this.R, this.clon, this.clat};
    }

    public double getR() {
        return this.R;
    }

    @Override
    public Proj.P2 getCenter() {
        return new Proj.P2(this.clon * 57.29577951308232, this.clat * 57.29577951308232);
    }

    @Override
    public Proj.P2 getOpposite() {
        return null;
    }

    @Override
    public int getProjId() {
        return 3;
    }

    @Override
    public Rectangle2D getBoundingBox(Rectangle2D dataView, Rectangle2D deviceView) {
        double size = dataView.getHeight();
        Proj.P2 res = new Proj.P2();
        this.forward(dataView.getCenterX(), Proj.util.Clip(dataView.getCenterY() + size / 2.0, -90.0, 90.0), res);
        double hh = res.y - this.northing;
        return new Rectangle2D.Double(this.northing - hh, this.easting - hh, hh * 2.05, hh * 2.05);
    }

    @Override
    public final boolean forward(double lon, double lat, Proj.P2 result) {
        double lambda = Proj.util.Clip(lon, -360.0, 360.0) * (Math.PI / 180);
        double phi = Proj.util.Clip(lat, -90.0, 90.0);
        double index = Math.abs(phi) / 5.0;
        int i = (int)index;
        double fraction = index - (double)i;
        double X = Constants[i][0] + fraction * (Constants[i + 1][0] - Constants[i][0]);
        double Y = Constants[i][1] + fraction * (Constants[i + 1][1] - Constants[i][1]);
        double x = this.MultX * X * Proj.util.adjustLon(lambda - this.clon);
        double y = this.MultY * Y;
        if (phi < 0.0) {
            y = -y;
        }
        result.set(x + this.easting, y + this.northing);
        return true;
    }

    @Override
    public final boolean inverse(double x, double y, Proj.P2 result) {
        double X;
        double phi;
        double d;
        double destX = x - this.easting;
        double destY = y - this.northing;
        double Y = Math.abs(destY / this.MultY);
        if (d >= 1.0) {
            phi = 90.0;
            X = Constants[18][0];
        } else {
            int i = 0;
            for (int j = 0; j < 19; ++j) {
                if (!(Constants[j + 1][1] > Y)) continue;
                i = j;
                break;
            }
            double fraction = (Y - Constants[i][1]) / (Constants[i + 1][1] - Constants[i][1]);
            phi = ((double)i + fraction) * 5.0;
            X = Constants[i][0] + fraction * (Constants[i + 1][0] - Constants[i][0]);
        }
        double lambda = destX / (X * this.MultX) + this.clon;
        destX = Proj.util.Clip(lambda, Math.PI * -2, Math.PI * 2);
        destY = destY < 0.0 ? -phi : phi;
        double lon = destX * 57.29577951308232;
        if (lon > 180.0) {
            lon -= 360.0;
        } else if (lon <= -180.0) {
            lon += 360.0;
        }
        double lat = destY;
        result.set(lon, lat);
        return true;
    }

    @Override
    public void setOffset(double easting, double northing) {
        this.easting = easting;
        this.northing = northing;
        this.createBoundingGeom();
    }

    @Override
    public Proj.P2 getOffset() {
        return new Proj.P2(this.easting, this.northing);
    }

    public boolean isOddPoint(double x, double y) {
        return false;
    }

    @Override
    public double[] getBoundingGeom() {
        return null;
    }

    @Override
    public double[] getParallel(double y, double density) {
        CoordArray ca = new CoordArray(1440);
        int i = 360;
        int k = 0;
        while (i >= -360) {
            ca.add(i, y);
            --i;
            ++k;
        }
        return ca.getAll();
    }

    private void init() {
        this.MultX = 0.8487 * this.R;
        this.MultY = 1.3523 * this.R;
        this.createBoundingGeom();
    }

    private void createBoundingGeom() {
    }
}

