/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import oracle.sdovis.DataException;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.ImageThemeProducer;

public class ImageTheme
extends Theme {
    public static final String FORMAT_GIF = "GIF";
    public static final String FORMAT_TIFF = "TIFF";
    public static final String FORMAT_JPEG = "JPEG";
    public static final String FORMAT_PNG = "PNG";
    public static final String FORMAT_ECW = "ECW";

    public ImageTheme(String name, String dataSource, String query) {
        ImageThemeDefinition def = new ImageThemeDefinition();
        def.setName(name);
        def.setDataSourceName(dataSource);
        def.setImageQuery(query);
        DBDataSource ds = (DBDataSource)DSManager.get(dataSource);
        def.set9i(ds.is9i());
        def.setPredefined(false);
        this.setDefinition(def);
        this.setProducer(new ImageThemeProducer(this));
    }

    public ImageTheme(ImageThemeDefinition def) {
        this.setDefinition(def);
        this.setProducer(new ImageThemeProducer(this));
    }

    public ImageTheme() {
    }

    @Override
    public void destroy() {
        this.decorator = null;
        this.producer.destroy();
        this.definition = null;
    }

    @Override
    public boolean isTextLabelPresent() {
        return false;
    }

    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        return this.getProducer().prepareData(queryWin, vc);
    }

    public byte[][] getImages() {
        return ((ImageThemeProducer)this.producer).getImages();
    }

    public double[][] getMBRs() {
        return ((ImageThemeProducer)this.producer).getMBRs();
    }
}

