/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SRSRowData;
import oracle.sdovis.SRSStore;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.util.IntHashtable;

public class DBSRSStore
implements SRSStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String dataSource;

    public DBSRSStore(String dataSrc) {
        this.dataSource = dataSrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SRSRowData getSRSRowData(int srid) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(this.dataSource, null);
            String query = "select cs_name,srid, auth_srid, auth_name, wktext from MDSYS.cs_srs where srid=?";
            stmt = conn.prepareStatement(query);
            stmt.setInt(1, srid);
            rs = stmt.executeQuery();
            if (rs.next()) {
                SRSRowData row = new SRSRowData();
                row.csName = rs.getString(1);
                row.srid = srid;
                row.authSrid = rs.getInt(3);
                row.authName = rs.getString(4);
                row.wktext = rs.getString(5);
                SRSRowData sRSRowData = row;
                return sRSRowData;
            }
            SRSRowData sRSRowData = null;
            return sRSRowData;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SRSRowData sRSRowData = null;
            return sRSRowData;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int loadGeodeticSrids(IntHashtable geodeticSrids) {
        geodeticSrids.clear();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int count = 0;
        try {
            conn = DSUtil.getDBConnection(this.dataSource, null);
            ps = conn.prepareStatement("SELECT srid FROM MDSYS.cs_srs where WKTEXT like 'GEOGCS%'");
            ps.setFetchSize(100);
            rs = ps.executeQuery();
            while (rs.next()) {
                geodeticSrids.put(rs.getInt(1), (Object)"");
                ++count;
            }
            log.finest("Number of geodetic srids loaded: " + geodeticSrids.size() + ".");
            int n = count;
            return n;
        }
        catch (Exception ex) {
            log.finest("falling to fetch geodetic srids.");
            log.log(Level.WARNING, ex.getMessage(), ex);
            int n = 0;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e) {}
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

