/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SharedUtils {
    public static List splitBy(String str, String delim) {
        StringTokenizer tk = new StringTokenizer(str, delim);
        ArrayList<String> al = new ArrayList<String>();
        while (tk.hasMoreTokens()) {
            al.add(tk.nextToken());
        }
        return al;
    }

    public static double[] parseBBox2D(String bbox) {
        String bs = bbox.trim();
        if (bs.endsWith(",")) {
            bs = bs.substring(0, bs.length() - 1);
        }
        int idx = bs.indexOf(44);
        String vs = null;
        double[] res = new double[4];
        int i = 0;
        while (idx > 0) {
            vs = bs.substring(0, idx);
            if ((vs = vs.trim()).length() > 0) {
                res[i] = Double.parseDouble(vs);
                ++i;
            }
            bs = bs.substring(idx + 1);
            idx = bs.indexOf(44);
        }
        if (i != 3) {
            throw new IllegalArgumentException("Invalid bbox string found: " + bbox);
        }
        res[i] = Double.parseDouble(bs);
        return res;
    }

    public static int countBindingVariables(String query) {
        if (query == null) {
            return 0;
        }
        boolean quoteStarted = false;
        int count = 0;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (!quoteStarted) {
                int j;
                if (c == '\'') {
                    quoteStarted = true;
                    continue;
                }
                if (c != ':') continue;
                ++count;
                for (j = i + 1; j < query.length() && Character.isWhitespace(query.charAt(j)); ++j) {
                }
                i = j;
                continue;
            }
            if (c != '\'') continue;
            if (i + 1 < query.length() && query.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            quoteStarted = false;
        }
        return count;
    }

    public static String[] getBindingVariablesNames(String query) {
        if (query == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        boolean quoteStarted = false;
        int count = 0;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (!quoteStarted) {
                int j;
                if (c == '\'') {
                    quoteStarted = true;
                    continue;
                }
                if (c != ':') continue;
                ++count;
                boolean found = false;
                for (j = i + 1; j < query.length(); ++j) {
                    if (Character.isLetterOrDigit(query.charAt(j))) continue;
                    names.add(query.substring(i + 1, j));
                    found = true;
                    break;
                }
                if (!found) {
                    names.add(query.substring(i + 1, j));
                }
                i = j;
                continue;
            }
            if (c != '\'') continue;
            if (i + 1 < query.length() && query.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            quoteStarted = false;
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }
}

