/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.awt.Color;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.AbstractBucketStyleModel;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.PieSliceInfo;

public class VariablePieChartStyleModel
extends AbstractBucketStyleModel {
    static final long serialVersionUID = 4360058909925091486L;
    SizeDefinition2D pieSize = new SizeDefinition2D(10.0, 5.0, null);
    int numSlices = 0;
    PieSliceInfo[] pieSlices = null;
    Color strokeColor = Color.black;

    public VariablePieChartStyleModel() {
        this.type = 9;
        this.bucketSeries = new BucketSeries();
    }

    public VariablePieChartStyleModel(BucketSeries bs) {
        this.type = 9;
        this.bucketSeries = bs;
    }

    @Override
    public Object clone() {
        VariablePieChartStyleModel obj = (VariablePieChartStyleModel)super.clone();
        obj.setSizes(this.pieSize);
        return obj;
    }

    public void setSizes(SizeDefinition2D size) {
        this.pieSize = new SizeDefinition2D(10.0, 5.0, null);
        if (size == null) {
            return;
        }
        this.pieSize.setSize(size.getWidth(), size.getHeight());
        this.pieSize.setUnit(size.getUnit());
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    @Override
    public String toXMLString() {
        String unit = "";
        if (this.pieSize.getUnit() != null && !this.pieSize.getUnit().equalsIgnoreCase("px")) {
            unit = this.pieSize.getUnit();
        }
        String startStr = StyleUtils.getUSLocaleFormat(this.pieSize.getWidth());
        startStr = StyleUtils.cleanDecimalZeros(startStr, 1);
        String incStr = StyleUtils.getUSLocaleFormat(this.pieSize.getHeight());
        incStr = StyleUtils.cleanDecimalZeros(incStr, 1);
        if (this.pieSize.isPixelUnit()) {
            startStr = String.valueOf((int)this.pieSize.getWidth());
            incStr = String.valueOf((int)this.pieSize.getHeight());
        }
        String xmlDef = "<?xml version=\"1.0\" ?>\n";
        xmlDef = xmlDef + "<AdvancedStyle>\n  <VariablePieChartStyle";
        xmlDef = xmlDef + " startradius=\"" + startStr + unit + "\"";
        xmlDef = xmlDef + " increment=\"" + incStr + unit + "\"";
        if (this.strokeColor != null && (this.strokeColor.getRed() != 0 || this.strokeColor.getGreen() != 0 || this.strokeColor.getBlue() != 0 || this.strokeColor.getAlpha() != 255)) {
            String stroke = " stroke=\"" + StyleUtils.getHexidecimalString(this.strokeColor) + "\"";
            int alpha = this.strokeColor.getAlpha();
            if (alpha < 255) {
                stroke = stroke + " stroke-opacity=\"" + alpha + "\"";
            }
            xmlDef = xmlDef + stroke;
        }
        xmlDef = xmlDef + ">\n";
        if (this.pieSlices != null) {
            for (int i = 0; i < this.pieSlices.length; ++i) {
                PieSliceInfo _psi = this.pieSlices[i];
                xmlDef = xmlDef + "       <PieSlice name=\"" + XMLUtil.replaceXMLEntities(_psi.name) + "\"";
                if (_psi.color != null) {
                    xmlDef = xmlDef + " color=\"" + StyleUtils.getHexidecimalString(_psi.color) + "\"";
                }
                xmlDef = xmlDef + " />\n";
            }
        }
        xmlDef = xmlDef + this.bucketSeries.toXMLString();
        xmlDef = xmlDef + "\n   </VariablePieChartStyle>\n</AdvancedStyle>\n";
        return xmlDef;
    }

    public void setStartRadius(int startSize) {
        this.pieSize.setWidth(startSize);
    }

    public void setStartRadius(double startSize) {
        this.pieSize.setWidth(startSize);
    }

    public int getStartRadius() {
        return (int)this.pieSize.getWidth();
    }

    public double getDoubleStartRadius() {
        return this.pieSize.getWidth();
    }

    public void setIncrement(int increment) {
        this.pieSize.setHeight(increment);
    }

    public void setIncrement(double increment) {
        this.pieSize.setHeight(increment);
    }

    public int getIncrement() {
        return (int)this.pieSize.getHeight();
    }

    public double getDoubleIncrement() {
        return this.pieSize.getHeight();
    }

    public String getRadiusUnit() {
        return this.pieSize.getUnit();
    }

    public void setRadiusUnit(String unit) {
        this.pieSize.setUnit(unit);
    }

    public void setNumSlices(int numSlices) {
        this.numSlices = numSlices;
    }

    public int getNumSlices() {
        return this.numSlices;
    }

    public void setPieSlices(PieSliceInfo[] pieSlices) {
        this.pieSlices = pieSlices;
        this.numSlices = pieSlices == null ? 0 : pieSlices.length;
    }

    public PieSliceInfo[] getPieSlices() {
        return this.pieSlices;
    }

    public PieSliceInfo getPieSlice(int index) {
        return this.pieSlices != null ? this.pieSlices[index] : null;
    }

    @Override
    public String[] getStyleDependency() {
        return null;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor == null ? Color.black : strokeColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }
}

