/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;

public class CollectionStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = -2055664308810750671L;
    private Vector styleParameters = null;
    private Object defaultStyle = null;
    public static String POINT_SHAPE = "POINT";
    public static String LINE_SHAPE = "LINE";
    public static String POLYGON_SHAPE = "POLYGON";

    public CollectionStyleModel() {
        this.type = 9;
        this.styleParameters = new Vector();
    }

    @Override
    public Object clone() {
        CollectionStyleModel obj = (CollectionStyleModel)super.clone();
        return obj;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    public int getNumberOfStyles() {
        return this.styleParameters.size();
    }

    public boolean addStyle(String name, Object style, String shapeType) {
        if (name == null) {
            return false;
        }
        StyleParameters param = new StyleParameters();
        param.name = name;
        param.style = style == null ? this.defaultStyle : style;
        param.shape = shapeType;
        this.styleParameters.add(param);
        return true;
    }

    public void removeStyle(String name) {
        if (name == null) {
            return;
        }
        int index = -1;
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters param = (StyleParameters)this.styleParameters.get(i);
            if (!param.name.equalsIgnoreCase(name)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.styleParameters.remove(index);
        }
    }

    public boolean containsStyle(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters param = (StyleParameters)this.styleParameters.get(i);
            if (!param.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public String[] getStyleNames() {
        int size = this.styleParameters.size();
        if (size == 0) {
            return null;
        }
        String[] names = new String[size];
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters param = (StyleParameters)this.styleParameters.get(i);
            names[i] = param.name;
        }
        return names;
    }

    public Object getStyle(String name) {
        Object style = null;
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters param = (StyleParameters)this.styleParameters.get(i);
            if (!param.name.equalsIgnoreCase(name)) continue;
            style = param.style;
            break;
        }
        return style;
    }

    public boolean setStyle(String name, Object style) {
        if (name == null || style == null) {
            return false;
        }
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters param = (StyleParameters)this.styleParameters.get(i);
            if (!param.name.equalsIgnoreCase(name)) continue;
            param.style = style;
            return true;
        }
        return false;
    }

    public String getStyleShape(String name) {
        String shape = null;
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters param = (StyleParameters)this.styleParameters.get(i);
            if (!param.name.equalsIgnoreCase(name)) continue;
            shape = param.shape;
            break;
        }
        return shape;
    }

    public boolean setStyleShape(String name, String shape) {
        if (name == null || shape == null) {
            return false;
        }
        if (!(shape.equalsIgnoreCase(POINT_SHAPE) || shape.equalsIgnoreCase(LINE_SHAPE) || shape.equalsIgnoreCase(POLYGON_SHAPE))) {
            return false;
        }
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters param = (StyleParameters)this.styleParameters.get(i);
            if (!param.name.equalsIgnoreCase(name)) continue;
            param.shape = shape;
            return true;
        }
        return false;
    }

    @Override
    public String toXMLString() {
        String xmlDef = "<?xml version=\"1.0\" ?>\n";
        xmlDef = xmlDef + "<AdvancedStyle>\n  <CollectionStyle>\n";
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters param = (StyleParameters)this.styleParameters.get(i);
            xmlDef = xmlDef + "  <style name=\"" + XMLUtil.replaceXMLEntities(param.name) + "\"";
            xmlDef = param.shape != null ? xmlDef + " shape=\"" + XMLUtil.replaceXMLEntities(param.shape) + "\" />\n" : xmlDef + "/>\n";
        }
        xmlDef = xmlDef + "  </CollectionStyle>\n</AdvancedStyle>";
        return xmlDef;
    }

    public String getStyleName(int index) {
        if (index < 0 || index >= this.styleParameters.size()) {
            return null;
        }
        StyleParameters param = (StyleParameters)this.styleParameters.get(index);
        return param.name;
    }

    public Object getStyle(int index) {
        if (index < 0 || index >= this.styleParameters.size()) {
            return null;
        }
        StyleParameters param = (StyleParameters)this.styleParameters.get(index);
        return param.style;
    }

    public String getStyleShape(int index) {
        if (index < 0 || index >= this.styleParameters.size()) {
            return null;
        }
        StyleParameters param = (StyleParameters)this.styleParameters.get(index);
        return param.shape;
    }

    public void setDefaultStyle(Object defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public Object getDefaultStyle() {
        return this.defaultStyle;
    }

    @Override
    public String[] getStyleDependency() {
        ArrayList<String> depStyles = new ArrayList<String>();
        if (this.defaultStyle != null) {
            // empty if block
        }
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters param = (StyleParameters)this.styleParameters.get(i);
            if (param.name == null || depStyles.contains(param.name)) continue;
            depStyles.add(param.name);
        }
        if (depStyles.size() == 0) {
            return null;
        }
        return depStyles.toArray(new String[depStyles.size()]);
    }

    private static class StyleParameters
    implements Serializable {
        static final long serialVersionUID = 1467133582389982868L;
        public String name = null;
        public Object style = null;
        public String shape = null;
    }
}

