/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.util.SharedUtils;

public class StyleUtils {
    public static int getTypeCodeFromName(String typeName) {
        if ("COLOR".equals(typeName = typeName.toUpperCase())) {
            return 1;
        }
        if ("AREA".equals(typeName)) {
            return 4;
        }
        if ("LINE".equals(typeName)) {
            return 3;
        }
        if ("MARKER".equals(typeName)) {
            return 2;
        }
        if ("TEXT".equals(typeName)) {
            return 5;
        }
        if ("ADVANCED".equals(typeName)) {
            return 9;
        }
        if ("CUSTOM".equals(typeName)) {
            return 100;
        }
        if ("TTF".equals(typeName)) {
            return 99;
        }
        return 0;
    }

    public static String getTypeNameFromCode(int typeCode) {
        switch (typeCode) {
            case 9: {
                return "ADVANCED";
            }
            case 4: {
                return "AREA";
            }
            case 1: {
                return "COLOR";
            }
            case 100: {
                return "CUSTOM";
            }
            case 3: {
                return "LINE";
            }
            case 2: {
                return "MARKER";
            }
            case 5: {
                return "TEXT";
            }
            case 99: {
                return "TTF";
            }
        }
        return null;
    }

    public static String getHexidecimalString(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        String s = "#";
        int i = (r >> 4) % 16;
        char ch = i < 10 ? (char)(48 + i) : (char)(65 + (i - 10));
        s = s + ch;
        i = r % 16;
        ch = i < 10 ? (char)(48 + i) : (char)(65 + (i - 10));
        s = s + ch;
        i = (g >> 4) % 16;
        ch = i < 10 ? (char)(48 + i) : (char)(65 + (i - 10));
        s = s + ch;
        i = g % 16;
        ch = i < 10 ? (char)(48 + i) : (char)(65 + (i - 10));
        s = s + ch;
        i = (b >> 4) % 16;
        ch = i < 10 ? (char)(48 + i) : (char)(65 + (i - 10));
        s = s + ch;
        i = b % 16;
        ch = i < 10 ? (char)(48 + i) : (char)(65 + (i - 10));
        s = s + ch;
        return s;
    }

    public static int getStyleTypeFromXML(String xml) {
        if (xml == null) {
            return 0;
        }
        int idx = xml.indexOf("class=");
        int idx2 = 0;
        if (idx < 0) {
            int adv = xml.indexOf("AdvancedStyle");
            if (adv < 0) {
                return 0;
            }
            return 9;
        }
        idx2 = idx += 7;
        try {
            while (xml.charAt(idx2++) != '\"') {
            }
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
        String cls = xml.substring(idx, idx2 - 1);
        if (cls == null || cls.length() < 4) {
            return 0;
        }
        cls = cls.toUpperCase();
        try {
            if (cls.equals("COLOR")) {
                return 1;
            }
            if (cls.equals("LINE")) {
                return 3;
            }
            if (cls.equals("TEXT")) {
                return 5;
            }
            if (cls.equals("MARKER")) {
                return 2;
            }
            if (cls.equals("AREA")) {
                return 4;
            }
            return 0;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return 0;
        }
    }

    public static Color getColor(String color) {
        if (color == null || color.length() <= 0) {
            return null;
        }
        Color tc = null;
        if (color.indexOf("#") != -1 || color.indexOf("0x") != -1) {
            try {
                tc = Color.decode(color);
            }
            catch (Exception e) {
                return null;
            }
        } else if (color.toUpperCase().equals("BLACK")) {
            tc = Color.black;
        } else if (color.toUpperCase().equals("RED")) {
            tc = Color.red;
        } else if (color.toUpperCase().equals("GREEN")) {
            tc = Color.green;
        } else if (color.toUpperCase().equals("BLUE")) {
            tc = Color.blue;
        } else if (color.toUpperCase().equals("YELLOW")) {
            tc = Color.yellow;
        } else if (color.toUpperCase().equals("WHITE")) {
            tc = Color.white;
        } else if (color.toUpperCase().equals("PINK")) {
            tc = Color.pink;
        } else if (color.toUpperCase().equals("MAGENTA")) {
            tc = Color.magenta;
        } else if (color.toUpperCase().equals("ORANGE")) {
            tc = Color.orange;
        } else if (color.toUpperCase().equals("GRAY")) {
            tc = Color.gray;
        } else if (color.toUpperCase().equals("LIGHTGRAY")) {
            tc = Color.lightGray;
        } else if (color.toUpperCase().equals("CYAN")) {
            tc = Color.cyan;
        } else if (color.toUpperCase().equals("US MAP YELLOW")) {
            tc = new Color(0xFFFFA5);
        } else {
            if (color.toUpperCase().equals("NONE")) {
                return null;
            }
            return null;
        }
        return tc;
    }

    public static Color getColor(String name, String str) {
        String color = StyleUtils.getNamedString(str, name);
        if (color == null || color.length() <= 0) {
            return null;
        }
        String opaName = name + "-opacity";
        int opacity = StyleUtils.getColorOpacity(opaName, str);
        Color tc = StyleUtils.getColor(color);
        if (tc == null) {
            return null;
        }
        if (opacity >= 0 && opacity <= 255) {
            return new Color(tc.getRed(), tc.getGreen(), tc.getBlue(), opacity);
        }
        return tc;
    }

    public static int getColorOpacity(String name, String str) {
        String opa = StyleUtils.getNamedString(str, name);
        if (opa == null || opa.length() <= 0) {
            return 255;
        }
        if ((opa = opa.trim()).indexOf("#") != -1) {
            Integer i = Integer.decode(opa);
            return i;
        }
        if ("1".equals(opa)) {
            return 255;
        }
        if ("0".equals(opa)) {
            return 0;
        }
        if (opa.indexOf(".") >= 0) {
            double v = Double.parseDouble(opa);
            if (v < 1.0 && v > 0.0) {
                return (int)(255.0 * v);
            }
            return 255;
        }
        return Integer.parseInt(opa);
    }

    public static float getStrokeWidth(String svgStyle) {
        String sw = StyleUtils.getNamedString(svgStyle, "stroke-width");
        if (sw == null || sw.length() <= 0) {
            return 1.0f;
        }
        return Float.valueOf(sw.trim()).floatValue();
    }

    public static SizeDefinition getStrokeWidthSize(String svgStyle) {
        String sw = StyleUtils.getNamedString(svgStyle, "stroke-width");
        if (sw == null || sw.length() <= 0) {
            return null;
        }
        return SizeDefinition.parse(sw.trim());
    }

    public static String getNamedString(String style, String name) {
        String sw;
        char tc;
        if (style == null) {
            return null;
        }
        int idx = style.indexOf(name);
        if (idx < 0) {
            return null;
        }
        while (idx > 0 && (tc = style.charAt(idx - 1)) != ';' && !Character.isWhitespace(tc)) {
            if ((idx = style.indexOf(name, idx + 1)) >= 0) continue;
            return null;
        }
        String s2 = style.substring(idx += name.length() + 1, style.length());
        int idx2 = s2.indexOf(";");
        if ((sw = idx2 < 0 ? style.substring(idx, style.length()) : style.substring(idx, idx + idx2)) == null || sw.length() <= 0) {
            return null;
        }
        return sw;
    }

    public static Color getColorFromRGB(String rgb) {
        if (rgb == null) {
            return null;
        }
        int ini = rgb.toLowerCase().indexOf("rgb(");
        if (ini == -1) {
            return null;
        }
        int end = rgb.indexOf(")");
        if (end == -1) {
            return null;
        }
        String c = rgb.substring(ini + 4, end);
        List cl = SharedUtils.splitBy(c, ",");
        if (cl == null || cl.size() != 3) {
            return null;
        }
        try {
            int red = Integer.parseInt(cl.get(0).toString());
            int green = Integer.parseInt(cl.get(1).toString());
            int blue = Integer.parseInt(cl.get(2).toString());
            return new Color(red, green, blue);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String cleanDecimalZeros(String value, int fromDecIndex) {
        if (value == null) {
            return null;
        }
        String defaultPattern = "0.";
        String number = value;
        int dotIndex = number.indexOf(".");
        if (dotIndex == -1) {
            return number;
        }
        int strLen = number.length();
        int ndecs = 0;
        for (int i = dotIndex + 1; i < strLen; ++i) {
            defaultPattern = defaultPattern + "0";
            ++ndecs;
        }
        int index = 1;
        if (fromDecIndex > 0) {
            index += fromDecIndex + 1;
        }
        while (index <= ndecs + 1) {
            if (number.endsWith(defaultPattern.substring(index))) {
                return number.substring(0, dotIndex + index - 1);
            }
            ++index;
        }
        return number;
    }

    public static String getUSLocaleFormat(double value) {
        if (Double.isNaN(value)) {
            return null;
        }
        NumberFormat f = NumberFormat.getInstance(Locale.US);
        if (f instanceof DecimalFormat) {
            ((DecimalFormat)f).applyPattern("0.000");
            String df = f.format(value);
            return df;
        }
        return String.valueOf(value);
    }

    public static Color[] createTwoStopGradient(Color one, Color two, int numSteps, int alpha) {
        if (alpha < 0 || alpha > 255) {
            alpha = 255;
        }
        int r1 = one.getRed();
        int g1 = one.getGreen();
        int b1 = one.getBlue();
        int r2 = two.getRed();
        int g2 = two.getGreen();
        int b2 = two.getBlue();
        int newR = 0;
        int newG = 0;
        int newB = 0;
        Color[] gradientColors = new Color[numSteps];
        for (int i = 0; i < numSteps; ++i) {
            double iNorm = (double)i / (double)numSteps;
            newR = (int)((double)r1 + iNorm * (double)(r2 - r1));
            newG = (int)((double)g1 + iNorm * (double)(g2 - g1));
            newB = (int)((double)b1 + iNorm * (double)(b2 - b1));
            gradientColors[i] = new Color(newR, newG, newB, alpha);
        }
        return gradientColors;
    }

    public static Color[] createMultiStopGradient(Color[] colors, int numSteps, int alpha) {
        if (alpha < 0 || alpha > 255) {
            alpha = 255;
        }
        int numSegments = colors.length - 1;
        int gradientIndex = 0;
        Color[] gradient = new Color[numSteps];
        if (numSegments <= 0) {
            throw new IllegalArgumentException("You must pass in at least 2 colors in the array!");
        }
        for (int segment = 0; segment < numSegments; ++segment) {
            Color[] c = StyleUtils.createTwoStopGradient(colors[segment], colors[segment + 1], numSteps / numSegments, alpha);
            for (int i = 0; i < c.length; ++i) {
                gradient[gradientIndex++] = c[i];
            }
        }
        if (gradientIndex < numSteps) {
            while (gradientIndex < numSteps) {
                gradient[gradientIndex] = colors[colors.length - 1];
                ++gradientIndex;
            }
        }
        return gradient;
    }
}

