/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.sdovis.util.Util;

public class MarkerStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 6465985930521778440L;
    public static final int MARKER_POLYGON = 1;
    public static final int MARKER_POLYLINE = 2;
    public static final int MARKER_CIRCLE = 3;
    public static final int MARKER_RECT = 4;
    public static final int MARKER_IMAGE = 5;
    public static final int MARKER_TTF = 6;
    public static final int MARKER_SVG = 7;
    public static final double NO_ROTATION = 0.0;
    public static final int OTHER = -1;
    public static final int GIF = 0;
    public static final int JPG = 1;
    public static final int PNG = 2;
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    int markerType = 0;
    byte[] markerImageBinary = null;
    int markerImageType = 0;
    Font labelFont = null;
    SizeDefinition labelFontSize = new SizeDefinition(12.0, null);
    Color labelFontColor = Color.white;
    SizeDefinition2D labelOffset = new SizeDefinition2D();
    double[] vector = null;
    Color vectorFillColor = Color.gray;
    Color vectorStrokeColor = Color.black;
    Color backgroundColor = null;
    float vectorStrokeWidth = 1.0f;
    TruetypeFont ttf = null;
    int glyphCharCode = 0;
    SizeDefinition2D markerSize = new SizeDefinition2D();
    double ox = 1.0;
    double oy = 0.0;
    double oz = 0.0;
    double rotation = 0.0;
    String url = null;
    String urlFormat = "gif";
    String urlColumn = null;
    double[] anchorPoint = new double[]{0.5, 0.5};
    double[] svgNaturalSize = null;
    String rawSVGString = null;

    public MarkerStyleModel() {
        this.type = 2;
    }

    @Override
    public Object clone() {
        MarkerStyleModel obj = (MarkerStyleModel)super.clone();
        if (this.vector != null) {
            obj.vector = (double[])this.vector.clone();
        }
        if (this.markerImageBinary != null) {
            obj.markerImageBinary = (byte[])this.markerImageBinary.clone();
        }
        obj.setLabelFontSize(this.labelFontSize);
        obj.setLabelOffsetSize(this.labelOffset);
        obj.setMarkerSize(this.markerSize);
        obj.setAnchorPoint(this.getAnchorX(), this.getAnchorY());
        return obj;
    }

    @Override
    public String getTypeName() {
        return "MARKER";
    }

    @Override
    public String toXMLString() {
        String fonts = "";
        if (this.labelFont != null) {
            int fs;
            String family = this.labelFont.getFamily();
            float size = (float)this.labelFontSize.getValue();
            String sizeStr = String.valueOf(size);
            if (this.labelFontSize.isPixelUnit()) {
                sizeStr = String.valueOf((int)size);
            }
            String ftUnit = "";
            if (this.labelFontSize.getUnit() != null && !this.labelFontSize.getUnit().equalsIgnoreCase("px")) {
                ftUnit = this.labelFontSize.getUnit();
            }
            boolean bold = ((fs = this.labelFont.getStyle()) & 1) > 0;
            boolean italic = (fs & 2) > 0;
            String bs = bold ? ";font-weight:bold" : "";
            String is = italic ? ";font-style:italic" : "";
            String fc = this.labelFontColor == null ? ";font-fill:#ffffff" : ";font-fill:" + StyleUtils.getHexidecimalString(this.labelFontColor);
            fonts = fonts + ";font-family:" + family + ";font-size:" + sizeStr + ftUnit + bs + is + fc;
            double labelOffsetX = this.labelOffset.getWidth();
            double labelOffsetY = this.labelOffset.getHeight();
            String labelOffsetStr = "";
            if (this.labelOffset.getUnit() != null && !this.labelOffset.getUnit().equalsIgnoreCase("px")) {
                labelOffsetStr = this.labelOffset.getUnit();
            }
            if (this.labelOffset.isPixelUnit()) {
                if (labelOffsetX != 0.0) {
                    fonts = fonts + ";text-offset-x:" + String.valueOf((int)labelOffsetX) + labelOffsetStr;
                }
                if (labelOffsetY != 0.0) {
                    fonts = fonts + ";text-offset-y:" + String.valueOf((int)labelOffsetY) + labelOffsetStr;
                }
            } else {
                if (labelOffsetX != 0.0) {
                    String loffx = StyleUtils.getUSLocaleFormat(labelOffsetX);
                    loffx = StyleUtils.cleanDecimalZeros(loffx, 1);
                    fonts = fonts + ";text-offset-x:" + loffx + labelOffsetStr;
                }
                if (labelOffsetY != 0.0) {
                    String loffy = StyleUtils.getUSLocaleFormat(labelOffsetY);
                    loffy = StyleUtils.cleanDecimalZeros(loffy, 1);
                    fonts = fonts + ";text-offset-y:" + loffy + labelOffsetStr;
                }
            }
        }
        String forcedUnit = "";
        if (this.markerSize.getUnit() != null && !this.markerSize.getUnit().equalsIgnoreCase("px")) {
            forcedUnit = this.markerSize.getUnit();
        }
        String mkwdStr = String.valueOf(this.markerSize.getWidth());
        String mkhtStr = String.valueOf(this.markerSize.getHeight());
        if (this.markerSize.isPixelUnit()) {
            mkwdStr = String.valueOf((int)this.markerSize.getWidth());
            mkhtStr = String.valueOf((int)this.markerSize.getHeight());
        }
        String anchorElem = "";
        if (this.anchorPoint[0] != 0.5 || this.anchorPoint[1] != 0.5) {
            anchorElem = "      <anchor x=\"" + this.anchorPoint[0] + "\" y=\"" + this.anchorPoint[1] + "\" />\n";
        }
        String bgColor = "";
        if (this.backgroundColor != null) {
            bgColor = ";background:" + StyleUtils.getHexidecimalString(this.backgroundColor);
            if (this.backgroundColor.getAlpha() < 255) {
                bgColor = bgColor + ";background-opacity:" + this.backgroundColor.getAlpha();
            }
        }
        if (this.markerType == 5) {
            String href = "dummy.gif";
            if (this.url != null) {
                href = this.url;
            }
            String mtype = "gif";
            if (this.urlFormat != null) {
                mtype = this.urlFormat;
            }
            String res = "";
            res = this.urlColumn == null || !href.equals("dummy.gif") ? "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n  <desc></desc>\n  <g class=\"marker\" style=\"width:" + mkwdStr + forcedUnit + ";height:" + mkhtStr + forcedUnit + fonts + bgColor + "\">\n" + "    <image x=\"0\" y=\"0\" width=\"1\" height=\"1\" markerType=\"" + mtype + "\" href=\"" + href + "\"/>\n" + anchorElem + "  </g>\n" + "</svg>" : "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n  <desc></desc>\n  <g class=\"marker\" style=\"width:" + mkwdStr + forcedUnit + ";height:" + mkhtStr + forcedUnit + fonts + bgColor + "\">\n" + "    <image x=\"0\" y=\"0\" width=\"1\" height=\"1\" markerType=\"" + mtype + "\" hrefColumn=\"" + this.urlColumn + "\"/>\n" + anchorElem + "  </g>\n" + "</svg>";
            return res;
        }
        if (this.markerType == 7) {
            String href = "dummy.svg";
            String res = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n  <desc></desc>\n  <g class=\"marker\" style=\"width:" + mkwdStr + forcedUnit + ";height:" + mkhtStr + forcedUnit + fonts + bgColor + "\">\n" + "    <svgSymbol href=\"" + href + "\">\n" + "      <![CDATA[" + this.rawSVGString + "]]>\n" + "    </svgSymbol>\n" + anchorElem + "  </g>\n" + "</svg>";
            return res;
        }
        if (this.markerType == 1 || this.markerType == 2 || this.markerType == 4 || this.markerType == 3 || this.markerType == 6) {
            String res = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n  <desc></desc>\n  <g class=\"marker\"";
            res = res + " style=\"";
            String color = "";
            int alpha = 255;
            if (this.vectorStrokeColor != null) {
                color = color + "stroke:" + StyleUtils.getHexidecimalString(this.vectorStrokeColor);
                alpha = this.vectorStrokeColor.getAlpha();
                if (alpha < 255) {
                    color = color + ";stroke-opacity:" + alpha;
                }
                if (this.vectorStrokeWidth != 1.0f) {
                    color = color + ";stroke-width:" + this.vectorStrokeWidth;
                }
                if (this.vectorFillColor != null) {
                    color = color + ";fill:" + StyleUtils.getHexidecimalString(this.vectorFillColor);
                    alpha = this.vectorFillColor.getAlpha();
                    if (alpha < 255) {
                        color = color + ";fill-opacity:" + alpha;
                    }
                }
            } else if (this.vectorFillColor != null) {
                color = color + "fill:" + StyleUtils.getHexidecimalString(this.vectorFillColor);
                alpha = this.vectorFillColor.getAlpha();
                if (alpha < 255) {
                    color = color + ";fill-opacity:" + alpha;
                }
            }
            if (this.backgroundColor != null) {
                color = color.length() == 0 ? color + "background:" + StyleUtils.getHexidecimalString(this.backgroundColor) : color + ";background:" + StyleUtils.getHexidecimalString(this.backgroundColor);
                alpha = this.backgroundColor.getAlpha();
                if (alpha < 255) {
                    color = color + ";background-opacity:" + alpha;
                }
            }
            if (color.length() > 1) {
                res = res + color;
            }
            if (this.markerSize.getWidth() > 0.0 && this.markerSize.getHeight() > 0.0) {
                res = res + ";width:" + mkwdStr + forcedUnit + ";height:" + mkhtStr + forcedUnit;
            }
            res = res + fonts;
            res = res + "\">\n";
            switch (this.markerType) {
                case 6: {
                    res = res + "    <ttfSymbol fontName=\"" + XMLUtil.replaceXMLEntities(this.ttf.getName().toUpperCase()) + "\" charCode=\"" + this.glyphCharCode + "\" />\n";
                    break;
                }
                case 3: {
                    if (this.vector == null) break;
                    res = res + "    <circle cx=\"0\" cy=\"0\" r=\"0\" />\n";
                    break;
                }
                case 1: {
                    if (this.vector == null || this.vector.length % 2 != 0) break;
                    String points = "";
                    points = points + this.vector[0] + "," + this.vector[1];
                    for (int i = 2; i < this.vector.length; i += 2) {
                        points = points + "," + this.vector[i] + "," + this.vector[i + 1];
                    }
                    res = res + "    <polygon points=\"" + points + "\" />\n";
                    break;
                }
                case 2: {
                    if (this.vector == null || this.vector.length % 2 != 0) break;
                    String points = "";
                    points = points + this.vector[0] + "," + this.vector[1];
                    for (int i = 2; i < this.vector.length; i += 2) {
                        points = points + "," + this.vector[i] + "," + this.vector[i + 1];
                    }
                    res = res + "    <polyline points=\"" + points + "\" />\n";
                    break;
                }
                case 4: {
                    if (this.vector == null || this.vector.length != 4) break;
                    String points = "";
                    points = points + this.vector[0] + "," + this.vector[1];
                    for (int i = 2; i < this.vector.length; i += 2) {
                        points = points + "," + this.vector[i] + "," + this.vector[i + 1];
                    }
                    res = res + "    <rect points=\"" + points + "\" />\n";
                }
            }
            res = res + anchorElem;
            res = res + "  </g>\n</svg>";
            return res;
        }
        return null;
    }

    public void setMarkerType(int markerType) {
        this.markerType = markerType;
    }

    public int getMarkerType() {
        return this.markerType;
    }

    public void setMarkerImageBinary(byte[] markerImageBinary) {
        this.markerImageBinary = markerImageBinary;
    }

    public byte[] getMarkerImageBinary() {
        return this.markerImageBinary;
    }

    public void setMarkerImageType(int markerImageType) {
        this.markerImageType = markerImageType;
    }

    public int getMarkerImageType() {
        return this.markerImageType;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFontColor(Color fontColor) {
        this.labelFontColor = fontColor;
    }

    public Color getLabelFontColor() {
        return this.labelFontColor;
    }

    public void setMarkerSize(SizeDefinition2D size) {
        this.markerSize = new SizeDefinition2D();
        if (size == null) {
            return;
        }
        this.markerSize.setSize(size);
        this.markerSize.setUnit(size.getUnit());
    }

    public SizeDefinition2D getMarkerSize() {
        return this.markerSize;
    }

    public double getMarkerWidth() {
        return this.markerSize.getWidth();
    }

    public void setMarkerWidth(double width) {
        this.markerSize.setWidth(width);
    }

    public double getMarkerHeight() {
        return this.markerSize.getHeight();
    }

    public void setMarkerHeight(double height) {
        this.markerSize.setHeight(height);
    }

    public String getMarkerSizeUnit() {
        return this.markerSize.getUnit();
    }

    public void setMarkerSizeUnit(String unit) {
        this.markerSize.setUnit(unit);
    }

    public void setForcedWidth(int forcedWidth) {
        this.markerSize.setWidth(forcedWidth);
    }

    public int getForcedWidth() {
        return (int)this.markerSize.getWidth();
    }

    public void setForcedHeight(int forcedHeight) {
        this.markerSize.setHeight(forcedHeight);
    }

    public int getForcedHeight() {
        return (int)this.markerSize.getHeight();
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setVector(double[] vector) {
        this.vector = vector;
    }

    public double[] getVector() {
        return this.vector;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getCoordinatesAsString() {
        if (this.vector == null || this.vector.length == 0) {
            if (this.markerType != 3) {
                return "";
            }
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("" + this.vector[0]);
        if (this.markerType != 3) {
            for (int i = 1; i < this.vector.length; ++i) {
                sb.append("," + this.vector[i]);
            }
        }
        return sb.toString();
    }

    public void setCoordinatesAsString(String s) {
        if (s == null || s.trim().length() == 0) {
            this.vector = null;
            return;
        }
        ArrayList values = Util.splitBy(s.trim(), ",");
        if (values == null || values.size() == 0) {
            this.vector = null;
            return;
        }
        if (this.markerType == 3) {
            this.vector = new double[1];
            this.vector[0] = Double.parseDouble((String)values.get(0));
        }
        this.vector = Util.convert(s.trim());
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setVectorFillColor(Color vectorFillColor) {
        this.vectorFillColor = vectorFillColor;
    }

    public Color getVectorFillColor() {
        return this.vectorFillColor;
    }

    public void setVectorStrokeColor(Color vectorStrokeColor) {
        this.vectorStrokeColor = vectorStrokeColor;
    }

    public Color getVectorStrokeColor() {
        return this.vectorStrokeColor;
    }

    public void setVectorStrokeWidth(float vectorStrokeWidth) {
        this.vectorStrokeWidth = vectorStrokeWidth;
    }

    public float getVectorStrokeWidth() {
        return this.vectorStrokeWidth;
    }

    public double setOrientation(double x, double y, double z) {
        this.ox = x;
        this.oy = y;
        this.oz = z;
        this.rotation = Math.atan2(-y, x);
        return this.rotation;
    }

    public double[] getOrientation() {
        return new double[]{this.ox, this.oy, this.oz};
    }

    public void resetOrientation() {
        this.ox = 1.0;
        this.oy = 0.0;
        this.oz = 0.0;
        this.rotation = 0.0;
    }

    public void setGlyphCharCode(int glyphCharCode) {
        this.glyphCharCode = glyphCharCode;
    }

    public int getGlyphCharCode() {
        return this.glyphCharCode;
    }

    public void setTruetypeFontName(String name) {
        if (this.ttf == null) {
            this.ttf = new TruetypeFont();
        }
        this.ttf.setName(name);
    }

    public String getTruetypeFontName() {
        return this.ttf == null ? null : this.ttf.getName();
    }

    public void setTruetypeFont(TruetypeFont ttf) {
        this.ttf = ttf;
    }

    public TruetypeFont getTruetypeFont() {
        return this.ttf;
    }

    public void setTruetypeFont(Font font) {
        if (this.ttf == null) {
            this.ttf = new TruetypeFont();
        }
        this.ttf.setFont(font);
        if (this.ttf.getName() == null) {
            this.ttf.setName(font.getFamily().toUpperCase());
        }
    }

    public void setLabelOffsetSize(SizeDefinition2D size) {
        this.labelOffset = new SizeDefinition2D();
        if (size == null) {
            return;
        }
        this.labelOffset.setSize(size);
        this.labelOffset.setUnit(size.getUnit());
    }

    public SizeDefinition2D getLabelOffsetSize() {
        return this.labelOffset;
    }

    public double getLabelOffsetSizeX() {
        return this.labelOffset.getWidth();
    }

    public void setLabelOffsetSizeX(double offsetX) {
        this.labelOffset.setWidth(offsetX);
    }

    public double getLabelOffsetSizeY() {
        return this.labelOffset.getHeight();
    }

    public void setLabelOffsetSizeY(double offsetY) {
        this.labelOffset.setHeight(offsetY);
    }

    public String getLabelOffsetUnit() {
        return this.labelOffset.getUnit();
    }

    public void setLabelOffsetUnit(String unit) {
        this.labelOffset.setUnit(unit);
    }

    public void setLabelOffsetX(int labelOffsetX) {
        this.labelOffset.setWidth(labelOffsetX);
    }

    public int getLabelOffsetX() {
        return (int)this.labelOffset.getWidth();
    }

    public void setLabelOffsetY(int labelOffsetY) {
        this.labelOffset.setHeight(labelOffsetY);
    }

    public int getLabelOffsetY() {
        return (int)this.labelOffset.getHeight();
    }

    public void setUrl(String param) {
        this.url = param;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrlColumn(String param) {
        this.urlColumn = param;
    }

    public String getUrlColumn() {
        return this.urlColumn;
    }

    public String getUrlMarkerImageFormat() {
        return this.urlFormat;
    }

    public void setUrlMarkerImageFormat(String format) {
        this.urlFormat = format;
    }

    public String getLabelFontSizeUnit() {
        return this.labelFontSize.getUnit();
    }

    public void setLabelFontSizeUnit(String unit) {
        this.labelFontSize.setUnit(unit);
    }

    public float getLabelFontSizeValue() {
        return (float)this.labelFontSize.getValue();
    }

    public void setLabelFontSizeValue(float v) {
        this.labelFontSize.setValue(v);
    }

    public void setLabelFontSize(SizeDefinition size) {
        this.labelFontSize = new SizeDefinition(12.0, null);
        if (size == null) {
            return;
        }
        this.labelFontSize.setValue(size.getValue());
        this.labelFontSize.setUnit(size.getUnit());
    }

    public void setLabelFontSize(float v, String unit) {
        this.labelFontSize.setValue(v);
        this.labelFontSize.setUnit(unit);
    }

    public void setAnchorPoint(double anchorX, double anchorY) {
        if (anchorX < 0.0 || anchorX > 1.0 || anchorY < 0.0 || anchorY > 1.0) {
            throw new IllegalArgumentException("Invalid anchor point x or y.");
        }
        this.anchorPoint[0] = anchorX;
        this.anchorPoint[1] = anchorY;
    }

    public double[] getAnchorPoint() {
        return this.anchorPoint;
    }

    public void setAnchorX(double anchorX) {
        this.anchorPoint[0] = anchorX;
    }

    public double getAnchorX() {
        return this.anchorPoint[0];
    }

    public void setAnchorY(double anchorY) {
        this.anchorPoint[1] = anchorY;
    }

    public double getAnchorY() {
        return this.anchorPoint[1];
    }

    public double[] getSVGNaturalSize() {
        return this.svgNaturalSize;
    }

    public void setSVGNaturalSize(double[] size) {
        if (size != null && size.length >= 2) {
            this.svgNaturalSize = new double[]{size[0], size[1]};
        }
    }

    public void setRawSVGString(String rawSVGString) {
        if (rawSVGString != null) {
            this.rawSVGString = rawSVGString.trim();
        }
    }

    public String getRawSVGString() {
        return this.rawSVGString;
    }

    @Override
    public String[] getStyleDependency() {
        String[] deps = null;
        if (this.ttf != null) {
            deps = new String[]{this.ttf.getName()};
        }
        return deps;
    }

    public SizeDefinition getLabelFontSize() {
        return this.labelFontSize;
    }
}

