/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import oracle.lbs.util.MPHttpServletRequest;
import oracle.mapviewer.share.util.LogFactory;

public class MPRequestAssembler {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.MAPCACHE_SERVER);
    private static long instanceIdCount = 0L;
    private static Hashtable requestTable = new Hashtable(1000);
    private static int MAX_REQUEST_LIFE_IN_SECOND = 40;
    private static RequestRecyleThread recycler = null;

    public static void init() {
        if (recycler != null) {
            recycler.markDead();
        }
        recycler = new RequestRecyleThread(MAX_REQUEST_LIFE_IN_SECOND);
        recycler.start();
    }

    public static long getNextInstanceId() {
        return instanceIdCount++;
    }

    public static void stopRequestRecycler() {
        log.info("Stopping MP request recycler thread.");
        if (recycler != null) {
            recycler.markDead();
        }
        recycler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPHttpServletRequest processRequest(HttpServletRequest req) {
        String partNumber = req.getParameter("pn");
        String callBackId = req.getParameter("callback_id");
        if (callBackId != null && callBackId.trim().length() == 0) {
            callBackId = null;
        }
        if (partNumber != null && callBackId != null) {
            Hashtable hashtable = requestTable;
            synchronized (hashtable) {
                MPHttpServletRequest request = (MPHttpServletRequest)requestTable.get(callBackId);
                if (request == null) {
                    request = new MPHttpServletRequest(req, callBackId);
                    requestTable.put(callBackId, request);
                } else {
                    request.mergeRequest(req);
                    if (request.isComplete()) {
                        requestTable.remove(callBackId);
                    }
                }
                return request;
            }
        }
        return new MPHttpServletRequest(req, callBackId);
    }

    static {
        recycler = new RequestRecyleThread(MAX_REQUEST_LIFE_IN_SECOND);
        recycler.start();
    }

    static class RequestRecyleThread
    extends Thread {
        private volatile boolean stop = false;
        int maxLifeInSeconds = 30;

        public RequestRecyleThread(int timeout) {
            this.maxLifeInSeconds = timeout;
        }

        public void markDead() {
            this.stop = true;
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    RequestRecyleThread.sleep(this.maxLifeInSeconds * 1000 * 2);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    Iterator it = requestTable.entrySet().iterator();
                    ArrayList requestsToDelete = new ArrayList(10);
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        MPHttpServletRequest req = (MPHttpServletRequest)entry.getValue();
                        if (req.getAgeInSeconds() <= (long)this.maxLifeInSeconds) continue;
                        requestsToDelete.add(entry.getKey());
                    }
                    for (int i = 0; i < requestsToDelete.size(); ++i) {
                        requestTable.remove(requestsToDelete.get(i));
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

