/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.lbs.mapserver.core.RealWorker;
import oracle.lbs.util.CharResponseWrapper;
import oracle.lbs.util.FileIOUtil;
import oracle.lbs.util.ServerInitListener;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.template.TTileLayer;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.TemplateDataSource;

public class LBSResourceFilter
implements Filter {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.MAPVIEWER);
    FilterConfig config = null;
    String saveImagesAt = null;
    String templatesRootFolder = null;
    int expires = -1;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        String _expires = this.config.getInitParameter("expires");
        if (_expires != null) {
            try {
                this.expires = Integer.parseInt(_expires);
                log.info("Browser cached resource images expire after " + this.expires + " hours.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.info("*** MapViewer resource filter started. ***");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.config == null) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String ctxPath = req.getContextPath();
        String imageFlag = ctxPath + "/images/";
        String templateFlag = ctxPath + "/templates/";
        String mcsFlag = ctxPath + "/mcserver";
        String requestUri = req.getRequestURI();
        if (requestUri.indexOf(mcsFlag) >= 0) {
            this.handleTileLayerRequest(request, response, filterChain);
        } else if (requestUri.indexOf(imageFlag) >= 0) {
            this.streamImage(req, res);
        } else if (requestUri.indexOf(templateFlag) >= 0) {
            this.streamTemplateFile(req, res);
        } else {
            return;
        }
    }

    private void handleTileLayerRequest(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String qs = ((HttpServletRequest)request).getQueryString();
        if (qs != null && qs.indexOf("xml_request") >= 0) {
            if (qs.indexOf("get_cache_status") > 0) {
                PrintWriter out = response.getWriter();
                CharResponseWrapper wrapper = new CharResponseWrapper((HttpServletResponse)response);
                filterChain.doFilter(request, (ServletResponse)wrapper);
                String origResponse = wrapper.toString();
                if (origResponse.indexOf("<tile_server_status>") >= 0) {
                    CharArrayWriter caw = new CharArrayWriter();
                    caw.write(origResponse.substring(0, origResponse.indexOf("</tile_server_status>") - 1));
                    String[] tdsList = DSManager.getTemplateDSNames();
                    try {
                        if (tdsList != null) {
                            for (int i = 0; i < tdsList.length; ++i) {
                                TemplateDataSource tds = (TemplateDataSource)DSManager.get(tdsList[i]);
                                List tlist = tds.getTemplate().getTileLayerList();
                                for (int j = 0; j < tlist.size(); ++j) {
                                    String cacheStatus = "\n<cache_instance data_source=\"" + tdsList[i] + "\" name=\"" + ((TTileLayer)tlist.get(j)).getName() + "\" type=\"external\" service_url=\"\" adapter_class_path=\"null\" zoom_levels=\"19\" status=\"adapter not ready\" online=\"true\"/>";
                                    caw.write(cacheStatus);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        log.warning("Error getting template based tile layer status." + ex.getMessage());
                    }
                    caw.write("\n</tile_server_status>");
                    response.setContentLength(caw.toString().length());
                    out.write(caw.toString());
                } else {
                    out.write(origResponse);
                }
                out.close();
            } else {
                filterChain.doFilter(request, response);
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    private void streamImage(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.saveImagesAt == null) {
            if (RealWorker.getConfig() == null) {
                return;
            }
            this.saveImagesAt = RealWorker.getConfig().saveImagesAt;
            if (this.saveImagesAt != null && !this.saveImagesAt.endsWith(File.separator)) {
                this.saveImagesAt = this.saveImagesAt + File.separator;
            }
        }
        String mypath = req.getRequestURI().substring((req.getContextPath() + "/images/").length());
        log.finest("path=" + mypath);
        String file = this.saveImagesAt + mypath;
        File f = new File(file);
        if (!f.exists()) {
            res.sendError(404);
            return;
        }
        String ctype = this.config.getServletContext().getMimeType(file);
        if (ctype == null) {
            ctype = this.getImageCType(mypath);
        }
        FileIOUtil.streamFile(res, file, this.expires, ctype, false);
    }

    private void streamTemplateFile(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.templatesRootFolder == null) {
            if (ServerInitListener.getTemplatesFolder() == null) {
                return;
            }
            this.templatesRootFolder = ServerInitListener.getTemplatesFolder();
        }
        String mypath = req.getRequestURI().substring((req.getContextPath() + "/templates/").length());
        log.finest("path=" + mypath);
        String file = this.templatesRootFolder + mypath;
        File f = new File(file);
        if (!f.exists()) {
            res.sendError(404);
            return;
        }
        String ctype = "text/plain; charset=UTF-8";
        String _file = file.toLowerCase();
        boolean isImage = false;
        if (_file.endsWith(".png") || _file.endsWith(".gif") || _file.endsWith(".jpg") || _file.endsWith(".jpeg")) {
            isImage = true;
            ctype = this.getImageCType(_file);
        }
        boolean gzip = false;
        String ae = req.getHeader("accept-encoding");
        if (!isImage && ae != null && ae.toLowerCase().indexOf("gzip") >= 0) {
            gzip = true;
        }
        FileIOUtil.streamFile(res, file, this.expires, ctype, gzip);
    }

    private String getImageCType(String mypath) {
        String ctype = null;
        ctype = (mypath = mypath.toLowerCase()).endsWith(".png") ? "image/png" : (mypath.endsWith(".gif") ? "image/gif" : (mypath.endsWith(".jpeg") || mypath.endsWith(".jpg") ? "image/jpeg" : (mypath.endsWith(".svg") || mypath.endsWith(".svgz") ? "image/svg+xml" : (mypath.endsWith(".pdf") ? "application/pdf" : (mypath.endsWith(".tif") || mypath.endsWith(".tiff") ? "image/tiff" : "application/octet-stream")))));
        return ctype;
    }

    public void destroy() {
        this.config = null;
    }
}

