/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapcommon;

import java.awt.geom.Point2D;
import java.io.Serializable;
import oracle.lbs.mapcommon.GeocoderAddress;
import oracle.sdovis.JSDOGeometry;

public class GeoFeature
implements Serializable {
    static final long serialVersionUID = 1308025278521145831L;
    private Object id;
    private String label = null;
    private JSDOGeometry geometry = null;
    private String labelStyleName = null;
    private String renderStyleName = null;
    private int markerStyleSize = 0;
    private boolean forcedLabeling = false;
    private boolean fixedSVGLabel = false;
    private double[] radius = null;
    private double[] originalRadii = null;
    private GeocoderAddress address = null;
    private String hiddenInfo = null;
    private Object[] attrs = null;
    private double orient_x = 0.0;
    private double orient_y = 0.0;
    private double orient_z = 0.0;
    private boolean selectableInSVG = false;
    private String onClick = null;
    private String onMouseMove = null;
    private String onMouseOver = null;
    private String onMouseOut = null;

    public GeoFeature() {
    }

    public GeoFeature(double x, double y) {
        this.geometry = new JSDOGeometry(x, y, 0);
    }

    public Point2D getCenterAsPoint2D() {
        if (this.geometry != null) {
            double x = this.getCenterX();
            double y = this.getCenterY();
            return new Point2D.Double(x, y);
        }
        if (this.address != null && this.address.coordinates != null) {
            return new Point2D.Double(this.address.coordinates[0], this.address.coordinates[1]);
        }
        return null;
    }

    private double getCenterX() {
        if (this.geometry != null) {
            int gt = this.geometry.getType();
            if (gt == 1) {
                double[] p = this.geometry.getPoint();
                return p[0];
            }
            double[] env = this.geometry.getMBR();
            return (env[0] + env[2]) / 2.0;
        }
        return 0.0;
    }

    private double getCenterY() {
        if (this.geometry != null) {
            int gt = this.geometry.getType();
            if (gt == 1) {
                double[] p = this.geometry.getPoint();
                return p[1];
            }
            double[] env = this.geometry.getMBR();
            return (env[1] + env[3]) / 2.0;
        }
        return 0.0;
    }

    public GeocoderAddress getAddress() {
        return this.address;
    }

    public void setAddress(GeocoderAddress addr) {
        this.address = addr;
    }

    public JSDOGeometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(JSDOGeometry g) {
        this.geometry = g;
    }

    public String getID() {
        return this.id == null ? null : this.id.toString();
    }

    public void setID(Object i) {
        this.id = i;
    }

    public void setMarkerOrientation(double x, double y, double z) {
        this.orient_x = x;
        this.orient_y = y;
        this.orient_z = z;
    }

    public double getOrientationX() {
        return this.orient_x;
    }

    public double getOrientationY() {
        return this.orient_y;
    }

    public double getOrientationZ() {
        return this.orient_z;
    }

    public String getRenderStyleName() {
        return this.renderStyleName;
    }

    public void setRenderStyleName(String rs) {
        this.renderStyleName = rs;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public String getLabelStyleName() {
        return this.labelStyleName;
    }

    public void setLabelStyleName(String ls) {
        this.labelStyleName = ls;
    }

    public int getMarkerStyleSize() {
        return this.markerStyleSize;
    }

    public void setMarkerStyleSize(int mss) {
        this.markerStyleSize = mss;
    }

    public void setCenter(double x, double y) {
        this.setGeometry(new JSDOGeometry(x, y, 0));
    }

    public double[] getRadius() {
        return this.radius;
    }

    public void setRadius(double[] r) {
        this.radius = r;
    }

    public double[] getOriginalRadius() {
        return this.originalRadii;
    }

    public void setOriginalRadius(double[] r) {
        this.originalRadii = r;
    }

    public void setHiddenInfo(String str) {
        this.hiddenInfo = str;
    }

    public String getHiddenInfo() {
        return this.hiddenInfo;
    }

    public void setForcedLabeling(boolean fl) {
        this.forcedLabeling = fl;
    }

    public boolean forcedLabeling() {
        return this.forcedLabeling;
    }

    public void setFixedSVGLabel(boolean f) {
        this.fixedSVGLabel = f;
    }

    public boolean fixedSVGLabel() {
        return this.fixedSVGLabel;
    }

    public void setSelectableInSVG(boolean selectable) {
        this.selectableInSVG = selectable;
    }

    public boolean selectableInSVG() {
        return this.selectableInSVG;
    }

    public void setOnClick(String oc) {
        this.onClick = oc;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnMouseMove(String oc) {
        this.onMouseMove = oc;
    }

    public String getOnMouseMove() {
        return this.onMouseMove;
    }

    public void setOnMouseOver(String oc) {
        this.onMouseOver = oc;
    }

    public String getOnMouseOver() {
        return this.onMouseOver;
    }

    public void setOnMouseOut(String oc) {
        this.onMouseOut = oc;
    }

    public String getOnMouseOut() {
        return this.onMouseOut;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("GeoFeature:\n");
        sb.append("  id=" + this.id);
        sb.append("\n  label=" + this.label);
        sb.append("\n  geometry=" + this.geometry);
        sb.append("\n  labelStyleName=" + this.labelStyleName);
        sb.append("\n  renderStyleName=" + this.renderStyleName);
        sb.append("\n  markerStyleSize=" + this.markerStyleSize);
        sb.append("\n  radius=" + this.radius);
        sb.append("\n  address=" + this.address);
        sb.append("\n  attribute=" + this.attrs);
        sb.append("\n  orient_x=" + this.orient_x + ", orient_y=" + this.orient_y + ", orient_z=" + this.orient_z);
        return sb.toString();
    }

    public Object[] getAttrs() {
        return this.attrs;
    }

    public void setAttrs(Object[] as) {
        this.attrs = as;
    }
}

