/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.AWFunctionNotSupported;
import oracle.AWXML.Cube;
import oracle.AWXML.Dimension;
import oracle.AWXML.ObjectNotValidException;

public abstract class BaseObject {
    protected String m_name;
    protected String m_longName = null;
    protected String m_shortName = null;
    protected String m_pluralName = null;
    protected String m_id;
    protected BaseObject m_owner = null;
    protected String m_schema = null;
    protected boolean m_dataRead = true;
    protected String m_columnName = null;
    protected static String AWNULL = "NA";
    protected static String s_EndElementTag = "/>";
    protected static String s_StartStartTag = "<";
    protected static String s_StartEndTag = ">";
    protected static String s_EndStartTag = "</";
    protected static String s_EndEndTag = ">";
    protected static String s_EndTag = ">";
    protected static String s_JAVA_LINEEND = ";\n";
    protected static String s_NEWLINE = "\n";
    protected static int s_Indent = 2;
    protected static int s_objectCounter = 1;
    protected String[] m_listResults;
    protected String m_commandResults;
    protected String m_commandResultText;
    public static String DATABASENULL = "AWXML$NULL";
    private Hashtable m_shortDescriptions = new Hashtable();
    private Hashtable m_longDescriptions = new Hashtable();
    private Hashtable m_pluralDescriptions = new Hashtable();

    public BaseObject(BaseObject baseObject) {
        if (s_objectCounter == 1) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            int n = gregorianCalendar.get(14);
            Random random = new Random(n);
            random.nextInt();
            s_objectCounter = Math.abs(random.nextInt());
        }
        this.m_owner = baseObject;
        this.m_shortName = this.m_name = "OBJ" + s_objectCounter++;
        this.m_pluralName = this.m_name;
    }

    protected BaseObject() {
        if (s_objectCounter == 1) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            int n = gregorianCalendar.get(14);
            Random random = new Random(n);
            random.nextInt();
            s_objectCounter = Math.abs(random.nextInt());
        }
        this.m_shortName = this.m_name = "OBJ" + s_objectCounter++;
        this.m_pluralName = this.m_name;
    }

    protected BaseObject(String string, String string2) {
        this.m_name = string;
        this.setLongName(this.m_name);
        this.setShortName(this.m_name);
        this.setPluralName(this.m_name);
        this.m_id = string2;
    }

    protected void setDataRead(boolean bl) {
        this.m_dataRead = bl;
    }

    public boolean DataRead() {
        return this.m_dataRead;
    }

    public void setSchema(String string) {
        this.m_schema = string;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public void setName(String string) {
        if (!this.m_name.equals(string)) {
            boolean bl = true;
            if (this.m_owner != null) {
                if (this.m_owner instanceof Dimension) {
                    bl = ((Dimension)this.m_owner).validateName(string, this);
                } else if (this.m_owner instanceof Cube) {
                    bl = ((Cube)this.m_owner).validateName(string, this);
                }
            }
            if (bl) {
                this.m_name = string;
                this.setLongName(string);
                this.setShortName(string);
                this.setPluralName(string);
            } else {
                throw new AWException("AWXML-ERR-NUM-900006", new Object[]{string});
            }
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setColumnName(String string) {
        this.m_columnName = string;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public void setShortName(String string) {
        if (string.indexOf("::") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "::");
            while (stringTokenizer.hasMoreTokens() && stringTokenizer.countTokens() >= 2) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.m_shortDescriptions.put(string2, string3);
            }
            this.m_shortName = string;
        } else if (AW.getCurAW().getMetaDataFormat() <= 10.1) {
            this.m_shortName = string;
        } else if (string.length() > 0) {
            if (this.m_shortDescriptions.containsKey(AW.getCurAW().getDefaultLanguage())) {
                this.m_shortDescriptions.remove(AW.getCurAW().getDefaultLanguage());
            }
            this.m_shortDescriptions.put(AW.getCurAW().getDefaultLanguage(), string);
            this.m_shortName = null;
            Enumeration enumeration = this.m_shortDescriptions.keys();
            Enumeration enumeration2 = this.m_shortDescriptions.elements();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = (String)enumeration2.nextElement();
                if (this.m_shortName == null) {
                    this.m_shortName = string4 + "::" + string5;
                    continue;
                }
                this.m_shortName = this.m_shortName + "::" + string4 + "::" + string5;
            }
        }
    }

    public String getLongName() {
        String string = null;
        string = AW.getCurAW().getMetaDataFormat() <= 10.1 ? this.m_longName : this.getLongName(AW.getCurAW().getDefaultLanguage());
        return string;
    }

    public String getLongName(String string) {
        String string2 = null;
        if (!(AW.getCurAW().getMetaDataFormat() > 10.1)) {
            throw new AWException("AW does not have multi-lingual support");
        }
        string2 = (String)this.m_longDescriptions.get(string);
        return string2;
    }

    public void setLongName(String string) {
        if (string.indexOf("::") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "::");
            while (stringTokenizer.hasMoreTokens() && stringTokenizer.countTokens() >= 2) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.m_longDescriptions.put(string2, string3);
            }
            this.m_longName = string;
        } else if (AW.getCurAW().getMetaDataFormat() <= 10.1) {
            this.m_longName = string;
        } else if (string.length() > 0) {
            if (this.m_longDescriptions.containsKey(AW.getCurAW().getDefaultLanguage())) {
                this.m_longDescriptions.remove(AW.getCurAW().getDefaultLanguage());
            }
            this.m_longDescriptions.put(AW.getCurAW().getDefaultLanguage(), string);
            this.m_longName = null;
            Enumeration enumeration = this.m_longDescriptions.keys();
            Enumeration enumeration2 = this.m_longDescriptions.elements();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = (String)enumeration2.nextElement();
                if (this.m_longName == null) {
                    this.m_longName = string4 + "::" + string5;
                    continue;
                }
                this.m_longName = this.m_longName + "::" + string4 + "::" + string5;
            }
        }
    }

    public String getShortName() {
        String string = null;
        string = AW.getCurAW().getMetaDataFormat() <= 10.1 ? this.m_shortName : this.getShortName(AW.getCurAW().getDefaultLanguage());
        return string;
    }

    public String getShortName(String string) {
        String string2 = null;
        if (!(AW.getCurAW().getMetaDataFormat() > 10.1)) {
            throw new AWException("AW does not have multi-lingual support");
        }
        string2 = (String)this.m_shortDescriptions.get(string);
        return string2;
    }

    public void setPluralName(String string) {
        if (string.indexOf("::") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "::");
            while (stringTokenizer.hasMoreTokens() && stringTokenizer.countTokens() >= 2) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.m_pluralDescriptions.put(string2, string3);
            }
            this.m_pluralName = string;
        } else if (AW.getCurAW().getMetaDataFormat() <= 10.1) {
            this.m_pluralName = string;
        } else if (string.length() > 0) {
            if (this.m_pluralDescriptions.containsKey(AW.getCurAW().getDefaultLanguage())) {
                this.m_pluralDescriptions.remove(AW.getCurAW().getDefaultLanguage());
            }
            this.m_pluralDescriptions.put(AW.getCurAW().getDefaultLanguage(), string);
            this.m_pluralName = null;
            Enumeration enumeration = this.m_pluralDescriptions.keys();
            Enumeration enumeration2 = this.m_pluralDescriptions.elements();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = (String)enumeration2.nextElement();
                if (this.m_pluralName == null) {
                    this.m_pluralName = string4 + "::" + string5;
                    continue;
                }
                this.m_pluralName = this.m_pluralName + "::" + string4 + "::" + string5;
            }
        }
    }

    public String getPluralName() {
        String string = null;
        string = AW.getCurAW().getMetaDataFormat() <= 10.1 ? this.m_pluralName : this.getPluralName(AW.getCurAW().getDefaultLanguage());
        return string;
    }

    public String getPluralName(String string) {
        String string2 = null;
        if (!(AW.getCurAW().getMetaDataFormat() > 10.1)) {
            throw new AWException("AW does not have multi-lingual support");
        }
        string2 = (String)this.m_pluralDescriptions.get(string);
        return string2;
    }

    public void setId(String string) {
        this.m_id = string;
    }

    public String getId() {
        if (this.m_id == null || this.m_id.indexOf("AW$DEFAULT") >= 0) {
            String string = this.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            string = string.toUpperCase();
            if (this.m_owner == null) {
                return this.m_name.toUpperCase() + "." + string.toUpperCase();
            }
            return this.m_owner.getParentId().toUpperCase() + "." + this.m_name.toUpperCase() + "." + string.toUpperCase();
        }
        return this.m_id.toUpperCase();
    }

    public String getParentId() {
        if (this.m_owner == null) {
            return this.m_name;
        }
        return this.m_owner.getParentId().toUpperCase() + "." + this.m_name.toUpperCase();
    }

    protected String getParentName() {
        try {
            String string = null;
            if (this.m_owner != null) {
                string = this.m_owner.getName();
            } else {
                String string2 = new String(this.m_id);
                int n = string2.lastIndexOf(".");
                string = (n = (string2 = string2.substring(0, n)).lastIndexOf(".") + 1) > 0 ? string2.substring(n) : string2;
            }
            return string;
        }
        catch (Exception exception) {
            System.out.println("Error returning Parent Name: " + exception.getMessage());
            return null;
        }
    }

    public String WriteToXML() {
        String string = null;
        return string;
    }

    protected String WriteContentsToXML() {
        String string = null;
        return string;
    }

    protected String WriteAttributesToXML() {
        String string = this.WriteAsAttribute("Name", this.m_name);
        string = string + this.WriteAsAttribute("LongName", this.m_longName);
        string = string + this.WriteAsAttribute("ShortName", this.m_shortName);
        string = string + this.WriteAsAttribute("PluralName", this.m_pluralName);
        string = string + this.WriteAsAttribute("Id", this.getId());
        if (this.m_schema != null) {
            string = string + this.WriteAsAttribute("Schema", this.m_schema);
        }
        return string;
    }

    protected String QuoteString(String string) {
        return '\"' + string + '\"';
    }

    protected String WriteAsAttribute(String string, String string2) {
        if (string2 != null) {
            String string3 = this.replaceInvalidXMLChars(string2);
            return " " + string + "=" + this.QuoteString(string3);
        }
        return " " + string + "=" + '\"' + '\"';
    }

    public String WriteElementStart(String string) {
        return s_StartStartTag + string + " ";
    }

    protected String WriteElementEndTag(String string) {
        return s_EndStartTag + string + s_EndEndTag;
    }

    protected static String TAB() {
        String string = "";
        for (int i = 0; i <= s_Indent; ++i) {
            string = string + "  ";
        }
        return string;
    }

    protected String WriteAsIDRef(String string, BaseObject baseObject) {
        return BaseObject.TAB() + "<" + string + " XMLIDref=" + this.QuoteString(baseObject.getId()) + " />" + s_NEWLINE;
    }

    protected String WriteAsIDRef(String string, String string2) {
        return BaseObject.TAB() + "<" + string + " XMLIDref=" + this.QuoteString(string2) + " />" + s_NEWLINE;
    }

    protected String WriteAsElement(String string, String string2) {
        return BaseObject.TAB() + "<" + string + ">" + string2 + "</" + string + ">" + s_NEWLINE;
    }

    public String toString() {
        return this.m_name;
    }

    public BaseObject getOwner() {
        return this.m_owner;
    }

    protected void setOwner(BaseObject baseObject) {
        String string;
        this.m_owner = baseObject instanceof AW ? null : baseObject;
        if (this.m_id != null && baseObject.getId() != null && this.m_id.indexOf(string = "." + this.getLogicalNamePart(baseObject.getId()) + ".") < 0) {
            this.m_id = null;
        }
    }

    public String Create(AWConnection aWConnection) {
        throw new AWFunctionNotSupported("Create not supported on this object");
    }

    public String CreateFirst(AWConnection aWConnection) {
        throw new AWFunctionNotSupported("Create First not supported on this object");
    }

    public String CreateAfter(AWConnection aWConnection, BaseObject baseObject) {
        throw new AWFunctionNotSupported("Create After not supported on this object");
    }

    public String CreateBefore(AWConnection aWConnection, BaseObject baseObject) {
        throw new AWFunctionNotSupported("Create Before not supported on this object");
    }

    public String Delete(AWConnection aWConnection) {
        throw new AWFunctionNotSupported("Delete not supported on this object");
    }

    protected String Rename(AWConnection aWConnection, String string) {
        throw new AWFunctionNotSupported("Rename not supported on this object");
    }

    protected String Copy(AWConnection aWConnection) {
        throw new AWFunctionNotSupported("Copy not supported on this object");
    }

    public String Alter(AWConnection aWConnection) {
        return "no op";
    }

    protected String quoteValue(String string) {
        if (string != null && string.indexOf("'") >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                String string2 = new Character(string.charAt(i)).toString();
                if (string2.equals("'")) {
                    stringBuffer.append("\\'");
                    continue;
                }
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        return "'" + string + "'";
    }

    protected String convertMultiLineString(Vector vector) {
        String string = null;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof BaseObject) {
                if (string == null) {
                    string = ((BaseObject)e).getId();
                    continue;
                }
                string = string + "\\n" + ((BaseObject)e).getId();
                continue;
            }
            if (string == null) {
                string = (String)e;
                continue;
            }
            string = string + "\\n" + (String)e;
        }
        if (string != null) {
            string = this.quoteValue(string);
        }
        return string;
    }

    protected String getLogicalNamePart(String string) {
        try {
            String string2 = null;
            int n = string.lastIndexOf(".");
            string = string.substring(0, n);
            string2 = string.substring(string.lastIndexOf(".") + 1);
            return string2;
        }
        catch (Exception exception) {
            System.out.println("Error returning Parent Name: " + exception.getMessage());
            return null;
        }
    }

    public String getNamePart(int n, String string) {
        try {
            String string2 = null;
            for (int i = 1; i < n; ++i) {
                int n2 = string.indexOf(".");
                string = string.substring(n2 + 1);
            }
            string2 = string.substring(0, string.indexOf("."));
            return string2;
        }
        catch (Exception exception) {
            System.out.println("Error returning Parent Name: " + exception.getMessage());
            return null;
        }
    }

    private boolean ObjectValid() throws ObjectNotValidException {
        return true;
    }

    protected String replaceInvalidXMLChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = new Character(string.charAt(i)).toString();
            if (string2.equals("&")) {
                stringBuffer.append("&amp;");
                continue;
            }
            if (string2.equals(">")) {
                stringBuffer.append("&gt;");
                continue;
            }
            if (string2.equals("<")) {
                stringBuffer.append("&lt;");
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void setPluralName(String string, String string2) {
        if (AW.getCurAW().getMetaDataFormat() <= 10.1) {
            throw new AWException("Current AW does not have multi-lingual support");
        }
        if (this.m_pluralDescriptions.containsKey(string)) {
            this.m_pluralDescriptions.remove(string);
        }
        this.m_pluralDescriptions.put(string, string2);
        this.m_pluralName = null;
        Enumeration enumeration = this.m_pluralDescriptions.keys();
        Enumeration enumeration2 = this.m_pluralDescriptions.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)enumeration2.nextElement();
            if (this.m_pluralName == null) {
                this.m_pluralName = string3 + "::" + string4;
                continue;
            }
            this.m_pluralName = this.m_pluralName + "::" + string3 + "::" + string4;
        }
    }

    public void setLongName(String string, String string2) {
        if (AW.getCurAW().getMetaDataFormat() <= 10.1) {
            throw new AWException("Current AW does not have multi-lingual support");
        }
        if (this.m_longDescriptions.containsKey(string)) {
            this.m_longDescriptions.remove(string);
        }
        this.m_longDescriptions.put(string, string2);
        this.m_longName = null;
        Enumeration enumeration = this.m_longDescriptions.keys();
        Enumeration enumeration2 = this.m_longDescriptions.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)enumeration2.nextElement();
            if (this.m_longName == null) {
                this.m_longName = string3 + "::" + string4;
                continue;
            }
            this.m_longName = this.m_longName + "::" + string3 + "::" + string4;
        }
    }

    public void setShortName(String string, String string2) {
        if (AW.getCurAW().getMetaDataFormat() <= 10.1) {
            throw new AWException("Current AW does not have multi-lingual support");
        }
        if (this.m_shortDescriptions.containsKey(string)) {
            this.m_shortDescriptions.remove(string);
        }
        this.m_shortDescriptions.put(string, string2);
        this.m_shortName = null;
        Enumeration enumeration = this.m_shortDescriptions.keys();
        Enumeration enumeration2 = this.m_shortDescriptions.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)enumeration2.nextElement();
            if (this.m_shortName == null) {
                this.m_shortName = string3 + "::" + string4;
                continue;
            }
            this.m_shortName = this.m_shortName + "::" + string3 + "::" + string4;
        }
    }
}

