/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import java.util.Vector;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.Attribute;
import oracle.AWXML.AttributeProjection;
import oracle.AWXML.AttributeSourceExpression;
import oracle.AWXML.BaseObject;
import oracle.AWXML.CubeMapGroup;
import oracle.AWXML.Dimension;
import oracle.AWXML.DimensionMapGroup;
import oracle.AWXML.Hierarchy;
import oracle.AWXML.HierarchyLevelAssociation;
import oracle.AWXML.Level;
import oracle.AWXML.MappingGroup;

public abstract class AWObject
extends BaseObject {
    protected Vector m_attributes = new Vector(0);
    protected Vector m_sourceMapGroup = new Vector(0);

    protected AWObject() {
    }

    public AWObject(BaseObject baseObject) {
        super(baseObject);
    }

    protected AWObject(String string, String string2) {
        super(string, string2);
    }

    public String WriteToXML() {
        String string = null;
        string = this.WriteElementStart("AWObject");
        string = string + this.WriteAttributesToXML();
        string = string + this.WriteContentsToXML();
        string = string + this.WriteElementEndTag("AWObject");
        return string;
    }

    protected String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        return string;
    }

    protected String WriteContentsToXML() {
        BaseObject baseObject;
        String string = super.WriteContentsToXML();
        Iterator iterator = this.m_attributes.iterator();
        while (iterator.hasNext()) {
            baseObject = (Attribute)iterator.next();
            if (string == null) {
                string = ((Attribute)baseObject).WriteToXML();
                continue;
            }
            string = string + ((Attribute)baseObject).WriteToXML();
        }
        if (this.m_sourceMapGroup.size() > 0) {
            string = string == null ? AWObject.TAB() + this.WriteElementStart("SourceMappingGroup") + s_EndTag + s_NEWLINE : string + AWObject.TAB() + this.WriteElementStart("SourceMappingGroup") + s_EndTag + s_NEWLINE;
            ++s_Indent;
            iterator = this.m_sourceMapGroup.iterator();
            while (iterator.hasNext()) {
                baseObject = (MappingGroup)iterator.next();
                if (string == null) {
                    string = ((MappingGroup)baseObject).WriteToXML();
                    continue;
                }
                string = string + ((MappingGroup)baseObject).WriteToXML();
            }
            --s_Indent;
            string = string + AWObject.TAB() + this.WriteElementEndTag("SourceMappingGroup") + s_NEWLINE;
        }
        return string;
    }

    public void addAttribute(Attribute attribute) {
        this.m_attributes.add(attribute);
        attribute.setOwner(this);
    }

    public void removeAttribute(Attribute attribute) {
        Vector<AttributeSourceExpression> vector = new Vector<AttributeSourceExpression>(0);
        Iterator iterator = this.m_sourceMapGroup.iterator();
        while (iterator.hasNext()) {
            AttributeSourceExpression attributeSourceExpression;
            DimensionMapGroup dimensionMapGroup = (DimensionMapGroup)iterator.next();
            Iterator iterator2 = dimensionMapGroup.getAttributeMaps().iterator();
            while (iterator2.hasNext()) {
                attributeSourceExpression = (AttributeSourceExpression)iterator2.next();
                if (attributeSourceExpression.getTargetObject() != attribute) continue;
                vector.add(attributeSourceExpression);
            }
            iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                attributeSourceExpression = (AttributeSourceExpression)iterator2.next();
                dimensionMapGroup.removeAttributeMap(attributeSourceExpression);
            }
        }
        this.m_attributes.remove(attribute);
        ((Dimension)this).removeAttributeReferences(attribute);
    }

    public void addAttributeProjection(AttributeProjection attributeProjection) {
        this.m_attributes.add(attributeProjection);
        attributeProjection.setOwner(this);
    }

    public void removeAttributeProjection(AttributeProjection attributeProjection) {
        Vector<AttributeSourceExpression> vector = new Vector<AttributeSourceExpression>(0);
        Iterator iterator = this.m_sourceMapGroup.iterator();
        while (iterator.hasNext()) {
            AttributeSourceExpression attributeSourceExpression;
            DimensionMapGroup dimensionMapGroup = (DimensionMapGroup)iterator.next();
            Iterator iterator2 = dimensionMapGroup.getAttributeMaps().iterator();
            while (iterator2.hasNext()) {
                attributeSourceExpression = (AttributeSourceExpression)iterator2.next();
                if (attributeSourceExpression.getTargetObject() != attributeProjection) continue;
                vector.add(attributeSourceExpression);
            }
            iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                attributeSourceExpression = (AttributeSourceExpression)iterator2.next();
                dimensionMapGroup.removeAttributeMap(attributeSourceExpression);
            }
        }
        this.m_attributes.remove(attributeProjection);
    }

    public void removeAttributeProjection(Attribute attribute) {
        AttributeProjection attributeProjection = null;
        Iterator iterator = this.m_attributes.iterator();
        while (iterator.hasNext()) {
            AttributeProjection attributeProjection2;
            Attribute attribute2 = (Attribute)iterator.next();
            if (!(attribute2 instanceof AttributeProjection) || (attributeProjection2 = (AttributeProjection)attribute2).getAttribute() != attribute) continue;
            attributeProjection = attributeProjection2;
            break;
        }
        if (attributeProjection != null) {
            this.removeAttributeProjection(attributeProjection);
        }
    }

    protected void addAttributeProjection(Attribute attribute, AWConnection aWConnection) {
        boolean bl = false;
        Object object = this.m_attributes.iterator();
        while (object.hasNext()) {
            AttributeProjection attributeProjection;
            Attribute attribute2 = (Attribute)object.next();
            if (!(attribute2 instanceof AttributeProjection) || (attributeProjection = (AttributeProjection)attribute2).getAttribute() != attribute) continue;
            bl = true;
            break;
        }
        if (!bl) {
            object = this.createAttributeProjection();
            ((AttributeProjection)object).setAttribute(attribute);
            if (aWConnection != null) {
                ((AttributeProjection)object).Create(aWConnection);
            }
        }
    }

    public Vector getAttributes() {
        return this.m_attributes;
    }

    public void addSourceMappingGroup(MappingGroup mappingGroup) {
        this.m_sourceMapGroup.add(mappingGroup);
        mappingGroup.setOwner(this);
    }

    public void removeSourceMappingGroup(MappingGroup mappingGroup) {
        this.m_sourceMapGroup.remove(mappingGroup);
    }

    public void addSourceDimensionMapGroup(DimensionMapGroup dimensionMapGroup) {
        this.m_sourceMapGroup.add(dimensionMapGroup);
        dimensionMapGroup.setOwner(this);
    }

    public void addSourceCubeMapGroup(CubeMapGroup cubeMapGroup) {
        this.m_sourceMapGroup.add(cubeMapGroup);
        cubeMapGroup.setOwner(this);
    }

    public Vector getSourceMapGroup() {
        return this.m_sourceMapGroup;
    }

    public Attribute createAttribute() {
        Attribute attribute = null;
        if (!(this instanceof Dimension)) {
            throw new AWException("AWXML-ERR-NUM-900007", new Object[]{this.getId()});
        }
        attribute = new Attribute(this);
        this.addAttribute(attribute);
        attribute.setOwner(this);
        return attribute;
    }

    public AttributeProjection createAttributeProjection() {
        AttributeProjection attributeProjection = new AttributeProjection(this);
        this.addAttribute(attributeProjection);
        attributeProjection.setOwner(this);
        if (this instanceof HierarchyLevelAssociation) {
            attributeProjection.setHierarchy((Hierarchy)this.getOwner());
            attributeProjection.setLevel(((HierarchyLevelAssociation)this).getLevel());
        }
        if (this instanceof Hierarchy) {
            attributeProjection.setHierarchy((Hierarchy)this);
        }
        if (this instanceof Level) {
            attributeProjection.setLevel((Level)this);
        }
        return attributeProjection;
    }

    public DimensionMapGroup createSourceDimensionMapGroup() {
        DimensionMapGroup dimensionMapGroup = new DimensionMapGroup(this);
        this.addSourceMappingGroup(dimensionMapGroup);
        dimensionMapGroup.setName("MAPGROUP" + this.m_sourceMapGroup.size());
        if (this instanceof Dimension) {
            dimensionMapGroup.setType("DIMENSION");
        }
        if (this instanceof Level) {
            dimensionMapGroup.setType("LEVEL");
        }
        if (this instanceof Hierarchy) {
            dimensionMapGroup.setType("HIERARCHY");
        }
        if (this instanceof HierarchyLevelAssociation) {
            dimensionMapGroup.setType("HIERARCHYLEVEL");
        }
        return dimensionMapGroup;
    }

    public CubeMapGroup createSourceCubeMapGroup() {
        CubeMapGroup cubeMapGroup = new CubeMapGroup(this);
        this.addSourceMappingGroup(cubeMapGroup);
        cubeMapGroup.setName("MAPGROUP" + this.m_sourceMapGroup.size());
        return cubeMapGroup;
    }

    protected CubeMapGroup findCubeMapGroup(String string) {
        CubeMapGroup cubeMapGroup = null;
        Iterator iterator = this.m_sourceMapGroup.iterator();
        while (iterator.hasNext()) {
            MappingGroup mappingGroup = (MappingGroup)iterator.next();
            if (!mappingGroup.getName().equals(string) || !(mappingGroup instanceof CubeMapGroup)) continue;
            cubeMapGroup = (CubeMapGroup)mappingGroup;
            break;
        }
        return cubeMapGroup;
    }

    protected DimensionMapGroup findDimensionMapGroup(String string) {
        DimensionMapGroup dimensionMapGroup = null;
        Iterator iterator = this.m_sourceMapGroup.iterator();
        while (iterator.hasNext()) {
            MappingGroup mappingGroup = (MappingGroup)iterator.next();
            if (!mappingGroup.getName().equals(string) || !(mappingGroup instanceof DimensionMapGroup)) continue;
            dimensionMapGroup = (DimensionMapGroup)mappingGroup;
            break;
        }
        return dimensionMapGroup;
    }

    protected Attribute findAttribute(String string) {
        Attribute attribute = null;
        Iterator iterator = this.m_attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute2 = (Attribute)iterator.next();
            if (!attribute2.getName().equals(string)) continue;
            attribute = attribute2;
            break;
        }
        return attribute;
    }
}

